
#macro m(vec)
	(vec * <1,1,-1>)
#end


// start,end,radius,strength,scale
#macro scyl(st,en,r,s,sc)
	cylinder{st/sc,en/sc,r,s scale sc}
#end
// center,radius,strength,scale
#macro ssph(cen,r,s,sc)
	sphere{cen/sc,r,s scale sc}
#end

#macro figure(pat)
#local hl=<0,0,-1.75>;
#local hr=m(hl);
#local kl=<-6,3.5,-3>;
#local kr=m(kl);
#local al=<-13,0,-3.5>;
#local ar=m(al);
#local fl=<-15,2,-4>;
#local fr=m(fl);
#local hp=<1.5,0.5,0>;
#local brc=<5,2.5,0>;
#local trc=<7.5,4.5,0>;
#local tr=(trc+brc*2)/3+<0,1.55,-1.5>;
#local tl=m(tr);
#local head=<9,8.5,0>;

#local shl=<8,5.25,-3.5>;
#local shr=m(shl);
#local elbl=<4,4.5,-5.5>;
#local elbr=<5,4.5,7>;
#local wrl=<0,4.5,-3.5>;
#local wrr=<2,4.5,3.5>;
#local handl=<-1,4.5,-3>;
#local handr=<1,4.5,3>;
union
{
blob
{
	threshold 0.5
// right leg
	cylinder {hr,kr,1.7,1}
	ssph((hr*2+kr)/3,4,0.5,<1.25,1.25,1>)
	cylinder {kr,ar,1.2,1}
	ssph((kr*2+ar)/3,3,0.5,<1.25,1.25,1>)
	scyl (ar,fr,1.2,1, <1.5,0.75,1>)
// left leg
	cylinder {hl,kl,1.7,1}
	ssph((hl*2+kl)/3,4,0.5,<1.25,1.25,1>)
	cylinder {kl,al,1.2,1}
	ssph((kl*2+al)/3,3,0.5,<1.25,1.25,1>)
	scyl (al,fl,1.2,1, <1.5,0.75,1>)
// torso
	ssph(hp,4.5,1, <0.7,1,1.25>)
	ssph((brc*3+trc)/4,4.5,-0.25, <0.7,1,1>)
	scyl(brc,trc,5,1,<1,0.75,1.25>)

	ssph(tr,1.75,0.9,<1,0.8,1>)
	ssph(tl,1.75,0.9,<1,0.8,1>)

	cylinder{shl,shr,1,1}
	sphere{trc,2.5,-0.15}
	sphere{brc,4,0.1}
	ssph((brc+hp)/2,4.5,-0.35,<1,1.8,0.9>)

// head neck
	ssph(head,2,3,<1.25,1.25,1>)
	scyl(head,trc,1,1,<1,1,1>)

// left arm
	cylinder{shl,elbl,1.2,1}
	scyl(shl*.75+elbl*.25,shl*.25+elbl*.75,2,0.25,<1.25,1.25,0.5>)
	cylinder{elbl,wrl,0.8,1}
	sphere{elbl,1,-0.5}
	ssph(elbl*0.7+0.3*wrl,3,0.45,<1,1,0.6>)
	scyl(wrl,(handl+wrl)/2,1,1,<1,1.2,1.6>)

// right arm
	cylinder{shr,elbr,1.2,1}
	scyl(shr*.75+elbr*.25,shr*.25+elbr*.75,2,0.25,<1.25,1.25,0.5>)
	cylinder{elbr,wrr,0.8,1}
	sphere{elbr,1,-0.5}
	ssph(elbr*0.7+0.3*wrr,3,0.45,<1,1,0.6>)
	scyl(wrr,(handr+wrr)/2,1,1,<1,0.8,1.6>)
	
#if (detail <1)
	sturm on
#end
	normal {bozo scale 0.1}
//	texture {pigment {Cyan}}
	pigment {Cyan}
	texture
	{
		pigment
		{
			function {clip(f_r(x-9,y-8.5,z)/8,0,1)}
			color_map
			{
				[0.0 Flesh]
				[0.25 Flesh]
				[0.25 Gray50]
				[0.4 Gray50]
				[0.4 White]
				[0.5 White]
				[0.5 Magenta]
				[0.86 Magenta]
				[0.86 White]
				[0.88 White]
				[0.88 Black]
				[0.98 Black]
				[0.98 White]
				[1.0 White]
				[1.0 rgbf 1]
			}
		}
	}
	texture
	{
		pigment
		{
			function {clip(f_r(x+6,y-3.5,0)/4,0,1)}
			color_map
			{
				[0.0 Gray50]
				[0.4 Gray50]
				[0.4 White]
				[0.5 White]
				[0.5 Magenta]
				[0.86 Magenta]
				[0.86 White]
				[0.88 White]
				[0.88 Black]
				[0.98 Black]
				[0.98 White]
				[1.0 White]
				[1.0 rgbf 1]
			}
		}
	}
	texture
	{
		pigment
		{
			function {clip(f_r(x+16,(y-1)*4,0)/20,0,1)}
			color_map
			{
				[0.0 Gray20]
				[0.35 Gray20]
				[0.35 rgbf 1]
				[0.92 rgbf 1]
				[0.92 White]
				[0.935 White]
				[0.935 Black]
				[0.985 Black]
				[0.985 White]
				[1.0 White]
				[1.0 rgbf 1]
			}
		}
	}
}
	intersection
	{
		sphere{0,2.2 scale <1.2,1.2,1> translate head-<0.5,0,0>}
		box {head-<3,1.8,3>, head+<3,3,3> }
		pigment
		{
			crackle scale 0.1
			color_map
			{
				[0.0 color rgb <0.8,0.2,0.6>]
				[0.5 color rgb <0.8,0.2,0.6>]
				[0.5 color White]
			}
		}
		finish {phong 0.5 phong_size 100}
//		cutaway_textures
	}
	intersection
	{
		sphere{0,2.3 scale <1.2,1.2,1> translate head-<0.5,0.0>}
		sphere{0,1 scale <2.5,1.5,2.5> rotate <0,0,20> translate head-<1.5,0,0> }
		pigment {Gray20}
		finish { reflection 0.5 ambient 0 diffuse 0.5 }
//		cutaway_textures
	}

}
#end
