
#macro fore_roof(h,lg)
#declare r1=3;
#declare r2=0.15;
union
{
	cylinder {<0,h,0> <0,h+0.15,0> r1}
	cylinder {<0,0,0>, <0,h,0>, r2}
	cone {<0,h-0.5,0> r2 <0,h,0> r1}
#declare i=0;
#while(i<360)
	cone {<0,h-0.45,0>,r2 <r1,h,0> 0 rotate <0,i,0>}
#declare i=i+30;
#end
#if(lg=0)
	object{light scale <0.15,0.15,0.1> translate <0,2.5,-0.2>}
#else
	object{rope(<0,2.4,-0.05>,<-0.01,2.3,-0.25>,-0.1,0.0075) pigment {Red}}
	object{rope(<0.005,2.399,-0.05>,<0.005,2.25,-0.27>,-0.1,0.0075) pigment {Black}}
	object{rope(<0.0025,2.401,-0.05>,<0.02,2.32,-0.23>,-0.1,0.0075) pigment {Green}}
#end
	object{light scale <0.15,0.15,0.1> translate <0,2.5,-0.2> rotate <0,180,0>}
	pigment
	{
		object
		{
			object{baselight scale <0.15,0.15,0.1> translate <0,2.5,-0.2>}
			pigment
			{
				function{clip((f_bozo(x*20,y*5,z*20)-0.5)+((y/(y+1)))/0.8,0,1)}
				color_map
				{
					[0.0 rgb <0.3,0.325,0.25>]
					[0.25 rgb <0.5,0.55,0.4>]
					[1.0 Gray80]
				}
			}
			pigment {Gray90}
		}
	}
}
#end

#declare forecourt_t=
texture
{
	pigment
	{
		function{f_bozo(x/(1+30*f_bozo(x,y,z)),0,z/(1+30*f_bozo(x,y,z)))}
		color_map
		{
			[0.0 rgb <0.9,0.9,0.8>]
			[0.15 rgb <0.9,0.9,0.8>]
			[0.2 rgb <0.8,0.8,0.7>]
			[0.75 rgb <0.7,0.7,0.6>]
			[0.8 rgb <0.2,0.2,0.2>]
			[1.0 rgb <0.1,0.1,0.1>]
		}
	}
	normal{bumps scale 0.05}
}

#declare forecourt_t2=
texture
{
	pigment
	{
		bozo scale 0.5
		color_map
		{
			[0.0 rgbft <0.3,0.5,0,0.2,0.2>]
			[0.5 rgbf 0.8]
			[1.0 rgbf 1]
		}
	}
	normal{bumps scale 0.05}
}



#declare forecourt_cracks=
union
{

	object {crack(8,0.05,0.00,0.1, 0.25,4,0, 0.032,20,0.1, 1.5,1) translate <-5,0.2,7>}
	object {crack(8,0.05,0.00,0.1, 0.26,3,0, 0.024,32,0.1, 1.5,2) rotate<0,100,0> translate <-5,0.2,7>}
	object {crack(8,0.05,0.00,0.1, 0.15,4,0, 0.02,25,0.1, 1.5,3) rotate<0,160,0> translate <-5,0.2,7>}
	object {crack(8,0.05,0.00,0.1, 0.37,3,0, 0.025,30,0.1, 1.5,4) rotate<0,220,0> translate <-5,0.2,7>}

	object {crack(3,0.05,0.00,0.1, 0.25,4,0, 0.032,20,0.1, 1.5,1) rotate <0,20,0>translate <-5,0.2,7>}
	object {crack(3,0.05,0.00,0.1, 0.37,3,0, 0.025,30,0.1, 1.5,4) rotate<0,290,0> translate <-5,0.2,7>}

	object {crack(8,0.05,0.00,0.1, 0.25,4,0, 0.042,20,0.1, 1.5,1) rotate <0,28,0>translate <5,0.2,6>}
	object {crack(8,0.05,0.00,0.1, 0.26,3,0, 0.024,32,0.1, 1.5,2) rotate<0,71,0> translate <5,0.2,6>}
	object {crack(8,0.05,0.00,0.1, 0.15,4,0, 0.02,25,0.1, 1.5,3) rotate<0,171,0> translate <5,0.2,6>}
	object {crack(8,0.05,0.00,0.1, 0.37,3,0, 0.025,30,0.1, 1.5,4) rotate<0,282,0> translate <5,0.2,6>}

	object {crack(3,0.05,0.00,0.1, 0.25,4,0, 0.022,20,0.1, 1.5,1) rotate <0,58,0>translate <5,0.2,6>}
	object {crack(2,0.05,0.00,0.1, 0.26,3,0, 0.024,32,0.1, 1.5,2) rotate<0,101,0> translate <5,0.2,6>}
	object {crack(3,0.05,0.00,0.1, 0.15,4,0, 0.02,25,0.1, 1.5,3) rotate<0,131,0> translate <5,0.2,6>}

	object {crack(3,0.05,0.00,0.1, 0.25,4,0, 0.032,20,0.1, 1.5,1) rotate <0,17,0>translate <-5,0.2,2.8>}
	object {crack(7,0.05,0.00,0.1, 0.26,3,0, 0.024,32,0.1, 1.5,2) rotate<0,-12,0> translate <-4.1,0.2,2.8>}
	object {crack(3,0.05,0.00,0.1, 0.15,4,0, 0.02,25,0.1, 1.5,3) rotate<0,3,0> translate <-3.3,0.2,2.8>}
	object {crack(1,0.05,0.00,0.1, 0.37,3,0, 0.035,30,0.1, 1.5,4) rotate<0,-5,0> translate <-2.8,0.2,2.8>}
	object {crack(5,0.05,0.00,0.1, 0.26,3,0, 0.024,32,0.1, 1.5,2) rotate<0,10,0> translate <-1,0.2,2.8>}
	object {crack(3,0.05,0.00,0.1, 0.15,4,0, 0.03,25,0.1, 1.5,3) rotate<0,-30,0> translate <1,0.2,2.8>}
	texture{forecourt_t}
}

#declare forecourt_grass=
union
{
#local rand4=seed(614);
#local i=0;
#while(i<60)
#local vec=<-15,0.28,2.8+rand(rand4)*10>;
#while (vec.y>0)
#local vec=trace(forecourt_cracks,vec,<1,0,0>);
#if(vec.y>0)
#if(rand(rand4)>0.6)
	object{grass(30+60*rand(rand4),50*rand(rand4)) scale (rand(rand4)*0.15+0.05) translate vec}
#local vec=vec+<1,0,0>;
#else
#local vec=vec+<0.1,0,0>;
#end
#end
#end
#local i=i+1;
#end
}

#declare forecourt_base =
difference
{
	box
	{
		<-15,0,2.8> <15,0.28,14>
		texture{forecourt_t}
		texture{forecourt_t2}
	}
	object{forecourt_cracks}
}

#declare fir_p=
pigment
{
	bozo scale 0.4
	color_map
	{
		[0.0 Gray40]
		[0.3 Gray70]
		[1.0 rgb <0.5,0.3,0.0>]
	}
}

#declare rat=
union
{
	sphere_sweep
	{
		cubic_spline,
		9,
		<0,0.1,0> 0.1,
		<-1,0.1,0> 0.1,
		<-1.33,0.083,0> 0.083,
		<-1.66,0.066,-0.25> 0.066,
		<-2,0.05,0> 0.05,
		<-2.33,0.033,0.4> 0.033,
		<-2.66,0.016,0> 0.016,
		<-3,0.00,-0.2> 0.0,
		<-3.3,0.00,0.0> 0.0
		pigment {rgb <1,0.6,0.5>}
	}
	sphere{	0,1.0}
	cone{<1.5,0,0> 0, <0.5,0,0> 0.875}
	union
	{
		sphere{<0.78,0.4,-0.47> 0.0825}
		sphere{<0.78,0.4,0.47> 0.0825 }
		pigment{Black}
		finish
		{
			phong 1
			phong_size 100
			reflection{1}
		}
	}
	pigment	{fir_p}
	normal {granite 2 scale 0.1}
	scale <1.5,1,1>
}

#declare rrnd=seed(102.4);

//#declare randx=function(e) {30*rand(rrnd)-15}
//#declare randz=function(e) {11.2*rand(rrnd)+2.8}
//#declare randa=function(e) {360*rand(rrnd)}

#declare rubbish=
union
{
#local i=0;
#while (i<5)
object{can1(0) rotate <0,360*rand(rrnd),0> translate <30*rand(rrnd)-15,0.28,11.2*rand(rrnd)+2.8>}
object{can2(0) rotate <0,360*rand(rrnd),0> translate <30*rand(rrnd)-15,0.28,11.2*rand(rrnd)+2.8>}
object{cup_side(0) rotate <0,360*rand(rrnd),0> translate <30*rand(rrnd)-15,0.28,11.2*rand(rrnd)+2.8>}
#local i=i+1;
#end
object{cup(0) rotate <0,360*rand(rrnd),0> translate <30*rand(rrnd)-15,0.28,11.2*rand(rrnd)+2.8>}
#local i=0;
#while (i<25)
object{ rat scale 0.1 rotate <0,360*rand(rrnd),0> translate <30*rand(rrnd)-15,0.28,9*rand(rrnd)+4.8>}
#local i=i+1;
#end
}

#declare pump_base=
union
{
	union
	{
		cylinder{<-2.5,0,6> <-2.5,0.39,6> 0.5}
		cylinder{<2.5,0,6> <2.5,0.39,6> 0.5}
		box{<-2.5,0,5.5> <2.5,0.39,6.5>}
		pigment {Gray50}
	}
#local klen=0.09;
#local i=0;
#while (i<180)
	object{kerb(klen) translate <-klen/2,0,-0.5> rotate<0,i,0> translate <-2.5,0.3,6>}
	object{kerb(klen) translate <-klen/2,0,-0.5> rotate<0,-i,0> translate <2.5,0.3,6>}
#local i=i+12;
#end
	object{kerb_run(-2.5,2.5,klen,0.01,5) translate<klen/2,0.3,5.5>}
	object{kerb_run(-2.5,2.5,klen,0.01,5) rotate <0,180,0> translate<klen/2,0.3,6.5>}
}

#declare forecourt=
union
{
	object {pump2 rotate <0,180,0> translate <0.5,0.28,6>}
	object {pump1 rotate <0,0,0> translate <-0.5,0.28,6>}
	object {forecourt_base}
	object {forecourt_grass}
	object {rubbish}
	object {pump_base}
	object {fore_roof(4,1) translate <-2.5,0,6>}
	object {rposter(0.6001,10) scale <0.25,0.25,0.25>translate <-2.5,1.5,6>}
	object {fore_roof(4.65,0) translate <2.5,0,6>}
}
