
// c == curl (-2 = ~180, +2 = ~30 deg)
#macro gr_blade(r,c,pat)
difference
{
	sphere
	{
		0, r
		scale <0.2,1,1.01>
		pigment
		{
			function{clip(f_r(x,y,z+r)/(f_bozo(1,2,pat)*0.8+1.4),0,1)}
			color_map
			{
				[0.0 Green]
				[1.0 (Green+Brown*2)/3]
			}
		}
		normal {bozo scale <0.01,0.2,0.2>}
	}
	sphere {<0,c/100,0.02> r scale <2,1,1> pigment {rgb <0.1,0.7,0>}}
	bounded_by {box{<-0.1,0,-r*1.01> <0.1,r*1.01,r*1.01> }}
	clipped_by { bounded_by }
	translate <0,0,r>
}
#end

#declare num_blades=256;
#declare blade_array=array[num_blades];

#local i=0;
#while (i<num_blades)
#declare blade_array[i]=
	gr_blade(f_bozo(0,0,i)+0.5,f_bozo(0,2,i)*4-2,31)
#local i=i+1;
#end

#declare grand=seed(612371);
#macro grass(blades,pat)
#if(detail=0)
union
{
#local i = 0 ;
#while (i<360 )
//	object {gr_blade(f_bozo(0,0,i)+0.5,f_bozo(0,2,i)*4-2,pat) rotate<0,40*f_bozo(9,i,0)-20,0> translate<0,-f_bozo(0,i,-3)/5,f_bozo(0,i,2)/5> rotate <0,i+f_bozo(0,12,i)*7,0>}
	object {blade_array[rand(grand)*num_blades] rotate<0,40*f_bozo(9,i,0)-20,0> translate<0,-f_bozo(0,i,-3)/5,f_bozo(0,i,2)/5> rotate <0,i+f_bozo(0,12,i)*7,0>}
#local i=i+(360/blades);
#end
//	bounded_by{sphere{0,2}}
	translate <0,f_bozo(i,pat,2)*(-0.1)-0.3,0>
}
#else
union
{
	sphere{0,1 pigment {rgbf <0,1,0,0.7>}}
	cylinder{0,<0,1.5,0> 0.02 pigment {White}}
}
#end
#end

//#object{gr_blade(1,-1)}

