
#declare paving =
object{ superellipsoid { <0.2, 0.01> scale <0.24,0.02,0.24>}}
//object{	box {<-0.24,-0.02,-0.24>, <0.24,0.02,0.24>}}

#declare h_func =
function{(f_bozo(x/2,y/2,z)-0.5)/15}


#declare pavement_bound =
union
{
	intersection
	{
		box{<-20,0,0.86> <20,0.35,3>}
		union
		{
			cylinder{<5,0,2.8> <5,0.351,2.8> 1.94}
			cylinder{<11,0,2.8> <11,0.351,2.8> 1.94}
			cylinder{<-5,0,2.8> <-5,0.351,2.8> 1.94}
			cylinder{<-11,0,2.8> <-11,0.351,2.8> 1.94}
		}
	}
	box{<-20,0,0.86> <-11,0.35,3>}
	box{<-5,0,0.86> <5,0.35,3>}
	box{<11,0,0.86> <20,0.35,3>}
}

#declare slabs =
union
{
#declare j1=0.125;
#declare i=-20;
#while(i<20)
#declare j=0.9;
#while(j<3.1)
	object {paving 
		rotate<
			atan2d(h_func(i,j-0.25,0.0)-h_func(i,j+0.25,0.0),0.5)+(f_bozo(i*2,j*2,1)-0.5)*5,
			(f_bozo(i*2,j*2,8)-0.5)*10,
			atan2d(h_func(i+0.25,j,0.0)-h_func(i-0.25,j,0.0),0.5)+(f_bozo(i*2,j*2,4)-0.5)*5
			>
		translate <i,h_func(i,j,0)+0.29,j+j1>
		texture{
			pigment
			{
				bozo scale 0.01
				color_map
				{
					[0.2 rgb (f_bozo(i,j,1)*0.2+0.0)]
					[0.2 rgb (f_bozo(i,j,2)*0.6+0.1)]
					[0.8 rgb (f_bozo(i,j,3)*0.6+0.3)]
					[0.8 rgb <(f_bozo(i,j,5)*0.1+0.9),(f_bozo(i,j,0)*0.1+0.8),(f_bozo(i,j,0)*0.1+0.7)>]
				}
			}
			normal {granite 0.2 scale 0.01}
		}
		texture
		{
			pigment
			{
				bozo scale 0.5
				color_map
				{
					[0.0 rgbft <0.3,0.5,0,0.2,0.2>]
					[0.5 rgbf 0.8]
					[1.0 rgbf 1]
				}
			}
			normal {granite 0.2 scale 0.01}
		}
	
		}
#declare j=j+0.5;
#end
#declare j1=0-j1;
#declare i=i+0.5;
#end
	object{pavement_bound pigment {rgb <0.5,0.4,0.3>} translate <0,-0.075,0>}
}

#declare kerb_stones =
union
{
	kerb_run(-20,-11,1,0.01,5)
	kerb_run(-5,5,1,0.01,5)
	kerb_run(11,20,1,0.01,5)

	union
	{
		kerb_run(-20,-11,10,0,0)
		kerb_run(-5,5,11,0,0)
		kerb_run(11,20,11,0,0)
		translate<0,-0.02,0.01>
	}
	translate <0,0.2,0.8>
}

#declare grass_cracks=
union
{
#declare j1=0.125;
#declare i=-25;
#while(i<25)
#declare j=0.9;
#while(j<3.1)
#declare i2=i-0.25;
#declare j2=j+j1-0.25;
#declare i2a=i2+f_granite(i2*10,j2*10,0)*0.5;
#declare j2a=j2+f_granite(i2*10,j2*10,2)*0.5;
#if(f_granite(i2a,4,j2a)>0.4)
#declare vec=trace(pavement_bound,<i2,2,j2a>,<0,-1,0>);
#if(vec.y>0)
	object{grass(f_bozo(i2a,j2a,1)*100,i2) translate <0,-0.35,0>scale 0.15*f_bozo(i2a,j2a,20) translate vec}
//#debug concat(str(vec.x,5,4)," ",str(vec.y,5,4)," ",str(vec.z,5,4),"\n")
#end
#end
#if(f_granite(i2a,40,j2a)>0.4)
#declare vec=trace(pavement_bound,<i2a,2,j2>,<0,-1,0>);
#if(vec.y>0)
	object{grass(f_bozo(i2a,j2a,1)*100,i2) translate <0,-0.35,0> scale 0.15*f_bozo(i2a,j2a,10) translate vec}
//#debug concat(str(vec.x,5,4)," ",str(vec.y,5,4)," ",str(vec.z,5,4),"\n")
#end
#end
#declare j=j+0.5;
#end
#declare j1=0-j1;
#declare i=i+0.5;
#end

}


#declare pavement=
union
{
	difference
	{
		object {ramp translate <-8,0,1.8> }
		object {crack(10,0.01,0.02,0.5, 0.25,10,0.05, 0.1,80,0.0, 4.45,3) translate <-7.5,0,-1>}
		object {crack(10,0.02,0.01,0.5, 0.25,10,0.05, 0.1,60,0.0, 4.44,2) rotate<0,10,0> translate <-8.5,0,-1>}
		cutaway_textures
	}
	object {ramp translate <8,0,1.8> }

	union
	{
		object {bollard_complete rotate <0,0,2 >translate <-9.5,0.3,3.1>}
		object {bollard_broken(0.5,1) translate  <-6.5,0.3,3.1>}
		object {bollard_broken(0.4,2) translate <-4.2,0.3,3.1>}
		object {bollard_complete rotate <-5,0,1> translate <-1.8,0.3,3.1>}
		object {bollard_complete rotate <1,0,-1> translate <0,0.3,3.1>}
		object {bollard_broken(0.4,4) rotate <0,0,2>  translate <1.8,0.3,3.1>}
		object {bollard_complete rotate <-3,0,-2> translate <4.2,0.3,3.1>}
		object {bollard_broken(0.2,3) rotate <10,0,0> translate <6.5,0.3,3.1>}
		object {bollard_complete rotate <-1,0,-3> translate <9.5,0.3,3.1>}
	}
 	intersection
	{
		union
		{
			difference
			{
				object {rkerb(2) translate <-5,0.2,2.8>}
				object{crack(1,0.005,0.0075,0.4 ,0.2,21,0 ,0.05,100,0 ,4.71,99) rotate <0,30,0>translate <-6.75,0,0.9>}
				object{crack(1,0.005,0.0075,0.4 ,0.21,18,0 ,0.05,100,0 ,7.72,102) rotate <0,80,0>translate <-7.25,0.1,1.75>}
				cutaway_textures
			}
			object {rkerb(2) translate <-11,0.2,2.8>}
		}
		box { <-5,0,0.7> <-11,0.4,2.8> pigment {Gray50}}
	}
	intersection
	{
		union
		{
			object {rkerb(2) translate <5,0.2,2.8>}
			object {rkerb(2) translate <11,0.2,2.8>}
		}
		box { <5,0,0.7> <11,0.4,2.8> pigment {Gray50}}
	}
	intersection
	{
		object{slabs}
		object{pavement_bound pigment {Gray60}}
	}
	object{kerb_stones}
	object{grass_cracks}
}

