
#declare f_poster =
function{clip(f_bozo(x*4,y,z*4)+f_bozo(x*40,y*10,z*40)*0.2+(y+0.5)/2,0,1)}

#declare f_pattern=
function
{
	clip(
	(f_bozo(x*30,y*7,z*29)-0.5)*3+
	abs(sin(((x+z)+f_bozo(x*4,y*4,2)*2)*4))*clip(sin(y*8+0.25),0,1)
	,0,1)
}

#macro p_poster(pat)
pigment
{
	function{f_poster(x,y,pat)}
	pigment_map
	{
		[0.0 color rgbf 1]
		[0.25 White]
		[0.75 White]
		[0.80 function{f_pattern(x,y,z)} color_map{[0.5 Green][0.5 Blue]}]
	}
}
#end

#macro n_poster(pat)
normal
{
	function{f_poster(x,y,pat)}
	normal_map
	{
		[0.0 bumps 0.0 scale 0.025]
		[0.25 bumps 0.1 scale 0.025]
		[0.75 bumps 0.1 scale 0.025]
		[0.80 function{ clip((f_bozo(x*4,y*4,z*4+pat)-0.66)/2,0,1) }]
	}
}
#end

#macro poster(pat)
box
{
	<-2,-2.5,0> <2,2.5,0.1>
	texture
	{
		p_poster(pat)
		n_poster(pat)
	}
}
#end

#macro rposter(r1,pat)
cylinder
{
	<0,-2.5,0> <0,2.5,0> r1
	texture
	{
		p_poster(pat)
		n_poster(pat)
	}
}
#end

#declare pposter=
union
{
	difference
	{
		box	{<-2,-2.5,0> <2,2.5,0.1>}
		box {-0.5,0.5 rotate <0,0,30> translate <-2,2.7,0>}
		box {<-3,-0.5,-0.5> <3,00,0.5> rotate <0,0,3> translate <0,-2.4,0>}
	}

	difference
	{
		difference
		{
			cylinder{ <-0.5,0,0>, <0.5,0,0> 0.301}
			cylinder{ <-0.5,0,0>, <0.5,0,0> 0.300}
			box{<-1.5,0,-0.8><2.5,-0.4,0.8>}
			translate <0,-0.5,0>rotate <0,0,30> translate <-2,2.7,-0.3>
		}
		box{<-2,0,-1><-1,2,1> rotate <-30,0,0> translate <0,2.5,0>}
		box{<-1,2,-1> <0,3,1> rotate <0,-30,0> translate <-2,0,0>}
	}

	difference
	{
		cone { <0,-2.5,0> 0.001 <3.875,-2.5,0> 0.0637*2}
		cone { <0,-2.5,0> 0.0 <4.01,-2.5,0> 0.0636*2}
		box {<-0.01,-2.5,-0.2> <4.02,-2.3,0.2>}
//		pigment {rgbf 0.7}
		rotate<0,1.825,2.975>
		translate<-2,0,0>
	}

	pigment
	{
		object
		{
			Povray_Logo_Prism scale 2
			pigment
			{
				White
			}
			pigment
			{
				crackle scale 0.05
				color_map
				{
					[0.15 White]
					[0.15 Blue]
				}
			}
		}
	}
	normal{function{ clip((f_bozo(x*3,y*3,z*3)-0.66)/1.5,0,1) } }
}

