
#declare nht1=
texture
{
	pigment {Gray20}
	finish
	{
		phong 0.9
		phong_size 80
	}
}

#declare nht2=
texture
{
	pigment {Gray50}
	normal {bumps scale 0.01}
}

#declare nt1=
texture
{
	pigment {Gray80}
	normal{bumps 0.1 scale 0.01}
}

#declare nt2=
texture
{
	pigment {Gray80}
	finish
	{
		reflection {0.5}
	}
	normal{function{f_bozo(x*20,y*20,z*20)}}
}

#declare pt1=
texture
{
	pigment
	{
		bozo scale 0.05
		color_map
		{
			[0.0 Gray20]
			[0.7 Gray30]
			[1.0 Gray50]
		}
	}
	finish
	{
		reflection {0.2}
		phong 0.2
		phong_size 60
	}
	normal{bumps 0.1 scale 0.01}
}

#declare nozzle=
union
{
	union
	{
		difference
		{
			torus{1,0.2}
			box{<-1.2,-0.2,-1.2> <0,.2,1.2>}
			box{<0,-0.2,-1.2> <1.2,0.2,1.2>rotate <0,30,0>}
		}
		difference
		{
			cylinder{<1,0,1> <0,0,1> 0.2 rotate <0,30,0> }
			cylinder{<1.25,0,1> <0,0,1> 0.15 rotate <0,30,0> }
		}
		torus{0.175 0.025 rotate <0,0,90> translate <1,0,1> rotate <0,30,0> }
		cylinder{<-2.75,0,1> <0,0,1> 0.2}


		union
		{
			cylinder{0,<-0.45,0,0> 0.05}
			sphere {<-0.45,0,0> 0.05}
			cylinder{<-0.45,0,0> <-0.75,0,0.1> 0.05}
			sphere {<-0.75,0,0.1> 0.05}
			scale <1,2,1>
			rotate <0,-40,0>
			translate <-1.25,0,0.8>
		}
		torus{0.5,0.05 scale <1.25,2,1> translate <-1.75,0,0.7>}
		texture
		{
			function{f_bozo(x*20,y*20,z*20)}
			texture_map
			{
				[0.25 nt2]
				[0.25 nt1]
			}
		}
	}
	union
	{
		cone{<-0.8,0,1> 0 <-0.9,0,1> 0.5}
		cylinder{<-1,0,1> <-0.9,0,1> 0.5}
		torus{0.5,0.05 rotate <0,0,90> translate <-0.95,0,1>}

#declare i=0;
#while(i<360)
		sphere{0,0.3 scale <1.5,0.5,1> rotate<i+20,0,0> translate <-2.25,0,1> }
		sphere{0,0.3 scale <1.5,0.5,1> rotate<i,0,0> translate <-2,0,1> }
		sphere{0,0.3 scale <1.5,0.5,1> rotate<i+10,0,0> translate <-1.75,0,1> }
		sphere{0,0.3 scale <1.5,0.5,1> rotate<i+20,0,0>translate <-1.5,0,1> }
		sphere{0,0.3 scale <1.5,0.5,1> rotate<i,0,0>translate <-1.25,0,1> }
#declare i=i+30;
#end
		texture
		{
			bozo scale 0.3
			texture_map
			{
				[0.0 nht1]
				[1.0 nht2]
			}
		}
	}
	translate <2.75,0,-1>
}


#declare prnd=seed(47.1);

#declare h=2;
#declare rc=0.5;
#declare th=0.1;
#declare ang=20;

	//bent panel
#declare panel1=
union
{
	difference
	{
		cylinder {<0,0,0> <0,h,0> rc}
		cylinder {<0,-0.01,0> <0,h+.01,0> rc-th}
		box{<-1.01,-0.01,-1.01> <0,h+.01,1.01>}
		box{<0,-0.01,-1.01> <1.01,h+01,1.01>rotate <0,ang,0>}
	}
	
	box{ <0,0,rc-th> <2,h,rc> rotate <0,ang,0>}
	box{ <0,0,rc-th> <-2,h,rc> rotate <0,0,0>}
	rotate<0,0,20>
}

#declare rp=0.2;
#declare px=1;
#declare py=1;
#declare pd=1;

	// hole in panel
#declare panel2=
union
{
	cylinder{<rp,rp,0> <rp,rp,pd> rp }
	cylinder{<px-rp,rp,0> <px-rp,rp,pd> rp }
	cylinder{<rp,py-rp,0> <rp,py-rp,pd> rp }
	cylinder{<px-rp,py-rp,0> <px-rp,py-rp,pd> rp }
	box{<0,rp,0> <px,py-rp,pd>}
	box{<rp,0,0> <px-rp,py,pd>}
	translate <-px/2,-py/2,-pd/2>
	scale 1.2 translate <-0.4,0.8,0>
}

#declare bent_panel=
intersection
{
	object{panel1}
	object{panel2}
}

#declare pump_nh=
difference
{
	superellipsoid { <.25, .25>  scale <0.5,0.25,1> }
	superellipsoid { <0.25,0.25> scale <0.2,0.2,0.8> translate <0,0.1,0>}
	superellipsoid { <0.25,0.25> scale <0.33,0.2,0.4> translate <0,0.1,-0.3>}
	pigment
	{
		bozo scale 0.2
		pigment_map
		{
			[0.0 Gray80]
			[0.5 Gray70]
			[1.0 Gray40]
		}
	}
}

#declare display_shape=
merge
{
#local dsh = array [5]
{ <0.05,0.05>, <0.05,0.2>, <0.55,0.2>,<0.55,0.05>,<0.05,0.05> }
	object{rounded_prism(dsh,5,0.03,0.8)}
	box{<0.05,0.05,0><0.55,0.2,0.8>}
}

#declare display=
intersection
{
	union
	{
		intersection
		{
			difference
			{
				box{<0,0,0.01><0.6,0.25,0.015>}
				object{window_break(7,rand(prnd)) scale 0.15 translate <0.6*rand(prnd),0.2*rand(prnd),0.01>}
			}
			pigment {rgbf 0.8}
			interior {ior 1.3 fade_distance 1.0 fade_power 2}
			normal{ bozo 0.3 scale 0.1}
			photons
			{
				target
				reflection on
				refraction on
		    }
		}
		intersection
		{
			box{<0,0,0.05><0.6,0.25,0.1>}
			pigment
			{
				function{clip(clip(sin(x*5.5),0,1)*abs(sin(y*32-0.5))-f_bozo(x*100,y*10,0)*1.4,0,1)}
				color_map
				{
					[0.1 Black]
					[0.1 White]
				}
			}
		}
		intersection
		{
			box{<0,0,0.1><0.6,0.25,0.2>}
			pigment {Gray80}
		}
	}
	object{display_shape pigment {Gray80}}
}

#declare pump_basic =
union
{
#local pp = array [6]
{ <0,0>, <0.8,0>, <0.8,0.8>, <0.4,1.2>,  <0,1.2>, <0,0> }

#local rp = 0.05;
#local dp = 0.4;

	object{rounded_prism(pp,6,rp,dp)}

#local pdp = array [5]
{ <0,0>, <0,0.25>, <0.6,0.25>,<0.6,0>,<0,0> }

	difference
	{
		object{rounded_prism(pdp,5,rp,dp) translate <0,1.75,0>}
		object{display_shape translate<0,1.75,-0.2>}
	}
	object{display translate<0,1.75,-0.05>}

	object{display rotate <0,180,0> translate<0.6,1.75,0.45>}

	superellipsoid { <0.2, 0.2> scale <0.05,0.6,0.1> translate <0.1,1.2,0.2> pigment {Gray50}}

	superellipsoid { <0.2, 0.2> scale 0.5 scale <0.6,0.3,0.3> translate <0.4,-0.15,0.2> pigment {Gray50}}
	object{pump_nh scale <0.2,0.2,0.275> rotate <0,-90,-45> translate <0.65,1.05,dp/2> }
	translate <0,0.3,-dp/2>
	scale <1,0.8,1>
}	

#declare roller=
difference
{
	cylinder {<0,0,-0.048> <0,0,0.048> 0.05}
	torus{0.05,0.03 scale <1,1.2,1>rotate <90,0,0>}
}

#declare pump=
union
{
	difference
	{
		object{pump_basic}
		object{panel2 scale 0.5 rotate <0,180,0> translate <0.15,0.25,0.3>}
		box{<-0.5,-0.10,-0.05> <0.5,0.1,0.05> pigment {Gray50} translate <1,0.5,0>}
	}
	object{roller translate <0.81,0.55,0> pigment{ Gray50}}
	object{roller translate <0.81,0.45,0> pigment{ Gray50}}
	object{bent_panel scale 0.49 rotate <0,180,1>translate <0.15,0.25,0.44>}
	pigment
	{
		function{clip(f_bozo(x*10,y*3,z*10)*f_bozo(x*30,y*30,z*30)*2-(y/(y+1)),0,1)}
		color_map
		{
			[0.0 Gray90]
			[0.5 Gray80]
			[1.0 Gray30]
		}
	}
	normal {function{clip(f_bozo(x*10,y*10,z*10),0.1,0.4)/2+f_bozo(x*10,y*10,z*10)/10}}
}

#declare pump2=
union
{
	object{pump}
	sphere_sweep
	{
		cubic_spline,8
		<0.40,0.5,0>,0.025,
		<0.60,0.5,0>,0.025,
		<0.8,0.5,0>,0.025,
		<1.3,0.2,0>,0.025,
		<1.6,0.15,0>,0.025,
		<1.8,0.15,0.3>,0.025
		<1.8,0.1,0.6>,0.025
		<1.8,0.1,1>,0.025
		texture{pt1}
	}
	object {nozzle rotate <-25,-90,-20> scale 0.165 translate <1.8,0.1,0.6>}
	rotate <0,180,0>
}

#declare pump1=
union
{
	object{pump}
	sphere_sweep
	{
		cubic_spline,9
		<0.40,0.5,0>,0.025,
		<0.60,0.5,0>,0.025,
		<0.8,0.5,0>,0.025,
		<1.1,0.25,-0.40>,0.025,
		<1.2,0.1,-1>,0.025,
		<1.6,0.1,-1>,0.025,
		<1.6,0.15,0.3>,0.025
		<1.6,0.1,0.6>,0.025
		<1.6,0.1,1>,0.025
		texture{pt1}
	}
	object {nozzle rotate <-25,-90,-20> scale 0.165 translate <1.6,0.1,0.6>}
	rotate <0,180,0>
}

