// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions

// several different gold colors, finishes and textures
#include "golds.inc"
#include "metals.inc"
#include "woods.inc"
#include "tarot\cardfan.inc"
#include "crystalballstand\tabletop.inc"
#include "crystalball\crystalball.inc"
#include "pearlstand\pearl-stand.inc"
#include "zodiac\zodiac.inc"       
        
#include "mountain\mountain.inc"

#include "chair\chair.inc" 
#include "cjrh-chair\cjrh-chair.inc"
#include "stonewall\stonewall.inc"
#include "dreamcatcher\dreamcatcher.inc"
        
#declare galaxy_seed = 503; // 24,28,29
#declare debug_options = true;
#include "GALAXY.INC"        

        
// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 3               // higher -> higher quality (1..10) [5]
    error_bound 0.2               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.2            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1.2                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}
         
camera {
  location  <5.0, 20.0, -53.0> 
  //location  <-28.0, 25.0, 28.0>
  //location  <65.0, 70.0, -75.0>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
  angle 70
}
/*             
light_source {
  0*x                  
  color rgb <1,1,0>    
  translate <0, 16, 0>
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 20
  fade_power 5
} 
*/     

/*
light_source {
  0*x                  
  color rgb <1.0,1.0,1.0>    
  translate <120, 70, -120>
} 
*/

/*
light_source {
  0*x                  
  color rgb <1.0,1.0,1.0>    
  translate <300, 300, 300> 
} 
*/ 

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x                 // light's position (translated below)
  color rgb <0.9,0.9,1.5>       // light's color
/*  area_light
  <80, 0, 0> <0, 0, 80> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
*/  translate <300, 280, 300>   // <x y z> position of light
}

  
object { cballstand }
object { CrystalBall(8) translate 6*y }
object { pearlstand scale <7,6,7> }
object { CardFan(21, 360, 23) }
          
#declare x1 = -9;
#declare z1 = 9;
#declare y1 = 1;        
#declare numzsigns = 12;
#declare zsigns = array[numzsigns] {
    aries,      
    taurus,     
    gemini,      
    cancer,      
    leo,        
    virgo,      
    libra,       
    scorpio,     
    sagittarius,
    capricorn,  
    aquarius,    
    pisces };      


union{
  #local Nr = 0;     // start
  #local EndNr = 11; // end
  #while (Nr< EndNr) 
    object { zsigns[Nr] scale 5 translate <x1,y1,z1> rotate<0,Nr * 360/EndNr,0>} 
    #local Nr = Nr + 1;    // next Nr
  #end // ---------------  end of loop 
} // end of union
        

/*      
box { 
  <-300,-100,-300>
  <300,300,300>
  texture { 
    pigment { color rgb <0.8,0.8,1.0> }
      
  }
  hollow
}      
*/    
#declare plainwall = 
difference {
  box { 
    <0,0,0>
    <300,300,20>
    texture { 
      pigment { color rgb <0.8,0.8,1.0> }
        
    }
    hollow    
  }      
  
  box { 
    <50,86,-10>
    <150,150,30>
    texture { 
      pigment { color rgb <0.8,0.8,1.0> }
        
    }
    hollow
  }
  translate -10*z
}
     
#declare wallcorner = 
union {                     
  object {
    plainwall  
    rotate 45*y
    translate -86*y
    translate 100*z
  }                     
  object {
    plainwall  
    rotate 135*y
    translate -86*y
    translate 100*z
  }                     
}
    
// corner in view    
/*
object {
  wallcorner
}                
*/
/*
// corner behind camera
object { 
  wallcorner 
  rotate 180*y 
}  
*/
// floor
box { 
  <-150,-1,-150>
  <150,0,150>
  texture { 
    pigment { color rgb <0.8,0.8,1.0> }
      
  }              
  rotate 45*y
  translate -86*y
}      
  
// ceiling  
box { 
  <-150,-1,-150>
  <150,0,150>
  texture { 
    pigment { color rgb <0.8,0.8,1.0> }
      
  }              
  rotate 45*y
  translate (300-86)*y
}      
/*
object {
  mountain 
  scale <50,40,50>
  rotate -10*x
  translate -120*y
  translate 50*z
}   
*/
object {
  mountain 
  scale <50,40,50>
  //rotate -10*x
  translate -120*y
  translate 50*z
}   
/*
// Create an infinite sphere around scene and allow any pigment on it
sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}
*/
// atmospheric media can be generated by adding a media statement
// to the scene not attached to any specific object

// create a box that extends between the 2 specified points
box {
  <-150, -86, -150>  // one corner position <X1 Y1 Z1>
  < 150,  300-86,  150>  // other corner position <X2 Y2 Z2>
  hollow
  pigment { color rgbf <1,1,1,1> }
  rotate 45*y
  interior {
    media {    // atmospheric media sample
      intervals 10
      //emission 0.002   
      scattering { 4, rgb 0.006 extinction 0.1 }
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      ratio 0.9
    }
  }  
  no_shadow
  scale 1
}


/*                                   
// A chair    
#declare chair =                               
object { 
  WindsorChair 
  rotate 140*y 
  scale 1.5
  translate <20,-36,-15>
}

object { chair }
object { chair rotate 40*y }
object { chair rotate 80*y }
*/

#declare chair =                                       
object { 
  cjrhchair
  rotate 90*y 
  translate <30,-62,0>
}  
#declare chairrotextra = 3;
object { chair rotate chairrotextra*y }
object { chair rotate (chairrotextra+90)*y }
object { chair rotate (chairrotextra+180)*y }
object { chair rotate (chairrotextra+270)*y }

// Wall

/*    
#macro wallOfBricksWindow(wallWidth,         wallWidthRes,     wallSpaceWidth, 
                          wallHeight,        wallHeightRes,    wallSpaceHeight,
                          wallThickness,     wallThicknessRes, wallSpaceThickness,
                          windowWidthStart,  windowWidthEnd,
                          windowHeightStart, windowHeightEnd)
*/
    
object {
  wallOfBricksWindow(300, 8, 0.0, 
                     300, 8, 0.0, 
                     60,  2, 0.0, 
                     1, 2, 
                     2, 3)
  rotate 45*y
  translate 100*z  
  translate -86*y 
  translate 10*y                  
}   

object {
  wallOfBricksWindow(300, 8, 0.0, 
                     300, 8, 0.0, 
                     60,  2, 0.0, 
                     1, 2, 
                     2, 3)
  translate -30*z                   
  rotate 135*y
  translate 100*z
  translate -86*y  
  translate 10*y                   
} 

// Dreamcatchers

object { dreamcatcher scale 5 translate <15,0,-15> rotate 0*y }
object { dreamcatcher scale 5 translate <15,2,-15> rotate 90*y }
object { dreamcatcher scale 5 translate <15,4,-15> rotate 180*y }
object { dreamcatcher scale 5 rotate 45*y translate <15,5,-15> rotate 270*y }
