// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions

// Layer 1  
#declare legs =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.138, 0.808> <0.000, 0.097, 0.808> <0.000, 0.041, 0.808> <0.000, 0.000, 0.808> 
		<-1.332, 0.138, 0.808> <-1.332, 0.097, 0.808> <-1.329, 0.041, 0.808> <-1.329, 0.000, 0.808> 
		<-0.647, 0.185, 0.400> <-0.647, 0.125, 0.400> <-0.647, 0.060, 0.399> <-0.647, 0.000, 0.399> 
		<-0.647, 0.200, 0.000> <-0.647, 0.140, 0.000> <-0.647, 0.060, 0.000> <-0.647, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.138, 0.808> <0.000, 0.138, 0.808> <0.000, 0.138, 0.808> <0.000, 0.138, 0.808> 
		<1.332, 0.138, 0.808> <0.000, 0.138, 0.808> <0.000, 0.138, 0.808> <-1.332, 0.138, 0.808> 
		<0.647, 0.185, 0.400> <0.259, 0.185, 0.400> <-0.259, 0.185, 0.400> <-0.647, 0.185, 0.400> 
		<0.647, 0.200, 0.000> <0.259, 0.200, 0.000> <-0.259, 0.200, 0.000> <-0.647, 0.200, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.138, 0.808> <1.332, 0.138, 0.808> <0.647, 0.185, 0.400> <0.647, 0.200, 0.000> 
		<0.000, 0.097, 0.808> <1.332, 0.097, 0.808> <0.647, 0.125, 0.400> <0.647, 0.140, 0.000> 
		<0.000, 0.041, 0.808> <1.329, 0.041, 0.808> <0.647, 0.060, 0.399> <0.647, 0.060, 0.000> 
		<0.000, 0.000, 0.808> <1.329, 0.000, 0.808> <0.647, 0.000, 0.399> <0.647, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.200, -0.808> <0.000, 0.200, -0.808> <0.000, 0.200, -0.808> <0.000, 0.200, -0.808> 
		<-0.620, 0.200, -0.808> <0.000, 0.200, -0.808> <0.000, 0.200, -0.808> <0.620, 0.200, -0.808> 
		<-0.647, 0.215, -0.399> <-0.259, 0.215, -0.399> <0.259, 0.215, -0.399> <0.647, 0.215, -0.399> 
		<-0.647, 0.200, 0.000> <-0.259, 0.200, 0.000> <0.259, 0.200, 0.000> <0.647, 0.200, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.200, -0.808> <0.000, 0.140, -0.808> <0.000, 0.060, -0.808> <0.000, 0.000, -0.808> 
		<0.620, 0.200, -0.808> <0.620, 0.140, -0.808> <0.620, 0.060, -0.808> <0.620, 0.000, -0.808> 
		<0.647, 0.215, -0.399> <0.647, 0.155, -0.399> <0.647, 0.060, -0.399> <0.647, 0.000, -0.399> 
		<0.647, 0.200, 0.000> <0.647, 0.140, 0.000> <0.647, 0.060, 0.000> <0.647, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.200, -0.808> <-0.620, 0.200, -0.808> <-0.647, 0.215, -0.399> <-0.647, 0.200, 0.000> 
		<0.000, 0.140, -0.808> <-0.620, 0.140, -0.808> <-0.647, 0.155, -0.399> <-0.647, 0.140, 0.000> 
		<0.000, 0.060, -0.808> <-0.620, 0.060, -0.808> <-0.647, 0.060, -0.399> <-0.647, 0.060, 0.000> 
		<0.000, 0.000, -0.808> <-0.620, 0.000, -0.808> <-0.647, 0.000, -0.399> <-0.647, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, 0.808> <0.000, 0.000, 0.808> <0.000, 0.000, 0.808> <0.000, 0.000, 0.808> 
		<-1.329, 0.000, 0.808> <0.000, 0.000, 0.808> <0.000, 0.000, 0.808> <1.329, 0.000, 0.808> 
		<-0.647, 0.000, 0.399> <-0.259, 0.000, 0.399> <0.259, 0.000, 0.399> <0.647, 0.000, 0.399> 
		<-0.647, 0.000, 0.000> <-0.259, 0.000, 0.000> <0.259, 0.000, 0.000> <0.647, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, -0.808> <0.000, 0.000, -0.808> <0.000, 0.000, -0.808> <0.000, 0.000, -0.808> 
		<0.620, 0.000, -0.808> <0.000, 0.000, -0.808> <0.000, 0.000, -0.808> <-0.620, 0.000, -0.808> 
		<0.647, 0.000, -0.399> <0.259, 0.000, -0.399> <-0.259, 0.000, -0.399> <-0.647, 0.000, -0.399> 
		<0.647, 0.000, 0.000> <0.259, 0.000, 0.000> <-0.259, 0.000, 0.000> <-0.647, 0.000, 0.000> 
	}
}
// Layer 2   
#declare seat =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, -1.800, 0.550> <0.658, -1.800, 0.537> <0.650, -1.800, 0.518> <0.641, -1.800, 0.509> 
		<0.667, -1.785, 0.550> <0.667, -1.785, 0.537> <0.656, -1.785, 0.512> <0.647, -1.785, 0.503> 
		<0.687, -1.767, 0.550> <0.687, -1.767, 0.530> <0.676, -1.767, 0.503> <0.661, -1.767, 0.489> 
		<0.687, -1.750, 0.550> <0.687, -1.750, 0.530> <0.676, -1.750, 0.503> <0.661, -1.750, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, -1.800, 0.550> <0.667, -1.785, 0.550> <0.687, -1.767, 0.550> <0.687, -1.750, 0.550> 
		<0.658, -1.800, 0.563> <0.667, -1.785, 0.563> <0.687, -1.767, 0.570> <0.687, -1.750, 0.570> 
		<0.650, -1.800, 0.582> <0.656, -1.785, 0.588> <0.676, -1.767, 0.597> <0.676, -1.750, 0.597> 
		<0.641, -1.800, 0.591> <0.647, -1.785, 0.597> <0.661, -1.767, 0.611> <0.661, -1.750, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.687, -1.750, 0.550> <0.687, -1.750, 0.530> <0.676, -1.750, 0.503> <0.661, -1.750, 0.489> 
		<0.687, -1.704, 0.550> <0.687, -1.704, 0.530> <0.676, -1.704, 0.503> <0.661, -1.704, 0.489> 
		<0.658, -1.646, 0.550> <0.658, -1.646, 0.537> <0.650, -1.646, 0.518> <0.641, -1.646, 0.509> 
		<0.658, -1.600, 0.550> <0.658, -1.600, 0.537> <0.650, -1.600, 0.518> <0.641, -1.600, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.687, -1.750, 0.550> <0.687, -1.704, 0.550> <0.658, -1.646, 0.550> <0.658, -1.600, 0.550> 
		<0.687, -1.750, 0.570> <0.687, -1.704, 0.570> <0.658, -1.646, 0.563> <0.658, -1.600, 0.563> 
		<0.676, -1.750, 0.597> <0.676, -1.704, 0.597> <0.650, -1.646, 0.582> <0.650, -1.600, 0.582> 
		<0.661, -1.750, 0.611> <0.661, -1.704, 0.611> <0.641, -1.646, 0.591> <0.641, -1.600, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, -1.600, 0.550> <0.658, -1.600, 0.537> <0.650, -1.600, 0.518> <0.641, -1.600, 0.509> 
		<0.658, -1.569, 0.550> <0.658, -1.569, 0.537> <0.650, -1.569, 0.518> <0.641, -1.569, 0.509> 
		<0.685, -1.531, 0.550> <0.685, -1.531, 0.530> <0.674, -1.531, 0.504> <0.660, -1.531, 0.490> 
		<0.687, -1.500, 0.550> <0.687, -1.500, 0.530> <0.676, -1.500, 0.503> <0.661, -1.500, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, -1.600, 0.550> <0.658, -1.569, 0.550> <0.685, -1.531, 0.550> <0.687, -1.500, 0.550> 
		<0.658, -1.600, 0.563> <0.658, -1.569, 0.563> <0.685, -1.531, 0.570> <0.687, -1.500, 0.570> 
		<0.650, -1.600, 0.582> <0.650, -1.569, 0.582> <0.674, -1.531, 0.596> <0.676, -1.500, 0.597> 
		<0.641, -1.600, 0.591> <0.641, -1.569, 0.591> <0.660, -1.531, 0.610> <0.661, -1.500, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.687, -1.500, 0.550> <0.687, -1.500, 0.530> <0.676, -1.500, 0.503> <0.661, -1.500, 0.489> 
		<0.702, -1.260, 0.550> <0.702, -1.260, 0.530> <0.686, -1.260, 0.492> <0.672, -1.260, 0.478> 
		<0.723, -0.940, 0.550> <0.723, -0.940, 0.523> <0.706, -0.940, 0.482> <0.687, -0.940, 0.463> 
		<0.716, -0.700, 0.550> <0.716, -0.700, 0.523> <0.701, -0.700, 0.487> <0.682, -0.700, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.687, -1.500, 0.550> <0.702, -1.260, 0.550> <0.723, -0.940, 0.550> <0.716, -0.700, 0.550> 
		<0.687, -1.500, 0.570> <0.702, -1.260, 0.570> <0.723, -0.940, 0.577> <0.716, -0.700, 0.577> 
		<0.676, -1.500, 0.597> <0.686, -1.260, 0.608> <0.706, -0.940, 0.618> <0.701, -0.700, 0.613> 
		<0.661, -1.500, 0.611> <0.672, -1.260, 0.622> <0.687, -0.940, 0.637> <0.682, -0.700, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.716, -0.700, 0.550> <0.716, -0.700, 0.523> <0.701, -0.700, 0.487> <0.682, -0.700, 0.468> 
		<0.714, -0.638, 0.550> <0.714, -0.638, 0.523> <0.699, -0.638, 0.488> <0.681, -0.638, 0.469> 
		<0.664, -0.562, 0.550> <0.664, -0.562, 0.537> <0.655, -0.562, 0.514> <0.645, -0.562, 0.505> 
		<0.658, -0.500, 0.550> <0.658, -0.500, 0.537> <0.650, -0.500, 0.518> <0.641, -0.500, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.716, -0.700, 0.550> <0.714, -0.638, 0.550> <0.664, -0.562, 0.550> <0.658, -0.500, 0.550> 
		<0.716, -0.700, 0.577> <0.714, -0.638, 0.577> <0.664, -0.562, 0.563> <0.658, -0.500, 0.563> 
		<0.701, -0.700, 0.613> <0.699, -0.638, 0.612> <0.655, -0.562, 0.586> <0.650, -0.500, 0.582> 
		<0.682, -0.700, 0.632> <0.681, -0.638, 0.631> <0.645, -0.562, 0.595> <0.641, -0.500, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, -0.500, 0.550> <0.658, -0.500, 0.537> <0.650, -0.500, 0.518> <0.641, -0.500, 0.509> 
		<0.655, -0.469, 0.550> <0.655, -0.469, 0.537> <0.648, -0.469, 0.521> <0.639, -0.469, 0.511> 
		<0.682, -0.431, 0.550> <0.682, -0.431, 0.530> <0.672, -0.431, 0.506> <0.658, -0.431, 0.492> 
		<0.687, -0.400, 0.550> <0.687, -0.400, 0.530> <0.676, -0.400, 0.503> <0.661, -0.400, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, -0.500, 0.550> <0.655, -0.469, 0.550> <0.682, -0.431, 0.550> <0.687, -0.400, 0.550> 
		<0.658, -0.500, 0.563> <0.655, -0.469, 0.563> <0.682, -0.431, 0.570> <0.687, -0.400, 0.570> 
		<0.650, -0.500, 0.582> <0.648, -0.469, 0.579> <0.672, -0.431, 0.594> <0.676, -0.400, 0.597> 
		<0.641, -0.500, 0.591> <0.639, -0.469, 0.589> <0.658, -0.431, 0.608> <0.661, -0.400, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.687, -0.400, 0.550> <0.687, -0.400, 0.530> <0.676, -0.400, 0.503> <0.661, -0.400, 0.489> 
		<0.700, -0.311, 0.550> <0.700, -0.311, 0.530> <0.685, -0.311, 0.494> <0.671, -0.311, 0.479> 
		<0.722, -0.190, 0.550> <0.722, -0.190, 0.523> <0.705, -0.190, 0.482> <0.687, -0.190, 0.463> 
		<0.716, -0.100, 0.550> <0.716, -0.100, 0.523> <0.701, -0.100, 0.487> <0.682, -0.100, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.687, -0.400, 0.550> <0.700, -0.311, 0.550> <0.722, -0.190, 0.550> <0.716, -0.100, 0.550> 
		<0.687, -0.400, 0.570> <0.700, -0.311, 0.570> <0.722, -0.190, 0.577> <0.716, -0.100, 0.577> 
		<0.676, -0.400, 0.597> <0.685, -0.311, 0.606> <0.705, -0.190, 0.618> <0.701, -0.100, 0.613> 
		<0.661, -0.400, 0.611> <0.671, -0.311, 0.621> <0.687, -0.190, 0.637> <0.682, -0.100, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, 0.000, 0.550> <0.675, -0.030, 0.550> <0.713, -0.065, 0.550> <0.716, -0.100, 0.550> 
		<0.658, 0.000, 0.537> <0.675, -0.030, 0.537> <0.713, -0.065, 0.523> <0.716, -0.100, 0.523> 
		<0.650, 0.000, 0.518> <0.663, -0.030, 0.506> <0.699, -0.065, 0.489> <0.701, -0.100, 0.487> 
		<0.641, 0.000, 0.509> <0.653, -0.030, 0.497> <0.680, -0.065, 0.470> <0.682, -0.100, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, 0.000, 0.550> <0.658, 0.000, 0.563> <0.650, 0.000, 0.582> <0.641, 0.000, 0.591> 
		<0.675, -0.030, 0.550> <0.675, -0.030, 0.563> <0.663, -0.030, 0.594> <0.653, -0.030, 0.603> 
		<0.713, -0.065, 0.550> <0.713, -0.065, 0.577> <0.699, -0.065, 0.611> <0.680, -0.065, 0.630> 
		<0.716, -0.100, 0.550> <0.716, -0.100, 0.577> <0.701, -0.100, 0.613> <0.682, -0.100, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.641, 0.000, 0.591> <0.632, 0.000, 0.600> <0.613, 0.000, 0.608> <0.600, 0.000, 0.608> 
		<0.653, -0.030, 0.603> <0.644, -0.030, 0.613> <0.613, -0.030, 0.625> <0.600, -0.030, 0.625> 
		<0.680, -0.065, 0.630> <0.661, -0.065, 0.649> <0.627, -0.065, 0.663> <0.600, -0.065, 0.663> 
		<0.682, -0.100, 0.632> <0.663, -0.100, 0.651> <0.627, -0.100, 0.666> <0.600, -0.100, 0.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.000, 0.608> <0.587, 0.000, 0.608> <0.568, 0.000, 0.600> <0.559, 0.000, 0.591> 
		<0.600, -0.030, 0.625> <0.587, -0.030, 0.625> <0.556, -0.030, 0.613> <0.547, -0.030, 0.603> 
		<0.600, -0.065, 0.663> <0.573, -0.065, 0.663> <0.539, -0.065, 0.649> <0.520, -0.065, 0.630> 
		<0.600, -0.100, 0.666> <0.573, -0.100, 0.666> <0.537, -0.100, 0.651> <0.518, -0.100, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.559, 0.000, 0.591> <0.550, 0.000, 0.582> <0.542, 0.000, 0.563> <0.542, 0.000, 0.550> 
		<0.547, -0.030, 0.603> <0.537, -0.030, 0.594> <0.525, -0.030, 0.563> <0.525, -0.030, 0.550> 
		<0.520, -0.065, 0.630> <0.501, -0.065, 0.611> <0.487, -0.065, 0.577> <0.487, -0.065, 0.550> 
		<0.518, -0.100, 0.632> <0.499, -0.100, 0.613> <0.484, -0.100, 0.577> <0.484, -0.100, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.542, 0.000, 0.550> <0.542, 0.000, 0.537> <0.550, 0.000, 0.518> <0.559, 0.000, 0.509> 
		<0.525, -0.030, 0.550> <0.525, -0.030, 0.537> <0.537, -0.030, 0.506> <0.547, -0.030, 0.497> 
		<0.487, -0.065, 0.550> <0.487, -0.065, 0.523> <0.501, -0.065, 0.489> <0.520, -0.065, 0.470> 
		<0.484, -0.100, 0.550> <0.484, -0.100, 0.523> <0.499, -0.100, 0.487> <0.518, -0.100, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.559, 0.000, 0.509> <0.568, 0.000, 0.500> <0.587, 0.000, 0.492> <0.600, 0.000, 0.492> 
		<0.547, -0.030, 0.497> <0.556, -0.030, 0.487> <0.587, -0.030, 0.475> <0.600, -0.030, 0.475> 
		<0.520, -0.065, 0.470> <0.539, -0.065, 0.451> <0.573, -0.065, 0.437> <0.600, -0.065, 0.437> 
		<0.518, -0.100, 0.468> <0.537, -0.100, 0.449> <0.573, -0.100, 0.434> <0.600, -0.100, 0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.000, 0.492> <0.613, 0.000, 0.492> <0.632, 0.000, 0.500> <0.641, 0.000, 0.509> 
		<0.600, -0.030, 0.475> <0.613, -0.030, 0.475> <0.644, -0.030, 0.487> <0.653, -0.030, 0.497> 
		<0.600, -0.065, 0.437> <0.627, -0.065, 0.437> <0.661, -0.065, 0.451> <0.680, -0.065, 0.470> 
		<0.600, -0.100, 0.434> <0.627, -0.100, 0.434> <0.663, -0.100, 0.449> <0.682, -0.100, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.682, -0.100, 0.632> <0.663, -0.100, 0.651> <0.627, -0.100, 0.666> <0.600, -0.100, 0.666> 
		<0.687, -0.190, 0.637> <0.668, -0.190, 0.655> <0.627, -0.190, 0.672> <0.600, -0.190, 0.672> 
		<0.671, -0.311, 0.621> <0.656, -0.311, 0.635> <0.620, -0.311, 0.650> <0.600, -0.311, 0.650> 
		<0.661, -0.400, 0.611> <0.647, -0.400, 0.626> <0.620, -0.400, 0.637> <0.600, -0.400, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.100, 0.666> <0.573, -0.100, 0.666> <0.537, -0.100, 0.651> <0.518, -0.100, 0.632> 
		<0.600, -0.190, 0.672> <0.573, -0.190, 0.672> <0.532, -0.190, 0.655> <0.513, -0.190, 0.637> 
		<0.600, -0.311, 0.650> <0.580, -0.311, 0.650> <0.544, -0.311, 0.635> <0.529, -0.311, 0.621> 
		<0.600, -0.400, 0.637> <0.580, -0.400, 0.637> <0.553, -0.400, 0.626> <0.539, -0.400, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.518, -0.100, 0.632> <0.499, -0.100, 0.613> <0.484, -0.100, 0.577> <0.484, -0.100, 0.550> 
		<0.513, -0.190, 0.637> <0.495, -0.190, 0.618> <0.478, -0.190, 0.577> <0.478, -0.190, 0.550> 
		<0.529, -0.311, 0.621> <0.515, -0.311, 0.606> <0.500, -0.311, 0.570> <0.500, -0.311, 0.550> 
		<0.539, -0.400, 0.611> <0.524, -0.400, 0.597> <0.513, -0.400, 0.570> <0.513, -0.400, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.484, -0.100, 0.550> <0.484, -0.100, 0.523> <0.499, -0.100, 0.487> <0.518, -0.100, 0.468> 
		<0.478, -0.190, 0.550> <0.478, -0.190, 0.523> <0.495, -0.190, 0.482> <0.513, -0.190, 0.463> 
		<0.500, -0.311, 0.550> <0.500, -0.311, 0.530> <0.515, -0.311, 0.494> <0.529, -0.311, 0.479> 
		<0.513, -0.400, 0.550> <0.513, -0.400, 0.530> <0.524, -0.400, 0.503> <0.539, -0.400, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.518, -0.100, 0.468> <0.537, -0.100, 0.449> <0.573, -0.100, 0.434> <0.600, -0.100, 0.434> 
		<0.513, -0.190, 0.463> <0.532, -0.190, 0.445> <0.573, -0.190, 0.428> <0.600, -0.190, 0.428> 
		<0.529, -0.311, 0.479> <0.544, -0.311, 0.465> <0.580, -0.311, 0.450> <0.600, -0.311, 0.450> 
		<0.539, -0.400, 0.489> <0.553, -0.400, 0.474> <0.580, -0.400, 0.463> <0.600, -0.400, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.100, 0.434> <0.627, -0.100, 0.434> <0.663, -0.100, 0.449> <0.682, -0.100, 0.468> 
		<0.600, -0.190, 0.428> <0.627, -0.190, 0.428> <0.668, -0.190, 0.445> <0.687, -0.190, 0.463> 
		<0.600, -0.311, 0.450> <0.620, -0.311, 0.450> <0.656, -0.311, 0.465> <0.671, -0.311, 0.479> 
		<0.600, -0.400, 0.463> <0.620, -0.400, 0.463> <0.647, -0.400, 0.474> <0.661, -0.400, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.661, -0.400, 0.611> <0.647, -0.400, 0.626> <0.620, -0.400, 0.637> <0.600, -0.400, 0.637> 
		<0.658, -0.431, 0.608> <0.644, -0.431, 0.622> <0.620, -0.431, 0.632> <0.600, -0.431, 0.632> 
		<0.639, -0.469, 0.589> <0.629, -0.469, 0.598> <0.613, -0.469, 0.605> <0.600, -0.469, 0.605> 
		<0.641, -0.500, 0.591> <0.632, -0.500, 0.600> <0.613, -0.500, 0.608> <0.600, -0.500, 0.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.400, 0.637> <0.580, -0.400, 0.637> <0.553, -0.400, 0.626> <0.539, -0.400, 0.611> 
		<0.600, -0.431, 0.632> <0.580, -0.431, 0.632> <0.556, -0.431, 0.622> <0.542, -0.431, 0.608> 
		<0.600, -0.469, 0.605> <0.587, -0.469, 0.605> <0.571, -0.469, 0.598> <0.561, -0.469, 0.589> 
		<0.600, -0.500, 0.608> <0.587, -0.500, 0.608> <0.568, -0.500, 0.600> <0.559, -0.500, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.539, -0.400, 0.611> <0.524, -0.400, 0.597> <0.513, -0.400, 0.570> <0.513, -0.400, 0.550> 
		<0.542, -0.431, 0.608> <0.528, -0.431, 0.594> <0.518, -0.431, 0.570> <0.518, -0.431, 0.550> 
		<0.561, -0.469, 0.589> <0.552, -0.469, 0.579> <0.545, -0.469, 0.563> <0.545, -0.469, 0.550> 
		<0.559, -0.500, 0.591> <0.550, -0.500, 0.582> <0.542, -0.500, 0.563> <0.542, -0.500, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.513, -0.400, 0.550> <0.513, -0.400, 0.530> <0.524, -0.400, 0.503> <0.539, -0.400, 0.489> 
		<0.518, -0.431, 0.550> <0.518, -0.431, 0.530> <0.528, -0.431, 0.506> <0.542, -0.431, 0.492> 
		<0.545, -0.469, 0.550> <0.545, -0.469, 0.537> <0.552, -0.469, 0.521> <0.561, -0.469, 0.511> 
		<0.542, -0.500, 0.550> <0.542, -0.500, 0.537> <0.550, -0.500, 0.518> <0.559, -0.500, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.539, -0.400, 0.489> <0.553, -0.400, 0.474> <0.580, -0.400, 0.463> <0.600, -0.400, 0.463> 
		<0.542, -0.431, 0.492> <0.556, -0.431, 0.478> <0.580, -0.431, 0.468> <0.600, -0.431, 0.468> 
		<0.561, -0.469, 0.511> <0.571, -0.469, 0.502> <0.587, -0.469, 0.495> <0.600, -0.469, 0.495> 
		<0.559, -0.500, 0.509> <0.568, -0.500, 0.500> <0.587, -0.500, 0.492> <0.600, -0.500, 0.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.400, 0.463> <0.620, -0.400, 0.463> <0.647, -0.400, 0.474> <0.661, -0.400, 0.489> 
		<0.600, -0.431, 0.468> <0.620, -0.431, 0.468> <0.644, -0.431, 0.478> <0.658, -0.431, 0.492> 
		<0.600, -0.469, 0.495> <0.613, -0.469, 0.495> <0.629, -0.469, 0.502> <0.639, -0.469, 0.511> 
		<0.600, -0.500, 0.492> <0.613, -0.500, 0.492> <0.632, -0.500, 0.500> <0.641, -0.500, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.641, -0.500, 0.591> <0.632, -0.500, 0.600> <0.613, -0.500, 0.608> <0.600, -0.500, 0.608> 
		<0.645, -0.562, 0.595> <0.636, -0.562, 0.605> <0.613, -0.562, 0.614> <0.600, -0.562, 0.614> 
		<0.681, -0.638, 0.631> <0.662, -0.638, 0.649> <0.627, -0.638, 0.664> <0.600, -0.638, 0.664> 
		<0.682, -0.700, 0.632> <0.663, -0.700, 0.651> <0.627, -0.700, 0.666> <0.600, -0.700, 0.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.500, 0.608> <0.587, -0.500, 0.608> <0.568, -0.500, 0.600> <0.559, -0.500, 0.591> 
		<0.600, -0.562, 0.614> <0.587, -0.562, 0.614> <0.564, -0.562, 0.605> <0.555, -0.562, 0.595> 
		<0.600, -0.638, 0.664> <0.573, -0.638, 0.664> <0.538, -0.638, 0.649> <0.519, -0.638, 0.631> 
		<0.600, -0.700, 0.666> <0.573, -0.700, 0.666> <0.537, -0.700, 0.651> <0.518, -0.700, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.559, -0.500, 0.591> <0.550, -0.500, 0.582> <0.542, -0.500, 0.563> <0.542, -0.500, 0.550> 
		<0.555, -0.562, 0.595> <0.545, -0.562, 0.586> <0.536, -0.562, 0.563> <0.536, -0.562, 0.550> 
		<0.519, -0.638, 0.631> <0.501, -0.638, 0.612> <0.486, -0.638, 0.577> <0.486, -0.638, 0.550> 
		<0.518, -0.700, 0.632> <0.499, -0.700, 0.613> <0.484, -0.700, 0.577> <0.484, -0.700, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.542, -0.500, 0.550> <0.542, -0.500, 0.537> <0.550, -0.500, 0.518> <0.559, -0.500, 0.509> 
		<0.536, -0.562, 0.550> <0.536, -0.562, 0.537> <0.545, -0.562, 0.514> <0.555, -0.562, 0.505> 
		<0.486, -0.638, 0.550> <0.486, -0.638, 0.523> <0.501, -0.638, 0.488> <0.519, -0.638, 0.469> 
		<0.484, -0.700, 0.550> <0.484, -0.700, 0.523> <0.499, -0.700, 0.487> <0.518, -0.700, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.559, -0.500, 0.509> <0.568, -0.500, 0.500> <0.587, -0.500, 0.492> <0.600, -0.500, 0.492> 
		<0.555, -0.562, 0.505> <0.564, -0.562, 0.495> <0.587, -0.562, 0.486> <0.600, -0.562, 0.486> 
		<0.519, -0.638, 0.469> <0.538, -0.638, 0.451> <0.573, -0.638, 0.436> <0.600, -0.638, 0.436> 
		<0.518, -0.700, 0.468> <0.537, -0.700, 0.449> <0.573, -0.700, 0.434> <0.600, -0.700, 0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.500, 0.492> <0.613, -0.500, 0.492> <0.632, -0.500, 0.500> <0.641, -0.500, 0.509> 
		<0.600, -0.562, 0.486> <0.613, -0.562, 0.486> <0.636, -0.562, 0.495> <0.645, -0.562, 0.505> 
		<0.600, -0.638, 0.436> <0.627, -0.638, 0.436> <0.662, -0.638, 0.451> <0.681, -0.638, 0.469> 
		<0.600, -0.700, 0.434> <0.627, -0.700, 0.434> <0.663, -0.700, 0.449> <0.682, -0.700, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.682, -0.700, 0.632> <0.663, -0.700, 0.651> <0.627, -0.700, 0.666> <0.600, -0.700, 0.666> 
		<0.687, -0.940, 0.637> <0.668, -0.940, 0.656> <0.627, -0.940, 0.673> <0.600, -0.940, 0.673> 
		<0.672, -1.260, 0.622> <0.658, -1.260, 0.636> <0.620, -1.260, 0.652> <0.600, -1.260, 0.652> 
		<0.661, -1.500, 0.611> <0.647, -1.500, 0.626> <0.620, -1.500, 0.637> <0.600, -1.500, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.700, 0.666> <0.573, -0.700, 0.666> <0.537, -0.700, 0.651> <0.518, -0.700, 0.632> 
		<0.600, -0.940, 0.673> <0.573, -0.940, 0.673> <0.532, -0.940, 0.656> <0.513, -0.940, 0.637> 
		<0.600, -1.260, 0.652> <0.580, -1.260, 0.652> <0.542, -1.260, 0.636> <0.528, -1.260, 0.622> 
		<0.600, -1.500, 0.637> <0.580, -1.500, 0.637> <0.553, -1.500, 0.626> <0.539, -1.500, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.518, -0.700, 0.632> <0.499, -0.700, 0.613> <0.484, -0.700, 0.577> <0.484, -0.700, 0.550> 
		<0.513, -0.940, 0.637> <0.494, -0.940, 0.618> <0.477, -0.940, 0.577> <0.477, -0.940, 0.550> 
		<0.528, -1.260, 0.622> <0.514, -1.260, 0.608> <0.498, -1.260, 0.570> <0.498, -1.260, 0.550> 
		<0.539, -1.500, 0.611> <0.524, -1.500, 0.597> <0.513, -1.500, 0.570> <0.513, -1.500, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.484, -0.700, 0.550> <0.484, -0.700, 0.523> <0.499, -0.700, 0.487> <0.518, -0.700, 0.468> 
		<0.477, -0.940, 0.550> <0.477, -0.940, 0.523> <0.494, -0.940, 0.482> <0.513, -0.940, 0.463> 
		<0.498, -1.260, 0.550> <0.498, -1.260, 0.530> <0.514, -1.260, 0.492> <0.528, -1.260, 0.478> 
		<0.513, -1.500, 0.550> <0.513, -1.500, 0.530> <0.524, -1.500, 0.503> <0.539, -1.500, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.518, -0.700, 0.468> <0.537, -0.700, 0.449> <0.573, -0.700, 0.434> <0.600, -0.700, 0.434> 
		<0.513, -0.940, 0.463> <0.532, -0.940, 0.444> <0.573, -0.940, 0.427> <0.600, -0.940, 0.427> 
		<0.528, -1.260, 0.478> <0.542, -1.260, 0.464> <0.580, -1.260, 0.448> <0.600, -1.260, 0.448> 
		<0.539, -1.500, 0.489> <0.553, -1.500, 0.474> <0.580, -1.500, 0.463> <0.600, -1.500, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -0.700, 0.434> <0.627, -0.700, 0.434> <0.663, -0.700, 0.449> <0.682, -0.700, 0.468> 
		<0.600, -0.940, 0.427> <0.627, -0.940, 0.427> <0.668, -0.940, 0.444> <0.687, -0.940, 0.463> 
		<0.600, -1.260, 0.448> <0.620, -1.260, 0.448> <0.658, -1.260, 0.464> <0.672, -1.260, 0.478> 
		<0.600, -1.500, 0.463> <0.620, -1.500, 0.463> <0.647, -1.500, 0.474> <0.661, -1.500, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.661, -1.500, 0.611> <0.647, -1.500, 0.626> <0.620, -1.500, 0.637> <0.600, -1.500, 0.637> 
		<0.660, -1.531, 0.610> <0.646, -1.531, 0.624> <0.620, -1.531, 0.635> <0.600, -1.531, 0.635> 
		<0.641, -1.569, 0.591> <0.632, -1.569, 0.600> <0.613, -1.569, 0.608> <0.600, -1.569, 0.608> 
		<0.641, -1.600, 0.591> <0.632, -1.600, 0.600> <0.613, -1.600, 0.608> <0.600, -1.600, 0.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -1.500, 0.637> <0.580, -1.500, 0.637> <0.553, -1.500, 0.626> <0.539, -1.500, 0.611> 
		<0.600, -1.531, 0.635> <0.580, -1.531, 0.635> <0.554, -1.531, 0.624> <0.540, -1.531, 0.610> 
		<0.600, -1.569, 0.608> <0.587, -1.569, 0.608> <0.568, -1.569, 0.600> <0.559, -1.569, 0.591> 
		<0.600, -1.600, 0.608> <0.587, -1.600, 0.608> <0.568, -1.600, 0.600> <0.559, -1.600, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.539, -1.500, 0.611> <0.524, -1.500, 0.597> <0.513, -1.500, 0.570> <0.513, -1.500, 0.550> 
		<0.540, -1.531, 0.610> <0.526, -1.531, 0.596> <0.515, -1.531, 0.570> <0.515, -1.531, 0.550> 
		<0.559, -1.569, 0.591> <0.550, -1.569, 0.582> <0.542, -1.569, 0.563> <0.542, -1.569, 0.550> 
		<0.559, -1.600, 0.591> <0.550, -1.600, 0.582> <0.542, -1.600, 0.563> <0.542, -1.600, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.513, -1.500, 0.550> <0.513, -1.500, 0.530> <0.524, -1.500, 0.503> <0.539, -1.500, 0.489> 
		<0.515, -1.531, 0.550> <0.515, -1.531, 0.530> <0.526, -1.531, 0.504> <0.540, -1.531, 0.490> 
		<0.542, -1.569, 0.550> <0.542, -1.569, 0.537> <0.550, -1.569, 0.518> <0.559, -1.569, 0.509> 
		<0.542, -1.600, 0.550> <0.542, -1.600, 0.537> <0.550, -1.600, 0.518> <0.559, -1.600, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.539, -1.500, 0.489> <0.553, -1.500, 0.474> <0.580, -1.500, 0.463> <0.600, -1.500, 0.463> 
		<0.540, -1.531, 0.490> <0.554, -1.531, 0.476> <0.580, -1.531, 0.465> <0.600, -1.531, 0.465> 
		<0.559, -1.569, 0.509> <0.568, -1.569, 0.500> <0.587, -1.569, 0.492> <0.600, -1.569, 0.492> 
		<0.559, -1.600, 0.509> <0.568, -1.600, 0.500> <0.587, -1.600, 0.492> <0.600, -1.600, 0.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -1.500, 0.463> <0.620, -1.500, 0.463> <0.647, -1.500, 0.474> <0.661, -1.500, 0.489> 
		<0.600, -1.531, 0.465> <0.620, -1.531, 0.465> <0.646, -1.531, 0.476> <0.660, -1.531, 0.490> 
		<0.600, -1.569, 0.492> <0.613, -1.569, 0.492> <0.632, -1.569, 0.500> <0.641, -1.569, 0.509> 
		<0.600, -1.600, 0.492> <0.613, -1.600, 0.492> <0.632, -1.600, 0.500> <0.641, -1.600, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.641, -1.600, 0.591> <0.632, -1.600, 0.600> <0.613, -1.600, 0.608> <0.600, -1.600, 0.608> 
		<0.641, -1.646, 0.591> <0.632, -1.646, 0.600> <0.613, -1.646, 0.608> <0.600, -1.646, 0.608> 
		<0.661, -1.704, 0.611> <0.647, -1.704, 0.626> <0.620, -1.704, 0.637> <0.600, -1.704, 0.637> 
		<0.661, -1.750, 0.611> <0.647, -1.750, 0.626> <0.620, -1.750, 0.637> <0.600, -1.750, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -1.600, 0.608> <0.587, -1.600, 0.608> <0.568, -1.600, 0.600> <0.559, -1.600, 0.591> 
		<0.600, -1.646, 0.608> <0.587, -1.646, 0.608> <0.568, -1.646, 0.600> <0.559, -1.646, 0.591> 
		<0.600, -1.704, 0.637> <0.580, -1.704, 0.637> <0.553, -1.704, 0.626> <0.539, -1.704, 0.611> 
		<0.600, -1.750, 0.637> <0.580, -1.750, 0.637> <0.553, -1.750, 0.626> <0.539, -1.750, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.559, -1.600, 0.591> <0.550, -1.600, 0.582> <0.542, -1.600, 0.563> <0.542, -1.600, 0.550> 
		<0.559, -1.646, 0.591> <0.550, -1.646, 0.582> <0.542, -1.646, 0.563> <0.542, -1.646, 0.550> 
		<0.539, -1.704, 0.611> <0.524, -1.704, 0.597> <0.513, -1.704, 0.570> <0.513, -1.704, 0.550> 
		<0.539, -1.750, 0.611> <0.524, -1.750, 0.597> <0.513, -1.750, 0.570> <0.513, -1.750, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.542, -1.600, 0.550> <0.542, -1.600, 0.537> <0.550, -1.600, 0.518> <0.559, -1.600, 0.509> 
		<0.542, -1.646, 0.550> <0.542, -1.646, 0.537> <0.550, -1.646, 0.518> <0.559, -1.646, 0.509> 
		<0.513, -1.704, 0.550> <0.513, -1.704, 0.530> <0.524, -1.704, 0.503> <0.539, -1.704, 0.489> 
		<0.513, -1.750, 0.550> <0.513, -1.750, 0.530> <0.524, -1.750, 0.503> <0.539, -1.750, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.559, -1.600, 0.509> <0.568, -1.600, 0.500> <0.587, -1.600, 0.492> <0.600, -1.600, 0.492> 
		<0.559, -1.646, 0.509> <0.568, -1.646, 0.500> <0.587, -1.646, 0.492> <0.600, -1.646, 0.492> 
		<0.539, -1.704, 0.489> <0.553, -1.704, 0.474> <0.580, -1.704, 0.463> <0.600, -1.704, 0.463> 
		<0.539, -1.750, 0.489> <0.553, -1.750, 0.474> <0.580, -1.750, 0.463> <0.600, -1.750, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -1.600, 0.492> <0.613, -1.600, 0.492> <0.632, -1.600, 0.500> <0.641, -1.600, 0.509> 
		<0.600, -1.646, 0.492> <0.613, -1.646, 0.492> <0.632, -1.646, 0.500> <0.641, -1.646, 0.509> 
		<0.600, -1.704, 0.463> <0.620, -1.704, 0.463> <0.647, -1.704, 0.474> <0.661, -1.704, 0.489> 
		<0.600, -1.750, 0.463> <0.620, -1.750, 0.463> <0.647, -1.750, 0.474> <0.661, -1.750, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.661, -1.750, 0.611> <0.647, -1.750, 0.626> <0.620, -1.750, 0.637> <0.600, -1.750, 0.637> 
		<0.661, -1.767, 0.611> <0.647, -1.767, 0.626> <0.620, -1.767, 0.637> <0.600, -1.767, 0.637> 
		<0.647, -1.785, 0.597> <0.638, -1.785, 0.606> <0.613, -1.785, 0.617> <0.600, -1.785, 0.617> 
		<0.641, -1.800, 0.591> <0.632, -1.800, 0.600> <0.613, -1.800, 0.608> <0.600, -1.800, 0.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -1.750, 0.637> <0.580, -1.750, 0.637> <0.553, -1.750, 0.626> <0.539, -1.750, 0.611> 
		<0.600, -1.767, 0.637> <0.580, -1.767, 0.637> <0.553, -1.767, 0.626> <0.539, -1.767, 0.611> 
		<0.600, -1.785, 0.617> <0.587, -1.785, 0.617> <0.562, -1.785, 0.606> <0.553, -1.785, 0.597> 
		<0.600, -1.800, 0.608> <0.587, -1.800, 0.608> <0.568, -1.800, 0.600> <0.559, -1.800, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.539, -1.750, 0.611> <0.524, -1.750, 0.597> <0.513, -1.750, 0.570> <0.513, -1.750, 0.550> 
		<0.539, -1.767, 0.611> <0.524, -1.767, 0.597> <0.513, -1.767, 0.570> <0.513, -1.767, 0.550> 
		<0.553, -1.785, 0.597> <0.544, -1.785, 0.588> <0.533, -1.785, 0.563> <0.533, -1.785, 0.550> 
		<0.559, -1.800, 0.591> <0.550, -1.800, 0.582> <0.542, -1.800, 0.563> <0.542, -1.800, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.513, -1.750, 0.550> <0.513, -1.750, 0.530> <0.524, -1.750, 0.503> <0.539, -1.750, 0.489> 
		<0.513, -1.767, 0.550> <0.513, -1.767, 0.530> <0.524, -1.767, 0.503> <0.539, -1.767, 0.489> 
		<0.533, -1.785, 0.550> <0.533, -1.785, 0.537> <0.544, -1.785, 0.512> <0.553, -1.785, 0.503> 
		<0.542, -1.800, 0.550> <0.542, -1.800, 0.537> <0.550, -1.800, 0.518> <0.559, -1.800, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.539, -1.750, 0.489> <0.553, -1.750, 0.474> <0.580, -1.750, 0.463> <0.600, -1.750, 0.463> 
		<0.539, -1.767, 0.489> <0.553, -1.767, 0.474> <0.580, -1.767, 0.463> <0.600, -1.767, 0.463> 
		<0.553, -1.785, 0.503> <0.562, -1.785, 0.494> <0.587, -1.785, 0.483> <0.600, -1.785, 0.483> 
		<0.559, -1.800, 0.509> <0.568, -1.800, 0.500> <0.587, -1.800, 0.492> <0.600, -1.800, 0.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, -1.750, 0.463> <0.620, -1.750, 0.463> <0.647, -1.750, 0.474> <0.661, -1.750, 0.489> 
		<0.600, -1.767, 0.463> <0.620, -1.767, 0.463> <0.647, -1.767, 0.474> <0.661, -1.767, 0.489> 
		<0.600, -1.785, 0.483> <0.613, -1.785, 0.483> <0.638, -1.785, 0.494> <0.647, -1.785, 0.503> 
		<0.600, -1.800, 0.492> <0.613, -1.800, 0.492> <0.632, -1.800, 0.500> <0.641, -1.800, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.542, -1.800, 0.550> <-0.542, -1.800, 0.537> <-0.550, -1.800, 0.518> <-0.559, -1.800, 0.509> 
		<-0.533, -1.785, 0.550> <-0.533, -1.785, 0.537> <-0.544, -1.785, 0.512> <-0.553, -1.785, 0.503> 
		<-0.513, -1.767, 0.550> <-0.513, -1.767, 0.530> <-0.524, -1.767, 0.503> <-0.539, -1.767, 0.489> 
		<-0.513, -1.750, 0.550> <-0.513, -1.750, 0.530> <-0.524, -1.750, 0.503> <-0.539, -1.750, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.542, -1.800, 0.550> <-0.533, -1.785, 0.550> <-0.513, -1.767, 0.550> <-0.513, -1.750, 0.550> 
		<-0.542, -1.800, 0.563> <-0.533, -1.785, 0.563> <-0.513, -1.767, 0.570> <-0.513, -1.750, 0.570> 
		<-0.550, -1.800, 0.582> <-0.544, -1.785, 0.588> <-0.524, -1.767, 0.597> <-0.524, -1.750, 0.597> 
		<-0.559, -1.800, 0.591> <-0.553, -1.785, 0.597> <-0.539, -1.767, 0.611> <-0.539, -1.750, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.513, -1.750, 0.550> <-0.513, -1.750, 0.530> <-0.524, -1.750, 0.503> <-0.539, -1.750, 0.489> 
		<-0.513, -1.704, 0.550> <-0.513, -1.704, 0.530> <-0.524, -1.704, 0.503> <-0.539, -1.704, 0.489> 
		<-0.542, -1.646, 0.550> <-0.542, -1.646, 0.537> <-0.550, -1.646, 0.518> <-0.559, -1.646, 0.509> 
		<-0.542, -1.600, 0.550> <-0.542, -1.600, 0.537> <-0.550, -1.600, 0.518> <-0.559, -1.600, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.513, -1.750, 0.550> <-0.513, -1.704, 0.550> <-0.542, -1.646, 0.550> <-0.542, -1.600, 0.550> 
		<-0.513, -1.750, 0.570> <-0.513, -1.704, 0.570> <-0.542, -1.646, 0.563> <-0.542, -1.600, 0.563> 
		<-0.524, -1.750, 0.597> <-0.524, -1.704, 0.597> <-0.550, -1.646, 0.582> <-0.550, -1.600, 0.582> 
		<-0.539, -1.750, 0.611> <-0.539, -1.704, 0.611> <-0.559, -1.646, 0.591> <-0.559, -1.600, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.542, -1.600, 0.550> <-0.542, -1.600, 0.537> <-0.550, -1.600, 0.518> <-0.559, -1.600, 0.509> 
		<-0.542, -1.569, 0.550> <-0.542, -1.569, 0.537> <-0.550, -1.569, 0.518> <-0.559, -1.569, 0.509> 
		<-0.515, -1.531, 0.550> <-0.515, -1.531, 0.530> <-0.526, -1.531, 0.504> <-0.540, -1.531, 0.490> 
		<-0.513, -1.500, 0.550> <-0.513, -1.500, 0.530> <-0.524, -1.500, 0.503> <-0.539, -1.500, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.542, -1.600, 0.550> <-0.542, -1.569, 0.550> <-0.515, -1.531, 0.550> <-0.513, -1.500, 0.550> 
		<-0.542, -1.600, 0.563> <-0.542, -1.569, 0.563> <-0.515, -1.531, 0.570> <-0.513, -1.500, 0.570> 
		<-0.550, -1.600, 0.582> <-0.550, -1.569, 0.582> <-0.526, -1.531, 0.596> <-0.524, -1.500, 0.597> 
		<-0.559, -1.600, 0.591> <-0.559, -1.569, 0.591> <-0.540, -1.531, 0.610> <-0.539, -1.500, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.513, -1.500, 0.550> <-0.513, -1.500, 0.530> <-0.524, -1.500, 0.503> <-0.539, -1.500, 0.489> 
		<-0.498, -1.260, 0.550> <-0.498, -1.260, 0.530> <-0.514, -1.260, 0.492> <-0.528, -1.260, 0.478> 
		<-0.477, -0.940, 0.550> <-0.477, -0.940, 0.523> <-0.494, -0.940, 0.482> <-0.513, -0.940, 0.463> 
		<-0.484, -0.700, 0.550> <-0.484, -0.700, 0.523> <-0.499, -0.700, 0.487> <-0.518, -0.700, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.513, -1.500, 0.550> <-0.498, -1.260, 0.550> <-0.477, -0.940, 0.550> <-0.484, -0.700, 0.550> 
		<-0.513, -1.500, 0.570> <-0.498, -1.260, 0.570> <-0.477, -0.940, 0.577> <-0.484, -0.700, 0.577> 
		<-0.524, -1.500, 0.597> <-0.514, -1.260, 0.608> <-0.494, -0.940, 0.618> <-0.499, -0.700, 0.613> 
		<-0.539, -1.500, 0.611> <-0.528, -1.260, 0.622> <-0.513, -0.940, 0.637> <-0.518, -0.700, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.484, -0.700, 0.550> <-0.484, -0.700, 0.523> <-0.499, -0.700, 0.487> <-0.518, -0.700, 0.468> 
		<-0.486, -0.638, 0.550> <-0.486, -0.638, 0.523> <-0.501, -0.638, 0.488> <-0.519, -0.638, 0.469> 
		<-0.536, -0.562, 0.550> <-0.536, -0.562, 0.537> <-0.545, -0.562, 0.514> <-0.555, -0.562, 0.505> 
		<-0.542, -0.500, 0.550> <-0.542, -0.500, 0.537> <-0.550, -0.500, 0.518> <-0.559, -0.500, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.484, -0.700, 0.550> <-0.486, -0.638, 0.550> <-0.536, -0.562, 0.550> <-0.542, -0.500, 0.550> 
		<-0.484, -0.700, 0.577> <-0.486, -0.638, 0.577> <-0.536, -0.562, 0.563> <-0.542, -0.500, 0.563> 
		<-0.499, -0.700, 0.613> <-0.501, -0.638, 0.612> <-0.545, -0.562, 0.586> <-0.550, -0.500, 0.582> 
		<-0.518, -0.700, 0.632> <-0.519, -0.638, 0.631> <-0.555, -0.562, 0.595> <-0.559, -0.500, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.542, -0.500, 0.550> <-0.542, -0.500, 0.537> <-0.550, -0.500, 0.518> <-0.559, -0.500, 0.509> 
		<-0.545, -0.469, 0.550> <-0.545, -0.469, 0.537> <-0.552, -0.469, 0.521> <-0.561, -0.469, 0.511> 
		<-0.518, -0.431, 0.550> <-0.518, -0.431, 0.530> <-0.528, -0.431, 0.506> <-0.542, -0.431, 0.492> 
		<-0.513, -0.400, 0.550> <-0.513, -0.400, 0.530> <-0.524, -0.400, 0.503> <-0.539, -0.400, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.542, -0.500, 0.550> <-0.545, -0.469, 0.550> <-0.518, -0.431, 0.550> <-0.513, -0.400, 0.550> 
		<-0.542, -0.500, 0.563> <-0.545, -0.469, 0.563> <-0.518, -0.431, 0.570> <-0.513, -0.400, 0.570> 
		<-0.550, -0.500, 0.582> <-0.552, -0.469, 0.579> <-0.528, -0.431, 0.594> <-0.524, -0.400, 0.597> 
		<-0.559, -0.500, 0.591> <-0.561, -0.469, 0.589> <-0.542, -0.431, 0.608> <-0.539, -0.400, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.513, -0.400, 0.550> <-0.513, -0.400, 0.530> <-0.524, -0.400, 0.503> <-0.539, -0.400, 0.489> 
		<-0.500, -0.311, 0.550> <-0.500, -0.311, 0.530> <-0.515, -0.311, 0.494> <-0.529, -0.311, 0.479> 
		<-0.478, -0.190, 0.550> <-0.478, -0.190, 0.523> <-0.495, -0.190, 0.482> <-0.513, -0.190, 0.463> 
		<-0.484, -0.100, 0.550> <-0.484, -0.100, 0.523> <-0.499, -0.100, 0.487> <-0.518, -0.100, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.513, -0.400, 0.550> <-0.500, -0.311, 0.550> <-0.478, -0.190, 0.550> <-0.484, -0.100, 0.550> 
		<-0.513, -0.400, 0.570> <-0.500, -0.311, 0.570> <-0.478, -0.190, 0.577> <-0.484, -0.100, 0.577> 
		<-0.524, -0.400, 0.597> <-0.515, -0.311, 0.606> <-0.495, -0.190, 0.618> <-0.499, -0.100, 0.613> 
		<-0.539, -0.400, 0.611> <-0.529, -0.311, 0.621> <-0.513, -0.190, 0.637> <-0.518, -0.100, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.542, 0.000, 0.550> <-0.525, -0.030, 0.550> <-0.487, -0.065, 0.550> <-0.484, -0.100, 0.550> 
		<-0.542, 0.000, 0.537> <-0.525, -0.030, 0.537> <-0.487, -0.065, 0.523> <-0.484, -0.100, 0.523> 
		<-0.550, 0.000, 0.518> <-0.537, -0.030, 0.506> <-0.501, -0.065, 0.489> <-0.499, -0.100, 0.487> 
		<-0.559, 0.000, 0.509> <-0.547, -0.030, 0.497> <-0.520, -0.065, 0.470> <-0.518, -0.100, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.542, 0.000, 0.550> <-0.542, 0.000, 0.563> <-0.550, 0.000, 0.582> <-0.559, 0.000, 0.591> 
		<-0.525, -0.030, 0.550> <-0.525, -0.030, 0.563> <-0.537, -0.030, 0.594> <-0.547, -0.030, 0.603> 
		<-0.487, -0.065, 0.550> <-0.487, -0.065, 0.577> <-0.501, -0.065, 0.611> <-0.520, -0.065, 0.630> 
		<-0.484, -0.100, 0.550> <-0.484, -0.100, 0.577> <-0.499, -0.100, 0.613> <-0.518, -0.100, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.559, 0.000, 0.591> <-0.568, 0.000, 0.600> <-0.587, 0.000, 0.608> <-0.600, 0.000, 0.608> 
		<-0.547, -0.030, 0.603> <-0.556, -0.030, 0.613> <-0.587, -0.030, 0.625> <-0.600, -0.030, 0.625> 
		<-0.520, -0.065, 0.630> <-0.539, -0.065, 0.649> <-0.573, -0.065, 0.663> <-0.600, -0.065, 0.663> 
		<-0.518, -0.100, 0.632> <-0.537, -0.100, 0.651> <-0.573, -0.100, 0.666> <-0.600, -0.100, 0.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 0.000, 0.608> <-0.613, 0.000, 0.608> <-0.632, 0.000, 0.600> <-0.641, 0.000, 0.591> 
		<-0.600, -0.030, 0.625> <-0.613, -0.030, 0.625> <-0.644, -0.030, 0.613> <-0.653, -0.030, 0.603> 
		<-0.600, -0.065, 0.663> <-0.627, -0.065, 0.663> <-0.661, -0.065, 0.649> <-0.680, -0.065, 0.630> 
		<-0.600, -0.100, 0.666> <-0.627, -0.100, 0.666> <-0.663, -0.100, 0.651> <-0.682, -0.100, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, 0.000, 0.591> <-0.650, 0.000, 0.582> <-0.658, 0.000, 0.563> <-0.658, 0.000, 0.550> 
		<-0.653, -0.030, 0.603> <-0.663, -0.030, 0.594> <-0.675, -0.030, 0.563> <-0.675, -0.030, 0.550> 
		<-0.680, -0.065, 0.630> <-0.699, -0.065, 0.611> <-0.713, -0.065, 0.577> <-0.713, -0.065, 0.550> 
		<-0.682, -0.100, 0.632> <-0.701, -0.100, 0.613> <-0.716, -0.100, 0.577> <-0.716, -0.100, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 0.000, 0.550> <-0.658, 0.000, 0.537> <-0.650, 0.000, 0.518> <-0.641, 0.000, 0.509> 
		<-0.675, -0.030, 0.550> <-0.675, -0.030, 0.537> <-0.663, -0.030, 0.506> <-0.653, -0.030, 0.497> 
		<-0.713, -0.065, 0.550> <-0.713, -0.065, 0.523> <-0.699, -0.065, 0.489> <-0.680, -0.065, 0.470> 
		<-0.716, -0.100, 0.550> <-0.716, -0.100, 0.523> <-0.701, -0.100, 0.487> <-0.682, -0.100, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, 0.000, 0.509> <-0.632, 0.000, 0.500> <-0.613, 0.000, 0.492> <-0.600, 0.000, 0.492> 
		<-0.653, -0.030, 0.497> <-0.644, -0.030, 0.487> <-0.613, -0.030, 0.475> <-0.600, -0.030, 0.475> 
		<-0.680, -0.065, 0.470> <-0.661, -0.065, 0.451> <-0.627, -0.065, 0.437> <-0.600, -0.065, 0.437> 
		<-0.682, -0.100, 0.468> <-0.663, -0.100, 0.449> <-0.627, -0.100, 0.434> <-0.600, -0.100, 0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 0.000, 0.492> <-0.587, 0.000, 0.492> <-0.568, 0.000, 0.500> <-0.559, 0.000, 0.509> 
		<-0.600, -0.030, 0.475> <-0.587, -0.030, 0.475> <-0.556, -0.030, 0.487> <-0.547, -0.030, 0.497> 
		<-0.600, -0.065, 0.437> <-0.573, -0.065, 0.437> <-0.539, -0.065, 0.451> <-0.520, -0.065, 0.470> 
		<-0.600, -0.100, 0.434> <-0.573, -0.100, 0.434> <-0.537, -0.100, 0.449> <-0.518, -0.100, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.518, -0.100, 0.632> <-0.537, -0.100, 0.651> <-0.573, -0.100, 0.666> <-0.600, -0.100, 0.666> 
		<-0.513, -0.190, 0.637> <-0.532, -0.190, 0.655> <-0.573, -0.190, 0.672> <-0.600, -0.190, 0.672> 
		<-0.529, -0.311, 0.621> <-0.544, -0.311, 0.635> <-0.580, -0.311, 0.650> <-0.600, -0.311, 0.650> 
		<-0.539, -0.400, 0.611> <-0.553, -0.400, 0.626> <-0.580, -0.400, 0.637> <-0.600, -0.400, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -0.100, 0.666> <-0.627, -0.100, 0.666> <-0.663, -0.100, 0.651> <-0.682, -0.100, 0.632> 
		<-0.600, -0.190, 0.672> <-0.627, -0.190, 0.672> <-0.668, -0.190, 0.655> <-0.687, -0.190, 0.637> 
		<-0.600, -0.311, 0.650> <-0.620, -0.311, 0.650> <-0.656, -0.311, 0.635> <-0.671, -0.311, 0.621> 
		<-0.600, -0.400, 0.637> <-0.620, -0.400, 0.637> <-0.647, -0.400, 0.626> <-0.661, -0.400, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.682, -0.100, 0.632> <-0.701, -0.100, 0.613> <-0.716, -0.100, 0.577> <-0.716, -0.100, 0.550> 
		<-0.687, -0.190, 0.637> <-0.705, -0.190, 0.618> <-0.722, -0.190, 0.577> <-0.722, -0.190, 0.550> 
		<-0.671, -0.311, 0.621> <-0.685, -0.311, 0.606> <-0.700, -0.311, 0.570> <-0.700, -0.311, 0.550> 
		<-0.661, -0.400, 0.611> <-0.676, -0.400, 0.597> <-0.687, -0.400, 0.570> <-0.687, -0.400, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.716, -0.100, 0.550> <-0.716, -0.100, 0.523> <-0.701, -0.100, 0.487> <-0.682, -0.100, 0.468> 
		<-0.722, -0.190, 0.550> <-0.722, -0.190, 0.523> <-0.705, -0.190, 0.482> <-0.687, -0.190, 0.463> 
		<-0.700, -0.311, 0.550> <-0.700, -0.311, 0.530> <-0.685, -0.311, 0.494> <-0.671, -0.311, 0.479> 
		<-0.687, -0.400, 0.550> <-0.687, -0.400, 0.530> <-0.676, -0.400, 0.503> <-0.661, -0.400, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.682, -0.100, 0.468> <-0.663, -0.100, 0.449> <-0.627, -0.100, 0.434> <-0.600, -0.100, 0.434> 
		<-0.687, -0.190, 0.463> <-0.668, -0.190, 0.445> <-0.627, -0.190, 0.428> <-0.600, -0.190, 0.428> 
		<-0.671, -0.311, 0.479> <-0.656, -0.311, 0.465> <-0.620, -0.311, 0.450> <-0.600, -0.311, 0.450> 
		<-0.661, -0.400, 0.489> <-0.647, -0.400, 0.474> <-0.620, -0.400, 0.463> <-0.600, -0.400, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -0.100, 0.434> <-0.573, -0.100, 0.434> <-0.537, -0.100, 0.449> <-0.518, -0.100, 0.468> 
		<-0.600, -0.190, 0.428> <-0.573, -0.190, 0.428> <-0.532, -0.190, 0.445> <-0.513, -0.190, 0.463> 
		<-0.600, -0.311, 0.450> <-0.580, -0.311, 0.450> <-0.544, -0.311, 0.465> <-0.529, -0.311, 0.479> 
		<-0.600, -0.400, 0.463> <-0.580, -0.400, 0.463> <-0.553, -0.400, 0.474> <-0.539, -0.400, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.539, -0.400, 0.611> <-0.553, -0.400, 0.626> <-0.580, -0.400, 0.637> <-0.600, -0.400, 0.637> 
		<-0.542, -0.431, 0.608> <-0.556, -0.431, 0.622> <-0.580, -0.431, 0.632> <-0.600, -0.431, 0.632> 
		<-0.561, -0.469, 0.589> <-0.571, -0.469, 0.598> <-0.587, -0.469, 0.605> <-0.600, -0.469, 0.605> 
		<-0.559, -0.500, 0.591> <-0.568, -0.500, 0.600> <-0.587, -0.500, 0.608> <-0.600, -0.500, 0.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -0.400, 0.637> <-0.620, -0.400, 0.637> <-0.647, -0.400, 0.626> <-0.661, -0.400, 0.611> 
		<-0.600, -0.431, 0.632> <-0.620, -0.431, 0.632> <-0.644, -0.431, 0.622> <-0.658, -0.431, 0.608> 
		<-0.600, -0.469, 0.605> <-0.613, -0.469, 0.605> <-0.629, -0.469, 0.598> <-0.639, -0.469, 0.589> 
		<-0.600, -0.500, 0.608> <-0.613, -0.500, 0.608> <-0.632, -0.500, 0.600> <-0.641, -0.500, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, -0.400, 0.611> <-0.676, -0.400, 0.597> <-0.687, -0.400, 0.570> <-0.687, -0.400, 0.550> 
		<-0.658, -0.431, 0.608> <-0.672, -0.431, 0.594> <-0.682, -0.431, 0.570> <-0.682, -0.431, 0.550> 
		<-0.639, -0.469, 0.589> <-0.648, -0.469, 0.579> <-0.655, -0.469, 0.563> <-0.655, -0.469, 0.550> 
		<-0.641, -0.500, 0.591> <-0.650, -0.500, 0.582> <-0.658, -0.500, 0.563> <-0.658, -0.500, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.687, -0.400, 0.550> <-0.687, -0.400, 0.530> <-0.676, -0.400, 0.503> <-0.661, -0.400, 0.489> 
		<-0.682, -0.431, 0.550> <-0.682, -0.431, 0.530> <-0.672, -0.431, 0.506> <-0.658, -0.431, 0.492> 
		<-0.655, -0.469, 0.550> <-0.655, -0.469, 0.537> <-0.648, -0.469, 0.521> <-0.639, -0.469, 0.511> 
		<-0.658, -0.500, 0.550> <-0.658, -0.500, 0.537> <-0.650, -0.500, 0.518> <-0.641, -0.500, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, -0.400, 0.489> <-0.647, -0.400, 0.474> <-0.620, -0.400, 0.463> <-0.600, -0.400, 0.463> 
		<-0.658, -0.431, 0.492> <-0.644, -0.431, 0.478> <-0.620, -0.431, 0.468> <-0.600, -0.431, 0.468> 
		<-0.639, -0.469, 0.511> <-0.629, -0.469, 0.502> <-0.613, -0.469, 0.495> <-0.600, -0.469, 0.495> 
		<-0.641, -0.500, 0.509> <-0.632, -0.500, 0.500> <-0.613, -0.500, 0.492> <-0.600, -0.500, 0.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -0.400, 0.463> <-0.580, -0.400, 0.463> <-0.553, -0.400, 0.474> <-0.539, -0.400, 0.489> 
		<-0.600, -0.431, 0.468> <-0.580, -0.431, 0.468> <-0.556, -0.431, 0.478> <-0.542, -0.431, 0.492> 
		<-0.600, -0.469, 0.495> <-0.587, -0.469, 0.495> <-0.571, -0.469, 0.502> <-0.561, -0.469, 0.511> 
		<-0.600, -0.500, 0.492> <-0.587, -0.500, 0.492> <-0.568, -0.500, 0.500> <-0.559, -0.500, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.559, -0.500, 0.591> <-0.568, -0.500, 0.600> <-0.587, -0.500, 0.608> <-0.600, -0.500, 0.608> 
		<-0.555, -0.562, 0.595> <-0.564, -0.562, 0.605> <-0.587, -0.562, 0.614> <-0.600, -0.562, 0.614> 
		<-0.519, -0.638, 0.631> <-0.538, -0.638, 0.649> <-0.573, -0.638, 0.664> <-0.600, -0.638, 0.664> 
		<-0.518, -0.700, 0.632> <-0.537, -0.700, 0.651> <-0.573, -0.700, 0.666> <-0.600, -0.700, 0.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -0.500, 0.608> <-0.613, -0.500, 0.608> <-0.632, -0.500, 0.600> <-0.641, -0.500, 0.591> 
		<-0.600, -0.562, 0.614> <-0.613, -0.562, 0.614> <-0.636, -0.562, 0.605> <-0.645, -0.562, 0.595> 
		<-0.600, -0.638, 0.664> <-0.627, -0.638, 0.664> <-0.662, -0.638, 0.649> <-0.681, -0.638, 0.631> 
		<-0.600, -0.700, 0.666> <-0.627, -0.700, 0.666> <-0.663, -0.700, 0.651> <-0.682, -0.700, 0.632> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, -0.500, 0.591> <-0.650, -0.500, 0.582> <-0.658, -0.500, 0.563> <-0.658, -0.500, 0.550> 
		<-0.645, -0.562, 0.595> <-0.655, -0.562, 0.586> <-0.664, -0.562, 0.563> <-0.664, -0.562, 0.550> 
		<-0.681, -0.638, 0.631> <-0.699, -0.638, 0.612> <-0.714, -0.638, 0.577> <-0.714, -0.638, 0.550> 
		<-0.682, -0.700, 0.632> <-0.701, -0.700, 0.613> <-0.716, -0.700, 0.577> <-0.716, -0.700, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, -0.500, 0.550> <-0.658, -0.500, 0.537> <-0.650, -0.500, 0.518> <-0.641, -0.500, 0.509> 
		<-0.664, -0.562, 0.550> <-0.664, -0.562, 0.537> <-0.655, -0.562, 0.514> <-0.645, -0.562, 0.505> 
		<-0.714, -0.638, 0.550> <-0.714, -0.638, 0.523> <-0.699, -0.638, 0.488> <-0.681, -0.638, 0.469> 
		<-0.716, -0.700, 0.550> <-0.716, -0.700, 0.523> <-0.701, -0.700, 0.487> <-0.682, -0.700, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, -0.500, 0.509> <-0.632, -0.500, 0.500> <-0.613, -0.500, 0.492> <-0.600, -0.500, 0.492> 
		<-0.645, -0.562, 0.505> <-0.636, -0.562, 0.495> <-0.613, -0.562, 0.486> <-0.600, -0.562, 0.486> 
		<-0.681, -0.638, 0.469> <-0.662, -0.638, 0.451> <-0.627, -0.638, 0.436> <-0.600, -0.638, 0.436> 
		<-0.682, -0.700, 0.468> <-0.663, -0.700, 0.449> <-0.627, -0.700, 0.434> <-0.600, -0.700, 0.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -0.500, 0.492> <-0.587, -0.500, 0.492> <-0.568, -0.500, 0.500> <-0.559, -0.500, 0.509> 
		<-0.600, -0.562, 0.486> <-0.587, -0.562, 0.486> <-0.564, -0.562, 0.495> <-0.555, -0.562, 0.505> 
		<-0.600, -0.638, 0.436> <-0.573, -0.638, 0.436> <-0.538, -0.638, 0.451> <-0.519, -0.638, 0.469> 
		<-0.600, -0.700, 0.434> <-0.573, -0.700, 0.434> <-0.537, -0.700, 0.449> <-0.518, -0.700, 0.468> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.518, -0.700, 0.632> <-0.537, -0.700, 0.651> <-0.573, -0.700, 0.666> <-0.600, -0.700, 0.666> 
		<-0.513, -0.940, 0.637> <-0.532, -0.940, 0.656> <-0.573, -0.940, 0.673> <-0.600, -0.940, 0.673> 
		<-0.528, -1.260, 0.622> <-0.542, -1.260, 0.636> <-0.580, -1.260, 0.652> <-0.600, -1.260, 0.652> 
		<-0.539, -1.500, 0.611> <-0.553, -1.500, 0.626> <-0.580, -1.500, 0.637> <-0.600, -1.500, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -0.700, 0.666> <-0.627, -0.700, 0.666> <-0.663, -0.700, 0.651> <-0.682, -0.700, 0.632> 
		<-0.600, -0.940, 0.673> <-0.627, -0.940, 0.673> <-0.668, -0.940, 0.656> <-0.687, -0.940, 0.637> 
		<-0.600, -1.260, 0.652> <-0.620, -1.260, 0.652> <-0.658, -1.260, 0.636> <-0.672, -1.260, 0.622> 
		<-0.600, -1.500, 0.637> <-0.620, -1.500, 0.637> <-0.647, -1.500, 0.626> <-0.661, -1.500, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.682, -0.700, 0.632> <-0.701, -0.700, 0.613> <-0.716, -0.700, 0.577> <-0.716, -0.700, 0.550> 
		<-0.687, -0.940, 0.637> <-0.706, -0.940, 0.618> <-0.723, -0.940, 0.577> <-0.723, -0.940, 0.550> 
		<-0.672, -1.260, 0.622> <-0.686, -1.260, 0.608> <-0.702, -1.260, 0.570> <-0.702, -1.260, 0.550> 
		<-0.661, -1.500, 0.611> <-0.676, -1.500, 0.597> <-0.687, -1.500, 0.570> <-0.687, -1.500, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.716, -0.700, 0.550> <-0.716, -0.700, 0.523> <-0.701, -0.700, 0.487> <-0.682, -0.700, 0.468> 
		<-0.723, -0.940, 0.550> <-0.723, -0.940, 0.523> <-0.706, -0.940, 0.482> <-0.687, -0.940, 0.463> 
		<-0.702, -1.260, 0.550> <-0.702, -1.260, 0.530> <-0.686, -1.260, 0.492> <-0.672, -1.260, 0.478> 
		<-0.687, -1.500, 0.550> <-0.687, -1.500, 0.530> <-0.676, -1.500, 0.503> <-0.661, -1.500, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.682, -0.700, 0.468> <-0.663, -0.700, 0.449> <-0.627, -0.700, 0.434> <-0.600, -0.700, 0.434> 
		<-0.687, -0.940, 0.463> <-0.668, -0.940, 0.444> <-0.627, -0.940, 0.427> <-0.600, -0.940, 0.427> 
		<-0.672, -1.260, 0.478> <-0.658, -1.260, 0.464> <-0.620, -1.260, 0.448> <-0.600, -1.260, 0.448> 
		<-0.661, -1.500, 0.489> <-0.647, -1.500, 0.474> <-0.620, -1.500, 0.463> <-0.600, -1.500, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -0.700, 0.434> <-0.573, -0.700, 0.434> <-0.537, -0.700, 0.449> <-0.518, -0.700, 0.468> 
		<-0.600, -0.940, 0.427> <-0.573, -0.940, 0.427> <-0.532, -0.940, 0.444> <-0.513, -0.940, 0.463> 
		<-0.600, -1.260, 0.448> <-0.580, -1.260, 0.448> <-0.542, -1.260, 0.464> <-0.528, -1.260, 0.478> 
		<-0.600, -1.500, 0.463> <-0.580, -1.500, 0.463> <-0.553, -1.500, 0.474> <-0.539, -1.500, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.539, -1.500, 0.611> <-0.553, -1.500, 0.626> <-0.580, -1.500, 0.637> <-0.600, -1.500, 0.637> 
		<-0.540, -1.531, 0.610> <-0.554, -1.531, 0.624> <-0.580, -1.531, 0.635> <-0.600, -1.531, 0.635> 
		<-0.559, -1.569, 0.591> <-0.568, -1.569, 0.600> <-0.587, -1.569, 0.608> <-0.600, -1.569, 0.608> 
		<-0.559, -1.600, 0.591> <-0.568, -1.600, 0.600> <-0.587, -1.600, 0.608> <-0.600, -1.600, 0.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -1.500, 0.637> <-0.620, -1.500, 0.637> <-0.647, -1.500, 0.626> <-0.661, -1.500, 0.611> 
		<-0.600, -1.531, 0.635> <-0.620, -1.531, 0.635> <-0.646, -1.531, 0.624> <-0.660, -1.531, 0.610> 
		<-0.600, -1.569, 0.608> <-0.613, -1.569, 0.608> <-0.632, -1.569, 0.600> <-0.641, -1.569, 0.591> 
		<-0.600, -1.600, 0.608> <-0.613, -1.600, 0.608> <-0.632, -1.600, 0.600> <-0.641, -1.600, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, -1.500, 0.611> <-0.676, -1.500, 0.597> <-0.687, -1.500, 0.570> <-0.687, -1.500, 0.550> 
		<-0.660, -1.531, 0.610> <-0.674, -1.531, 0.596> <-0.685, -1.531, 0.570> <-0.685, -1.531, 0.550> 
		<-0.641, -1.569, 0.591> <-0.650, -1.569, 0.582> <-0.658, -1.569, 0.563> <-0.658, -1.569, 0.550> 
		<-0.641, -1.600, 0.591> <-0.650, -1.600, 0.582> <-0.658, -1.600, 0.563> <-0.658, -1.600, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.687, -1.500, 0.550> <-0.687, -1.500, 0.530> <-0.676, -1.500, 0.503> <-0.661, -1.500, 0.489> 
		<-0.685, -1.531, 0.550> <-0.685, -1.531, 0.530> <-0.674, -1.531, 0.504> <-0.660, -1.531, 0.490> 
		<-0.658, -1.569, 0.550> <-0.658, -1.569, 0.537> <-0.650, -1.569, 0.518> <-0.641, -1.569, 0.509> 
		<-0.658, -1.600, 0.550> <-0.658, -1.600, 0.537> <-0.650, -1.600, 0.518> <-0.641, -1.600, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, -1.500, 0.489> <-0.647, -1.500, 0.474> <-0.620, -1.500, 0.463> <-0.600, -1.500, 0.463> 
		<-0.660, -1.531, 0.490> <-0.646, -1.531, 0.476> <-0.620, -1.531, 0.465> <-0.600, -1.531, 0.465> 
		<-0.641, -1.569, 0.509> <-0.632, -1.569, 0.500> <-0.613, -1.569, 0.492> <-0.600, -1.569, 0.492> 
		<-0.641, -1.600, 0.509> <-0.632, -1.600, 0.500> <-0.613, -1.600, 0.492> <-0.600, -1.600, 0.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -1.500, 0.463> <-0.580, -1.500, 0.463> <-0.553, -1.500, 0.474> <-0.539, -1.500, 0.489> 
		<-0.600, -1.531, 0.465> <-0.580, -1.531, 0.465> <-0.554, -1.531, 0.476> <-0.540, -1.531, 0.490> 
		<-0.600, -1.569, 0.492> <-0.587, -1.569, 0.492> <-0.568, -1.569, 0.500> <-0.559, -1.569, 0.509> 
		<-0.600, -1.600, 0.492> <-0.587, -1.600, 0.492> <-0.568, -1.600, 0.500> <-0.559, -1.600, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.559, -1.600, 0.591> <-0.568, -1.600, 0.600> <-0.587, -1.600, 0.608> <-0.600, -1.600, 0.608> 
		<-0.559, -1.646, 0.591> <-0.568, -1.646, 0.600> <-0.587, -1.646, 0.608> <-0.600, -1.646, 0.608> 
		<-0.539, -1.704, 0.611> <-0.553, -1.704, 0.626> <-0.580, -1.704, 0.637> <-0.600, -1.704, 0.637> 
		<-0.539, -1.750, 0.611> <-0.553, -1.750, 0.626> <-0.580, -1.750, 0.637> <-0.600, -1.750, 0.637> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -1.600, 0.608> <-0.613, -1.600, 0.608> <-0.632, -1.600, 0.600> <-0.641, -1.600, 0.591> 
		<-0.600, -1.646, 0.608> <-0.613, -1.646, 0.608> <-0.632, -1.646, 0.600> <-0.641, -1.646, 0.591> 
		<-0.600, -1.704, 0.637> <-0.620, -1.704, 0.637> <-0.647, -1.704, 0.626> <-0.661, -1.704, 0.611> 
		<-0.600, -1.750, 0.637> <-0.620, -1.750, 0.637> <-0.647, -1.750, 0.626> <-0.661, -1.750, 0.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, -1.600, 0.591> <-0.650, -1.600, 0.582> <-0.658, -1.600, 0.563> <-0.658, -1.600, 0.550> 
		<-0.641, -1.646, 0.591> <-0.650, -1.646, 0.582> <-0.658, -1.646, 0.563> <-0.658, -1.646, 0.550> 
		<-0.661, -1.704, 0.611> <-0.676, -1.704, 0.597> <-0.687, -1.704, 0.570> <-0.687, -1.704, 0.550> 
		<-0.661, -1.750, 0.611> <-0.676, -1.750, 0.597> <-0.687, -1.750, 0.570> <-0.687, -1.750, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, -1.600, 0.550> <-0.658, -1.600, 0.537> <-0.650, -1.600, 0.518> <-0.641, -1.600, 0.509> 
		<-0.658, -1.646, 0.550> <-0.658, -1.646, 0.537> <-0.650, -1.646, 0.518> <-0.641, -1.646, 0.509> 
		<-0.687, -1.704, 0.550> <-0.687, -1.704, 0.530> <-0.676, -1.704, 0.503> <-0.661, -1.704, 0.489> 
		<-0.687, -1.750, 0.550> <-0.687, -1.750, 0.530> <-0.676, -1.750, 0.503> <-0.661, -1.750, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, -1.600, 0.509> <-0.632, -1.600, 0.500> <-0.613, -1.600, 0.492> <-0.600, -1.600, 0.492> 
		<-0.641, -1.646, 0.509> <-0.632, -1.646, 0.500> <-0.613, -1.646, 0.492> <-0.600, -1.646, 0.492> 
		<-0.661, -1.704, 0.489> <-0.647, -1.704, 0.474> <-0.620, -1.704, 0.463> <-0.600, -1.704, 0.463> 
		<-0.661, -1.750, 0.489> <-0.647, -1.750, 0.474> <-0.620, -1.750, 0.463> <-0.600, -1.750, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -1.600, 0.492> <-0.587, -1.600, 0.492> <-0.568, -1.600, 0.500> <-0.559, -1.600, 0.509> 
		<-0.600, -1.646, 0.492> <-0.587, -1.646, 0.492> <-0.568, -1.646, 0.500> <-0.559, -1.646, 0.509> 
		<-0.600, -1.704, 0.463> <-0.580, -1.704, 0.463> <-0.553, -1.704, 0.474> <-0.539, -1.704, 0.489> 
		<-0.600, -1.750, 0.463> <-0.580, -1.750, 0.463> <-0.553, -1.750, 0.474> <-0.539, -1.750, 0.489> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.539, -1.750, 0.611> <-0.553, -1.750, 0.626> <-0.580, -1.750, 0.637> <-0.600, -1.750, 0.637> 
		<-0.539, -1.767, 0.611> <-0.553, -1.767, 0.626> <-0.580, -1.767, 0.637> <-0.600, -1.767, 0.637> 
		<-0.553, -1.785, 0.597> <-0.562, -1.785, 0.606> <-0.587, -1.785, 0.617> <-0.600, -1.785, 0.617> 
		<-0.559, -1.800, 0.591> <-0.568, -1.800, 0.600> <-0.587, -1.800, 0.608> <-0.600, -1.800, 0.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -1.750, 0.637> <-0.620, -1.750, 0.637> <-0.647, -1.750, 0.626> <-0.661, -1.750, 0.611> 
		<-0.600, -1.767, 0.637> <-0.620, -1.767, 0.637> <-0.647, -1.767, 0.626> <-0.661, -1.767, 0.611> 
		<-0.600, -1.785, 0.617> <-0.613, -1.785, 0.617> <-0.638, -1.785, 0.606> <-0.647, -1.785, 0.597> 
		<-0.600, -1.800, 0.608> <-0.613, -1.800, 0.608> <-0.632, -1.800, 0.600> <-0.641, -1.800, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, -1.750, 0.611> <-0.676, -1.750, 0.597> <-0.687, -1.750, 0.570> <-0.687, -1.750, 0.550> 
		<-0.661, -1.767, 0.611> <-0.676, -1.767, 0.597> <-0.687, -1.767, 0.570> <-0.687, -1.767, 0.550> 
		<-0.647, -1.785, 0.597> <-0.656, -1.785, 0.588> <-0.667, -1.785, 0.563> <-0.667, -1.785, 0.550> 
		<-0.641, -1.800, 0.591> <-0.650, -1.800, 0.582> <-0.658, -1.800, 0.563> <-0.658, -1.800, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.687, -1.750, 0.550> <-0.687, -1.750, 0.530> <-0.676, -1.750, 0.503> <-0.661, -1.750, 0.489> 
		<-0.687, -1.767, 0.550> <-0.687, -1.767, 0.530> <-0.676, -1.767, 0.503> <-0.661, -1.767, 0.489> 
		<-0.667, -1.785, 0.550> <-0.667, -1.785, 0.537> <-0.656, -1.785, 0.512> <-0.647, -1.785, 0.503> 
		<-0.658, -1.800, 0.550> <-0.658, -1.800, 0.537> <-0.650, -1.800, 0.518> <-0.641, -1.800, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, -1.750, 0.489> <-0.647, -1.750, 0.474> <-0.620, -1.750, 0.463> <-0.600, -1.750, 0.463> 
		<-0.661, -1.767, 0.489> <-0.647, -1.767, 0.474> <-0.620, -1.767, 0.463> <-0.600, -1.767, 0.463> 
		<-0.647, -1.785, 0.503> <-0.638, -1.785, 0.494> <-0.613, -1.785, 0.483> <-0.600, -1.785, 0.483> 
		<-0.641, -1.800, 0.509> <-0.632, -1.800, 0.500> <-0.613, -1.800, 0.492> <-0.600, -1.800, 0.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, -1.750, 0.463> <-0.580, -1.750, 0.463> <-0.553, -1.750, 0.474> <-0.539, -1.750, 0.489> 
		<-0.600, -1.767, 0.463> <-0.580, -1.767, 0.463> <-0.553, -1.767, 0.474> <-0.539, -1.767, 0.489> 
		<-0.600, -1.785, 0.483> <-0.587, -1.785, 0.483> <-0.562, -1.785, 0.494> <-0.553, -1.785, 0.503> 
		<-0.600, -1.800, 0.492> <-0.587, -1.800, 0.492> <-0.568, -1.800, 0.500> <-0.559, -1.800, 0.509> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, -1.800, -0.500> <-0.342, -1.800, -0.513> <-0.350, -1.800, -0.532> <-0.359, -1.800, -0.541> 
		<-0.333, -1.785, -0.500> <-0.333, -1.785, -0.513> <-0.344, -1.785, -0.538> <-0.353, -1.785, -0.547> 
		<-0.313, -1.767, -0.500> <-0.313, -1.767, -0.520> <-0.324, -1.767, -0.547> <-0.339, -1.767, -0.561> 
		<-0.313, -1.750, -0.500> <-0.313, -1.750, -0.520> <-0.324, -1.750, -0.547> <-0.339, -1.750, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, -1.800, -0.500> <-0.333, -1.785, -0.500> <-0.313, -1.767, -0.500> <-0.313, -1.750, -0.500> 
		<-0.342, -1.800, -0.487> <-0.333, -1.785, -0.487> <-0.313, -1.767, -0.480> <-0.313, -1.750, -0.480> 
		<-0.350, -1.800, -0.468> <-0.344, -1.785, -0.462> <-0.324, -1.767, -0.453> <-0.324, -1.750, -0.453> 
		<-0.359, -1.800, -0.459> <-0.353, -1.785, -0.453> <-0.339, -1.767, -0.439> <-0.339, -1.750, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.313, -1.750, -0.500> <-0.313, -1.750, -0.520> <-0.324, -1.750, -0.547> <-0.339, -1.750, -0.561> 
		<-0.313, -1.704, -0.500> <-0.313, -1.704, -0.520> <-0.324, -1.704, -0.547> <-0.339, -1.704, -0.561> 
		<-0.342, -1.646, -0.500> <-0.342, -1.646, -0.513> <-0.350, -1.646, -0.532> <-0.359, -1.646, -0.541> 
		<-0.342, -1.600, -0.500> <-0.342, -1.600, -0.513> <-0.350, -1.600, -0.532> <-0.359, -1.600, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.313, -1.750, -0.500> <-0.313, -1.704, -0.500> <-0.342, -1.646, -0.500> <-0.342, -1.600, -0.500> 
		<-0.313, -1.750, -0.480> <-0.313, -1.704, -0.480> <-0.342, -1.646, -0.487> <-0.342, -1.600, -0.487> 
		<-0.324, -1.750, -0.453> <-0.324, -1.704, -0.453> <-0.350, -1.646, -0.468> <-0.350, -1.600, -0.468> 
		<-0.339, -1.750, -0.439> <-0.339, -1.704, -0.439> <-0.359, -1.646, -0.459> <-0.359, -1.600, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, -1.600, -0.500> <-0.342, -1.600, -0.513> <-0.350, -1.600, -0.532> <-0.359, -1.600, -0.541> 
		<-0.342, -1.569, -0.500> <-0.342, -1.569, -0.513> <-0.350, -1.569, -0.532> <-0.359, -1.569, -0.541> 
		<-0.315, -1.531, -0.500> <-0.315, -1.531, -0.520> <-0.326, -1.531, -0.546> <-0.340, -1.531, -0.560> 
		<-0.313, -1.500, -0.500> <-0.313, -1.500, -0.520> <-0.324, -1.500, -0.547> <-0.339, -1.500, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, -1.600, -0.500> <-0.342, -1.569, -0.500> <-0.315, -1.531, -0.500> <-0.313, -1.500, -0.500> 
		<-0.342, -1.600, -0.487> <-0.342, -1.569, -0.487> <-0.315, -1.531, -0.480> <-0.313, -1.500, -0.480> 
		<-0.350, -1.600, -0.468> <-0.350, -1.569, -0.468> <-0.326, -1.531, -0.454> <-0.324, -1.500, -0.453> 
		<-0.359, -1.600, -0.459> <-0.359, -1.569, -0.459> <-0.340, -1.531, -0.440> <-0.339, -1.500, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.313, -1.500, -0.500> <-0.313, -1.500, -0.520> <-0.324, -1.500, -0.547> <-0.339, -1.500, -0.561> 
		<-0.298, -1.260, -0.500> <-0.298, -1.260, -0.520> <-0.314, -1.260, -0.558> <-0.328, -1.260, -0.572> 
		<-0.277, -0.940, -0.500> <-0.277, -0.940, -0.527> <-0.294, -0.940, -0.568> <-0.313, -0.940, -0.587> 
		<-0.284, -0.700, -0.500> <-0.284, -0.700, -0.527> <-0.299, -0.700, -0.563> <-0.318, -0.700, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.313, -1.500, -0.500> <-0.298, -1.260, -0.500> <-0.277, -0.940, -0.500> <-0.284, -0.700, -0.500> 
		<-0.313, -1.500, -0.480> <-0.298, -1.260, -0.480> <-0.277, -0.940, -0.473> <-0.284, -0.700, -0.473> 
		<-0.324, -1.500, -0.453> <-0.314, -1.260, -0.442> <-0.294, -0.940, -0.432> <-0.299, -0.700, -0.437> 
		<-0.339, -1.500, -0.439> <-0.328, -1.260, -0.428> <-0.313, -0.940, -0.413> <-0.318, -0.700, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.284, -0.700, -0.500> <-0.284, -0.700, -0.527> <-0.299, -0.700, -0.563> <-0.318, -0.700, -0.582> 
		<-0.286, -0.638, -0.500> <-0.286, -0.638, -0.527> <-0.301, -0.638, -0.562> <-0.319, -0.638, -0.581> 
		<-0.336, -0.562, -0.500> <-0.336, -0.562, -0.513> <-0.345, -0.562, -0.536> <-0.355, -0.562, -0.545> 
		<-0.342, -0.500, -0.500> <-0.342, -0.500, -0.513> <-0.350, -0.500, -0.532> <-0.359, -0.500, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.284, -0.700, -0.500> <-0.286, -0.638, -0.500> <-0.336, -0.562, -0.500> <-0.342, -0.500, -0.500> 
		<-0.284, -0.700, -0.473> <-0.286, -0.638, -0.473> <-0.336, -0.562, -0.487> <-0.342, -0.500, -0.487> 
		<-0.299, -0.700, -0.437> <-0.301, -0.638, -0.438> <-0.345, -0.562, -0.464> <-0.350, -0.500, -0.468> 
		<-0.318, -0.700, -0.418> <-0.319, -0.638, -0.419> <-0.355, -0.562, -0.455> <-0.359, -0.500, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, -0.500, -0.500> <-0.342, -0.500, -0.513> <-0.350, -0.500, -0.532> <-0.359, -0.500, -0.541> 
		<-0.345, -0.469, -0.500> <-0.345, -0.469, -0.513> <-0.352, -0.469, -0.529> <-0.361, -0.469, -0.539> 
		<-0.318, -0.431, -0.500> <-0.318, -0.431, -0.520> <-0.328, -0.431, -0.544> <-0.342, -0.431, -0.558> 
		<-0.313, -0.400, -0.500> <-0.313, -0.400, -0.520> <-0.324, -0.400, -0.547> <-0.339, -0.400, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, -0.500, -0.500> <-0.345, -0.469, -0.500> <-0.318, -0.431, -0.500> <-0.313, -0.400, -0.500> 
		<-0.342, -0.500, -0.487> <-0.345, -0.469, -0.487> <-0.318, -0.431, -0.480> <-0.313, -0.400, -0.480> 
		<-0.350, -0.500, -0.468> <-0.352, -0.469, -0.471> <-0.328, -0.431, -0.456> <-0.324, -0.400, -0.453> 
		<-0.359, -0.500, -0.459> <-0.361, -0.469, -0.461> <-0.342, -0.431, -0.442> <-0.339, -0.400, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.313, -0.400, -0.500> <-0.313, -0.400, -0.520> <-0.324, -0.400, -0.547> <-0.339, -0.400, -0.561> 
		<-0.300, -0.311, -0.500> <-0.300, -0.311, -0.520> <-0.315, -0.311, -0.556> <-0.329, -0.311, -0.571> 
		<-0.278, -0.190, -0.500> <-0.278, -0.190, -0.527> <-0.295, -0.190, -0.568> <-0.313, -0.190, -0.587> 
		<-0.284, -0.100, -0.500> <-0.284, -0.100, -0.527> <-0.299, -0.100, -0.563> <-0.318, -0.100, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.313, -0.400, -0.500> <-0.300, -0.311, -0.500> <-0.278, -0.190, -0.500> <-0.284, -0.100, -0.500> 
		<-0.313, -0.400, -0.480> <-0.300, -0.311, -0.480> <-0.278, -0.190, -0.473> <-0.284, -0.100, -0.473> 
		<-0.324, -0.400, -0.453> <-0.315, -0.311, -0.444> <-0.295, -0.190, -0.432> <-0.299, -0.100, -0.437> 
		<-0.339, -0.400, -0.439> <-0.329, -0.311, -0.429> <-0.313, -0.190, -0.413> <-0.318, -0.100, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, 0.000, -0.500> <-0.325, -0.030, -0.500> <-0.287, -0.065, -0.500> <-0.284, -0.100, -0.500> 
		<-0.342, 0.000, -0.513> <-0.325, -0.030, -0.513> <-0.287, -0.065, -0.527> <-0.284, -0.100, -0.527> 
		<-0.350, 0.000, -0.532> <-0.337, -0.030, -0.544> <-0.301, -0.065, -0.561> <-0.299, -0.100, -0.563> 
		<-0.359, 0.000, -0.541> <-0.347, -0.030, -0.553> <-0.320, -0.065, -0.580> <-0.318, -0.100, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, 0.000, -0.500> <-0.342, 0.000, -0.487> <-0.350, 0.000, -0.468> <-0.359, 0.000, -0.459> 
		<-0.325, -0.030, -0.500> <-0.325, -0.030, -0.487> <-0.337, -0.030, -0.456> <-0.347, -0.030, -0.447> 
		<-0.287, -0.065, -0.500> <-0.287, -0.065, -0.473> <-0.301, -0.065, -0.439> <-0.320, -0.065, -0.420> 
		<-0.284, -0.100, -0.500> <-0.284, -0.100, -0.473> <-0.299, -0.100, -0.437> <-0.318, -0.100, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.359, 0.000, -0.459> <-0.368, 0.000, -0.450> <-0.387, 0.000, -0.442> <-0.400, 0.000, -0.442> 
		<-0.347, -0.030, -0.447> <-0.356, -0.030, -0.437> <-0.387, -0.030, -0.425> <-0.400, -0.030, -0.425> 
		<-0.320, -0.065, -0.420> <-0.339, -0.065, -0.401> <-0.373, -0.065, -0.387> <-0.400, -0.065, -0.387> 
		<-0.318, -0.100, -0.418> <-0.337, -0.100, -0.399> <-0.373, -0.100, -0.384> <-0.400, -0.100, -0.384> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 0.000, -0.442> <-0.413, 0.000, -0.442> <-0.432, 0.000, -0.450> <-0.441, 0.000, -0.459> 
		<-0.400, -0.030, -0.425> <-0.413, -0.030, -0.425> <-0.444, -0.030, -0.437> <-0.453, -0.030, -0.447> 
		<-0.400, -0.065, -0.387> <-0.427, -0.065, -0.387> <-0.461, -0.065, -0.401> <-0.480, -0.065, -0.420> 
		<-0.400, -0.100, -0.384> <-0.427, -0.100, -0.384> <-0.463, -0.100, -0.399> <-0.482, -0.100, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, 0.000, -0.459> <-0.450, 0.000, -0.468> <-0.458, 0.000, -0.487> <-0.458, 0.000, -0.500> 
		<-0.453, -0.030, -0.447> <-0.463, -0.030, -0.456> <-0.475, -0.030, -0.487> <-0.475, -0.030, -0.500> 
		<-0.480, -0.065, -0.420> <-0.499, -0.065, -0.439> <-0.513, -0.065, -0.473> <-0.513, -0.065, -0.500> 
		<-0.482, -0.100, -0.418> <-0.501, -0.100, -0.437> <-0.516, -0.100, -0.473> <-0.516, -0.100, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.458, 0.000, -0.500> <-0.458, 0.000, -0.513> <-0.450, 0.000, -0.532> <-0.441, 0.000, -0.541> 
		<-0.475, -0.030, -0.500> <-0.475, -0.030, -0.513> <-0.463, -0.030, -0.544> <-0.453, -0.030, -0.553> 
		<-0.513, -0.065, -0.500> <-0.513, -0.065, -0.527> <-0.499, -0.065, -0.561> <-0.480, -0.065, -0.580> 
		<-0.516, -0.100, -0.500> <-0.516, -0.100, -0.527> <-0.501, -0.100, -0.563> <-0.482, -0.100, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, 0.000, -0.541> <-0.432, 0.000, -0.550> <-0.413, 0.000, -0.558> <-0.400, 0.000, -0.558> 
		<-0.453, -0.030, -0.553> <-0.444, -0.030, -0.563> <-0.413, -0.030, -0.575> <-0.400, -0.030, -0.575> 
		<-0.480, -0.065, -0.580> <-0.461, -0.065, -0.599> <-0.427, -0.065, -0.613> <-0.400, -0.065, -0.613> 
		<-0.482, -0.100, -0.582> <-0.463, -0.100, -0.601> <-0.427, -0.100, -0.616> <-0.400, -0.100, -0.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 0.000, -0.558> <-0.387, 0.000, -0.558> <-0.368, 0.000, -0.550> <-0.359, 0.000, -0.541> 
		<-0.400, -0.030, -0.575> <-0.387, -0.030, -0.575> <-0.356, -0.030, -0.563> <-0.347, -0.030, -0.553> 
		<-0.400, -0.065, -0.613> <-0.373, -0.065, -0.613> <-0.339, -0.065, -0.599> <-0.320, -0.065, -0.580> 
		<-0.400, -0.100, -0.616> <-0.373, -0.100, -0.616> <-0.337, -0.100, -0.601> <-0.318, -0.100, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.318, -0.100, -0.418> <-0.337, -0.100, -0.399> <-0.373, -0.100, -0.384> <-0.400, -0.100, -0.384> 
		<-0.313, -0.190, -0.413> <-0.332, -0.190, -0.395> <-0.373, -0.190, -0.378> <-0.400, -0.190, -0.378> 
		<-0.329, -0.311, -0.429> <-0.344, -0.311, -0.415> <-0.380, -0.311, -0.400> <-0.400, -0.311, -0.400> 
		<-0.339, -0.400, -0.439> <-0.353, -0.400, -0.424> <-0.380, -0.400, -0.413> <-0.400, -0.400, -0.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -0.100, -0.384> <-0.427, -0.100, -0.384> <-0.463, -0.100, -0.399> <-0.482, -0.100, -0.418> 
		<-0.400, -0.190, -0.378> <-0.427, -0.190, -0.378> <-0.468, -0.190, -0.395> <-0.487, -0.190, -0.413> 
		<-0.400, -0.311, -0.400> <-0.420, -0.311, -0.400> <-0.456, -0.311, -0.415> <-0.471, -0.311, -0.429> 
		<-0.400, -0.400, -0.413> <-0.420, -0.400, -0.413> <-0.447, -0.400, -0.424> <-0.461, -0.400, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.482, -0.100, -0.418> <-0.501, -0.100, -0.437> <-0.516, -0.100, -0.473> <-0.516, -0.100, -0.500> 
		<-0.487, -0.190, -0.413> <-0.505, -0.190, -0.432> <-0.522, -0.190, -0.473> <-0.522, -0.190, -0.500> 
		<-0.471, -0.311, -0.429> <-0.485, -0.311, -0.444> <-0.500, -0.311, -0.480> <-0.500, -0.311, -0.500> 
		<-0.461, -0.400, -0.439> <-0.476, -0.400, -0.453> <-0.487, -0.400, -0.480> <-0.487, -0.400, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.516, -0.100, -0.500> <-0.516, -0.100, -0.527> <-0.501, -0.100, -0.563> <-0.482, -0.100, -0.582> 
		<-0.522, -0.190, -0.500> <-0.522, -0.190, -0.527> <-0.505, -0.190, -0.568> <-0.487, -0.190, -0.587> 
		<-0.500, -0.311, -0.500> <-0.500, -0.311, -0.520> <-0.485, -0.311, -0.556> <-0.471, -0.311, -0.571> 
		<-0.487, -0.400, -0.500> <-0.487, -0.400, -0.520> <-0.476, -0.400, -0.547> <-0.461, -0.400, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.482, -0.100, -0.582> <-0.463, -0.100, -0.601> <-0.427, -0.100, -0.616> <-0.400, -0.100, -0.616> 
		<-0.487, -0.190, -0.587> <-0.468, -0.190, -0.605> <-0.427, -0.190, -0.622> <-0.400, -0.190, -0.622> 
		<-0.471, -0.311, -0.571> <-0.456, -0.311, -0.585> <-0.420, -0.311, -0.600> <-0.400, -0.311, -0.600> 
		<-0.461, -0.400, -0.561> <-0.447, -0.400, -0.576> <-0.420, -0.400, -0.587> <-0.400, -0.400, -0.587> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -0.100, -0.616> <-0.373, -0.100, -0.616> <-0.337, -0.100, -0.601> <-0.318, -0.100, -0.582> 
		<-0.400, -0.190, -0.622> <-0.373, -0.190, -0.622> <-0.332, -0.190, -0.605> <-0.313, -0.190, -0.587> 
		<-0.400, -0.311, -0.600> <-0.380, -0.311, -0.600> <-0.344, -0.311, -0.585> <-0.329, -0.311, -0.571> 
		<-0.400, -0.400, -0.587> <-0.380, -0.400, -0.587> <-0.353, -0.400, -0.576> <-0.339, -0.400, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.339, -0.400, -0.439> <-0.353, -0.400, -0.424> <-0.380, -0.400, -0.413> <-0.400, -0.400, -0.413> 
		<-0.342, -0.431, -0.442> <-0.356, -0.431, -0.428> <-0.380, -0.431, -0.418> <-0.400, -0.431, -0.418> 
		<-0.361, -0.469, -0.461> <-0.371, -0.469, -0.452> <-0.387, -0.469, -0.445> <-0.400, -0.469, -0.445> 
		<-0.359, -0.500, -0.459> <-0.368, -0.500, -0.450> <-0.387, -0.500, -0.442> <-0.400, -0.500, -0.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -0.400, -0.413> <-0.420, -0.400, -0.413> <-0.447, -0.400, -0.424> <-0.461, -0.400, -0.439> 
		<-0.400, -0.431, -0.418> <-0.420, -0.431, -0.418> <-0.444, -0.431, -0.428> <-0.458, -0.431, -0.442> 
		<-0.400, -0.469, -0.445> <-0.413, -0.469, -0.445> <-0.429, -0.469, -0.452> <-0.439, -0.469, -0.461> 
		<-0.400, -0.500, -0.442> <-0.413, -0.500, -0.442> <-0.432, -0.500, -0.450> <-0.441, -0.500, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.461, -0.400, -0.439> <-0.476, -0.400, -0.453> <-0.487, -0.400, -0.480> <-0.487, -0.400, -0.500> 
		<-0.458, -0.431, -0.442> <-0.472, -0.431, -0.456> <-0.482, -0.431, -0.480> <-0.482, -0.431, -0.500> 
		<-0.439, -0.469, -0.461> <-0.448, -0.469, -0.471> <-0.455, -0.469, -0.487> <-0.455, -0.469, -0.500> 
		<-0.441, -0.500, -0.459> <-0.450, -0.500, -0.468> <-0.458, -0.500, -0.487> <-0.458, -0.500, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.487, -0.400, -0.500> <-0.487, -0.400, -0.520> <-0.476, -0.400, -0.547> <-0.461, -0.400, -0.561> 
		<-0.482, -0.431, -0.500> <-0.482, -0.431, -0.520> <-0.472, -0.431, -0.544> <-0.458, -0.431, -0.558> 
		<-0.455, -0.469, -0.500> <-0.455, -0.469, -0.513> <-0.448, -0.469, -0.529> <-0.439, -0.469, -0.539> 
		<-0.458, -0.500, -0.500> <-0.458, -0.500, -0.513> <-0.450, -0.500, -0.532> <-0.441, -0.500, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.461, -0.400, -0.561> <-0.447, -0.400, -0.576> <-0.420, -0.400, -0.587> <-0.400, -0.400, -0.587> 
		<-0.458, -0.431, -0.558> <-0.444, -0.431, -0.572> <-0.420, -0.431, -0.582> <-0.400, -0.431, -0.582> 
		<-0.439, -0.469, -0.539> <-0.429, -0.469, -0.548> <-0.413, -0.469, -0.555> <-0.400, -0.469, -0.555> 
		<-0.441, -0.500, -0.541> <-0.432, -0.500, -0.550> <-0.413, -0.500, -0.558> <-0.400, -0.500, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -0.400, -0.587> <-0.380, -0.400, -0.587> <-0.353, -0.400, -0.576> <-0.339, -0.400, -0.561> 
		<-0.400, -0.431, -0.582> <-0.380, -0.431, -0.582> <-0.356, -0.431, -0.572> <-0.342, -0.431, -0.558> 
		<-0.400, -0.469, -0.555> <-0.387, -0.469, -0.555> <-0.371, -0.469, -0.548> <-0.361, -0.469, -0.539> 
		<-0.400, -0.500, -0.558> <-0.387, -0.500, -0.558> <-0.368, -0.500, -0.550> <-0.359, -0.500, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.359, -0.500, -0.459> <-0.368, -0.500, -0.450> <-0.387, -0.500, -0.442> <-0.400, -0.500, -0.442> 
		<-0.355, -0.562, -0.455> <-0.364, -0.562, -0.445> <-0.387, -0.562, -0.436> <-0.400, -0.562, -0.436> 
		<-0.319, -0.638, -0.419> <-0.338, -0.638, -0.401> <-0.373, -0.638, -0.386> <-0.400, -0.638, -0.386> 
		<-0.318, -0.700, -0.418> <-0.337, -0.700, -0.399> <-0.373, -0.700, -0.384> <-0.400, -0.700, -0.384> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -0.500, -0.442> <-0.413, -0.500, -0.442> <-0.432, -0.500, -0.450> <-0.441, -0.500, -0.459> 
		<-0.400, -0.562, -0.436> <-0.413, -0.562, -0.436> <-0.436, -0.562, -0.445> <-0.445, -0.562, -0.455> 
		<-0.400, -0.638, -0.386> <-0.427, -0.638, -0.386> <-0.462, -0.638, -0.401> <-0.481, -0.638, -0.419> 
		<-0.400, -0.700, -0.384> <-0.427, -0.700, -0.384> <-0.463, -0.700, -0.399> <-0.482, -0.700, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, -0.500, -0.459> <-0.450, -0.500, -0.468> <-0.458, -0.500, -0.487> <-0.458, -0.500, -0.500> 
		<-0.445, -0.562, -0.455> <-0.455, -0.562, -0.464> <-0.464, -0.562, -0.487> <-0.464, -0.562, -0.500> 
		<-0.481, -0.638, -0.419> <-0.499, -0.638, -0.438> <-0.514, -0.638, -0.473> <-0.514, -0.638, -0.500> 
		<-0.482, -0.700, -0.418> <-0.501, -0.700, -0.437> <-0.516, -0.700, -0.473> <-0.516, -0.700, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.458, -0.500, -0.500> <-0.458, -0.500, -0.513> <-0.450, -0.500, -0.532> <-0.441, -0.500, -0.541> 
		<-0.464, -0.562, -0.500> <-0.464, -0.562, -0.513> <-0.455, -0.562, -0.536> <-0.445, -0.562, -0.545> 
		<-0.514, -0.638, -0.500> <-0.514, -0.638, -0.527> <-0.499, -0.638, -0.562> <-0.481, -0.638, -0.581> 
		<-0.516, -0.700, -0.500> <-0.516, -0.700, -0.527> <-0.501, -0.700, -0.563> <-0.482, -0.700, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, -0.500, -0.541> <-0.432, -0.500, -0.550> <-0.413, -0.500, -0.558> <-0.400, -0.500, -0.558> 
		<-0.445, -0.562, -0.545> <-0.436, -0.562, -0.555> <-0.413, -0.562, -0.564> <-0.400, -0.562, -0.564> 
		<-0.481, -0.638, -0.581> <-0.462, -0.638, -0.599> <-0.427, -0.638, -0.614> <-0.400, -0.638, -0.614> 
		<-0.482, -0.700, -0.582> <-0.463, -0.700, -0.601> <-0.427, -0.700, -0.616> <-0.400, -0.700, -0.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -0.500, -0.558> <-0.387, -0.500, -0.558> <-0.368, -0.500, -0.550> <-0.359, -0.500, -0.541> 
		<-0.400, -0.562, -0.564> <-0.387, -0.562, -0.564> <-0.364, -0.562, -0.555> <-0.355, -0.562, -0.545> 
		<-0.400, -0.638, -0.614> <-0.373, -0.638, -0.614> <-0.338, -0.638, -0.599> <-0.319, -0.638, -0.581> 
		<-0.400, -0.700, -0.616> <-0.373, -0.700, -0.616> <-0.337, -0.700, -0.601> <-0.318, -0.700, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.318, -0.700, -0.418> <-0.337, -0.700, -0.399> <-0.373, -0.700, -0.384> <-0.400, -0.700, -0.384> 
		<-0.313, -0.940, -0.413> <-0.332, -0.940, -0.394> <-0.373, -0.940, -0.377> <-0.400, -0.940, -0.377> 
		<-0.328, -1.260, -0.428> <-0.342, -1.260, -0.414> <-0.380, -1.260, -0.398> <-0.400, -1.260, -0.398> 
		<-0.339, -1.500, -0.439> <-0.353, -1.500, -0.424> <-0.380, -1.500, -0.413> <-0.400, -1.500, -0.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -0.700, -0.384> <-0.427, -0.700, -0.384> <-0.463, -0.700, -0.399> <-0.482, -0.700, -0.418> 
		<-0.400, -0.940, -0.377> <-0.427, -0.940, -0.377> <-0.468, -0.940, -0.394> <-0.487, -0.940, -0.413> 
		<-0.400, -1.260, -0.398> <-0.420, -1.260, -0.398> <-0.458, -1.260, -0.414> <-0.472, -1.260, -0.428> 
		<-0.400, -1.500, -0.413> <-0.420, -1.500, -0.413> <-0.447, -1.500, -0.424> <-0.461, -1.500, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.482, -0.700, -0.418> <-0.501, -0.700, -0.437> <-0.516, -0.700, -0.473> <-0.516, -0.700, -0.500> 
		<-0.487, -0.940, -0.413> <-0.506, -0.940, -0.432> <-0.523, -0.940, -0.473> <-0.523, -0.940, -0.500> 
		<-0.472, -1.260, -0.428> <-0.486, -1.260, -0.442> <-0.502, -1.260, -0.480> <-0.502, -1.260, -0.500> 
		<-0.461, -1.500, -0.439> <-0.476, -1.500, -0.453> <-0.487, -1.500, -0.480> <-0.487, -1.500, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.516, -0.700, -0.500> <-0.516, -0.700, -0.527> <-0.501, -0.700, -0.563> <-0.482, -0.700, -0.582> 
		<-0.523, -0.940, -0.500> <-0.523, -0.940, -0.527> <-0.506, -0.940, -0.568> <-0.487, -0.940, -0.587> 
		<-0.502, -1.260, -0.500> <-0.502, -1.260, -0.520> <-0.486, -1.260, -0.558> <-0.472, -1.260, -0.572> 
		<-0.487, -1.500, -0.500> <-0.487, -1.500, -0.520> <-0.476, -1.500, -0.547> <-0.461, -1.500, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.482, -0.700, -0.582> <-0.463, -0.700, -0.601> <-0.427, -0.700, -0.616> <-0.400, -0.700, -0.616> 
		<-0.487, -0.940, -0.587> <-0.468, -0.940, -0.606> <-0.427, -0.940, -0.623> <-0.400, -0.940, -0.623> 
		<-0.472, -1.260, -0.572> <-0.458, -1.260, -0.586> <-0.420, -1.260, -0.602> <-0.400, -1.260, -0.602> 
		<-0.461, -1.500, -0.561> <-0.447, -1.500, -0.576> <-0.420, -1.500, -0.587> <-0.400, -1.500, -0.587> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -0.700, -0.616> <-0.373, -0.700, -0.616> <-0.337, -0.700, -0.601> <-0.318, -0.700, -0.582> 
		<-0.400, -0.940, -0.623> <-0.373, -0.940, -0.623> <-0.332, -0.940, -0.606> <-0.313, -0.940, -0.587> 
		<-0.400, -1.260, -0.602> <-0.380, -1.260, -0.602> <-0.342, -1.260, -0.586> <-0.328, -1.260, -0.572> 
		<-0.400, -1.500, -0.587> <-0.380, -1.500, -0.587> <-0.353, -1.500, -0.576> <-0.339, -1.500, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.339, -1.500, -0.439> <-0.353, -1.500, -0.424> <-0.380, -1.500, -0.413> <-0.400, -1.500, -0.413> 
		<-0.340, -1.531, -0.440> <-0.354, -1.531, -0.426> <-0.380, -1.531, -0.415> <-0.400, -1.531, -0.415> 
		<-0.359, -1.569, -0.459> <-0.368, -1.569, -0.450> <-0.387, -1.569, -0.442> <-0.400, -1.569, -0.442> 
		<-0.359, -1.600, -0.459> <-0.368, -1.600, -0.450> <-0.387, -1.600, -0.442> <-0.400, -1.600, -0.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -1.500, -0.413> <-0.420, -1.500, -0.413> <-0.447, -1.500, -0.424> <-0.461, -1.500, -0.439> 
		<-0.400, -1.531, -0.415> <-0.420, -1.531, -0.415> <-0.446, -1.531, -0.426> <-0.460, -1.531, -0.440> 
		<-0.400, -1.569, -0.442> <-0.413, -1.569, -0.442> <-0.432, -1.569, -0.450> <-0.441, -1.569, -0.459> 
		<-0.400, -1.600, -0.442> <-0.413, -1.600, -0.442> <-0.432, -1.600, -0.450> <-0.441, -1.600, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.461, -1.500, -0.439> <-0.476, -1.500, -0.453> <-0.487, -1.500, -0.480> <-0.487, -1.500, -0.500> 
		<-0.460, -1.531, -0.440> <-0.474, -1.531, -0.454> <-0.485, -1.531, -0.480> <-0.485, -1.531, -0.500> 
		<-0.441, -1.569, -0.459> <-0.450, -1.569, -0.468> <-0.458, -1.569, -0.487> <-0.458, -1.569, -0.500> 
		<-0.441, -1.600, -0.459> <-0.450, -1.600, -0.468> <-0.458, -1.600, -0.487> <-0.458, -1.600, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.487, -1.500, -0.500> <-0.487, -1.500, -0.520> <-0.476, -1.500, -0.547> <-0.461, -1.500, -0.561> 
		<-0.485, -1.531, -0.500> <-0.485, -1.531, -0.520> <-0.474, -1.531, -0.546> <-0.460, -1.531, -0.560> 
		<-0.458, -1.569, -0.500> <-0.458, -1.569, -0.513> <-0.450, -1.569, -0.532> <-0.441, -1.569, -0.541> 
		<-0.458, -1.600, -0.500> <-0.458, -1.600, -0.513> <-0.450, -1.600, -0.532> <-0.441, -1.600, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.461, -1.500, -0.561> <-0.447, -1.500, -0.576> <-0.420, -1.500, -0.587> <-0.400, -1.500, -0.587> 
		<-0.460, -1.531, -0.560> <-0.446, -1.531, -0.574> <-0.420, -1.531, -0.585> <-0.400, -1.531, -0.585> 
		<-0.441, -1.569, -0.541> <-0.432, -1.569, -0.550> <-0.413, -1.569, -0.558> <-0.400, -1.569, -0.558> 
		<-0.441, -1.600, -0.541> <-0.432, -1.600, -0.550> <-0.413, -1.600, -0.558> <-0.400, -1.600, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -1.500, -0.587> <-0.380, -1.500, -0.587> <-0.353, -1.500, -0.576> <-0.339, -1.500, -0.561> 
		<-0.400, -1.531, -0.585> <-0.380, -1.531, -0.585> <-0.354, -1.531, -0.574> <-0.340, -1.531, -0.560> 
		<-0.400, -1.569, -0.558> <-0.387, -1.569, -0.558> <-0.368, -1.569, -0.550> <-0.359, -1.569, -0.541> 
		<-0.400, -1.600, -0.558> <-0.387, -1.600, -0.558> <-0.368, -1.600, -0.550> <-0.359, -1.600, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.359, -1.600, -0.459> <-0.368, -1.600, -0.450> <-0.387, -1.600, -0.442> <-0.400, -1.600, -0.442> 
		<-0.359, -1.646, -0.459> <-0.368, -1.646, -0.450> <-0.387, -1.646, -0.442> <-0.400, -1.646, -0.442> 
		<-0.339, -1.704, -0.439> <-0.353, -1.704, -0.424> <-0.380, -1.704, -0.413> <-0.400, -1.704, -0.413> 
		<-0.339, -1.750, -0.439> <-0.353, -1.750, -0.424> <-0.380, -1.750, -0.413> <-0.400, -1.750, -0.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -1.600, -0.442> <-0.413, -1.600, -0.442> <-0.432, -1.600, -0.450> <-0.441, -1.600, -0.459> 
		<-0.400, -1.646, -0.442> <-0.413, -1.646, -0.442> <-0.432, -1.646, -0.450> <-0.441, -1.646, -0.459> 
		<-0.400, -1.704, -0.413> <-0.420, -1.704, -0.413> <-0.447, -1.704, -0.424> <-0.461, -1.704, -0.439> 
		<-0.400, -1.750, -0.413> <-0.420, -1.750, -0.413> <-0.447, -1.750, -0.424> <-0.461, -1.750, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, -1.600, -0.459> <-0.450, -1.600, -0.468> <-0.458, -1.600, -0.487> <-0.458, -1.600, -0.500> 
		<-0.441, -1.646, -0.459> <-0.450, -1.646, -0.468> <-0.458, -1.646, -0.487> <-0.458, -1.646, -0.500> 
		<-0.461, -1.704, -0.439> <-0.476, -1.704, -0.453> <-0.487, -1.704, -0.480> <-0.487, -1.704, -0.500> 
		<-0.461, -1.750, -0.439> <-0.476, -1.750, -0.453> <-0.487, -1.750, -0.480> <-0.487, -1.750, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.458, -1.600, -0.500> <-0.458, -1.600, -0.513> <-0.450, -1.600, -0.532> <-0.441, -1.600, -0.541> 
		<-0.458, -1.646, -0.500> <-0.458, -1.646, -0.513> <-0.450, -1.646, -0.532> <-0.441, -1.646, -0.541> 
		<-0.487, -1.704, -0.500> <-0.487, -1.704, -0.520> <-0.476, -1.704, -0.547> <-0.461, -1.704, -0.561> 
		<-0.487, -1.750, -0.500> <-0.487, -1.750, -0.520> <-0.476, -1.750, -0.547> <-0.461, -1.750, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, -1.600, -0.541> <-0.432, -1.600, -0.550> <-0.413, -1.600, -0.558> <-0.400, -1.600, -0.558> 
		<-0.441, -1.646, -0.541> <-0.432, -1.646, -0.550> <-0.413, -1.646, -0.558> <-0.400, -1.646, -0.558> 
		<-0.461, -1.704, -0.561> <-0.447, -1.704, -0.576> <-0.420, -1.704, -0.587> <-0.400, -1.704, -0.587> 
		<-0.461, -1.750, -0.561> <-0.447, -1.750, -0.576> <-0.420, -1.750, -0.587> <-0.400, -1.750, -0.587> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -1.600, -0.558> <-0.387, -1.600, -0.558> <-0.368, -1.600, -0.550> <-0.359, -1.600, -0.541> 
		<-0.400, -1.646, -0.558> <-0.387, -1.646, -0.558> <-0.368, -1.646, -0.550> <-0.359, -1.646, -0.541> 
		<-0.400, -1.704, -0.587> <-0.380, -1.704, -0.587> <-0.353, -1.704, -0.576> <-0.339, -1.704, -0.561> 
		<-0.400, -1.750, -0.587> <-0.380, -1.750, -0.587> <-0.353, -1.750, -0.576> <-0.339, -1.750, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.339, -1.750, -0.439> <-0.353, -1.750, -0.424> <-0.380, -1.750, -0.413> <-0.400, -1.750, -0.413> 
		<-0.339, -1.767, -0.439> <-0.353, -1.767, -0.424> <-0.380, -1.767, -0.413> <-0.400, -1.767, -0.413> 
		<-0.353, -1.785, -0.453> <-0.362, -1.785, -0.444> <-0.387, -1.785, -0.433> <-0.400, -1.785, -0.433> 
		<-0.359, -1.800, -0.459> <-0.368, -1.800, -0.450> <-0.387, -1.800, -0.442> <-0.400, -1.800, -0.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -1.750, -0.413> <-0.420, -1.750, -0.413> <-0.447, -1.750, -0.424> <-0.461, -1.750, -0.439> 
		<-0.400, -1.767, -0.413> <-0.420, -1.767, -0.413> <-0.447, -1.767, -0.424> <-0.461, -1.767, -0.439> 
		<-0.400, -1.785, -0.433> <-0.413, -1.785, -0.433> <-0.438, -1.785, -0.444> <-0.447, -1.785, -0.453> 
		<-0.400, -1.800, -0.442> <-0.413, -1.800, -0.442> <-0.432, -1.800, -0.450> <-0.441, -1.800, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.461, -1.750, -0.439> <-0.476, -1.750, -0.453> <-0.487, -1.750, -0.480> <-0.487, -1.750, -0.500> 
		<-0.461, -1.767, -0.439> <-0.476, -1.767, -0.453> <-0.487, -1.767, -0.480> <-0.487, -1.767, -0.500> 
		<-0.447, -1.785, -0.453> <-0.456, -1.785, -0.462> <-0.467, -1.785, -0.487> <-0.467, -1.785, -0.500> 
		<-0.441, -1.800, -0.459> <-0.450, -1.800, -0.468> <-0.458, -1.800, -0.487> <-0.458, -1.800, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.487, -1.750, -0.500> <-0.487, -1.750, -0.520> <-0.476, -1.750, -0.547> <-0.461, -1.750, -0.561> 
		<-0.487, -1.767, -0.500> <-0.487, -1.767, -0.520> <-0.476, -1.767, -0.547> <-0.461, -1.767, -0.561> 
		<-0.467, -1.785, -0.500> <-0.467, -1.785, -0.513> <-0.456, -1.785, -0.538> <-0.447, -1.785, -0.547> 
		<-0.458, -1.800, -0.500> <-0.458, -1.800, -0.513> <-0.450, -1.800, -0.532> <-0.441, -1.800, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.461, -1.750, -0.561> <-0.447, -1.750, -0.576> <-0.420, -1.750, -0.587> <-0.400, -1.750, -0.587> 
		<-0.461, -1.767, -0.561> <-0.447, -1.767, -0.576> <-0.420, -1.767, -0.587> <-0.400, -1.767, -0.587> 
		<-0.447, -1.785, -0.547> <-0.438, -1.785, -0.556> <-0.413, -1.785, -0.567> <-0.400, -1.785, -0.567> 
		<-0.441, -1.800, -0.541> <-0.432, -1.800, -0.550> <-0.413, -1.800, -0.558> <-0.400, -1.800, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, -1.750, -0.587> <-0.380, -1.750, -0.587> <-0.353, -1.750, -0.576> <-0.339, -1.750, -0.561> 
		<-0.400, -1.767, -0.587> <-0.380, -1.767, -0.587> <-0.353, -1.767, -0.576> <-0.339, -1.767, -0.561> 
		<-0.400, -1.785, -0.567> <-0.387, -1.785, -0.567> <-0.362, -1.785, -0.556> <-0.353, -1.785, -0.547> 
		<-0.400, -1.800, -0.558> <-0.387, -1.800, -0.558> <-0.368, -1.800, -0.550> <-0.359, -1.800, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.458, -1.800, -0.500> <0.458, -1.800, -0.513> <0.450, -1.800, -0.532> <0.441, -1.800, -0.541> 
		<0.467, -1.785, -0.500> <0.467, -1.785, -0.513> <0.456, -1.785, -0.538> <0.447, -1.785, -0.547> 
		<0.487, -1.767, -0.500> <0.487, -1.767, -0.520> <0.476, -1.767, -0.547> <0.461, -1.767, -0.561> 
		<0.487, -1.750, -0.500> <0.487, -1.750, -0.520> <0.476, -1.750, -0.547> <0.461, -1.750, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.458, -1.800, -0.500> <0.467, -1.785, -0.500> <0.487, -1.767, -0.500> <0.487, -1.750, -0.500> 
		<0.458, -1.800, -0.487> <0.467, -1.785, -0.487> <0.487, -1.767, -0.480> <0.487, -1.750, -0.480> 
		<0.450, -1.800, -0.468> <0.456, -1.785, -0.462> <0.476, -1.767, -0.453> <0.476, -1.750, -0.453> 
		<0.441, -1.800, -0.459> <0.447, -1.785, -0.453> <0.461, -1.767, -0.439> <0.461, -1.750, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.487, -1.750, -0.500> <0.487, -1.750, -0.520> <0.476, -1.750, -0.547> <0.461, -1.750, -0.561> 
		<0.487, -1.704, -0.500> <0.487, -1.704, -0.520> <0.476, -1.704, -0.547> <0.461, -1.704, -0.561> 
		<0.458, -1.646, -0.500> <0.458, -1.646, -0.513> <0.450, -1.646, -0.532> <0.441, -1.646, -0.541> 
		<0.458, -1.600, -0.500> <0.458, -1.600, -0.513> <0.450, -1.600, -0.532> <0.441, -1.600, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.487, -1.750, -0.500> <0.487, -1.704, -0.500> <0.458, -1.646, -0.500> <0.458, -1.600, -0.500> 
		<0.487, -1.750, -0.480> <0.487, -1.704, -0.480> <0.458, -1.646, -0.487> <0.458, -1.600, -0.487> 
		<0.476, -1.750, -0.453> <0.476, -1.704, -0.453> <0.450, -1.646, -0.468> <0.450, -1.600, -0.468> 
		<0.461, -1.750, -0.439> <0.461, -1.704, -0.439> <0.441, -1.646, -0.459> <0.441, -1.600, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.458, -1.600, -0.500> <0.458, -1.600, -0.513> <0.450, -1.600, -0.532> <0.441, -1.600, -0.541> 
		<0.458, -1.569, -0.500> <0.458, -1.569, -0.513> <0.450, -1.569, -0.532> <0.441, -1.569, -0.541> 
		<0.485, -1.531, -0.500> <0.485, -1.531, -0.520> <0.474, -1.531, -0.546> <0.460, -1.531, -0.560> 
		<0.487, -1.500, -0.500> <0.487, -1.500, -0.520> <0.476, -1.500, -0.547> <0.461, -1.500, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.458, -1.600, -0.500> <0.458, -1.569, -0.500> <0.485, -1.531, -0.500> <0.487, -1.500, -0.500> 
		<0.458, -1.600, -0.487> <0.458, -1.569, -0.487> <0.485, -1.531, -0.480> <0.487, -1.500, -0.480> 
		<0.450, -1.600, -0.468> <0.450, -1.569, -0.468> <0.474, -1.531, -0.454> <0.476, -1.500, -0.453> 
		<0.441, -1.600, -0.459> <0.441, -1.569, -0.459> <0.460, -1.531, -0.440> <0.461, -1.500, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.487, -1.500, -0.500> <0.487, -1.500, -0.520> <0.476, -1.500, -0.547> <0.461, -1.500, -0.561> 
		<0.502, -1.260, -0.500> <0.502, -1.260, -0.520> <0.486, -1.260, -0.558> <0.472, -1.260, -0.572> 
		<0.523, -0.940, -0.500> <0.523, -0.940, -0.527> <0.506, -0.940, -0.568> <0.487, -0.940, -0.587> 
		<0.516, -0.700, -0.500> <0.516, -0.700, -0.527> <0.501, -0.700, -0.563> <0.482, -0.700, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.487, -1.500, -0.500> <0.502, -1.260, -0.500> <0.523, -0.940, -0.500> <0.516, -0.700, -0.500> 
		<0.487, -1.500, -0.480> <0.502, -1.260, -0.480> <0.523, -0.940, -0.473> <0.516, -0.700, -0.473> 
		<0.476, -1.500, -0.453> <0.486, -1.260, -0.442> <0.506, -0.940, -0.432> <0.501, -0.700, -0.437> 
		<0.461, -1.500, -0.439> <0.472, -1.260, -0.428> <0.487, -0.940, -0.413> <0.482, -0.700, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.516, -0.700, -0.500> <0.516, -0.700, -0.527> <0.501, -0.700, -0.563> <0.482, -0.700, -0.582> 
		<0.514, -0.638, -0.500> <0.514, -0.638, -0.527> <0.499, -0.638, -0.562> <0.481, -0.638, -0.581> 
		<0.464, -0.562, -0.500> <0.464, -0.562, -0.513> <0.455, -0.562, -0.536> <0.445, -0.562, -0.545> 
		<0.458, -0.500, -0.500> <0.458, -0.500, -0.513> <0.450, -0.500, -0.532> <0.441, -0.500, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.516, -0.700, -0.500> <0.514, -0.638, -0.500> <0.464, -0.562, -0.500> <0.458, -0.500, -0.500> 
		<0.516, -0.700, -0.473> <0.514, -0.638, -0.473> <0.464, -0.562, -0.487> <0.458, -0.500, -0.487> 
		<0.501, -0.700, -0.437> <0.499, -0.638, -0.438> <0.455, -0.562, -0.464> <0.450, -0.500, -0.468> 
		<0.482, -0.700, -0.418> <0.481, -0.638, -0.419> <0.445, -0.562, -0.455> <0.441, -0.500, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.458, -0.500, -0.500> <0.458, -0.500, -0.513> <0.450, -0.500, -0.532> <0.441, -0.500, -0.541> 
		<0.455, -0.469, -0.500> <0.455, -0.469, -0.513> <0.448, -0.469, -0.529> <0.439, -0.469, -0.539> 
		<0.482, -0.431, -0.500> <0.482, -0.431, -0.520> <0.472, -0.431, -0.544> <0.458, -0.431, -0.558> 
		<0.487, -0.400, -0.500> <0.487, -0.400, -0.520> <0.476, -0.400, -0.547> <0.461, -0.400, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.458, -0.500, -0.500> <0.455, -0.469, -0.500> <0.482, -0.431, -0.500> <0.487, -0.400, -0.500> 
		<0.458, -0.500, -0.487> <0.455, -0.469, -0.487> <0.482, -0.431, -0.480> <0.487, -0.400, -0.480> 
		<0.450, -0.500, -0.468> <0.448, -0.469, -0.471> <0.472, -0.431, -0.456> <0.476, -0.400, -0.453> 
		<0.441, -0.500, -0.459> <0.439, -0.469, -0.461> <0.458, -0.431, -0.442> <0.461, -0.400, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.487, -0.400, -0.500> <0.487, -0.400, -0.520> <0.476, -0.400, -0.547> <0.461, -0.400, -0.561> 
		<0.500, -0.311, -0.500> <0.500, -0.311, -0.520> <0.485, -0.311, -0.556> <0.471, -0.311, -0.571> 
		<0.522, -0.190, -0.500> <0.522, -0.190, -0.527> <0.505, -0.190, -0.568> <0.487, -0.190, -0.587> 
		<0.516, -0.100, -0.500> <0.516, -0.100, -0.527> <0.501, -0.100, -0.563> <0.482, -0.100, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.487, -0.400, -0.500> <0.500, -0.311, -0.500> <0.522, -0.190, -0.500> <0.516, -0.100, -0.500> 
		<0.487, -0.400, -0.480> <0.500, -0.311, -0.480> <0.522, -0.190, -0.473> <0.516, -0.100, -0.473> 
		<0.476, -0.400, -0.453> <0.485, -0.311, -0.444> <0.505, -0.190, -0.432> <0.501, -0.100, -0.437> 
		<0.461, -0.400, -0.439> <0.471, -0.311, -0.429> <0.487, -0.190, -0.413> <0.482, -0.100, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.458, 0.000, -0.500> <0.475, -0.030, -0.500> <0.513, -0.065, -0.500> <0.516, -0.100, -0.500> 
		<0.458, 0.000, -0.513> <0.475, -0.030, -0.513> <0.513, -0.065, -0.527> <0.516, -0.100, -0.527> 
		<0.450, 0.000, -0.532> <0.463, -0.030, -0.544> <0.499, -0.065, -0.561> <0.501, -0.100, -0.563> 
		<0.441, 0.000, -0.541> <0.453, -0.030, -0.553> <0.480, -0.065, -0.580> <0.482, -0.100, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.458, 0.000, -0.500> <0.458, 0.000, -0.487> <0.450, 0.000, -0.468> <0.441, 0.000, -0.459> 
		<0.475, -0.030, -0.500> <0.475, -0.030, -0.487> <0.463, -0.030, -0.456> <0.453, -0.030, -0.447> 
		<0.513, -0.065, -0.500> <0.513, -0.065, -0.473> <0.499, -0.065, -0.439> <0.480, -0.065, -0.420> 
		<0.516, -0.100, -0.500> <0.516, -0.100, -0.473> <0.501, -0.100, -0.437> <0.482, -0.100, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.441, 0.000, -0.459> <0.432, 0.000, -0.450> <0.413, 0.000, -0.442> <0.400, 0.000, -0.442> 
		<0.453, -0.030, -0.447> <0.444, -0.030, -0.437> <0.413, -0.030, -0.425> <0.400, -0.030, -0.425> 
		<0.480, -0.065, -0.420> <0.461, -0.065, -0.401> <0.427, -0.065, -0.387> <0.400, -0.065, -0.387> 
		<0.482, -0.100, -0.418> <0.463, -0.100, -0.399> <0.427, -0.100, -0.384> <0.400, -0.100, -0.384> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, 0.000, -0.442> <0.387, 0.000, -0.442> <0.368, 0.000, -0.450> <0.359, 0.000, -0.459> 
		<0.400, -0.030, -0.425> <0.387, -0.030, -0.425> <0.356, -0.030, -0.437> <0.347, -0.030, -0.447> 
		<0.400, -0.065, -0.387> <0.373, -0.065, -0.387> <0.339, -0.065, -0.401> <0.320, -0.065, -0.420> 
		<0.400, -0.100, -0.384> <0.373, -0.100, -0.384> <0.337, -0.100, -0.399> <0.318, -0.100, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.359, 0.000, -0.459> <0.350, 0.000, -0.468> <0.342, 0.000, -0.487> <0.342, 0.000, -0.500> 
		<0.347, -0.030, -0.447> <0.337, -0.030, -0.456> <0.325, -0.030, -0.487> <0.325, -0.030, -0.500> 
		<0.320, -0.065, -0.420> <0.301, -0.065, -0.439> <0.287, -0.065, -0.473> <0.287, -0.065, -0.500> 
		<0.318, -0.100, -0.418> <0.299, -0.100, -0.437> <0.284, -0.100, -0.473> <0.284, -0.100, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.342, 0.000, -0.500> <0.342, 0.000, -0.513> <0.350, 0.000, -0.532> <0.359, 0.000, -0.541> 
		<0.325, -0.030, -0.500> <0.325, -0.030, -0.513> <0.337, -0.030, -0.544> <0.347, -0.030, -0.553> 
		<0.287, -0.065, -0.500> <0.287, -0.065, -0.527> <0.301, -0.065, -0.561> <0.320, -0.065, -0.580> 
		<0.284, -0.100, -0.500> <0.284, -0.100, -0.527> <0.299, -0.100, -0.563> <0.318, -0.100, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.359, 0.000, -0.541> <0.368, 0.000, -0.550> <0.387, 0.000, -0.558> <0.400, 0.000, -0.558> 
		<0.347, -0.030, -0.553> <0.356, -0.030, -0.563> <0.387, -0.030, -0.575> <0.400, -0.030, -0.575> 
		<0.320, -0.065, -0.580> <0.339, -0.065, -0.599> <0.373, -0.065, -0.613> <0.400, -0.065, -0.613> 
		<0.318, -0.100, -0.582> <0.337, -0.100, -0.601> <0.373, -0.100, -0.616> <0.400, -0.100, -0.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, 0.000, -0.558> <0.413, 0.000, -0.558> <0.432, 0.000, -0.550> <0.441, 0.000, -0.541> 
		<0.400, -0.030, -0.575> <0.413, -0.030, -0.575> <0.444, -0.030, -0.563> <0.453, -0.030, -0.553> 
		<0.400, -0.065, -0.613> <0.427, -0.065, -0.613> <0.461, -0.065, -0.599> <0.480, -0.065, -0.580> 
		<0.400, -0.100, -0.616> <0.427, -0.100, -0.616> <0.463, -0.100, -0.601> <0.482, -0.100, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.482, -0.100, -0.418> <0.463, -0.100, -0.399> <0.427, -0.100, -0.384> <0.400, -0.100, -0.384> 
		<0.487, -0.190, -0.413> <0.468, -0.190, -0.395> <0.427, -0.190, -0.378> <0.400, -0.190, -0.378> 
		<0.471, -0.311, -0.429> <0.456, -0.311, -0.415> <0.420, -0.311, -0.400> <0.400, -0.311, -0.400> 
		<0.461, -0.400, -0.439> <0.447, -0.400, -0.424> <0.420, -0.400, -0.413> <0.400, -0.400, -0.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.100, -0.384> <0.373, -0.100, -0.384> <0.337, -0.100, -0.399> <0.318, -0.100, -0.418> 
		<0.400, -0.190, -0.378> <0.373, -0.190, -0.378> <0.332, -0.190, -0.395> <0.313, -0.190, -0.413> 
		<0.400, -0.311, -0.400> <0.380, -0.311, -0.400> <0.344, -0.311, -0.415> <0.329, -0.311, -0.429> 
		<0.400, -0.400, -0.413> <0.380, -0.400, -0.413> <0.353, -0.400, -0.424> <0.339, -0.400, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, -0.100, -0.418> <0.299, -0.100, -0.437> <0.284, -0.100, -0.473> <0.284, -0.100, -0.500> 
		<0.313, -0.190, -0.413> <0.295, -0.190, -0.432> <0.278, -0.190, -0.473> <0.278, -0.190, -0.500> 
		<0.329, -0.311, -0.429> <0.315, -0.311, -0.444> <0.300, -0.311, -0.480> <0.300, -0.311, -0.500> 
		<0.339, -0.400, -0.439> <0.324, -0.400, -0.453> <0.313, -0.400, -0.480> <0.313, -0.400, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.284, -0.100, -0.500> <0.284, -0.100, -0.527> <0.299, -0.100, -0.563> <0.318, -0.100, -0.582> 
		<0.278, -0.190, -0.500> <0.278, -0.190, -0.527> <0.295, -0.190, -0.568> <0.313, -0.190, -0.587> 
		<0.300, -0.311, -0.500> <0.300, -0.311, -0.520> <0.315, -0.311, -0.556> <0.329, -0.311, -0.571> 
		<0.313, -0.400, -0.500> <0.313, -0.400, -0.520> <0.324, -0.400, -0.547> <0.339, -0.400, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, -0.100, -0.582> <0.337, -0.100, -0.601> <0.373, -0.100, -0.616> <0.400, -0.100, -0.616> 
		<0.313, -0.190, -0.587> <0.332, -0.190, -0.605> <0.373, -0.190, -0.622> <0.400, -0.190, -0.622> 
		<0.329, -0.311, -0.571> <0.344, -0.311, -0.585> <0.380, -0.311, -0.600> <0.400, -0.311, -0.600> 
		<0.339, -0.400, -0.561> <0.353, -0.400, -0.576> <0.380, -0.400, -0.587> <0.400, -0.400, -0.587> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.100, -0.616> <0.427, -0.100, -0.616> <0.463, -0.100, -0.601> <0.482, -0.100, -0.582> 
		<0.400, -0.190, -0.622> <0.427, -0.190, -0.622> <0.468, -0.190, -0.605> <0.487, -0.190, -0.587> 
		<0.400, -0.311, -0.600> <0.420, -0.311, -0.600> <0.456, -0.311, -0.585> <0.471, -0.311, -0.571> 
		<0.400, -0.400, -0.587> <0.420, -0.400, -0.587> <0.447, -0.400, -0.576> <0.461, -0.400, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.461, -0.400, -0.439> <0.447, -0.400, -0.424> <0.420, -0.400, -0.413> <0.400, -0.400, -0.413> 
		<0.458, -0.431, -0.442> <0.444, -0.431, -0.428> <0.420, -0.431, -0.418> <0.400, -0.431, -0.418> 
		<0.439, -0.469, -0.461> <0.429, -0.469, -0.452> <0.413, -0.469, -0.445> <0.400, -0.469, -0.445> 
		<0.441, -0.500, -0.459> <0.432, -0.500, -0.450> <0.413, -0.500, -0.442> <0.400, -0.500, -0.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.400, -0.413> <0.380, -0.400, -0.413> <0.353, -0.400, -0.424> <0.339, -0.400, -0.439> 
		<0.400, -0.431, -0.418> <0.380, -0.431, -0.418> <0.356, -0.431, -0.428> <0.342, -0.431, -0.442> 
		<0.400, -0.469, -0.445> <0.387, -0.469, -0.445> <0.371, -0.469, -0.452> <0.361, -0.469, -0.461> 
		<0.400, -0.500, -0.442> <0.387, -0.500, -0.442> <0.368, -0.500, -0.450> <0.359, -0.500, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, -0.400, -0.439> <0.324, -0.400, -0.453> <0.313, -0.400, -0.480> <0.313, -0.400, -0.500> 
		<0.342, -0.431, -0.442> <0.328, -0.431, -0.456> <0.318, -0.431, -0.480> <0.318, -0.431, -0.500> 
		<0.361, -0.469, -0.461> <0.352, -0.469, -0.471> <0.345, -0.469, -0.487> <0.345, -0.469, -0.500> 
		<0.359, -0.500, -0.459> <0.350, -0.500, -0.468> <0.342, -0.500, -0.487> <0.342, -0.500, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.313, -0.400, -0.500> <0.313, -0.400, -0.520> <0.324, -0.400, -0.547> <0.339, -0.400, -0.561> 
		<0.318, -0.431, -0.500> <0.318, -0.431, -0.520> <0.328, -0.431, -0.544> <0.342, -0.431, -0.558> 
		<0.345, -0.469, -0.500> <0.345, -0.469, -0.513> <0.352, -0.469, -0.529> <0.361, -0.469, -0.539> 
		<0.342, -0.500, -0.500> <0.342, -0.500, -0.513> <0.350, -0.500, -0.532> <0.359, -0.500, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, -0.400, -0.561> <0.353, -0.400, -0.576> <0.380, -0.400, -0.587> <0.400, -0.400, -0.587> 
		<0.342, -0.431, -0.558> <0.356, -0.431, -0.572> <0.380, -0.431, -0.582> <0.400, -0.431, -0.582> 
		<0.361, -0.469, -0.539> <0.371, -0.469, -0.548> <0.387, -0.469, -0.555> <0.400, -0.469, -0.555> 
		<0.359, -0.500, -0.541> <0.368, -0.500, -0.550> <0.387, -0.500, -0.558> <0.400, -0.500, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.400, -0.587> <0.420, -0.400, -0.587> <0.447, -0.400, -0.576> <0.461, -0.400, -0.561> 
		<0.400, -0.431, -0.582> <0.420, -0.431, -0.582> <0.444, -0.431, -0.572> <0.458, -0.431, -0.558> 
		<0.400, -0.469, -0.555> <0.413, -0.469, -0.555> <0.429, -0.469, -0.548> <0.439, -0.469, -0.539> 
		<0.400, -0.500, -0.558> <0.413, -0.500, -0.558> <0.432, -0.500, -0.550> <0.441, -0.500, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.441, -0.500, -0.459> <0.432, -0.500, -0.450> <0.413, -0.500, -0.442> <0.400, -0.500, -0.442> 
		<0.445, -0.562, -0.455> <0.436, -0.562, -0.445> <0.413, -0.562, -0.436> <0.400, -0.562, -0.436> 
		<0.481, -0.638, -0.419> <0.462, -0.638, -0.401> <0.427, -0.638, -0.386> <0.400, -0.638, -0.386> 
		<0.482, -0.700, -0.418> <0.463, -0.700, -0.399> <0.427, -0.700, -0.384> <0.400, -0.700, -0.384> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.500, -0.442> <0.387, -0.500, -0.442> <0.368, -0.500, -0.450> <0.359, -0.500, -0.459> 
		<0.400, -0.562, -0.436> <0.387, -0.562, -0.436> <0.364, -0.562, -0.445> <0.355, -0.562, -0.455> 
		<0.400, -0.638, -0.386> <0.373, -0.638, -0.386> <0.338, -0.638, -0.401> <0.319, -0.638, -0.419> 
		<0.400, -0.700, -0.384> <0.373, -0.700, -0.384> <0.337, -0.700, -0.399> <0.318, -0.700, -0.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.359, -0.500, -0.459> <0.350, -0.500, -0.468> <0.342, -0.500, -0.487> <0.342, -0.500, -0.500> 
		<0.355, -0.562, -0.455> <0.345, -0.562, -0.464> <0.336, -0.562, -0.487> <0.336, -0.562, -0.500> 
		<0.319, -0.638, -0.419> <0.301, -0.638, -0.438> <0.286, -0.638, -0.473> <0.286, -0.638, -0.500> 
		<0.318, -0.700, -0.418> <0.299, -0.700, -0.437> <0.284, -0.700, -0.473> <0.284, -0.700, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.342, -0.500, -0.500> <0.342, -0.500, -0.513> <0.350, -0.500, -0.532> <0.359, -0.500, -0.541> 
		<0.336, -0.562, -0.500> <0.336, -0.562, -0.513> <0.345, -0.562, -0.536> <0.355, -0.562, -0.545> 
		<0.286, -0.638, -0.500> <0.286, -0.638, -0.527> <0.301, -0.638, -0.562> <0.319, -0.638, -0.581> 
		<0.284, -0.700, -0.500> <0.284, -0.700, -0.527> <0.299, -0.700, -0.563> <0.318, -0.700, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.359, -0.500, -0.541> <0.368, -0.500, -0.550> <0.387, -0.500, -0.558> <0.400, -0.500, -0.558> 
		<0.355, -0.562, -0.545> <0.364, -0.562, -0.555> <0.387, -0.562, -0.564> <0.400, -0.562, -0.564> 
		<0.319, -0.638, -0.581> <0.338, -0.638, -0.599> <0.373, -0.638, -0.614> <0.400, -0.638, -0.614> 
		<0.318, -0.700, -0.582> <0.337, -0.700, -0.601> <0.373, -0.700, -0.616> <0.400, -0.700, -0.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.500, -0.558> <0.413, -0.500, -0.558> <0.432, -0.500, -0.550> <0.441, -0.500, -0.541> 
		<0.400, -0.562, -0.564> <0.413, -0.562, -0.564> <0.436, -0.562, -0.555> <0.445, -0.562, -0.545> 
		<0.400, -0.638, -0.614> <0.427, -0.638, -0.614> <0.462, -0.638, -0.599> <0.481, -0.638, -0.581> 
		<0.400, -0.700, -0.616> <0.427, -0.700, -0.616> <0.463, -0.700, -0.601> <0.482, -0.700, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.482, -0.700, -0.418> <0.463, -0.700, -0.399> <0.427, -0.700, -0.384> <0.400, -0.700, -0.384> 
		<0.487, -0.940, -0.413> <0.468, -0.940, -0.394> <0.427, -0.940, -0.377> <0.400, -0.940, -0.377> 
		<0.472, -1.260, -0.428> <0.458, -1.260, -0.414> <0.420, -1.260, -0.398> <0.400, -1.260, -0.398> 
		<0.461, -1.500, -0.439> <0.447, -1.500, -0.424> <0.420, -1.500, -0.413> <0.400, -1.500, -0.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.700, -0.384> <0.373, -0.700, -0.384> <0.337, -0.700, -0.399> <0.318, -0.700, -0.418> 
		<0.400, -0.940, -0.377> <0.373, -0.940, -0.377> <0.332, -0.940, -0.394> <0.313, -0.940, -0.413> 
		<0.400, -1.260, -0.398> <0.380, -1.260, -0.398> <0.342, -1.260, -0.414> <0.328, -1.260, -0.428> 
		<0.400, -1.500, -0.413> <0.380, -1.500, -0.413> <0.353, -1.500, -0.424> <0.339, -1.500, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, -0.700, -0.418> <0.299, -0.700, -0.437> <0.284, -0.700, -0.473> <0.284, -0.700, -0.500> 
		<0.313, -0.940, -0.413> <0.294, -0.940, -0.432> <0.277, -0.940, -0.473> <0.277, -0.940, -0.500> 
		<0.328, -1.260, -0.428> <0.314, -1.260, -0.442> <0.298, -1.260, -0.480> <0.298, -1.260, -0.500> 
		<0.339, -1.500, -0.439> <0.324, -1.500, -0.453> <0.313, -1.500, -0.480> <0.313, -1.500, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.284, -0.700, -0.500> <0.284, -0.700, -0.527> <0.299, -0.700, -0.563> <0.318, -0.700, -0.582> 
		<0.277, -0.940, -0.500> <0.277, -0.940, -0.527> <0.294, -0.940, -0.568> <0.313, -0.940, -0.587> 
		<0.298, -1.260, -0.500> <0.298, -1.260, -0.520> <0.314, -1.260, -0.558> <0.328, -1.260, -0.572> 
		<0.313, -1.500, -0.500> <0.313, -1.500, -0.520> <0.324, -1.500, -0.547> <0.339, -1.500, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, -0.700, -0.582> <0.337, -0.700, -0.601> <0.373, -0.700, -0.616> <0.400, -0.700, -0.616> 
		<0.313, -0.940, -0.587> <0.332, -0.940, -0.606> <0.373, -0.940, -0.623> <0.400, -0.940, -0.623> 
		<0.328, -1.260, -0.572> <0.342, -1.260, -0.586> <0.380, -1.260, -0.602> <0.400, -1.260, -0.602> 
		<0.339, -1.500, -0.561> <0.353, -1.500, -0.576> <0.380, -1.500, -0.587> <0.400, -1.500, -0.587> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.700, -0.616> <0.427, -0.700, -0.616> <0.463, -0.700, -0.601> <0.482, -0.700, -0.582> 
		<0.400, -0.940, -0.623> <0.427, -0.940, -0.623> <0.468, -0.940, -0.606> <0.487, -0.940, -0.587> 
		<0.400, -1.260, -0.602> <0.420, -1.260, -0.602> <0.458, -1.260, -0.586> <0.472, -1.260, -0.572> 
		<0.400, -1.500, -0.587> <0.420, -1.500, -0.587> <0.447, -1.500, -0.576> <0.461, -1.500, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.461, -1.500, -0.439> <0.447, -1.500, -0.424> <0.420, -1.500, -0.413> <0.400, -1.500, -0.413> 
		<0.460, -1.531, -0.440> <0.446, -1.531, -0.426> <0.420, -1.531, -0.415> <0.400, -1.531, -0.415> 
		<0.441, -1.569, -0.459> <0.432, -1.569, -0.450> <0.413, -1.569, -0.442> <0.400, -1.569, -0.442> 
		<0.441, -1.600, -0.459> <0.432, -1.600, -0.450> <0.413, -1.600, -0.442> <0.400, -1.600, -0.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -1.500, -0.413> <0.380, -1.500, -0.413> <0.353, -1.500, -0.424> <0.339, -1.500, -0.439> 
		<0.400, -1.531, -0.415> <0.380, -1.531, -0.415> <0.354, -1.531, -0.426> <0.340, -1.531, -0.440> 
		<0.400, -1.569, -0.442> <0.387, -1.569, -0.442> <0.368, -1.569, -0.450> <0.359, -1.569, -0.459> 
		<0.400, -1.600, -0.442> <0.387, -1.600, -0.442> <0.368, -1.600, -0.450> <0.359, -1.600, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, -1.500, -0.439> <0.324, -1.500, -0.453> <0.313, -1.500, -0.480> <0.313, -1.500, -0.500> 
		<0.340, -1.531, -0.440> <0.326, -1.531, -0.454> <0.315, -1.531, -0.480> <0.315, -1.531, -0.500> 
		<0.359, -1.569, -0.459> <0.350, -1.569, -0.468> <0.342, -1.569, -0.487> <0.342, -1.569, -0.500> 
		<0.359, -1.600, -0.459> <0.350, -1.600, -0.468> <0.342, -1.600, -0.487> <0.342, -1.600, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.313, -1.500, -0.500> <0.313, -1.500, -0.520> <0.324, -1.500, -0.547> <0.339, -1.500, -0.561> 
		<0.315, -1.531, -0.500> <0.315, -1.531, -0.520> <0.326, -1.531, -0.546> <0.340, -1.531, -0.560> 
		<0.342, -1.569, -0.500> <0.342, -1.569, -0.513> <0.350, -1.569, -0.532> <0.359, -1.569, -0.541> 
		<0.342, -1.600, -0.500> <0.342, -1.600, -0.513> <0.350, -1.600, -0.532> <0.359, -1.600, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, -1.500, -0.561> <0.353, -1.500, -0.576> <0.380, -1.500, -0.587> <0.400, -1.500, -0.587> 
		<0.340, -1.531, -0.560> <0.354, -1.531, -0.574> <0.380, -1.531, -0.585> <0.400, -1.531, -0.585> 
		<0.359, -1.569, -0.541> <0.368, -1.569, -0.550> <0.387, -1.569, -0.558> <0.400, -1.569, -0.558> 
		<0.359, -1.600, -0.541> <0.368, -1.600, -0.550> <0.387, -1.600, -0.558> <0.400, -1.600, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -1.500, -0.587> <0.420, -1.500, -0.587> <0.447, -1.500, -0.576> <0.461, -1.500, -0.561> 
		<0.400, -1.531, -0.585> <0.420, -1.531, -0.585> <0.446, -1.531, -0.574> <0.460, -1.531, -0.560> 
		<0.400, -1.569, -0.558> <0.413, -1.569, -0.558> <0.432, -1.569, -0.550> <0.441, -1.569, -0.541> 
		<0.400, -1.600, -0.558> <0.413, -1.600, -0.558> <0.432, -1.600, -0.550> <0.441, -1.600, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.441, -1.600, -0.459> <0.432, -1.600, -0.450> <0.413, -1.600, -0.442> <0.400, -1.600, -0.442> 
		<0.441, -1.646, -0.459> <0.432, -1.646, -0.450> <0.413, -1.646, -0.442> <0.400, -1.646, -0.442> 
		<0.461, -1.704, -0.439> <0.447, -1.704, -0.424> <0.420, -1.704, -0.413> <0.400, -1.704, -0.413> 
		<0.461, -1.750, -0.439> <0.447, -1.750, -0.424> <0.420, -1.750, -0.413> <0.400, -1.750, -0.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -1.600, -0.442> <0.387, -1.600, -0.442> <0.368, -1.600, -0.450> <0.359, -1.600, -0.459> 
		<0.400, -1.646, -0.442> <0.387, -1.646, -0.442> <0.368, -1.646, -0.450> <0.359, -1.646, -0.459> 
		<0.400, -1.704, -0.413> <0.380, -1.704, -0.413> <0.353, -1.704, -0.424> <0.339, -1.704, -0.439> 
		<0.400, -1.750, -0.413> <0.380, -1.750, -0.413> <0.353, -1.750, -0.424> <0.339, -1.750, -0.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.359, -1.600, -0.459> <0.350, -1.600, -0.468> <0.342, -1.600, -0.487> <0.342, -1.600, -0.500> 
		<0.359, -1.646, -0.459> <0.350, -1.646, -0.468> <0.342, -1.646, -0.487> <0.342, -1.646, -0.500> 
		<0.339, -1.704, -0.439> <0.324, -1.704, -0.453> <0.313, -1.704, -0.480> <0.313, -1.704, -0.500> 
		<0.339, -1.750, -0.439> <0.324, -1.750, -0.453> <0.313, -1.750, -0.480> <0.313, -1.750, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.342, -1.600, -0.500> <0.342, -1.600, -0.513> <0.350, -1.600, -0.532> <0.359, -1.600, -0.541> 
		<0.342, -1.646, -0.500> <0.342, -1.646, -0.513> <0.350, -1.646, -0.532> <0.359, -1.646, -0.541> 
		<0.313, -1.704, -0.500> <0.313, -1.704, -0.520> <0.324, -1.704, -0.547> <0.339, -1.704, -0.561> 
		<0.313, -1.750, -0.500> <0.313, -1.750, -0.520> <0.324, -1.750, -0.547> <0.339, -1.750, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.359, -1.600, -0.541> <0.368, -1.600, -0.550> <0.387, -1.600, -0.558> <0.400, -1.600, -0.558> 
		<0.359, -1.646, -0.541> <0.368, -1.646, -0.550> <0.387, -1.646, -0.558> <0.400, -1.646, -0.558> 
		<0.339, -1.704, -0.561> <0.353, -1.704, -0.576> <0.380, -1.704, -0.587> <0.400, -1.704, -0.587> 
		<0.339, -1.750, -0.561> <0.353, -1.750, -0.576> <0.380, -1.750, -0.587> <0.400, -1.750, -0.587> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -1.600, -0.558> <0.413, -1.600, -0.558> <0.432, -1.600, -0.550> <0.441, -1.600, -0.541> 
		<0.400, -1.646, -0.558> <0.413, -1.646, -0.558> <0.432, -1.646, -0.550> <0.441, -1.646, -0.541> 
		<0.400, -1.704, -0.587> <0.420, -1.704, -0.587> <0.447, -1.704, -0.576> <0.461, -1.704, -0.561> 
		<0.400, -1.750, -0.587> <0.420, -1.750, -0.587> <0.447, -1.750, -0.576> <0.461, -1.750, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.461, -1.750, -0.439> <0.447, -1.750, -0.424> <0.420, -1.750, -0.413> <0.400, -1.750, -0.413> 
		<0.461, -1.767, -0.439> <0.447, -1.767, -0.424> <0.420, -1.767, -0.413> <0.400, -1.767, -0.413> 
		<0.447, -1.785, -0.453> <0.438, -1.785, -0.444> <0.413, -1.785, -0.433> <0.400, -1.785, -0.433> 
		<0.441, -1.800, -0.459> <0.432, -1.800, -0.450> <0.413, -1.800, -0.442> <0.400, -1.800, -0.442> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -1.750, -0.413> <0.380, -1.750, -0.413> <0.353, -1.750, -0.424> <0.339, -1.750, -0.439> 
		<0.400, -1.767, -0.413> <0.380, -1.767, -0.413> <0.353, -1.767, -0.424> <0.339, -1.767, -0.439> 
		<0.400, -1.785, -0.433> <0.387, -1.785, -0.433> <0.362, -1.785, -0.444> <0.353, -1.785, -0.453> 
		<0.400, -1.800, -0.442> <0.387, -1.800, -0.442> <0.368, -1.800, -0.450> <0.359, -1.800, -0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, -1.750, -0.439> <0.324, -1.750, -0.453> <0.313, -1.750, -0.480> <0.313, -1.750, -0.500> 
		<0.339, -1.767, -0.439> <0.324, -1.767, -0.453> <0.313, -1.767, -0.480> <0.313, -1.767, -0.500> 
		<0.353, -1.785, -0.453> <0.344, -1.785, -0.462> <0.333, -1.785, -0.487> <0.333, -1.785, -0.500> 
		<0.359, -1.800, -0.459> <0.350, -1.800, -0.468> <0.342, -1.800, -0.487> <0.342, -1.800, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.313, -1.750, -0.500> <0.313, -1.750, -0.520> <0.324, -1.750, -0.547> <0.339, -1.750, -0.561> 
		<0.313, -1.767, -0.500> <0.313, -1.767, -0.520> <0.324, -1.767, -0.547> <0.339, -1.767, -0.561> 
		<0.333, -1.785, -0.500> <0.333, -1.785, -0.513> <0.344, -1.785, -0.538> <0.353, -1.785, -0.547> 
		<0.342, -1.800, -0.500> <0.342, -1.800, -0.513> <0.350, -1.800, -0.532> <0.359, -1.800, -0.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, -1.750, -0.561> <0.353, -1.750, -0.576> <0.380, -1.750, -0.587> <0.400, -1.750, -0.587> 
		<0.339, -1.767, -0.561> <0.353, -1.767, -0.576> <0.380, -1.767, -0.587> <0.400, -1.767, -0.587> 
		<0.353, -1.785, -0.547> <0.362, -1.785, -0.556> <0.387, -1.785, -0.567> <0.400, -1.785, -0.567> 
		<0.359, -1.800, -0.541> <0.368, -1.800, -0.550> <0.387, -1.800, -0.558> <0.400, -1.800, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -1.750, -0.587> <0.420, -1.750, -0.587> <0.447, -1.750, -0.576> <0.461, -1.750, -0.561> 
		<0.400, -1.767, -0.587> <0.420, -1.767, -0.587> <0.447, -1.767, -0.576> <0.461, -1.767, -0.561> 
		<0.400, -1.785, -0.567> <0.413, -1.785, -0.567> <0.438, -1.785, -0.556> <0.447, -1.785, -0.547> 
		<0.400, -1.800, -0.558> <0.413, -1.800, -0.558> <0.432, -1.800, -0.550> <0.441, -1.800, -0.541> 
	}
}
// Layer 3
#declare arch = 
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.525, 0.200, -0.532> <-0.452, 0.200, -0.532> <-0.355, 0.200, -0.532> <-0.283, 0.200, -0.532> 
		<-0.547, 0.380, -0.570> <-0.475, 0.380, -0.570> <-0.414, 0.336, -0.559> <-0.342, 0.336, -0.559> 
		<-0.616, 0.620, -0.617> <-0.581, 0.577, -0.635> <-0.505, 0.542, -0.623> <-0.475, 0.505, -0.590> 
		<-0.600, 0.800, -0.659> <-0.565, 0.757, -0.677> <-0.509, 0.689, -0.656> <-0.479, 0.652, -0.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.525, 0.200, -0.532> <-0.547, 0.380, -0.570> <-0.616, 0.620, -0.617> <-0.600, 0.800, -0.659> 
		<-0.525, 0.200, -0.502> <-0.547, 0.380, -0.540> <-0.634, 0.642, -0.609> <-0.618, 0.821, -0.650> 
		<-0.525, 0.200, -0.462> <-0.547, 0.380, -0.501> <-0.631, 0.638, -0.537> <-0.615, 0.818, -0.579> 
		<-0.525, 0.200, -0.432> <-0.547, 0.380, -0.471> <-0.616, 0.620, -0.520> <-0.600, 0.800, -0.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.525, 0.200, -0.532> <-0.525, 0.200, -0.502> <-0.525, 0.200, -0.462> <-0.525, 0.200, -0.432> 
		<-0.452, 0.200, -0.532> <-0.452, 0.200, -0.502> <-0.452, 0.200, -0.462> <-0.452, 0.200, -0.432> 
		<-0.355, 0.200, -0.532> <-0.355, 0.200, -0.502> <-0.355, 0.200, -0.462> <-0.355, 0.200, -0.432> 
		<-0.283, 0.200, -0.532> <-0.283, 0.200, -0.502> <-0.283, 0.200, -0.462> <-0.283, 0.200, -0.432> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.283, 0.200, -0.532> <-0.283, 0.200, -0.502> <-0.283, 0.200, -0.462> <-0.283, 0.200, -0.432> 
		<-0.342, 0.336, -0.559> <-0.342, 0.336, -0.529> <-0.342, 0.336, -0.490> <-0.342, 0.336, -0.460> 
		<-0.475, 0.505, -0.590> <-0.460, 0.487, -0.573> <-0.457, 0.484, -0.502> <-0.475, 0.505, -0.493> 
		<-0.479, 0.652, -0.623> <-0.464, 0.633, -0.606> <-0.462, 0.630, -0.535> <-0.479, 0.652, -0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.283, 0.200, -0.532> <0.355, 0.200, -0.532> <0.452, 0.200, -0.532> <0.525, 0.200, -0.532> 
		<0.342, 0.336, -0.559> <0.414, 0.336, -0.559> <0.475, 0.380, -0.570> <0.547, 0.380, -0.570> 
		<0.475, 0.505, -0.590> <0.505, 0.542, -0.623> <0.581, 0.577, -0.635> <0.616, 0.620, -0.617> 
		<0.479, 0.652, -0.623> <0.509, 0.689, -0.656> <0.565, 0.757, -0.677> <0.600, 0.800, -0.659> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.283, 0.200, -0.532> <0.342, 0.336, -0.559> <0.475, 0.505, -0.590> <0.479, 0.652, -0.623> 
		<0.283, 0.200, -0.502> <0.342, 0.336, -0.529> <0.460, 0.487, -0.573> <0.464, 0.633, -0.606> 
		<0.283, 0.200, -0.462> <0.342, 0.336, -0.490> <0.457, 0.484, -0.502> <0.462, 0.630, -0.535> 
		<0.283, 0.200, -0.432> <0.342, 0.336, -0.460> <0.475, 0.505, -0.493> <0.479, 0.652, -0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.283, 0.200, -0.532> <0.283, 0.200, -0.502> <0.283, 0.200, -0.462> <0.283, 0.200, -0.432> 
		<0.355, 0.200, -0.532> <0.355, 0.200, -0.502> <0.355, 0.200, -0.462> <0.355, 0.200, -0.432> 
		<0.452, 0.200, -0.532> <0.452, 0.200, -0.502> <0.452, 0.200, -0.462> <0.452, 0.200, -0.432> 
		<0.525, 0.200, -0.532> <0.525, 0.200, -0.502> <0.525, 0.200, -0.462> <0.525, 0.200, -0.432> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.525, 0.200, -0.532> <0.525, 0.200, -0.502> <0.525, 0.200, -0.462> <0.525, 0.200, -0.432> 
		<0.547, 0.380, -0.570> <0.547, 0.380, -0.540> <0.547, 0.380, -0.501> <0.547, 0.380, -0.471> 
		<0.616, 0.620, -0.617> <0.634, 0.642, -0.609> <0.631, 0.638, -0.537> <0.616, 0.620, -0.520> 
		<0.600, 0.800, -0.659> <0.618, 0.821, -0.650> <0.615, 0.818, -0.579> <0.600, 0.800, -0.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.525, 0.200, -0.432> <-0.547, 0.380, -0.471> <-0.616, 0.620, -0.520> <-0.600, 0.800, -0.562> 
		<-0.452, 0.200, -0.432> <-0.475, 0.380, -0.471> <-0.586, 0.583, -0.487> <-0.570, 0.763, -0.529> 
		<-0.355, 0.200, -0.432> <-0.414, 0.336, -0.460> <-0.510, 0.548, -0.475> <-0.514, 0.695, -0.508> 
		<-0.283, 0.200, -0.432> <-0.342, 0.336, -0.460> <-0.475, 0.505, -0.493> <-0.479, 0.652, -0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.283, 0.200, -0.432> <0.342, 0.336, -0.460> <0.475, 0.505, -0.493> <0.479, 0.652, -0.526> 
		<0.355, 0.200, -0.432> <0.414, 0.336, -0.460> <0.510, 0.548, -0.475> <0.514, 0.695, -0.508> 
		<0.452, 0.200, -0.432> <0.475, 0.380, -0.471> <0.586, 0.583, -0.487> <0.570, 0.763, -0.529> 
		<0.525, 0.200, -0.432> <0.547, 0.380, -0.471> <0.616, 0.620, -0.520> <0.600, 0.800, -0.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.200, -0.906> <0.000, 2.162, -0.874> <0.000, 2.086, -0.850> <0.000, 2.039, -0.867> 
		<0.221, 2.200, -0.906> <0.221, 2.162, -0.874> <0.182, 2.086, -0.850> <0.182, 2.039, -0.867> 
		<0.315, 1.798, -0.807> <0.299, 1.786, -0.783> <0.282, 1.723, -0.756> <0.261, 1.708, -0.774> 
		<0.400, 1.600, -0.759> <0.384, 1.588, -0.735> <0.340, 1.556, -0.715> <0.319, 1.541, -0.733> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.200, -0.906> <0.221, 2.200, -0.906> <0.315, 1.798, -0.807> <0.400, 1.600, -0.759> 
		<0.000, 2.222, -0.925> <0.221, 2.222, -0.925> <0.330, 1.809, -0.830> <0.415, 1.611, -0.781> 
		<0.000, 2.227, -0.993> <0.221, 2.227, -0.993> <0.334, 1.812, -0.888> <0.419, 1.614, -0.839> 
		<0.000, 2.200, -1.003> <0.221, 2.200, -1.003> <0.315, 1.798, -0.904> <0.400, 1.600, -0.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.200, -0.906> <0.000, 2.222, -0.925> <0.000, 2.227, -0.993> <0.000, 2.200, -1.003> 
		<-0.221, 2.200, -0.906> <-0.221, 2.222, -0.925> <-0.221, 2.227, -0.993> <-0.221, 2.200, -1.003> 
		<-0.315, 1.798, -0.807> <-0.330, 1.809, -0.830> <-0.334, 1.812, -0.888> <-0.315, 1.798, -0.904> 
		<-0.400, 1.600, -0.759> <-0.415, 1.611, -0.781> <-0.419, 1.614, -0.839> <-0.400, 1.600, -0.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.200, -0.906> <-0.221, 2.200, -0.906> <-0.315, 1.798, -0.807> <-0.400, 1.600, -0.759> 
		<0.000, 2.162, -0.874> <-0.221, 2.162, -0.874> <-0.299, 1.786, -0.783> <-0.384, 1.588, -0.735> 
		<0.000, 2.086, -0.850> <-0.182, 2.086, -0.850> <-0.282, 1.723, -0.756> <-0.340, 1.556, -0.715> 
		<0.000, 2.039, -0.867> <-0.182, 2.039, -0.867> <-0.261, 1.708, -0.774> <-0.319, 1.541, -0.733> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.039, -0.867> <-0.182, 2.039, -0.867> <-0.261, 1.708, -0.774> <-0.319, 1.541, -0.733> 
		<0.000, 2.012, -0.877> <-0.182, 2.012, -0.877> <-0.242, 1.694, -0.791> <-0.300, 1.526, -0.750> 
		<0.000, 2.017, -0.945> <-0.182, 2.017, -0.945> <-0.247, 1.697, -0.848> <-0.305, 1.530, -0.807> 
		<0.000, 2.039, -0.964> <-0.182, 2.039, -0.964> <-0.261, 1.708, -0.871> <-0.319, 1.541, -0.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.039, -0.867> <0.000, 2.012, -0.877> <0.000, 2.017, -0.945> <0.000, 2.039, -0.964> 
		<0.182, 2.039, -0.867> <0.182, 2.012, -0.877> <0.182, 2.017, -0.945> <0.182, 2.039, -0.964> 
		<0.261, 1.708, -0.774> <0.242, 1.694, -0.791> <0.247, 1.697, -0.848> <0.261, 1.708, -0.871> 
		<0.319, 1.541, -0.733> <0.300, 1.526, -0.750> <0.305, 1.530, -0.807> <0.319, 1.541, -0.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.039, -0.964> <0.000, 2.077, -0.996> <0.000, 2.153, -1.020> <0.000, 2.200, -1.003> 
		<0.182, 2.039, -0.964> <0.182, 2.077, -0.996> <0.221, 2.153, -1.020> <0.221, 2.200, -1.003> 
		<0.261, 1.708, -0.871> <0.277, 1.720, -0.895> <0.295, 1.783, -0.922> <0.315, 1.798, -0.904> 
		<0.319, 1.541, -0.830> <0.335, 1.552, -0.854> <0.380, 1.585, -0.874> <0.400, 1.600, -0.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.039, -0.964> <-0.182, 2.039, -0.964> <-0.261, 1.708, -0.871> <-0.319, 1.541, -0.830> 
		<0.000, 2.077, -0.996> <-0.182, 2.077, -0.996> <-0.277, 1.720, -0.895> <-0.335, 1.552, -0.854> 
		<0.000, 2.153, -1.020> <-0.221, 2.153, -1.020> <-0.295, 1.783, -0.922> <-0.380, 1.585, -0.874> 
		<0.000, 2.200, -1.003> <-0.221, 2.200, -1.003> <-0.315, 1.798, -0.904> <-0.400, 1.600, -0.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 1.600, -0.759> <-0.498, 1.372, -0.703> <-0.578, 1.047, -0.620> <-0.600, 0.800, -0.562> 
		<-0.415, 1.611, -0.781> <-0.513, 1.383, -0.725> <-0.593, 1.065, -0.636> <-0.615, 0.818, -0.579> 
		<-0.419, 1.614, -0.839> <-0.517, 1.386, -0.783> <-0.596, 1.068, -0.707> <-0.618, 0.821, -0.650> 
		<-0.400, 1.600, -0.856> <-0.498, 1.372, -0.800> <-0.578, 1.047, -0.716> <-0.600, 0.800, -0.659> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.400, 1.600, -0.759> <-0.498, 1.372, -0.703> <-0.578, 1.047, -0.620> <-0.600, 0.800, -0.562> 
		<-0.384, 1.588, -0.735> <-0.482, 1.360, -0.679> <-0.548, 1.010, -0.586> <-0.570, 0.763, -0.529> 
		<-0.340, 1.556, -0.715> <-0.428, 1.300, -0.652> <-0.522, 0.966, -0.569> <-0.514, 0.695, -0.508> 
		<-0.319, 1.541, -0.733> <-0.408, 1.285, -0.670> <-0.486, 0.923, -0.587> <-0.479, 0.652, -0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.319, 1.541, -0.733> <-0.408, 1.285, -0.670> <-0.486, 0.923, -0.587> <-0.479, 0.652, -0.526> 
		<-0.300, 1.526, -0.750> <-0.389, 1.271, -0.687> <-0.469, 0.901, -0.595> <-0.462, 0.630, -0.535> 
		<-0.305, 1.530, -0.807> <-0.393, 1.274, -0.744> <-0.471, 0.905, -0.666> <-0.464, 0.633, -0.606> 
		<-0.319, 1.541, -0.830> <-0.408, 1.285, -0.767> <-0.486, 0.923, -0.683> <-0.479, 0.652, -0.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.319, 1.541, -0.830> <-0.335, 1.552, -0.854> <-0.380, 1.585, -0.874> <-0.400, 1.600, -0.856> 
		<-0.408, 1.285, -0.767> <-0.423, 1.296, -0.791> <-0.477, 1.357, -0.818> <-0.498, 1.372, -0.800> 
		<-0.486, 0.923, -0.683> <-0.517, 0.960, -0.716> <-0.543, 1.004, -0.734> <-0.578, 1.047, -0.716> 
		<-0.479, 0.652, -0.623> <-0.509, 0.689, -0.656> <-0.565, 0.757, -0.677> <-0.600, 0.800, -0.659> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, 1.600, -0.759> <0.498, 1.372, -0.703> <0.578, 1.047, -0.620> <0.600, 0.800, -0.562> 
		<0.384, 1.588, -0.735> <0.482, 1.360, -0.679> <0.548, 1.010, -0.586> <0.570, 0.763, -0.529> 
		<0.340, 1.556, -0.715> <0.428, 1.300, -0.652> <0.522, 0.966, -0.569> <0.514, 0.695, -0.508> 
		<0.319, 1.541, -0.733> <0.408, 1.285, -0.670> <0.486, 0.923, -0.587> <0.479, 0.652, -0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, 1.600, -0.759> <0.498, 1.372, -0.703> <0.578, 1.047, -0.620> <0.600, 0.800, -0.562> 
		<0.415, 1.611, -0.781> <0.513, 1.383, -0.725> <0.593, 1.065, -0.636> <0.615, 0.818, -0.579> 
		<0.419, 1.614, -0.839> <0.517, 1.386, -0.783> <0.596, 1.068, -0.707> <0.618, 0.821, -0.650> 
		<0.400, 1.600, -0.856> <0.498, 1.372, -0.800> <0.578, 1.047, -0.716> <0.600, 0.800, -0.659> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.319, 1.541, -0.733> <0.408, 1.285, -0.670> <0.486, 0.923, -0.587> <0.479, 0.652, -0.526> 
		<0.300, 1.526, -0.750> <0.389, 1.271, -0.687> <0.469, 0.901, -0.595> <0.462, 0.630, -0.535> 
		<0.305, 1.530, -0.807> <0.393, 1.274, -0.744> <0.471, 0.905, -0.666> <0.464, 0.633, -0.606> 
		<0.319, 1.541, -0.830> <0.408, 1.285, -0.767> <0.486, 0.923, -0.683> <0.479, 0.652, -0.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, 1.600, -0.856> <0.380, 1.585, -0.874> <0.335, 1.552, -0.854> <0.319, 1.541, -0.830> 
		<0.498, 1.372, -0.800> <0.477, 1.357, -0.818> <0.423, 1.296, -0.791> <0.408, 1.285, -0.767> 
		<0.578, 1.047, -0.716> <0.543, 1.004, -0.734> <0.517, 0.960, -0.716> <0.486, 0.923, -0.683> 
		<0.600, 0.800, -0.659> <0.565, 0.757, -0.677> <0.509, 0.689, -0.656> <0.479, 0.652, -0.623> 
	}
}
// Layer 4
#declare spokes = 
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.027, 2.150, -0.950> <-0.027, 2.150, -0.950> <-0.027, 2.150, -0.950> <-0.027, 2.150, -0.950> 
		<-0.027, 2.150, -0.965> <-0.027, 2.150, -0.950> <-0.027, 2.150, -0.950> <-0.027, 2.150, -0.935> 
		<-0.015, 2.150, -0.977> <-0.015, 2.150, -0.961> <-0.015, 2.150, -0.939> <-0.015, 2.150, -0.923> 
		<0.000, 2.150, -0.977> <0.000, 2.150, -0.961> <0.000, 2.150, -0.939> <0.000, 2.150, -0.923> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.027, 2.150, -0.950> <-0.027, 2.150, -0.965> <-0.015, 2.150, -0.977> <0.000, 2.150, -0.977> 
		<-0.027, 1.565, -0.815> <-0.027, 1.565, -0.830> <-0.015, 1.565, -0.842> <0.000, 1.565, -0.842> 
		<-0.027, 0.785, -0.635> <-0.027, 0.785, -0.650> <-0.015, 0.785, -0.662> <0.000, 0.785, -0.662> 
		<-0.027, 0.200, -0.500> <-0.027, 0.200, -0.515> <-0.015, 0.200, -0.527> <0.000, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.027, 2.150, -0.950> <-0.027, 1.565, -0.815> <-0.027, 0.785, -0.635> <-0.027, 0.200, -0.500> 
		<-0.027, 2.150, -0.935> <-0.027, 1.565, -0.800> <-0.027, 0.785, -0.620> <-0.027, 0.200, -0.485> 
		<-0.015, 2.150, -0.923> <-0.015, 1.565, -0.788> <-0.015, 0.785, -0.608> <-0.015, 0.200, -0.473> 
		<0.000, 2.150, -0.923> <0.000, 1.565, -0.788> <0.000, 0.785, -0.608> <0.000, 0.200, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 2.150, -0.950> <0.027, 2.150, -0.935> <0.015, 2.150, -0.923> <0.000, 2.150, -0.923> 
		<0.027, 1.565, -0.815> <0.027, 1.565, -0.800> <0.015, 1.565, -0.788> <0.000, 1.565, -0.788> 
		<0.027, 0.785, -0.635> <0.027, 0.785, -0.620> <0.015, 0.785, -0.608> <0.000, 0.785, -0.608> 
		<0.027, 0.200, -0.500> <0.027, 0.200, -0.485> <0.015, 0.200, -0.473> <0.000, 0.200, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 2.150, -0.950> <0.027, 2.150, -0.950> <0.027, 2.150, -0.950> <0.027, 2.150, -0.950> 
		<0.027, 2.150, -0.935> <0.027, 2.150, -0.950> <0.027, 2.150, -0.950> <0.027, 2.150, -0.965> 
		<0.015, 2.150, -0.923> <0.015, 2.150, -0.939> <0.015, 2.150, -0.961> <0.015, 2.150, -0.977> 
		<0.000, 2.150, -0.923> <0.000, 2.150, -0.939> <0.000, 2.150, -0.961> <0.000, 2.150, -0.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 2.150, -0.950> <0.027, 1.565, -0.815> <0.027, 0.785, -0.635> <0.027, 0.200, -0.500> 
		<0.027, 2.150, -0.965> <0.027, 1.565, -0.830> <0.027, 0.785, -0.650> <0.027, 0.200, -0.515> 
		<0.015, 2.150, -0.977> <0.015, 1.565, -0.842> <0.015, 0.785, -0.662> <0.015, 0.200, -0.527> 
		<0.000, 2.150, -0.977> <0.000, 1.565, -0.842> <0.000, 0.785, -0.662> <0.000, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.027, 0.200, -0.500> <-0.027, 0.200, -0.500> <-0.027, 0.200, -0.500> <-0.027, 0.200, -0.500> 
		<-0.027, 0.200, -0.485> <-0.027, 0.200, -0.500> <-0.027, 0.200, -0.500> <-0.027, 0.200, -0.515> 
		<-0.015, 0.200, -0.473> <-0.015, 0.200, -0.489> <-0.015, 0.200, -0.511> <-0.015, 0.200, -0.527> 
		<0.000, 0.200, -0.473> <0.000, 0.200, -0.489> <0.000, 0.200, -0.511> <0.000, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.027, 0.200, -0.500> <0.027, 0.200, -0.500> <0.027, 0.200, -0.500> <0.027, 0.200, -0.500> 
		<0.027, 0.200, -0.515> <0.027, 0.200, -0.500> <0.027, 0.200, -0.500> <0.027, 0.200, -0.485> 
		<0.015, 0.200, -0.527> <0.015, 0.200, -0.511> <0.015, 0.200, -0.489> <0.015, 0.200, -0.473> 
		<0.000, 0.200, -0.527> <0.000, 0.200, -0.511> <0.000, 0.200, -0.489> <0.000, 0.200, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.373, 1.550, -0.800> <0.373, 1.550, -0.800> <0.373, 1.550, -0.800> <0.373, 1.550, -0.800> 
		<0.373, 1.550, -0.815> <0.373, 1.550, -0.800> <0.373, 1.550, -0.800> <0.373, 1.550, -0.785> 
		<0.385, 1.550, -0.827> <0.385, 1.550, -0.811> <0.385, 1.550, -0.789> <0.385, 1.550, -0.773> 
		<0.400, 1.550, -0.827> <0.400, 1.550, -0.811> <0.400, 1.550, -0.789> <0.400, 1.550, -0.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.373, 1.550, -0.800> <0.373, 1.550, -0.815> <0.385, 1.550, -0.827> <0.400, 1.550, -0.827> 
		<0.298, 1.145, -0.710> <0.298, 1.145, -0.725> <0.310, 1.145, -0.737> <0.325, 1.145, -0.737> 
		<0.198, 0.605, -0.590> <0.198, 0.605, -0.605> <0.210, 0.605, -0.617> <0.225, 0.605, -0.617> 
		<0.123, 0.200, -0.500> <0.123, 0.200, -0.515> <0.135, 0.200, -0.527> <0.150, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.373, 1.550, -0.800> <0.298, 1.145, -0.710> <0.198, 0.605, -0.590> <0.123, 0.200, -0.500> 
		<0.373, 1.550, -0.785> <0.298, 1.145, -0.695> <0.198, 0.605, -0.575> <0.123, 0.200, -0.485> 
		<0.385, 1.550, -0.773> <0.310, 1.145, -0.683> <0.210, 0.605, -0.563> <0.135, 0.200, -0.473> 
		<0.400, 1.550, -0.773> <0.325, 1.145, -0.683> <0.225, 0.605, -0.563> <0.150, 0.200, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 1.550, -0.800> <0.427, 1.550, -0.785> <0.415, 1.550, -0.773> <0.400, 1.550, -0.773> 
		<0.352, 1.145, -0.710> <0.352, 1.145, -0.695> <0.340, 1.145, -0.683> <0.325, 1.145, -0.683> 
		<0.252, 0.605, -0.590> <0.252, 0.605, -0.575> <0.240, 0.605, -0.563> <0.225, 0.605, -0.563> 
		<0.177, 0.200, -0.500> <0.177, 0.200, -0.485> <0.165, 0.200, -0.473> <0.150, 0.200, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 1.550, -0.800> <0.427, 1.550, -0.800> <0.427, 1.550, -0.800> <0.427, 1.550, -0.800> 
		<0.427, 1.550, -0.785> <0.427, 1.550, -0.800> <0.427, 1.550, -0.800> <0.427, 1.550, -0.815> 
		<0.415, 1.550, -0.773> <0.415, 1.550, -0.789> <0.415, 1.550, -0.811> <0.415, 1.550, -0.827> 
		<0.400, 1.550, -0.773> <0.400, 1.550, -0.789> <0.400, 1.550, -0.811> <0.400, 1.550, -0.827> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 1.550, -0.800> <0.352, 1.145, -0.710> <0.252, 0.605, -0.590> <0.177, 0.200, -0.500> 
		<0.427, 1.550, -0.815> <0.352, 1.145, -0.725> <0.252, 0.605, -0.605> <0.177, 0.200, -0.515> 
		<0.415, 1.550, -0.827> <0.340, 1.145, -0.737> <0.240, 0.605, -0.617> <0.165, 0.200, -0.527> 
		<0.400, 1.550, -0.827> <0.325, 1.145, -0.737> <0.225, 0.605, -0.617> <0.150, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.123, 0.200, -0.500> <0.123, 0.200, -0.500> <0.123, 0.200, -0.500> <0.123, 0.200, -0.500> 
		<0.123, 0.200, -0.485> <0.123, 0.200, -0.500> <0.123, 0.200, -0.500> <0.123, 0.200, -0.515> 
		<0.135, 0.200, -0.473> <0.135, 0.200, -0.489> <0.135, 0.200, -0.511> <0.135, 0.200, -0.527> 
		<0.150, 0.200, -0.473> <0.150, 0.200, -0.489> <0.150, 0.200, -0.511> <0.150, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.177, 0.200, -0.500> <0.177, 0.200, -0.500> <0.177, 0.200, -0.500> <0.177, 0.200, -0.500> 
		<0.177, 0.200, -0.515> <0.177, 0.200, -0.500> <0.177, 0.200, -0.500> <0.177, 0.200, -0.485> 
		<0.165, 0.200, -0.527> <0.165, 0.200, -0.511> <0.165, 0.200, -0.489> <0.165, 0.200, -0.473> 
		<0.150, 0.200, -0.527> <0.150, 0.200, -0.511> <0.150, 0.200, -0.489> <0.150, 0.200, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.427, 1.550, -0.800> <-0.427, 1.550, -0.800> <-0.427, 1.550, -0.800> <-0.427, 1.550, -0.800> 
		<-0.427, 1.550, -0.815> <-0.427, 1.550, -0.800> <-0.427, 1.550, -0.800> <-0.427, 1.550, -0.785> 
		<-0.415, 1.550, -0.827> <-0.415, 1.550, -0.811> <-0.415, 1.550, -0.789> <-0.415, 1.550, -0.773> 
		<-0.400, 1.550, -0.827> <-0.400, 1.550, -0.811> <-0.400, 1.550, -0.789> <-0.400, 1.550, -0.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.427, 1.550, -0.800> <-0.427, 1.550, -0.815> <-0.415, 1.550, -0.827> <-0.400, 1.550, -0.827> 
		<-0.352, 1.145, -0.710> <-0.352, 1.145, -0.725> <-0.340, 1.145, -0.737> <-0.325, 1.145, -0.737> 
		<-0.252, 0.605, -0.590> <-0.252, 0.605, -0.605> <-0.240, 0.605, -0.617> <-0.225, 0.605, -0.617> 
		<-0.177, 0.200, -0.500> <-0.177, 0.200, -0.515> <-0.165, 0.200, -0.527> <-0.150, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.427, 1.550, -0.800> <-0.352, 1.145, -0.710> <-0.252, 0.605, -0.590> <-0.177, 0.200, -0.500> 
		<-0.427, 1.550, -0.785> <-0.352, 1.145, -0.695> <-0.252, 0.605, -0.575> <-0.177, 0.200, -0.485> 
		<-0.415, 1.550, -0.773> <-0.340, 1.145, -0.683> <-0.240, 0.605, -0.563> <-0.165, 0.200, -0.473> 
		<-0.400, 1.550, -0.773> <-0.325, 1.145, -0.683> <-0.225, 0.605, -0.563> <-0.150, 0.200, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.373, 1.550, -0.800> <-0.373, 1.550, -0.785> <-0.385, 1.550, -0.773> <-0.400, 1.550, -0.773> 
		<-0.298, 1.145, -0.710> <-0.298, 1.145, -0.695> <-0.310, 1.145, -0.683> <-0.325, 1.145, -0.683> 
		<-0.198, 0.605, -0.590> <-0.198, 0.605, -0.575> <-0.210, 0.605, -0.563> <-0.225, 0.605, -0.563> 
		<-0.123, 0.200, -0.500> <-0.123, 0.200, -0.485> <-0.135, 0.200, -0.473> <-0.150, 0.200, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.373, 1.550, -0.800> <-0.373, 1.550, -0.800> <-0.373, 1.550, -0.800> <-0.373, 1.550, -0.800> 
		<-0.373, 1.550, -0.785> <-0.373, 1.550, -0.800> <-0.373, 1.550, -0.800> <-0.373, 1.550, -0.815> 
		<-0.385, 1.550, -0.773> <-0.385, 1.550, -0.789> <-0.385, 1.550, -0.811> <-0.385, 1.550, -0.827> 
		<-0.400, 1.550, -0.773> <-0.400, 1.550, -0.789> <-0.400, 1.550, -0.811> <-0.400, 1.550, -0.827> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.373, 1.550, -0.800> <-0.298, 1.145, -0.710> <-0.198, 0.605, -0.590> <-0.123, 0.200, -0.500> 
		<-0.373, 1.550, -0.815> <-0.298, 1.145, -0.725> <-0.198, 0.605, -0.605> <-0.123, 0.200, -0.515> 
		<-0.385, 1.550, -0.827> <-0.310, 1.145, -0.737> <-0.210, 0.605, -0.617> <-0.135, 0.200, -0.527> 
		<-0.400, 1.550, -0.827> <-0.325, 1.145, -0.737> <-0.225, 0.605, -0.617> <-0.150, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.177, 0.200, -0.500> <-0.177, 0.200, -0.500> <-0.177, 0.200, -0.500> <-0.177, 0.200, -0.500> 
		<-0.177, 0.200, -0.485> <-0.177, 0.200, -0.500> <-0.177, 0.200, -0.500> <-0.177, 0.200, -0.515> 
		<-0.165, 0.200, -0.473> <-0.165, 0.200, -0.489> <-0.165, 0.200, -0.511> <-0.165, 0.200, -0.527> 
		<-0.150, 0.200, -0.473> <-0.150, 0.200, -0.489> <-0.150, 0.200, -0.511> <-0.150, 0.200, -0.527> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.123, 0.200, -0.500> <-0.123, 0.200, -0.500> <-0.123, 0.200, -0.500> <-0.123, 0.200, -0.500> 
		<-0.123, 0.200, -0.515> <-0.123, 0.200, -0.500> <-0.123, 0.200, -0.500> <-0.123, 0.200, -0.485> 
		<-0.135, 0.200, -0.527> <-0.135, 0.200, -0.511> <-0.135, 0.200, -0.489> <-0.135, 0.200, -0.473> 
		<-0.150, 0.200, -0.527> <-0.150, 0.200, -0.511> <-0.150, 0.200, -0.489> <-0.150, 0.200, -0.473> 
	}
}

#local texscalefact = 0.008;             
             
#declare cjrhchair =
union {
  object { legs texture { EMBWood1 scale texscalefact } }
  object { seat texture { EMBWood1 scale texscalefact } }                      
  object { arch texture { EMBWood1 scale texscalefact rotate 70*x} }                      
  object { spokes texture { EMBWood1 scale texscalefact rotate 90*x } }                                            
  rotate 180*y 
  translate 1.78*y
  scale 20
}