// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
#include "textures.inc"     
// various (mostly layered) wood textures
// T_Wood1 - T_Wood35
#include "woods.inc"
     
     
global_settings {
  assumed_gamma 1.0
  //max_trace_level 9
}

// ----------------------------------------

camera {
  location  <0.0, 7, -10.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  4.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.9,0.9,0.9> }
  normal { crackle 0.4 no_bump_scale scale 0.2 }
  finish { specular 0.2 }
}

// Dreamcatcher
#declare innerclip = 0.3;
#declare outerclip = 1;
#declare strandr = 0.7;
#declare ringthk = 0.05;        
#declare strandthk = 0.005;

// Outer ring    
#declare bigring =    
torus {
  outerclip,
  ringthk    
  texture { T_Wood1 
            normal { 
              pigment_pattern { 
                P_WoodGrain1B 
              } 
              bump_size 5 
            }
            rotate 90*x
  }
  
}
             
// Inner ring     
#declare littlering =        
torus {
  innerclip,
  ringthk    
  texture { T_Wood1 
            normal { 
              pigment_pattern { 
                P_WoodGrain1B 
              } 
              bump_size 5 
            }
            rotate 90*x
  }

}   
             
// Single Strand             
#declare insidestrand =
intersection {
  torus {
    strandr,
    strandthk    
    translate strandr*x
  }
  cylinder {
    -1*y,  1*y,  outerclip+ringthk
    // open      
    //translate strandr*x
  }    
  box {
    <-5,-1,0>,<5,1,5>
  }  
}
                      
#declare cutinsidestrand =                       
difference {
  object { insidestrand }
  cylinder {
    -1*y,  1*y,  innerclip
    // open
  }
}  
                          
// One-way web of strands
#declare onewayweb =
union{
 #local Nr = 0;     // start
 #local EndNr = 30; // end
 #while (Nr< EndNr) 
   object{
     cutinsidestrand           
     pigment { color rgb <0.2,0.1,0> }
     //translate<1,0.25,0> 
     rotate<0,Nr * 360/EndNr,0>
   } 
 #local Nr = Nr + 1;    // next Nr
 #end // ---------------  end of loop 
rotate<0,0,0>
translate<0,0,0>} // end of union
                         
// Both inner strand webs                         
#declare webs =
union {
    object { onewayweb }
    object { onewayweb rotate 180*z }
}
      
// ********************************************************

// Feather

#declare feathershape = function(xval) { 0.5* (-3.5734*pow(xval,4) 
                                         +8.0615*pow(xval,3)
                                         -6.6558*pow(xval,2) 
                                         +2.1614*xval) }
         
#declare halffeather =         
union{
 #declare Nr = 0;     // start
 #declare EndNr = 200; // end
 #while (Nr< EndNr) 
   
   cylinder {                                 
     #local xval = Nr/EndNr;
     <xval,0,0>,  <xval+0.05,0,feathershape(xval)>  0.001
     // open                                 
   }

 #declare Nr = Nr + 1;  // next Nr
 #end // --------------- end of loop 
 texture { 
  pigment { bozo
            color_map {
              [0.0 color rgb <1,1,1>]
              [0.2 color rgb <0.4,0.35,0.2>]
              [0.5 color rgb <0.8,0.75,0.4>]
              [1.0 color rgb <0.95,0.95,0.8>]
            }  
  
  }      
  finish { specular 0.3 }
  scale 0.1
}

rotate<0,0,0> 
translate<0,0,0>} // end of union
 
#declare featherspine =
cone {
  0*x,  0.006,
  1*x,  0.005
  // open    
  pigment { color rgb <1,1,0.95> }
  finish { phong 0.3 specular 0.3 }
}
 
// Complete feather      
#declare feather =
union {                      
  object { halffeather }
  object { featherspine }
  object { halffeather rotate 180*x }
  rotate 90*y
}
         

// Featherbunch
  
#declare fbR = seed(1);
  
#declare featherbunch =  
union{
 #local Nr = 0;     // start
 #local EndNr = 20; // end
 #while (Nr< EndNr) 
   object{ feather 
           translate<0,0,0> 
           #local val1 = (Nr * 360/EndNr)*(rand(fbR)-0.5)/5;
           #local val2 = (Nr * 360/EndNr)*(rand(fbR)-0.5)/5;
           #local val3 = (Nr * 360/EndNr)*(rand(fbR)-0.5)/5;
           #local val4 = rand(fbR)+0.1;
           
           rotate< val1, val2, val3> 
           scale val4
         } 

 #local Nr = Nr + 1;    // next Nr
 #end // ---------------  end of loop 
rotate<0,0,0>
translate<0,0,0>} // end of union

//object { feather translate -2*z }
#declare featherbunches =
union {
    object { featherbunch scale 1.0 translate -2*z }
    object { featherbunch rotate -45*z scale 0.5 translate -1.2*z  }                                                                                
}

// Connecting rope
// ...center rope
#declare ropes =
union {
      cylinder {
        -2*z,  -1*z,  0.01
        pigment { color rgb <0.3,0.2,0.05> }
      }                              
      #declare smallknot =
      torus { 
        0.06, 
        0.01
        rotate 90*z
        translate -1*z                      
        pigment { color rgb <0.3,0.2,0.05> }
      }                   
      
      object { smallknot }
      
      // ...left rope
      cylinder {
        -2*z,  -1*z,  0.01
        pigment { color rgb <0.3,0.2,0.05> }
        translate -0.7*x
        translate 0.206*z
      }                   
      object { smallknot rotate 43*y}
      
      // ...right rope
      cylinder {
        -2*z,  -1*z,  0.01
        pigment { color rgb <0.3,0.2,0.05> }
        translate 0.7*x
        translate 0.206*z
      }
      object { smallknot rotate -43*y}
                         
      // Top rope
      cylinder {
        300*z,  1*z,  0.01
        pigment { color rgb <0.3,0.2,0.05> }
      }                              
      #declare smallknot =
      torus { 
        0.06, 
        0.01
        rotate 90*z
        translate 1*z                      
        pigment { color rgb <0.3,0.2,0.05> }
      }                   
}                   
                   
// Crystals
    
#declare basecrystalbox = 
box {
  <0,0,0>,
  <1,1,1>                 
  translate <-0.5,-0.5,-0.5> // centering
}     

#declare subtractbits = 
union{
 #local Nr = 0;     // start
 #local EndNr = 9; // end
 #local subwidth = 0.6;
 #local sidewidth = 0.7;
 #while (Nr< EndNr) 
   // Top
   object{ basecrystalbox 
           scale <1,1,1>
           rotate 30*z            
           translate (subwidth+0.1)*y 
           translate -subwidth*x
           rotate<0,Nr * 360/EndNr,0> 
         }
            
   // Sides         
   object{ basecrystalbox 
           translate sidewidth*x 
           rotate<0,Nr * 360/EndNr,0> }  
            
   // Bottom
   object{ basecrystalbox 
           scale <1,1,1>
           rotate 30*z            
           translate -(subwidth+0.1)*y
           translate subwidth*x
           rotate<0,Nr * 360/EndNr,0> 
         }  

 #local Nr = Nr + 1;    // next Nr
 #end // ---------------  end of loop 
rotate<0,0,0>
translate<0,0,0>} // end of union

#declare crystalpiece =
difference {
  object { basecrystalbox  }
  object { subtractbits  }
  scale 1.5*y
}
       
#declare cpleft =       
object { crystalpiece 
         pigment { color rgbf <1,0.9,1,0.9> }
         finish { phong 0.1 }
         interior { ior 2.6 }
         scale 0.5       
         rotate 90*x
         translate <-0.7,0,-2> 
}
                 
#declare cpright =                  
object { crystalpiece 
         pigment { color rgbf <0.8,0.8,1,0.9> }
         finish { phong 0.1 }
         interior { ior 2.6 }
         scale 0.5       
         rotate 90*x
         translate <0.7,0,-2> 
}

#declare dreamcatcher = 
union {
  object { bigring }
  object { webs }    
  object { littlering }
  object { ropes }        
  object { featherbunches }        
  object { cpleft }
  object { cpright }   
  rotate -90*x 
  translate 3*y                            
}

object { dreamcatcher } 
    
/*                  
union{
 #declare NrX = 0;     // start x
 #declare EndNrX = 3; // end   x
 #while (NrX< EndNrX) 
    // inner loop
    #declare NrZ = 0;     // start z
    #declare EndNrZ = 3; // end   z
    #while (NrZ< EndNrZ) 
     
      object{ dreamcatcher translate<NrX*4, 0, NrZ*4>} 

    #declare NrZ = NrZ + 1;  // next Nr z
    #end // --------------- end of loop z
    // end inner loop
 #declare NrX = NrX + 1;  // next Nr x
 #end // --------------- end of loop x
 // end of outer loop
rotate<0,0,0> 
translate<-1.5,0,0>} // end of union
*/                  
                  
                  