// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 350                      // higher -> higher quality (1..1600) [35]
    nearest_count 2               // higher -> higher quality (1..10) [5]
    error_bound 0.18               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}

// perspective (default) camera
camera {
  location  <-10.0, 10.0, -10.0>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
}

box {
  <-110,0,-110>,
  <11,100,11>
  hollow
  pigment { color rgb <0.99,0.99,0.99> }
  finish { ambient 0.0 diffuse 1.0 }
}  

plane {
  y, 50
  pigment { color rgb <1,1,1> }
  finish { ambient 1 } 
}       
       
// create a sphere shape
sphere {
  <0, 1, 0> // center of sphere <X Y Z>
  1       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling
  scale 3
  texture {
    pigment { 
      color rgb <0.5,0.6,0.8> 
    }
    normal {
      bumps
      scale 0.1 
    }
    finish {
      ambient 0.0
      diffuse 1.0
    }
  }
}

 
 