
#version 3.5;

#include "FusionPower.inc"
#include "DishArray.inc"
#include "GreenHouse.inc"
#include "Resident.inc" 
#include "Misc.inc"

#include "functions.inc"

global_settings {
	max_trace_level 10
	assumed_gamma 1.0
	/*
	ambient_light <0,0,0>
 	radiosity{
		pretrace_start 0.08
  		pretrace_end   0.01
    	count 35
     	nearest_count 5
      	error_bound 0.7
      	recursion_limit 1
      	low_error_factor 0.8
      	gray_threshold 0.25
      	minimum_reuse 0.015
      	brightness 1.0
      	adc_bailout 0.01/2
      	normal on
	}
	*/
}
 
#default{ finish{ ambient 0.02} } 
 
camera {
   location  <6.5, 6.5, 5>+<0.15, 0.5, 0>
   direction y
   sky       z
   up        z
   right     x*16/9
   look_at	 <0,0,0>+<0.15, 0.5, 0>
   angle     45
}

light_source {
	<-0.7, 0.83, 0.55>*150000
	color rgb <1,1,1>
}
// Ambient light, sorta'
light_source {
	<0.9, -0.6, 0.5>*150000
	color rgb <0.556863,0.137255,0.137255>*0.20+0.10
	shadowless
}

// Sky 
sphere {
  <0, 0, 0>, 1
  texture {
	pigment {
     gradient z
     color_map {
       [0.0 color rgb < 1.0, 1.0, 1.0 >]
       [0.3 color rgb < 0.3, 0.3, 1.0 >]
     }
   }
   finish { diffuse 0 ambient 1 }
  }
  scale 10000
  hollow on
  no_shadow
}

// Ground level
isosurface{
	function{ max(z-0.5*f_ridged_mf(x, y, z, 0.1, 3.1, 8 ,0.7, 0.9, 3), 
				  -min( f_rounded_box(x,y,z-3.5, 0.5, 3.5,3.5,3.5), 
				  		f_rounded_box(x,y+5,z-2.5, 0.5, 2.5,2.5,2.5),
				  		f_rounded_box(x,y-4,z-1.5, 0.5, 1.5,1.5,1.5)
				   )
			  ) }
	max_gradient 8.732
	accuracy 0.001
	contained_by{ box{ <-11,-11,-0.001>, <6,6,0.5> } }
	texture{ 
		pigment{ color red 0.556863 green 0.137255 blue 0.137255 }
		finish {
			diffuse 0.4
		}
		normal{ bumps 1.0 scale 0.001 }
	}
	
}             

// All objects
object{ FusionPower scale 1.5 translate<0,-5,0> }

object{ Resident translate<-2, -2, 0> }
object{ Resident translate< 0, -2, 0> }
object{ Resident translate< 2, -2, 0> }

object{ GreenHouse translate<-2, 0, 0> }
object{ GreenHouse translate<-2, 2, 0> }
object{ GreenHouse translate< 0, 0, 0> }
object{ GreenHouse translate< 0, 2, 0> }
object{ GreenHouse translate< 2, 0, 0> }
object{ GreenHouse translate< 2, 2, 0> }

object{ DishArray(60, 180-35) translate<0,4,0> }

// The "murder scene"

object{ Astro(<1,1,0>) translate<0,0,-0.011> rotate<0,90,0> translate<-0.8,3.3,0>}

#local COP_STREAM = seed(14);
       
#local COP_NR = 1;
#while(COP_NR < 7)
	#local ANGLE = rand(COP_STREAM)*2*pi;
	#local DIST = rand(COP_STREAM)*0.04+0.03;
	#local XPOS = cos(ANGLE)*DIST;
	#local YPOS = sin(ANGLE)*DIST;
	object{ Astro(<0.3,0.3,2>) translate<-0.8+XPOS,3.3+YPOS,0>}
	
	#local COP_NR=COP_NR+1;
#end

