#version unofficial MegaPov 0.7;

#declare Sand = texture {
  pigment {image_map {tga "008eau.tga" interpolate 2 map_type 0} rotate 90*x}
  finish {ambient 0 diffuse 1 brilliance 1 phong 0.3 phong_size 40}
  normal {granite 0.1 turbulence 0.5 scale 0.2}
  scale 20
}

#declare Water =  material {
  texture {
    pigment {color rgbf <0.9,0.9,1,0.9>}
    finish {
      ambient 0
      diffuse 0.1
      reflection_min 0.1
      reflection_max 0.7
      conserve_energy
      phong 1
      phong_size 120
      specular 0.5
      roughness 0.05
      brilliance 1
      metallic 0.5
    }
    normal {bumps 0.1 turbulence 0.3 scale <12,8,8>}      
  }   
  interior {ior 1.33 caustics 0.4 media {absorption <0.45, 0.3, 0.15>}}
}
 
#declare Stone = texture {
  pigment {image_map {tga "047roche.tga" interpolate 2 map_type 1}} 
  finish {ambient 0.1 diffuse 1 brilliance 1 phong 0.5 phong_size 40}
  normal {granite 0.2 turbulence 0.5 scale 0.01}
}

#declare PlanetSurface = texture {      
  pigment {
    gradient y
    color_map {
      [ 0.0  rgb <1.0,1.0,0.9>]
      [ 0.56 rgb <0.853,0.718,0.541>]
      [ 0.66 rgb <0.936,0.881,0.684>]
      [ 0.83 rgb <0.852,0.718,0.541>]
      [ 1.0  rgb <1.0,1.0,1.0>]
    }
    turbulence 0.5
    lambda 4.0
    frequency 3.0
    ramp_wave
  }      
  finish {
    ambient 0
    diffuse 0.6
    brilliance 1
    phong 0.1 phong_size 5
  }      
  scale  <9.0,1.0,9.0>
}

#declare A = seed(123);

#declare m_r = 0.3;

#declare IridMetal = texture { 
  wrinkles
  scale 0.1 
  warp {reset_children}
  texture_map {
    [0 pigment {
         wrinkles 
         color_map {
           #declare n=100;
           #declare i=0;
           #while (i<=1) 
             [i rgb <1+m_r*rand(A)-m_r*rand(A),0.93+m_r*rand(A)-m_r*rand(A),0.9+m_r*rand(A)-m_r*rand(A)>]
             #declare i=i+1/n;
           #end
         }
         scale 0.05
       }
       finish {ambient 0 diffuse 0.4 reflection_max 0.6 reflection_min 0.3 reflect_metallic metallic specular 1 roughness 0.007}
       normal {dents 0.35 scale 0.05}
    ]
    [1 pigment { 
         wrinkles 
         color_map {
           #declare n=100;
           #declare i=0;
           #while (i<=1)
             [i rgb <0.915+m_r*rand(A)-m_r*rand(A),0.85+m_r*rand(A)-m_r*rand(A),0.85+m_r*rand(A)-m_r*rand(A)>] 
             #declare i=i+1/n;
           #end 
         }
         scale 0.05
       }
       finish {ambient 0 diffuse 0.6 reflection_max 0.4 reflection_min 0.2 reflect_metallic metallic specular .7 roughness 0.02}
       normal {dents 0.5 scale 0.01}
    ]
  }
}  