/***********************************************************
 *                                                         *
 * Name        : Glass Towers                              *
 * File        : GlassTowers.pov                           *
 * Pov Version : 3.5                                       *
 * Version     : 1.0                                       *
 * Date        : Decmber 15, 2003                          *
 * Author      : Jamie Saunders                            *
 * Email       : kernal_the@hotmail.com                    *
 *                                                         *
 * Description                                             *
 *                                                         *
 ***********************************************************/
                                
#version 3.5;

#include "colors.inc"         
#include "textures.inc"          

#declare random_seed =seed(4050);
#declare elevatorheight = 0;              
#declare currentfloor = 0;

                             
#macro chooseColor()                                         
  #declare currentchoice = rand(random_seed);
  #declare currentchoice = currentchoice*10;
  #declare currentchoice = int(currentchoice);
  #switch (currentchoice)
    #case(0) pigment {color Red} #break
    #case(1) pigment {color Blue} #break
    #case(2) pigment {color Green} #break
    #case(3) pigment {color White} #break
    #case(4) pigment {color Yellow} #break
    #case(5) pigment {color Gray50} #break
    #case(6) pigment {color Orange} #break
    #case(7) pigment {color Red} #break
    #case(8) pigment {color Blue} #break
    #case(9) pigment {color Green} #break
  #else pigment {color Red} 
  #end                         
#end                           

#macro chooseHeight()
#declare elevatorheight = rand(random_seed);
#declare elevatorheight = elevatorheight * 30;
#end

#macro chooseFloor()
#declare currentfloor = rand(random_seed);
#declare currentfloor = int (currentfloor *4);
#declare currentfloor = currentfloor * 10; 
#end 

camera {
  location  <0.0, 45.0,  0.0>
  look_at   <0.0, 30.0,  50.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}               

box {
  <-10000, 0, -10000>, // <X Y Z> unit surface normal, vector points "away from surface"
  < 10000,-0.1, 10000>
  pigment { color <1.0, 1.0, 0.9>}
}


light_source {
  <0, 100, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
}

#declare i = -25;
#declare j = 0; 
//#declare i = 0;
//#declare j = 0; 
#declare glass_material  = M_Glass
#declare glass_material2 = M_Glass2

#while (i <= 25)
  #while (j <= 25) 
//#while (i <= 1)
//  #while (j <= 0) 
    union
    {
      cylinder 
      { 
        <i * 15, 0, j * 30 + 30>, 
        <i * 15, 30,j * 30 + 30>, 
        4
      }          
      difference 
      {
        sphere 
        {
          <i * 15, 30,j * 30 + 30> 
          4       
        } 
        cylinder 
        { 
          <i * 15, 0, j * 30 + 30>, 
          <i * 15, 30,j * 30 + 30>, 
          4.1
        }
      }          
      material{glass_material}
    }
    union
    {
      cylinder 
      { 
        <i * 15 - 7.5, 0, j * 30 + 45>, 
        <i * 15 - 7.5, 30,j * 30 + 45>, 
        4
      } 
      difference 
      {         
        sphere 
        {
          <i * 15 - 7.5, 30,j * 30 + 45> 
          4       
        } 
        cylinder 
        { 
          <i * 15 - 7.5, 0, j * 30 + 45>, 
          <i * 15 - 7.5, 30,j * 30 + 45>, 
          4.1
        } 
      }
      material{glass_material}
    }
    difference 
    {         
      union
      {   
        cylinder 
        { 
          <i * 15, 0, j * 30 + 30>,
          <i * 15, 0.1, j * 30 + 30>,
          3.9
          texture 
          {
            chooseColor()
          }                           
        }  
        cylinder 
        {
          <i * 15, 10, j * 30 + 30>,
          <i * 15, 10.1, j * 30 + 30>,
          3.9
          texture 
          {
            chooseColor()
          }
        }
        cylinder 
        {
          <i * 15, 20, j * 30 + 30>,
          <i * 15, 20.1, j * 30 + 30>,
          3.9
          texture 
          {
            chooseColor()
          }
        }
        cylinder 
        {
          <i * 15, 29.8, j * 30 + 30>,
          <i * 15, 29.9, j * 30 + 30>,
          3.9        
          texture 
          {
            chooseColor()
          }
    
        }
      }
      cylinder 
      {
        <i * 15, -1.0, j*30 + 30>,
        <i * 15, 31.0, j*30 + 30>,
        0.5
        material
        {
          glass_material2
        }
      }
    }
    difference 
    {
      union
      {                                                
        cylinder 
        {
          <i * 15 - 7.5, 0, j * 30 + 45>,
          <i * 15 - 7.5, 0.1, j * 30 + 45>,
          3.9
          texture 
          {
            chooseColor()
          }
        }
        cylinder 
        {
          <i * 15 - 7.5, 10, j * 30 + 45>,
          <i * 15 - 7.5, 10.1, j * 30 + 45>,
          3.9
          texture 
          {
            chooseColor()
          }
        }
        cylinder 
        {
          <i * 15 - 7.5, 20, j * 30 + 45>,
          <i * 15 - 7.5, 20.1, j * 30 + 45>,
          3.9
          texture 
          {
            chooseColor()
          }
        }
        cylinder 
        {
          <i * 15 - 7.5, 29.8, j * 30 + 45>,
          <i * 15 - 7.5, 29.9, j * 30 + 45>,
          3.9        
          texture 
          {
            chooseColor()
          }
        }                                               
      }   
      cylinder 
      {
        <i * 15 - 7.5, -1.0, j*30 + 45>,
        <i * 15 - 7.5, 31.0, j*30 + 45>,
        0.5
        material
        {
          glass_material2
        }
      }
    }    
    union
    {
      cylinder 
      {
        <i * 15 - 7.5, -1.0, j*30 + 30>,
        <i * 15 - 7.5, 31.0, j*30 + 30>,
        0.5
        material
        {
          glass_material2
        }
      }
      cylinder 
      {
        <i * 15, -1.0, j*30 + 30>,
        <i * 15, 31.0, j*30 + 30>,
        0.5
        material
        {
          glass_material2
        }
      }    
      cylinder 
      {
        <i * 15 - 7.5, -1.0, j*30 + 45>,
        <i * 15 - 7.5, 31.0, j*30 + 45>,
        0.5
        material
        {
          glass_material2
        }
      }
      cylinder 
      {
        <i * 15, -1.0, j*30 + 45>,
        <i * 15, 31.0, j*30 + 45>,
        0.5
        material
        {
          glass_material2
        }
      }                                
    }
    union
    {
      cylinder 
      {      
        chooseHeight()
        <i * 15 - 7.5, elevatorheight, j*30 + 30>,
        <i * 15 - 7.5, elevatorheight + 3, j*30 + 30>,
        0.4
        texture
        {
          chooseColor()
        }
      }
      cylinder 
      {
        chooseHeight()
        <i * 15, elevatorheight, j*30 + 30>,
        <i * 15, elevatorheight + 3, j*30 + 30>,
        0.4
        texture
        {
          chooseColor()
        }
      }    
      cylinder 
      {
        chooseHeight()
        <i * 15 - 7.5, elevatorheight, j*30 + 45>,
        <i * 15 - 7.5, elevatorheight + 3, j*30 + 45>,
        0.4
        texture
        {
          chooseColor()
        }
      }
      cylinder 
      {
        chooseHeight()
        <i * 15, elevatorheight, j*30 + 45>,
        <i * 15, elevatorheight + 3, j*30 + 45>,
        0.5
        texture
        {
          chooseColor()
        }
      }                                
    }  

    union
    {
      cylinder 
      {      
        chooseFloor()
        <i * 15 - 7.5, currentfloor + 0.1, j*30 + 30>,
        <i * 15 - 7.5, currentfloor + 0.1, j*30 + 42>,
        0.4
        material
        {
          glass_material2
        }
      }
      cylinder 
      {      
        chooseFloor()
        <i * 15, currentfloor + 0.1, j*30 + 33>,
        <i * 15, currentfloor + 0.1, j*30 + 45>,
        0.4
        material
        {
          glass_material2
        }
      }      
      cylinder 
      {      
        chooseFloor()
        <i * 15 - 7.5, currentfloor + 0.1, j*30 + 30>,
        <i * 15 - 3  , currentfloor + 0.1, j*30 + 30>,
        0.4
        material
        {
          glass_material2
        }
      }      
      cylinder 
      {      
        chooseFloor()
        <i * 15 + 7.5, currentfloor + 0.1, j*30 + 30>,
        <i * 15 + 3  , currentfloor + 0.1, j*30 + 30>,
        0.4
        material
        {
          glass_material2
        }
      }      
      cylinder 
      {      
        chooseFloor()
        <i * 15 - 0,   currentfloor + 0.1, j*30 + 45>,
        <i * 15 - 4,   currentfloor + 0.1, j*30 + 45>,
        0.4
        material
        {
          glass_material2
        }
      }      
      cylinder 
      {      
        chooseFloor()
        <i * 15 + 0  , currentfloor + 0.1, j*30 + 45>,
        <i * 15 + 4  , currentfloor + 0.1, j*30 + 45>,
        0.4
        material
        {
          glass_material2
        }
      }      
      cylinder
      {
        chooseFloor()
        <i * 15 - 7.5, currentfloor + 0.1, j*30 + 48>,
        <i * 15 - 7.5, currentfloor + 0.1, j*30 + 60>,
        0.4
        material
        {
          glass_material2
        }
      }
      cylinder 
      {      
        chooseFloor()
        <i * 15, currentfloor + 0.1, j*30 + 57>,
        <i * 15, currentfloor + 0.1, j*30 + 45>,
        0.4
        material
        {
          glass_material2
        }
      }      

    }  
      
  #declare j = j + 1;
  #end              
#declare j = 0;
#declare i = i + 1;
#end      

                       
