 
cradle.pov      mZ  8"mY* M (mZ
4
H
   mZ 
iTEXTPOV3        $                           // Persistence of Vision Ray Tracer Scene Description File
// File: console.pov
// Vers: 3.5
// Desc: Console and monitors around the window for Leaving The
//		Cradle, entry for the Nov-Dec 2003 IRTC competition
// Date: 11.08.03
// Auth: JRE
//
#version 3.5;
#declare FakeIt = no;
#declare UseRad = no;

#if (UseRad)
#include "rad_def.inc"
#end

global_settings {
  assumed_gamma 1.0
	#if (UseRad)  radiosity {Rad_Settings(Radiosity_IndoorLQ,on,off)} #end
	max_trace_level 15 }
// ----------------------------------------
camera { 
  location  <0, 1.6,-5.31>
  //location <0,5,-10>
  direction 1.2*z
  //direction 1.5*z
  right     x*image_width/image_height
  look_at   <0, -2000,  300000>
  //look_at <0,0,5>
}

box { <-15,-1,-7> <15,7,-6> 
	texture { cells scale 0.5
		texture_map {
			[ 0.0 pigment { rgb <1,0.3,0> } finish { ambient 0.1 } ]
			[ 0.1 pigment { rgb <1,0.9,0> } finish { ambient 0.4 } ]
			[ 0.2 pigment { rgb <0.5,0.5,0> } finish { ambient 0.1 } ]
			[ 0.3 pigment { rgb <0,0.5,0.5>} finish { ambient 0.2 } ]
			[ 0.4 pigment { rgb <1,0.,0> } finish { ambient 0.4 } ]
			[ 0.5 pigment { rgb <0.1,0.0,0> } finish { ambient 0 } ] 
		  } }
	}
/*light_source {
	<0,3,-5> color rgb 1
	area_light <2,0,0> <0,1,0> 5, 1
	}*/
cylinder { <-2,2,-5> <2,2,-5> 0.2
	pigment { rgb 1 }
	finish { ambient 1 } }
	
#if (!FakeIt)
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <0, 20000, 300000>
/*  looks_like { 
  	sphere { 0*x 20000 
  		pigment { rgb <1,1,0> } 
  		finish { ambient 1 } } } */
  }
light_source { <-3,5,-6> color rgb 0.1 }

#declare camera_location = <0, 1.6,-5.31> ; 
#declare camera_look_at = <0, -2000,  300000> ; 
#declare effect_location = <0, 20000, 300000> ;
#declare effect_scale = 0.75;
#declare effect_always_on_top= false;
#declare effect_rotate = 25;
//#declare effect_type = "Sun"  
//#include "Lens.inc" 
#declare glow_type = 4;
#declare glow_colour = <1.5, 1.1, .3>;
#declare rays_type = 4;
#declare rays_color = <1.5,1.1,0.2>;
//#declare streak_type=6;
//#declare streak_color = <1.5,1.5,0.1>;
//#declare streak_rotate=-10;
#declare spots_type=5;
#declare spots_colour = <1.3, .9, .3>;
#declare spots_frequency = 2.4;
#declare spots_intensity = 2;
#declare spots_rotate = -55;
#declare spots_scale =0.4;
#include "LnsEfcts.inc"
#declare glow_type=0;
#declare rays_type=0;
#declare spots_frequency = 2.7;
#declare spots_intensity = 1.8;
#declare spots_rotate = -55+59;
#declare spots_scale =0.3;
#declare spots_seed = 2541;
#include "LnsEfcts.inc"
#declare spots_frequency = 1.7;
#declare spots_intensity = 2.1;
#declare spots_rotate = -55-59;
#declare spots_scale =0.4;
#declare spots_seed = 5313;
#include "LnsEfcts.inc"
#end
sky_sphere { pigment { rgb 0 } }
//plane { y, 0 pigment { checker } }
// Towers for the monitors on the side of the window
// Left Tower

difference {
	union {
		cylinder { <-2.2,0,-0.2> <-2.2,3,-0.2> 0.5 }
		sphere { <-2.2,3,-0.2> 0.5 }
		pigment { rgb <-0.5,0,-1.5>  }
		normal { wrinkles scale 0.1 }
		finish { specular 0.6 roughness 0.1}}
	box { <-0.4,-0.3,-0.6> <0.4,0.3,-0.1> 
		rotate -16*y
		translate <-2.2,2.7,-0.2> 
		pigment { rgb <-1,-1,-0.5> } }
	 
	box { <-0.4,-0.3,-0.6> <0.4,0.3,-0.1> 
		rotate -16*y
		translate <-2.2,2,-0.2> 
		pigment { rgb <-1,-1,-0.5> } }
	box { <-0.4,-0.3,-0.6> <0.4,0.3,-0.1> 
		rotate -16*y
		translate <-2.2,1.3,-0.2> 
		pigment { rgb <-1,-1,-0.5> } }
	 }
 
// Right Tower
difference {
	union {
		cylinder { <2.2,0,0> <2.2,3,-0.2> 0.5 }
		sphere { <2.2,3,-0.2> 0.5}
		pigment { rgb <-0.5,0,-1.5>  }
		normal { wrinkles scale 0.1 }
		finish { specular 0.6 roughness 0.1}}
	box { <-0.4,-0.3,-0.6> <0.4,0.3,-0.1> 
		rotate 16*y
		translate <2.2,2.7,-0.2> 
		pigment { rgb <-1,-1,-0.5> } }
	 
	box { <-0.4,-0.3,-0.6> <0.4,0.3,-0.1> 
		rotate 16*y
		translate <2.2,2,-0.2> 
		pigment { rgb <-1,-1,-0.5> } }
	box { <-0.4,-0.3,-0.6> <0.4,0.3,-0.1> 
		rotate 16*y
		translate <2.2,1.3,-0.2> 
		pigment { rgb <-1,-1,-0.5> } }
	 }
	 
// Console		 
intersection { 
	cylinder { <0,0,0> <0,1.3,0> 1 scale <3,1,1.2> }
	box { <-3,-0.01,0> <3,1,1.21> }
	pigment { rgb <-0.5,0,-1.5>  }
	normal { wrinkles scale 0.1 }
	finish { specular 0.6 roughness 0.1}
	}

// Front of console
intersection { 
	cylinder { <0,0,0> <0,1.3,0> 1 scale <3,1,1.2> }
	box { <-3,-0.01,-1.21> <3,1,0> }
	plane { <0,1,-0.3> 0 translate 1*y }
	pigment { rgb <-0.5,0,-1.5>  }
	normal { wrinkles scale 0.1 }
	finish { specular 0.6 roughness 0.1} 
	}	

// Control panel
box { <-0.49,0,-0.39> <0.49,0.009,0.49>
	texture { cells scale 0.1
		texture_map {
			[ 0.0 pigment { rgb <1,0.3,0> } finish { ambient 0.2 } ]
			[ 0.1 pigment { rgb <1,0.9,0> } finish { ambient 0.8 } ]
			[ 0.2 pigment { rgb <0.5,0.5,0> } finish { ambient 0.2 } ]
			[ 0.3 pigment { rgb <0,0.5,0.5>} finish { ambient 0.4 } ]
			[ 0.4 pigment { rgb <1,0.,0> } finish { ambient 0.8 } ]
			[ 0.5 pigment { rgb <0.9,0.9,0> } finish { ambient 0 } ] 
		  } }

	translate <-0.13,1,-0.5>
	rotate -degrees(atan(0.3))*x }
	
box { <-0.5,0,-0.4> <0.5,0.01,0.5>
	texture { 
		pigment { 
			boxed scale 0.5 translate <0.5,0,0.5> 
			color_map { 
				[ 0 rgb 0 ] [ 0.1 rgb 0 ] [0.1 rgbt 1] [1 rgbt 1]
			}
			warp { repeat x }
			warp { repeat z }
			scale 0.1}
			} 

	translate <-0.13,1,-0.5>
	rotate -degrees(atan(0.3))*x }
	
	

// Tower Backing
intersection {
	cylinder { <0,0,0> <0,4,0> 1 scale <3,1,1.2>
	pigment { rgb <-0.5,0,-1.5>  }
	normal { wrinkles scale 0.1 }
	finish { specular 0.6 roughness 0.1}
	}
	union {
		box { <-2.7,1,-0.2> <-1.7,3,1.2> }
		cylinder { <-2.2,3,-0.2> <-2.2,3,1.2> 0.5 }
		box { <1.7,1,-0.2> <2.7,3,1.2> }
		cylinder { <2.2,3,-0.2> <2.2,3,1.2> 0.5}
	pigment { rgb <-0.5,0,-1.5>  }
	normal { wrinkles scale 0.1 }
	finish { specular 0.6 roughness 0.1} }
	
	}

// Monitors

box { <0,0,-0.0> <1,1,0.1>
	pigment { image_map { tga "monitor0.tga" } }
	finish { ambient 0.5 reflection 0.1}
	translate <-0.5,-0.5,-0.3>
	scale <0.8,0.6,1> 
	rotate -16*y
	translate <-2.2,2.7,-0.2> 
	 }

box { <0,0,-0.0> <1,1,0.1>
	pigment { image_map { tga "monitor1.tga" } }
	finish { ambient 0.5 reflection 0.1}
	translate <-0.5,-0.5,-0.3>
	scale <0.8,0.6,1> 
	rotate -16*y
	translate <-2.2,2,-0.2> 
	 }

box { <0,0,-0.0> <1,1,0.1>
	pigment { image_map { tga "flare.tga" } }
	finish { ambient 0.5 reflection 0.1 }
	translate <-0.5,-0.5,-0.3>
	scale <0.8,0.6,1> 
	rotate -16*y
	translate <-2.2,1.3,-0.2> 
	 }

box { <0,0,-0.0> <1,1,0.1>
	pigment { image_map { tga "monitor2.tga" } }
	finish { ambient 0.5 reflection 0.1}
	translate <-0.5,-0.5,-0.3>
	scale <0.8,0.6,1> 
	rotate 16*y
	translate <2.2,2.7,-0.2> 
	 }

box { <0,0,-0.0> <1,1,0.1>
	pigment { image_map { tga "lunar.tga" } }
	finish { ambient 0.5 reflection 0.1}
	translate <-0.5,-0.5,-0.3>
	scale <0.8,0.6,1> 
	rotate 16*y
	translate <2.2,2,-0.2> 
	 }

box { <0,0,-0.0> <1,1,0.1>
	pigment { gradient y frequency 5 
		pigment_map {
			[ 0 color rgb 0 ]
			[ 1 granite scale 0.1 ]
		}}
	finish { ambient 1 reflection 0.1}
	translate <-0.5,-0.5,-0.3>
	scale <0.8,0.6,1> 
	rotate 16*y
	translate <2.2,1.3,-0.2> 
	 }

// Floor and exterior wall

cylinder { <0,-0.1,0> <0,0,0> 1
	scale <15,1,10>
	translate -9.2*z 
	pigment { rgb <-0.5,0,-1.5>  }
	normal { wrinkles scale 0.1 }
	finish { specular 0.6 roughness 0.1} 
	
	}

difference {
	difference {
		union { 
			cylinder { <0,-0.5,0> <0,6.5,0> 1 }
			sphere { <0,6.5,0> 1.15 } }
		union {
			cylinder { <0,-0.5,0> <0,6.5,0> 0.99 }
			sphere { <0,6.5,0> 0.99 } }
		scale <15,1,10>
		translate -9.2*z
		}
	box {	<-1.8,0.99,0.6> <1.8,3,3> }
	pigment { rgb <-0.5,0,-1.5>  }
	normal { wrinkles scale 0.1 }
	finish { specular 0.6 roughness 0.1} 
	}

// Fake Window
#if (FakeIt)
box {	<-1.9,0.59,2.9> <1.9,3.5,3> 
	pigment { spherical
		scale 0.55
		color_map { 
			[0 rgb 0 ]
			[0.01 rgb <1,1,0> ]
		}
		translate <0.2,2.15,2.9>
		}
	finish { ambient 50 }
		}

light_source { <0.2,2.15,2.89> color rgb 2 }
light_source { <-3,5,-6> color rgb 0.1 }
light_source { <3,5,-6> color rgb 0.03 }
#end
// Dummy Figure
/*
union {
sphere { <0,1.75,0> 0.3 }
cylinder {<0,0,0> <0,1.4,0> 0.4 }
cylinder { <-0.55,0.5,0> <-0.55,1.4,0> 0.15}

pigment { rgb y }
translate <0.7,0,-2>
}
*/
#declare minimum=<-0.10439, -0.0143, -0.07748>;
#declare maximum=<0.10474, 0.68149, 0.05543>;
#declare s = maximum-minimum;

object {
	#include "man.inc"
	//hollow
	translate -minimum.y*y
	//translate -s
	scale 2/s.y
	//rotate 180*y
	translate <0.5,0,-3>
	pigment { slope
		<0,0,1>
		color_map { 
			[0 rgb 0 transmit 0 ]
			//[0.5 rgb <-0.5,0,-1.5> ]
			[0.5 rgb <0,0.94,0> ]
			[0.8 rgb 0 transmit 0.5] }
		poly_wave 1.5
		 } 
	//normal { crackle }
	//pigment { rgb <-0.5,0,-1.5>  }
	normal { wrinkles scale 0.1 }
	finish { specular 0.3 roughness 0.3} 
	//finish { specular 0.6 ambient 0.3}
	interior { //ior 1.3 
		fade_color <0,0,0>
		fade_distance 0.01
		fade_power 4 }
	 }
#declare minimum= <-0.0966, -0.00174, -0.07151>;
#declare maximum= <0.11331, 0.66628, 0.1379>;
#declare s = maximum-minimum;
object {
	#include "woman.inc"
	translate -minimum.y*y
	//translate -s
	scale 1.85/s.y
	//rotate 180*y
	translate <-0.5,0,-3>
		pigment { slope
		<0,0,1>
		color_map { 
			[0 rgb 0 transmit 0 ]
			//[0.5 rgb <-0.5,0,-1.5> ]
			[0.5 rgb <0,0.94,0> ]
			[0.8 rgb 0 transmit 0.5] }
		poly_wave 1.5
		 } 
	//normal { crackle }
	//pigment { rgb <-0.5,0,-1.5>  }
	normal { wrinkles scale 0.1 }
	finish { specular 0.3 roughness 0.3}  }
	                                                              l  l   }                                                                                                                                                                                                                                                   D   @      PRec   @      WKin   @                   A
 	     @      )ADep   @      LAEFr   @      AFCl   @     AFFr   @      AIFr   @      AJit   @      <AMet   @     (ASFr   @      AThr   @      DBPCo   @      BThr   @      ZCIma   @      DACh   @      DAni   @      DAnt   @      6DBSl   @      TDCom   @      DFAc   @     "DFRe   @     
DMPE   @       DMPS   @      DMPr   @      DPIm   @     DPre   @      DSAc   @     DSUn   @      hHeig   @      IFTy   @      LVer   @      OBSi   @      PIRe   @     0QTSp   @      QTTe   	@      Qual   @      (RINI   @     RUBo   @      bRadi   @      0ULBu   @      nUOBu   @      zUVBu   @      tWidt   @        8     P   7    @                  	    V             >                   @                      d     @        PNGf                   a   png                 
            
      
                ?   ?      j         !                   ( J     D   @      PRec   @      WKin   @                   0      l  l   }SORTN   J  POVR  
              H        $I2Window PreferencesRender PrefsWindow Preferences                       