#declare F_Cam = on;
#declare Cities = on;
#declare Walls = on;
#declare Ground = on;
#declare Background = on;
#declare Craters = on;

#include "colors.inc"
#include "ML_textures.inc"
#include "ML_background.inc"
#include "ML_macros.inc"

#if (F_Cam = on)
  camera {
    location <100,15,-180>
    look_at <10,20,0>
  }
#else
  camera {
    location <0,50,-250>
    look_at <0,0,0>
  }
#end

global_settings {
  max_trace_level 8
}

#if (Cities = on)
  #declare City1 = union { Buildings(45,200,2,10) }
  #declare City2 = union { Buildings(35,150,2,6) }
  #declare City3 = union {
    union { Buildings(45,150,10,30) }
    difference {
      union { Buildings(80,400,5,15) }
      cylinder { <0,-1,0>,<0,9,0>,45 }
    }  
  }
#end  

#declare T1spline = spline { 0,<0,0,180>,1,<-120,0,20> }
#declare T2spline = spline { 0,<0,0,180>,1,<80,0,0> }
#declare T3spline = spline { 0,<80,0,0>,1,<80,0,-200> }
#declare T4spline = spline { 0,<-120,0,20>,1,<80,0,-200> }

#declare Frame = union {  
  difference {
    union {
      sphere { T1spline(.5),5.25 }
      sphere { T1spline(.6),5.25 }
      sphere { T1spline(.7),5.25 }
      difference {
        cylinder { <0,3,180>,<-120,3,20>,2.25 }
        sphere { <0,0,180>,85 }
        sphere { <-120,0,20>,50 }
      } 
    }
    cylinder { <0,0,180>,<-120,0,20>,5 }
  }   
  difference {
    union {
      sphere { T2spline(.500),5.25 }
      sphere { T2spline(.625),5.25 }
      sphere { T2spline(.750),5.25 }
      difference {
        cylinder { <0,3,180>,<80,3,0>,2.25 }
        sphere { <0,0,180>,85 }
        sphere { <80,0,0>,40 }
      }
    }
    cylinder { <0,0,180>,<80,0,0>,5 }
  }   
  difference {
    union {
      sphere { T3spline(.2),5.25 }
      sphere { T3spline(.3),5.25 }
      sphere { T3spline(.4),5.25 }
      sphere { T3spline(.5),5.25 }
      sphere { T3spline(.6),5.25 }
      sphere { T3spline(.7),5.25 }
      sphere { T3spline(.8),5.25 }
      sphere { T3spline(.9),5.25 }
      difference {
        cylinder { <80,3,0>,<80,3,-200>,2.25 }
        sphere { <80,0,0>,40 }
      }
    }
    cylinder { <80,0,0>,<80,0,-200>,5 }
  }   
  difference {
    union {
      sphere { T4spline(.2),5.25 }
      sphere { T4spline(.3),5.25 }
      sphere { T4spline(.4),5.25 }
      sphere { T4spline(.5),5.25 }
      sphere { T4spline(.6),5.25 }
      sphere { T4spline(.7),5.25 }
      sphere { T4spline(.8),5.25 }
      sphere { T4spline(.9),5.25 }
      difference {
        cylinder { <-120,3,20>,<80,3,-200>,2.25 }
        sphere { <-120,0,20>,50 }
      }
    }
    cylinder { <-120,0,20>,<80,0,-200>,5 }
  }
  difference {
    union {
      torus { 80,5.25 rotate x*90 }
      torus { 80,5.25 rotate x*90 rotate y*45 }
      torus { 80,5.25 rotate x*90 rotate y*90 }
      torus { 80,5.25 rotate x*90 rotate y*135 }
      torus { sqrt(9031.25)-26,5.25 translate y*42.5 }
      rotate y*-20
    }
    sphere { 0,85 }
    translate z*180
  }   
  difference {
    union {
      torus { 45,5.25 rotate x*90 }
      torus { 45,5.25 rotate x*90 rotate y*45 }
      torus { 45,5.25 rotate x*90 rotate y*90 }
      torus { 45,5.25 rotate x*90 rotate y*135 }
      torus { sqrt(3125)-18,5.25 translate y*25 }
      rotate y*30
    }
    sphere { 0,50 }
    translate <-120,0,20>
  }   
  difference {
    union {
      torus { 35,5.25 rotate x*90 }
      torus { 35,5.25 rotate x*90 rotate y*45 }
      torus { 35,5.25 rotate x*90 rotate y*90 }
      torus { 35,5.25 rotate x*90 rotate y*135 }
      torus { sqrt(2000)-16,5.25 translate y*20 }
      rotate y*10
    }
    sphere { 0,40 }
    translate x*80
  }
  texture {
    pigment { Gray25 }
    finish { ambient .1 diffuse .4 brilliance 5 specular .3 roughness .01 }
  }   
}

#declare Bubbles = union {
  difference {
    union {
      cylinder { <0,0,180>,<-120,0,20>,5 }
      cylinder { <0,0,180>,<80,0,0>,5 }
      cylinder { <80,0,0>,<80,0,-200>,5 }
      cylinder { <-120,0,20>,<80,0,-200>,5 }
    }
    union {
      sphere { 0,50 translate <-120,0,20> }
      sphere { 0,40 translate <80,0,0> }
      sphere { 0,85 translate <0,0,180> }  
    }
    pigment { White }
  }
  union {
    sphere { 0,50 translate <-120,0,20> }
    sphere { 0,40 translate <80,0,0> }
    sphere { 0,85 translate <0,0,180> }
  }
  pigment { Bubble_tex1 }
}

#declare Floor = intersection {
  plane { <0,1,0>,0 }
  union {
    cylinder { <0,0,180>,<-120,0,20>,5 }
    cylinder { <0,0,180>,<80,0,0>,5 }
    cylinder { <80,0,0>,<80,0,-200>,5 }
    cylinder { <-120,0,20>,<80,0,-200>,5 }
    sphere { 0,50 translate <-120,0,20> }
    sphere { 0,40 translate <80,0,0> }
    sphere { 0,85 translate <0,0,180> }  
  }
  pigment { Gray15 }  
}

difference {
  cylinder { <0,0,0>,<0,-10,0>,500 }
  #if (Craters = on)
    union {
      object { CraterPit(8,8) translate <-60,0,-80> }
      object { CraterPit(9,6) translate <20,0,-60> }
      object { CraterPit(10,10) translate <50,0,-120> }
      object { CraterPit(5,4) translate <0,0,-55> }
      object { CraterPit(15,13) translate <-35,0,0> }
      object { CraterPit(7,6) translate <110,0,-100> }
      object { CraterPit(5,3) translate <100,0,-130> }
      object { CraterPit(8,8) translate <40,0,50> }
    }
  #end
  #if (Ground = on)
    texture { Moon_tex }
  #else
    pigment { Gray80 }
  #end  
}

sky_sphere {
  #if (Background = on)
    pigment { Starfield }
  #else
    pigment { Black }
  #end
}

#if (Background = on)
  object { Earth rotate <-40,-30,0> translate <-1500,1000,2000> }
#end

#if (Cities = on)
  object { City1 translate <-120,0,20> }
  object { City2 translate <80,0,0> }
  object { City3 translate <0,0,180> } 
#end

#if (Walls = on)
  object { Bubbles }
  object { Frame }
#end

#if (Craters = on)
  union {
    object { CraterRim(8,8) translate <-60,0,-80> }   
    object { CraterRim(9,6) translate <20,0,-60> }
    object { CraterRim(10,10) translate <50,0,-120> }
    object { CraterRim(5,4) translate <0,0,-55> }
    object { CraterRim(15,13) translate <-35,0,0> }     
    object { CraterRim(7,6) translate <110,0,-100> }
    object { CraterRim(5,3) translate <100,0,-130> }
    object { CraterRim(8,8) translate <40,0,50> }
    #if (Ground = on)
      texture { Moon_tex }
    #else
      pigment { Gray80 }
    #end
  }
#end

#if (Background = on)
  intersection {
    height_field {
      jpeg "background_HF.jpg"
      smooth
      translate <-.5,-.25,-.5>
      scale <1000,50,1000>
    }
    cylinder { <0,-100,0>,<0,100,0>,500 }
    cylinder { <0,-100,0>,<0,100,0>,300 inverse }
    #if (Ground = on)
      texture { Moon_tex }
    #else
      pigment { Gray80 }
    #end 
  }  
#end  

#if (Ground = on)
  object { Floor translate y*.001 }
#end

light_source { <-500,500,-750> color Gray70 shadowless }
light_source { <500,500,750> color White area_light x*250,y*250,20,20 rotate x*-20 adaptive 1 jitter }