//	Persistence of Vision Ray Tracer Scene Description File
//	File: biohazard.inc
//	Date: Dec 23, 2003
//	Author: MJP
//	Biohazard Symbol

#declare Smidgen = 1/100000000 ;
#declare BumpUp = 1+Smidgen ;

#local BHS_Ring = difference {
	cylinder {
		-Smidgen*z , BumpUp*z , 1.1
	}
	cylinder {
		-Smidgen*z*2, BumpUp*z*2, .9
	}
}

#local BHS_Spike = intersection {
	plane { y, -.2 }
	difference {
		#local OutsideCyl = cylinder {
			0, z, 1.07
			translate .9*x
		}
		#local CutoutCyl = cylinder {
			-Smidgen*z, BumpUp*z, 1.
			translate .9*x-y/10
			translate .2*(x+y)
		}
		merge { object { OutsideCyl } object { OutsideCyl scale <-1, 1, 1> } }
		merge { object { CutoutCyl } object { CutoutCyl scale <-1, 1, 1> } }
		translate -y*.7
	}
}

#local RingAreaPortion = cylinder {
	-z, 2*z, .85
	translate 1.2*y
}
#local RingArea = union {
	object { RingAreaPortion }
	object { RingAreaPortion rotate 120*z }
	object { RingAreaPortion rotate -120*z }
}

union {
	intersection { 
		object { BHS_Ring } 
		object { RingArea } 
	}
	object { BHS_Spike }
	object { BHS_Spike rotate 120*z }
	object { BHS_Spike rotate -120*z }
}