
// POV-Ray Object File - Curbs
// created 31-Dec-03
// last update 31-Dec-03
// copyright 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Curbs.inc" in another .pov file
//
// objects:
// CurbSection(Length)
// CurbCorner(Radius)
// DrainSection
//
// Intended scale is English system (inches)
// origin at ground level, at LH edge of curb face.
// curb extends into +X
// Uses RH coord system (Z=up)

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here



//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare Grey10 =
	texture {
		pigment { color rgb<.1,.1,.1> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare GreyStucco =
	texture {
		pigment { color rgb<.205,.208,.200> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .3 roughness .08 }
	}
#declare CurbTex =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.32,0.33,0.16> ]
				[ 0.5  color rgb<0.55,0.54,0.55> ]
				[ 1.0  color rgb<0.880,0.884,0.579> ]
			}
		}
		normal { bumps 0.2 scale 0.1 }
		finish { ambient .02 specular .18 roughness .12 }
	}

#declare SConcreteTex =
	texture {
		pigment { color rgb<.54,.61,.68>*.94 }
		normal { bumps 0.3 scale 4 }
		finish { specular 0.06 roughness .38 }
	}


//===============================================
//             Objects
//===============================================

#macro CurbSection(Length)
	union {
		difference {
			box { // main
				<0,-6,-12>,<Length,6,4-0.5>
			}
			box { // lower top
				<-1,-20,0>,<Length+1,-0.5,6>
			}
			cylinder { // lower
				<-1,0,0>,<Length+1,0,0>,0.5
				translate <0,-0.5,0.5>
			}
			box { // side
				<-1,-2,0.5>,<Length+1,0,6>
			}
		} // end difference
		cylinder { // top edge
			<0,0,0>,<Length,0,0>,0.5
			translate <0,0.5,4-0.5>
		}
		box { // top area
			<0,0.5,0>,<Length,6,4>
		}
		texture { CurbTex }
	} // end union
#end

#macro CurbCorner(CRad)
	difference {
		union {
			cylinder { // main
				<0,0,0>,<0,0,3.5>,CRad
			}
			cylinder { // base
				<0,0,-8>,<0,0,0>,CRad+12
			}
			torus { // top edge
				CRad-0.5,0.5
				rotate x*90
				translate <0,0,4-0.5>
			}
			cylinder { // top surf
				<0,0,0>,<0,0,4>,CRad-0.5
			}
		} // end union
		box { <-CRad-20,0,-10>,<CRad+20,CRad+20,6> }
		box { <0,-CRad-20,-10>,<CRad+20,CRad+20,6> }
		texture { CurbTex }
	} // end difference
#end

#declare DrainSection =
	difference {
		object { CurbSection(24) }
		box { <6,-1,0.1>,<6+14,24,3.4> }
	} // end difference

#macro Sidewalk(Num)
	union {
		#declare RS = seed(20945);
		#declare JS = 0;
		#while (JS < Num)
			box { <0,0,-8>,<24,48,0>
				translate <24.4*JS,0,rand(RS)*.6>
			}
			box { <0,48.5,-8>,<24,8*Feet,0>
				translate <24.4*JS,0,rand(RS)*.6>
			}
			#declare JS = JS + 1;
		#end
		texture { SConcreteTex }
	} // end union
#end

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings {
	ambient_light 0 // default <1,1,1>, use 0 for radiosity
}

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <1*Feet, -6*Feet, 4*Feet> // overall
		look_at <2*Feet,0,5>
	}

light_source
{ <40*Feet,-35*Feet,50*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*0.6
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 12 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

//object { CurbSection(4*Feet) scale 1.0 rotate z*25 translate <0,0*Feet,6.1> }
//object { CurbCorner(24) scale 1.0 rotate z*25 translate <24,24,6.1> }
//object { DrainSection scale 1.0 rotate z*25 translate <24,24,6.1> }
object { Sidewalk(4) scale 1.0 rotate z*25 translate <2,2,1.1> }

#end
