
// POV-Ray Object File - Diner
// created 28-Dec-03
// last update 31-Dec-03
// copyright 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Diner.inc" in another .pov file
//
// objects:
// CornerDiner - a corner diner in the city
//
// Intended scale is English system (inches)
// origin at ground level, at LH edge of building face.
// Building face is along +X, depth extends into +Y
// Uses RH coord system (Z=up)

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
//	#declare Wet = 0;
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here



//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare Grey10 =
	texture {
		pigment { color rgb<.1,.1,.1> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey20 =
	texture {
		pigment { color rgb<.2,.2,.2> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey30 =
	texture {
		pigment { color rgb<.3,.3,.3> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey40 =
	texture {
		pigment { color rgb<.420,.416,.425> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey50 =
	texture {
		pigment { color rgb<.5,.5,.5> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey60 =
	texture {
		pigment { color rgb<.6,.6,.6> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey70 =
	texture {
		pigment { color rgb<.7,.7,.7> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey80 =
	texture {
		pigment { color rgb<.83,.83,.80> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey90 =
	texture {
		pigment { color rgb<.92,.92,.90> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare GreyStucco =
	texture {
		pigment { color rgb<.205,.208,.200> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .3 roughness .08 }
	}
#declare GreyBricks1 = // small size
	texture {
		pigment {
			brick color rgb<.060,.056,.067>, color rgb<.426,.422,.409> //mortar,brick
				brick_size <8,8,2.2>   // size of brick
				mortar 0.46       // width of mortar
//				rotate x*90
			}
		finish { ambient .02 specular .3 roughness .08 }
	}
#declare GreyTin20 =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0  color rgb<0.24,0.34,0.21> ]
				[ 0.5  color rgb<0.55,0.54,0.55> ]
				[ 1.0  color rgb<0.48,0.44,0.49> ]
			}
			scale <.09,.09,.52>
		}
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .95 roughness .005 metallic brilliance 3 }
	}
#declare GreyBricks2 = // large size, brighter
	texture {
		pigment {
			brick color rgb<.34,.34,.34>, color rgb<.62,.60,.60> //mortar,brick
				brick_size <22,22,10>   // size of brick
				mortar 1.2       // width of mortar
//				rotate x*90
			}
		finish { ambient .02 specular .3 roughness .08 }
	}
#declare GreyStone20 =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.078,0.070,0.065> ]
				[ 0.5  color rgb<0.156,0.18,0.158> ]
				[ 0.8  color rgb<0.235,0.246,0.250> ]
				[ 1.0  color rgb<0.156,0.158,0.151> ]
			}
		}
		normal { bumps 0.3 }
		finish { ambient .02 specular .7 roughness .095 }
	}
#declare GreyStone30 =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.12,0.13,0.10> ]
				[ 0.5  color rgb<0.25,0.24,0.25> ]
				[ 1.0  color rgb<0.380,0.384,0.379> ]
			}
		}
		normal { bumps 0.2 }
		finish { ambient .02 specular .6 roughness .095 }
	}
#declare GreyStone40 =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.21,0.23,0.20> ]
				[ 0.5  color rgb<0.35,0.38,0.36> ]
				[ 1.0  color rgb<0.51,0.53,0.52> ]
			}
		}
		normal { bumps 0.2 }
		finish { ambient .02 specular .44 roughness .095 }
	}
#declare GreyStone50 =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.32,0.33,0.34> ]
				[ 0.5  color rgb<0.45,0.44,0.45> ]
				[ 1.0  color rgb<0.58,0.59,0.62> ]
			}
		}
		normal { bumps 0.34 }
		finish { ambient .02 specular .34 roughness .095 }
	}
#declare JustGlass =
	texture {
		pigment { color rgbf<1,1,1,.9> }
		finish { ambient .02 reflection .4 }
	}
#declare DarkGlass =
	texture {
		pigment { color rgb<0.94,0.94,1.00>*.010 }
		normal { bumps 0.002 scale 3*Feet }
		finish { reflection 0.20 }
	}


#declare RustyIron =
	texture {
		pigment {
			agate
			color_map {
				[0.00 color rgb<.20,.13,.28> ] // iron
				[0.45 color rgb<.26,.18,.08> ] // light rust
				[0.50 color rgb<.09,.03,.01> ] // dark rust
				[0.55 color rgb<.26,.18,.08> ] // light rust
				[1.00 color rgb<.20,.13,.28> ] // iron
			}
			scale .3
		}
		finish { specular .1 roughness .14 }
	}

#declare GreyRust =
	texture {
		pigment {
			agate
			color_map {
				[0.00 color rgb<.20,.19,.21> ] // iron
				[0.45 color rgb<.16,.13,.11> ] // light rust
				[0.50 color rgb<.04,.03,.04> ] // dark rust
				[0.55 color rgb<.16,.13,.11> ] // light rust
				[1.00 color rgb<.20,.19,.21> ] // iron
			}
			scale .3
		}
		finish { ambient .02 specular .1 roughness .14 }
	}

#declare BrightStainless =
	texture {
		pigment {
			color rgb<1,1,1>*.6
		}
		finish { ambient .02 specular .9 roughness .03 reflection .24 }
	}
#declare DarkStainless =
	texture {
		pigment {
			color rgb<1,1,1>*.10
		}
		finish { ambient .02 specular .9 roughness .03 reflection .24 }
	}

#declare NeonTex =
	texture {
		pigment { color rgbt<.90,.31,.61,.5> }
		finish { ambient 5 specular .94 roughness .002 }
	}
#declare NeonInt =
	interior {
		ior 1.45
	}
#declare NeonMat =
	material {
		texture { NeonTex }
		interior { NeonInt }
	}
#declare NeonReflectTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0 rgbt<1,1,1,1> ]
				[ 1/6 rgbt<.90,.31,.61,.3> ]
				[ 2/6 rgbt<1,1,1,1> ]
				[ 3/6 rgbt<.90,.31,.61,.3> ]
				[ 4/6 rgbt<1,1,1,1> ]
				[ 5/6 rgbt<.90,.31,.61,.3> ]
				[ 6/6 rgbt<1,1,1,1> ]
			}
		}
		finish { ambient .02 specular .9 roughness .03 reflection .24 }
	}


//===============================================
//             Objects
//===============================================

#declare GlassDoor40 =
	union {
		difference {
			box { // frame outer
				<0,0,0>,<40,1.5,7*Feet>
				texture { Grey80 }
			}
			box { // frame inner
				<2,-1,5>,<40-2,6,7*Feet-4>
				texture { Grey80 }
			}
		} // end difference
		box { // cross bar
			<0,0,0>,<38,1,3>
			texture { Grey80 }
			translate <1.5,-.4,36>
		}
		box { // window glass
			<.5,.7,.5>,<40-.5,.9,7*Feet-.5>
			texture { JustGlass }
		}
	} // end union

#declare DownSpoutBracket =
	union {
		cylinder { // bracket ring
			<0,0,0>,<0,0,2>,3.3
			texture { Grey50 }
		}
		difference {
			box { // bracket extension
				<-3.3,0,0>,<3.3,8,2>
				texture { Grey50 }
			}
			box { // bracket hole
				<-3.0,-1,-1>,<3.0,9,3>
				texture { Grey50 }
			}
		} // end difference
		box { // bracket base
			<-4.6,5,0>,<4.6,8,2>
			texture { Grey50 }
		}
		sphere { // screw
			<0,0,0>,.2
			scale <1,.4,1>
			translate <-4,5,0>
			texture { GreyRust }
		}
		sphere { // screw
			<0,0,0>,.2
			scale <1,.4,1>
			translate <4,5,0>
			texture { GreyRust }
		}
	} // end union
#declare DownSpout =
	union {
		object { DownSpoutBracket translate <0,0,6*Feet> }
		object { DownSpoutBracket translate <0,0,14*Feet> }
		cylinder { // main spout
			<0,0,-6>,<0,0,24*Feet>,2.7
			texture { GreyRust }
		}
		cylinder { // bottom collector
			<0,0,-6>,<0,0,24>,3.7
			texture { GreyStone20 }
		}
		cylinder { // bottom collector top ring
			<0,0,23>,<0,0,24>,4.3
			texture { GreyStone30 }
		}
		cone { // bottom collector top ring
			<0,0,24>,4.3,<0,0,24.7>,3.9
			texture { GreyStone30 }
		}
	}
/*
#declare Grating =
	difference {
		box { // main
			<0,0,-2>,<2*Feet,9,0>
			texture { GratingTex }
		}
		#declare SlotCount = 0;
		#while ( SlotCount < 4 )
			box {
				<1,0,-3>,<11.5,1,1>
				texture { Grey10 }
				translate <0,SlotCount*2+1,0>
			}
			box {
				<12.5,0,-3>,<23,1,1>
				texture { Grey10 }
				translate <0,SlotCount*2+1,0>
			}
			#declare SlotCount = SlotCount + 1;
		#end
	} // end difference

#declare GratingWithSteam =
	union {
		object { Grating }
//		object { GratingSteam scale <12,12,24> rotate <38,10,0> translate <14,4.5,2>}
	}
*/

#declare VentVane =
	union {
		box {
			<0,0,0>,<16,2,.1>
		}
		cylinder {
			<0,0,.05>,<16,0,.05>,.05
		}
	}
#declare Vent =
	union {
		difference {
			box { // outer
				<-1.5,-.3,0>,<17.5,1,10>
			}
			box { // inner
				<0,-1,1.5>,<16,3,9.5>
			}
		} // end difference
		object { VentVane rotate <65,0,0> translate <0,.2,2> }
		object { VentVane rotate <65,0,0> translate <0,.2,4> }
		object { VentVane rotate <65,0,0> translate <0,.2,6> }
		object { VentVane rotate <65,0,0> translate <0,.2,8> }
		object { VentVane rotate <65,0,0> translate <0,.2,10> }
		texture { Grey50 }
	} // end union

/*
#declare GoodsInWindow =
	union {
		box { // lower shelf
			<0,0,-1>,<8*Feet,12,0>
			texture { Grey90 }
			translate <0,0,30>
		}
		box { // upper shelf
			<0,0,-1>,<8*Feet,12,0>
			texture { Grey90 }
			translate <0,0,48>
		}
		box {
			<0,0,0>,<14,6,5>
			texture { Grey30 }
			rotate z*8
			translate <6,2,30>
		}
		cylinder {
			<0,0,0>,<0,0,6>,2.3
			texture { Grey20 }
			translate <18,5,30>
		}
		cylinder {
			<0,0,0>,<0,0,8>,3.3
			texture { Grey40 }
			translate <28,7,30>
		}
		box {
			<0,0,0>,<8,6,3>
			texture { GreyStucco }
			rotate <15,0,0>
			translate <42,2,30>
		}
		cylinder {
			<0,0,0>,<0,0,4.5>,4.7
			texture { Grey80 }
			translate <22,6,48>
		}
		cylinder {
			<0,0,0>,<0,0,6>,2.7
			texture { Grey30 }
			translate <44,6,48>
		}
		box {
			<0,0,0>,<16,6,2.2>
			texture { Grey10 }
			rotate <5,0,0>
			translate <5*Feet,6,48>
		}
		box {
			<0,0,0>,<10,8,3>
			texture { Grey30 }
			rotate z*18
			translate <6.3*Feet,6,48>
		}
	}
*/

/*
//----------- Diner (complex version) -------------------
#declare Diner =
	union {
		difference {
			box { // outer shell
				<0,0,0>,<22*Feet,32*Feet,38*Feet>
				texture { GreyStucco }
			}
			box { // inner shell
				<8,8,8>,<22*Feet-8,32*Feet-8,38*Feet-8>
				texture { Grey80 }
			}
			box { // doorway
				<0,-1,0>,<3*Feet,12,7*Feet>
				texture { Grey20 }
				translate <2*Feet,0,0>
			}
			#declare Width=8*Feet; // for Windows.inc
			#declare Height=5*Feet; // for Windows.inc
			box { // picture window cutout
				<0,-1,0>,<Width,40,Height>
				texture { Grey50 }
				translate <8*Feet,0,2*Feet>
			}
			#declare RowCount = 0;
			#while ( RowCount < 3 )
				#declare ColCount = 0;
				#while ( ColCount < 4 )
					box { // window cutouts
						<0,0,0>,<26,20,50>
						texture { GreyBricks1 }
						translate <16+ColCount*4.8*Feet,-.1,12*Feet+RowCount*8.5*Feet>
					}
					#declare ColCount = ColCount + 1;
				#end
			#declare RowCount = RowCount + 1;
			#end
		} // end difference
		box { // all upper windows
			<0,0,0>,<21*Feet,31.8*Feet,27*Feet>
			texture { JustGlass }
			translate <6,1,10*Feet>
		}
		object { DownSpout rotate <0,0,-90> translate <-7,2*Feet,0> }
		object { GlassDoor translate <2*Feet,8,0> }
		#include "Windows.inc"
		object { BasicWindow translate <8*Feet,-1,2*Feet> }
		box { // slime under window
			<0,0,0>,<Width,1,12>
			texture {
				pigment {
					bozo
					color_map {
						[ 0.00  color rgbt<.20,.20,.20,1> ]
						[ 0.31  color rgbt<.2,.20,.20,1> ]
						[ 0.50  color rgb<0.10,0.08,0.08> ]
						[ 0.69  color rgbt<.2,.2,.2,1> ]
						[ 1.00  color rgbt<.20,.20,.20,1> ]
					}
				}
				normal { bumps .2 scale 1 }
				finish { ambient .02 specular .2 roughness .02 }
				scale <2,2,8>
			}
			translate <8*Feet,-.1,12>
		}
		#declare Roundedness = .3;
		object { RoundedBox(.1) // front step
			translate <.5,.5,.5> // origin at corner
			scale <3.6*Feet,36,6>
			texture { GreyStone30 }
			translate <1.8*Feet,-14,-2>
		}
		difference {
			box { // lower blocks main
				<0,0,0>,<17*Feet,2,14>
				texture { GreyStone50 }
				translate <5*Feet,-1.6,0>
			}
			box { // hole for vent
				<-.5,-3,0>,<24.5,5,9.8>
				translate <18*Feet,0,3>
				texture { GreyStone50 }
			}
		} // end difference
//		object { Vent translate <18*Feet,-1.65,2> }
		box { // lower blocks slanted top edge
			<0,0,0>,<17*Feet,2,2>
			texture { GreyStone50 }
			rotate <-50,0,0>
			translate <5*Feet,-1.6,14>
		}
		box { // coping1
			<-2,0,0>,<22*Feet+2,4,4>
			texture { GreyStone50 }
			translate <0,-1.8,10*Feet>
		}
		box { // coping2
			<-2,0,2>,<22*Feet+2,4,9>
			texture { GreyStone50 }
			translate <0,-0.8,10*Feet>
		}
		#declare Width = 4.5*Feet;
		#include "Windows.inc"
		object { Awning translate <1.0*Feet,-2.4*Feet,7.2*Feet> }
		box { // awning mount
			<0,0,0>,<4.8*Feet,4,14>
			texture { Grey40 }
			translate <1*Feet-1,-0.6,7*Feet>
		}
		box { // sign in window
			<0,0,0>,<10,.1,20>
			texture { Grey80 }
			translate <9*Feet,5,5*Feet>
		}
	} // end union
*/

//===============================================
//                 Diner
//===============================================

// Corner Diner front faces -X, along X=0 plane
// Exposed side wall is along Y=0 plane

#declare CRad = 24; // main corner radius
#declare BSR = 8; // scallop radius
#declare BSS = 6; // scallop vertical spacing
#declare BackScallop =
	union {
		torus {
			CRad-1.5-BSR,BSR
			rotate x*90
			translate <CRad,CRad,0>
		}
		cylinder { <CRad,1.5+BSR,0>,<13*Feet,1.5+BSR,0>,BSR }
		cylinder { <1.5+BSR,CRad,0>,<1.5+BSR,19*Feet,0>,BSR }
//		texture { BrightStainless }
	} // end union
#declare NeonBacking =
	union {
		difference {
			box { <-0.8,-0.8,0>,<13*Feet,19*Feet,24> } // main shape
			box { <8,8,-1>,<13*Feet+1,19*Feet+1,25> } // inside cutaway
			box { <-2,-2,2>,<2,19*Feet-2,22> } // front outside
			box { <-2,-2,2>,<13*Feet-2,2,22> } // side outside
			box { <-sqrt(2)*CRad/2,-1,-1>,<sqrt(2)*CRad/2,40,22> rotate z*-45 } // corner
		} // end difference
		cylinder { // bottom rim
			<0,0,0>,<0,0,2>,CRad
			translate <CRad,CRad,0>
		}
		cylinder { // main rim
			<0,0,2>,<0,0,22>,CRad-2
			translate <CRad,CRad,0>
		}
//		object { BackScallop translate <0,0,12-BSR*2> }

		object { BackScallop translate <0,0,12-BSS*1> }
		object { BackScallop translate <0,0,12+BSS*0> }
		object { BackScallop translate <0,0,12+BSS*1> }
		object { BackScallop translate <0,0,12+BSS*2> }

		texture { BrightStainless }
		texture { NeonReflectTex scale <1,1,20> translate <0,0,2> }
	} // end union

#declare NR = .35; // Neon tube Radius
#declare NeonTube =
	union {
		difference {
			torus {
				CRad-1,NR
				rotate x*90
				translate <CRad,CRad,0>
			}
			box { <-1,CRad,-1>,<CRad*2,CRad*2,1> }
			box { <CRad,-1,-1>,<CRad*2,CRad*2,1> }
		} // end difference
		cylinder {
			<CRad,1,0>,<13*Feet,1,0>,NR
		}
		cylinder {
			<1,CRad,0>,<1,19*Feet,0>,NR
		}
		material { NeonMat }
	} // end union

#declare NeonGlow =
	merge {
		cylinder {
			<20,0,0>,<13*Feet,0,0>,2
			hollow on
			material {
				texture {
					pigment { color rgbt<1,1,1,1> }
				}
				interior {
					media {
						emission <.095,.035,.061> // soft neon glow
						density { cylindrical rotate z*-90 scale <13*Feet,2,2> }
					}
				}
			}
		}
		cylinder {
			<-22,0,0>,<0,0,0>,2
			hollow on
			material {
				texture {
					pigment { color rgbt<1,1,1,1> }
				}
				interior {
					media {
//						emission <.095,.035,.061> // heavy neon glow
						emission <.043,.019,.032> // softer neon glow
						density { cylindrical rotate z*-90 scale <13*Feet,2,2> }
					}
				}
			}
			rotate z*-45
			translate <20,0,0>
		}
	} // end merge

#declare NeonGroup =
	union {
		object { NeonBacking }

		object { NeonTube translate <0,0,12-6> }
		object { NeonTube translate <0,0,12> }
		object { NeonTube translate <0,0,12+6> }

		object { NeonGlow translate <0,-2,12-6> }
		object { NeonGlow translate <0,-2,12> }
		object { NeonGlow translate <0,-2,12+6> }

	} // end union

#declare DinerAwningSign =
	union {
		cylinder {
			<0,0,-3>,<0,0,0>,32
			translate <0,0,0>
		}
		torus { 32.3,1 rotate x*90 translate <0,0, 0> }
		torus { 32.3,1 rotate x*90 translate <0,0,-1> }
		torus { 32.3,1 rotate x*90 translate <0,0,-2> }
		torus { 32.3,1 rotate x*90 translate <0,0,-3> }
		box {
			<-2,-1,-24>,<2,1,0>
			rotate y*-40
			translate <0,-21,-2>
		}
		box {
			<-2,-1,-24>,<2,1,0>
			rotate y*-40
			translate <0,21,-2>
		}
		#declare StringArray = array[10] {"R","A","Y","S"," ","D","I","N","E","R"}
		#declare OffsetArray = array[10] {15,30,45,60,75,90,110,118,135,153}
		#declare MT = 0;
		#while (MT < 10)
			text {
				ttf "ArialBD.ttf",
				StringArray[MT],
				.1,     // THICKNESS_FLOAT, extruded into +Z
				0.0       //OFFSET_VECTOR
				scale <11,11,14>
				rotate <90,0,-90>
				translate <-26,0,0>
				rotate z*(-97+OffsetArray[MT])
				texture { Grey40 }
			}
			#declare MT = MT + 1;
		#end
		texture { BrightStainless }
	} // end union

#macro WindowStrip(Length)
	union {
		box {
			<0,-3,0>,<Length,3,1>
		}
		cylinder {
			<0,0,0>,<Length,0,0>,0.5
			scale <1,.4,1>
			translate <0,-3,0.5>
		}
		texture { DarkStainless }
	} // end union
#end
#declare SideWindow =
	union {
		box { // side window
			<32,2,24>,<12*Feet,2.2,24+60>
			texture { DarkGlass }
		}
		object { WindowStrip(12*Feet-33) translate <33,0,24> }
		object { WindowStrip(12*Feet-33) translate <33,0,24+58> }
		object { WindowStrip(58) rotate y*-90 translate <33,0,24> }
		object { WindowStrip(58) rotate y*-90 translate <12*Feet,0,24> }
	} // end union

#declare StreakPig =
	pigment {
		bozo
		color_map {
			[ 0.00  color rgbt<.20,.20,.20,1> ]
			[ 0.31  color rgbt<.2,.20,.20,1> ]
			[ 0.50  color rgbt<0.10,0.08,0.08,.4> ]
			[ 0.69  color rgbt<.2,.2,.2,1> ]
			[ 1.00  color rgbt<.20,.20,.20,1> ]
		}
	}
#declare ClearPig =
	pigment { color rgbt<.1,.1,.1,1> }
#declare Dirt =
	union {
		box { // dirty slime at base of bricks
			<30,0,0>,<32*Feet,1,8>
			texture {
				pigment {
					gradient z
					color_map {
						[ 0.0  color rgbt<.10,.10,.10,.3> ]
						[ 1.0  color rgbt<0.10,.09,.09,1> ]
					}
					turbulence .15
					scale <1,1,8>
				}
				normal { bumps .2 scale 1 }
				finish { ambient .02 specular .2 roughness .02 }
			}
			translate <0,-.01,0>
		}
		box { // slime under window
			<0,0,0>,<12*Feet-33,1,20>
			texture {
				pigment {
					gradient z
					pigment_map {
						[ 0.00 ClearPig ]
						[ 0.72 StreakPig ]
						[ 1.00 ClearPig ]
					}
					turbulence <.1,.1,.8>
				}
				normal { bumps .2 scale 1 }
				finish { ambient .02 specular .2 roughness .02 }
				scale <4,4,20>
			}
			translate <33,-.1,23-20>
		}
	} // end union

#declare WallCrack =
	box {
		<0,0,0>,<1,1,1> // the box is initially square
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "WallCrack.png"
					once
				}
			}
			finish { ambient 1 }
			scale <1,1,1> // the image is initially square
		}
		rotate <90,0,0> // align to wall
		translate <0,0.95,0>
		scale <3*Feet,1,6*Feet>
	}

#declare DinerBuilding =
	union {
		difference {
			box { // outer shell
				<0,0,0>,<32*Feet,22*Feet,38*Feet>
				texture { GreyStucco }
			}
			box { // inner shell
				<6,6,0.1>,<32*Feet-6,22*Feet-8,38*Feet-8>
				texture { Grey80 }
			}
			box { // front window opening
				<-1,32,24>,<8,18*Feet,24+60>
				texture { GreyStucco }
			}
			box { // side window opening
				<32,-1,24>,<12*Feet,8,24+60>
				texture { GreyStucco }
			}
			box { // front sign opening
				<-1,-1,24+60>,<8,19*Feet,24+60+24>
				texture { GreyStucco }
			}
			box { // side sign opening
				<-1,-1,24+60>,<13*Feet,8,24+60+24>
				texture { GreyStucco }
			}
			box { // corner door opening
				<-20,0,-1>,<20,40,7*Feet>
				rotate z*-45
				texture { GreyStucco }
			}
			box { // hole for vent
				<-.5,-3,0>,<16.5,5,9.8>
				translate <11.5*Feet,0,5>
				texture { GreyStone50 }
			}
		} // end difference
		box { // corner support RH of door
			<0,0,0>,<10,8,10*Feet>
			texture { Grey80 }
			translate <36,6,0>
		}
		box { // corner support LH of door
			<0,0,0>,<8,10,10*Feet>
			texture { Grey80 }
			translate <6,36,0>
		}
		box { // front window
			<2,32,24>,<2.2,18*Feet,24+60>
			texture { DarkGlass }
		}
		object { RoundedHalfBox(.1) // front step
//			translate <.5,.5,.5> // origin at corner
			scale <3.6*Feet,36,6>
			texture { GreyStone30 }
			rotate z*-45
			translate <14,14,0>
		}
	}

#declare CornerDiner =
	union {
		object { DinerBuilding }
		object { SideWindow translate <0,0.6,0> }
		object { DinerAwningSign rotate z*45 translate <6,6,7.3*Feet> }
		object { GlassDoor40 rotate z*-45 translate <2,40/1.414,0> }
		object { NeonGroup translate <0,0,24+60> }
		object { Vent translate <11.5*Feet,0.1,5> }
		object { DownSpout rotate <0,0,0> translate <14*Feet,-5,0> }
		object { Dirt }
		object { WallCrack rotate <0,7,0> translate <12*Feet,0,15> }
	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings {
	ambient_light 0 // default <1,1,1>, use 0 for radiosity
}

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
//		location  <3*Feet, -22*Feet, 15*Feet> // overall
//		look_at <3*Feet,0,5*Feet>
		location  <28*Feet, -28*Feet, 5*Feet> // render view
		look_at <5*Feet,0,7*Feet>
	}

light_source
{ <40*Feet,-35*Feet,50*Feet>, 1.6
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*2.2
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

object { CornerDiner scale 1.0 rotate z*25 translate <0,0*Feet,0> }

#end
