
// POV-Ray Object File - Speeder Engine
// created 14-Dec-03
// last update 30-Dec-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Engine.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", EngineValveCoverShape.inc
//
// Objects:
// EngineAssy
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Engine origin is along the main driveshaft, with Z=up
// Exhaust pipes extend into +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here
#include "EngineValveCoverShape.inc"


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare EngineTex =
	texture {
		pigment { color rgb<.99,.99,.99>*.08 }
		finish { specular 0.13 roughness 0.14 }
	}
#declare ChromeTex =
	texture {
		pigment { color rgb<.99,.99,.99>*.38 }
		finish { specular 0.83 roughness 0.024 reflection 0.68}
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare EngineBlock =
	union {
		difference {
			box { <0,-12,-13>,<30,12,16> }
			box { <-2,0,-12>,<32,22,16> rotate x*57 translate <0,10,8> }
			box { <-2,0,-12>,<32,22,16> rotate x*-40 translate <0,10,-6> }
			box { <-2,-22,-12>,<32,0,16> rotate x*8 translate <0,-10,0> }
		texture { EngineTex}
		} // end difference
	} // end union

#declare ValveCover =
	object { EngineValveCoverShape
		scale <1.6,1.6,-1.6>
		rotate <0,0,-90>
		translate <0,12,16>
		texture { ChromeTex }
	}
#declare Fin =
	union {
		box { <0,-0.2,0>,<0.8,0.2,8> }
		cylinder { <0.8,0,0>,<0.8,0,8>,0.2 }
		texture { ChromeTex }
	} // end union
#declare FinGroup =
	union {
		object { Fin }
		object { Fin translate <0,1.2,0> }
		object { Fin translate <0,2.4,0> }
		object { Fin translate <0,3.6,0> }
	} // end union
#declare Gen =
	union {
		cylinder { <0,0,0>,<5,0,0>,1.8 texture { EngineTex } }
		cylinder { <5,0,0>,<5.3,0,0>,1.8 texture { ChromeTex } }
		cylinder { <5,0,0>,<6.2,0,0>,1.4 texture { ChromeTex } }
	} // end union
#declare Lever =
	union {
		box { <0,0,0>,<1,.24,5> rotate <0,-30,0> }
		cylinder { <-24,0,0>,<0,0,0>,.2 }
		texture { ChromeTex }
	} // end union
#declare ExhaustPipe =
	difference {
//union {
		cylinder { <0,0,0>,<30,0,0>,3.44 texture { ChromeTex } }
		cylinder { <1,0,0>,<31,0,0>,3.05 texture { EngineTex } }
		box { <0,-4,-4>,<4,4,6> rotate y*30 translate <28,0,0> texture { ChromeTex } }
	} // end difference
#declare EngineAssy =
	union {
		object { EngineBlock }
		object { Gen translate <24,8,-8> }
		object { Lever translate <24,12,-2> }
		object { ValveCover translate <30,0,0>}
		object { FinGroup translate <33,-3,-3> }
		object { ExhaustPipe translate <15,-6,15> }
		object { ExhaustPipe translate <15, 6,15> }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <3*Feet, -12*Feet, 5*Feet> // overall
		look_at <0*Feet,0,2*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { EngineAssy scale 1 rotate z*-6 translate <0,0 ,18> }
object { EngineAssy scale 1 rotate z*-90 translate <-4*Feet,4*Feet,28> }


#end
