
// Glenn's Windows POV-Ray Object File
// This file does not render.  #include "Windows.inc" in another .pov file
// first concept 20-Sep-97  last update 13-Dec-03
// copyright 1997-2003 Glenn McCarter

// A collection of simple windows
// objects: BasicWindow, Awning
// Intended scale is English system (inches)
// origin at lower LH outside corner.  Window lies in +X+Z plane
// Uses RH coord system

//===============================================
//             Textures
//===============================================

#declare Grey10 =
	texture {
		pigment { color rgb<.1,.1,.1> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey20 =
	texture {
		pigment { color rgb<.2,.2,.2> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey30 =
	texture {
		pigment { color rgb<.3,.3,.3> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey50 =
	texture {
		pigment { color rgb<.5,.5,.5> }
		finish { ambient .02 specular .8 roughness .005 }
	}

#declare JustGlass =
	texture {
		pigment { color rgbf<1,1,1,.9> }
		finish { ambient .02 reflection .6 }
	}
#declare AwningTex =
	texture {
		pigment { color rgb<.31,.31,.33> }
		normal { bumps .2 scale <2,2,5> }
		finish { ambient .02 specular .7 roughness .03 }
	}

//===============================================
//             Variables
//===============================================

#ifndef ( Height )
	#declare Height = 5*Feet;
#end
#ifndef ( Width )
	#declare Width = 5*Feet;
#end
#ifndef ( Depth )
	#declare Depth = 5*Feet;
#end


//===============================================
//             Window
//===============================================

#declare BasicWindow =
	union {
		difference {
			box { // frame outer
				<0,0,0>,<Width,8,Height>
				texture { Grey50 }
			}
			box { // frame inner
				<1,-1,1>,<Width-1,12,Height-1>
				texture { Grey50 }
			}
		} // end difference
		box { // window glass
			<.5,3,.5>,<Width-.5,3.12,Height-.5>
			texture { JustGlass }
		}
	} // end union

//===============================================
//             Window
//===============================================

#declare AwningShape =
	union {
		cylinder { // top front rad
			<0,0,0>,<Width,0,0>,4
		}
		box { // top
			<0,0,-4>,<Width,Depth,4>
			rotate <15,0,0>
		}
		box { // main sides
			<0,0,-4>,<Width,Depth,4>
		}
		box { // front
			<0,-4,-4>,<Width,Depth,0>
		}
	} // end union

#declare Awning =
	union {
		difference {
			object { AwningShape }
			object { AwningShape scale .96 translate <0,0,-.5> }
		} // end difference
		#declare Count = 0;
		#declare TotalScallops = 12;
		#while ( Count < TotalScallops )
			cylinder { // front bottom edge scallop
				<0,-4,-3>,<0,-3.2,-3>,4
				translate <Width/TotalScallops*Count+4,0,0>
			}
			#declare Count = Count + 1;
		#end
		box { // side lip LH
			<-.2,0,-.2>,<.3,Depth,1>
		}
		box { // side lip RH
			<Width-.3,0,-.2>,<Width+.2,Depth,1>
		}
		texture { AwningTex }
	}

