#include "textures.inc"
#include "colors.inc" 
#include "functions.inc"
#include "stones.inc"
#include "math.inc"

#declare walls = 1;
#declare rad = 1;
#declare columns = 1;
#declare ceiling = 1;
#declare pedestal = 1;
#declare skull = 1;
#declare fire = 1;
#declare sarcophagus = 1;
#declare braziers = 1;
#declare sparklies = 1;
#declare objects = 1;
#declare floortile = 1;
#declare hangings = 1;

//#if (( fire = 1 ) | (braziers = 1))
   #declare FireTex = 1;
   #declare FireQual = 1;
   #include "c:\personal\raytracing\mythology\fire.inc"
//#end

#if ( skull = 1 )
   #include "c:\personal\raytracing\mythology\skull.inc"
#end

#if ( sarcophagus = 1 )
   #include "c:\personal\raytracing\mythology\sarcophagus.inc"
   #include "c:\personal\raytracing\mythology\sword.inc"
#end

#if ( sparklies = 1 )
   #include "c:\personal\raytracing\mythology\sparklies.inc"
#end

#if ( objects = 1 )
   #include "c:\personal\raytracing\mythology\bottles.inc"
   #include "c:\personal\raytracing\mythology\herbl.inc"
   #include "c:\personal\raytracing\mythology\herbf.inc"
   #include "c:\personal\raytracing\mythology\herbs.inc"
   #include "c:\personal\raytracing\mythology\quartz.inc"
   #include "c:\personal\raytracing\mythology\pile.inc"
   #include "c:\personal\raytracing\mythology\candle.inc"
   #include "c:\personal\raytracing\mythology\mortar.inc"
   #include "c:\personal\raytracing\mythology\snuffer.inc"
   #include "c:\personal\raytracing\mythology\dagger.inc"
#end
   
#if ( pedestal = 1 )
   #include "c:\personal\raytracing\mythology\tableleg.inc"
#end                    
                    
#if ( floortile = 1 )
   #include "c:\personal\raytracing\mythology\tile.inc"
#end

#if ( hangings = 1 )
   #include "c:\personal\raytracing\mythology\tapestry.inc"
#end
   
//   #include "c:\personal\raytracing\mythology\venus.inc"

global_settings {
#if (rad = 1)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35

      nearest_count 5
      error_bound 1.8
      recursion_limit 3

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2
      normal on
      media on
    }
#end
max_trace_level 32
  }


camera {
   //location <0, 5, -10>
   //location <0, 15, -30>//Close up of pedestal
   location <0, 20, -40>
   //look_at <0, 0, 0>
   look_at <0, 4.5, -16> //Pedestal top
   //look_at <0, 10, 0>
   }
//light_source { <0, 20, -40> rgb 0.6 }    


#declare Stone =
   texture{ pigment { color White } finish { ambient 0 crand 0.06 diffuse 0.7 } }
   texture{ T_Grnt0a scale <2, 3, 2> rotate <0, 0, -30> }
   texture{ T_Grnt9a scale <5, 3, 4> rotate <0, 0, 40> normal { bumps 0.5 scale 0.0001 } }

#declare r=seed(0);
#macro RoughFace()
   #local F1 = function { pattern { granite translate <rand(r),rand(r),rand(r)> rotate <rand(r),rand(r),rand(r)>} }
   #local F2 = function { pattern { leopard turbulence 0.4 scale 0.10 translate <rand(r),rand(r),rand(r)> rotate <rand(r),rand(r),rand(r)> } }
   #local F3 = function { pattern { leopard turbulence 0.3 scale 0.15 translate <rand(r),rand(r),rand(r)> rotate <rand(r),rand(r),rand(r)>} }
   height_field {
      function 256, 256 { 0.5-0.5*f_rounded_box(x-0.5, y-0.5, z, 0.1, 0.5, 0.5, 0.5) + 0.03*F1(x, y, 0) + 0.05*F2(x, y, 0) + 0.05*F3(x-0.1, y+0.2, 0) }
      translate <-0.5,-0.5,-0.5> 
      }
#end         

#declare Block = difference {
   box { <-0.49, -0.49, -0.49> <0.49, 0.49, 0.49> }

   difference {
      box { <-0.5, -0.5, -0.5> <0.5, 0.5, 0.5> }
      object { RoughFace() }
      translate <0, 0.35, 0>
      }
   difference {
      box { <-0.5, -0.5, -0.5> <0.5, 0.5, 0.5> }
      object { RoughFace() }
      translate <0, 0.35, 0>
      rotate <0, 0, 180>
      }
   difference {
      box { <-0.5, -0.5, -0.5> <0.5, 0.5, 0.5> }
      object { RoughFace() }
      translate <0, 0.35, 0>
      rotate <-90, 0, 0>
      }   
   difference {
      box { <-0.5, -0.5, -0.5> <0.5, 0.5, 0.5> }
      object { RoughFace() }
      translate <0, 0.35, 0>
      rotate <0, 0, 90>
      }   
   difference {
      box { <-0.5, -0.5, -0.5> <0.5, 0.5, 0.5> }
      object { RoughFace() }
      translate <0, 0.35, 0>
      rotate <0, 0, -90>
      }      
   difference {
      box { <-0.5, -0.5, -0.5> <0.5, 0.5, 0.5> }
      object { RoughFace() }
      translate <0, 0.35, 0>
      rotate <90, 0, 0>
      }
   }

#if ( walls = 1 )

//Back Wall
#declare j = 0;
#while ( j < 6 )
   #declare i = 0;
   #while ( i < 15 )
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1.95, 1, 1>
      translate <2*(-7.5+i)+0.5, 2*j+0.5, 0>
      }
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1.95, 1, 1>
      translate <1+2*(-7.5+i)+0.5, 2*j+1.5, 0>
      }   
   #declare i = i + 1;
   #end       
#declare j = j + 1;
#end


//Left Wall
#declare j = 0;
#while ( j < 6 )
   #declare i = 0;
   #while ( i < 20 )
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1.95>
      translate <-15, 2*j+0.5, -2*i-1.5>
      }
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1.95>
      translate <-15, 2*j+1.5, -2*i-0.5>
      }   
   #declare i = i + 1;
   #end       
#declare j = j + 1;
#end


//Right Wall
#declare j = 0;
#while ( j < 6 )
   #declare i = 0;
   #while ( i < 20 )
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1.95>
      translate <15, 2*j+0.5, -2*i-0.5>
      }
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1.95>
      translate <15, 2*j+1.5, -2*i-1.5>
      }   
   #declare i = i + 1;
   #end       
#declare j = j + 1;
#end

#end

//Floor
#if ( floortile = 1 )
#declare j = 0;
#while ( j < 20 )
#declare i = 0;
#while ( i < 15 )
   object { 
      Tile 
      scale <2, 0.5, 2> 
      pigment { 
         marble
         turbulence 2
         color_map {
            [ 0.00 rgb <0.2, 0.2, 0.2> ]
            [ 0.60 rgb <0.3, 0.3, 0.4> ]
            [ 0.95 rgb <0.4, 0.4, 0.5> ]
            [ 1.00 rgb <1.0, 1.0, 1.0> ]
            }
         rotate < 360*rand(r), 360*rand(r), 360*rand(r) >
         }
      finish { reflection 0.2 specular 0.9 roughness 0.02 ambient 0 diffuse 0.65 }
      normal { ripples 0.15 translate <10*rand(r), 10*rand(r), 10*rand(r)> scale 1 }
      translate <-15+2.7*i, -0.15, -1-2*j>
      }
   object { 
      Tile 
      scale <2, 0.5, 2> 
      pigment { 
         marble
         turbulence 2
         color_map {
            [ 0.00 rgb <0.2, 0.2, 0.2> ]
            [ 0.60 rgb <0.3, 0.3, 0.4> ]
            [ 0.95 rgb <0.4, 0.4, 0.5> ]
            [ 1.00 rgb <1.0, 1.0, 1.0> ]
            }
         rotate < 360*rand(r), 360*rand(r), 360*rand(r) >
         }
      finish { reflection 0.2 specular 0.9 roughness 0.02 ambient 0 diffuse 0.65 }
      normal { ripples 0.15 translate <10*rand(r), 10*rand(r), 10*rand(r)> scale 1 }
      translate <-15+2.7*i+2.7/2, -0.15, -2*j>
      }

   #declare i = i + 1;
#end
#declare j = j + 1;
#end
#end

#if ( pedestal = 1 )
//Pedestal Front and Back
#declare j = 0;
#while ( j < 2 )
   #declare i = 0;
   #while ( i < 8 )
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1.95, 1, 1>
      translate <-7+2*i, 2*j+0.5, -23.5>
      }
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1.95, 1, 1>
      translate <-7+2*i, 2*j+0.5, -8.5>
      }
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1.95>
      translate <7.5, 2*j+1.5, 2*i-23>
      }   
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1.95>
      translate <-7.5, 2*j+1.5, 2*i-23>
      }   
   #declare i = i + 1;
   #end       
   #declare i = 0;
   #while ( i < 7 )
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1.95, 1, 1>
      translate <-6+2*i, 2*j+1.5, -23.5>
      }
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1.95, 1, 1>
      translate <-6+2*i, 2*j+1.5, -8.5>
      }
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1.95>
      translate <7.5, 2*j+0.5, 2*i-22>
      }
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1.95>
      translate <-7.5, 2*j+0.5, 2*i-22>
      }
   #declare i = i + 1;
   #end  
#declare j = j + 1;
#end
 
//Pedestal top
box { 
   <-8, 4, -8> <8, 4.3, -24> 
   pigment { 
      marble
      turbulence 2
      color_map {
         [ 0.00 rgb <0.2, 0.2, 0.2> ]
         [ 0.60 rgb <0.3, 0.3, 0.4> ]
         [ 0.95 rgb <0.4, 0.4, 0.5> ]
         [ 1.00 rgb <1.0, 1.0, 1.0> ]
         }
      }
   finish { reflection 0.2 /*specular 0.9 roughness 0.02*/ ambient 0 diffuse 0.65 }
   }

//Pedestal inlay

difference {
   cylinder { <0, 0, 0> <0, 0.02, 0> 7 }
   cylinder { <0, -1, 0> <0, 1, 0> 6.95 }
   texture { Polished_Brass }
   translate <0, 4.3, -16>
   finish { ambient 0.5 diffuse 1 }
   }
difference {
   cylinder { <0, 0, 0> <0, 0.02, 0> 6.5 }
   cylinder { <0, -1, 0> <0, 1, 0> 6.45 }
   texture { Polished_Brass }
   translate <0, 4.3, -16>
   finish { ambient 0.5 diffuse 1 }
   }
#declare i = 0;
#while ( i < 5 )
   box { 
      <-6.15, 4.3, -2> <6.15, 4.32, -2.05> 
      texture { Polished_Brass } 
      rotate <0, 144*i+36, 0>
      translate <0, 0, -16>
      finish { ambient 0.5 diffuse 1 }
      }
   #declare i = i + 1;
#end 

#declare Message = "abandon hope all ye who enter here";
#declare i = 0;
#while ( i < 34 )
text {
  ttf "c:\windows\fonts\cirth.ttf"
  substr( Message, i+1, 1 )
  0.02, 1 
  rotate <90, 0, 0>
  scale 0.5
  translate <0, 4.32, -6.87>
  rotate <0, -3*i+50, 0>
  translate <0, 0, -16>
  texture { Polished_Brass }
  finish { ambient 0.5 diffuse 1 }
  }
text {
  ttf "c:\windows\fonts\cirth.ttf"
  substr( Message, i+1, 1 )
  0.02, 1 
  rotate <90, 0, 0>
  scale 0.5
  translate <0, 4.32, -6.87>
  rotate <0, -3*i+50+120, 0>
  translate <0, 0, -16>
  texture { Polished_Brass }
  finish { ambient 0.5 diffuse 1 }
  }
text {
  ttf "c:\windows\fonts\cirth.ttf"
  substr( Message, i+1, 1 )
  0.02, 1 
  rotate <90, 0, 0>
  scale 0.5
  translate <0, 4.32, -6.87>
  rotate <0, -3*i+50+240, 0>
  translate <0, 0, -16>
  texture { Polished_Brass }
  finish { ambient 0.5 diffuse 1 }
  }  
#declare i = i + 1;
#end
#end
  
  
//Columns
#if ( columns = 1 )
#macro Column(X, Z)
   #local i = 0;
   #while ( i < 12 )
      object {
         Block  
         scale 1.15
         texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
         rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
         scale <1, 1, 1>
         translate <X, i+0.5, Z>
         }   
      #local i = i + 1;
   #end
#end

#declare i = 0;
#while (i < 5)
   Column(-10+5*i, -5)
   #declare i = i + 1;
#end
#declare i = 0;
#while (i < 6)
   Column(-10, -5*i-10 )
   Column(10, -5*i-10 )
   #declare i = i + 1;
#end
#end


//Ceiling  
#if ( ceiling = 1 ) 
difference {
   cylinder { <0, 12.5, 0> <0, 12.5, -45> 16 }
   cylinder { <0, 12.5, 2> <0, 12.5, -52> 10 }
   plane { <0, 1, 0>, 12 }
   torus { 7.1, 3.52 rotate <90, 0, 0> translate <0, 12.5, -42.5> }
   torus { 7.1, 3.52 rotate <90, 0, 0> translate <0, 12.5, -37.5> }
   torus { 7.1, 3.52 rotate <90, 0, 0> translate <0, 12.5, -32.5> }
   torus { 7.1, 3.52 rotate <90, 0, 0> translate <0, 12.5, -27.5> }
   torus { 7.1, 3.52 rotate <90, 0, 0> translate <0, 12.5, -22.5> }
   torus { 7.1, 3.52 rotate <90, 0, 0> translate <0, 12.5, -17.5> }
   cylinder { <12.5, 12, 2> <12.5, 12, -52> 2 }
   cylinder { <-12.5, 12, 2> <-12.5, 12, -52> 2 }
   cylinder { <-12.5, 12, -42.5> <12.5, 12, -42.5> 1.95 }
   cylinder { <-12.5, 12, -37.5> <12.5, 12, -37.5> 1.95 }
   cylinder { <-12.5, 12, -32.5> <12.5, 12, -32.5> 1.95 }
   cylinder { <-12.5, 12, -27.5> <12.5, 12, -27.5> 1.95 }
   cylinder { <-12.5, 12, -22.5> <12.5, 12, -22.5> 1.95 }
   cylinder { <-12.5, 12, -17.5> <12.5, 12, -17.5> 1.95 }
   cylinder { <-12.5, 12, -12.5> <12.5, 12, -12.5> 1.95 }
   cylinder { <-12.5, 12, -07.5> <12.5, 12, -07.5> 1.95 }
   cylinder { <-12.5, 12, -02.5> <12.5, 12, -02.5> 1.95 }
   //pigment { rgb 0.85 } normal { bumps 0.5 scale 0.0001 }
   texture { 
      pigment { color White }
      finish{ ambient 0 crand 0.06 diffuse 0.7 }
      }
   texture{ T_Grnt0a scale <2, 3, 2> rotate <0, 0, -30> }
   texture{ T_Grnt9a scale <5, 3, 4> rotate <0, 0, 40> 
      finish { ambient 0 diffuse 0.65 specular 0.1 roughness 0.01 }   
   }
   normal { ripples 0.2 scale 1 }
   
   } 

difference {
   cylinder { <-16, 12.5, -15> <16, 12.5, -15> 16 }
   cylinder { <-17, 12.5, -15> <17, 12.5, -15> 10 }
   plane { <0, 1, 0>, 12 }
   plane { <0, 0, 1>, -13 }
   //torus { 7.1, 3.5 rotate <0, 0, 90> translate <7.5, 12.5, -14.5> pigment { rgb <0, 0, 1> } }
   //torus { 7.1, 3.5 rotate <0, 0, 90> translate <2.5, 12.5, -14.5> pigment { rgb <0, 0, 1> } }
   //torus { 7.1, 3.5 rotate <0, 0, 90> translate <-2.5, 12.5, -14.5> pigment { rgb <0, 0, 1> } }
   //torus { 7.1, 3.5 rotate <0, 0, 90> translate <-7.5, 12.5, -14.5> pigment { rgb <0, 0, 1> } }
   cylinder { <-7.5, 12, -2.5> <-7.5, 12, -10> 2 }
   cylinder { <-2.5, 12, -2.5> <-2.5, 12, -10> 2 }
   cylinder { <2.5, 12, -2.5> <2.5, 12, -10> 2 }
   cylinder { <7.5, 12, -2.5> <7.5, 12, -10> 2 } 
   cylinder { <-12.75, 12, -02.5> <12.75, 12, -02.5> 2 }
   //pigment { rgb 0.85 } normal { bumps 0.5 scale 0.0001 }
   //finish { ambient 0 diffuse 0.65 }
   texture { 
      pigment { color White }
      finish{ ambient 0 crand 0.06 diffuse 0.7 }
      }
   texture{ T_Grnt0a scale <2, 3, 2> rotate <0, 0, -30> }
   texture{ T_Grnt9a scale <5, 3, 4> rotate <0, 0, 40> 
      finish { ambient 0 diffuse 0.65 specular 0.1 roughness 0.01 }   
   }
   normal { ripples 0.2 scale 1 }
   }
#end    


//Arches
#if ( columns = 1 )
#declare j = 0;
#while ( j < 5 )
#declare i = 0;
#while ( i < 186 )
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1>
      translate <-10, 0, 0>
      rotate <0, 0, -i>
      translate <0, 12.5, -15-5*j>
      }   
   #declare i = i + 6;
#end   
#declare j = j + 1;
#end   

//Center back arch
#declare i = 0;
#while ( i < 96 )
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1>
      translate <0, 0, 10>
      rotate <-i, 0, 0>
      translate <0, 12.5, -15>
      }   
   #declare i = i + 6;
#end  

//Diagonals
#declare i = 0;
#while ( i < 96 )
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1>
      rotate <0, 0, 30*sind(i)>
      translate <0, 0, 10>
      rotate <-i, 0, 0>
      translate <5, 12.5, -15>
      translate <-5+5*cosd(i), 0, 0>
      }   
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1>
      rotate <0, 0, -30*sind(i)>
      translate <0, 0, 10>
      rotate <-i, 0, 0>
      translate <5, 12.5, -15>
      translate <-5-5*cosd(i), 0, 0>
      }   
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1>
      rotate <-30*sind(i), 0, 0>
      translate <-10, 0, 0>
      rotate <0, 0, -i>
      translate <0, 12.5, -10>
      translate <0, 0, -5+5*cosd(i)>
      }   
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1>
      rotate <-45*sind(i), 0, 0>
      translate <-10, 0, 0>
      rotate <0, 0, -i>
      translate <0, 12.5, -5>
      translate <0, 0, -10+10*cosd(i)>
      }  
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1>
      rotate <-30*sind(i), 0, 0>
      translate <10, 0, 0>
      rotate <0, 0, i>
      translate <0, 12.5, -10>
      translate <0, 0, -5+5*cosd(i)>
      }   
   object {
      Block  
      scale 1.15
      texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
      rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
      scale <1, 1, 1>
      rotate <-45*sind(i), 0, 0>
      translate <10, 0, 0>
      rotate <0, 0, i>
      translate <0, 12.5, -5>
      translate <0, 0, -10+10*cosd(i)>
      }   
   #declare i = i + 6;
#end  
#end

//Steps up to pedestal
#if ( pedestal = 1 )
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <-1, 0.5, -27.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <1, 0.5, -27.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1, 1, 1.95>
   translate <-2.5, 0.5, -27>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1, 1, 1.95>
   translate <-2.5, 0.5, -25>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1, 1, 1.95>
   translate <2.5, 0.5, -27>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1, 1, 1.95>
   translate <2.5, 0.5, -25>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <2, 1.5, -26.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <0 1.5, -26.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <-2, 1.5, -26.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1, 1, 1.95>
   translate <-2.5, 1.5, -25>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1, 1, 1.95>
   translate <2.5, 1.5, -25>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1, 1, 1.95>
   translate <-2.5, 2.5, -25>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1, 1, 1.95>
   translate <2.5, 2.5, -25>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <-1, 2.5, -25.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <1, 2.5, -25.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <2, 3.5, -24.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <0, 3.5, -24.5>
   }
object { 
   Block  
   scale 1.15
   texture { Stone rotate <360*rand(r), 360*rand(r), 360*rand(r)> scale 0.4 }
   rotate <90*int( rand(r) * 4), 90*int( rand(r) * 4), 90*int( rand(r) * 4)>
   scale <1.95, 1, 1>
   translate <-2, 3.5, -24.5>
   }
#end
   

//Skull
#if ( skull = 1 )
object { 
   Skull 
   no_shadow
   rotate <0, 180, 0>
   rotate <-110, 0, 0>
   scale 0.07 
   pigment { rgbt <0.75, 0.75, 0.75, 0.6> } 
   finish { ambient 0.2 diffuse 0.65 }
   translate <0, 10, -14.5>
   }
sphere { <-0.5, 11.7, -16.5>, 0.2 texture { Ruby_Glass } }
sphere { <0.5, 11.7, -16.5>, 0.2  texture { Ruby_Glass } }
light_source { <-0.5, 11.7, -16.5> rgb 3 fade_power 2 fade_distance 0.4 }
light_source { <0.5, 11.7, -16.5>  rgb 3 fade_power 2 fade_distance 0.4 }
#end
                                          
//Magical flames
#if ( fire = 1 )
   object { BigFire rotate <0, 30, 0> translate <0, 4.501, -17> no_shadow }
   light_source { <0, 7, -16> rgb 0.1*<0.4, 0.7, 1> fade_distance 10 fade_power 2}
   light_source { <0, 9, -16> rgb 0.1*<0.4, 0.7, 1> fade_distance 10 fade_power 2}
   light_source { <0, 11, -16> rgb 0.1*<0.4, 0.7, 1> fade_distance 10 fade_power 2}
   light_source { <0, 13, -16> rgb 0.1*<0.4, 0.7, 1> fade_distance 10 fade_power 2}
   light_source { <0, 15, -16> rgb 0.1*<0.4, 0.7, 1> fade_distance 10 fade_power 2}
#end
  

//Sarcophagus
#if ( sarcophagus = 1 )
object { 
   S_body 
   texture { T_Stone10 }
   translate <0.9, 5, -16>
   }
object { 
   S_lid 
   texture { T_Stone10 }
   rotate <0, 0, 45>
   rotate <-8, 0, 0>
   rotate <0, -10, 0>
   translate <-1.1, 5.4, -16>
   }  
object { 
   S_shroud
   pigment { image_map { gif "c:\personal\raytracing\mythology\net5.gif"} scale 0.1 }
   translate <0.9, 5, -16>
   }
union {
   object { SBlade texture { Polished_Chrome } }
   object { SHilt texture { Polished_Brass } }
   object { SGrip pigment { rgb 0.4 } normal { bumps 0.5 scale 0.001 } }
   object { SPommel texture { Polished_Brass } }
   scale 0.12
   rotate <180, -1, 0>
   translate <0.2, 5.9, -15.5>
   }
#end

#declare Link = union {
   difference {
      torus { 1, 0.2 }
      box { <0, -2, 2> <2, 2, -2> }
      translate <-0.5, 0, 0>
      }
   difference {
      torus { 1, 0.2 }
      box { <0, -2, 2> <-2, 2, -2> }
      translate <0.5, 0, 0>
   }
   cylinder { <-0.5, 0, 1> <0.5, 0, 1>, 0.2 }
   cylinder { <-0.5, 0, -1> <0.5, 0, -1>, 0.2 }
   texture { Polished_Chrome }
   }

#declare Schain = union {
   #declare i = 0;
   #while ( i < 20 )
      object { 
         Link 
         #if ( odd(i) = 1 )
            rotate < 90, 0, 0 >
         #end
         translate <-10 + i*(3-0.4), 0, 0>
         }
      #declare i = i + 1;
   #end
   scale 0.05
   rotate <90, 0, 68>
   translate <-0.8, 0.5, 0>              
   }


//Braziers
#if ( braziers = 1 )
#declare Brazier = union {
union {
   difference {
      sphere { <0, 0, 0> 1 }
      sphere { <0, 0, 0> 0.95 }
      plane { <0, -1, 0> 0 }
      }
   torus { 1, 0.03 }
   pigment { rgb 0.5 }
   }
   
   object { Fire translate <0, -1.2, 0> rotate <0, 360*rand(r), 0> }

   //Coals
   intersection { 
      sphere { <0, 0, 0>, 0.95 }
      sphere { <0, -2.0, 0>, 1.7 }
      pigment { 
         granite
         color_map {
            [0.0 rgbt <0.0, 0.0, 0.0, 0.0> ]
            [0.4 rgbt <0.0, 0.0, 0.0, 0.5> ]
            [0.5 rgbt <1.0, 0.3, 0.2, 0.0> ]
            [1.0 rgbt <1.0, 0.4, 0.2, 0.0> ]
            }
         }
      }
   light_source { <0, 2, 0> rgb 0.15*<1.0, 0.7, 0.2> fade_power 2 fade_distance 7 }
   light_source { <0, -0.5, 0> rgb <1.0, 0.6, 0.1> fade_power 2 fade_distance 1 }
   
   object { Schain no_shadow }
   object { Schain no_shadow rotate <0, 120, 0> }
   object { Schain no_shadow rotate <0, 240, 0> }

   union {
      #declare i = 0;
      #while ( i < 120 )
         object { 
            Link 
            #if ( odd(i) = 1 )
               rotate < 90, 0, 0 >
            #end
            translate <-10 + i*(3-0.4), 0, 0>
            }
        #declare i = i + 1;
      #end
      scale 0.05
      rotate <0, 0, 90>
      translate <0, 2.7, 0>              
      no_shadow
      }
   }   
   
   object { Brazier rotate <0, 360*rand(r), 0> translate <-10, 10, -12.5> }
   object { Brazier rotate <0, 360*rand(r), 0> translate <10, 10, -12.5> }
   object { Brazier rotate <0, 360*rand(r), 0> translate <-10, 10, -22.5> }
   object { Brazier rotate <0, 360*rand(r), 0> translate <10, 10, -22.5> }
#end  
  

//Magic sparklies
#if ( sparklies = 1 )
#declare i = 0;
#while ( i < 100 )
   #declare R = 10 * rand(r);
   #declare theta = 360*rand(r);
   #declare P = R*x*cosd(theta) + R*z*sind(theta) + y*20*rand(r) -16*z;
   Flare(P)   
   #declare i = i + 1;
#end
#end

//Ring of fire on pentagram
#if ( fire = 1 )
object { RingFire translate < 0, 4.301, -16> }
/*
#declare i = 0;
#while ( i < 5 )
   light_source { 
      <0, 1, 7> 
      rgb 0.2*<0.4, 0.7, 1>
      fade_power 2 
      fade_distance 5 
      rotate <0, 72*i, 0> 
      translate <0, 4.5, -16> 
      }
   #declare i = i + 1;
#end */
#end

#if ( objects = 1 )
//Earth jar
union {
   object { Bottle1 texture { T_Stone5 } }
   object { Stopper1 texture { Cork scale 0.5*<1, 2, 1> } }
   scale 0.5
   rotate <-90, 15, 0>
   translate <-7.25, 6.9, -8.5>
   }

//Red bottle
union {
   object { Bottle2 texture { T_Stone21 } }
   object { Stopper2 texture { Cork scale 0.5*<1, 2, 1>} }
   scale 0.5
   rotate <-90, 0, 0>
   translate <7, 6.9, -23>
   }

//Empty bottle
object {
   Bottle3
   rotate <-90, 0, 0>
   scale 0.7
   pigment { rgbt <0.7, 0.7, 1, 0.95 > }
   finish { reflection 0.3 specular 0.5 roughness 0.001 ambient 0 diffuse 0.65 }
   interior { ior 1.5 }
   translate <7, 6.9, -9>
   }

//Water in dish
union {
   difference {
      sphere { <0, 0, 0> 1 }
      sphere { <0, 0, 0> 0.98 }
      plane { <0, -1, 0>, 0 }
      }
   torus { 1, 0.02 }
   difference {
      sphere { <0, 0, 0> 0.9799 }
      plane { 
         <0, -1, 0>, 0.4 
         normal { ripples 0.5 turbulence 0.1 scale 0.1 } 
         pigment { rgbt <0.4, 0.4, 1, 0.8> } 
         finish { reflection 0.3 specular 0.5 roughness 0.1 ambient 0.2 diffuse 0.01 }
         }
      interior { ior 1.3 }
      }
   translate <0, 1, 0>
   scale 0.7*<1, 0.5, 1>
   texture { Silver3 }
   finish { ambient 0 diffuse 0.65 }
   translate <-6.5, 6.9, -23.3>
   }

//Herbs
union { 
   object { Herbs }
   object { Herbf pigment { rgb <0.5, 0.6 , 0.3> } } 
   scale 0.1
   rotate <0, 0, 70>
   rotate <0, 30, 0>
   translate <7.25, 7, -10.25>
   }

//Quartz crystals

object { 
   Quartz 
   pigment { rgbt <1, 1, 1, 0.95> } 
   interior { ior 1.5 }
   finish { specular 0.7 roughness 0.001 ambient 0 diffuse 0.65 }
   scale 0.3
   translate <-6.45, 6.9, -9.5>
   }
object { 
   Dish 
   scale 0.9
   translate <-6.25, 6.9, -9.75> 
   //pigment { rgb <2, 0, 0>}
   texture { Silver3 } finish { ambient 0 diffuse 0.65 } 
   }

//Brimstone
object { Pile scale 0.5 translate <6.1, 6.9, -22.75> }
object { Dish scale 0.5 translate <6.1, 6.9, -22.75> }

//Candle
union {
   object { 
      Candle 
      pigment { rgb <1, 0.95, 0.9> } 
      finish { specular 0.3 roughness 0.1 ambient 0 diffuse 0.65 }
      }
   object { 
      CDrips 
      pigment { rgb <1, 0.95, 0.9> } 
      finish { specular 0.3 roughness 0.1 ambient 0 diffuse 0.65 }
      }
   object { CWick  pigment { rgb 0.3 } }
   object { CStick texture { Polished_Brass } }
   scale 0.6
   
   rotate <-90, 200, 0>
   translate <-7.3, 6.9, -22>
   }


//Mortar and pestle
union { 
   object { Mortar texture { T_Stone17 scale 0.5 } }
   object { Pestle texture { T_Stone17 scale 0.5 } }
   scale 0.5
   rotate <-90, 190, 0>
   translate <6.7, 6.9, -22>
   }

//Candle snuffer
union {
   object { SBell texture { Polished_Brass } }
   object { SBody texture { Polished_Brass } }
   object { SHandle texture { Rosewood } finish { specular 0.4 roughness 0.01 } }
   scale 0.5
   
   rotate <0, 0, 190>
   rotate <0, -45, 0>
   
   translate <-5.3, 7, -23.0>
   } 

//Dagger
union {
   object { DBlade texture { Silver3 } finish { ambient 0 diffuse 0.65 } }
   object { DHandle texture { Rosewood } finish { specular 0.4 roughness 0.01 } }
   object { DHilt texture { Polished_Brass } }
   object { DPommel texture { Polished_Brass } }
   scale 0.25
   rotate <0, 0, 15>
   rotate <0, -70, 0>
   translate <7, 7, -10.7>
   }

#end


//Ritual component tables
#if ( pedestal = 1 )
#declare Table = union {
union {
   object { Tableleg scale 0.2 rotate <-90, 0, 0> }
   object { Tableleg scale 0.2 rotate <-90, 120, 0> }
   object { Tableleg scale 0.2 rotate <-90, 240, 0> }
   cylinder { <0, 0.9, 0> <0, 1.3, 0>, 0.1 }
   pigment { rgb 0.3 }
   normal { bumps 0.3 scale 0.001 }
   }
union {
   cylinder { <0, 2.5, 0> <0, 2.6, 0>, 1.5 } 
   torus { 1.5, 0.05 translate <0, 2.55, 0> }
   pigment { rgb 0.1 }
   finish { reflection 0.2 specular 0.5 roughness 0.01 ambient 0 diffuse 0.65 }
   }
}

object { Table rotate <0, -45, 0> translate <6.5, 4.3, -9.5> } 
object { Table rotate <0, 45, 0> translate <-6.5, 4.3, -9.5> }
object { Table rotate <0, -45, 0> translate <6.5, 4.3, -22.5> }
object { Table rotate <0, 45, 0> translate <-6.5, 4.3, -22.5> }
#end

//Tapestries
#if ( hangings = 1 )
#declare Hanging = union {
   object { 
      Tapestry 
      //pigment { rgb <1, 0, 0> } 
      texture {
      pigment { 
         uv_mapping 
         image_map { gif "c:\personal\raytracing\mythology\yclothtile.gif"} 
         scale 0.1
         }
         }
      texture {   
      pigment {
         image_map { 
            png "c:\personal\raytracing\mythology\runes1.png"
            //once
            filter all 1
            }
         rotate <90, 0, 0>
         rotate <0, 90, 0>
         translate 1/20*<0, 0, -10>
         scale 16
         }
         }    
      finish { specular 0.2 roughness 0.1 ambient 0 diffuse 0.65 }
      normal { bumps 0.6 scale 0.01 }
      }
   object { Rods texture { Polished_Brass } }
   scale 0.6
   rotate <0, 90, 0>
   rotate <90, 0, 0>
   }

object { Hanging translate <-5, 3, -1.5> }
object { Hanging translate <5, 3, -1.5> }
object { Hanging rotate <0, 90, 0> translate <-14, 3, -10> }
object { Hanging rotate <0, -90, 0> translate <14, 3, -10> }
object { Hanging rotate <0, 90, 0> translate <-14, 3, -20> }
object { Hanging rotate <0, -90, 0> translate <14, 3, -20> }
object { Hanging rotate <0, 90, 0> translate <-14, 3, -30> }
object { Hanging rotate <0, -90, 0> translate <14, 3, -30> }
#end

/*
cylinder { <0, 0, 0> <0, 2, 0>, 1.5 pigment { rgb <0, 1, 0> } translate <-5, 0, -30> }

object { 
   Venus 
   pigment { rgb <1, 0, 0> } 
   rotate <-90, 90, 0> 
   scale 0.075 
   translate <-5, 2, -30> 
   }
*/

 
#if (( fire = 0 ) & ( braziers = 0 ))
   light_source { <0, 20, -70> rgb 1 }
   light_source { <0, 20, -16> rgb 1 }
#end
 
   
//light_source { <0, -20, -40> rgb 1 }
