#ifndef ( r ) 
   #declare r = seed(0);
#end

#declare Dish = union {
   difference {
      sphere { <0, 0, 0> 1 }
      sphere { <0, 0, 0> 0.98 }
      plane { <0, -1, 0>, 0 }
      }
   torus { 1, 0.02 }
   translate <0, 1, 0>
   scale <1.2, 0.2, 1.2>
   texture { Silver3 }
   finish { ambient 0 diffuse 0.65 }
   //translate <-7, 6.9, -23>
   }

#declare Pile = union {
#declare j = 0;
#while ( j < 1 )
#declare i = 0;
#while (i < (1 - j)*300) 
   #declare R = sqrt(1 - j) * rand(r);
   #declare theta = 360*rand(r);
   #declare X = R * cosd(theta);
   #declare Z = R * sind(theta);
   #declare V = trace( Dish, <X, 10, Z>, <0, -1, 0> );
   #declare Y = vlength(<X, 0, Z> - V);
   //#warning vstr(3, Y, ",", 0, 2)
   
   #if ( Y < 0.1 + j ) 
   box{ 
      <-0.05, -0.05, -0.05> <0.05, 0.05, 0.05> 
      scale 0.5*(0.5+0.5*rand(r))
      rotate <360*rand(r), 360*rand(r), 360*rand(r)> 
      translate <X, 0.1+j, Z>
      pigment { rgbt <1, 1, 0, 0.5+0.5*rand(r)> }
      finish { specular 0.5 roughness 0.01 }
      interior { ior 1.4 }
      } 
   #declare i = i + 1;
   #end
#end
#declare j = j + 0.025;
#end
}
  
