// Persistence of Vision Ray Tracer Scene Description File
// File: Nemo1.pov
// Vers: 3.5
// Desc: Nautilus on the prowl . . . 
// Date: 02/29/04
// Auth: Chris Holtorf
//

#version 3.5;

/*Sub Texture for reference
texture {
  pigment { color rgbf <0.411765, 0.411765, 0.411765, 0> }
  finish  { ambient 0.3 diffuse 0.4 specular 0.30 roughness 0.2 }  normal { bumps 0.3 scale 0.04 }
  }  */

#include "colors.inc"	  
#include "textures.inc"	  
#include "functions.inc"   

#include "Sub.inc"
#include "Lights_Windows.inc"
#include "Prop.inc"
#include "Rivets.inc" 
#include "Rivets2.inc"
#include "D:\February Contest\Sub\Drawings\Render Geometry\Fish\Fish.inc"
#include "D:\February Contest\Sub\Drawings\Render Geometry\Fish\Fish2.inc" 
#include "D:\February Contest\Sub\Drawings\Render Geometry\Ship\SunkenShip.inc"
#include "Gun.inc"
#include "Wake.inc"


camera {
   perspective
   location <-113.125, 33.454, -61.4058>
   right <0.631334, 0, -1.17439>
   up <0.222003, 0.967715, 0.119345>
   direction <0.852357, -0.252049, 0.458213>
   angle 18.2474
   look_at <-3.61844, 1.07196, -2.53683>
}


light_source { <-10883.1, 6678.74, -1453.23> color rgb <1,1,1> }

global_settings {
  ambient_light color rgb <0, 0, 0>
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 1000                      // higher -> higher quality (1..1600) [35]
    nearest_count 8               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 0.8                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}
                               

sky_sphere{pigment {gradient y                          
   color_map { [0.0 SteelBlue+((White)/2)][0.75 rgb<.9,.625,.65>/1.25]}
 	}
  	  rotate x*-5
		}

fog {
    distance 150
    color rgbf<0.3, 0.5, 0.5, 0.75>
    turbulence 0.3
    turb_depth 0.3
  }

//Sandy Ground
plane{ y, -20 texture{ pigment{color rgb <0.7,0.5,0.3>} normal { bozo 15 scale 50 } finish {ambient 0.1 diffuse 0.8} }  
      } 

//Rocky ground
height_field { png "NewFloor.png"     
                smooth
                texture{ pigment{color rgb <0.7,0.4,0.4>} normal { bozo 0.5 scale 0.25 } finish {ambient 0.1 diffuse 0.6} }
                translate<-0.5,0,-0.5> rotate<0,-40,0>
                scale<100,8,100> translate<0,-22,0> 
                }
              
             
#declare Nautilus = union {
        object { Hull }
        object { Windows }
        object { Prop }
        object { Rivets }
        object { Rivets2 }        
        object { Wake }
        }
        
object { Nautilus rotate<-10,0,-4> translate<0,0,0> } 


object { Ship scale<10,10,10> rotate<0,20,0> translate<100,-22.5,100> } 
object { Gun scale<0.05,0.05,0.05> rotate<0,40,0> translate<82,-20,62> texture { Rusty_Iron } }
object { Gun scale<0.05,0.05,0.05> rotate<0,-30,0> translate<52,-20.3,52> texture { Rusty_Iron } }

#declare Nscale = 0.1; 
#declare Sscale = 0.7;
//School of Fish
#declare School = union {
                         object { Fish scale<14,12,14>*Sscale rotate<0,2,3> translate<0.00,0.00,0.00>*Nscale } 
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,1,2> translate<0.00,-25.39,162.15>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,3,1> translate<0.00,19.45,197.67>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,3,0> translate<-15.08,10.12,258.12>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,0,-2> translate<-6.03,17.23,93.96>*Nscale }
                         object { Fish scale<14,12,14>*Sscale rotate<0,1,1> translate<-16.92,-29.83,21.69>*Nscale }
                         object { Fish scale<14,12,14>*Sscale rotate<0,-2,-3> translate<24.63,18.56,23.03>*Nscale }
                         object { Fish scale<14,12,14>*Sscale rotate<0,-5,1> translate<10.72,-9.85,73.29>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,0,2> translate<34.35,-17.61,123.82>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,2,-2> translate<18.94,-2.31,286.88>*Nscale }
                         object { Fish scale<14,12,14>*Sscale rotate<0,0,-2> translate<16.75,-23.42,212.06>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,0,0> translate<-33.50,-23.43,151.74>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,1,0> translate<0.00,45.11,223.86>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,0,3> translate<24.12,34.12,233.76>*Nscale }
                         object { Fish scale<14,12,14>*Sscale rotate<0,0,1> translate<19.76,46.19,154.93>*Nscale }
                         object { Fish scale<14,12,14>*Sscale rotate<0,-2,4> translate<-26.80,9.76,54.61>*Nscale }
                         object { Fish scale<14,12,14>*Sscale rotate<0,-2,2> translate<-22.78,26.79,193.91>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,0,-2> translate<-12.13,35.63,114.85>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,2,-4> translate<-17.74,-6.48,214.10>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,0,-1> translate<-30.85,-4.68,104.09>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,3,0> translate<10.75,22.26,125.45>*Nscale }
                         object { Fish scale<14,12,14>*Sscale rotate<0,0,2> translate<9.31,4.53,152.61>*Nscale }
                         object { Fish2 scale<14,12,14>*Sscale rotate<0,1,0> translate<-11.53,-18.82,163.41>*Nscale } 
                         rotate<0,0,0>
                         }
                         
                         
object { School rotate<0,-40,0> translate<100,-12,70> }                         



