#include "header.inc"
  camera {
    location <10, 20, -30>
    look_at <0, 8, 0>
    angle 45
  }
 sky_sphere { S_Cloud3 }
  light_source { <100, 100, -100> color rgb 1 }
  plane {
    y, 0
    pigment { checker color Black, color White scale 10 }
        finish { phong 1.0 }
  }

//lamp
  sor {
    5,
    <0.0,   0.0>,
    <3.0,   0.0>,
    <1.5,   3.0>,
    <2.7,   6.0>,
    <0.0,   6.0>
    texture { pigment { color Red } }
    finish { phong 1.0 }
  }
  sor {
    4,
    <0.0,   6.0>,
    <2.7,   6.0>,
    <1.0,  15.0>,
    <0.0,  15.0>
    hollow
        
   pigment { color White filter 0.95 }
   finish {
      ambient 0.0
      diffuse 1.0
      reflection 0.1
      phong 50.3
      phong_size 90
   }
   }
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>*2    // light's color
  translate <0, 5, 0>
}

sor {
    4,
    <0.0,   15.0>,
    <1.0,   15.0>,
    <.5,   16.5>,
    <0,   16.5>
    texture { pigment { color Red } }
    finish { phong 1.0 }
  }
//end lamp

//blobs

// create a smooth blobby shape
#declare RadiusVal   = 1.0; // (0 < RadiusVal) outer sphere of influence on other components
#declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density

blob {
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  sphere { < 0.0,   6,    0>, RadiusVal, StrengthVal }
  sphere { <-0.375,  8.65, 0>, RadiusVal, StrengthVal }
  sphere { <-0.375, 7.65, 0>, RadiusVal, StrengthVal }
  sphere { <0.2, 9.65, 0>, .7, StrengthVal }
  sphere { <0.2, 6.65, 0>, .7, StrengthVal }
  cylinder { -z, +z, RadiusVal, StrengthVal }
  // [sturm]
  scale 2
  translate <0,-5,0>
    texture { pigment { color NeonBlue } }
    texture { T_Glass1 }
}                


global_settings {
assumed_gamma 2.2

  radiosity {             // --- Settings 1 (fast) ---
    pretrace_start 0.08
    pretrace_end   0.02
    count 1500
    error_bound 0.5
    recursion_limit 1
  }
  /*
  radiosity {             // --- Settings 2 (medium quality) ---
    pretrace_start 0.08
    pretrace_end   0.01
    count 120
    error_bound 0.25
    recursion_limit 1
  }*/
  /*
  radiosity {             // --- Settings 3 (high quality) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 400
    error_bound 0.1
    recursion_limit 1
  }*/
  /*
  radiosity {             // --- Settings 4 (medium quality, recursion_limit 2) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 350
    error_bound 0.15
    recursion_limit 2
  }*/
}