// Thibaut Jonckheere - 2004
#include "colors.inc"
#include "textures.inc"  
#include "woods.inc"   
#include "shapes.inc" 

#declare xsol=1;
#declare xtable=1;
#declare xassiette=1;
#declare xeau=1;
#declare xbouchon=1;
#declare xbouss=1;
#declare xaimant=1;
#declare xchair=1;    
#declare xgoutte=0; //not functionnal, keep at 0 !
 
#declare xphoton=0;
#declare rad=1; 

global_settings {   
  max_trace_level 64
  ambient_light 0.0
  #if(xphoton=1)
   photons {
   spacing .025
   autostop 0
   }
   #end

    #if(rad=1)
        radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35


      nearest_count 5
      error_bound .5
      recursion_limit 3


      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1


      adc_bailout 0.01/2
    }
        ambient_light 0
        #end
  }




 
#declare wbot =6;   
#declare stiff = 2;
#declare plate = array[102]


#declare icount=0;
 
#while (icount<102) 
        #if (icount<50)    
        #local xplate = 8*(icount-1)/50 ;
        #local yplate = tanh(stiff*(xplate-wbot)) + 1;
        #declare plate[icount] = <xplate,yplate> ;
        #declare icount= icount+1;
        #else
        #local xplate = 8*(100-icount)/50 ;
        #local yplate = tanh(stiff*(xplate-wbot)) + 1+0.1;
        #declare plate[icount] = <xplate,yplate> ;
        #declare icount= icount+1;
        #end                                  
#end


#declare icount=0;



camera{ location <4.,10,-15>*1.*1 look_at <4,-1,-1> up<0,1,0> right<70/48,0,0>
    focal_point < 0.2, 1.7, -2>   aperture 0.4 blur_samples 100 variance 1/10000 confidence 0.95}


light_source{<-20,200,-20> color  White*0.8 area_light <2,0,0>, <0,0,2>,2,2  jitter}

       
 
//table
#declare table = 
box {<-50,-1,-30> ,<30,-0.01,20>
        texture{ pigment {White}}
        texture{ pigment { function{x} pigment_map{ [0. White] [0.5 White] [0.5 OrangeRed transmit 0.5] [1.0 OrangeRed transmit 0.5] } } scale 3}
        texture{ pigment { function{z} pigment_map{ [0. White transmit 0.5] [0.5 White transmit 0.5] 
        [0.5 OrangeRed transmit 0.5] [1.0 OrangeRed transmit 0.5] } } scale 3 }
}

#if (xtable) 
object {table}
#end




 //sol
#if (xsol)
plane {<0,1,0>, -20  texture{pigment {brick Gray40 Gray95 brick_size 3 mortar 0.1 scale <2,3,2> rotate x*90 rotate y*6 }} }
#end
                                                                                     
                                                                                      
#declare assiette =
lathe { cubic_spline   102  ,
        #while (icount<102) 
                plate[icount] 
                #declare icount= icount+1;
        #end }
        //pigment{Gray95}
        //finish {phong 0.6 }}
                         
#declare icount=53;                            
#declare upper_assiette =
lathe { cubic_spline   49  ,
        #while (icount<102) 
                plate[icount] 
                #declare icount= icount+1;
        #end 
       pigment{Gray95 transmit 0.1}}
                                    
        



#declare eau =
 difference {
        box{ <-10,0,-10>,<10,1.5,10>}
        object {upper_assiette inverse }
        texture {
        pigment { color rgbf <0.94,0.94,0.99,0.95>}
        normal {
        ripples 0.25
        frequency 1
        }
         finish {
        reflection {0.3, 1 fresnel}
        //conserve_energy
         }
         }  
        interior {ior 1.33} 
        // */
       // pigment {Green transmit 0.75}
        }     
        

 
 #declare bouchaigui = 
 merge{
// le bouchon
difference{
cylinder { <0,-0.1,0>, <0,0.5,0> , 0.6  }
box{<-0.1,-0.2,-0.05>,<0.1,0.2,0.05> rotate z*35 rotate y*25 translate <0.62,0.55,0> rotate y*125}
  texture {Cork}  rotate x*4 }     //T_Wood31

// l'aiguille  
merge{
cylinder { <-0.5,0,0>, <0.5,0,0> , 0.02  
           scale <2,1,1>  }   
cone { <0,0,0> , 0.02   <0.3,0,0> , 0.0001   translate x*1 }  
torus { 0.04 , 0.02  scale <3,1,0.33>rotate x*-60  translate x*(-1-0.05) }
texture {Silver3}  
scale 1.5
translate y*0.4
}     
translate  y*1.2      
rotate y*+30
translate z*-2 translate x*0.2
}




#declare bouss =
union{
#if (xassiette)
object{assiette texture {pigment{ function{sqrt(x*x+z*z)/8}
                pigment_map {
                [0.0 Gray95]
                [0.8 Gray95]
                [0.8 PaleGreen]
                [0.85 PaleGreen]
                [0.85 radial color_map{[0.5 Black][0.5 White]} frequency 20 ]// Salmon]
                [0.87 radial color_map{[0.5 Black][0.5 White]} frequency 20 ]//Salmon]
                [0.87 PaleGreen]
                [1.0 PaleGreen] } } finish{ phong 1.0}  }
                texture {pigment{ color White transmit 1} finish{ reflection {0.15}} }
        finish { phong 1.0}
          }
#end                  
#if(xeau)
object{eau}
#end
#if(xbouchon) 
object{bouchaigui}
#end
}     

#if (xbouss=1)
object{bouss}
#end




#declare aimant = 
merge{
difference {
        cylinder {<0,0,0>, <0,0.3,0>,1 }
        cylinder {<0,-0.1,-0.2>, <0,0.5,-0.2>,0.6}
	//box{<-1,-1,-1>,<1,1,1> rotate y*-45 translate z*-1.5}       
	 plane{ <0,0,1>,-.45}
        }   
box{<-1.02,0.3,0>,<-0.7,0.,-0.3> rotate y*-25 translate <0.02,0,0.>}
box{<1.02,0.3,0>,<0.7,0.,-0.3> rotate y*25 translate <-0.02,0,0.>}


  texture{ pigment{ radial pigment_map{
	[0.0  Silver1_Colour][0.19  Silver1_Colour][0.19 Red][0.81 Red]
	[0.81 Silver1_Colour] [1.0  Silver1_Colour] }rotate y*90}
  finish {
        metallic
        ambient 0.0
        diffuse 0.35
        specular 0.85
        roughness 0.01
        reflection 0.15
        brilliance 1.
    }  normal{dents .00 scale 0.15 no_bump_scale}} 
        scale <1,1.5,1.5>*1.

    
  scale <1,1,1.4>
        
  
} 

#if(xaimant=1)
object{aimant rotate y*-175 translate <17,0.35,3.> }
#end


//cahier 
difference{
        box{<0,0,0>,<1,1,0.1> 
        texture { pigment { image_map{ gif "compass2.gif" } } }
         texture{ pigment{ function{ 1/(pow(cosh(cos(90*x)),10))}
                        color_map{
                               [0.0 White transmit 1]
                               [0.9 White transmit 1] 
                               [1.0 LightBlue transmit 0.5]
                               }
                       } } 
         texture{ pigment{ function{ 1/(pow(cosh(cos(90*(y+10))),10))}
                        color_map{
                               [0.0 White transmit 1]
                               [0.9 White transmit 1] 
                               [1.0 LightBlue transmit 0.5]
                               }
                       } }   
        normal {bumps 0.5 frequency 5}
        scale 6*<2.1,2.7,0.5>}
        #declare ntrou=32;
        #declare itrou=0;
        union{
                #while (itrou <(ntrou + 1))
                cylinder {6*<0.03,0.1+itrou*2.5/ntrou,-1>,6*<0.1,0.1+itrou*2.5/ntrou,1>, 6*5/210 pigment{White}}
                #declare itrou=itrou+1;
                #end    
        }
        rotate x*90 rotate y*(10)
        translate <6,0.35,-7> }
 // spirales du cahier
union{  
        #declare ntrou=32;
        #declare itrou=0;
        #while (itrou <(ntrou + 1)) 
        torus{0.35, 0.03 texture{ Silver1}     translate y*(0.008+0.1+itrou*2.5/ntrou)*6 translate x*0.005}
        torus{0.35, 0.03 texture{ Silver1}     translate y*(-0.008+0.1+itrou*2.5/ntrou)*6 translate x*0.005}
        #declare itrou=itrou+1;
        #end
        rotate x*90 rotate y*(10)
        translate <6,0.35,-7>
}




//goutte sur l'assiette 
#if(xgoutte=1)
difference{
sphere{0, 0.5  translate <-6.9,2.05,0>}
object{upper_assiette inverse }
 /* texture {
        pigment { color rgbf <0.94,0.94,0.99,0.95>}
        normal {
        ripples 0.35
        frequency 1
        }
         finish {
        reflection {0.3, 1 fresnel}
        conserve_energy
         }
         }  
        interior {ior 1.33}     */
        pigment{ Red*10 transmit 0}
}
#end


// mur  droite, avec fentre 

union{
difference{
box{ <0,-21,-200>,<0.5,2000,200>}
box{ <0,10,-8>,<0.6,35,8> translate x*-0.001}
}
// croisillons fenetre
union{
box{<0,10,-0.5>,<0.5,35,0.5>}
box{<0,22.,-8>,<0.5,23,8>} 
}
// plinthe
Round_Box(<-0.5,-21,-200>,<0.1,-17,200>,0.1,off)


 pigment {White*1.0} translate x*65 normal {bumps 0.1 scale 20}
}

//mur derriere
//plane{<0,0,1>,-35}


// sun through the hole

light_source {
        <65,30,0>*10, (White*0.3+Gold*0.7)*2.0
        parallel
        point_at <0,0,0>
} 


// chaise
#if (xchair=1)
#include "chair.inc"
object {K_Chair rotate y*100 scale 0.4 translate <10,-20,20> }
object {K_Chair rotate y*87 scale 0.4 translate <-15,-20,13> }   
#end