#include "metals.inc"

#macro Battery()
union {
   // The top.
   union {
      disc { y*0.99, y, 0.49 }
      cone { y*0.98, 0.18, y*1.05, 0.14 }
      texture { T_Chrome_5A }
      finish { reflection { metallic } phong 1 }
   }
   // The black/copper shell.
   difference {
      cylinder{ 0, y, 0.5 }
      cylinder{ y/9, 2*y, 0.45 }
      pigment {
	 gradient y
	 color_map { [0, Black][0.7 Black][0.7 Copper][1.0 Copper]}
	 scale 1.001
      }
      finish { reflection { metallic } phong 1 }
   }
   // The logo/letters
   intersection {
      cylinder{ 0, y, 0.505 }
      union {
         text { ttf "timrom.ttf" "POV-Ray" 9, 0
		translate <-5.3,0.25,-8.5>
		scale 1/8
	 }
         text { ttf "timrom.ttf" "Greatest Inventions" 9, 0
		translate <-9.2,-1.5,-13.5>
		scale 1/14
	 }
         text { ttf "timrom.ttf" "Marvin Taylor, 4/2004" 9, 0
		translate <-15.8,-5.3,-13.5>
		scale 1/24
	 }
	 rotate <0,0,-90>
      }
      pigment {Silver}
      finish { reflection { metallic } phong 1 }
   }
   scale <1,2,1>
}
#end