#include "colors.inc"

#macro Blotter(dx, dz)
 union {
    // We export the height of the paper.  Corners are x 2.5 tall.
    #declare BlotterHeight = 0.16;
			 // Thickness of the base & paper (each)
    #local bth = BlotterHeight/2;
    #local ith = 0.0001; // Thickness of the ink (normal to paper)
    #local iwd = 0.015;	 // Width of the ink (parallel to paper)
    #local cnr = 0.78;	 // Portion of DX,DZ that the corners are.

    // The paper
    box { <-(dx/2-bth),bth,-(dz/2-bth)>, <(dx/2-bth),bth*2,(dz/2-bth)>
          pigment { Gray90 } }

    union {
       // The underliner && sides:
       box { <-(dx/2),0,-(dz/2)>,<(dx/2),bth*1.5,(dz/2)> }

       // The corners:
       #local i = -1; #while (i<2)
          #local j = -1; #while (j<2)
	  prism {
	     0, bth*3, 4
	     <dx/2*i,dz/2*j>,
	     <dx/2*i*cnr,dz/2*j>,
	     <dx/2*i,dz/2*j*cnr>,
	     <dx/2*i,dz/2*j>
	  }
          #local j = j + 2; #end
       #local i = i + 2; #end
       pigment { rgb<0.416,0.32,0.29> } // Maybe: Bronze2
       //finish {phong 0.6 }
    }
#if (1)
    // The ink...
    union {
       // The grid lines first:
       #local i = -7; #while (i<8)
          #if (abs(i)>6) #local m=6; #else #local m=4; #end
	  box { <dx/16*i-iwd,0,-dz*6/16-iwd>,
		<dx/16*i+iwd,ith,dz*m/16+iwd> }
       #local i = i + 2; #end
       #local j = -6; #while (j<7)
	  box { <-dx*7/16-iwd,0,dz*j/16-iwd>,
		< dx*7/16+iwd,ith,dz*j/16+iwd> }
       #local j = j + 2; #end

       #local month = "April                 2004";
       #local xx    = -dx*1.8/8;
       #local zz    = dz*2.2/8;
       text { ttf "timrom.ttf" month ith*4, 0
	      rotate 90*x scale dx/18
	      translate <xx,ith,zz>
       }

       // The dates on the calendar...
       #local first_dow = 5;
       #local days_in_month = 30;
       #local day_to_circle = 30;
       #local day = 1; #while (day <= days_in_month)
          #local dow  = mod((day+8-first_dow),7);
          #local week = int((day+mod((8-first_dow),7))/7);
	  #local xx   = dx*(dow-3.4)/8;
	  #local zz   = -dz*(week-1.6)/8;

	  #if (day_to_circle=day)
	     #local circ_xx = xx+dx/25;
	     #local circ_zz = zz-dz/40;
	  #end

          text { ttf "timrom.ttf" str(day,1,0) ith*4, 0
		 rotate 90*x scale dx/40
		 translate <xx,ith,zz>
	  }
       #local day = day+1; #end

       translate y*bth*2
       pigment {Gray20}
    }
    #if (day_to_circle>0)
    union {
       intersection {
	  torus { dx/20, iwd }
	  box { <-dx,-ith,-dz>, <dx,ith,dz> }
	  scale <1.3,1,1.0>
       }
       text { ttf "cyrvetic.ttf" "IRTC" ith*4, 0
	      rotate 90*x scale dx/40
	      translate <-dx/40,ith,-dz/90>
       }
       text { ttf "cyrvetic.ttf" "Deadline" ith*4, 0
	      rotate 90*x scale dx/48
	      translate <-dx/28,ith,-dz/30>
       }
       translate <circ_xx,bth*2,circ_zz>
       pigment {Red}
    }
    #debug concat( "CIRC=<",str(circ_xx,6,4),",0,",str(circ_zz,6,4),">\n")
    #end
#end
}
#end