#include "centeredtext.inc"

#macro Book( word1, word2, word3, word4 )
union {
   #local tcover  = 0.15;	// Thickness
   #local dcover  = 0.35;	// indent for pages.
   #local wbook	  = 6;		// Width
   #local hbook	  = 10;		// Height
   #local tbook	  = 3;		// Thickness

   // pages...
   #local R1 = seed(5000);
   box { <dcover-hbook,tcover,dcover-wbook>,
	 <hbook-dcover,tbook-tcover,wbook-dcover>
	 pigment {gradient y color_map {
	   #local dd=0.05;#local ii=0; #while(ii<1)
	      #local c = 0.6+0.4*rand(R1);
	      [ii rgb<c,c,c>] [ii+dd rgb<c,c,c>]
           #local ii=ii+dd; #end }
         }
   }

   // The cover...
   union {
      box { <-hbook,0,-wbook>, <hbook,tcover,wbook> }	  // Back
      box { <-hbook,tbook-tcover,-wbook>, <hbook,tbook,wbook> }// Front
      // This should be a bit more complex ... maybe later.
      box { <-hbook,0,-wbook>, <hbook,tbook,-(wbook+tcover)> } // binding
      pigment { Gray20 }
      normal { bumps 0.15 scale 0.2 }
      finish { phong 0.2 }
   }

   // The front cover title...
   union {
      union {
	 object { CenteredText( "timrom.ttf" word1 tcover )
		  translate <hbook/2.8,+0.5> }
	 object { CenteredText( "timrom.ttf" word2 tcover )
		  translate <hbook/2.8,-0.6> }
	 object { CenteredText( "timrom.ttf" word3 tcover )
		  translate <hbook/2.8,-1.7> }
	 object { CenteredText( "timrom.ttf" word4 tcover )
		  translate <hbook/2.8,-2.8> }
	 rotate <90,-90>
	 scale <1.5,1,1.5>
	 translate <-hbook*0.6,tbook+0.01,-wbook*.8>
      }
      #local words = concat(word1," ",word2," ",word3," ",word4);
      object {
         CenteredText( "timrom.ttf",  words tcover/2 )
	 pigment { rgb<.8,.8,.3> }
	 scale <0.7,1,0.7>
	 translate <-hbook/5,tbook/2,-(wbook+tcover*1.1)>
      }
      pigment { rgb<.8,.8,.3> }
      finish { reflection { metallic 0.8 } phong 1 }
   }
   scale 0.15
}

#end