#include "match.inc"

// A candle in a holder
#macro Candle()
union {
   // ...holder 
   union {  
      cylinder { 0, y/100, 1 }
      torus { 1, 0.1 translate y/10 }
      torus { 0.25, 0.08 rotate 90*x translate <1.14,0.34> }
      cone  { 0, 0.20, y/3, 0.25 open }
      texture { T_Copper_3D }
   }
   cone {
      0, 0.20, y/3, 0.25 open
      texture { T_Copper_1A }
   }
   // candle:
   difference {
      union {
         cylinder { 0, <0,2.499>, 0.2001 hollow
            pigment {rgb<1,0,0>} finish {phong 0.8}}
         cylinder { 0, <0,2.5>, 0.20
            pigment {rgbt<0.8,0.8,0.8,0.25>}}
      }
      sphere { <.05,2.6,.08>, .2
         pigment {rgbt<0.8,0.8,0.8,0.25>}}
   }
   // wick:
   cylinder { <0,2.4>, <.05,2.66,.02> .005 pigment { Gray30 }}

   // a dead match...
   object { Match(1) rotate -2*z
      scale 0.8
      translate <-0.4,0.25,-0.45>
      rotate y*40
   }
   // and a live match...
   object { Match(0) rotate -8*z
      scale 0.8 translate <-0.6,0.2,-0.3> }

   // A fire !?!?!
}
#end
