#include "glass.inc"
#include "colors.inc"
#include "centeredtext.inc"

//
// A wall clock on the Y-Z "wall" at the origin:
//  Diameter=12 Depth=4.5
// Usage:
//   Clock( bt, gt, ft, ht, st, nt, hh, mm, ss, logo )
//    bt   = texture for the body,
//    gt   = non-zero to add a glass face,
//    ft   = texture for the face,
//    ht   = texture for the hour & minute hands,
//    st   = texture for the second hand,
//    nt   = texture for the number & logo,
//    hh   = the hour of time [1..12]
//    mm   = the hour of time [0..59]
//    ss   = the hour of time [0..59]
//    logo = "logo" text on the clock.
//
#macro ClockHand(wdth,leng,ang,dx)
   #local aa = <-wdth/2,-wdth*2>;
   #local bb = <wdth/2,-wdth*2>;
   #local cc = <0,leng>;
   #debug concat("triangle{ ",Q(aa),","Q(bb),","Q(cc)," }\n" )
   triangle { aa,bb,cc rotate 90*y rotate x*ang translate x*dx }
#end

#macro Clock( bt, gt, ft, ht, st, nt, hh, mm, ss, logo )

union {
   // The outer body:
   union {
      cylinder { <0,0,0>, <2.5,0,0>, 6.0 open }
      torus { 5.75, 0.25 rotate 90*z translate x*2.5 }
      cylinder { <0,0,0>, <2.5,0,0>, 5.5 open }
      texture{bt}
   }
   // The glass cover:
   #if (gt != 0)
   cylinder { <2.45,0,0>, <2.55,0,0>, 5.6
      material { texture { pigment { color Clear }
			   finish { F_Glass7 } }
      interior { I_Glass_Dispersion1 fade_color Col_Blue_04 }}
   }
   #end
   // The face:
   disc { <1.5,0,0>, x, 5.6 texture{ ft }}

   object {
      CenteredText( "timrom.ttf", "Taylor", 0.3 )
      scale 1/2
      rotate -90*y
      translate <1.51,1,0>
      texture{ nt }
   }

   // The numbers:
   union {
#if (1)
      #local TEXT = array[12] {
	     "1", "2", "3", "4", "5", "6", "7",
	     "8", "9", "10", "11", "12" };
#else
      #local TEXT = array[12] {
	     "I", "II", "III", "IV", "V", "VI", "VII",
	     "VIII", "IX", "X", "XI", "XII" };
#end
      #local i=0; #while(i<12) #local i=i+1;
         object {
	    CenteredText( "timrom.ttf", TEXT[i-1], 0.1 )
	    translate <sin(i*pi/6),cos(i*pi/6),0>*4
	 }
      #end
      texture{ nt }
      rotate -90*y
      translate x*1.51
   }   
   // The tick marks...
   union {
      #local i=0; #while(i<60)
      cylinder { 
         #if (mod(i,5)=0)
	    <0,3.1,0>, <0,3.45,0>, 0.03
         #else
	    <0,3.3,0>, <0,3.45,0>, 0.02
         #end
	    rotate x*i*6
      }
      #local i=i+1; #end
      texture{nt}
      translate x*1.5
   }

   // The hands...
   union {
      #if (ss>=0)
      object { ClockHand(0.2,4.8,6*ss,1/20) texture{st} }
      #end
      object { ClockHand(0.33,4.8,6*mm,1/25) texture{ht} }
      object { ClockHand(0.33,3.0,hh*30+mm/2,1/30) texture{ht} }
      translate x*1.65
   }      
   // The hands' shaft:
   cylinder { <0,0,0>, <1.8,0,0> 0.1 texture{ht} }
      
}
#end