//
// Create a desktop (top at Y=0) that _XSIZE x _ZSIZE on the suraface.
// It is composed of boards running across the desk (parallel to the X
// axis).  The board width is _BW and the board length is _BL +/- 50%.
//
#macro Desktop( _width, _depth, _bw, _bl )
union {
   #local _xx = _width/2;
   #local _zz = _depth/2;
   #local _rdsk = seed(1523);
   #local _x = -_xx; #while (_x<_xx) 
      #local _z = -_zz; #while (_z<_zz)

         #local _cc = 1-pow((rand(_rdsk)/2-0.3333),3);
	 #local _z2 = _z+_bl*(0.5+rand(_rdsk)); 
	 #if (_z2>_zz) #local _z2=_zz; #end
	 box { <0,-1,0>, <_bw,-0.1,_z2-_z>
	   texture {
	      pigment {
		 wood turbulence 0.02 octaves 4 lambda 3
		 scale 0.175 rotate <2, 2, 0> color_map { 
		 [0.0, 0.5 color rgb <1.00, 0.85, 0.50>*_cc
			   color rgb <0.90, 0.70, 0.46>*_cc]
		 [0.5, 0.7 color rgb <0.90, 0.70, 0.46>*_cc
			   color rgb <0.90, 0.70, 0.46>*_cc]
		 [0.7, 1.0 color rgb <0.90, 0.70, 0.46>*_cc
			   color rgb <1.00, 0.85, 0.50>*_cc] }
	      }
	      scale 4*rand(_rdsk)
	   }
	   texture {
	      pigment {
		 wood turbulence 0.02 octaves 4 lambda 2.8
		 scale 0.2 rotate <2, 2, 0>
		 translate <0.0175, 0.0175, 0.0175> color_map { 
		 [0.0, 0.5 color rgbt <1.00, 0.45, 0.10, 0.80>*_cc
			   color rgbt <0.85, 0.65, 0.40, 0.40>*_cc]
		 [0.5, 0.7 color rgbt <0.85, 0.65, 0.40, 0.40>*_cc
			   color rgbt <0.85, 0.65, 0.40, 0.40>*_cc]
		 [0.7, 1.0 color rgbt <0.85, 0.65, 0.40, 0.40>*_cc
			   color rgbt <1.00, 0.45, 0.10, 0.80>*_cc] }
	      }
	      scale 4*rand(_rdsk)
	   }
	   translate <_x,0,_z>
	 }
      #if (_z2 = _zz) #break #end #local _z = _z2;  #end
   #local _x = _x+_bw; #end
   normal { bumps 0.1 scale 1/20 }
   finish { Dull ambient 0.5 reflection 0 }
}
#end
