#include "shapes.inc"

#macro KeyCap(txt1,txt2,kpig,tpig,xx,yy,xs)
#local dy = 0.15;
#local y0 = 1.0;
#local y1 = y0+dy;
#local ys = 6.0;
#local aa = 1.25;
#local dd = 0.15;
merge {
   // Grrr. Wide keys (esp the space bar) CANNOT be made realistic
   // this way -- the left/right sides slope too much.  Oh well.
   prism {
      linear_spline
      conic_sweep
      y0, y1 9,
      <(xs*aa),aa-dd>,
      <(xs*aa)-dd,aa>,
      <dd-(xs*aa),aa>,
      <-(xs*aa),aa-dd>,
      <-(xs*aa),dd-aa>,
      <dd-(xs*aa),-aa>,
      <(xs*aa)-dd,-aa>,
      <(xs*aa),dd-aa>,
      <(xs*aa),aa-dd>
      rotate 180*z
      translate y1*y
      scale <1,ys,1>
      pigment {kpig}
      finish { phong 1 }
   }
   #local _txt1 = text {
	   ttf "timrom.ttf" txt1 dy*ys/100, 0
	   rotate <-90,180,180>
	   pigment{tpig}
	   translate y*dy*ys*1.01
	};
   object { _txt1
      // Center on the origin in the X-Z plane:
      translate -(min_extent(_txt1)+max_extent(_txt1))/2*<1,0,1>
      #if (!strcmp(txt2,""))
         // Then shift a bit:
         translate <-0.45,0,0.25>
	 scale <1.25,1,1.25>
      #else #if (!strcmp(txt2,"~"))
         // Then shift only horizontally...
         translate <-0.45,0,0>
      #else
         // Then shift a LOT...
         translate <-0.45,0,0.50>
      #end #end
   }
   // "~" is used to indicate a single line, in smaller font
   #if (strcmp(txt2,"") & strcmp(txt2,"~") & strcmp(txt2," "))
   #local _txt2 = text {
	   ttf "timrom.ttf" txt2 dy*ys/100, 0
	   rotate <-90,180,180>
	   pigment{tpig}
	   translate y*dy*ys*1.01
	};
   object { _txt2
      // Center on the origin in the X-Z plane:
      translate -(min_extent(_txt2)+max_extent(_txt2))/2*<1,0,1>
      translate <-0.45,0,-0.45>
   }
   #end
   scale 0.65
   translate <xx+xs-1,0,zz>
   #declare xx = xx+2*xs;
   #debug concat( "\nKeyCap('",txt1,"','",txt2,"') @ ")
   #debug concat( "<",str(xx+xs-1,6,4),",0,",str(zz,6,4),">")
}
#end

#macro KeyBoard(lpig, dpig, tpig, mySize)
union {
   #local xx = -11;
   #local zz = +6.8;
   KeyCap("Esc","~",dpig,tpig,xx,zz,1)
   #local xx = xx+0.5;
   KeyCap("F1","~",lpig,tpig,xx,zz,1.125)
   KeyCap("F2","~",lpig,tpig,xx,zz,1.125)
   KeyCap("F3","~",lpig,tpig,xx,zz,1.125)
   KeyCap("F4","~",lpig,tpig,xx,zz,1.125)
   #local xx = xx+0.5;
   KeyCap("F5","~",dpig,tpig,xx,zz,1.125)
   KeyCap("F6","~",dpig,tpig,xx,zz,1.125)
   KeyCap("F7","~",dpig,tpig,xx,zz,1.125)
   KeyCap("F8","~",dpig,tpig,xx,zz,1.125)
   #local xx = xx+0.5;
   KeyCap("F9","~",lpig,tpig,xx,zz,1.125)
   KeyCap("F10","~",lpig,tpig,xx,zz,1.125)
   KeyCap("F11","~",lpig,tpig,xx,zz,1.125)
   KeyCap("F12","~",lpig,tpig,xx,zz,1.125)

   #local xx = xx+0.5;
   KeyCap("Prnt","~",dpig,tpig,xx,zz,1)
   KeyCap("Scrl","Lock",dpig,tpig,xx,zz,1)
   KeyCap("Pse","Brk",dpig,tpig,xx,zz,1)

   #local xx = -11;
   #local zz = +4;
   KeyCap("~","`",lpig,tpig,xx,zz,1)
   KeyCap("!","1",lpig,tpig,xx,zz,1)
   KeyCap("@","2",lpig,tpig,xx,zz,1)
   KeyCap("#","3",lpig,tpig,xx,zz,1)
   KeyCap("$","4",lpig,tpig,xx,zz,1)
   KeyCap("%","5",lpig,tpig,xx,zz,1)
   KeyCap("^","6",lpig,tpig,xx,zz,1)
   KeyCap("&","7",lpig,tpig,xx,zz,1)
   KeyCap("*","8",lpig,tpig,xx,zz,1)
   KeyCap("(","9",lpig,tpig,xx,zz,1)
   KeyCap(")","0",lpig,tpig,xx,zz,1)
   KeyCap("_","-",lpig,tpig,xx,zz,1)
   KeyCap("+","=",lpig,tpig,xx,zz,1)
   KeyCap("Backspace","<---",dpig,tpig,xx,zz,2.25)

   #local xx = xx+0.5;
   KeyCap("Ins","~",dpig,tpig,xx,zz,1)
   KeyCap("Home","~",dpig,tpig,xx,zz,1)
   KeyCap("Page"," Up",dpig,tpig,xx,zz,1)

   #local xx = -11;
   #local zz = +2;
   KeyCap("TAB","--->|",dpig,tpig,xx,zz,1.5)
   KeyCap("Q","",lpig,tpig,xx,zz,1)
   KeyCap("W","",lpig,tpig,xx,zz,1)
   KeyCap("E","",lpig,tpig,xx,zz,1)
   KeyCap("R","",lpig,tpig,xx,zz,1)
   KeyCap("T","",lpig,tpig,xx,zz,1)
   KeyCap("Y","",lpig,tpig,xx,zz,1)
   KeyCap("U","",lpig,tpig,xx,zz,1)
   KeyCap("I","",lpig,tpig,xx,zz,1)
   KeyCap("O","",lpig,tpig,xx,zz,1)
   KeyCap("P","",lpig,tpig,xx,zz,1)
   KeyCap("{","[",lpig,tpig,xx,zz,1)
   KeyCap("}","]",lpig,tpig,xx,zz,1)
   KeyCap("|","\\",lpig,tpig,xx,zz,1.75)

   #local xx = xx+0.5;
   KeyCap("Del","~",dpig,tpig,xx,zz,1)
   KeyCap("End","~",dpig,tpig,xx,zz,1)
   KeyCap("Page","Down",dpig,tpig,xx,zz,1)

   #local xx = -11;
   #local zz = 0;
   KeyCap("Caps","Lock",dpig,tpig,xx,zz,1.75)
   KeyCap("A","",lpig,tpig,xx,zz,1)
   KeyCap("S","",lpig,tpig,xx,zz,1)
   KeyCap("D","",lpig,tpig,xx,zz,1)
   KeyCap("F","",lpig,tpig,xx,zz,1)
   KeyCap("G","",lpig,tpig,xx,zz,1)
   KeyCap("H","",lpig,tpig,xx,zz,1)
   KeyCap("J","",lpig,tpig,xx,zz,1)
   KeyCap("K","",lpig,tpig,xx,zz,1)
   KeyCap("L","",lpig,tpig,xx,zz,1)
   KeyCap(":",";",lpig,tpig,xx,zz,1)
   KeyCap("\"","'",lpig,tpig,xx,zz,1)
   KeyCap("Enter","<--",dpig,tpig,xx,zz,2.5)

   #local xx = -11;
   #local zz = -2;
   KeyCap("Shift"," ",dpig,tpig,xx,zz,2.625)
   KeyCap("Z","",lpig,tpig,xx,zz,1)
   KeyCap("X","",lpig,tpig,xx,zz,1)
   KeyCap("C","",lpig,tpig,xx,zz,1)
   KeyCap("V","",lpig,tpig,xx,zz,1)
   KeyCap("B","",lpig,tpig,xx,zz,1)
   KeyCap("N","",lpig,tpig,xx,zz,1)
   KeyCap("M","",lpig,tpig,xx,zz,1)
   KeyCap("<",",",lpig,tpig,xx,zz,1)
   KeyCap(">",".",lpig,tpig,xx,zz,1)
   KeyCap("?","/",lpig,tpig,xx,zz,1)
   KeyCap("Shift"," ",dpig,tpig,xx,zz,2.625)

   #local xx = xx+2.5;
   KeyCap("^","|",dpig,tpig,xx,zz,1)

   #local xx = -11;
   #local zz = -4;
   KeyCap("Ctrl"," ",dpig,tpig,xx,zz,1.125)
   KeyCap("POV","Ray",dpig,tpig,xx,zz,1.25)
   KeyCap("Alt"," ",dpig,tpig,xx,zz,1.125)
   KeyCap(" ","",lpig,tpig,xx,zz,6.625)
   KeyCap("Alt","",dpig,tpig,xx,zz,1.125)
   KeyCap("POV" "Ray",dpig,tpig,xx,zz,1.5)
   KeyCap("Menu"," ",dpig,tpig,xx,zz,1.25)
   KeyCap("Ctrl"," ",dpig,tpig,xx,zz,1.125)

   #local xx = xx+0.5;
   KeyCap("<--","~",dpig,tpig,xx,zz,1)
   KeyCap("|","v",dpig,tpig,xx,zz,1)
   KeyCap("-->","~",dpig,tpig,xx,zz,1)

   // The "board" itself...
   #local SW = <-14,-1,-7>;
   #local NE = <26.5,0.25,+10.5>;
   difference {
     object {
	    Round_Box( SW, NE, 0.5, yes )
		pigment{lpig}
	 }
     union {
        box { <-12,-.35,-5>, <18.5,1,5>	}		// Qwerty, etc.
        box { <-12,-.35,5.8>, <-10,1,7.8> }		// Esc
        box { <-9.5,-.35,5.8>, <-0.5,1,7.8> }	// F1-F4
        box { <0,-.35,5.8>, <9,1,7.8> }			// F5-F9
        box { <9.5,-.35,5.8>, <18.5,1,7.8> }	// F5-F9
        box { <19,-.35,5.8>, <25,1,7.8> }		// Print-Pause
        box { <19,-.35,1>, <25,1,5> }			// Ins-PgDn
        box { <21,-.35,-3>, <23,1,-1> }			// 1x arrow
        box { <19,-.35,-5>, <25,1,-3> }			// 3x arrows
	pigment { Gray20 }
     }
   }
   translate <-(SW.x+NE.x)/2,-SW.y,-(SW.z+NE.z)/2>
}
#declare mySize = NE-SW;
#end
