//
// A magnifying glass
//
#ifndef(Glass_Inc_Temp)
   #include "glass.inc"
#end

//
// A magnifying glass, with the glass in the Y=0 plane, centered at 0
// with a handle in the -X direction.
//   MRAD = radius of the glass + metal circle,
//   GTHK = thickness of the glass at the center,
//   
//
#macro MagnifyingGlass( mrad, gthk, hlen, hrad, htxt )
   #local thk  = gthk/3;
   #local bnd  = 0.01;
   #local mtl  = T_Chrome_4C;
   #local scrw = 0.15;
   #local grad = mrad-bnd;
   #local R1   = (grad*grad/thk+thk)/2; // Radius of surface curvature
   #local dbg  = 0;
   union {
      #debug "Intersection {\n"
      intersection {
         sphere { <0,thk-R1,0>, R1 }
         sphere { <0,R1-thk,0>, R1 }
	 cylinder { <0,-thk,0>, <0,thk,0>, grad }
	 #if (dbg)
	 pigment{Cyan}
	 #else
         material { texture { pigment { color Clear } finish { F_Glass7 } }
	    interior { I_Glass_Dispersion1 fade_color Col_Blue_04 } }
	 #end
      }
      difference {
        cylinder { <0,-gthk/2,0>, <0,gthk/2,0>, mrad }
        cylinder { <0,-gthk,0>, <0,gthk,0>, grad }
	 #if (dbg)
	 pigment{Blue}
	 #else
	 texture { mtl }
	 #end
      }
      cylinder { -x*(grad), -x*(grad+scrw), hrad texture { mtl }}
      cylinder { -x*(grad+scrw), -x*(hlen+grad), hrad texture { htxt }}
   }
#end

