// +A0.333 +Q10 +W1280 +H1024

#include "colors.inc"
#include "metals.inc"
#include "woods.inc"
#include "finish.inc"

#macro Q(vv) concat("<",vstr(3,vv,",",4,3),">") #end
#macro I(ii) str(i,1,0) #end
#macro F(ff) str(ff,4,3) #end

#declare Show_Candle	= 1;
#declare Show_Book	= 1;
#declare Show_Mag	= +1;	// -1 for no photons
#declare Show_Batt	= 1;
#declare Show_Desk	= 1;
#declare Show_Blotter	= 1;	// Show the blotter?
#declare Show_Pencils	= 1;
#declare Show_PostIt	= 1;
#declare Show_Keyboard	= 1;
#declare Show_Clock	= 1;
#declare Show_Phone	= 1;
#declare Show_Walls	= 1;
#declare Focal_Blur	= 1;
			 
// If we drop the resolution, simplify the image, too:
#if (image_width < 1000)
  #if (Show_Mag = 1) #declare Show_Mag = -1; #end
#end

#declare Show_Ink	= 0;	// -1 for simple feather
#declare Show_Grid	= 0;

global_settings {
   photons {
     count 20000
     autostop 0
     jitter .4
   }
}

#if (Show_Mag>0)
 #macro LSPhotons()
    photons { refraction on reflection on }
 #end
 #macro ObjPhotons()
    photons { target refraction on reflection on collect off }
 #end
#else
 #macro LSPhotons() #end
 #macro ObjPhotons() #end
#end

light_source {<-10,30,-20> rgb 0.5 LSPhotons() shadowless}
light_source {<-80,50,  0> rgb 1.0 LSPhotons() }
light_source {<-30,80,  0> rgb 0.5 LSPhotons() shadowless}
light_source {<+10,40,-10> rgb 0.5 LSPhotons() }
//light_source {<-20,40,-20> rgb 0.7 LSPhotons() }

#local WallZ = 20.5;
#local WallX = 12.5;


#if (Show_Desk)
   #include "desk.inc"
   Desktop( 2*WallX-1, 2*WallZ-1, 4, 12 )
#end

#if (Show_Walls)
// The walls
union {
   plane { x, WallX }
   plane { z, WallZ }
   plane { z, -WallZ }
   texture {
      pigment {rgb <0.95,0.95,0.98> } 
      normal { bumps 1/10 scale 1/10 }
      finish { ambient 0.20 } 
   }
}
#end

#if (Show_Grid)
union {
   #local _pig = array [3] { pigment{Red}, pigment{Blue}, pigment{Black}};
   #local _axe = array [9] { x, y, z, y, z, x, z, x, y };
   #local i = -1; #while (i<2) #local i=i+1;
      #local j = -35; #while (j<30) #local j=j+5;
         #local k = 0; #while (k<6) #local k=k+3;
	    #local cc = j*_axe[k];
	    #local pp = _axe[i]*100;
	    #debug concat("At: ",Q(cc-pp),",",Q(cc+pp),"\n")
	    cylinder { cc-pp, cc+pp,
		    #if (j=0) 0.333 #else 0.05 #end
		    pigment {_pig[mod(i+k/3,3)]} }
	 #end
      #end
   #end
   scale 0.2 }
#end

#if (Show_Blotter)
   #include "blotter.inc"
   object { Blotter( 14, 11 ) rotate 90*y }
#else
   #declare BlotterHeight = 0.0;
#end

// A candle with a match...
#if (Show_Candle)
   #include "match.inc"
   #include "candle.inc"      
   #declare CandleBase = <3.75,BlotterHeight,-1.0>;
   object { Candle()
      rotate 60*y
      translate CandleBase
   }
#else
   #declare CandleBase = 0;
#end /* Show_Candle */

#if (Show_Ink)
   #include "inkjar.inc"
   object {
      #if (Show_Ink>0) InkJar(1) #else InkJar(0) #end
      rotate y*180
      scale 3/4
      translate <3.9,BlotterHeight,5.1>
   }
#end
#if (Show_Pencils)
   #include "pencils.inc"
   object {
      PencilJar()
      rotate y*25
      scale 3/4
      //translate <3.9,BlotterHeight,5.1>
      translate <10.2,0,7.2>
   }
#end

#if (Show_Book)
   #include "book.inc"
   #declare BookTrans = <-2.5,BlotterHeight,+4>;
   object {
      Book("Philosophia", "Naturalis", "Principia", "Mathematica")
      scale 1.5
      rotate 60*y
      translate BookTrans
   }
#else
   #declare BookTrans = 0;
#end


#if (Show_Batt)
   #include "battery.inc"
   object {
      Battery()
      rotate y*45
      translate BookTrans+<0.5,0.75,-0.5>
   }
#end

#if (Show_PostIt)
   #include "post-it.inc"
   object {
      PostIt( rgb<1,1,0.5>, 1.5 )
      scale 1/3
      rotate 22*y
      translate <10.2,0,5.2>
   }
#end

#if (Show_Keyboard)
   #include "keyboard.inc"
   #include "finish.inc"
   #local pig1 = pigment{Gray90};
   #local pig2 = pigment{Gray50};
   object {
      #local kbsz = <0,0,0>;
      KeyBoard( pig1, pig2, pigment{Black}, kbsz )
      translate z*kbsz.z/2
      rotate <-10,30,0>
      scale 1/3
      translate <+1,0,WallZ-kbsz.z*0.6>
   }      
   // A monitor on the wall...
   union {
      #local screenOff = <0,3,WallZ-4>;
      difference {
	 object {
	    Round_Box( <-kbsz.x/8,0,-0.5>,
		    <kbsz.x/8,kbsz.x/6,-1.5>, 0.25, yes )
	    translate screenOff
	    pigment{Gray50}
	    normal { bumps 1/10 scale 1/20 }
	 }
	 box { <-kbsz.x/9,0.5,-1.45>,
	       <kbsz.x/9,kbsz.x/6-0.5,-5>
	    translate screenOff
	    pigment{Gray10} finish {reflection 0.1}
         }
      }
      union {
         cylinder { <0,1,0>, <0,kbsz.x/8>, 0.6 }
	 cone { <0,0,0>, 4, <0,3,0>, 1 scale <1,1,1/4> }
	 translate <0,0,WallZ-1.4>
	 pigment{Gray50}
      }
      rotate y*15
   }
#end

#if (Show_Clock)
   #include "clock.inc"
   object {
      Clock( pigment{Blue}, 1, pigment{White}, pigment{Black},
	     pigment{Red}, pigment{rgb<.3,.3,1>},
	     8, 13, 22, "M. Taylor" )
      rotate y*180
      scale 1/2
      translate <WallX+0.5,7,0>
   }
#end


#if (Show_Phone)
   #include "phone.inc"
   #local sz = 0;
   object {
      Phone( sz )
      rotate y*90
      #local _psc = <4.5/sz.x,2.5/sz.y,6/sz.z>;
      scale _psc
      translate <WallX-3.25,0,-3>
   }
   #debug concat("Phone Size: ",Q(sz),"\tPhone Scale: ",Q(_psc),"\tResult: ",Q(_psc*sz),"\n")

#end


#if (Show_Mag)
   #include "maglass.inc"
   #include "stones.inc"
   object {
      MagnifyingGlass( 1, 0.50, 1.425, 0.2,
	 texture { T_Grnt25 rotate <60,80,80> scale 1/5 } )
      ObjPhotons()
      //rotate <90,0,35> rotate <0,-120,0> translate <-1.8,1.5,1.5>
      //rotate <90,0,20> rotate <0,+20,0> translate <-0.15,1,-2.52>
      rotate <90,0,20> rotate <0,+20,0> translate <-0.1,1,-2.4>
      translate y*BlotterHeight
      rotate y*30
   }
#end

#declare aspect = (image_width/image_height);
camera {
//location  BookTrans+<-3,4,-2> look_at BookTrans+<1,1.5,0>

// location <-16.5,10,-9.8> look_at 0 // Good for widescreen
// location <-16.5,10,-19.8> look_at 0 // Good for widescreen
location <-20,22,0.1-WallZ> look_at <2,3,1> // Good for 4x3

   up   y/sqrt(aspect)  right x*sqrt(aspect)
  angle 35
  #if (Focal_Blur)
     aperture 0.25 focal_point 0 blur_samples 20
     //aperture 0.4 focal_point <0,2,0> blur_samples 10
  #end
}
// focal_point <-6, 1, 30>    // blue cylinder in focus
// focal_point < 0, 1,  0>    // green box in focus
// aperture 0.4     // a nice compromise
// aperture 1.5     // much blurring
// blur_samples 4       // fewer samples, faster to render
