#include "glass.inc"
#include "colors.inc"

#macro Pencil(txt)
   union {
      cone { 0*y, 0, 0.15*y, 0.03 pigment{Gray10}}
      cone { 0.15*y, 0.03, 0.5*y, 0.1 texture{T_Wood7} }
      cylinder{ 0.5*y, 5.5*y, 0.1 texture{txt}}
      cylinder{ 5.5*y, 5.85*y, 0.11 pigment{Silver}}
      cylinder{ 5.85*y, 6*y, 0.1 pigment{Pink}}
   }
#end

#macro PencilJar()
union {
   // The jar...
   #local diam = 1.05;
   difference {
      cylinder { y/100, y*5 diam }
      cylinder { y/2, y*6 diam-0.15 }
      material { texture { pigment { color Clear } finish { F_Glass7 } }
			  interior { I_Glass_Dispersion1 fade_color Col_Blue_04 } }
   }

   object{ Pencil(pigment{Red})    rotate <21,0> translate <0.18,0.4,0.1-diam> }
   object{ Pencil(pigment{Green})  rotate <21,0> translate <0.18,0.5,0.2-diam> rotate 90*y}
   object{ Pencil(pigment{Blue})   rotate <21,0> translate <0.18,0.4,0.1-diam> rotate 180*y}
   object{ Pencil(pigment{Yellow}) rotate <21,0> translate <0.18,0.5,0.2-diam> rotate 270*y}
}


#end

