#include "colors.inc"
#include "shapes.inc"
#include "keyboard.inc"

//
// A collapsible antenna, staring at PT (with radius R0), extending by
// DL.  Each of the rest of the NN pieces move by DL*Q and are DR
// smaller in radius.  If nonzero, the vector DB requests that a
// segment, also of radius R0 exist and have a sphere at PT.
//
#macro Phone_Antenna(_pt,_r0,_dl,_nn,_q,_dr,_db)
   union {
      #local pt  = _pt;
      #local rad = _r0;

      #if (vlength(_db)>0)
         cylinder{ pt, pt+_db, rad }
	 sphere{ pt, rad*1.25 }
      #end

      #local ii=0;#while (ii<_nn)
         cylinder{ pt, pt+_dl, rad }
	 #local pt  = pt+_dl*_q;
	 #local rad = rad-_dr;
      #local ii=ii+1; #end
      cylinder{ pt+_dl*(1-_q), pt+_dl*(1-_q)+vnormalize(_dl)*rad, _r0 }
      texture{T_Chrome_5A}      
   }
#end

#macro Phone(_size)
// A phone
#local ww	= 12;
#local hr	= 4.5;
#local hf	= 1.5;
#local dd	= 15;
#local ang	= -atan((hr-hf)/dd)*180/pi;
#local dp	= (hr-hf)/4;
#local r1	= ww*0.15;
#local r2	= ww*0.1667;
#local hsc	= r1*2;
#local hsf	= <-ww/3.75,0,+dd*0.333>;
#local hsr	= hsf*<1,1,-1>;
#local txtr	= texture { pigment {rgb<0.55,0.4,0.35>} };
#local lpig	= pigment{rgb<0.33,0.24,0.21>};
#local tpig	= pigment{Black};
#local font1	= "cyrvetic.ttf";
#local font2	= "crystal.ttf";
#local cordless = 1;
union {
   difference {
      prism {
	 linear_spline -ww/2, ww/2, 5,
	 <0,dd/2>, <0,-dd/2>, <hf,-dd/2>, <hr,dd/2>, <0,dd/2>
	 rotate 90*z //rotate 180*y
      }
      union {
      #if (cordless)
         box{ hsr-<r2,dp,r2>, hsf+<r2,dp,r2> }
      #else
         cylinder{ hsf-y*dp, hsf+y*dp, r2 }
         cylinder{ hsr-y*dp, hsr+y*dp, r2 }
      #end
	 rotate x*ang
	 translate (hr+hf)/2*y
      }
      texture {txtr}
   }
   union {
      #local xx = -2;
      #local zz = 3.0;
      KeyCap("1","",lpig,tpig,xx,zz,1)
      KeyCap("2","",lpig,tpig,xx,zz,1)
      KeyCap("3","",lpig,tpig,xx,zz,1)
      #local xx = -2;
      #local zz = 1.0;
      KeyCap("4","",lpig,tpig,xx,zz,1)
      KeyCap("5","",lpig,tpig,xx,zz,1)
      KeyCap("6","",lpig,tpig,xx,zz,1)
      #local xx = -2;
      #local zz = -1.0;
      KeyCap("7","",lpig,tpig,xx,zz,1)
      KeyCap("8","",lpig,tpig,xx,zz,1)
      KeyCap("9","",lpig,tpig,xx,zz,1)
      #local xx = -2;
      #local zz = -3.0;
      KeyCap("*","",lpig,tpig,xx,zz,1)
      KeyCap("8","",lpig,tpig,xx,zz,1)
      KeyCap("#","",lpig,tpig,xx,zz,1)
      union {
        text { ttf font1 "* Mute", 0.001, 0 translate <-2.75,7> }
        text { ttf font1 "* Forward", 0.001, 0 translate <-2.75,8> }
        text { ttf font1 "* Transfer", 0.001, 0 translate <-2.75,9> }
        text { ttf font1 "* Voice Mail", 0.001, 0 translate <-2.75,10> }
	text { ttf font2 "I R Tele Comm", 0.2, 0 scale 1.25 translate <-4.2,12> }
	scale 2/3
        rotate <90,0>
	pigment{rgb <0.5,0.2,0.2> }
	//translate -y/5
      }
      scale <1,0.5,1>
      rotate x*ang
      translate <dd/6,hf+(hr-hf)/3,-ww/4>
   }

#if (cordless) // is it cordless?
   // The base antenna (easier than a cord!)
   #local dx = x*3/4;
   #local dy = y*hr/1.5;
   #local pt = <ww/2,hr*2/3,dd/2.5>+dx;
   Phone_Antenna( pt, 0.25, dy, 3, 0.75, 0.06, -dx )

   // The handset...
   union {
      object {
         Round_Box( hsr-<r1,dp/1.1,r1>, hsf+<r1,dp*3,r1>, r1/3, yes )
	 texture{txtr}
      }
      #local pt = hsf+<r1/2,0,-r1/2>;
      #local dy = z*r1*2;
      Phone_Antenna( pt, 0.25, dy, 3, 1/6, 0.06, <0,0> )
      rotate x*ang
      translate (hr+hf)/2*y
   }

#else
   // The handset...
   union {
      cylinder{ hsf-y*dp, hsf+y*dp, r1 }
      cylinder{ hsr-y*dp, hsr+y*dp, r1 }
      cone{ hsf+y*dp, r1, hsf+y*dp*3.5, r1/2 }
      cone{ hsr+y*dp, r1, hsr+y*dp*3.5, r1/2 }
      sphere{ hsf+y*dp*3.333, r1/2 }
      sphere{ hsr+y*dp*3.333, r1/2 }
      cylinder{ hsf+y*dp*3.333, hsr+y*dp*3.333, r1/2 }
      rotate x*ang
      translate (hr+hf)/2*y
      texture{txtr}
   }
   // And what about the phone cord?
#end
}

#declare _size = <ww,hsr.y+dp*3.333+r1/2+(hr+hf)/2,dd>;
#end