#declare MinPt = <-0.011409, -0.29117, -5.05258>;
#declare MaxPt = <0.0348958, 0.600001, 4.898>;
#declare Range = MaxPt - MinPt;

#declare NailLength = 2.0;
#declare NailRadius = 0.3;
#declare StringLength = 70.0;
#declare StringRadius = 0.12;

#declare NailCounter = 0;

//////////////////////////////////////////////////////////////////////////////////////

#macro CreateString (P, Len, Angle)

    #local WireHeight = StringRadius * 0.5;

    #declare Base =
    cylinder
    {
        0, -Len * y, StringRadius
        
        texture
        {
            pigment { color rgb 0.15 }
            
            finish
            {
                specular 10
                roughness 0.001
            }
        }
    }

    union
    {
        object { Base }
        
        #if (NailCounter > 160)
            union
            {
                #local CurPos = Len * 0.1;
                
                #while (CurPos < Len * 0.9)
                    torus
                    {
                        StringRadius + WireHeight/2, WireHeight
                        translate -CurPos * y
                    }
                
                    #declare CurPos = CurPos + WireHeight * 2.05;
                #end
                
                texture
                {
                    pigment { color rgb <0.5, 0.25, 0.05> }
                    finish
                    {
                        specular 7
                        roughness 0.001
                    }
                }
            }
        #end

        rotate Angle*z
        rotate 4*x
        translate <P.x, P.y, P.z - 0.75*NailLength>
    }

#end

//////////////////////////////////////////////////////////////////////////////////////

#macro CreateNail (BoardWidth, BoardHeight, P)

    #local Position = 
        <-((P.z - MinPt.z) / Range.z - 0.5) * BoardWidth, 
          ((P.y - MinPt.y) / Range.y - 0.5) * BoardHeight, 0.0>;

    #if (NailCounter < 174)
        #if (NailCounter >= 89)
            #declare Position = Position - 0.7 * x;
        #end
    #end

    union
    {
        // Nail
        union
        {
            cylinder
            {
                Position, Position - NailLength*z, 
                NailRadius
            }
            
            sphere
            {
                Position - NailLength*z, NailRadius
            }

            texture
            {            
                pigment
                {
                    color rgb 0.1
                }
                
                finish
                {
                    specular 3
                    roughness 0.01
                }
            }
        }
    
        #if (NailCounter >= 174)
            CreateString (Position, StringLength, 20)
        #else
            #if (NailCounter >= 89)
                CreateString (Position, StringLength, -30)
            #else
                CreateString (Position, StringLength, -25)
            #end
        #end
    }
    
    #declare NailCounter = NailCounter + 1;
#end

//////////////////////////////////////////////////////////////////////////////////////

#macro CreateNails (Width, Height)
    // There are 211 nails in this union
    union
    {
        // Upper nails (89)
        
    	CreateNail (Width, Height, <0.0348958, -0.187169, -5.05258>)
    	CreateNail (Width, Height, <0.0348958, 0.00883065, -5.04258>)
    	CreateNail (Width, Height, <0.0348957, -0.29117, -4.97257>)
    	CreateNail (Width, Height, <0.0348957, -0.105169, -4.95057>)
    	CreateNail (Width, Height, <0.0348957, 0.112831, -4.95657>)
    	CreateNail (Width, Height, <0.0348956, -0.187169, -4.88257>)
    	CreateNail (Width, Height, <0.0348956, 0.00483066, -4.87057>)
    	CreateNail (Width, Height, <0.0348956, 0.186831, -4.86057>)
    	CreateNail (Width, Height, <0.0348955, -0.28917, -4.78857>)
    	CreateNail (Width, Height, <0.0348954, -0.0791692, -4.76457>)
    	CreateNail (Width, Height, <0.0348954, 0.110831, -4.76257>)
    	CreateNail (Width, Height, <0.0348953, -0.18117, -4.69057>)
    	CreateNail (Width, Height, <0.0348953, 0.00483066, -4.67457>)
    	CreateNail (Width, Height, <0.0348953, 0.194831, -4.66257>)
    	CreateNail (Width, Height, <0.0348952, -0.277169, -4.60057>)
    	CreateNail (Width, Height, <0.0348952, -0.0771693, -4.58657>)
    	CreateNail (Width, Height, <0.0348952, 0.124831, -4.57257>)
    	CreateNail (Width, Height, <0.0348951, -0.189169, -4.50257>)
    	CreateNail (Width, Height, <0.0348951, 0.00483066, -4.49657>)
    	CreateNail (Width, Height, <0.0348951, 0.20883, -4.47657>)
    	CreateNail (Width, Height, <0.034895, -0.281169, -4.42257>)
    	CreateNail (Width, Height, <0.034895, -0.0731695, -4.40657>)
    	CreateNail (Width, Height, <0.0348949, 0.124831, -4.39257>)
    	CreateNail (Width, Height, <0.0348949, -0.18117, -4.31057>)
    	CreateNail (Width, Height, <0.0348948, 0.0148306, -4.30457>)
    	CreateNail (Width, Height, <0.0348948, 0.204831, -4.29457>)
    	CreateNail (Width, Height, <0.0348947, -0.281169, -4.22857>)
    	CreateNail (Width, Height, <0.0348947, -0.0711692, -4.19857>)
    	CreateNail (Width, Height, <0.0348947, 0.116831, -4.19057>)
    	CreateNail (Width, Height, <0.0348946, -0.165169, -4.11457>)
    	CreateNail (Width, Height, <0.0348946, 0.0288308, -4.10457>)
    	CreateNail (Width, Height, <0.0348946, 0.21083, -4.09057>)
    	CreateNail (Width, Height, <0.0348945, -0.28917, -4.01457>)
    	CreateNail (Width, Height, <0.0348945, -0.0791692, -4.01057>)
    	CreateNail (Width, Height, <0.0348944, 0.120831, -3.99657>)
    	CreateNail (Width, Height, <0.0348943, -0.187169, -3.92257>)
    	CreateNail (Width, Height, <0.0348943, 0.0308307, -3.90657>)
    	CreateNail (Width, Height, <0.0348943, 0.216831, -3.90057>)
    	CreateNail (Width, Height, <-0.011409, -0.287941, -3.85796>)
    	CreateNail (Width, Height, <-0.0083461, -0.0699594, -3.80997>)
    	CreateNail (Width, Height, <-0.00583293, 0.118025, -3.79798>)
    	CreateNail (Width, Height, <-0.0094108, -0.17795, -3.72996>)
    	CreateNail (Width, Height, <-0.00654859, 0.0360315, -3.71598>)
    	CreateNail (Width, Height, <-0.00413143, 0.214016, -3.69598>)
    	CreateNail (Width, Height, <-0.00750857, -0.06396, -3.63597>)
    	CreateNail (Width, Height, <-0.00479471, 0.138023, -3.61998>)
    	CreateNail (Width, Height, <-0.00230772, 0.326007, -3.61399>)
    	CreateNail (Width, Height, <-0.00565872, 0.0420311, -3.52998>)
    	CreateNail (Width, Height, <-0.00310193, 0.234014, -3.51999>)
    	CreateNail (Width, Height, <-0.000806919, 0.406, -3.51>)
    	CreateNail (Width, Height, <-0.00661871, -0.0579603, -3.44997>)
    	CreateNail (Width, Height, <-0.00411428, 0.128024, -3.43398>)
    	CreateNail (Width, Height, <-0.00154004, 0.318007, -3.414>)
    	CreateNail (Width, Height, <-0.00524879, 0.0160332, -3.35798>)
    	CreateNail (Width, Height, <-0.00256109, 0.218016, -3.34799>)
    	CreateNail (Width, Height, <4.40331e-006, 0.404, -3.318>)
    	CreateNail (Width, Height, <4.30532e-006, -0.0640001, -3.244>)
    	CreateNail (Width, Height, <4.31419e-006, 0.132, -3.25>)
    	CreateNail (Width, Height, <4.27325e-006, 0.324, -3.222>)
    	CreateNail (Width, Height, <4.18902e-006, 0.0219999, -3.158>)
    	CreateNail (Width, Height, <4.14842e-006, 0.22, -3.126>)
    	CreateNail (Width, Height, <4.13774e-006, 0.408, -3.118>)
    	CreateNail (Width, Height, <4.03393e-006, -0.06, -3.04>)
    	CreateNail (Width, Height, <4.01416e-006, 0.14, -3.024>)
    	CreateNail (Width, Height, <3.98115e-006, 0.32, -3.002>)
    	CreateNail (Width, Height, <3.90726e-006, 0.0219999, -2.944>)
    	CreateNail (Width, Height, <3.87242e-006, 0.226, -2.92>)
    	CreateNail (Width, Height, <3.86602e-006, 0.418, -2.914>)
    	CreateNail (Width, Height, <3.77421e-006, -0.0559999, -2.846>)
    	CreateNail (Width, Height, <3.76718e-006, 0.14, -2.84>)
    	CreateNail (Width, Height, <3.76023e-006, 0.318, -2.834>)
    	CreateNail (Width, Height, <3.68137e-006, 0.0219999, -2.776>)
    	CreateNail (Width, Height, <3.64545e-006, 0.224, -2.748>)
    	CreateNail (Width, Height, <3.63578e-006, 0.416, -2.74>)
    	CreateNail (Width, Height, <3.53099e-006, -0.074, -2.66>)
    	CreateNail (Width, Height, <3.50862e-006, 0.136, -2.644>)
    	CreateNail (Width, Height, <3.49332e-006, 0.326, -2.634>)
    	CreateNail (Width, Height, <3.39281e-006, 0.02, -2.558>)
    	CreateNail (Width, Height, <3.37128e-006, 0.23, -2.542>)
    	CreateNail (Width, Height, <3.36445e-006, 0.419999, -2.536>)
    	CreateNail (Width, Height, <3.27511e-006, -0.074, -2.47>)
    	CreateNail (Width, Height, <3.26609e-006, 0.12, -2.462>)
    	CreateNail (Width, Height, <3.23103e-006, 0.322, -2.434>)
    	CreateNail (Width, Height, <3.13414e-006, 0.032, -2.362>)
    	CreateNail (Width, Height, <3.11695e-006, 0.234, -2.348>)
    	CreateNail (Width, Height, <3.1031e-006, 0.414001, -2.338>)
    	CreateNail (Width, Height, <3.01907e-006, -0.06, -2.274>)
    	CreateNail (Width, Height, <2.98932e-006, 0.128, -2.254>)
    	CreateNail (Width, Height, <2.97531e-006, 0.330001, -2.244>)

        // Middle nails (85)
    	
    	CreateNail (Width, Height, <2.58891e-006, 0.02, -1.952>)
    	CreateNail (Width, Height, <2.57234e-006, 0.226, -1.94>)
    	CreateNail (Width, Height, <2.56272e-006, 0.424, -1.932>)
    	CreateNail (Width, Height, <2.45497e-006, -0.0640001, -1.85>)
    	CreateNail (Width, Height, <2.45151e-006, 0.118, -1.848>)
    	CreateNail (Width, Height, <2.45497e-006, 0.316, -1.85>)
    	CreateNail (Width, Height, <2.34539e-006, 0.0180001, -1.768>)
    	CreateNail (Width, Height, <2.35079e-006, 0.214, -1.772>)
    	CreateNail (Width, Height, <2.3401e-006, 0.419999, -1.764>)
    	CreateNail (Width, Height, <2.23262e-006, -0.0760001, -1.682>)
    	CreateNail (Width, Height, <2.22802e-006, 0.122, -1.678>)
    	CreateNail (Width, Height, <2.23262e-006, 0.318, -1.682>)
    	CreateNail (Width, Height, <2.12113e-006, 0.016, -1.598>)
    	CreateNail (Width, Height, <2.12494e-006, 0.226, -1.6>)
    	CreateNail (Width, Height, <2.10551e-006, 0.43, -1.586>)
    	CreateNail (Width, Height, <1.98576e-006, -0.0819998, -1.498>)
    	CreateNail (Width, Height, <1.99175e-006, 0.12, -1.502>)
    	CreateNail (Width, Height, <2.00214e-006, 0.318, -1.508>)
    	CreateNail (Width, Height, <1.87409e-006, 0.02, -1.414>)
    	CreateNail (Width, Height, <1.87633e-006, 0.228, -1.416>)
    	CreateNail (Width, Height, <1.88869e-006, 0.426, -1.424>)
    	CreateNail (Width, Height, <1.7492e-006, -0.068, -1.318>)
    	CreateNail (Width, Height, <1.76668e-006, 0.132, -1.332>)
    	CreateNail (Width, Height, <1.75973e-006, 0.32, -1.326>)
    	CreateNail (Width, Height, <1.64248e-006, 0.038, -1.238>)
    	CreateNail (Width, Height, <1.64493e-006, 0.22, -1.24>)
    	CreateNail (Width, Height, <1.65638e-006, 0.426, -1.248>)
    	CreateNail (Width, Height, <1.50314e-006, -0.062, -1.132>)
    	CreateNail (Width, Height, <1.52138e-006, 0.128, -1.146>)
    	CreateNail (Width, Height, <1.52773e-006, 0.322, -1.15>)
    	CreateNail (Width, Height, <1.40507e-006, 0.036, -1.058>)
    	CreateNail (Width, Height, <1.43155e-006, 0.226, -1.078>)
    	CreateNail (Width, Height, <1.42086e-006, 0.428001, -1.07>)
    	CreateNail (Width, Height, <1.28201e-006, -0.042, -0.968>)
    	CreateNail (Width, Height, <1.30871e-006, 0.13, -0.986>)
    	CreateNail (Width, Height, <1.28519e-006, 0.32, -0.97>)
    	CreateNail (Width, Height, <1.15466e-006, 0.0439999, -0.87>)
    	CreateNail (Width, Height, <1.18148e-006, 0.228, -0.892>)
    	CreateNail (Width, Height, <1.21101e-006, 0.44, -0.912>)
    	CreateNail (Width, Height, <1.02831e-006, -0.0300001, -0.774>)
    	CreateNail (Width, Height, <1.0451e-006, 0.142, -0.788>)
    	CreateNail (Width, Height, <1.07111e-006, 0.330001, -0.808>)
    	CreateNail (Width, Height, <9.32316e-007, 0.0579999, -0.702001>)
    	CreateNail (Width, Height, <9.4225e-007, 0.248, -0.710001>)
    	CreateNail (Width, Height, <9.74463e-007, 0.467999, -0.736001>)
    	CreateNail (Width, Height, <7.92342e-007, -0.014, -0.598>)
    	CreateNail (Width, Height, <8.10725e-007, 0.174, -0.61>)
    	CreateNail (Width, Height, <8.38987e-007, 0.358001, -0.632>)
    	CreateNail (Width, Height, <6.74603e-007, 0.0920002, -0.51>)
    	CreateNail (Width, Height, <7.15201e-007, 0.278, -0.538>)
    	CreateNail (Width, Height, <7.40059e-007, 0.486, -0.558>)
    	CreateNail (Width, Height, <5.43649e-007, 0.038, -0.41>)
    	CreateNail (Width, Height, <5.7415e-007, 0.196, -0.433999>)
    	CreateNail (Width, Height, <6.11159e-007, 0.37, -0.46>)
    	CreateNail (Width, Height, <4.50796e-007, 0.136, -0.34>)
    	CreateNail (Width, Height, <4.75363e-007, 0.302, -0.36>)
    	CreateNail (Width, Height, <5.39036e-007, 0.486, -0.405999>)
    	CreateNail (Width, Height, <3.19894e-007, 0.076, -0.24>)
    	CreateNail (Width, Height, <3.42401e-007, 0.236, -0.258>)
    	CreateNail (Width, Height, <3.80413e-007, 0.394, -0.288>)
    	CreateNail (Width, Height, <2.16364e-007, 0.18, -0.162>)
    	CreateNail (Width, Height, <2.33926e-007, 0.348, -0.176>)
    	CreateNail (Width, Height, <2.9984e-007, 0.49, -0.226>)
    	CreateNail (Width, Height, <7.48594e-008, 0.132, -0.0580001>)
    	CreateNail (Width, Height, <1.20808e-007, 0.274, -0.0900001>)
    	CreateNail (Width, Height, <1.35801e-007, 0.436, -0.102>)
    	CreateNail (Width, Height, <-8.53455e-009, 0.242, 0.006>)
    	CreateNail (Width, Height, <1.81299e-008, 0.386001, -0.012>)
    	CreateNail (Width, Height, <5.03359e-008, 0.524, -0.038>)
    	CreateNail (Width, Height, <-1.5463e-007, 0.186, 0.116>)
    	CreateNail (Width, Height, <-1.20836e-007, 0.326, 0.09>)
    	CreateNail (Width, Height, <-9.17701e-008, 0.452, 0.07>)
    	CreateNail (Width, Height, <-2.41659e-007, 0.298, 0.182>)
    	CreateNail (Width, Height, <-2.16378e-007, 0.414001, 0.162>)
    	CreateNail (Width, Height, <-1.66724e-007, 0.554001, 0.126>)
    	CreateNail (Width, Height, <-2.99845e-007, 0.496, 0.226>)
    	CreateNail (Width, Height, <-3.3962e-007, 0.38, 0.256>)
    	CreateNail (Width, Height, <-3.74596e-007, 0.256, 0.284>)
    	CreateNail (Width, Height, <-4.5869e-007, 0.356, 0.346>)
    	CreateNail (Width, Height, <-4.28806e-007, 0.473999, 0.322>)
    	CreateNail (Width, Height, <-3.85531e-007, 0.589999, 0.292>)
    	CreateNail (Width, Height, <-6.08503e-007, 0.338001, 0.458>)
    	CreateNail (Width, Height, <-5.317e-007, 0.52, 0.400001>)
    	CreateNail (Width, Height, <-6.37401e-007, 0.582, 0.48>)
    	CreateNail (Width, Height, <-6.85409e-007, 0.422, 0.518>)

        // Lower nails (37)

    	CreateNail (Width, Height, <-2.83741e-006, 0.224, 2.038>)
    	CreateNail (Width, Height, <-2.97099e-006, 0.362, 2.14>)
    	CreateNail (Width, Height, <-3.02672e-006, 0.224, 2.18>)
    	CreateNail (Width, Height, <-3.06474e-006, 0.086, 2.21>)
    	CreateNail (Width, Height, <-3.26384e-006, 0.500001, 2.36>)
    	CreateNail (Width, Height, <-3.30768e-006, 0.364, 2.392>)
    	CreateNail (Width, Height, <-3.32083e-006, 0.24, 2.402>)
    	CreateNail (Width, Height, <-3.38135e-006, 0.114, 2.45>)
    	CreateNail (Width, Height, <-3.5347e-006, 0.493999, 2.564>)
    	CreateNail (Width, Height, <-3.58919e-006, 0.376, 2.606>)
    	CreateNail (Width, Height, <-3.61868e-006, 0.258001, 2.626>)
    	CreateNail (Width, Height, <-3.68441e-006, 0.128, 2.678>)
    	CreateNail (Width, Height, <-3.82364e-006, 0.497999, 2.78>)
    	CreateNail (Width, Height, <-3.88046e-006, 0.378, 2.826>)
    	CreateNail (Width, Height, <-3.92451e-006, 0.272001, 2.856>)
    	CreateNail (Width, Height, <-3.99058e-006, 0.164, 2.908>)
    	CreateNail (Width, Height, <-4.0999e-006, 0.496001, 2.99>)
    	CreateNail (Width, Height, <-4.16961e-006, 0.388, 3.044>)
    	CreateNail (Width, Height, <-4.23524e-006, 0.282, 3.092>)
    	CreateNail (Width, Height, <-4.2754e-006, 0.179999, 3.124>)
    	CreateNail (Width, Height, <-4.39111e-006, 0.496001, 3.21>)
    	CreateNail (Width, Height, <-4.47457e-006, 0.398, 3.274>)
    	CreateNail (Width, Height, <-4.5152e-006, 0.24, 3.302>)
    	CreateNail (Width, Height, <-4.75574e-006, 0.462, 3.484>)
    	CreateNail (Width, Height, <-4.78036e-006, 0.262, 3.504>)
    	CreateNail (Width, Height, <-5.03954e-006, 0.457999, 3.698>)
    	CreateNail (Width, Height, <-5.07454e-006, 0.284, 3.726>)
    	CreateNail (Width, Height, <-5.32521e-006, 0.46, 3.912>)
    	CreateNail (Width, Height, <-5.59489e-006, 0.462, 4.118>)
    	CreateNail (Width, Height, <-5.36553e-006, 0.306, 3.944>)
    	CreateNail (Width, Height, <-5.66029e-006, 0.308, 4.166>)
    	CreateNail (Width, Height, <-5.87913e-006, 0.454001, 4.332>)
    	CreateNail (Width, Height, <-5.96515e-006, 0.318, 4.396>)
    	CreateNail (Width, Height, <-6.15074e-006, 0.45, 4.536>)
    	CreateNail (Width, Height, <-6.25489e-006, 0.319999, 4.614>)
    	CreateNail (Width, Height, <-6.38561e-006, 0.45, 4.714>)
    	CreateNail (Width, Height, <-6.49733e-006, 0.332, 4.798>)
    }
#end
