// Persistence of Vision Ray Tracer Scene Description File
// File: new-wood.inc
// Vers: 3.5
// Desc: Wood texture for the piano skeleton
// Date: 2004/04/26 (at first the texture was placed into keyboard.inc)
// Auth: Maurizio Tomasi

#ifndef (__NEW_WOOD_INCLUDED)
#declare __NEW_WOOD_INCLUDED = 1;

#include "colors.inc"
#include "woods.inc"

#declare WoodTex = /* texture { T_Wood24 } is a simpler replacement */
texture
{
    pigment 
    { 
        wood
        
        color_map
        {
                [0.0 color rgb <67, 19, 12>/255]
                [0.6 color rgb <102, 33, 10>/255]
                [0.8 color rgb <85, 15, 1>/255]
        }
        
        warp { turbulence 0.15 }
        
        scale 0.3        
    }

    finish
    {
        specular 0.2
        roughness 0.002
    }
}
texture
{
    pigment
    {
        bozo
        
        color_map
        {
            [0.2 color rgbt 1]
            [0.2 color rgbt <0.05, 0.03, 0.03, 0.4>]
            [0.4 color rgbt <0.05, 0.03, 0.03, 0.4>]
            [0.4 color rgbt 1]
            [0.8 color rgbt 1]
            [0.8 color rgbt <0.05, 0.03, 0.03, 0.4>]
        }
        
        scale 0.01
    }
    
    normal
    {
        bozo 0.3
        
        scale 0.01
    }
}

#declare LightWoodTex = texture { T_Wood1 scale 10 }

#end // __NEW_WOOD_INCLUDED
