//===========================================================================
//
// Stonehenge as it might have been.
// IRTC Submission, April 2004 -- "Great Inventions"
// By Marvin Taylor ( povray at maltasoft dot com )
//
// Copyright information: Aside from the radiosity values & comments
// that were lifted from POVRay itself, the rest was created by me.
// Use it for whatever purpose you wish, but if you make something 
// cool from it, drop me a line, please.
//
//===========================================================================

#include "colors.inc"
#include "functions.inc"
#include "stones.inc"

#declare Radiosity      = 0;
#declare Show_Sky	= 1;
#declare Show_Triliths	= 1;
#declare Show_Sarsen	= 1;
#declare Show_Posts	= 1;

#declare SarsenTxt = texture {
    pigment { color rgb<0.63,0.55,0.82> }
    normal { bumps 0.25 turbulence 2.0 scale 0.15 }
    finish { diffuse 0.65 ambient 0.35 }
  };

global_settings {                   
  ambient_light rgb<0.015,0.015,0.015>
  assumed_gamma 1.0
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.01           // end pretrace at this size
      count 85                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.2            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 0.25               // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}
 

//
// Trilithon parameters:
//   ww = Overall width
//   hh = Overall height
//   dp = depth
#macro Trilithon( ww, hh, dp )
   // uw = upright width
   #local uw = ww/3.25;
   // th = topstone height
   #local th = dp/1.5;

   #local w3 = ww/2;
   #local w2 = w3-ww/20;
   #local w1 = w2-uw;
   #local h1 = hh-th;
   #local h2 = h1+1/24;
   #local h3 = hh;
   #local t2 = dp/2;
   #local t1 = dp/2.25;

   union {
      box { <-w2,0,-t1>,  <-w1,h1,t1> }
      box { <+w1,0,-t1>,  <+w2,h1,t1> }
      box { <-w3,h2,-t2>, <+w3,h3,t2> }
      texture { SarsenTxt }
   }

#end

// Circle of posts:
#macro PostCircle( pnum, phgt, ppr, txt, prad, a1, a2 )
   union {
      #local i = 0; #while (i<pnum)
      #local a = (a1+(a2-a1)*i/pnum)*pi/180;
      cylinder { 0, phgt*y, ppr
         translate prad*<sin(a),0,cos(a)>
      }
      #local i=i+1; #end
      texture { txt }
   }
#end
// A line of posts
#macro PostLine( pnum, phgt, ppr, txt, off1, dlt )
   union {
      #local pt = off1;
      #local i = 0; #while (i<pnum)
         cylinder { pt, pt+phgt*y, ppr }
	 #debug concat("Post #",str(i,1,1)," @ <",vstr(2,pt,",",7,3),"...\n")
         #local pt = pt+dlt/pnum;
      #local i=i+1; #end
      texture { txt }
   }
#end

/////////////////////////////////////////////////////////////////
//
// Here all distances are in feet...
//
#if (Show_Triliths)
   // "small" trilithons (20ft)
   object { Trilithon( 16, 20, 6.2 ) rotate +90*y translate <-27.3,0,-13> }
   object { Trilithon( 16, 20, 6.2 ) rotate -90*y translate <+27.3,0,-13> }

   // "second" trilithons (21ft)
   object { Trilithon( 17, 21, 6.8 ) rotate +106*y translate <-25,0,+11> }
   object { Trilithon( 17, 21, 6.8 ) rotate -106*y translate <+25,0,+11> }

   // The central trilithon (24ft)
   object { Trilithon( 18, 24, 8.2 ) rotate      0 translate <0,0,+24> }
#end

// The "altar" stone... which I'm pretty sure is placed badly (books are at home).
box { <-2,0,-3.75>, <2,2.1,3.75> 
      texture{ SarsenTxt } 
      translate <0,0,+8> 
}
   
#if (Show_Posts)
   // the posts around the horseshoe
   PostCircle( 60, 4.25, 0.35, SarsenTxt, 45, 0, 360 )

   // the post horseshoe:
   PostCircle( 12, 4.25, 0.35, SarsenTxt, 20.5, -90, 90 )
   PostLine  (  5, 4.25, 0.35, SarsenTxt, <-20.5,0,-2>, -z*27 )
   PostLine  (  5, 4.25, 0.35, SarsenTxt, <+20.5,0,-2>, -z*27 )

   // The 56 posts, diameter 284ft.
   PostCircle( 56, 6, 1.5, SarsenTxt, 142, 0, 360 )
#end

#if (Show_Sarsen)
   // The outer sarsen stones
   union {
       #local gap = 0.01;
       #local h1  = 11-gap;
       #local h2  = 11+gap;
       #local h3  = 14;
       #local bw  = 4;
       #local dt  = 1.8;
       #local r1  = 56;
       #local num = 30;
   
       difference {
	  cylinder { <0,h2,0>, <0,h3,0>, r1+dt*1.08+gap }
	  cylinder { <0,h2-1,0>, <0,h3+1,0>, r1-dt*1.1-gap }
	  #local i = 0; #while (i<num)
	  box { <-gap,h1,dt*2-r1>, <gap,h3+gap,-dt*2-r1>
		rotate -360*(i+0.5)/num*y }
	  #local i=i+1; #end
       }
       #local i = 0; #while (i<num)
       box { <-bw,0,-dt>, <bw,h1,dt> 
	    translate z*r1
	    rotate 360*(i+.5)/num*y
       }
       #local i=i+1; #end
       texture{ SarsenTxt }
   }
#end


// The ground...
difference {
  union {
     plane { y, 0 }
     box { <-500,-15,-500>, <500,0,500> }
     torus { 157, 5 translate -y*2 }
     torus { 176, 5 translate -y*2 }
  }
#if (0)
  difference {
     isosurface { 
     box { <-500,-15,-500>, <500,0,500> }
  }     
#end     

  torus { 166.5, 5.35 translate y*2.1 }
  texture {
    pigment {
      granite turbulence 0.4 octaves 3 omega 0.7 lambda 2
      color_map {
          [0.0 0.3 color rgbt<0.4, 0.5, 0.2, 0.0> color rgbt<0.4, 0.3, 0.1, 0.1>]
          [0.3 0.5 color rgbt<0.6, 0.6, 0.2, 0.1> color rgbt<0.0, 0.0, 0.0, 0.0>]
          [0.5 1.0 color rgbt<0.3, 0.3, 0.3, 0.0> color rgbt<0.3, 0.6, 0.0, 0.0>]
      }
      //scale 1/8 //scale <0.2, 0.5, 0.2>
    }
    //pigment { rgbt<0.4,0.6,0.2,0.1> }
    normal  {bumps 0.5 turbulence 2.0 }
    finish  {diffuse 0.3 ambient 0.25 }
  
  }
}



#if (Show_Sky)
   // Some sky...
   sky_sphere {
       pigment {
	 gradient y
	 color_map {
	   [0.0000 0.0003 color rgb <0.9, 0.9, 1.1> color rgb <0.7, 0.7, 0.7>]
	   [0.0003 0.0050 color rgb <0.6, 0.6, 0.5> color rgb <0.4, 0.4, 0.6>]
	   [0.0050 1.0000 color rgb <0.4, 0.4, 0.6> color rgb <0.2, 0.2, 0.2>]
	 }
	 scale 2
	 translate -1
	 rotate <-120,20,0>
       }
       pigment {
	 bozo
	 turbulence 0.65
	 octaves 22
	 omega 0.7
	 lambda 2
	 color_map {
	     [0.0 0.1 color rgb <0.85, 0.85, 0.85>
	              color rgb <0.75, 0.75, 0.75>]
	     [0.1 0.9 color rgb <0.75, 0.75, 0.75>
	              color rgbt <1, 1, 1, 1>]
	     [0.9 1.0 color rgbt <1, 1, 1, 1>
	              color rgbt <1, 1, 1, 1>]
	 }
	 scale 1/15 //scale <0.2, 0.5, 0.2>
       }
     }
#end

camera {
   //fisheye
   location <0,9.5,-56.5> // <0,32,-78> // <0,75,-100>
   look_at <0,30,+230>
   up y
   right z*image_width/image_height
   angle 80
}

light_source {<-600,800,-600> rgb 0.1}
light_source {<   0,800,-600> rgb 0.1}
light_source {<-600,800,   0> rgb 0.1}
light_source {< 200,300, 600> rgb 0.6}

