// Persistence of Vision Ray Tracer Scene Description File
// File: StandMag.pov
// Vers: 3.5
// Desc: Demonstration of the stand-magnifier-and-alligator-clip thingy
// Date: 04/29/2004
// Auth: Copyright  2004 by Sherry K. Shaw


global_settings {
  assumed_gamma 1.0
}


//------------------------------------------------------------------------------
// A bit of wire (just a prop for the posed object)
//------------------------------------------------------------------------------

#declare INS_TEX =
texture {
  pigment {
    color rgb < 1, 0, 0 >
  }
  finish {
    ambient 0.4
    diffuse 0.65
    specular 1.0
    roughness 0.05
  }
}

#declare WIRE_TEX =
texture {
  pigment {
    color rgb < 1, 1, 1 >
  }
  finish {
    ambient 0.1
    diffuse 0.65
    specular 1.0
    roughness 0.025
    metallic
  }
}

#declare NUM_PTS = 7 ;
#declare WIRE_PT = array[ NUM_PTS ] {
  < -2.2, 0.0, -0.7 >, 
  < -2.3, 0.0, -0.7 >,  
  < -1.6, 0.0,  0.2 >, 
  <  0.2, 0.0,  0.7 >, 
  <  1.7, 0.0,  0.3 >,
  <  2.7, 0.0, -0.7 >, 
  <  2.5, 0.0, -0.7 >
}

#declare WIRE_OBJ =
union {
  sphere_sweep {
    cubic_spline
    NUM_PTS,
    #local Ix = 0 ;
    #while ( Ix < NUM_PTS )
      WIRE_PT[ Ix ], 0.05
      #local Ix = Ix + 1 ;
    #end
    texture {
      INS_TEX
    }
  }
  cylinder {
    < -0.45, 0, 0 >, < 0.003, 0, 0 >, 0.03
    rotate y*-63
    translate WIRE_PT[ 1 ]
    texture {
      WIRE_TEX
    }
  }
  cylinder {
    < -0.003, 0, 0 >, < 0.45, 0, 0 >, 0.03
    rotate y*54
    translate WIRE_PT[ NUM_PTS - 2 ]
    texture {
      WIRE_TEX
    }
  }
}


//------------------------------------------------------------------------------
// Here's the default stand magnifier, with no changes to the pose.
//------------------------------------------------------------------------------

#include "StandMag.inc"

#declare UNPOSED_OBJ =
object {
  SSMC_STAND_MAG_OBJ
}


//------------------------------------------------------------------------------
// Here's a posed version.  First we define the posing variables, then we
// include the file again to build the object.
//------------------------------------------------------------------------------

// The magnifier and the doodads holding it
#declare SSMC_Mag_on_FPC_Rot = < -30, 0, 0 > ;
#declare SSMC_Mag_FPC_SW_Rot = < 30, 30, 0 > ;
#declare SSMC_Mag_FPC_on_BC_Rot = < 0, 215, 0 > ;
#declare SSMC_Mag_BC_S_XRot = 30 ;
#declare SSMC_Mag_X_Trans = -1.25 ;
#declare SSMC_Mag_BC_on_Rod_Rot = 10 ;
#declare SSMC_Mag_UsePhotons = false ;

// The left-hand alligator clip
#declare SSMC_Left_AC_UseObj = true ;
#declare SSMC_Left_AC_Obj =
object {
  WIRE_OBJ
}
#declare SSMC_Left_AC_J_XRot = 5 ;
#declare SSMC_Left_AC_Rot = < -30, 150, -15 > ;
#declare SSMC_Left_AC_CPC_SW_Rot = < 0, 0, 0 > ;

// The right-hand alligator clip
#declare SSMC_Right_AC_UseObj = false ;
//#declare SSMC_Right_AC_Obj =              // You'd use this variable to put something into
//object {                                  // the right-hand alligator clip.
//  MY_DOODAD_OBJ
//}
#declare SSMC_Right_AC_J_XRot = 0 ;
#declare SSMC_Right_AC_Rot = < 39, 115, 75 > ;
#declare SSMC_Right_AC_CPC_SW_Rot = < 0, 0, 0 > ;

// Everything above the base
#declare SSMC_Rod_in_BC_Rot = -5 ;
#declare SSMC_Rod_BC_S_XRot = 30 ;
#declare SSMC_Rod_on_FPC_Rot = < 30, 0, 0 > ;
#declare SSMC_Rod_FPC_SW_Rot = < 0, 0, 0 > ;
#declare SSMC_Ass_Rot = < -30, 0, 0 > ;

#include "StandMag.inc"

#declare POSED_OBJ =
object {
  SSMC_STAND_MAG_OBJ
}


//------------------------------------------------------------------------------
//                            ***  The Scene  ***
//------------------------------------------------------------------------------

camera {
  right x*image_width/image_height
  location < 0, 5, -12 >
  look_at < 0, 5, 0 >
}

light_source {
  < -200, 150, -200 >
  color rgb < 1.0, 1.0, 1.0 >
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0.5 color rgb < 0.2, 0.3, 0.8 > ]
      [ 1.0 color rgb < 0.0, 0.0, 0.4 > ]
    }
    scale 2
    translate -1
  }
  pigment {
    agate
    color_map {
      [ 0.0 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 1.0 color rgbf < 1.0, 1.0, 1.0, 0.0 > ]
    }
    scale < 0.8, 0.4, 0.8 >
  }
}

plane {
  y, 0
  texture {
    pigment {
      color rgb < 0.3, 0.2, 0.1 >
    }
    finish {
      ambient 0.3
      diffuse 0.8
    }
  }
}

object {
  UNPOSED_OBJ
  translate < -3.75, 0, 0 >
}

object {
  POSED_OBJ
  rotate y*30
  translate < 4.25, 0, 0 >
}



