// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;    

#include "colors.inc"  
#include "textures.inc"  
#include "stones.inc"
#include "TV.inc"         
#include "marbles.inc"  
#include "PS2.inc"  
#include "chess.inc" 
#include "woods.inc"

#declare useRadiosity   =       1;
#declare showTV         =       1;        
#declare showPS2        =       1;
#declare useTestTex     =       0;
#declare useArea        =       1;   
#declare usePhotons     =       0;  
#declare showMarbles    =       1;
#declare showBag        =       1;      
#declare useFocalBlur   =       0;
#declare showTable      =       1;
#declare showChess      =       1;
#declare showBBall      =       1;
#declare showRacket     =       1;

global_settings {
  assumed_gamma 1.0
#if(useRadiosity)
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
#end                                                                    
#if(usePhotons)
  photons {
    //spacing 0.01                 // specify the density of photons
    count 200000               // alternatively use a total number of photons

    //gather min, max            // amount of photons gathered during render [20, 100]
    //media max_steps [,factor]  // media photons
    //jitter 1.0                 // jitter phor photon rays
    //max_trace_level 5          // optional separate max_trace_level
    //adc_bailout 1/255          // see global adc_bailout
    //save_file "filename"       // save photons to file
    //load_file "filename"       // load photons from file
    //autostop 0                 // photon autostop option
    //radius 10                  // manually specified search radius
    // (---Adaptive Search Radius---)
    //steps 1
    //expand_thresholds 0.2, 40
  }
#end
}


// ----------------------------------------


camera {
  location  <250, 130, 295.0>
  direction 1.2*z
  right     x*image_width/image_height
  look_at   <300, 52,  400.0> 
#if(useFocalBlur)
  aperture 0.2           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 100       // number of rays per pixel for sampling
  focal_point <450, 35, 600>    // point that is in focus <X,Y,Z>
  confidence 0.995           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/2000            // [0...1] how precise to calculate (smaller is more accurate)
#end
//  rotate <0, 40, 0>
}


// Create an infinite sphere around scene and allow any pigment on it
sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}

     
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 0.9, 0.8>*4  // light's color
  translate <-420, 450, 500>
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 500
  fade_power 2
#if(useArea)
  area_light
  <60, 0, 0> <0, 0, 60> // lights spread out across this distance (x * z)
  5, 5                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  orient              // orient light
#end
} 

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 0.9, 0.8>  // light's color
  translate <-120, 450, -600>
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 1500
  fade_power 2
#if(useArea)
  area_light
  <60, 0, 0> <0, 0, 60> // lights spread out across this distance (x * z)
  5, 5                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  orient              // orient light
#end
} 
     
#declare kR = seed(98873);

#macro knot()


cylinder { <0,-0.1,0> <0,0,0> 1
texture 
{
        pigment 
        {
                wood  
                turbulence <0.005+(rand(kR)*0.005), 0.005+(rand(kR)*0.005), 0.0>    
/*
                octaves 5+(rand(kR)*2)
                lambda  2+(rand(kR)*1.5)
*/                
//                omega 0.8   
//                octaves 7
//                lambda  2.5
                omega 0.7+(rand(kR)*0.1)   
                octaves 5+(rand(kR)*2)
                lambda  2+(rand(kR)*1.5)

                #declare ks1=0.2+(rand(kR)*0.1);
                #declare ks2=ks1+0.051+(rand(kR)*0.01);
                #declare ks3=ks2+0.1+(rand(kR)*0.015); 
                
                #declare kCol=0.2+(rand(kR)*0.5);
                
                colour_map
                {
                

                        [0.0            rgb <0.1, 0.021, 0.0>*kCol ]
                        [ks1            rgbt<0.21, 0.0812, 0.0, 0.0>*kCol ]
                        [ks1+0.005      rgbt<0.35, 0.2, 0, 0.1>*kCol ]
                        [ks1+0.01       rgbt<0.4, 0.22, 0.01, 1> ]  
                        [ks1+0.05       rgbt<0.4, 0.22, 0.01, 1> ]  
                        [ks1+0.051      rgbt<0.14, 0.0522, 0.0, 0>*kCol ]  
                        [ks2            rgbt<0.14, 0.0622, 0.001, 0.0>*kCol ]  
                        [ks2+0.005      rgbt<0.4, 0.22, 0.01, 1> ]  
                        [ks2+0.095      rgbt<0.4, 0.22, 0.01, 1> ]  
                        [ks3            rgbt<0.45, 0.27, 0.03, 0.0>*kCol ]  
                        [ks3+0.025      rgbt<0.5, 0.232, 0.051, 0.1>*kCol ]  
                        [ks3+0.026      rgbt <0.5, 0.275, 0.05, 1> ]
                        [1.0    rgbt <0.75, 0.3275, 0.05, 1> ]


                }                  
                scale 2
                rotate <90, 0, 0>
        }
}       
/*texture 
{
        pigment { rgbt <1, 0.9, 0.8, 0.95> }
        finish 
        { 
                specular 0.2
                roughness 0.075
                ambient 0
                diffuse 0.4
                reflection 0.0375
        }        
} 
*/       
scale <0.8+(rand(kR)*0.2), 1, 0.8+(rand(kR)*0.2)>
}
#end


/*
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 0.97, 0.95>*10  // light's color
  translate <-120, 500, 1200>
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 1000
  fade_power 2
#if(useArea)
  area_light
  <0, 0, 0> <200, 200, 200> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  orient              // orient light
#end
} 
     
*/
/*
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 0.95, 0.9>*2  // light's color
  translate <-450, 300, 0>
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 450                                       
  fade_power 2                                            
#if(useArea)
  area_light
  <20, 0, 0> <0, 0, 100> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  orient              // orient light
#end
}
*/





// ----------------------------------------

// room
difference {
        box { <-540, -120, -760> <540, 480, 760> }
        union
        {
                box { <-500, -100, -700> <500, 460, 700> }
                // window
                box { <-150, 150, 699> <150, 420, 761> }                      
        } 
        texture
        {  
                pigment { color rgb <0.75, 0.875, 0.8> }
                finish { ambient 0.0 diffuse 0.4 }  
                // texture component
                normal 
                {
                        average
                        normal_map 
                        {
                                [0.5, granite 0.5 turbulence 0.2 scale 5 ]
                                [0.4, spotted 0.5 turbulence .35 scale 3]
                                [0.3, marble 0.3 turbulence .5]
                                [0.211, bozo 0.5 turbulence .25 scale 0.5]
                        }
                }
        }
} 

// ceiling
box { <-501, 459, -701> <501, 460, 701>     
#if(useTestTex)
        texture
        {  
                pigment { color rgb <0.98, 0.97, 0.97> }
                finish { ambient 0.0 diffuse 0.4 }  
        }
#else
        texture
        {  
                pigment { color rgb <0.98, 0.97, 0.97> }
                finish { ambient 0.0 diffuse 0.4 }  
                // texture component
                normal 
                {
                        average
                        normal_map 
                        {
                                [1, granite turbulence 0.1 scale 5 ]
                                [0.5, spotted turbulence .25 scale 3]
                        }
                }
        }
#end
} 

#if(useTestTex)
#declare covingTex = texture
        {  
                pigment { color rgb <0.98, 0.97, 0.97> }
                finish { ambient 0.0 diffuse 0.5 }  
        }
#else
#declare covingTex = texture
        {  
                pigment { color rgb <0.98, 0.97, 0.97> }
                finish { ambient 0.0 diffuse 0.5 }  
                // texture component
                normal 
                {
                        
                        granite turbulence 0.2 scale 2 
                }
        }
#end

// coving
difference 
{ 
        box { <0, 0, -700> <15, 15, 700> }
        cylinder { <15, 0, -701> <15, 0, 701> 13.5 }
        texture { covingTex }
        translate <-500, 444, 0> 
}               

difference 
{ 
        box { <0, 0, -700> <15, 15, 700> }
        cylinder { <15, 0, -701> <15, 0, 701> 13.5 }
        texture { covingTex }
        rotate <0, 180, 0> 
        translate <500, 444, 0> 
}               

difference 
{ 
        box { <0, 0, -500> <15, 15, 500> }
        cylinder { <15, 0, -701> <15, 0, 701> 13.5 }
        texture { covingTex } 
        rotate <0, 90, 0> 
        translate <0, 444, 700> 
}               

difference 
{ 
        box { <0, 0, -500> <15, 15, 500> }
        cylinder { <15, 0, -701> <15, 0, 701> 13.5 }
        texture { covingTex } 
        rotate <0, -90, 0> 
        translate <0, 444, -700> 
}               




#declare MyPineYellow = colour rgb <0.81, 0.7, 0.32>*0.6;
#declare MyPineOrange = colour rgb <0.5, 0.2, 0>*0.6;
#declare MyPineBrown = colour rgb <0.2, 0.085, 0>*0.6;  



   
#declare MyPine = texture 
{ 
        pigment 
        {       
                ripples  
                turbulence 0.75
                //frequency 2  
                octaves 6
                lambda 2
                omega 2   
                colour_map
                { 
                        [ 0.0 MyPineYellow ]
                        [ 1.001 MyPineOrange ]
                }                  
                scale 50
                rotate <30, 40, 20>
        }          
} 
texture
{
        pigment
        {
                bozo       
                turbulence 0.345   
                colour_map
                {
                        [ 0.0 MyPineYellow+<0, 0, 0, 0.2, 0.3> ] 
                        [ 0.67 MyPineOrange+<0, 0, 0, 0.2, 0.6> ]
                        [ 1.001 MyPineBrown+<0, 0, 0,0.2, 0.8> ]
                }
        }
}        
texture
{
        pigment
        {
                wood       
                turbulence <0.04, 0.75, 0.1>
                octaves 4
                lambda 5  
                omega 1.5
                
                colour_map
                {
                        [ 0.0   MyPineYellow+<0, 0, 0, 0.0, 0.8> ] 
                        [ 0.85  MyPineOrange+<0, 0, 0, 0.0, 0.6> ]
                        [ 1.001 MyPineBrown+ <0, 0, 0, 0.0, 0.3> ]
                }     
                rotate <2, 1, 0>
                scale <0.5, 2, 0.3>                 
        }
}        
texture
{
        pigment
        {
                wood       
                turbulence <0.04, 0.75, 0.1>
                octaves 6
                lambda 9  
                omega 1.0
                
                colour_map
                {
                        [ 0.0   MyPineYellow+<0, 0, 0, 0.0, 0.6> ] 
                        [ 0.6   MyPineYellow+<0, 0, 0, 0.0, 0.7> ] 
                        [ 0.95  MyPineOrange+<0, 0, 0, 0.0, 0.75> ]
                        [ 1.001 MyPineBrown+ <0, 0, 0, 0.0, 0.1> ]
                }     
                rotate <1, -1.25, 0>
                scale <0.625, 0.25, 0.3>                 
        }         
        normal
        {              
                average
                normal_map
                {
                        [ 1, wrinkles 0.5 turbulence 0.115 scale <1, 0.5, 5> ]
                        [ 1, dents 0.5 turbulence 0.115 scale <3, 0.75, 5> rotate <20, 40, 0> ]
                        [ 1, ripples 0.345 turbulence 0.75 octaves 6 lambda 2 omega 2 scale 80 rotate <30, 40, 20> ]
                }
        }          
} 
 
#declare VarnishedPine = texture
{
        MyPine
}
texture 
{
        pigment { rgbt <1, 0.9, 0.8, 0.95> }
        finish 
        { 
                specular 0.2
                roughness 0.075
                ambient 0
                diffuse 0.4
                reflection 0.0375
        }        
}        

#declare RoughVarnishedPine = texture 
{
        bozo
        turbulence 0.124
        texture_map
        { 
                [ 0.0 VarnishedPine ]
                [ 0.7 VarnishedPine ]
                [ 1.001 MyPine ]
        }  
        scale <0.75, 1, 8>            
}                

// floor
// Create 10 balls along X axis, from 0 to 9
#declare plankCount = 0;      
#declare plankRand = seed(14515);
#while (plankCount < 20)                

  #declare pHeight=0+(rand(plankRand)*0.15);
  
  box { <-24.9+(rand(plankRand)*0.2), -3, -700> <24.9-(rand(plankRand)*0.2), pHeight, 700> 

#if(useTestTex)
        texture 
        {
                pigment 
                {
                     color rgb <0.85, 0.7, 0.25> 
                }
                finish 
                {
                        ambient 0.0
                        diffuse 0.4
                        specular 0.65 
                        roughness 0.1 
                        reflection 0.025
                }      
        }

#else 
        texture 
        {     
                RoughVarnishedPine   
                scale 5+(rand(plankRand)*5)
                rotate <rand(plankRand)*1, (rand(plankRand)*0.5), 0>
                translate <-20+(rand(plankRand)*40), -0.5+(rand(plankRand)*1.5), 500+(rand(plankRand)*150)>
                
        } 
#end       

        translate <-500+25+(plankCount*50), 0, 0>
        
                                
  }   
  #declare knotZ=0;
  #while(knotZ < 700)
        object { knot() scale 2+(rand(kR)*4) translate <-23+(rand(kR)*46), pHeight+0.01, knotZ>  translate <-500+25+(plankCount*50), 0, 0>}
        #declare knotZ = knotZ+5+(rand(kR)*60);
  #end
  
  #declare plankCount = plankCount+1;   // increment our counter
#end


// Skirting board
#declare skBoard = union 
{
        difference
        {               
                box { <0, 0, 0> <3, 25, 10> }
                cylinder { <3, 24.001, -0.001> <3, 24.001, 10.001> 1.5 }
        }
        cylinder { <0, 25, 0> <0, 25, 10> 3 }  
        box { <0, 0, 0> <0.5, 28.5, 10> }      
}                                            

#declare skBoardTex = texture
{
        pigment 
        {
                wood
                turbulence 0.1
                octaves 6
                lambda 9  
                omega 1.0
                color_map
                { 
                        [ 0.0 color rgb <0.65, 0.45, 0.175> ]
                        [ 1.001 color rgb <0.3, 0.15, 0.06125> ]
                }            
                scale <0.7, 1.25, 1>
                rotate <0.25, 1.75, 0> 
                translate <-2, -2, 20>
        }
        finish 
        {
                ambient 0.0
                diffuse 0.5
                specular 0.25 
                roughness 0.1 
                reflection 0.005
                diffuse 0.3
        }      

}  
texture {
    pigment { rgbt <0.75, 0.15, 0.0, 0.95> }
    finish { 
        specular 0.1
        roughness 0.1
        ambient 0
        diffuse 0.33
    }
}









object { skBoard  scale <1, 1, 140> texture { skBoardTex } translate <-499.9, 0.5, -700> }
object { skBoard  scale <1, 1, 140> texture { skBoardTex } rotate <0, 180, 0> translate <499.9, 0.5, 700> }
object { skBoard  scale <1, 1, 100> texture { skBoardTex } rotate <0, 90, 0> translate <-500, 0.5, 699.9> }
object { skBoard  scale <1, 1, 100> texture { skBoardTex } rotate <0, -90, 0> translate <500, 0.5, -699.9> }
 
#if(showTV)
object 
{ 
        TV        
        rotate <0, 45, 0>
        translate <420, 0.01, 620> 
}
#end



#if(showPS2)
        object { PS2 rotate <0, 44, 0> translate <400, 16.5, 640> }

        object { DualShock rotate <1, 0, 0> rotate <0, 60, 0> translate <230, 1.95, 416> }
        object { DualShock rotate <1, 0, 0> rotate <0, 33, 0> translate <295, 1.95, 420> }
        
        
          sphere_sweep {
          //linear_spline                 // linear curve
          cubic_spline                // alternative spline curves
          //b_spline
          8,                            // number of specified sphere positions
          <100, 3, 336>, 0.35               // position, radius
          <246, 6, 414>, 0.35                // ...
          <300, 1, 500>, 0.35
          <325, 3, 530>, 0.35  
          <300, 1, 570>, 0.35
          <350, 3, 590>, 0.35  
          <403, 27.5, 628.5>, 0.35  
          <390, 10, 700>, 0.35  
        
          tolerance 0.05             // optional   
        //  bounded_by { box { <-1, -0.75, -6> <1.25, 0.75, 0.1> } }     
          texture { PS2_Grey_Tex }
          } 
        
          sphere_sweep {
          //linear_spline                 // linear curve
          cubic_spline                // alternative spline curves
          //b_spline
          8,                            // number of specified sphere positions
          <180, 3, 326>, 0.35               // position, radius
          <305, 6, 420>, 0.35                // ...
          <335, 1, 500>, 0.35
          <390, 3, 520>, 0.35  
          <410, 1, 550>, 0.35
          <350, 3, 570>, 0.35  
          <408.5, 27.75, 621>, 0.35  
          <390, 10, 700>, 0.35  
        
          tolerance 0.05             // optional   
        //  bounded_by { box { <-1, -0.75, -6> <1.25, 0.75, 0.1> } }     
          texture { PS2_Grey_Tex }
          } 
   
#end
   
    


#if(showBag)
object { Bag scale 3 rotate <0, 60, 0> translate <350, 0, 400> }// translate <193, 0, 485> }
#end

#if (showMarbles)
union
{
#declare mRand=seed(1424);
#declare mCount=0;

#declare mX = 5;
#declare mRot=0;
#while(mCount < 40)


#declare mType=rand(mRand);  
#warning str(mType, 4, 2)    


#switch (mType)
  #range (0.0, 0.1)
        #declare marb = RedMarble;  
  #warning    "Red"
  #break
  #range (0.1, 0.2)
        #declare marb = BlueMarble;
  #warning    "Blue"
  #break
  #range (0.2, 0.3)
        #declare marb = YellowMarble;
  #warning    "Yellow"
  #break
  #range (0.3, 0.4)
        #declare marb = GreenMarble;
  #warning    "Green"
  #break
  #range (0.4, 0.5)
        #declare marb = OrangeMarble;
  #warning    "Orange"
  #break
  #range (0.5, 0.6)
        #declare marb = RGBYMarble;
  #warning    "RGBY"
  #break
  #range (0.6, 0.7)
        #declare marb = RYMarble;
  #warning    "RY"
  #break
  #range (0.7, 0.8)
        #declare marb = PBMarble;
  #warning    "PB"
  #break
  #range (0.8, 0.9)
        #declare marb = GYMarble;
  #warning    "GY"
  #break
  #else
        #declare marb = WierdMarble;     // just to test if this happens..
        #warning    "Wierd"
#end    

  union { marb rotate <rand(mRand)*360, rand(mRand)*360, rand(mRand)*360> scale 0.4 
        translate <mX, 0.675, 0> rotate <0, mRot, 0> 
                #if(usePhotons)
                // photon block for an object
                  photons{
                    target 1.0          // spacing multiplier for photons hitting the object
                    refraction on
                    reflection on
                    //collect off       // ignore photons
                    //pass_through      // do not influence photons
                  }
                #end
        }
#declare mCount = mCount+1;
#declare mX=mX+0.4-(0.75*rand(mRand));
#declare mRot=mRot+(20-mX)+(rand(mRand)*mX);
#if(mRot > 40+(mX*4))
        #declare mX = mX+1.5+(rand(mRand))+(mX/15);
        #declare mRot= -mX;
#end
#end     
scale 3
rotate <0, 40, 0>           

//translate <203, 0, 480>
translate <360, 0, 395>
   
}

#end   


// Coffee table tile

#declare Tile = superellipsoid { <0.1, 0.1> scale <1, 0.05, 1> translate <1, -0.05, 1> 
texture
{
        pigment
        {
                image_map { jpeg "tile.jpg" once } 
                scale 2 rotate <90, 0, 0> 
        }
        finish { specular 0.5 roughness 0.02 ambient 0.0 diffuse 0.4}
        normal { dents 0.45 scale 1.25 turbulence 0.273 }
}
}       

// coffee table leg    

#if(useTestTex)
#declare CoffeeTableTex = texture { pigment { color rgb <0, 1, 0> } finish { phong 0.3 ambient 0.0 diffuse 0.3 } }
#else
#declare CoffeeTableTex = texture 
{
        pigment 
        {
                wood   
                turbulence 0.127 
                octaves 6
                lambda 7  
                omega 1.0

//                octaves 5       
//                lambda 3
                color_map
                { 
                        [ 0.0 color rgb <0.45, 0.3, 0.1> ]
                        [ 1.001 color rgb <0.35, 0.2, 0.01> ]
                }            
                scale <0.6, 0.5, 1>  
                rotate <0, 0, 2>
        }
        finish { ambient 0.0 diffuse 0.3 specular 0.1 roughness 0.15 }  
        normal
        {     
                average
                normal_map
                {
                [1, bump_map 
                { // uses image color or index as bumpiness
                  gif "coffeetabbm.gif" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                  // once           // for no repetitive tiling
                  // [use_color | use_index]
                  bump_size 3     // 0...3      
                } // bump_map
                turbulence 0.224
                scale <8 10, 5>  
                ]
                [0.7, dents turbulence 0.324 scale 3  ]
                }
        }
}        
#end


#declare CoffeeLeg = union
{
        sphere { <0, 0, 0> 5 scale <1.1, 1, 1.1> translate <0, 5, 0> }
        intersection
        {
                superellipsoid { <0.15, 0.15> scale <5, 12, 5> }
                sphere { <0, 0, 0> 1 scale <8.75, 14, 8.75> }    
                bounded_by { sphere { <0, 0, 0> 1 scale <8.76, 14.1, 8.76> } }
                translate <0, 20, 0> 
        }     
        torus { 3.75, 1 translate <0, 33, 0> }
        torus { 3.5, 1 translate <0, 36, 0> }
        torus { 3.75, 1 translate <0, 39, 0> } 
        difference
        {
                cylinder { <0, 0, 0> <0, 12, 0> 3.75 }
                torus { 3.75, 1 scale <1, 1.5, 1> translate <0, 6, 0> }
                translate <0, 31, 0>
        } 
        
        intersection
        {
                superellipsoid { <0.15, 0.15> scale <5, 8, 5> }
                sphere { <0, 0, 0> 1 scale <8.75, 10, 8.75> }    
                bounded_by { sphere { <0, 0, 0> 1 scale <8.76, 10.1, 8.76> } }
                translate <0, 48, 0> 
        }     
        texture { CoffeeTableTex rotate <-90, 0, 0> }        
} 
  
// coffee table      

#declare Table = union
{
        object { CoffeeLeg }
        object { CoffeeLeg translate <120, 0, 0>}
        object { CoffeeLeg translate <0, 0, 70> }
        object { CoffeeLeg translate <120, 0, 70> }    
        // Frame
        superellipsoid { <0.1, 0.1> scale <60, 5, 2> translate <60, 51, 0> }
        superellipsoid { <0.1, 0.1> scale <60, 5, 2> translate <60, 51, 70> }
        superellipsoid { <0.1, 0.1> scale <2, 5, 35> translate <0, 51, 35> }
        superellipsoid { <0.1, 0.1> scale <2, 5, 35> translate <120, 51, 35> } 

        // top wooden part
        difference
        {
                merge
                {
                        superellipsoid { <0.1, 0.1> scale <72, 2.5, 6> translate <60, 55, -6> 
                                texture { CoffeeTableTex rotate <1, 90, 1> }       
                        } 
                        superellipsoid { <0.1, 0.1> scale <72, 2.5, 6> translate <60, 55, 76> 
                                texture { CoffeeTableTex rotate <1, 90, 1> }       
                        }                          
                        superellipsoid { <0.1, 0.1> scale <6, 2.5, 47> translate <-6, 55, 35> 
                                texture { CoffeeTableTex rotate <1, 0, 1> }       
                        }                         
                        superellipsoid { <0.1, 0.1> scale <6, 2.5, 47> translate <126, 55, 35> 
                                texture { CoffeeTableTex rotate <1, 0, 1> }       
                        }                            
                }  
                union
                {
                        cylinder { <0, 0, -20> <0, 0, 20> 0.25 rotate <0, 45, 0> translate <0, 57.5, 0> }
                        box { <-0.02, -10, -20> <0.02, 0, 20> rotate <0, 45, 0> translate <0, 57.5, 0> }                       
                        cylinder { <0, 0, -20> <0, 0, 20> 0.25 rotate <0, -45, 0> translate <120, 57.5, 0> }
                        box { <-0.01, -10, -20> <0.01, 0, 20> rotate <0, -45, 0> translate <120, 57.5, 0> }
                        cylinder { <0, 0, -20> <0, 0, 20> 0.25 rotate <0, 45, 0> translate <120, 57.5, 70> }
                        box { <-0.01, -10, -20> <0.01, 0, 20> rotate <0, 45, 0> translate <120, 57.5, 70> }
                        cylinder { <0, 0, -20> <0, 0, 20> 0.25 rotate <0, -45, 0> translate <0, 57.5, 70> }
                        box { <-0.01, -10, -20> <0.01, 0, 20> rotate <0, -45, 0> translate <0, 57.5, 70> }
                }       
        }
        // grout
        box 
        { 
                <0, 55, 0> <120, 57, 70> 
                texture
                {
                        pigment 
                        { 
                                granite   
                                turbulence 0.2
                                color_map  
                                {
                                        [ 0.0 rgb <0.97, 0.96, 0.85> ]
                                        [ 1.0 rgb <0.98, 0.95, 0.85> ]
                                }     
                                
                        }
                        finish { specular 0.05 roughness 0.25 ambient 0.0 diffuse 0.25 }
                        normal { granite 0.1 turbulence 0.2 }
                }
         
        }   
        // add tiles
        #declare zPos = 0;
        #while (zPos < 70)
                #declare xPos = 0;
                #while(xPos < 120)
                        object { Tile scale 4.75 translate <xPos+0.1, 57.5, zPos+0.1> }
                        #declare xPos=xPos+10;
                #end                         
                #declare zPos=zPos+10;
        #end
        texture { CoffeeTableTex rotate <45, 45, 0>  }        
        
}   


#if(showTable)          
        object { Table rotate <0, -90, 0> translate <420, 0, 320> }   
#end

#declare CBBlack = texture 
{ 
        pigment 
        { 
                marble
                turbulence 0.352
                colour_map 
                {
                        [ 0.0 colour rgb <0, 0, 0> ]
                        [ 0.1 colour rgb <0.03, 0.03, 0.04> ]
                        [ 0.4 colour rgb <0.01, 0.02, 0.03> ]
                        [ 0.5 colour rgb <0.125, 0.13, 0.17> ]
                        [ 0.6 colour rgb <0.021, 0.03, 0.05> ]
                        [ 1.001 colour rgb <0.04, 0.07, 0.1> ]
                }            
                rotate <40, 25, 70>
                scale 4
        }
        finish
        {
                specular 0.4
                roughness 0.125
                ambient 0.0
                diffuse 0.3
                reflection 0.01
        }
}

#declare CBWhite = texture 
{ 
        pigment 
        { 
                marble
                turbulence 0.352
                colour_map 
                {
                        [ 0.0 colour rgb <1, 1, 1> ]
                        [ 0.1 colour rgb <0.9, 0.86, 0.84> ]
                        [ 0.4 colour rgb <0.92, 0.90, 0.84> ]
                        [ 0.5 colour rgb <0.85, 0.80, 0.7> ]
                        [ 0.6 colour rgb <0.921, 0.90, 0.90> ]
                        [ 1.001 colour rgb <0.94, 0.92, 0.9> ]
                }            
                rotate <80, 75, 20>
                scale 5
        }
        finish
        {
                specular 0.4
                roughness 0.125
                ambient 0.0
                diffuse 0.6
                reflection 0.01
        }
}
#declare ChessSurround = union
{
        box { <0, -1, 0> <1, -0.3, 1> }
        height_field { gif "ChessSurround.gif" scale <1, 0.4, 1> translate <0, -0.3, 0> }
        texture 
        {       
         pigment { image_map { jpeg "ChessSurround.jpg" } rotate <90, 0, 0> }
        } 
        finish
        {
                specular 0.6
                roughness 0.08
                ambient 0.0
                diffuse 0.35
                reflection 0.05
        }
}



#if(showChess)
union
{     


        // Chess board
        union
        {       
                #declare yp = 0;
                #while(yp < 8)
                        #declare xp = 0;
                        #while(xp < 8)
                                union
                                {
                                        box { <0, -1, 0> <1, -0.3, 1> }
                                        height_field { gif "ChessSquare.gif" scale <1, 0.3, 1> translate <0, -0.3, 0> }
                                        scale <7.45, 1, 7.45>
                                        translate <0.025, 0.1, 0.025> 
                                        translate <xp*7.5, 0, yp*7.5>
                                        #if(even(yp))
                                                #if(even(xp))
                                                        texture { CBBlack }
                                                #else
                                                        texture { CBWhite }
                                                #end
                                        #else
                                                #if(even(xp))
                                                        texture { CBWhite }
                                                #else
                                                        texture { CBBlack }
                                                #end
                                        #end
                                } 
                                #declare xp = xp+1;
                        #end
                        #declare yp = yp+1;
                #end  

           
                // surround
                object { ChessSurround scale <70, 1, 5> translate <-5, 0, -5> }
                object { ChessSurround scale <60, 1, 5> rotate <0, -90, 0> translate <65, 0, 0> }
                object { ChessSurround scale <60, 1, 5> rotate <0, -90, 0> translate <0, 0, 0> }
                object { ChessSurround scale <70, 1, 5> translate <-5, 0, 60> }
                // wooden surround
                superellipsoid 
                { 
                        <0.075, 0.075> 
                        scale <36, 2, 1> 
                        texture { VarnishedPine scale 4 rotate <-90, 0, -90> }
                        texture { pigment { rgbf <0.8, 0.6, 0.1, 0.975> } finish { specular 0.4 roughness 0.1 ambient 0.0 diffuse 0.3 reflection 0.06 } }
                        
                        translate <30, -1.5, -5> 
                }
                superellipsoid 
                { 
                        <0.075, 0.075> 
                        scale <36, 2, 1> 
                        texture { VarnishedPine scale 4 rotate <-90, 0, -90> }
                        texture { pigment { rgbf <0.8, 0.6, 0.1, 0.975> } finish { specular 0.4 roughness 0.1 ambient 0.0 diffuse 0.3 reflection 0.06 } }
                        translate <30, -1.5, 65> 
                }                 
                superellipsoid 
                { 
                        <0.075, 0.075> 
                        scale <35, 2, 1> 
                        texture { VarnishedPine scale 4 rotate <-90, 0, -90> }
                        texture { pigment { rgbf <0.8, 0.6, 0.1, 0.975> } finish { specular 0.4 roughness 0.1 ambient 0.0 diffuse 0.3 reflection 0.06 } }
                        rotate <0, 90, 0> 
                        translate <-5, -1.5, 30> 
                }
                superellipsoid 
                { 
                        <0.075, 0.075> 
                        scale <35, 2, 1> 
                        texture { VarnishedPine scale 4 rotate <-90, 0, -90> }
                        texture { pigment { rgbf <0.8, 0.6, 0.1, 0.975> } finish { specular 0.4 roughness 0.1 ambient 0.0 diffuse 0.3 reflection 0.06 } }
                        rotate <0, 90, 0> 
                        translate <65, -1.5, 30> 
                }                
        }        
        // chrome pieces   
        #declare pRand = seed(23245);
        
        union
        {
                // Row of pawns
                #declare pCount = 0;
               
                #while(pCount < 8)
                        union
                        {
                                Piece(1.75, 0.2, 0.05, 2.5, tPawn)
                                translate <45+3.75, 0.1, (pCount*7.5)+3.75>      
                                translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                        }      
                        #declare pCount = pCount+1;
                #end
                
                // Other pieces
                union
                {
                        Piece(1.8, 0.2, 0.05, 3.25, tRook)    
                        rotate <0, 0, 0>
                        translate <56.25, 0.1, 3.75>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }  
                union
                {
                        Piece(1.8, 0.2, 0.05, 2, tKnight)    
                        rotate <0, 90, 0>
                        translate <56.25, 0, 11.25>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }  
                union
                {
                        Piece(1.95, 0.2, 0.05, 3.5, tBishop)
                        rotate <0, 90, 0>
                        translate <56.25, 0, 18.75>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }      
                union
                {
                        Piece(2.25, 0.2, 0.05, 4.75, tQueen)
                        rotate <0, 0, 0>
                        translate <56.25, 0, 26.25>     
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }      
                union
                {
                        Piece(2.5, 0.2, 0.05, 5.25, tKing)   
                        rotate <0, 70, 0>  
                        translate <56.25, 0, 33.75>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }      
                union
                {
                        Piece(1.95, 0.2, 0.05, 3.5, tBishop)  
                        rotate <0, 90, 0> 
                        translate <56.25, 0, 41.25>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }      
                union
                {
                        Piece(1.8, 0.2, 0.05, 2, tKnight)    
                        rotate <0, 90, 0>
                        translate <56.25, 0, 48.75>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }  
                union
                {
                        Piece(1.8, 0.2, 0.05, 3.25, tRook)    
                        rotate <0, 0, 0>
                        translate <56.25, 0.1, 56.25>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }  
        

                
                texture { ChromeTex }//T_Wood21 scale 10 }
        }

        // brass pieces
        union
        {
                // Row of pawns
                #declare pCount = 0;
               
                #while(pCount < 8)
                        union
                        {
                                Piece(1.75, 0.2, 0.05, 2.5, tPawn)
                                translate <11.25, 0.1, (pCount*7.5)+3.75>
                                translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                        }      
                        #declare pCount = pCount+1;
                #end
                
                // Other pieces
                union
                {
                        Piece(1.8, 0.2, 0.05, 3.25, tRook)    
                        translate <3.75, 0.1, 3.75>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }  
                union
                {
                        Piece(1.8, 0.2, 0.05, 2, tKnight)    
                        rotate <0, -90, 0>
                        translate <3.75, 0, 11.25>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }  
                union
                {
                        Piece(1.95, 0.2, 0.05, 3.5, tBishop)
                        rotate <0, -90, 0>
                        translate <3.75, 0, 18.75>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }      
                union
                {
                        Piece(2.25, 0.2, 0.05, 4.75, tQueen)
                        rotate <0, 0, 0>
                        translate <3.75, 0, 26.25>     
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }      
                union
                {
                        Piece(2.5, 0.2, 0.05, 5.25, tKing)    
                        rotate <0, -105, 0>
                        translate <3.75, 0, 33.75>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }      
                union
                {
                        Piece(1.95, 0.2, 0.05, 3.5, tBishop)
                        rotate <0, -90, 0>
                        translate <3.75, 0, 41.25>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }      
                union
                {
                        Piece(1.8, 0.2, 0.05, 2, tKnight)    
                        rotate <0, -90, 0>
                        translate <3.75, 0, 48.75>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }  
                union
                {
                        Piece(1.8, 0.2, 0.05, 3.25, tRook)    
                        rotate <0, 0, 0>
                        translate <3.75, 0.1, 56.25>
                        translate <-0.35+(rand(pRand)*0.7), rand(pRand)*0.1, -0.35+(rand(pRand)*0.7)>
                }                          

                
                texture { BrassTex }//T_Wood21 scale 10 }
        }
                        
        rotate <0, 40, 0>
        translate <330, 3.6+57.5, 410>    
          
}

#end

// basket ball
#declare ball = union
{ 
        sphere { <0, 0, 0> 0.995 pigment { color Black } finish { phong 1 phong_size 130 } }
        difference
        {
                sphere { <0, 0, 0> 1 } 
                union
                {
                        box { <-1.1, -1.1, -0.02> <1.1, 1.1, 0.02> }
                        box { <-1.1, -1.1, -0.02> <1.1, 1.1, 0.02> rotate <0, 90, 0> }                        
                        difference
                        {
                                cylinder { <0, -1.1, 0> <0, 1.1, 0> 1 }
                                cylinder { <0, -1.11, 0> <0, 1.11, 0> 0.96 }
                                scale <1, 1, 0.75>
                                translate <1.2, 0, 0>
                        }
                        difference
                        {
                                cylinder { <0, -1.1, 0> <0, 1.1, 0> 1 }
                                cylinder { <0, -1.11, 0> <0, 1.11, 0> 0.96 }
                                scale <1, 1, 0.75>
                                translate <-1.2, 0, 0>
                        }
                }
        }   
        pigment { color rgb <0.55, 0.20, 0> }
        finish { specular 0.3 roughness 0.0005 phong 0.2 phong_size 20 }
        normal { leopard 6 scale 0.008 rotate <90, 0, 0>}
}

#if(showBBall)           
object { ball scale 20 rotate <-40, 15, 20> translate <280, 20.1, 660> }   
#end

#declare HandlePart = 
        merge
        {
                prism 
                {
                    linear_sweep
                    linear_spline
                    0, // height 1
                    .3, // height 2
                    9, // the number of points making up the shape...
                    <1, -1>, <-1, -1>, <-1.5, -0.5>, <-1.5, 0.5>, <-1, 1>, <1, 1>, <1.5, 0.5>, <1.5, -0.5>, <1, -1>
                    translate <0, -0.7, 0>
                }
   
                prism 
                {
                    conic_sweep
                    linear_spline
                    0.9, // height 1
                    1.0, // height 2
                    9, // the number of points making up the shape...
                    <1, -1>, <-1, -1>, <-1.5, -0.5>, <-1.5, 0.5>, <-1, 1>, <1, 1>, <1.5, 0.5>, <1.5, -0.5>, <1, -1>
                      translate <0, -0.9, 0>
                    rotate <180, 0, 0>
                    translate <0, 0, 0>
                    scale <1, 4, 1>
                }                             
                
                prism 
                {
                    linear_sweep
                    linear_spline
                    0, // height 1
                    1, // height 2
                    9, // the number of points making up the shape...
                    <1, -1>, <-1, -1>, <-1.5, -0.5>, <-1.5, 0.5>, <-1, 1>, <1, 1>, <1.5, 0.5>, <1.5, -0.5>, <1, -1>
                    scale <0.9, 17.5, 0.9>
                    translate <0, 0, 0>
                }    
                prism 
                {
                    conic_sweep
                    linear_spline
                    0.8, // height 1
                    1.0, // height 2
                    9, // the number of points making up the shape...
                    <1, -1>, <-1, -1>, <-1.5, -0.5>, <-1.5, 0.5>, <-1, 1>, <1, 1>, <1.5, 0.5>, <1.5, -0.5>, <1, -1>
                      translate <0, -0.8, 0>
                    rotate <180, 0, 0>
                    translate <0, 0, 0>
                    scale <0.9, 4, 0.9>
                    translate <0, 18.3, 0>
                }     
                translate <0, -18.2, 0>
                scale <0.14, 0.09, 0.14>
                
                                           
}
#declare Handle = union
{
        union
        {
                HandlePart scale <0.95, 1, 0.95> 
                pigment
                {
                        colour rgb <0.0, 0.0, 0.0>
                }
                finish 
                {
                        ambient 0.0 diffuse 0.4 specular 0.075 roughness 0.25 
                }
                        
        }       
        difference 
        {       
                union
                {
                        HandlePart 
                        pigment
                        {
                                colour rgb <0.0, 0.0, 0.0>
                        }
                        finish 
                        {
                                ambient 0.0 diffuse 0.4 specular 0.075 roughness 0.25 
                        }
                        normal   
                        {        
                                average
                                normal_map
                                {
                                        [ 1, gradient y, 3 scale .2 rotate <10, 0, 10> ]
                                        [ 1, wrinkles 0.35 scale 0.01 turbulence 0.3756 ]
                                } 
                        }
                }  
                union
                {
                        #declare yPos = -1.8;
                        #declare yRot = 0;
                        #declare ypStep = 0.004;             
                        #declare yrStep = 20;
                        #while(yPos < -0.1)
                                cylinder { <0, 0, -0.3> <0, 0, 0> 0.02 translate <0, yPos, 0> rotate <0, yRot, 0> }
                                #declare yPos=yPos+ypStep;
                                #declare yRot = yRot+yrStep;    
                        #end
                        texture { pigment { color rgb <0.2, 0.35, 0.2> } finish { phong 0 } }
                }
                bounded_by { box { <-0.3, -1.9, -0.3> <0.3, 0.1, 0.3> } }
        }
}
#declare Racket = union
{                         
        
        //head                            
        difference
        {
                torus { 1, 0.03 rotate <-90, 0, 0> translate <0, 1, 0> scale <1, 1.25, 1> }   
                torus { 1.03, 0.009 rotate <-90, 0, 0> translate <0, 1, 0> scale <1, 1.25, 1> }   
        }
        // shaft
        merge
        {
                cone { <0, 0, 0> 0.04 <0, 1.25, 0> 0.0225 }
                cone { <0, 1.25, 0> 0.0225 <0, 2.5, 0> 0.03 }   
                translate <0, -2.5, 0>                                        
        }    
        // cone at top of handle
        merge
        {
                cone { <0, 0, 0> 0.15 <0, 0.5, 0> 0.06 }
                sphere { <0, 0, 0> 0.06 scale <1, 0.25, 1> translate <0, 0.5, 0> }
                translate <0, -3, 0> 
        }                      
        // handle          
        torus { 0.145, 0.01 scale <1, 4.5, 1> translate <0, -3.03, 0> pigment { Black } finish { phong 1 } }
        object { 
                Handle
                translate <0, -3.06, 0>
        }     
        // Strings
        intersection
        {
                cylinder { <0, 0, -0.1> <0, 0, 0.1> 1.03 translate <0, 1, 0> scale <1, 1.25, 1> }
                union
                {
                        #declare StringYPos = 0.35;
                        #declare StringStep = 2.5/22;       
                        #declare zPos = 0.0075;
                        #while(StringYPos < 2.3)
                                cylinder { <-1.1, StringYPos, zPos> <1.1, StringYPos, zPos> 0.005 }
                                #declare StringYPos = StringYPos+StringStep;
                                #declare zPos = zPos*-1;
                        #end
                        #declare StringXPos = -0.9;
                        #declare StringStep = 1/10;       
                        #declare zPos = 0.005;
                        #while(StringXPos < 0.9)
                                cylinder { <StringXPos, -0.1, zPos> <StringXPos, 2.6, zPos> 0.005 }
                                #declare StringXPos = StringXPos+StringStep;
                                #declare zPos = zPos*-1;
                        #end
                        
                }
                texture 
                {
                        pigment { image_map { jpeg "String.jpg" } scale <2, 2.5, 1> translate <-1, 0, 0> }
                        finish { specular 0.5 roughness 0.03 ambient 0 diffuse 0.4 }
                } 
                     
                bounded_by { box { <-1.05, -0.1, -0.04> <1.05, 2.6, 0.04> } }
        
        }    
        texture { pigment { color rgb <0.1, 0.1, 0.1> }  finish { specular 0.9 roughness 0.001 reflection 0.4 ambient 0 diffuse 0.4 } }
}       
 

#declare shuttlePartA = difference
{
        cone { <0, -1, 0> 0.03 <0, 0, 0> 0.015 }
        union
        {
                cone { <0, -1.0001, 0> 0.029 <0, 0.0001, 0> 0.014 }
                box { <-0.1, -1.1, 0> <0.1, 0.1, 0.11> }
                #declare bY = -1.01;
                #declare bX = 0.02;
                #declare bXOff = 0.015/20;
                #declare bYOff = 1/40;
                #while ( bY < 0)
//                        box { <-bX, bY, -0.1> <bX, bY+bYOff, 0.1> }
                        box { <-0.1, bY, -0.1> <-(bX+0.0035), bY+bYOff, 0.1> }
                        box { <-(bX-0.0035), bY, -0.1> <(bX-0.0035), bY+bYOff, 0.1> }
                        box { <bX+0.0035, bY, -0.1> <0.1, bY+bYOff, 0.1> }
                        #declare bY = bY+(bYOff*1.5);
                        #declare bX = bX-bXOff;
                        
                #end                    
        }               
        bounded_by { box { <-0.035, -1.01, -0.035> <0.035, 0.01, 0.035> } }
        
}

#declare shuttlePart = union
{
 /*
        object { shuttlePartA rotate <0, 0, -1.35> }
        object { shuttlePartA rotate <0, 180, 0> rotate <0, 0, 1.35> translate <0.05, 0, 0> }
        */
        object { shuttlePartA translate <-0.0145, 0, 0> rotate <0, 0, -0.85> rotate <0, 5, 0> }
        object { shuttlePartA rotate <0, 180, 0> translate <0.0145, 0, 0> rotate <0, 0, 0.85> rotate <0, -5, 0> }
        rotate <20, 0, 0>
                
}


#declare shuttle = union
{
        #declare pCount = 0;
        #while(pCount < 360)
                object { shuttlePart translate <0, 0, -0.2> rotate <0, pCount, 0> }
                #declare pCount = pCount+13;        
        #end 
        cone { <0, -0.05, 0> 0.2 <0, 0.15, 0> 0.15 }    
        
        merge
        {
                cylinder { <0, 0.15, 0> <0, 0.3, 0> 0.185 }
                sphere { <0, 0.3, 0> 0.185 }
                torus { 0.18, 0.005 translate <0, 0.15, 0>  }   
                texture
                {
                        pigment
                        {                
                                gradient y
                                color_map
                                {
                                        [ 0.0 0.1 colour rgb <1, 0.95, 0.9> colour rgb <1, 0.95, 0.9>  ]
                                        [ 0.1, 0.2 color Red color Red ]
                                        [ 0.2 1.001 colour rgb <1, 0.95, 0.9> colour rgb <1, 0.95, 0.9> ]
                                }
                                scale 0.485
                                translate <0, 0.15, 0>
                        }
                        finish 
                        {
                                phong 0.2 phong_size 1
                                ambient 0 diffuse 0.3
                        }
                        normal
                        {
                                marble 0.2
                                turbulence 0.764
                                scale 0.004
                        } 
                }
        }
        
            
        pigment { rgbt <1, 1, 1, 0.1> } finish { specular 0.5 roughness 0.05 ambient 0.0 diffuse 0.6  }

}

/*
object { shuttle translate <0, 2, 0> }
object { shuttle rotate <90, 0, 0> translate <-3, 2, 0> }
object { shuttle rotate <-90, 0, 0> translate <3, 2, 0> }
*/
#if(showRacket)
        object { Racket translate <0, -2.5, 0> scale 15 rotate <91.25, -220, 0> translate <290, 0.46, 440> }
        object { Racket translate <0, -2.5, 0> scale 15 rotate <89, 40, 0> translate <290, 4.2, 540> }

        object { shuttle translate <0, 1, 0> scale 8 translate <280, 0, 480> }
        object { shuttle translate <0, -0.485, 0> scale 8 rotate <0, 0, -110> rotate <0, -20, 0> translate <270, 1.49, 490> }
#end

