#declare Clou = sphere {
   <0, 0, 0>, 0.02
   
   texture {
      pigment {
         color rgb <0.513725, 0.513725, 0.513725>
      }
      
      finish {
         metallic 1.1
         specular 0.5
         roughness 0.1
         
         reflection {
            rgb <0.298039, 0.298039, 0.298039>
            fresnel
         }
      }
   }
   scale 1
   rotate <0, 0, 0>
   translate z*(-0.98)
}

#declare Clou5 = union {
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate x*0.06
   }
   
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate x*(-0.06)
   }
   
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate x*0.12
   }
   
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate x*(-0.12)
   }
}

#declare Clou4 = union {
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate x*0.06
   }
   
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate x*0.12
   }
}

#declare ChaiseBois = texture {
   pigment {
      wood
      turbulence <0.2, 0.2, 0.2>
      scale 0.04
      
      pigment_map {
         [ 0 color rgb <0.423529, 0.258824, 0.211765>
         ]
         [ 0.9 color rgb <0.278431, 0.168627, 0.137255>
         ]
      }
   }
   
   finish {
      specular 0.1
      roughness 0.05
      
      reflection {
         rgb <0.0156863, 0.0156863, 0.0156863>
      }
   }
}

#declare BarreChaise = union {
   difference {
      union {
         box {
            <-1.05, 0, -1>, <1.05, -0.2, -1.05>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Clou5
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Clou5
            scale 1
            rotate <0, 0, 0>
            translate x*0.3
         }
         
         object {
            Clou5
            scale 1
            rotate <0, 0, 0>
            translate x*0.6
         }
         
         object {
            Clou4
            scale 1
            rotate <0, 0, 0>
            translate x*0.78
         }
         
         object {
            Clou5
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.3)
         }
         
         object {
            Clou5
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.6)
         }
         
         object {
            Clou4
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.9)
         }
         
         object {
            Clou
            scale 1
            rotate <0, 0, 0>
            translate <-0.96, 0, 0.02>
         }
      }
      
      cylinder {
         <-1, 0, 0>, <1, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <0, -0.06, -1.05>
      }
      
      cylinder {
         <-1, 0, 0>, <1, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <0, -0.14, -1.05>
      }
      
      sphere {
         <0, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <-1, -0.14, -1.05>
      }
      
      sphere {
         <0, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <1, -0.14, -1.05>
      }
      
      sphere {
         <0, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <1, -0.06, -1.05>
      }
      
      sphere {
         <0, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <-1, -0.06, -1.05>
      }
      
      texture {
         ChaiseBois
      }
   }
   
   union {
      box {
         <0.07, -0.3, 0.07>, <-0.07, 0, -0.07>
      }
      
      sphere {
         <0, 0, 0>, 0.065
         scale <1, 1.1, 1>
         translate y*(-0.35)
      }
      
      torus {
         0.065, 0.01
         translate y*(-0.35)
      }
      
      sphere {
         <0, 0, 0>, 0.065
         translate y*(-0.45)
      }
      
      cone {
         <0, -0.45, 0>, 0.065,
         <0, -1.6, 0>, 0.05
      }
      
      sphere {
         <0, 0, 0>, 0.05
         scale <1, 0.5, 1>
         translate y*(-1.6)
      }
      
      sphere {
         <0, 0, 0>, 0.05
         scale <1, 0.5, 1>
         translate y*(-1.64)
      }
      
      cone {
         <0, -1.65, 0>, 0.04,
         <0, -1.7, 0>, 0.035
         translate <0, 0, 0>
      }
      translate <-1.015, 0, -1.015>
   }
   
   texture {
      ChaiseBois
   }
}

#declare Chaise = union {
   //*PMName Chaise
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1, 0, -1>, <-0.5, 0, -1>, <0.5, 0, -1>, <1, 0, -1>,
      <-1, 0, -0.5>, <-0.5, 0.4, -0.5>, <0.5, 0.4, -0.5>, <1, 0, -0.5>,
      <-1, 0, 0.5>, <-0.5, 0.4, 0.5>, <0.5, 0.4, 0.5>, <1, 0, 0.5>,
      <-1, 0, 1>, <-0.5, 0, 1>, <0.5, 0, 1>, <1, 0, 1>
      //*PMRawBegin
      uv_mapping texture {
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Unplugged/textures/coussin.png"
            }
         }
      }
      //*PMRawEnd
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      BarreChaise
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      BarreChaise
      scale 1
      rotate y*90
      translate <0, 0, 0>
   }
   
   object {
      BarreChaise
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   object {
      BarreChaise
      scale 1
      rotate y*(-90)
      translate <0, 0, 0>
   }
   
   union {
      box {
         <0.07, 0.15, 0.14>, <-0.07, 0, 0>
         translate x*(-1.015)
      }
      
      box {
         <0.07, 0.15, 0.14>, <-0.07, 0, 0>
         translate x*1.015
      }
      
      union {
         union {
            //*PMName Clous
            
            object {
               Clou5
               rotate z*90
               translate <0, 0.44, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 0.74, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 1.04, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 1.34, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 1.64, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 1.94, 0.98>
            }
            
            object {
               Clou4
               rotate z*90
               translate <0, 2.12, 0.98>
            }
            translate x*(-0.965)
         }
         
         union {
            //*PMName Clous2
            
            object {
               Clou5
               rotate z*90
               translate <0, 0.44, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 0.74, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 1.04, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 1.34, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 1.64, 0.98>
            }
            
            object {
               Clou5
               rotate z*90
               translate <0, 1.94, 0.98>
            }
            
            object {
               Clou4
               rotate z*90
               translate <0, 2.12, 0.98>
            }
            translate x*0.965
         }
         
         union {
            //*PMName Clous3
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate x*0.3
            }
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate x*0.6
            }
            
            object {
               Clou4
               scale 1
               rotate <0, 0, 0>
               translate x*0.78
            }
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.3)
            }
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.6)
            }
            
            object {
               Clou4
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.9)
            }
            rotate x*(-90)
            translate y*3.24
         }
         
         union {
            //*PMName Clous4
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate x*0.3
            }
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate x*0.6
            }
            
            object {
               Clou4
               scale 1
               rotate <0, 0, 0>
               translate x*0.78
            }
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.3)
            }
            
            object {
               Clou5
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.6)
            }
            
            object {
               Clou4
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.9)
            }
            rotate x*(-90)
            translate y*1.3
         }
         
         box {
            <0.07, 2.38, 0.14>, <-0.07, 0, 0>
            translate x*(-1.015)
         }
         
         box {
            <0.07, 2.38, 0.14>, <-0.07, 0, 0>
            translate x*1.015
         }
         
         box {
            <-1, 2.38, 0.14>, <1, 2.24, 0>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-1, 0.14, 0.14>, <1, 0, 0>
            scale 1
            rotate <0, 0, 0>
            translate y*0.2
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-1, 0, -1>, <-0.5, 0, -1>, <0.5, 0, -1>, <1, 0, -1>,
            <-1, 0, -0.5>, <-0.5, 0.4, -0.5>, <0.5, 0.4, -0.5>, <1, 0, -0.5>,
            <-1, 0, 0.5>, <-0.5, 0.4, 0.5>, <0.5, 0.4, 0.5>, <1, 0, 0.5>,
            <-1, 0, 1>, <-0.5, 0, 1>, <0.5, 0, 1>, <1, 0, 1>
            //*PMRawBegin
            uv_mapping texture {
               pigment {
                  image_map {
                     png
                     "/home/tom/RayTrace/Unplugged/textures/coussin.png"
                  }
               }
            }
            //*PMRawEnd
            scale 1
            rotate <90, 180, 0>
            translate <0, 1.29, -0.0001>
         }
         rotate x*8
         translate y*0.15
      }
      translate z*0.945
      
      texture {
         ChaiseBois
      }
   }
   translate y*1.7
}

// Herbe
#declare Herbe = union {
   //*PMRawBegin
   #include "grass.inc"
   //*PMRawEnd
   
   pigment {
      color rgb <0.584314, 0.627451, 0.254902>
   }
   scale 1
}

#declare Herbe30 = union {
   object {
      Herbe
      scale 0.1
      translate <0, 0, 0>
   }
   
   object {
      Herbe
      scale 0.1
      translate x*5
   }
   
   object {
      Herbe
      scale 0.1
      translate x*10
   }
   
   object {
      Herbe
      scale 0.1
      translate x*15
   }
   
   object {
      Herbe
      scale 0.1
      translate x*20
   }
   
   object {
      Herbe
      scale 0.1
      translate x*25
   }
}

#declare Herbe60 = union {
   object {
      Herbe30
      translate <0, 0, 0>
   }
   
   object {
      Herbe30
      translate x*30
   }
}

#declare HerbePlaque = union {
   union {
      object {
         Herbe60
         translate <0, 0, 0>
      }
      
      object {
         Herbe60
         translate z*5
      }
      
      object {
         Herbe60
         translate z*10
      }
      
      object {
         Herbe60
         translate z*15
      }
   }
   
   union {
      object {
         Herbe60
         translate <0, 0, 0>
      }
      
      object {
         Herbe60
         translate z*5
      }
      
      object {
         Herbe60
         translate z*10
      }
      
      object {
         Herbe60
         translate z*15
      }
      translate z*20
   }
   
   union {
      object {
         Herbe60
         translate <0, 0, 0>
      }
      
      object {
         Herbe60
         translate z*5
      }
      
      object {
         Herbe60
         translate z*10
      }
      
      object {
         Herbe60
         translate z*15
      }
      translate <60, 0, 20>
   }
   
   union {
      object {
         Herbe60
         translate <0, 0, 0>
      }
      
      object {
         Herbe60
         translate z*5
      }
      
      object {
         Herbe60
         translate z*10
      }
      
      object {
         Herbe60
         translate z*15
      }
      translate x*60
   }
}

#declare GazonMaudit = union {
   //*PMName GazonMaudit
   
   object {
      HerbePlaque
      translate <9, 0, 40>
   }
   
   object {
      HerbePlaque
      translate <18, 0, 80>
   }
   
   object {
      HerbePlaque
      translate <29, 0, 120>
   }
   translate z*50
}

// Grillage
#declare MatGrid = texture {
   pigment {
      color rgb <0.584314, 0.654902, 0.6>
   }
   
   finish {
      metallic 1.2
   }
}

#declare Grid = union {
   //*PMRawBegin
   cylinder {
      <0.025, 0.025, 0>, <0, 0, 0>, 0.003
      rotate z*4
   }
   
   cylinder {
      <0.025, 0.025, 0>, <0, 0, 0>, 0.003
      rotate z*(-94)
   }
   
   cylinder {
      <0, 0, 0>, <-0.025, -0.025, 0>, 0.003
      rotate z*4
   }
   
   cylinder {
      <0, 0, 0>, <-0.025, -0.025, 0>, 0.003
      rotate z*(-94)
   }
   //*PMRawEnd
}

#declare Grid2 = union {
   object {
      Grid
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Grid
      scale 1
      rotate <0, 0, 0>
      translate y*0.05
   }
   
   object {
      Grid
      scale 1
      rotate <0, 0, 0>
      translate x*0.05
   }
   
   object {
      Grid
      scale 1
      rotate <0, 0, 0>
      translate <0.05, 0.05, 0>
   }
   scale 2
   
   texture {
      MatGrid
   }
}

#declare GridColonne = union {
   object {
      Grid2
      translate y*1.8
   }
   
   object {
      Grid2
      translate y*1.6
   }
   
   object {
      Grid2
      translate y*1.4
   }
   
   object {
      Grid2
      translate y*1.2
   }
   
   object {
      Grid2
      translate y*1
   }
   
   object {
      Grid2
      translate y*0.8
   }
   
   object {
      Grid2
      translate y*0.6
   }
   
   object {
      Grid2
      translate y*0.4
   }
   
   object {
      Grid2
      translate y*0.2
   }
   
   object {
      Grid2
      translate <0, 0, 0>
   }
   translate z*(-0.03)
}

#declare GridPlaque = union {
   object {
      GridColonne
      scale 1
      rotate <0, 0, 0>
      translate <0.05, 0.17, 0>
   }
   
   object {
      GridColonne
      scale 1
      rotate <0, 0, 0>
      translate <0.25, 0.17, 0>
   }
   
   object {
      GridColonne
      scale 1
      rotate <0, 0, 0>
      translate <0.45, 0.17, 0>
   }
   
   object {
      GridColonne
      scale 1
      rotate <0, 0, 0>
      translate <0.65, 0.17, 0>
   }
   
   object {
      GridColonne
      scale 1
      rotate <0, 0, 0>
      translate <0.85, 0.17, 0>
   }
   
   object {
      GridColonne
      scale 1
      rotate <0, 0, 0>
      translate <1.05, 0.17, 0>
   }
}

#declare PanGrillage = union {
   box {
      <-0.025, 0.1, -0.01>, <0.025, 2.15, 0.01>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.05, 0, -0.05>, <0.05, 0.1, 0.05>
      
      pigment {
         color rgb <0.564706, 0.564706, 0.564706>
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 0.11, -0.03>, <2.4, 0.11, -0.03>, 0.005
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 2.13, -0.03>, <2.4, 2.13, -0.03>, 0.005
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 1.15, -0.02>, <2.4, 1.15, -0.02>, 0.005
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      GridPlaque
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      GridPlaque
      scale 1
      rotate <0, 0, 0>
      translate x*1.2
   }
   
   texture {
      MatGrid
   }
}

#declare Grillage = union {
   //*PMName Grillage
   
   object {
      PanGrillage
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      PanGrillage
      scale 1
      rotate <0, 0, 0>
      translate x*(-2.4)
   }
   
   object {
      PanGrillage
      scale 1
      rotate <0, 0, 0>
      translate x*2.4
   }
   
   object {
      PanGrillage
      scale 1
      rotate <0, 0, 0>
      translate x*4.8
   }
   
   // No prototype for lien d'objet
   scale 8
   translate <40, -0.5, 80>
}

// Pylones
#declare Isolantorus = union {
   torus {
      0.09, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   torus {
      0.09, 0.03
      scale 1
      rotate <0, 0, 0>
      translate y*0.07
   }
   
   torus {
      0.09, 0.03
      scale 1
      rotate <0, 0, 0>
      translate y*0.14
   }
   
   torus {
      0.09, 0.03
      scale 1
      rotate <0, 0, 0>
      translate y*0.21
   }
   
   torus {
      0.09, 0.03
      scale 1
      rotate <0, 0, 0>
      translate y*0.28
   }
}

#declare CableElectrique = sphere_sweep {
   cubic_spline,
   5,
   <0, 0, 0>,0.04
   <0, 0, 0>,0.04
   <0, -4.5, -40>,0.04
   <0, 0, -80>,0.04
   <0, 0, -80>,0.04
}

#declare Quadrolite = union {
   //*PMName Quadrolite
   
   union {
      cylinder {
         <0, 0, 0>, <0.3, 0, 0>, 0.02
      }
      
      sphere {
         <0.3, 0, 0>, 0.03
      }
      rotate z*45
   }
   
   union {
      cylinder {
         <0, 0, 0>, <0.3, 0, 0>, 0.02
      }
      
      sphere {
         <0.3, 0, 0>, 0.03
      }
      rotate z*(-45)
   }
   
   union {
      cylinder {
         <0, 0, 0>, <0.3, 0, 0>, 0.02
      }
      
      sphere {
         <0.3, 0, 0>, 0.03
      }
      rotate z*(-135)
   }
   
   union {
      cylinder {
         <0, 0, 0>, <0.3, 0, 0>, 0.02
      }
      
      sphere {
         <0.3, 0, 0>, 0.03
      }
      rotate z*135
   }
}

#declare LigneHT = union {
   //*PMName LigneHT
   
   object {
      //*PMName Quadrolite
      Quadrolite
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      CableElectrique
      translate <0.2122, -0.2122, 0>
   }
   
   object {
      CableElectrique
      translate <0.2122, 0.2122, 0>
   }
   
   object {
      CableElectrique
      translate <-0.2122, -0.2122, 0>
   }
   
   object {
      CableElectrique
      translate <-0.2122, 0.2122, 0>
   }
   
   object {
      //*PMName Quadrolite
      Quadrolite
      translate <0, -4.5, -40>
   }
}

#declare Isolant = union {
   difference {
      cylinder {
         <0, 0, 0>, <0, 1.7, 0>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         Isolantorus
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         Isolantorus
         scale 1
         rotate <0, 0, 0>
         translate y*0.35
      }
      
      object {
         Isolantorus
         scale 1
         rotate <0, 0, 0>
         translate y*0.7
      }
      
      object {
         Isolantorus
         scale 1
         rotate <0, 0, 0>
         translate y*1.05
      }
      
      object {
         Isolantorus
         scale 1
         rotate <0, 0, 0>
         translate y*1.4
      }
      
      pigment {
         color rgb <0.180392, 0.290196, 0.160784>
      }
   }
   
   cone {
      <0, 2, 0>, 0.02,
      <0, 1.7, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere_sweep {
      cubic_spline,
      6,
      <0, 0.272248, 0.00446572>,0.02
      <0, 0.488836, 0.0223286>,0.02
      <0, 0.318919, 0.19406>,0.02
      <0, 0.101423, 0.201315>,0.02
      <0, 0, 0>,0.02
      <0, 0, 0>,0.02
   }
   
   sphere_sweep {
      cubic_spline,
      6,
      <0, 0.49514, -0.0437359>,0.02
      <0, 0.499028, -0.0379045>,0.02
      <0, 0.31892, -0.187291>,0.02
      <0, 0.10142, -0.20131>,0.02
      <0, 0, 0>,0.02
      <0, 0, 0>,0.02
      translate y*0.2
   }
   
   cylinder {
      <0, 0, 0>, <0, -0.2, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      //*PMName Fil
      
      sphere {
         <0, 0, 0>, 0.04
      }
      
      object {
         LigneHT
      }
      translate y*(-0.2)
   }
   
   pigment {
      color rgbft <0.309804, 0.309804, 0.309804, 0.1, 0.4>
   }
}

#declare pylquart = union {
   //*PMName Pylone
   
   union {
      //*PMName Etage1
      
      cylinder {
         <-4, 0, -4>, <-3, 4.7, -3>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <3, 4.7, -3>, <-3, 4.7, -3>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-2.1888, 2.4468, -3.353>, <-3, 4.7, -3>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-2.18883, 2.44683, -3.353>, <-3.34752, 2.44761, -3.38099>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-3.07986, 1.4158, -3.60181>, <-3.40556, 2.44631, -3.3612>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-2.15864, 2.49222, -3.33808>, <-3.8426, 0.61552, -3.8328>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-2.1586, 2.4922, -3.3381>, <0, 4.7, -3.001>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <3.0799, 1.4158, -3.6018>, <3.4056, 2.44627, -3.35965>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <2.1888, 2.4468, -3.353>, <3, 4.7, -3>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <2.1888, 2.4468, -3.353>, <3.3475, 2.44602, -3.35337>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <2.1586, 2.4922, -3.3381>, <3.8426, 0.61552, -3.8328>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <2.1586, 2.4922, -3.3381>, <0, 4.7, -3.001>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   union {
      //*PMName Etage2
      
      cylinder {
         <-3, 3.7, -3>, <-2.3, 7.5, -2.3>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-2.3, 7.5, -2.3>, <2.3, 7.5, -2.3>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-3, 3.7, -3>, <0, 7.5, -2.3>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <3, 3.7, -3>, <0, 7.5, -2.3>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-2.5933, 6, -2.5682>, <-1.1686, 6, -2.5682>, 0.04
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <2.5933, 6, -2.5682>, <1.1686, 6, -2.5682>, 0.04
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-2.7664, 5, -2.75>, <-1.9772, 5, -2.75>, 0.04
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <2.7664, 5, -2.75>, <1.9772, 5, -2.75>, 0.04
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      translate y*1
   }
   
   union {
      //*PMName Etages
      
      cylinder {
         //*PMName Etagex
         <-1, 30, -1>, <-2.3, 6, -2.3>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         //*PMName Etage3
         
         cylinder {
            <-2.1925, 10, -2.0883>, <2, 10, -2.0883>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-2.18, 8, -2.18>, <0, 6, -2.3>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <2.18, 8, -2.18>, <0, 6, -2.3>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-2.2679, 6.024, -2.3018>, <-1.2435, 7.1393, -2.2425>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <2.2679, 6.024, -2.3018>, <1.2435, 7.1393, -2.2425>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-2.18, 8, -2.18>, <0, 10.017, -2.0841>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <2.18, 8, -2.18>, <0, 10.017, -2.0841>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-2.1925, 10, -2.0883>, <-1.14386, 8.95844, -2.12891>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <2.1925, 10, -2.0883>, <1.1439, 8.9584, -2.1289>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Etage4
         
         cylinder {
            <-1.88, 14, -1.86>, <1.88, 14, -1.86>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.9841, 12.0042, -1.97667>, <0, 10.0125, -2.07667>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.9841, 12, -1.9767>, <0, 14.0253, -1.85566>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.9841, 12.004, -1.9767>, <0, 10.012, -2.0767>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.9841, 12, -1.9767>, <0, 14.025, -1.8557>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.88, 14, -1.86>, <-0.947237, 13.0626, -1.91417>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.88, 14, -1.86>, <0.962755, 13.0585, -1.9142>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-2.1925, 10, -2.0883>, <-1.08796, 11.1002, -2.03057>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <2.1925, 10, -2.0883>, <1.088, 11.1, -2.0306>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Etage5
         
         cylinder {
            <-1.7, 17, -1.69>, <1.7, 17, -1.69>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.7893, 15.5, -1.7815>, <0, 14, -1.8575>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.7893, 15.5, -1.7815>, <0, 17.0051, -1.68822>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.7893, 15.5, -1.7815>, <0, 14, -1.8575>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.7893, 15.5, -1.7815>, <0, 17.005, -1.6882>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.7893, 15.5, -1.7815>, <0, 14, -1.8575>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.7, 17, -1.69>, <-0.950012, 16.2023, -1.74394>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.7, 17, -1.69>, <0.95001, 16.202, -1.7439>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.88, 14, -1.86>, <-1.03902, 14.8791, -1.81417>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.88, 14, -1.86>, <1.039, 14.879, -1.8142>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Etage6
         
         cylinder {
            <-1.57, 19.5, -1.56>, <1.57, 19.5, -1.56>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.6405, 18.231, -1.6209>, <0, 17, -1.6954>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.6405, 18.231, -1.6209>, <0, 19.5, -1.56277>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.6405, 18.231, -1.6209>, <0, 17, -1.6954>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.6405, 18.231, -1.6209>, <0, 19.5, -1.5628>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.57, 19.5, -1.56>, <-0.966845, 18.754, -1.59849>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.57, 19.5, -1.56>, <0.96684, 18.754, -1.5985>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.7, 17, -1.69>, <-0.785498, 17.6059, -1.65954>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.7, 17, -1.69>, <0.7855, 17.606, -1.6595>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Etage7
         
         cylinder {
            <-1.46, 21.8, -1.45>, <1.46, 21.8, -1.45>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.5232, 20.593, -1.45>, <0, 19.502, -1.5661>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.5232, 20.593, -1.45>, <0, 21.8, -1.4411>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.5232, 20.593, -1.45>, <0, 19.502, -1.5661>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.5232, 20.593, -1.45>, <0, 21.8, -1.4411>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.46, 21.8, -1.45>, <-0.818878, 21.1799, -1.47083>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.46, 21.8, -1.45>, <0.81888, 21.18, -1.4708>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.57, 19.5, -1.56>, <-0.969106, 20.2001, -1.52409>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.57, 19.5, -1.56>, <0.96911, 20.2, -1.5241>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Etage8
         
         cylinder {
            <-1.33, 24, -1.3>, <1.33, 24, -1.3>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.3839, 22.949, -1.3821>, <0, 21.803, -1.4389>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.3839, 22.949, -1.3821>, <0, 24.0124, -1.32605>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.3839, 22.948, -1.3821>, <0, 21.803, -1.4389>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.3839, 22.949, -1.3821>, <0, 24.012, -1.326>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.33, 24, -1.3>, <-0.801773, 23.396, -1.35805>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.33, 24, -1.3>, <0.80177, 23.396, -1.358>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0.798185, 22.4726, -1.4125>, <1.46, 21.8, -1.45>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-0.79819, 22.473, -1.4125>, <-1.46, 21.8, -1.45>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Etage9
         
         cylinder {
            <-1.23, 26, -1.21>, <1.23, 26, -1.21>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.2865, 25.0389, -1.27924>, <0, 23.9826, -1.31153>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.2865, 25.0404, -1.28808>, <0, 26.007, -1.2133>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.2865, 25.0389, -1.28366>, <0, 23.983, -1.3115>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.2865, 25.0389, -1.27776>, <0, 26.007, -1.2133>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.23, 26, -1.21>, <-0.750851, 25.4387, -1.25897>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.23, 26, -1.21>, <0.75085, 25.439, -1.259>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.33, 24, -1.3>, <-0.786753, 24.6263, -1.28646>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.33, 24, -1.3>, <0.78675, 24.626, -1.2865>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Etage10
         
         cylinder {
            <-1.11, 28, -1.1>, <1.11, 28, -1.1>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.12385, 28.007, -1.10012>, <1.22403, 26.0067, -1.21237>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.1239, 28.007, -1.1001>, <-1.224, 26.007, -1.2124>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Etage11
         
         cylinder {
            <-1, 29.9, -1>, <1, 29.9, -1>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.01003, 29.9149, -0.99455>, <1.10582, 28.0066, -1.0975>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <1.01, 29.915, -0.99455>, <-1.1058, 28.007, -1.0975>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Last
         
         cylinder {
            <-1, 30, -1>, <-0.8, 31.5, -0.8>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-0.8, 31.5, -0.8>, <0.8, 31.5, -0.8>, 0.04
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-0.8, 31.5, -0.8>, <0.982733, 29.9364, -1.00519>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0.8, 31.5, -0.8>, <-0.98273, 29.936, -1.0052>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      translate y*2.5
   }
}

#declare Porteur1 = union {
   //*PMName Porteur
   
   cylinder {
      <-1.11, 29.5, 1.1>, <-6, 29.5, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-1.0028, 31.406, 1.0057>, <-6, 29.5, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-2.5, 30.859, 0.70408>, <-2.5, 29.505, 0.7867>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-3.9, 30.27, 0.41302>, <-3.9, 29.505, 0.45503>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-1.11, 29.5, -1.1>, <-6, 29.5, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-1.0028, 31.406, -1.0057>, <-6, 29.5, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-2.5, 30.859, -0.70408>, <-2.5, 29.505, -0.7867>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-2.5, 30.859, -0.70408>, <-1.10956, 29.4987, -0.991891>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-2.5, 30.859, 0.70408>, <-1.1096, 29.499, 0.99189>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-3.9, 30.27, -0.41302>, <-2.50933, 29.4936, -0.788518>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-3.9, 30.27, 0.41302>, <-2.5093, 29.494, 0.78852>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-3.9, 30.27, -0.41302>, <-3.9, 30.27, 0.42282>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <-2.5, 30.859, -0.7>, <-2.5, 30.859, 0.7>, 0.035
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Isolant
      scale 1
      rotate <0, 0, 0>
      translate <-5.92303, 27.4965, 0>
   }
   translate y*1
}

#declare Porteur2 = union {
   cylinder {
      <-1.46, 21.8, -1.45>, <-8, 21.8, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-1.46, 21.8, 1.45>, <-8, 21.8, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-1.35025, 24.0032, -1.31889>, <-8, 21.8, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-1.3502, 24.003, 1.3189>, <-8, 21.8, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.1, 21.803, -1.075>, <-3.1, 23.42, -0.97543>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.1, 21.803, 1.075>, <-3.1, 23.42, 0.97543>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-1.38828, 21.7865, -1.30867>, <-3.1, 23.42, -0.97543>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-1.3883, 21.787, 1.3087>, <-3.1, 23.42, 0.97543>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-5, 21.783, -0.65425>, <-5, 22.79, -0.58814>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-5, 21.783, 0.65425>, <-5, 22.79, 0.58814>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.08816, 21.7975, -1.0859>, <-5, 22.79, -0.58814>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.0882, 21.797, 1.0859>, <-5, 22.79, 0.58814>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-5, 22.79, 0.58814>, <-5, 22.79, -0.58814>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.1, 23.42, 0.97543>, <-3.1, 23.42, -0.97543>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   object {
      Isolant
      scale 1
      rotate <0, 0, 0>
      translate <-7.91682, 21.2792, 0>
   }
   translate y*1
}

#declare Porteur3 = union {
   cylinder {
      <-1.88, 14, -1.86>, <-7, 14, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-1.71488, 16.9995, -1.6975>, <-7, 14, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.2, 16.175, -1.2151>, <-3.2, 13.992, -1.3705>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.2, 16.175, -1.2151>, <-1.9, 14.0046, -1.85194>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-4.8, 15.263, -0.7059>, <-4.8, 13.98, -0.79903>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-4.8, 15.263, -0.7059>, <-3.19995, 14.0056, -1.37721>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-1.88, 14, 1.86>, <-7, 14, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-1.7149, 17, 1.6975>, <-7, 14, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.2, 16.175, 1.2151>, <-3.2, 13.992, 1.3705>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.2, 16.175, 1.2151>, <-1.9, 14.005, 1.8519>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-4.8, 15.263, 0.7059>, <-4.8, 13.98, 0.79903>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-4.8, 15.263, 0.7059>, <-3.2, 14.006, 1.3772>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-3.2, 16.175, -1.2151>, <-3.2, 16.175, 1.2151>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   cylinder {
      <-4.8, 15.263, 0.79903>, <-4.8, 15.263, -0.79903>, 0.04
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   object {
      Isolant
      scale 1
      rotate <0, 0, 0>
      translate <-6.91544, 13.5041, 0>
   }
   translate y*1
}

#declare Pylone = union {
   object {
      pylquart
      scale 1
      rotate <-0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      pylquart
      scale 1
      rotate y*90
      translate <0, 0, 0>
   }
   
   object {
      pylquart
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   object {
      pylquart
      scale 1
      rotate y*(-90)
      translate <0, 0, 0>
   }
   
   object {
      Porteur1
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Porteur1
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   object {
      Porteur2
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Porteur2
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   object {
      Porteur3
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Porteur3
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   union {
      //*PMName Fil2
      
      sphere_sweep {
         cubic_spline,
         5,
         <0, 34.05, 0.8>,0.015
         <0, 34.05, 0.8>,0.015
         <0, 31, 40>,0.015
         <0, 34.05, 79.2>,0.015
         <0, 34.05, 79.2>,0.015
      }
      
      cylinder {
         <0, 34.05, -0.8>, <0, 34.05, 0.8>, 0.015
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      pigment {
         color rgbt <0.41176, 0.41176, 0.41176, 0.1>
      }
   }
   
   pigment {
      color rgb <0.709804, 0.709804, 0.709804>
   }
}

#declare Pylone_0 = union {
   object {
      Porteur1
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Porteur1
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   object {
      Porteur2
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Porteur2
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   object {
      Porteur3
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Porteur3
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   union {
      //*PMName Fil2
      
      sphere_sweep {
         cubic_spline,
         5,
         <0, 34.05, 0.8>,0.015
         <0, 34.05, 0.8>,0.015
         <0, 31, 40>,0.015
         <0, 34.05, 79.2>,0.015
         <0, 34.05, 79.2>,0.015
      }
      
      cylinder {
         <0, 34.05, -0.8>, <0, 34.05, 0.8>, 0.015
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      pigment {
         color rgb <0, 0, 0>
      }
   }
   
   pigment {
      color rgb <0.709804, 0.709804, 0.709804>
   }
}

#declare Pylones = union {
   //*PMName Pylones
   
   object {
      //*PMName Pylone0
      Pylone
      rotate y*90
   }
   
   object {
      //*PMName Pylone1
      Pylone
      rotate y*90
      translate x*80
   }
   
   object {
      //*PMName Pylone2
      Pylone_0
      rotate y*90
      translate x*(-80)
   }
   
   object {
      //*PMName Pylone3
      Pylone
      rotate y*90
      translate x*160
   }
   
   object {
      //*PMName Pylone4
      Pylone
      rotate y*90
      translate x*240
   }
   
   object {
      //*PMName Pylone5
      Pylone
      rotate y*90
      translate x*320
   }
   scale 4
   rotate y*(-40)
   translate z*300
}

// Tetes
#declare StdTete = union {
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0.794534, -0>, <-0.382683, 0.774386, -0.0678307>, <-0.369843, 0.701909, -0.112766>, <-0.353552, 0.691245, -0.180794>,
      <-0.382683, 0.810774, 0.0546756>, <-0.382683, 0.790627, -0.0131551>, <-0.276066, 0.731366, -0.00587933>, <-0.259775, 0.720703, -0.0739073>,
      <-0.37303, 0.794534, 0.113342>, <-0.25911, 0.838459, 0.0595479>, <-0.247912, 0.858467, -0.00515968>, <-0.129202, 0.841127, -0.0635396>,
      <-0.353552, 0.794534, 0.166949>, <-0.239632, 0.838459, 0.113155>, <-0.11871, 0.87734, 0.0583799>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0.794534, -0>, <-0.50131, 0.752276, 0>, <-0.611627, 0.690221, -0>, <-0.707104, 0.608111, -0>,
      <-0.382683, 0.810774, 0.0546756>, <-0.501309, 0.768516, 0.0546756>, <-0.611627, 0.685554, 0.105286>, <-0.707104, 0.603444, 0.105286>,
      <-0.37303, 0.794534, 0.113342>, <-0.482313, 0.752397, 0.164945>, <-0.600727, 0.690532, 0.167617>, <-0.68927, 0.608111, 0.209427>,
      <-0.353552, 0.794534, 0.166949>, <-0.462835, 0.752397, 0.218553>, <-0.564737, 0.690532, 0.266671>, <-0.65328, 0.608111, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0.794534, -0>, <-0.382683, 0.810774, 0.0546756>, <-0.37303, 0.794534, 0.113342>, <-0.353552, 0.794534, 0.166949>,
      <-0.259595, 0.838381, -0>, <-0.259595, 0.854621, 0.0546756>, <-0.25911, 0.838459, 0.0595479>, <-0.239632, 0.838459, 0.113155>,
      <-0.129414, 0.86, 0>, <-0.129414, 0.86, 0>, <-0.11871, 0.87734, 0.0583799>, <-0.11871, 0.87734, 0.0583799>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0.794534, -0>, <-0.259595, 0.838381, -0>, <-0.129414, 0.86, 0>, <-0, 0.86, -0>,
      <-0.382683, 0.810774, 0.0546756>, <-0.259595, 0.854621, 0.0546756>, <-0.209137, 0.870808, 0.114391>, <-0.0797239, 0.870808, 0.114391>,
      <-0.37303, 0.794534, 0.113342>, <-0.354175, 0.794534, 0.165235>, <-0.219486, 0.838624, 0.167203>, <-0.183077, 0.838624, 0.208709>,
      <-0.353552, 0.794534, 0.166949>, <-0.334697, 0.794534, 0.218842>, <-0.307006, 0.794534, 0.266975>, <-0.270597, 0.794534, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0.794534, -0>, <-0.50131, 0.752276, 0>, <-0.611627, 0.690221, -0>, <-0.707104, 0.608111, -0>,
      <-0.382683, 0.774386, -0.0678307>, <-0.501309, 0.732129, -0.0678307>, <-0.611627, 0.701369, -0.251499>, <-0.707104, 0.619259, -0.251499>,
      <-0.369843, 0.701909, -0.112766>, <-0.50885, 0.658243, -0.271206>, <-0.582952, 0.703592, -0.320568>, <-0.689864, 0.639384, -0.49601>,
      <-0.353552, 0.691245, -0.180794>, <-0.492559, 0.64758, -0.339234>, <-0.546368, 0.718997, -0.569164>, <-0.65328, 0.654789, -0.744607>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0.794534, -0>, <-0.382683, 0.774386, -0.0678307>, <-0.369843, 0.701909, -0.112766>, <-0.353552, 0.691245, -0.180794>,
      <-0.259595, 0.838381, -0>, <-0.259595, 0.818234, -0.0678307>, <-0.276066, 0.731366, -0.00587933>, <-0.259775, 0.720703, -0.0739073>,
      <-0.129414, 0.86, 0>, <-0.129414, 0.86, 0>, <-0.129202, 0.841127, -0.0635396>, <-0.129202, 0.841127, -0.0635396>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0.794534, -0>, <-0.259595, 0.838381, -0>, <-0.129414, 0.86, 0>, <-0, 0.86, -0>,
      <-0.382683, 0.774386, -0.0678307>, <-0.259595, 0.818234, -0.0678307>, <-0.236506, 0.845481, -0.15366>, <-0.107092, 0.845481, -0.15366>,
      <-0.369843, 0.701909, -0.112766>, <-0.34656, 0.686668, -0.209992>, <-0.233233, 0.723878, -0.195787>, <-0.208084, 0.741753, -0.292096>,
      <-0.353552, 0.691245, -0.180794>, <-0.330269, 0.676004, -0.27802>, <-0.295746, 0.703289, -0.37174>, <-0.270597, 0.721164, -0.468048>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, 0.794534, 0.166949>, <-0.462835, 0.752397, 0.218553>, <-0.564737, 0.690532, 0.266671>, <-0.65328, 0.608111, 0.308481>,
      <-0.334697, 0.794534, 0.218842>, <-0.44398, 0.752397, 0.270446>, <-0.529898, 0.690532, 0.362556>, <-0.618441, 0.608111, 0.404367>,
      <-0.307006, 0.794534, 0.266975>, <-0.390133, 0.752657, 0.361739>, <-0.498943, 0.691218, 0.415406>, <-0.567275, 0.608111, 0.493304>,
      <-0.270597, 0.794534, 0.308481>, <-0.353724, 0.752657, 0.403245>, <-0.431668, 0.691218, 0.4921>, <-0.5, 0.608111, 0.569998>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, 0.794534, 0.166949>, <-0.334697, 0.794534, 0.218842>, <-0.307006, 0.794534, 0.266975>, <-0.270597, 0.794534, 0.308481>,
      <-0.239632, 0.838459, 0.113155>, <-0.220776, 0.838459, 0.165048>, <-0.219486, 0.838624, 0.167203>, <-0.183077, 0.838624, 0.208709>,
      <-0.11871, 0.87734, 0.0583799>, <-0.11871, 0.87734, 0.0583799>, <-0.0797239, 0.870808, 0.114391>, <-0.0797239, 0.870808, 0.114391>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, 0.794534, 0.166949>, <-0.239632, 0.838459, 0.113155>, <-0.11871, 0.87734, 0.0583799>, <-0, 0.86, -0>,
      <-0.334697, 0.794534, 0.218842>, <-0.220776, 0.838459, 0.165048>, <-0.149071, 0.872789, 0.201113>, <-0.0303604, 0.855448, 0.142733>,
      <-0.307006, 0.794534, 0.266975>, <-0.272369, 0.794534, 0.306461>, <-0.146427, 0.838764, 0.24985>, <-0.0989309, 0.838764, 0.272278>,
      <-0.270597, 0.794534, 0.308481>, <-0.23596, 0.794534, 0.347967>, <-0.193942, 0.794534, 0.380622>, <-0.146446, 0.794534, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, 0.794534, 0.308481>, <-0.353724, 0.752657, 0.403245>, <-0.431668, 0.691218, 0.4921>, <-0.5, 0.608111, 0.569998>,
      <-0.23596, 0.794534, 0.347967>, <-0.319087, 0.752657, 0.442731>, <-0.367667, 0.691218, 0.565061>, <-0.435999, 0.608111, 0.64296>,
      <-0.193942, 0.794534, 0.380622>, <-0.238692, 0.752878, 0.503784>, <-0.321107, 0.691826, 0.600775>, <-0.358359, 0.608111, 0.703298>,
      <-0.146446, 0.794534, 0.40305>, <-0.191196, 0.752878, 0.526212>, <-0.233346, 0.691826, 0.642217>, <-0.270597, 0.608111, 0.74474>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, 0.794534, 0.308481>, <-0.23596, 0.794534, 0.347967>, <-0.193942, 0.794534, 0.380622>, <-0.146446, 0.794534, 0.40305>,
      <-0.183077, 0.838624, 0.208709>, <-0.14844, 0.838624, 0.248195>, <-0.146427, 0.838764, 0.24985>, <-0.0989309, 0.838764, 0.272278>,
      <-0.0797239, 0.870808, 0.114391>, <-0.0797239, 0.870808, 0.114391>, <-0.0303604, 0.855448, 0.142733>, <-0.0303604, 0.855448, 0.142733>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, 0.794534, 0.308481>, <-0.183077, 0.838624, 0.208709>, <-0.0797239, 0.870808, 0.114391>, <-0, 0.86, -0>,
      <-0.23596, 0.794534, 0.347967>, <-0.14844, 0.838624, 0.248195>, <-0.0797239, 0.865936, 0.262781>, <-0, 0.855128, 0.148389>,
      <-0.193942, 0.794534, 0.380622>, <-0.148242, 0.794534, 0.402202>, <-0.0505385, 0.838816, 0.294547>, <-0, 0.838816, 0.294547>,
      <-0.146446, 0.794534, 0.40305>, <-0.100746, 0.794534, 0.42463>, <-0.0505385, 0.794534, 0.436259>, <-0, 0.794534, 0.436259>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, 0.794534, 0.40305>, <-0.191196, 0.752878, 0.526212>, <-0.233346, 0.691826, 0.642217>, <-0.270597, 0.608111, 0.74474>,
      <-0.100746, 0.794534, 0.42463>, <-0.145497, 0.752878, 0.547792>, <-0.148904, 0.691826, 0.682091>, <-0.186155, 0.608111, 0.784614>,
      <-0.0505385, 0.794534, 0.436259>, <-0.0505385, 0.75296, 0.569306>, <-0.0933829, 0.692058, 0.694823>, <-0.0933829, 0.608111, 0.806101>,
      <-0, 0.794534, 0.436259>, <-0, 0.75296, 0.569306>, <-0, 0.692058, 0.694823>, <-0, 0.608111, 0.806101>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, 0.794534, 0.40305>, <-0.100746, 0.794534, 0.42463>, <-0.0505385, 0.794534, 0.436259>, <-0, 0.794534, 0.436259>,
      <-0.0989309, 0.838764, 0.272278>, <-0.0532313, 0.838764, 0.293858>, <-0.0505385, 0.838816, 0.294547>, <-0, 0.838816, 0.294547>,
      <-0.0303604, 0.855448, 0.142733>, <-0.0303604, 0.855448, 0.142733>, <-0, 0.855128, 0.148389>, <-0, 0.855128, 0.148389>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, 0.794534, 0.40305>, <-0.0989309, 0.838764, 0.272278>, <-0.0303604, 0.855448, 0.142733>, <-0, 0.86, -0>,
      <-0.100746, 0.794534, 0.42463>, <-0.0532313, 0.838764, 0.293858>, <-0, 0.850896, 0.285466>, <0.0303604, 0.855448, 0.142733>,
      <-0.0505385, 0.794534, 0.436259>, <-0, 0.794534, 0.436259>, <0.0532313, 0.838764, 0.293858>, <0.0989309, 0.838764, 0.272278>,
      <-0, 0.794534, 0.436259>, <0.0505385, 0.794534, 0.436259>, <0.100746, 0.794534, 0.42463>, <0.146446, 0.794534, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.794534, 0.436259>, <-0, 0.75296, 0.569306>, <-0, 0.692058, 0.694823>, <-0, 0.608111, 0.806101>,
      <0.0505385, 0.794534, 0.436259>, <0.0505385, 0.75296, 0.569306>, <0.0933829, 0.692058, 0.694823>, <0.0933829, 0.608111, 0.806101>,
      <0.100746, 0.794534, 0.42463>, <0.145497, 0.752878, 0.547792>, <0.148904, 0.691826, 0.682091>, <0.186155, 0.608111, 0.784614>,
      <0.146446, 0.794534, 0.40305>, <0.191196, 0.752878, 0.526212>, <0.233346, 0.691826, 0.642217>, <0.270597, 0.608111, 0.74474>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.794534, 0.436259>, <0.0505385, 0.794534, 0.436259>, <0.100746, 0.794534, 0.42463>, <0.146446, 0.794534, 0.40305>,
      <-0, 0.838816, 0.294547>, <0.0505385, 0.838816, 0.294547>, <0.0532313, 0.838764, 0.293858>, <0.0989309, 0.838764, 0.272278>,
      <-0, 0.855128, 0.148389>, <-0, 0.855128, 0.148389>, <0.0303604, 0.855448, 0.142733>, <0.0303604, 0.855448, 0.142733>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.794534, 0.436259>, <-0, 0.838816, 0.294547>, <-0, 0.855128, 0.148389>, <-0, 0.86, -0>,
      <0.0505385, 0.794534, 0.436259>, <0.0505385, 0.838816, 0.294547>, <0.0797239, 0.865936, 0.262781>, <0.0797239, 0.870808, 0.114391>,
      <0.100746, 0.794534, 0.42463>, <0.148242, 0.794534, 0.402202>, <0.14844, 0.838624, 0.248195>, <0.183077, 0.838624, 0.208709>,
      <0.146446, 0.794534, 0.40305>, <0.193942, 0.794534, 0.380622>, <0.23596, 0.794534, 0.347967>, <0.270597, 0.794534, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, 0.794534, 0.40305>, <0.191196, 0.752878, 0.526212>, <0.233346, 0.691826, 0.642217>, <0.270597, 0.608111, 0.74474>,
      <0.193942, 0.794534, 0.380622>, <0.238692, 0.752878, 0.503784>, <0.321107, 0.691826, 0.600775>, <0.358359, 0.608111, 0.703298>,
      <0.23596, 0.794534, 0.347967>, <0.319087, 0.752657, 0.442731>, <0.367667, 0.691218, 0.565061>, <0.435999, 0.608111, 0.64296>,
      <0.270597, 0.794534, 0.308481>, <0.353724, 0.752657, 0.403245>, <0.431668, 0.691218, 0.4921>, <0.5, 0.608111, 0.569998>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, 0.794534, 0.40305>, <0.193942, 0.794534, 0.380622>, <0.23596, 0.794534, 0.347967>, <0.270597, 0.794534, 0.308481>,
      <0.0989309, 0.838764, 0.272278>, <0.146427, 0.838764, 0.24985>, <0.14844, 0.838624, 0.248195>, <0.183077, 0.838624, 0.208709>,
      <0.0303604, 0.855448, 0.142733>, <0.0303604, 0.855448, 0.142733>, <0.0797239, 0.870808, 0.114391>, <0.0797239, 0.870808, 0.114391>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, 0.794534, 0.40305>, <0.0989309, 0.838764, 0.272278>, <0.0303604, 0.855448, 0.142733>, <-0, 0.86, -0>,
      <0.193942, 0.794534, 0.380622>, <0.146427, 0.838764, 0.24985>, <0.149071, 0.872789, 0.201113>, <0.11871, 0.87734, 0.0583799>,
      <0.23596, 0.794534, 0.347967>, <0.272369, 0.794534, 0.306461>, <0.220776, 0.838459, 0.165048>, <0.239632, 0.838459, 0.113155>,
      <0.270597, 0.794534, 0.308481>, <0.307006, 0.794534, 0.266975>, <0.334697, 0.794534, 0.218842>, <0.353552, 0.794534, 0.166949>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, 0.794534, 0.308481>, <0.353724, 0.752657, 0.403245>, <0.431668, 0.691218, 0.4921>, <0.5, 0.608111, 0.569998>,
      <0.307006, 0.794534, 0.266975>, <0.390133, 0.752657, 0.361739>, <0.498943, 0.691218, 0.415406>, <0.567275, 0.608111, 0.493304>,
      <0.334697, 0.794534, 0.218842>, <0.44398, 0.752397, 0.270446>, <0.529898, 0.690532, 0.362556>, <0.618441, 0.608111, 0.404367>,
      <0.353552, 0.794534, 0.166949>, <0.462835, 0.752397, 0.218553>, <0.564737, 0.690532, 0.266671>, <0.65328, 0.608111, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, 0.794534, 0.308481>, <0.307006, 0.794534, 0.266975>, <0.334697, 0.794534, 0.218842>, <0.353552, 0.794534, 0.166949>,
      <0.183077, 0.838624, 0.208709>, <0.219486, 0.838624, 0.167203>, <0.220776, 0.838459, 0.165048>, <0.239632, 0.838459, 0.113155>,
      <0.0797239, 0.870808, 0.114391>, <0.0797239, 0.870808, 0.114391>, <0.11871, 0.87734, 0.0583799>, <0.11871, 0.87734, 0.0583799>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, 0.794534, 0.308481>, <0.183077, 0.838624, 0.208709>, <0.0797239, 0.870808, 0.114391>, <-0, 0.86, -0>,
      <0.307006, 0.794534, 0.266975>, <0.219486, 0.838624, 0.167203>, <0.209137, 0.870808, 0.114391>, <0.129414, 0.86, -0>,
      <0.334697, 0.794534, 0.218842>, <0.354175, 0.794534, 0.165235>, <0.259595, 0.854621, 0.0546756>, <0.259595, 0.838381, 0>,
      <0.353552, 0.794534, 0.166949>, <0.37303, 0.794534, 0.113342>, <0.382683, 0.810774, 0.0546756>, <0.382683, 0.794534, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, 0.794534, 0.166949>, <0.462835, 0.752397, 0.218553>, <0.564737, 0.690532, 0.266671>, <0.65328, 0.608111, 0.308481>,
      <0.37303, 0.794534, 0.113342>, <0.482313, 0.752397, 0.164945>, <0.600727, 0.690532, 0.167617>, <0.68927, 0.608111, 0.209427>,
      <0.382683, 0.810774, 0.0546756>, <0.501309, 0.768516, 0.0546756>, <0.611627, 0.685554, 0.105286>, <0.707104, 0.603444, 0.105286>,
      <0.382683, 0.794534, -0>, <0.50131, 0.752276, -0>, <0.611627, 0.690221, 0>, <0.707104, 0.608111, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, 0.794534, 0.166949>, <0.37303, 0.794534, 0.113342>, <0.382683, 0.810774, 0.0546756>, <0.382683, 0.794534, -0>,
      <0.239632, 0.838459, 0.113155>, <0.25911, 0.838459, 0.0595479>, <0.259595, 0.854621, 0.0546756>, <0.259595, 0.838381, 0>,
      <0.11871, 0.87734, 0.0583799>, <0.11871, 0.87734, 0.0583799>, <0.129414, 0.86, 0>, <0.129414, 0.86, -0>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, 0.794534, 0.166949>, <0.239632, 0.838459, 0.113155>, <0.11871, 0.87734, 0.0583799>, <-0, 0.86, -0>,
      <0.37303, 0.794534, 0.113342>, <0.25911, 0.838459, 0.0595479>, <0.247912, 0.858467, -0.00515968>, <0.129202, 0.841127, -0.0635396>,
      <0.382683, 0.810774, 0.0546756>, <0.382683, 0.790627, -0.0131551>, <0.276066, 0.731366, -0.00587933>, <0.259775, 0.720703, -0.0739073>,
      <0.382683, 0.794534, -0>, <0.382683, 0.774386, -0.0678307>, <0.369843, 0.701909, -0.112766>, <0.353552, 0.691245, -0.180794>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.382683, 0.794534, -0>, <0.50131, 0.752276, -0>, <0.611627, 0.690221, 0>, <0.707104, 0.608111, -0>,
      <0.382683, 0.774386, -0.0678307>, <0.501309, 0.732129, -0.0678307>, <0.611627, 0.701369, -0.251499>, <0.707104, 0.619259, -0.251499>,
      <0.369843, 0.701909, -0.112766>, <0.50885, 0.658243, -0.271206>, <0.582952, 0.703592, -0.320568>, <0.689864, 0.639384, -0.49601>,
      <0.353552, 0.691245, -0.180794>, <0.492559, 0.64758, -0.339234>, <0.546368, 0.718997, -0.569164>, <0.65328, 0.654789, -0.744607>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.382683, 0.794534, -0>, <0.382683, 0.774386, -0.0678307>, <0.369843, 0.701909, -0.112766>, <0.353552, 0.691245, -0.180794>,
      <0.259595, 0.838381, 0>, <0.259595, 0.818234, -0.0678307>, <0.276066, 0.731366, -0.00587933>, <0.259775, 0.720703, -0.0739073>,
      <0.129414, 0.86, -0>, <0.129414, 0.86, 0>, <0.129202, 0.841127, -0.0635396>, <0.129202, 0.841127, -0.0635396>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.382683, 0.794534, -0>, <0.259595, 0.838381, 0>, <0.129414, 0.86, -0>, <-0, 0.86, -0>,
      <0.382683, 0.774386, -0.0678307>, <0.259595, 0.818234, -0.0678307>, <0.236506, 0.845481, -0.15366>, <0.107092, 0.845481, -0.15366>,
      <0.369843, 0.701909, -0.112766>, <0.34656, 0.686668, -0.209992>, <0.233233, 0.723878, -0.195787>, <0.208084, 0.741753, -0.292096>,
      <0.353552, 0.691245, -0.180794>, <0.330269, 0.676004, -0.27802>, <0.295746, 0.703289, -0.37174>, <0.270597, 0.721164, -0.468048>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, 0.691245, -0.180794>, <0.492559, 0.64758, -0.339234>, <0.546368, 0.718997, -0.569164>, <0.65328, 0.654789, -0.744607>,
      <0.330269, 0.676004, -0.27802>, <0.469276, 0.632339, -0.43646>, <0.513041, 0.733031, -0.795632>, <0.619953, 0.668824, -0.971074>,
      <0.295746, 0.703289, -0.37174>, <0.40407, 0.667612, -0.676635>, <0.490538, 0.743203, -0.882558>, <0.574893, 0.68209, -1.19097>,
      <0.270597, 0.721164, -0.468048>, <0.378921, 0.685487, -0.772944>, <0.415645, 0.756436, -1.09892>, <0.5, 0.695323, -1.40733>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, 0.691245, -0.180794>, <0.330269, 0.676004, -0.27802>, <0.295746, 0.703289, -0.37174>, <0.270597, 0.721164, -0.468048>,
      <0.259775, 0.720703, -0.0739073>, <0.236492, 0.705462, -0.171133>, <0.233233, 0.723878, -0.195787>, <0.208084, 0.741753, -0.292096>,
      <0.129202, 0.841127, -0.0635396>, <0.129202, 0.841127, -0.0635396>, <0.107092, 0.845481, -0.15366>, <0.107092, 0.845481, -0.15366>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, 0.691245, -0.180794>, <0.259775, 0.720703, -0.0739073>, <0.129202, 0.841127, -0.0635396>, <-0, 0.86, -0>,
      <0.330269, 0.676004, -0.27802>, <0.236492, 0.705462, -0.171133>, <0.198147, 0.851464, -0.387669>, <0.0689447, 0.870337, -0.324129>,
      <0.295746, 0.703289, -0.37174>, <0.25106, 0.73505, -0.542867>, <0.172207, 0.829473, -0.486246>, <0.0985955, 0.862778, -0.646752>,
      <0.270597, 0.721164, -0.468048>, <0.225911, 0.752925, -0.639176>, <0.220057, 0.805142, -0.813413>, <0.146446, 0.838447, -0.97392>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, 0.721164, -0.468048>, <0.378921, 0.685487, -0.772944>, <0.415645, 0.756436, -1.09892>, <0.5, 0.695323, -1.40733>,
      <0.225911, 0.752925, -0.639176>, <0.334235, 0.717248, -0.944071>, <0.360753, 0.766135, -1.2575>, <0.445108, 0.705022, -1.56591>,
      <0.220057, 0.805142, -0.813413>, <0.263412, 0.783097, -1.10984>, <0.33758, 0.78508, -1.43216>, <0.378266, 0.714527, -1.7213>,
      <0.146446, 0.838447, -0.97392>, <0.189801, 0.816402, -1.27035>, <0.229911, 0.79296, -1.561>, <0.270597, 0.722407, -1.85014>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, 0.721164, -0.468048>, <0.225911, 0.752925, -0.639176>, <0.220057, 0.805142, -0.813413>, <0.146446, 0.838447, -0.97392>,
      <0.208084, 0.741753, -0.292096>, <0.163398, 0.773513, -0.463223>, <0.172207, 0.829473, -0.486246>, <0.0985955, 0.862778, -0.646752>,
      <0.107092, 0.845481, -0.15366>, <0.107092, 0.845481, -0.15366>, <0.0689447, 0.870337, -0.324129>, <0.0689447, 0.870337, -0.324129>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, 0.721164, -0.468048>, <0.208084, 0.741753, -0.292096>, <0.107092, 0.845481, -0.15366>, <-0, 0.86, -0>,
      <0.225911, 0.752925, -0.639176>, <0.163398, 0.773513, -0.463223>, <0.107092, 0.857168, -0.509612>, <-0, 0.871686, -0.355951>,
      <0.220057, 0.805142, -0.813413>, <0.19676, 0.815683, -0.864212>, <0.0568717, 0.866292, -0.702655>, <-0, 0.866292, -0.702655>,
      <0.146446, 0.838447, -0.97392>, <0.123149, 0.848988, -1.02472>, <0.0568717, 0.843594, -1.05807>, <-0, 0.843594, -1.05807>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, 0.838447, -0.97392>, <0.189801, 0.816402, -1.27035>, <0.229911, 0.79296, -1.561>, <0.270597, 0.722407, -1.85014>,
      <0.123149, 0.848988, -1.02472>, <0.166504, 0.826943, -1.32115>, <0.162599, 0.797887, -1.64155>, <0.203285, 0.727333, -1.93069>,
      <0.0568717, 0.843594, -1.05807>, <0.0568717, 0.823129, -1.37854>, <0.105085, 0.801265, -1.6921>, <0.105085, 0.731918, -2.00564>,
      <-0, 0.843594, -1.05807>, <-0, 0.823129, -1.37854>, <-0, 0.801266, -1.6921>, <-0, 0.731918, -2.00564>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, 0.838447, -0.97392>, <0.123149, 0.848988, -1.02472>, <0.0568717, 0.843594, -1.05807>, <-0, 0.843594, -1.05807>,
      <0.0985955, 0.862778, -0.646752>, <0.0752981, 0.873319, -0.697551>, <0.0568717, 0.866292, -0.702655>, <-0, 0.866292, -0.702655>,
      <0.0689447, 0.870337, -0.324129>, <0.0689447, 0.870337, -0.324129>, <-0, 0.871686, -0.355951>, <-0, 0.871686, -0.355951>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, 0.838447, -0.97392>, <0.0985955, 0.862778, -0.646752>, <0.0689447, 0.870337, -0.324129>, <-0, 0.86, -0>,
      <0.123149, 0.848988, -1.02472>, <0.0752981, 0.873319, -0.697551>, <-0, 0.880674, -0.648258>, <-0.0689447, 0.870337, -0.324129>,
      <0.0568717, 0.843594, -1.05807>, <-0, 0.843594, -1.05807>, <-0.0752981, 0.873319, -0.697551>, <-0.0985955, 0.862778, -0.646752>,
      <-0, 0.843594, -1.05807>, <-0.0568717, 0.843594, -1.05807>, <-0.123149, 0.848988, -1.02472>, <-0.146446, 0.838447, -0.97392>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.843594, -1.05807>, <-0, 0.823129, -1.37854>, <-0, 0.801266, -1.6921>, <-0, 0.731918, -2.00564>,
      <-0.0568717, 0.843594, -1.05807>, <-0.0568717, 0.823129, -1.37854>, <-0.105085, 0.801265, -1.6921>, <-0.105085, 0.731918, -2.00564>,
      <-0.123149, 0.848988, -1.02472>, <-0.166504, 0.826943, -1.32115>, <-0.162599, 0.797887, -1.64155>, <-0.203285, 0.727333, -1.93069>,
      <-0.146446, 0.838447, -0.97392>, <-0.189801, 0.816402, -1.27035>, <-0.229911, 0.79296, -1.561>, <-0.270597, 0.722407, -1.85014>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.843594, -1.05807>, <-0.0568717, 0.843594, -1.05807>, <-0.123149, 0.848988, -1.02472>, <-0.146446, 0.838447, -0.97392>,
      <-0, 0.866292, -0.702655>, <-0.0568717, 0.866292, -0.702655>, <-0.0752981, 0.873319, -0.697551>, <-0.0985955, 0.862778, -0.646752>,
      <-0, 0.871686, -0.355951>, <-0, 0.871686, -0.355951>, <-0.0689447, 0.870337, -0.324129>, <-0.0689447, 0.870337, -0.324129>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.843594, -1.05807>, <-0, 0.866292, -0.702655>, <-0, 0.871686, -0.355951>, <-0, 0.86, -0>,
      <-0.0568717, 0.843594, -1.05807>, <-0.0568717, 0.866292, -0.702655>, <-0.107092, 0.857168, -0.509612>, <-0.107092, 0.845481, -0.15366>,
      <-0.123149, 0.848988, -1.02472>, <-0.19676, 0.815683, -0.864212>, <-0.163398, 0.773513, -0.463223>, <-0.208084, 0.741753, -0.292096>,
      <-0.146446, 0.838447, -0.97392>, <-0.220057, 0.805142, -0.813413>, <-0.225911, 0.752925, -0.639176>, <-0.270597, 0.721164, -0.468048>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, 0.838447, -0.97392>, <-0.189801, 0.816402, -1.27035>, <-0.229911, 0.79296, -1.561>, <-0.270597, 0.722407, -1.85014>,
      <-0.220057, 0.805142, -0.813413>, <-0.263412, 0.783097, -1.10984>, <-0.33758, 0.78508, -1.43216>, <-0.378266, 0.714527, -1.7213>,
      <-0.225911, 0.752925, -0.639176>, <-0.334235, 0.717248, -0.944071>, <-0.360753, 0.766135, -1.2575>, <-0.445108, 0.705022, -1.56591>,
      <-0.270597, 0.721164, -0.468048>, <-0.378921, 0.685487, -0.772944>, <-0.415645, 0.756436, -1.09892>, <-0.5, 0.695323, -1.40733>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, 0.838447, -0.97392>, <-0.220057, 0.805142, -0.813413>, <-0.225911, 0.752925, -0.639176>, <-0.270597, 0.721164, -0.468048>,
      <-0.0985955, 0.862778, -0.646752>, <-0.172207, 0.829473, -0.486246>, <-0.163398, 0.773513, -0.463223>, <-0.208084, 0.741753, -0.292096>,
      <-0.0689447, 0.870337, -0.324129>, <-0.0689447, 0.870337, -0.324129>, <-0.107092, 0.845481, -0.15366>, <-0.107092, 0.845481, -0.15366>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, 0.838447, -0.97392>, <-0.0985955, 0.862778, -0.646752>, <-0.0689447, 0.870337, -0.324129>, <-0, 0.86, -0>,
      <-0.220057, 0.805142, -0.813413>, <-0.172207, 0.829473, -0.486246>, <-0.198147, 0.851464, -0.387669>, <-0.129202, 0.841127, -0.0635396>,
      <-0.225911, 0.752925, -0.639176>, <-0.25106, 0.73505, -0.542867>, <-0.236492, 0.705462, -0.171133>, <-0.259775, 0.720703, -0.0739073>,
      <-0.270597, 0.721164, -0.468048>, <-0.295746, 0.703289, -0.37174>, <-0.330269, 0.676004, -0.27802>, <-0.353552, 0.691245, -0.180794>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, 0.721164, -0.468048>, <-0.378921, 0.685487, -0.772944>, <-0.415645, 0.756436, -1.09892>, <-0.5, 0.695323, -1.40733>,
      <-0.295746, 0.703289, -0.37174>, <-0.40407, 0.667612, -0.676635>, <-0.490538, 0.743203, -0.882558>, <-0.574893, 0.68209, -1.19097>,
      <-0.330269, 0.676004, -0.27802>, <-0.469276, 0.632339, -0.43646>, <-0.513041, 0.733031, -0.795632>, <-0.619953, 0.668824, -0.971074>,
      <-0.353552, 0.691245, -0.180794>, <-0.492559, 0.64758, -0.339234>, <-0.546368, 0.718997, -0.569164>, <-0.65328, 0.654789, -0.744607>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, 0.721164, -0.468048>, <-0.295746, 0.703289, -0.37174>, <-0.330269, 0.676004, -0.27802>, <-0.353552, 0.691245, -0.180794>,
      <-0.208084, 0.741753, -0.292096>, <-0.233233, 0.723878, -0.195787>, <-0.236492, 0.705462, -0.171133>, <-0.259775, 0.720703, -0.0739073>,
      <-0.107092, 0.845481, -0.15366>, <-0.107092, 0.845481, -0.15366>, <-0.129202, 0.841127, -0.0635396>, <-0.129202, 0.841127, -0.0635396>,
      <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>, <-0, 0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.707104, 0.608111, -0>, <-0.797261, 0.530576, 0>, <-0.872279, 0.436239, -0>, <-0.923879, 0.329106, -0>,
      <-0.707104, 0.603444, 0.105286>, <-0.797261, 0.525909, 0.105286>, <-0.872279, 0.430179, 0.137565>, <-0.923879, 0.323047, 0.137565>,
      <-0.68927, 0.608111, 0.209427>, <-0.772209, 0.530906, 0.248592>, <-0.852708, 0.436676, 0.251027>, <-0.900574, 0.329106, 0.27363>,
      <-0.65328, 0.608111, 0.308481>, <-0.736219, 0.530906, 0.347645>, <-0.805683, 0.436676, 0.380447>, <-0.85355, 0.329106, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.707104, 0.608111, -0>, <-0.797261, 0.530576, 0>, <-0.872279, 0.436239, -0>, <-0.923879, 0.329106, -0>,
      <-0.707104, 0.619259, -0.251499>, <-0.797261, 0.541724, -0.251499>, <-0.872279, 0.451132, -0.338132>, <-0.923879, 0.344, -0.338132>,
      <-0.689864, 0.639384, -0.49601>, <-0.759912, 0.597315, -0.61096>, <-0.850464, 0.482241, -0.598202>, <-0.902004, 0.370403, -0.666947>,
      <-0.65328, 0.654789, -0.744607>, <-0.723329, 0.612721, -0.859556>, <-0.80201, 0.5028, -0.932544>, <-0.85355, 0.390962, -1.00129>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.65328, 0.608111, 0.308481>, <-0.736219, 0.530906, 0.347645>, <-0.805683, 0.436676, 0.380447>, <-0.85355, 0.329106, 0.40305>,
      <-0.618441, 0.608111, 0.404367>, <-0.70138, 0.530906, 0.443531>, <-0.760163, 0.436676, 0.505728>, <-0.80803, 0.329106, 0.528331>,
      <-0.567275, 0.608111, 0.493304>, <-0.630147, 0.531645, 0.564979>, <-0.704197, 0.437697, 0.602374>, <-0.741179, 0.329106, 0.644535>,
      <-0.5, 0.608111, 0.569998>, <-0.562872, 0.531645, 0.641672>, <-0.616297, 0.437697, 0.702579>, <-0.65328, 0.329106, 0.74474>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.5, 0.608111, 0.569998>, <-0.562872, 0.531645, 0.641672>, <-0.616297, 0.437697, 0.702579>, <-0.65328, 0.329106, 0.74474>,
      <-0.435999, 0.608111, 0.64296>, <-0.498871, 0.531645, 0.714634>, <-0.532676, 0.437697, 0.797907>, <-0.569659, 0.329106, 0.840068>,
      <-0.358359, 0.608111, 0.703298>, <-0.392088, 0.532311, 0.796129>, <-0.448023, 0.438669, 0.863323>, <-0.468217, 0.329106, 0.918902>,
      <-0.270597, 0.608111, 0.74474>, <-0.304327, 0.532311, 0.83757>, <-0.333358, 0.438669, 0.917468>, <-0.353552, 0.329106, 0.973047>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, 0.608111, 0.74474>, <-0.304327, 0.532311, 0.83757>, <-0.333358, 0.438669, 0.917468>, <-0.353552, 0.329106, 0.973047>,
      <-0.186155, 0.608111, 0.784614>, <-0.219885, 0.532311, 0.877444>, <-0.223029, 0.438669, 0.969566>, <-0.243223, 0.329106, 1.02514>,
      <-0.0933829, 0.608111, 0.806101>, <-0.0933829, 0.532568, 0.906239>, <-0.122011, 0.439059, 0.992848>, <-0.122011, 0.329106, 1.05322>,
      <-0, 0.608111, 0.806101>, <-0, 0.532568, 0.906239>, <-0, 0.439059, 0.992848>, <-0, 0.329106, 1.05322>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.608111, 0.806101>, <-0, 0.532568, 0.906239>, <-0, 0.439059, 0.992848>, <-0, 0.329106, 1.05322>,
      <0.0933829, 0.608111, 0.806101>, <0.0933829, 0.532568, 0.906239>, <0.122011, 0.439059, 0.992848>, <0.122011, 0.329106, 1.05322>,
      <0.186155, 0.608111, 0.784614>, <0.219885, 0.532311, 0.877444>, <0.223029, 0.438669, 0.969566>, <0.243223, 0.329106, 1.02514>,
      <0.270597, 0.608111, 0.74474>, <0.304327, 0.532311, 0.83757>, <0.333358, 0.438669, 0.917468>, <0.353552, 0.329106, 0.973047>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, 0.608111, 0.74474>, <0.304327, 0.532311, 0.83757>, <0.333358, 0.438669, 0.917468>, <0.353552, 0.329106, 0.973047>,
      <0.358359, 0.608111, 0.703298>, <0.392088, 0.532311, 0.796129>, <0.448023, 0.438669, 0.863323>, <0.468217, 0.329106, 0.918902>,
      <0.435999, 0.608111, 0.64296>, <0.498871, 0.531645, 0.714634>, <0.532676, 0.437697, 0.797907>, <0.569659, 0.329106, 0.840068>,
      <0.5, 0.608111, 0.569998>, <0.562872, 0.531645, 0.641672>, <0.616297, 0.437697, 0.702579>, <0.65328, 0.329106, 0.74474>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.5, 0.608111, 0.569998>, <0.562872, 0.531645, 0.641672>, <0.616297, 0.437697, 0.702579>, <0.65328, 0.329106, 0.74474>,
      <0.567275, 0.608111, 0.493304>, <0.630147, 0.531645, 0.564979>, <0.704197, 0.437697, 0.602374>, <0.741179, 0.329106, 0.644535>,
      <0.618441, 0.608111, 0.404367>, <0.70138, 0.530906, 0.443531>, <0.760163, 0.436676, 0.505728>, <0.80803, 0.329106, 0.528331>,
      <0.65328, 0.608111, 0.308481>, <0.736219, 0.530906, 0.347645>, <0.805683, 0.436676, 0.380447>, <0.85355, 0.329106, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.65328, 0.608111, 0.308481>, <0.736219, 0.530906, 0.347645>, <0.805683, 0.436676, 0.380447>, <0.85355, 0.329106, 0.40305>,
      <0.68927, 0.608111, 0.209427>, <0.772209, 0.530906, 0.248592>, <0.852708, 0.436676, 0.251027>, <0.900574, 0.329106, 0.27363>,
      <0.707104, 0.603444, 0.105286>, <0.797261, 0.525909, 0.105286>, <0.872279, 0.430179, 0.137565>, <0.923879, 0.323047, 0.137565>,
      <0.707104, 0.608111, -0>, <0.797261, 0.530576, -0>, <0.872279, 0.436239, 0>, <0.923879, 0.329106, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.707104, 0.608111, -0>, <0.797261, 0.530576, -0>, <0.872279, 0.436239, 0>, <0.923879, 0.329106, -0>,
      <0.707104, 0.619259, -0.251499>, <0.797261, 0.541724, -0.251499>, <0.872279, 0.451132, -0.338132>, <0.923879, 0.344, -0.338132>,
      <0.689864, 0.639384, -0.49601>, <0.759912, 0.597315, -0.61096>, <0.850464, 0.482241, -0.598202>, <0.902004, 0.370403, -0.666947>,
      <0.65328, 0.654789, -0.744607>, <0.723329, 0.612721, -0.859556>, <0.80201, 0.5028, -0.932544>, <0.85355, 0.390962, -1.00129>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.65328, 0.654789, -0.744607>, <0.723329, 0.612721, -0.859556>, <0.80201, 0.5028, -0.932544>, <0.85355, 0.390962, -1.00129>,
      <0.619953, 0.668824, -0.971074>, <0.690001, 0.626755, -1.08602>, <0.759113, 0.521001, -1.22854>, <0.810653, 0.409164, -1.29729>,
      <0.574893, 0.68209, -1.19097>, <0.622514, 0.64759, -1.36508>, <0.707815, 0.545931, -1.45159>, <0.751132, 0.426633, -1.58449>,
      <0.5, 0.695323, -1.40733>, <0.547622, 0.660823, -1.58144>, <0.609963, 0.563221, -1.73427>, <0.65328, 0.443922, -1.86718>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.5, 0.695323, -1.40733>, <0.547622, 0.660823, -1.58144>, <0.609963, 0.563221, -1.73427>, <0.65328, 0.443922, -1.86718>,
      <0.445108, 0.705022, -1.56591>, <0.492729, 0.670522, -1.74002>, <0.538243, 0.575893, -1.94147>, <0.58156, 0.456595, -2.07437>,
      <0.378266, 0.714527, -1.7213>, <0.407833, 0.663255, -1.93143>, <0.469708, 0.591338, -2.09827>, <0.494229, 0.469013, -2.27741>,
      <0.270597, 0.722407, -1.85014>, <0.300164, 0.671135, -2.06027>, <0.329032, 0.601634, -2.26661>, <0.353552, 0.479309, -2.44574>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, 0.722407, -1.85014>, <0.300164, 0.671135, -2.06027>, <0.329032, 0.601634, -2.26661>, <0.353552, 0.479309, -2.44574>,
      <0.203285, 0.727333, -1.93069>, <0.232853, 0.676062, -2.14081>, <0.241085, 0.608071, -2.37185>, <0.265605, 0.485746, -2.55098>,
      <0.105085, 0.731918, -2.00564>, <0.105085, 0.682011, -2.23128>, <0.1373, 0.614722, -2.45326>, <0.1373, 0.491735, -2.64891>,
      <-0, 0.731918, -2.00564>, <-0, 0.682011, -2.23128>, <-0, 0.614722, -2.45326>, <-0, 0.491735, -2.64891>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.731918, -2.00564>, <-0, 0.682011, -2.23128>, <-0, 0.614722, -2.45326>, <-0, 0.491735, -2.64891>,
      <-0.105085, 0.731918, -2.00564>, <-0.105085, 0.682011, -2.23128>, <-0.1373, 0.614722, -2.45326>, <-0.1373, 0.491735, -2.64891>,
      <-0.203285, 0.727333, -1.93069>, <-0.232853, 0.676062, -2.14081>, <-0.241085, 0.608071, -2.37185>, <-0.265605, 0.485746, -2.55098>,
      <-0.270597, 0.722407, -1.85014>, <-0.300164, 0.671135, -2.06027>, <-0.329032, 0.601634, -2.26661>, <-0.353552, 0.479309, -2.44574>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, 0.722407, -1.85014>, <-0.300164, 0.671135, -2.06027>, <-0.329032, 0.601634, -2.26661>, <-0.353552, 0.479309, -2.44574>,
      <-0.378266, 0.714527, -1.7213>, <-0.407833, 0.663255, -1.93143>, <-0.469708, 0.591338, -2.09827>, <-0.494229, 0.469013, -2.27741>,
      <-0.445108, 0.705022, -1.56591>, <-0.492729, 0.670522, -1.74002>, <-0.538243, 0.575893, -1.94147>, <-0.58156, 0.456595, -2.07437>,
      <-0.5, 0.695323, -1.40733>, <-0.547622, 0.660823, -1.58144>, <-0.609963, 0.563221, -1.73427>, <-0.65328, 0.443922, -1.86718>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.5, 0.695323, -1.40733>, <-0.547622, 0.660823, -1.58144>, <-0.609963, 0.563221, -1.73427>, <-0.65328, 0.443922, -1.86718>,
      <-0.574893, 0.68209, -1.19097>, <-0.622514, 0.64759, -1.36508>, <-0.707815, 0.545931, -1.45159>, <-0.751132, 0.426633, -1.58449>,
      <-0.619953, 0.668824, -0.971074>, <-0.690001, 0.626755, -1.08602>, <-0.759113, 0.521001, -1.22854>, <-0.810653, 0.409164, -1.29729>,
      <-0.65328, 0.654789, -0.744607>, <-0.723329, 0.612721, -0.859556>, <-0.80201, 0.5028, -0.932544>, <-0.85355, 0.390962, -1.00129>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.923879, 0.329106, -0>, <-0.973212, 0.226681, 0>, <-1, 0.113686, -0>, <-1, 0, -0>,
      <-0.923879, 0.323047, 0.137565>, <-0.973212, 0.220622, 0.137565>, <-1, 0.107156, 0.1489>, <-1, -0.00653022, 0.1489>,
      <-0.900574, 0.329106, 0.27363>, <-0.946015, 0.226988, 0.295088>, <-0.974778, 0.113813, 0.296176>, <-0.974778, 0, 0.296176>,
      <-0.85355, 0.329106, 0.40305>, <-0.898991, 0.226988, 0.424507>, <-0.923879, 0.113813, 0.436259>, <-0.923879, 0, 0.436259>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.923879, 0.329106, -0>, <-0.973212, 0.226681, 0>, <-1, 0.113686, -0>, <-1, 0, -0>,
      <-0.923879, 0.344, -0.338132>, <-0.973212, 0.241575, -0.338132>, <-1, 0.130058, -0.373289>, <-1, 0.0163711, -0.373289>,
      <-0.902004, 0.370403, -0.666947>, <-0.944676, 0.27781, -0.723863>, <-0.976814, 0.161582, -0.729217>, <-0.976814, 0.0450368, -0.736345>,
      <-0.85355, 0.390962, -1.00129>, <-0.896222, 0.29837, -1.0582>, <-0.923879, 0.184163, -1.09841>, <-0.923879, 0.0676174, -1.10553>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.85355, 0.329106, 0.40305>, <-0.898991, 0.226988, 0.424507>, <-0.923879, 0.113813, 0.436259>, <-0.923879, 0, 0.436259>,
      <-0.80803, 0.329106, 0.528331>, <-0.853471, 0.226988, 0.549788>, <-0.874608, 0.113813, 0.571863>, <-0.874608, 0, 0.571863>,
      <-0.741179, 0.329106, 0.644535>, <-0.775711, 0.227712, 0.683902>, <-0.802246, 0.114118, 0.697639>, <-0.802246, 0, 0.697639>,
      <-0.65328, 0.329106, 0.74474>, <-0.687812, 0.227712, 0.784107>, <-0.707104, 0.114118, 0.806101>, <-0.707104, 0, 0.806101>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.65328, 0.329106, 0.74474>, <-0.687812, 0.227712, 0.784107>, <-0.707104, 0.114118, 0.806101>, <-0.707104, 0, 0.806101>,
      <-0.569659, 0.329106, 0.840068>, <-0.604191, 0.227712, 0.879435>, <-0.616594, 0.114118, 0.909282>, <-0.616594, 0, 0.909283>,
      <-0.468217, 0.329106, 0.918902>, <-0.486777, 0.228414, 0.969981>, <-0.506795, 0.114422, 0.994614>, <-0.506795, 0, 0.994614>,
      <-0.353552, 0.329106, 0.973047>, <-0.372111, 0.228414, 1.02413>, <-0.382683, 0.114422, 1.05322>, <-0.382683, 0, 1.05322>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, 0.329106, 0.973047>, <-0.372111, 0.228414, 1.02413>, <-0.382683, 0.114422, 1.05322>, <-0.382683, 0, 1.05322>,
      <-0.243223, 0.329106, 1.02514>, <-0.261783, 0.228414, 1.07622>, <-0.263264, 0.114422, 1.10961>, <-0.263264, 0, 1.10961>,
      <-0.122011, 0.329106, 1.05322>, <-0.122011, 0.228698, 1.10835>, <-0.132064, 0.114548, 1.14>, <-0.132064, 0, 1.14>,
      <-0, 0.329106, 1.05322>, <-0, 0.228698, 1.10835>, <-0, 0.114548, 1.14>, <-0, 0, 1.14>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.329106, 1.05322>, <-0, 0.228698, 1.10835>, <-0, 0.114548, 1.14>, <-0, 0, 1.14>,
      <0.122011, 0.329106, 1.05322>, <0.122011, 0.228698, 1.10835>, <0.132064, 0.114548, 1.14>, <0.132064, 0, 1.14>,
      <0.243223, 0.329106, 1.02514>, <0.261783, 0.228414, 1.07622>, <0.263264, 0.114422, 1.10961>, <0.263264, 0, 1.10961>,
      <0.353552, 0.329106, 0.973047>, <0.372111, 0.228414, 1.02413>, <0.382683, 0.114422, 1.05322>, <0.382683, 0, 1.05322>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, 0.329106, 0.973047>, <0.372111, 0.228414, 1.02413>, <0.382683, 0.114422, 1.05322>, <0.382683, 0, 1.05322>,
      <0.468217, 0.329106, 0.918902>, <0.486777, 0.228414, 0.969981>, <0.506795, 0.114422, 0.994614>, <0.506795, 0, 0.994614>,
      <0.569659, 0.329106, 0.840068>, <0.604191, 0.227712, 0.879435>, <0.616594, 0.114118, 0.909282>, <0.616594, 0, 0.909283>,
      <0.65328, 0.329106, 0.74474>, <0.687812, 0.227712, 0.784107>, <0.707104, 0.114118, 0.806101>, <0.707104, 0, 0.806101>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.65328, 0.329106, 0.74474>, <0.687812, 0.227712, 0.784107>, <0.707104, 0.114118, 0.806101>, <0.707104, 0, 0.806101>,
      <0.741179, 0.329106, 0.644535>, <0.775711, 0.227712, 0.683902>, <0.802246, 0.114118, 0.697639>, <0.802246, 0, 0.697639>,
      <0.80803, 0.329106, 0.528331>, <0.853471, 0.226988, 0.549788>, <0.874608, 0.113813, 0.571863>, <0.874608, 0, 0.571863>,
      <0.85355, 0.329106, 0.40305>, <0.898991, 0.226988, 0.424507>, <0.923879, 0.113813, 0.436259>, <0.923879, 0, 0.436259>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.85355, 0.329106, 0.40305>, <0.898991, 0.226988, 0.424507>, <0.923879, 0.113813, 0.436259>, <0.923879, 0, 0.436259>,
      <0.900574, 0.329106, 0.27363>, <0.946015, 0.226988, 0.295088>, <0.974778, 0.113813, 0.296176>, <0.974778, 0, 0.296176>,
      <0.923879, 0.323047, 0.137565>, <0.973212, 0.220622, 0.137565>, <1, 0.107156, 0.1489>, <1, -0.00653022, 0.1489>,
      <0.923879, 0.329106, -0>, <0.973212, 0.226681, -0>, <1, 0.113686, 0>, <1, 0, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.923879, 0.329106, -0>, <0.973212, 0.226681, -0>, <1, 0.113686, 0>, <1, 0, -0>,
      <0.923879, 0.344, -0.338132>, <0.973212, 0.241575, -0.338132>, <1, 0.130058, -0.373289>, <1, 0.0163711, -0.373289>,
      <0.902004, 0.370403, -0.666947>, <0.944676, 0.27781, -0.723863>, <0.976814, 0.161582, -0.729217>, <0.976814, 0.0450368, -0.736345>,
      <0.85355, 0.390962, -1.00129>, <0.896222, 0.29837, -1.0582>, <0.923879, 0.184163, -1.09841>, <0.923879, 0.0676174, -1.10553>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.85355, 0.390962, -1.00129>, <0.896222, 0.29837, -1.0582>, <0.923879, 0.184163, -1.09841>, <0.923879, 0.0676174, -1.10553>,
      <0.810653, 0.409164, -1.29729>, <0.853324, 0.316571, -1.3542>, <0.877931, 0.203763, -1.41887>, <0.877931, 0.0872176, -1.426>,
      <0.751132, 0.426633, -1.58449>, <0.780331, 0.346216, -1.67408>, <0.813019, 0.229872, -1.72922>, <0.813019, 0.106226, -1.73679>,
      <0.65328, 0.443922, -1.86718>, <0.682479, 0.363506, -1.95676>, <0.707104, 0.248586, -2.0352>, <0.707104, 0.124941, -2.04276>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.65328, 0.443922, -1.86718>, <0.682479, 0.363506, -1.95676>, <0.707104, 0.248586, -2.0352>, <0.707104, 0.124941, -2.04276>,
      <0.58156, 0.456595, -2.07437>, <0.610759, 0.376178, -2.16396>, <0.629475, 0.262303, -2.25947>, <0.629475, 0.138657, -2.26703>,
      <0.494229, 0.469013, -2.27741>, <0.508899, 0.395829, -2.38458>, <0.53495, 0.282458, -2.47882>, <0.53495, 0.152099, -2.48679>,
      <0.353552, 0.479309, -2.44574>, <0.368222, 0.406125, -2.55292>, <0.382683, 0.293603, -2.66103>, <0.382683, 0.163243, -2.669>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, 0.479309, -2.44574>, <0.368222, 0.406125, -2.55292>, <0.382683, 0.293603, -2.66103>, <0.382683, 0.163243, -2.669>,
      <0.265605, 0.485746, -2.55098>, <0.280275, 0.412562, -2.65816>, <0.28749, 0.30057, -2.77494>, <0.28749, 0.17021, -2.78291>,
      <0.1373, 0.491735, -2.64891>, <0.1373, 0.420799, -2.76176>, <0.148613, 0.309735, -2.88077>, <0.148613, 0.176693, -2.88891>,
      <-0, 0.491735, -2.64891>, <-0, 0.420799, -2.76176>, <-0, 0.309735, -2.88077>, <-0, 0.176693, -2.88891>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.491735, -2.64891>, <-0, 0.420799, -2.76176>, <-0, 0.309735, -2.88077>, <-0, 0.176693, -2.88891>,
      <-0.1373, 0.491735, -2.64891>, <-0.1373, 0.420799, -2.76176>, <-0.148613, 0.309735, -2.88077>, <-0.148613, 0.176693, -2.88891>,
      <-0.265605, 0.485746, -2.55098>, <-0.280275, 0.412562, -2.65816>, <-0.28749, 0.30057, -2.77494>, <-0.28749, 0.17021, -2.78291>,
      <-0.353552, 0.479309, -2.44574>, <-0.368222, 0.406125, -2.55292>, <-0.382683, 0.293603, -2.66103>, <-0.382683, 0.163243, -2.669>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, 0.479309, -2.44574>, <-0.368222, 0.406125, -2.55292>, <-0.382683, 0.293603, -2.66103>, <-0.382683, 0.163243, -2.669>,
      <-0.494229, 0.469013, -2.27741>, <-0.508899, 0.395829, -2.38458>, <-0.53495, 0.282458, -2.47882>, <-0.53495, 0.152099, -2.48679>,
      <-0.58156, 0.456595, -2.07437>, <-0.610759, 0.376178, -2.16396>, <-0.629475, 0.262303, -2.25947>, <-0.629475, 0.138657, -2.26703>,
      <-0.65328, 0.443922, -1.86718>, <-0.682479, 0.363506, -1.95676>, <-0.707104, 0.248586, -2.0352>, <-0.707104, 0.124941, -2.04276>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.65328, 0.443922, -1.86718>, <-0.682479, 0.363506, -1.95676>, <-0.707104, 0.248586, -2.0352>, <-0.707104, 0.124941, -2.04276>,
      <-0.751132, 0.426633, -1.58449>, <-0.780331, 0.346216, -1.67408>, <-0.813019, 0.229872, -1.72922>, <-0.813019, 0.106226, -1.73679>,
      <-0.810653, 0.409164, -1.29729>, <-0.853324, 0.316571, -1.3542>, <-0.877931, 0.203763, -1.41887>, <-0.877931, 0.0872176, -1.426>,
      <-0.85355, 0.390962, -1.00129>, <-0.896222, 0.29837, -1.0582>, <-0.923879, 0.184163, -1.09841>, <-0.923879, 0.0676174, -1.10553>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1, 0, -0>, <-1, -0.113686, 0>, <-0.973212, -0.226681, -0>, <-0.923879, -0.329106, -0>,
      <-1, -0.00653022, 0.1489>, <-1, -0.120217, 0.1489>, <-0.973212, -0.232689, 0.137567>, <-0.923879, -0.335114, 0.137567>,
      <-0.974778, 0, 0.296176>, <-0.974778, -0.113813, 0.296176>, <-0.946015, -0.226988, 0.295088>, <-0.900574, -0.329106, 0.27363>,
      <-0.923879, 0, 0.436259>, <-0.923879, -0.113813, 0.436259>, <-0.898991, -0.226988, 0.424507>, <-0.85355, -0.329106, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1, 0, -0>, <-1, -0.113686, 0>, <-0.973212, -0.226681, -0>, <-0.923879, -0.329106, -0>,
      <-1, 0.0163711, -0.373289>, <-1, -0.0973154, -0.373289>, <-0.973212, -0.211325, -0.351617>, <-0.923879, -0.31375, -0.351617>,
      <-0.976814, 0.0450368, -0.736345>, <-0.976814, -0.0715088, -0.743474>, <-0.945569, -0.188345, -0.738847>, <-0.902897, -0.287184, -0.69364>,
      <-0.923879, 0.0676174, -1.10553>, <-0.923879, -0.0489283, -1.11266>, <-0.896222, -0.167183, -1.08668>, <-0.85355, -0.266022, -1.04147>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.923879, 0, 0.436259>, <-0.923879, -0.113813, 0.436259>, <-0.898991, -0.226988, 0.424507>, <-0.85355, -0.329106, 0.40305>,
      <-0.874608, 0, 0.571863>, <-0.874608, -0.113813, 0.571863>, <-0.853471, -0.226988, 0.549788>, <-0.80803, -0.329106, 0.528331>,
      <-0.802246, 0, 0.697639>, <-0.802246, -0.114118, 0.697639>, <-0.775711, -0.227712, 0.683902>, <-0.741179, -0.329106, 0.644535>,
      <-0.707104, 0, 0.806101>, <-0.707104, -0.114118, 0.806101>, <-0.687812, -0.227712, 0.784107>, <-0.65328, -0.329106, 0.74474>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.707104, 0, 0.806101>, <-0.707104, -0.114118, 0.806101>, <-0.687812, -0.227712, 0.784107>, <-0.65328, -0.329106, 0.74474>,
      <-0.616594, 0, 0.909283>, <-0.616594, -0.114118, 0.909282>, <-0.604191, -0.227712, 0.879435>, <-0.569659, -0.329106, 0.840068>,
      <-0.506795, 0, 0.994614>, <-0.506795, -0.114422, 0.994614>, <-0.486777, -0.228414, 0.969981>, <-0.468217, -0.329106, 0.918902>,
      <-0.382683, 0, 1.05322>, <-0.382683, -0.114422, 1.05322>, <-0.372111, -0.228414, 1.02413>, <-0.353552, -0.329106, 0.973047>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0, 1.05322>, <-0.382683, -0.114422, 1.05322>, <-0.372111, -0.228414, 1.02413>, <-0.353552, -0.329106, 0.973047>,
      <-0.263264, 0, 1.10961>, <-0.263264, -0.114422, 1.10961>, <-0.261783, -0.228414, 1.07622>, <-0.243223, -0.329106, 1.02514>,
      <-0.132064, 0, 1.14>, <-0.132064, -0.114548, 1.14>, <-0.122011, -0.228698, 1.10835>, <-0.122011, -0.329106, 1.05322>,
      <-0, 0, 1.14>, <-0, -0.114548, 1.14>, <-0, -0.228698, 1.10835>, <-0, -0.329106, 1.05322>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0, 1.14>, <-0, -0.114548, 1.14>, <-0, -0.228698, 1.10835>, <-0, -0.329106, 1.05322>,
      <0.132064, 0, 1.14>, <0.132064, -0.114548, 1.14>, <0.122011, -0.228698, 1.10835>, <0.122011, -0.329106, 1.05322>,
      <0.263264, 0, 1.10961>, <0.263264, -0.114422, 1.10961>, <0.261783, -0.228414, 1.07622>, <0.243223, -0.329106, 1.02514>,
      <0.382683, 0, 1.05322>, <0.382683, -0.114422, 1.05322>, <0.372111, -0.228414, 1.02413>, <0.353552, -0.329106, 0.973047>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.382683, 0, 1.05322>, <0.382683, -0.114422, 1.05322>, <0.372111, -0.228414, 1.02413>, <0.353552, -0.329106, 0.973047>,
      <0.506795, 0, 0.994614>, <0.506795, -0.114422, 0.994614>, <0.486777, -0.228414, 0.969981>, <0.468217, -0.329106, 0.918902>,
      <0.616594, 0, 0.909283>, <0.616594, -0.114118, 0.909282>, <0.604191, -0.227712, 0.879435>, <0.569659, -0.329106, 0.840068>,
      <0.707104, 0, 0.806101>, <0.707104, -0.114118, 0.806101>, <0.687812, -0.227712, 0.784107>, <0.65328, -0.329106, 0.74474>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.707104, 0, 0.806101>, <0.707104, -0.114118, 0.806101>, <0.687812, -0.227712, 0.784107>, <0.65328, -0.329106, 0.74474>,
      <0.802246, 0, 0.697639>, <0.802246, -0.114118, 0.697639>, <0.775711, -0.227712, 0.683902>, <0.741179, -0.329106, 0.644535>,
      <0.874608, 0, 0.571863>, <0.874608, -0.113813, 0.571863>, <0.853471, -0.226988, 0.549788>, <0.80803, -0.329106, 0.528331>,
      <0.923879, 0, 0.436259>, <0.923879, -0.113813, 0.436259>, <0.898991, -0.226988, 0.424507>, <0.85355, -0.329106, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.923879, 0, 0.436259>, <0.923879, -0.113813, 0.436259>, <0.898991, -0.226988, 0.424507>, <0.85355, -0.329106, 0.40305>,
      <0.974778, 0, 0.296176>, <0.974778, -0.113813, 0.296176>, <0.946015, -0.226988, 0.295088>, <0.900574, -0.329106, 0.27363>,
      <1, -0.00653022, 0.1489>, <1, -0.120217, 0.1489>, <0.973212, -0.232689, 0.137567>, <0.923879, -0.335114, 0.137567>,
      <1, 0, -0>, <1, -0.113686, -0>, <0.973212, -0.226681, 0>, <0.923879, -0.329106, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1, 0, -0>, <1, -0.113686, -0>, <0.973212, -0.226681, 0>, <0.923879, -0.329106, -0>,
      <1, 0.0163711, -0.373289>, <1, -0.0973154, -0.373289>, <0.973212, -0.211325, -0.351617>, <0.923879, -0.31375, -0.351617>,
      <0.976814, 0.0450368, -0.736345>, <0.976814, -0.0715088, -0.743474>, <0.945569, -0.188345, -0.738847>, <0.902897, -0.287184, -0.69364>,
      <0.923879, 0.0676174, -1.10553>, <0.923879, -0.0489283, -1.11266>, <0.896222, -0.167183, -1.08668>, <0.85355, -0.266022, -1.04147>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.923879, 0.0676174, -1.10553>, <0.923879, -0.0489283, -1.11266>, <0.896222, -0.167183, -1.08668>, <0.85355, -0.266022, -1.04147>,
      <0.877931, 0.0872176, -1.426>, <0.877931, -0.029328, -1.43312>, <0.854209, -0.149166, -1.38281>, <0.811537, -0.248005, -1.33761>,
      <0.813019, 0.106226, -1.73679>, <0.813019, -0.0174192, -1.74435>, <0.780331, -0.139617, -1.70379>, <0.751132, -0.230352, -1.62467>,
      <0.707104, 0.124941, -2.04276>, <0.707104, 0.00129522, -2.05033>, <0.682479, -0.122327, -1.98648>, <0.65328, -0.213062, -1.90736>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.707104, 0.124941, -2.04276>, <0.707104, 0.00129522, -2.05033>, <0.682479, -0.122327, -1.98648>, <0.65328, -0.213062, -1.90736>,
      <0.629475, 0.138657, -2.26703>, <0.629475, 0.0150118, -2.27459>, <0.610759, -0.109654, -2.19367>, <0.58156, -0.200389, -2.11455>,
      <0.53495, 0.152099, -2.48679>, <0.53495, 0.0217392, -2.49477>, <0.508899, -0.102271, -2.41505>, <0.494229, -0.187971, -2.31759>,
      <0.382683, 0.163243, -2.669>, <0.382683, 0.0328835, -2.67697>, <0.368222, -0.0919754, -2.58338>, <0.353552, -0.177675, -2.48593>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.382683, 0.163243, -2.669>, <0.382683, 0.0328835, -2.67697>, <0.368222, -0.0919754, -2.58338>, <0.353552, -0.177675, -2.48593>,
      <0.28749, 0.17021, -2.78291>, <0.28749, 0.0398505, -2.79088>, <0.280275, -0.0855387, -2.68862>, <0.265605, -0.171238, -2.59117>,
      <0.148613, 0.176693, -2.88891>, <0.148613, 0.0436515, -2.89704>, <0.1373, -0.0810894, -2.79245>, <0.1373, -0.165249, -2.68909>,
      <-0, 0.176693, -2.88891>, <-0, 0.0436515, -2.89704>, <-0, -0.0810894, -2.79245>, <-0, -0.165249, -2.68909>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, 0.176693, -2.88891>, <-0, 0.0436515, -2.89704>, <-0, -0.0810894, -2.79245>, <-0, -0.165249, -2.68909>,
      <-0.148613, 0.176693, -2.88891>, <-0.148613, 0.0436515, -2.89704>, <-0.1373, -0.0810894, -2.79245>, <-0.1373, -0.165249, -2.68909>,
      <-0.28749, 0.17021, -2.78291>, <-0.28749, 0.0398505, -2.79088>, <-0.280275, -0.0855387, -2.68862>, <-0.265605, -0.171238, -2.59117>,
      <-0.382683, 0.163243, -2.669>, <-0.382683, 0.0328835, -2.67697>, <-0.368222, -0.0919754, -2.58338>, <-0.353552, -0.177675, -2.48593>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, 0.163243, -2.669>, <-0.382683, 0.0328835, -2.67697>, <-0.368222, -0.0919754, -2.58338>, <-0.353552, -0.177675, -2.48593>,
      <-0.53495, 0.152099, -2.48679>, <-0.53495, 0.0217392, -2.49477>, <-0.508899, -0.102271, -2.41505>, <-0.494229, -0.187971, -2.31759>,
      <-0.629475, 0.138657, -2.26703>, <-0.629475, 0.0150118, -2.27459>, <-0.610759, -0.109654, -2.19367>, <-0.58156, -0.200389, -2.11455>,
      <-0.707104, 0.124941, -2.04276>, <-0.707104, 0.00129522, -2.05033>, <-0.682479, -0.122327, -1.98648>, <-0.65328, -0.213062, -1.90736>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.707104, 0.124941, -2.04276>, <-0.707104, 0.00129522, -2.05033>, <-0.682479, -0.122327, -1.98648>, <-0.65328, -0.213062, -1.90736>,
      <-0.813019, 0.106226, -1.73679>, <-0.813019, -0.0174192, -1.74435>, <-0.780331, -0.139617, -1.70379>, <-0.751132, -0.230352, -1.62467>,
      <-0.877931, 0.0872176, -1.426>, <-0.877931, -0.029328, -1.43312>, <-0.854209, -0.149166, -1.38281>, <-0.811537, -0.248005, -1.33761>,
      <-0.923879, 0.0676174, -1.10553>, <-0.923879, -0.0489283, -1.11266>, <-0.896222, -0.167183, -1.08668>, <-0.85355, -0.266022, -1.04147>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.923879, -0.329106, -0>, <-0.872279, -0.436239, 0>, <-0.797261, -0.530576, -0>, <-0.707104, -0.608111, -0>,
      <-0.923879, -0.335114, 0.137567>, <-0.872279, -0.442246, 0.137567>, <-0.797261, -0.535148, 0.10529>, <-0.707104, -0.612683, 0.10529>,
      <-0.900574, -0.329106, 0.27363>, <-0.852708, -0.436676, 0.251027>, <-0.772209, -0.530906, 0.248592>, <-0.68927, -0.608111, 0.209427>,
      <-0.85355, -0.329106, 0.40305>, <-0.805683, -0.436676, 0.380447>, <-0.736219, -0.530906, 0.347645>, <-0.65328, -0.608111, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.923879, -0.329106, -0>, <-0.872279, -0.436239, 0>, <-0.797261, -0.530576, -0>, <-0.707104, -0.608111, -0>,
      <-0.923879, -0.31375, -0.351617>, <-0.872279, -0.420883, -0.351617>, <-0.797261, -0.518575, -0.276415>, <-0.707104, -0.59611, -0.276415>,
      <-0.902897, -0.287184, -0.69364>, <-0.851357, -0.406566, -0.639037>, <-0.769106, -0.497913, -0.633771>, <-0.691515, -0.575684, -0.545333>,
      <-0.85355, -0.266022, -1.04147>, <-0.80201, -0.385404, -0.986869>, <-0.730871, -0.481394, -0.907293>, <-0.65328, -0.559164, -0.818855>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.85355, -0.329106, 0.40305>, <-0.805683, -0.436676, 0.380447>, <-0.736219, -0.530906, 0.347645>, <-0.65328, -0.608111, 0.308481>,
      <-0.80803, -0.329106, 0.528331>, <-0.760163, -0.436676, 0.505728>, <-0.70138, -0.530906, 0.443531>, <-0.618441, -0.608111, 0.404367>,
      <-0.741179, -0.329106, 0.644535>, <-0.704197, -0.437697, 0.602374>, <-0.630147, -0.531645, 0.564979>, <-0.567275, -0.608111, 0.493304>,
      <-0.65328, -0.329106, 0.74474>, <-0.616297, -0.437697, 0.702579>, <-0.562872, -0.531645, 0.641672>, <-0.5, -0.608111, 0.569998>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.65328, -0.329106, 0.74474>, <-0.616297, -0.437697, 0.702579>, <-0.562872, -0.531645, 0.641672>, <-0.5, -0.608111, 0.569998>,
      <-0.569659, -0.329106, 0.840068>, <-0.532676, -0.437697, 0.797907>, <-0.498871, -0.531645, 0.714634>, <-0.435999, -0.608111, 0.64296>,
      <-0.468217, -0.329106, 0.918902>, <-0.448023, -0.438669, 0.863323>, <-0.392088, -0.532311, 0.796129>, <-0.358359, -0.608111, 0.703298>,
      <-0.353552, -0.329106, 0.973047>, <-0.333358, -0.438669, 0.917468>, <-0.304327, -0.532311, 0.83757>, <-0.270597, -0.608111, 0.74474>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, -0.329106, 0.973047>, <-0.333358, -0.438669, 0.917468>, <-0.304327, -0.532311, 0.83757>, <-0.270597, -0.608111, 0.74474>,
      <-0.243223, -0.329106, 1.02514>, <-0.223029, -0.438669, 0.969566>, <-0.219885, -0.532311, 0.877444>, <-0.186155, -0.608111, 0.784614>,
      <-0.122011, -0.329106, 1.05322>, <-0.122011, -0.439059, 0.992848>, <-0.0933829, -0.532568, 0.906239>, <-0.0933829, -0.608111, 0.806101>,
      <-0, -0.329106, 1.05322>, <-0, -0.439059, 0.992848>, <-0, -0.532568, 0.906239>, <-0, -0.608111, 0.806101>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, -0.329106, 1.05322>, <-0, -0.439059, 0.992848>, <-0, -0.532568, 0.906239>, <-0, -0.608111, 0.806101>,
      <0.122011, -0.329106, 1.05322>, <0.122011, -0.439059, 0.992848>, <0.0933829, -0.532568, 0.906239>, <0.0933829, -0.608111, 0.806101>,
      <0.243223, -0.329106, 1.02514>, <0.223029, -0.438669, 0.969566>, <0.219885, -0.532311, 0.877444>, <0.186155, -0.608111, 0.784614>,
      <0.353552, -0.329106, 0.973047>, <0.333358, -0.438669, 0.917468>, <0.304327, -0.532311, 0.83757>, <0.270597, -0.608111, 0.74474>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, -0.329106, 0.973047>, <0.333358, -0.438669, 0.917468>, <0.304327, -0.532311, 0.83757>, <0.270597, -0.608111, 0.74474>,
      <0.468217, -0.329106, 0.918902>, <0.448023, -0.438669, 0.863323>, <0.392088, -0.532311, 0.796129>, <0.358359, -0.608111, 0.703298>,
      <0.569659, -0.329106, 0.840068>, <0.532676, -0.437697, 0.797907>, <0.498871, -0.531645, 0.714634>, <0.435999, -0.608111, 0.64296>,
      <0.65328, -0.329106, 0.74474>, <0.616297, -0.437697, 0.702579>, <0.562872, -0.531645, 0.641672>, <0.5, -0.608111, 0.569998>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.65328, -0.329106, 0.74474>, <0.616297, -0.437697, 0.702579>, <0.562872, -0.531645, 0.641672>, <0.5, -0.608111, 0.569998>,
      <0.741179, -0.329106, 0.644535>, <0.704197, -0.437697, 0.602374>, <0.630147, -0.531645, 0.564979>, <0.567275, -0.608111, 0.493304>,
      <0.80803, -0.329106, 0.528331>, <0.760163, -0.436676, 0.505728>, <0.70138, -0.530906, 0.443531>, <0.618441, -0.608111, 0.404367>,
      <0.85355, -0.329106, 0.40305>, <0.805683, -0.436676, 0.380447>, <0.736219, -0.530906, 0.347645>, <0.65328, -0.608111, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.85355, -0.329106, 0.40305>, <0.805683, -0.436676, 0.380447>, <0.736219, -0.530906, 0.347645>, <0.65328, -0.608111, 0.308481>,
      <0.900574, -0.329106, 0.27363>, <0.852708, -0.436676, 0.251027>, <0.772209, -0.530906, 0.248592>, <0.68927, -0.608111, 0.209427>,
      <0.923879, -0.335114, 0.137567>, <0.872279, -0.442246, 0.137567>, <0.797261, -0.535148, 0.10529>, <0.707104, -0.612683, 0.10529>,
      <0.923879, -0.329106, -0>, <0.872279, -0.436239, -0>, <0.797261, -0.530576, 0>, <0.707104, -0.608111, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.923879, -0.329106, -0>, <0.872279, -0.436239, -0>, <0.797261, -0.530576, 0>, <0.707104, -0.608111, -0>,
      <0.923879, -0.31375, -0.351617>, <0.872279, -0.420883, -0.351617>, <0.797261, -0.518575, -0.276415>, <0.707104, -0.59611, -0.276415>,
      <0.902897, -0.287184, -0.69364>, <0.851357, -0.406566, -0.639037>, <0.769106, -0.497913, -0.633771>, <0.691515, -0.575684, -0.545333>,
      <0.85355, -0.266022, -1.04147>, <0.80201, -0.385404, -0.986869>, <0.730871, -0.481394, -0.907293>, <0.65328, -0.559164, -0.818855>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.85355, -0.266022, -1.04147>, <0.80201, -0.385404, -0.986869>, <0.730871, -0.481394, -0.907293>, <0.65328, -0.559164, -0.818855>,
      <0.811537, -0.248005, -1.33761>, <0.759997, -0.367387, -1.283>, <0.699178, -0.4677, -1.13402>, <0.621587, -0.545471, -1.04558>,
      <0.751132, -0.230352, -1.62467>, <0.707815, -0.364958, -1.5073>, <0.630668, -0.4543, -1.42221>, <0.574893, -0.531863, -1.26522>,
      <0.65328, -0.213062, -1.90736>, <0.609963, -0.347668, -1.78998>, <0.555775, -0.441067, -1.63856>, <0.5, -0.51863, -1.48158>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.65328, -0.213062, -1.90736>, <0.609963, -0.347668, -1.78998>, <0.555775, -0.441067, -1.63856>, <0.5, -0.51863, -1.48158>,
      <0.58156, -0.200389, -2.11455>, <0.538243, -0.334996, -1.99718>, <0.500883, -0.431368, -1.79714>, <0.445108, -0.508931, -1.64016>,
      <0.494229, -0.187971, -2.31759>, <0.469708, -0.331215, -2.1547>, <0.407735, -0.420754, -1.99704>, <0.378266, -0.499427, -1.79555>,
      <0.353552, -0.177675, -2.48593>, <0.329032, -0.320919, -2.32303>, <0.300066, -0.412874, -2.12588>, <0.270597, -0.491546, -1.92439>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, -0.177675, -2.48593>, <0.329032, -0.320919, -2.32303>, <0.300066, -0.412874, -2.12588>, <0.270597, -0.491546, -1.92439>,
      <0.265605, -0.171238, -2.59117>, <0.241085, -0.314483, -2.42827>, <0.232754, -0.407948, -2.20643>, <0.203285, -0.48662, -2.00494>,
      <0.1373, -0.165249, -2.68909>, <0.1373, -0.311162, -2.50989>, <0.105085, -0.402813, -2.29698>, <0.105085, -0.482036, -2.07989>,
      <-0, -0.165249, -2.68909>, <-0, -0.311162, -2.50989>, <-0, -0.402813, -2.29698>, <-0, -0.482036, -2.07989>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, -0.165249, -2.68909>, <-0, -0.311162, -2.50989>, <-0, -0.402813, -2.29698>, <-0, -0.482036, -2.07989>,
      <-0.1373, -0.165249, -2.68909>, <-0.1373, -0.311162, -2.50989>, <-0.105085, -0.402813, -2.29698>, <-0.105085, -0.482036, -2.07989>,
      <-0.265605, -0.171238, -2.59117>, <-0.241085, -0.314483, -2.42827>, <-0.232754, -0.407948, -2.20643>, <-0.203285, -0.48662, -2.00494>,
      <-0.353552, -0.177675, -2.48593>, <-0.329032, -0.320919, -2.32303>, <-0.300066, -0.412874, -2.12588>, <-0.270597, -0.491546, -1.92439>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, -0.177675, -2.48593>, <-0.329032, -0.320919, -2.32303>, <-0.300066, -0.412874, -2.12588>, <-0.270597, -0.491546, -1.92439>,
      <-0.494229, -0.187971, -2.31759>, <-0.469708, -0.331215, -2.1547>, <-0.407735, -0.420754, -1.99704>, <-0.378266, -0.499427, -1.79555>,
      <-0.58156, -0.200389, -2.11455>, <-0.538243, -0.334996, -1.99718>, <-0.500883, -0.431368, -1.79714>, <-0.445108, -0.508931, -1.64016>,
      <-0.65328, -0.213062, -1.90736>, <-0.609963, -0.347668, -1.78998>, <-0.555775, -0.441067, -1.63856>, <-0.5, -0.51863, -1.48158>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.65328, -0.213062, -1.90736>, <-0.609963, -0.347668, -1.78998>, <-0.555775, -0.441067, -1.63856>, <-0.5, -0.51863, -1.48158>,
      <-0.751132, -0.230352, -1.62467>, <-0.707815, -0.364958, -1.5073>, <-0.630668, -0.4543, -1.42221>, <-0.574893, -0.531863, -1.26522>,
      <-0.811537, -0.248005, -1.33761>, <-0.759997, -0.367387, -1.283>, <-0.699178, -0.4677, -1.13402>, <-0.621587, -0.545471, -1.04558>,
      <-0.85355, -0.266022, -1.04147>, <-0.80201, -0.385404, -0.986869>, <-0.730871, -0.481394, -0.907293>, <-0.65328, -0.559164, -0.818855>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.707104, -0.608111, -0>, <-0.611627, -0.690221, 0>, <-0.50131, -0.752276, -0>, <-0.382683, -0.794534, -0>,
      <-0.707104, -0.612683, 0.10529>, <-0.611627, -0.694793, 0.10529>, <-0.501309, -0.754718, 0.0569842>, <-0.382683, -0.796976, 0.0569842>,
      <-0.68927, -0.608111, 0.209427>, <-0.600727, -0.690532, 0.167617>, <-0.482313, -0.752397, 0.164945>, <-0.37303, -0.794534, 0.113342>,
      <-0.65328, -0.608111, 0.308481>, <-0.564737, -0.690532, 0.266671>, <-0.462835, -0.752397, 0.218553>, <-0.353552, -0.794534, 0.166949>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.707104, -0.608111, -0>, <-0.611627, -0.690221, 0>, <-0.50131, -0.752276, -0>, <-0.382683, -0.794534, -0>,
      <-0.707104, -0.59611, -0.276415>, <-0.611627, -0.67822, -0.276415>, <-0.501309, -0.745458, -0.159133>, <-0.382683, -0.787716, -0.159133>,
      <-0.691515, -0.575684, -0.545333>, <-0.598249, -0.669165, -0.439029>, <-0.476439, -0.729739, -0.441367>, <-0.374825, -0.776532, -0.313999>,
      <-0.65328, -0.559164, -0.818855>, <-0.560015, -0.652645, -0.712551>, <-0.455166, -0.720383, -0.598942>, <-0.353552, -0.767176, -0.471574>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.65328, -0.608111, 0.308481>, <-0.564737, -0.690532, 0.266671>, <-0.462835, -0.752397, 0.218553>, <-0.353552, -0.794534, 0.166949>,
      <-0.618441, -0.608111, 0.404367>, <-0.529898, -0.690532, 0.362556>, <-0.44398, -0.752397, 0.270446>, <-0.334697, -0.794534, 0.218842>,
      <-0.567275, -0.608111, 0.493304>, <-0.498943, -0.691218, 0.415406>, <-0.390133, -0.752657, 0.361739>, <-0.307006, -0.794534, 0.266975>,
      <-0.5, -0.608111, 0.569998>, <-0.431668, -0.691218, 0.4921>, <-0.353724, -0.752657, 0.403245>, <-0.270597, -0.794534, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.5, -0.608111, 0.569998>, <-0.431668, -0.691218, 0.4921>, <-0.353724, -0.752657, 0.403245>, <-0.270597, -0.794534, 0.308481>,
      <-0.435999, -0.608111, 0.64296>, <-0.367667, -0.691218, 0.565061>, <-0.319087, -0.752657, 0.442731>, <-0.23596, -0.794534, 0.347967>,
      <-0.358359, -0.608111, 0.703298>, <-0.321107, -0.691826, 0.600775>, <-0.238692, -0.752878, 0.503784>, <-0.193942, -0.794534, 0.380622>,
      <-0.270597, -0.608111, 0.74474>, <-0.233346, -0.691826, 0.642217>, <-0.191196, -0.752878, 0.526212>, <-0.146446, -0.794534, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, -0.608111, 0.74474>, <-0.233346, -0.691826, 0.642217>, <-0.191196, -0.752878, 0.526212>, <-0.146446, -0.794534, 0.40305>,
      <-0.186155, -0.608111, 0.784614>, <-0.148904, -0.691826, 0.682091>, <-0.145497, -0.752878, 0.547792>, <-0.100746, -0.794534, 0.42463>,
      <-0.0933829, -0.608111, 0.806101>, <-0.0933829, -0.692058, 0.694823>, <-0.0505385, -0.75296, 0.569306>, <-0.0505385, -0.794534, 0.436259>,
      <-0, -0.608111, 0.806101>, <-0, -0.692058, 0.694823>, <-0, -0.75296, 0.569306>, <-0, -0.794534, 0.436259>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, -0.608111, 0.806101>, <-0, -0.692058, 0.694823>, <-0, -0.75296, 0.569306>, <-0, -0.794534, 0.436259>,
      <0.0933829, -0.608111, 0.806101>, <0.0933829, -0.692058, 0.694823>, <0.0505385, -0.75296, 0.569306>, <0.0505385, -0.794534, 0.436259>,
      <0.186155, -0.608111, 0.784614>, <0.148904, -0.691826, 0.682091>, <0.145497, -0.752878, 0.547792>, <0.100746, -0.794534, 0.42463>,
      <0.270597, -0.608111, 0.74474>, <0.233346, -0.691826, 0.642217>, <0.191196, -0.752878, 0.526212>, <0.146446, -0.794534, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, -0.608111, 0.74474>, <0.233346, -0.691826, 0.642217>, <0.191196, -0.752878, 0.526212>, <0.146446, -0.794534, 0.40305>,
      <0.358359, -0.608111, 0.703298>, <0.321107, -0.691826, 0.600775>, <0.238692, -0.752878, 0.503784>, <0.193942, -0.794534, 0.380622>,
      <0.435999, -0.608111, 0.64296>, <0.367667, -0.691218, 0.565061>, <0.319087, -0.752657, 0.442731>, <0.23596, -0.794534, 0.347967>,
      <0.5, -0.608111, 0.569998>, <0.431668, -0.691218, 0.4921>, <0.353724, -0.752657, 0.403245>, <0.270597, -0.794534, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.5, -0.608111, 0.569998>, <0.431668, -0.691218, 0.4921>, <0.353724, -0.752657, 0.403245>, <0.270597, -0.794534, 0.308481>,
      <0.567275, -0.608111, 0.493304>, <0.498943, -0.691218, 0.415406>, <0.390133, -0.752657, 0.361739>, <0.307006, -0.794534, 0.266975>,
      <0.618441, -0.608111, 0.404367>, <0.529898, -0.690532, 0.362556>, <0.44398, -0.752397, 0.270446>, <0.334697, -0.794534, 0.218842>,
      <0.65328, -0.608111, 0.308481>, <0.564737, -0.690532, 0.266671>, <0.462835, -0.752397, 0.218553>, <0.353552, -0.794534, 0.166949>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.65328, -0.608111, 0.308481>, <0.564737, -0.690532, 0.266671>, <0.462835, -0.752397, 0.218553>, <0.353552, -0.794534, 0.166949>,
      <0.68927, -0.608111, 0.209427>, <0.600727, -0.690532, 0.167617>, <0.482313, -0.752397, 0.164945>, <0.37303, -0.794534, 0.113342>,
      <0.707104, -0.612683, 0.10529>, <0.611627, -0.694793, 0.10529>, <0.501309, -0.754718, 0.0569842>, <0.382683, -0.796976, 0.0569842>,
      <0.707104, -0.608111, -0>, <0.611627, -0.690221, -0>, <0.50131, -0.752276, 0>, <0.382683, -0.794534, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.707104, -0.608111, -0>, <0.611627, -0.690221, -0>, <0.50131, -0.752276, 0>, <0.382683, -0.794534, -0>,
      <0.707104, -0.59611, -0.276415>, <0.611627, -0.67822, -0.276415>, <0.501309, -0.745458, -0.159133>, <0.382683, -0.787716, -0.159133>,
      <0.691515, -0.575684, -0.545333>, <0.598249, -0.669165, -0.439029>, <0.476439, -0.729739, -0.441367>, <0.374825, -0.776532, -0.313999>,
      <0.65328, -0.559164, -0.818855>, <0.560015, -0.652645, -0.712551>, <0.455166, -0.720383, -0.598942>, <0.353552, -0.767176, -0.471574>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.65328, -0.559164, -0.818855>, <0.560015, -0.652645, -0.712551>, <0.455166, -0.720383, -0.598942>, <0.353552, -0.767176, -0.471574>,
      <0.621587, -0.545471, -1.04558>, <0.528322, -0.638952, -0.939274>, <0.438589, -0.713092, -0.721729>, <0.336975, -0.759886, -0.594361>,
      <0.574893, -0.531863, -1.26522>, <0.500655, -0.635102, -1.05626>, <0.387544, -0.700229, -0.939573>, <0.311129, -0.752401, -0.713143>,
      <0.5, -0.51863, -1.48158>, <0.425762, -0.621869, -1.27262>, <0.347012, -0.693068, -1.05667>, <0.270597, -0.745239, -0.830236>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.5, -0.51863, -1.48158>, <0.425762, -0.621869, -1.27262>, <0.347012, -0.693068, -1.05667>, <0.270597, -0.745239, -0.830236>,
      <0.445108, -0.508931, -1.64016>, <0.37087, -0.61217, -1.4312>, <0.317305, -0.687819, -1.14249>, <0.24089, -0.73999, -0.916058>,
      <0.378266, -0.499427, -1.79555>, <0.337561, -0.608097, -1.51724>, <0.245968, -0.678676, -1.29353>, <0.204716, -0.734846, -1.00016>,
      <0.270597, -0.491546, -1.92439>, <0.229892, -0.600217, -1.64608>, <0.187699, -0.674411, -1.36326>, <0.146446, -0.730582, -1.06989>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, -0.491546, -1.92439>, <0.229892, -0.600217, -1.64608>, <0.187699, -0.674411, -1.36326>, <0.146446, -0.730582, -1.06989>,
      <0.203285, -0.48662, -2.00494>, <0.16258, -0.59529, -1.72662>, <0.15127, -0.671745, -1.40685>, <0.110017, -0.727916, -1.11348>,
      <0.105085, -0.482036, -2.07989>, <0.105085, -0.592487, -1.77723>, <0.0568717, -0.667829, -1.47104>, <0.0568717, -0.725435, -1.15404>,
      <-0, -0.482036, -2.07989>, <-0, -0.592487, -1.77723>, <-0, -0.667829, -1.47104>, <-0, -0.725435, -1.15404>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, -0.482036, -2.07989>, <-0, -0.592487, -1.77723>, <-0, -0.667829, -1.47104>, <-0, -0.725435, -1.15404>,
      <-0.105085, -0.482036, -2.07989>, <-0.105085, -0.592487, -1.77723>, <-0.0568717, -0.667829, -1.47104>, <-0.0568717, -0.725435, -1.15404>,
      <-0.203285, -0.48662, -2.00494>, <-0.16258, -0.59529, -1.72662>, <-0.15127, -0.671745, -1.40685>, <-0.110017, -0.727916, -1.11348>,
      <-0.270597, -0.491546, -1.92439>, <-0.229892, -0.600217, -1.64608>, <-0.187699, -0.674411, -1.36326>, <-0.146446, -0.730582, -1.06989>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, -0.491546, -1.92439>, <-0.229892, -0.600217, -1.64608>, <-0.187699, -0.674411, -1.36326>, <-0.146446, -0.730582, -1.06989>,
      <-0.378266, -0.499427, -1.79555>, <-0.337561, -0.608097, -1.51724>, <-0.245968, -0.678676, -1.29353>, <-0.204716, -0.734846, -1.00016>,
      <-0.445108, -0.508931, -1.64016>, <-0.37087, -0.61217, -1.4312>, <-0.317305, -0.687819, -1.14249>, <-0.24089, -0.73999, -0.916058>,
      <-0.5, -0.51863, -1.48158>, <-0.425762, -0.621869, -1.27262>, <-0.347012, -0.693068, -1.05667>, <-0.270597, -0.745239, -0.830236>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.5, -0.51863, -1.48158>, <-0.425762, -0.621869, -1.27262>, <-0.347012, -0.693068, -1.05667>, <-0.270597, -0.745239, -0.830236>,
      <-0.574893, -0.531863, -1.26522>, <-0.500655, -0.635102, -1.05626>, <-0.387544, -0.700229, -0.939573>, <-0.311129, -0.752401, -0.713143>,
      <-0.621587, -0.545471, -1.04558>, <-0.528322, -0.638952, -0.939274>, <-0.438589, -0.713092, -0.721729>, <-0.336975, -0.759886, -0.594361>,
      <-0.65328, -0.559164, -0.818855>, <-0.560015, -0.652645, -0.712551>, <-0.455166, -0.720383, -0.598942>, <-0.353552, -0.767176, -0.471574>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, -0.794534, -0>, <-0.382683, -0.787716, -0.159133>, <-0.374825, -0.776532, -0.313999>, <-0.353552, -0.767176, -0.471574>,
      <-0.382683, -0.796976, 0.0569842>, <-0.382683, -0.790157, -0.102149>, <-0.254459, -0.831961, -0.163125>, <-0.233185, -0.822605, -0.3207>,
      <-0.37303, -0.794534, 0.113342>, <-0.25911, -0.838459, 0.0595479>, <-0.247956, -0.858066, -0.0451438>, <-0.148974, -0.854236, -0.134525>,
      <-0.353552, -0.794534, 0.166949>, <-0.239632, -0.838459, 0.113155>, <-0.0989815, -0.86383, 0.0893814>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, -0.794534, -0>, <-0.382683, -0.796976, 0.0569842>, <-0.37303, -0.794534, 0.113342>, <-0.353552, -0.794534, 0.166949>,
      <-0.259595, -0.838381, 0>, <-0.259595, -0.840823, 0.0569842>, <-0.25911, -0.838459, 0.0595479>, <-0.239632, -0.838459, 0.113155>,
      <-0.129414, -0.86, -0>, <-0.129414, -0.86, 0>, <-0.0989815, -0.86383, 0.0893814>, <-0.0989815, -0.86383, 0.0893814>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, -0.794534, -0>, <-0.259595, -0.838381, 0>, <-0.129414, -0.86, -0>, <-0, -0.86, -0>,
      <-0.382683, -0.796976, 0.0569842>, <-0.259595, -0.840823, 0.0569842>, <-0.189399, -0.865464, 0.126214>, <-0.0599853, -0.865464, 0.126214>,
      <-0.37303, -0.794534, 0.113342>, <-0.354175, -0.794534, 0.165235>, <-0.219486, -0.838624, 0.167203>, <-0.183077, -0.838624, 0.208709>,
      <-0.353552, -0.794534, 0.166949>, <-0.334697, -0.794534, 0.218842>, <-0.307006, -0.794534, 0.266975>, <-0.270597, -0.794534, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, -0.794534, -0>, <-0.382683, -0.787716, -0.159133>, <-0.374825, -0.776532, -0.313999>, <-0.353552, -0.767176, -0.471574>,
      <-0.259595, -0.838381, 0>, <-0.259595, -0.831563, -0.159133>, <-0.254459, -0.831961, -0.163125>, <-0.233185, -0.822605, -0.3207>,
      <-0.129414, -0.86, -0>, <-0.129414, -0.86, 0>, <-0.148974, -0.854236, -0.134525>, <-0.148974, -0.854236, -0.134525>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.382683, -0.794534, -0>, <-0.259595, -0.838381, 0>, <-0.129414, -0.86, -0>, <-0, -0.86, -0>,
      <-0.382683, -0.787716, -0.159133>, <-0.259595, -0.831563, -0.159133>, <-0.256553, -0.84842, -0.267512>, <-0.127139, -0.848419, -0.267512>,
      <-0.374825, -0.776532, -0.313999>, <-0.358248, -0.769242, -0.436787>, <-0.218528, -0.815623, -0.438754>, <-0.177997, -0.808461, -0.555847>,
      <-0.353552, -0.767176, -0.471574>, <-0.336975, -0.759886, -0.594361>, <-0.311129, -0.752401, -0.713143>, <-0.270597, -0.745239, -0.830236>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, -0.794534, 0.166949>, <-0.334697, -0.794534, 0.218842>, <-0.307006, -0.794534, 0.266975>, <-0.270597, -0.794534, 0.308481>,
      <-0.239632, -0.838459, 0.113155>, <-0.220776, -0.838459, 0.165048>, <-0.219486, -0.838624, 0.167203>, <-0.183077, -0.838624, 0.208709>,
      <-0.0989815, -0.86383, 0.0893814>, <-0.0989815, -0.86383, 0.0893814>, <-0.0599853, -0.865464, 0.126214>, <-0.0599853, -0.865464, 0.126214>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.353552, -0.794534, 0.166949>, <-0.239632, -0.838459, 0.113155>, <-0.0989815, -0.86383, 0.0893814>, <-0, -0.86, -0>,
      <-0.334697, -0.794534, 0.218842>, <-0.220776, -0.838459, 0.165048>, <-0.12743, -0.870041, 0.232445>, <-0.0284482, -0.866212, 0.143064>,
      <-0.307006, -0.794534, 0.266975>, <-0.272369, -0.794534, 0.306461>, <-0.146427, -0.838764, 0.24985>, <-0.0989309, -0.838764, 0.272278>,
      <-0.270597, -0.794534, 0.308481>, <-0.23596, -0.794534, 0.347967>, <-0.193942, -0.794534, 0.380622>, <-0.146446, -0.794534, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, -0.794534, 0.308481>, <-0.23596, -0.794534, 0.347967>, <-0.193942, -0.794534, 0.380622>, <-0.146446, -0.794534, 0.40305>,
      <-0.183077, -0.838624, 0.208709>, <-0.14844, -0.838624, 0.248195>, <-0.146427, -0.838764, 0.24985>, <-0.0989309, -0.838764, 0.272278>,
      <-0.0599853, -0.865464, 0.126214>, <-0.0599853, -0.865464, 0.126214>, <-0.0284482, -0.866212, 0.143064>, <-0.0284482, -0.866212, 0.143064>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, -0.794534, 0.308481>, <-0.183077, -0.838624, 0.208709>, <-0.0599853, -0.865464, 0.126214>, <-0, -0.86, -0>,
      <-0.23596, -0.794534, 0.347967>, <-0.14844, -0.838624, 0.248195>, <-0.0599853, -0.871909, 0.274543>, <-0, -0.866445, 0.148329>,
      <-0.193942, -0.794534, 0.380622>, <-0.148242, -0.794534, 0.402202>, <-0.0505385, -0.838816, 0.294547>, <-0, -0.838816, 0.294547>,
      <-0.146446, -0.794534, 0.40305>, <-0.100746, -0.794534, 0.42463>, <-0.0505385, -0.794534, 0.436259>, <-0, -0.794534, 0.436259>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, -0.794534, 0.40305>, <-0.100746, -0.794534, 0.42463>, <-0.0505385, -0.794534, 0.436259>, <-0, -0.794534, 0.436259>,
      <-0.0989309, -0.838764, 0.272278>, <-0.0532313, -0.838764, 0.293858>, <-0.0505385, -0.838816, 0.294547>, <-0, -0.838816, 0.294547>,
      <-0.0284482, -0.866212, 0.143064>, <-0.0284482, -0.866212, 0.143064>, <-0, -0.866445, 0.148329>, <-0, -0.866445, 0.148329>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, -0.794534, 0.40305>, <-0.0989309, -0.838764, 0.272278>, <-0.0284482, -0.866212, 0.143064>, <-0, -0.86, -0>,
      <-0.100746, -0.794534, 0.42463>, <-0.0532313, -0.838764, 0.293858>, <-0, -0.872423, 0.286128>, <0.0284482, -0.866212, 0.143064>,
      <-0.0505385, -0.794534, 0.436259>, <-0, -0.794534, 0.436259>, <0.0532313, -0.838764, 0.293858>, <0.0989309, -0.838764, 0.272278>,
      <-0, -0.794534, 0.436259>, <0.0505385, -0.794534, 0.436259>, <0.100746, -0.794534, 0.42463>, <0.146446, -0.794534, 0.40305>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, -0.794534, 0.436259>, <0.0505385, -0.794534, 0.436259>, <0.100746, -0.794534, 0.42463>, <0.146446, -0.794534, 0.40305>,
      <-0, -0.838816, 0.294547>, <0.0505385, -0.838816, 0.294547>, <0.0532313, -0.838764, 0.293858>, <0.0989309, -0.838764, 0.272278>,
      <-0, -0.866445, 0.148329>, <-0, -0.866445, 0.148329>, <0.0284482, -0.866212, 0.143064>, <0.0284482, -0.866212, 0.143064>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, -0.794534, 0.436259>, <-0, -0.838816, 0.294547>, <-0, -0.866445, 0.148329>, <-0, -0.86, -0>,
      <0.0505385, -0.794534, 0.436259>, <0.0505385, -0.838816, 0.294547>, <0.0599853, -0.871909, 0.274543>, <0.0599853, -0.865464, 0.126214>,
      <0.100746, -0.794534, 0.42463>, <0.148242, -0.794534, 0.402202>, <0.14844, -0.838624, 0.248195>, <0.183077, -0.838624, 0.208709>,
      <0.146446, -0.794534, 0.40305>, <0.193942, -0.794534, 0.380622>, <0.23596, -0.794534, 0.347967>, <0.270597, -0.794534, 0.308481>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, -0.794534, 0.40305>, <0.193942, -0.794534, 0.380622>, <0.23596, -0.794534, 0.347967>, <0.270597, -0.794534, 0.308481>,
      <0.0989309, -0.838764, 0.272278>, <0.146427, -0.838764, 0.24985>, <0.14844, -0.838624, 0.248195>, <0.183077, -0.838624, 0.208709>,
      <0.0284482, -0.866212, 0.143064>, <0.0284482, -0.866212, 0.143064>, <0.0599853, -0.865464, 0.126214>, <0.0599853, -0.865464, 0.126214>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, -0.794534, 0.40305>, <0.0989309, -0.838764, 0.272278>, <0.0284482, -0.866212, 0.143064>, <-0, -0.86, -0>,
      <0.193942, -0.794534, 0.380622>, <0.146427, -0.838764, 0.24985>, <0.12743, -0.870041, 0.232445>, <0.0989815, -0.86383, 0.0893814>,
      <0.23596, -0.794534, 0.347967>, <0.272369, -0.794534, 0.306461>, <0.220776, -0.838459, 0.165048>, <0.239632, -0.838459, 0.113155>,
      <0.270597, -0.794534, 0.308481>, <0.307006, -0.794534, 0.266975>, <0.334697, -0.794534, 0.218842>, <0.353552, -0.794534, 0.166949>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, -0.794534, 0.308481>, <0.307006, -0.794534, 0.266975>, <0.334697, -0.794534, 0.218842>, <0.353552, -0.794534, 0.166949>,
      <0.183077, -0.838624, 0.208709>, <0.219486, -0.838624, 0.167203>, <0.220776, -0.838459, 0.165048>, <0.239632, -0.838459, 0.113155>,
      <0.0599853, -0.865464, 0.126214>, <0.0599853, -0.865464, 0.126214>, <0.0989815, -0.86383, 0.0893814>, <0.0989815, -0.86383, 0.0893814>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, -0.794534, 0.308481>, <0.183077, -0.838624, 0.208709>, <0.0599853, -0.865464, 0.126214>, <-0, -0.86, -0>,
      <0.307006, -0.794534, 0.266975>, <0.219486, -0.838624, 0.167203>, <0.189399, -0.865464, 0.126214>, <0.129414, -0.86, 0>,
      <0.334697, -0.794534, 0.218842>, <0.354175, -0.794534, 0.165235>, <0.259595, -0.840823, 0.0569842>, <0.259595, -0.838381, -0>,
      <0.353552, -0.794534, 0.166949>, <0.37303, -0.794534, 0.113342>, <0.382683, -0.796976, 0.0569842>, <0.382683, -0.794534, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, -0.794534, 0.166949>, <0.37303, -0.794534, 0.113342>, <0.382683, -0.796976, 0.0569842>, <0.382683, -0.794534, -0>,
      <0.239632, -0.838459, 0.113155>, <0.25911, -0.838459, 0.0595479>, <0.259595, -0.840823, 0.0569842>, <0.259595, -0.838381, -0>,
      <0.0989815, -0.86383, 0.0893814>, <0.0989815, -0.86383, 0.0893814>, <0.129414, -0.86, 0>, <0.129414, -0.86, 0>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, -0.794534, 0.166949>, <0.239632, -0.838459, 0.113155>, <0.0989815, -0.86383, 0.0893814>, <-0, -0.86, -0>,
      <0.37303, -0.794534, 0.113342>, <0.25911, -0.838459, 0.0595479>, <0.247956, -0.858066, -0.0451438>, <0.148974, -0.854236, -0.134525>,
      <0.382683, -0.796976, 0.0569842>, <0.382683, -0.790157, -0.102149>, <0.254459, -0.831961, -0.163125>, <0.233185, -0.822605, -0.3207>,
      <0.382683, -0.794534, -0>, <0.382683, -0.787716, -0.159133>, <0.374825, -0.776532, -0.313999>, <0.353552, -0.767176, -0.471574>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.382683, -0.794534, -0>, <0.382683, -0.787716, -0.159133>, <0.374825, -0.776532, -0.313999>, <0.353552, -0.767176, -0.471574>,
      <0.259595, -0.838381, -0>, <0.259595, -0.831563, -0.159133>, <0.254459, -0.831961, -0.163125>, <0.233185, -0.822605, -0.3207>,
      <0.129414, -0.86, 0>, <0.129414, -0.86, 0>, <0.148974, -0.854236, -0.134525>, <0.148974, -0.854236, -0.134525>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.382683, -0.794534, -0>, <0.259595, -0.838381, -0>, <0.129414, -0.86, 0>, <-0, -0.86, -0>,
      <0.382683, -0.787716, -0.159133>, <0.259595, -0.831563, -0.159133>, <0.256553, -0.84842, -0.267512>, <0.127139, -0.848419, -0.267512>,
      <0.374825, -0.776532, -0.313999>, <0.358248, -0.769242, -0.436787>, <0.218528, -0.815623, -0.438754>, <0.177997, -0.808461, -0.555847>,
      <0.353552, -0.767176, -0.471574>, <0.336975, -0.759886, -0.594361>, <0.311129, -0.752401, -0.713143>, <0.270597, -0.745239, -0.830236>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, -0.767176, -0.471574>, <0.336975, -0.759886, -0.594361>, <0.311129, -0.752401, -0.713143>, <0.270597, -0.745239, -0.830236>,
      <0.233185, -0.822605, -0.3207>, <0.216608, -0.815315, -0.443487>, <0.218528, -0.815623, -0.438754>, <0.177997, -0.808461, -0.555847>,
      <0.148974, -0.854236, -0.134525>, <0.148974, -0.854236, -0.134525>, <0.127139, -0.84842, -0.267512>, <0.127139, -0.848419, -0.267512>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.353552, -0.767176, -0.471574>, <0.233185, -0.822605, -0.3207>, <0.148974, -0.854236, -0.134525>, <-0, -0.86, -0>,
      <0.336975, -0.759886, -0.594361>, <0.216608, -0.815315, -0.443487>, <0.220297, -0.838663, -0.493205>, <0.0713232, -0.844427, -0.35868>,
      <0.311129, -0.752401, -0.713143>, <0.281421, -0.747152, -0.798965>, <0.15464, -0.803032, -0.644035>, <0.09637, -0.798767, -0.713762>,
      <0.270597, -0.745239, -0.830236>, <0.24089, -0.73999, -0.916058>, <0.204716, -0.734846, -1.00016>, <0.146446, -0.730582, -1.06989>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, -0.745239, -0.830236>, <0.24089, -0.73999, -0.916058>, <0.204716, -0.734846, -1.00016>, <0.146446, -0.730582, -1.06989>,
      <0.177997, -0.808461, -0.555847>, <0.148289, -0.803212, -0.641669>, <0.15464, -0.803032, -0.644035>, <0.09637, -0.798767, -0.713762>,
      <0.127139, -0.848419, -0.267512>, <0.127139, -0.84842, -0.267512>, <0.0713232, -0.844427, -0.35868>, <0.0713232, -0.844427, -0.35868>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.270597, -0.745239, -0.830236>, <0.177997, -0.808461, -0.555847>, <0.127139, -0.848419, -0.267512>, <-0, -0.86, -0>,
      <0.24089, -0.73999, -0.916058>, <0.148289, -0.803212, -0.641669>, <0.127139, -0.831445, -0.658173>, <-0, -0.843026, -0.390661>,
      <0.204716, -0.734846, -1.00016>, <0.168287, -0.73218, -1.04375>, <0.0568717, -0.795349, -0.769311>, <-0, -0.795349, -0.769311>,
      <0.146446, -0.730582, -1.06989>, <0.110017, -0.727916, -1.11348>, <0.0568717, -0.725435, -1.15404>, <-0, -0.725435, -1.15404>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, -0.730582, -1.06989>, <0.110017, -0.727916, -1.11348>, <0.0568717, -0.725435, -1.15404>, <-0, -0.725435, -1.15404>,
      <0.09637, -0.798767, -0.713762>, <0.0599413, -0.796101, -0.757354>, <0.0568717, -0.795349, -0.769311>, <-0, -0.795349, -0.769311>,
      <0.0713232, -0.844427, -0.35868>, <0.0713232, -0.844427, -0.35868>, <-0, -0.843026, -0.390661>, <-0, -0.843026, -0.390661>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.146446, -0.730582, -1.06989>, <0.09637, -0.798767, -0.713762>, <0.0713232, -0.844427, -0.35868>, <-0, -0.86, -0>,
      <0.110017, -0.727916, -1.11348>, <0.0599413, -0.796101, -0.757354>, <-0, -0.828854, -0.717359>, <-0.0713232, -0.844427, -0.35868>,
      <0.0568717, -0.725435, -1.15404>, <-0, -0.725435, -1.15404>, <-0.0599413, -0.796101, -0.757354>, <-0.09637, -0.798767, -0.713762>,
      <-0, -0.725435, -1.15404>, <-0.0568717, -0.725435, -1.15404>, <-0.110017, -0.727916, -1.11348>, <-0.146446, -0.730582, -1.06989>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, -0.725435, -1.15404>, <-0.0568717, -0.725435, -1.15404>, <-0.110017, -0.727916, -1.11348>, <-0.146446, -0.730582, -1.06989>,
      <-0, -0.795349, -0.769311>, <-0.0568717, -0.795349, -0.769311>, <-0.0599413, -0.796101, -0.757354>, <-0.09637, -0.798767, -0.713762>,
      <-0, -0.843026, -0.390661>, <-0, -0.843026, -0.390661>, <-0.0713232, -0.844427, -0.35868>, <-0.0713232, -0.844427, -0.35868>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0, -0.725435, -1.15404>, <-0, -0.795349, -0.769311>, <-0, -0.843026, -0.390661>, <-0, -0.86, -0>,
      <-0.0568717, -0.725435, -1.15404>, <-0.0568717, -0.795349, -0.769311>, <-0.127139, -0.831445, -0.658173>, <-0.127139, -0.848419, -0.267512>,
      <-0.110017, -0.727916, -1.11348>, <-0.168287, -0.73218, -1.04375>, <-0.148289, -0.803212, -0.641669>, <-0.177997, -0.808461, -0.555847>,
      <-0.146446, -0.730582, -1.06989>, <-0.204716, -0.734846, -1.00016>, <-0.24089, -0.73999, -0.916058>, <-0.270597, -0.745239, -0.830236>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, -0.730582, -1.06989>, <-0.204716, -0.734846, -1.00016>, <-0.24089, -0.73999, -0.916058>, <-0.270597, -0.745239, -0.830236>,
      <-0.09637, -0.798767, -0.713762>, <-0.15464, -0.803032, -0.644035>, <-0.148289, -0.803212, -0.641669>, <-0.177997, -0.808461, -0.555847>,
      <-0.0713232, -0.844427, -0.35868>, <-0.0713232, -0.844427, -0.35868>, <-0.127139, -0.84842, -0.267512>, <-0.127139, -0.848419, -0.267512>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.146446, -0.730582, -1.06989>, <-0.09637, -0.798767, -0.713762>, <-0.0713232, -0.844427, -0.35868>, <-0, -0.86, -0>,
      <-0.204716, -0.734846, -1.00016>, <-0.15464, -0.803032, -0.644035>, <-0.220297, -0.838663, -0.493205>, <-0.148974, -0.854236, -0.134525>,
      <-0.24089, -0.73999, -0.916058>, <-0.281421, -0.747152, -0.798965>, <-0.216608, -0.815315, -0.443487>, <-0.233185, -0.822605, -0.3207>,
      <-0.270597, -0.745239, -0.830236>, <-0.311129, -0.752401, -0.713143>, <-0.336975, -0.759886, -0.594361>, <-0.353552, -0.767176, -0.471574>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.270597, -0.745239, -0.830236>, <-0.311129, -0.752401, -0.713143>, <-0.336975, -0.759886, -0.594361>, <-0.353552, -0.767176, -0.471574>,
      <-0.177997, -0.808461, -0.555847>, <-0.218528, -0.815623, -0.438754>, <-0.216608, -0.815315, -0.443487>, <-0.233185, -0.822605, -0.3207>,
      <-0.127139, -0.848419, -0.267512>, <-0.127139, -0.84842, -0.267512>, <-0.148974, -0.854236, -0.134525>, <-0.148974, -0.854236, -0.134525>,
      <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>, <-0, -0.86, -0>
   }
}

#declare StdOreilles = union {
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.772212, 0.539803, 0.269071>, <0.779573, 0.517895, 0.288343>, <0.786424, 0.500629, 0.315111>, <0.794296, 0.474079, 0.326887>,
      <0.866071, 0.65173, 0.283195>, <0.873433, 0.629822, 0.302467>, <0.86372, 0.594466, 0.357591>, <0.871592, 0.567916, 0.369367>,
      <0.936788, 0.787571, 0.301418>, <0.927586, 0.747573, 0.349046>, <0.930267, 0.730549, 0.40384>, <0.927234, 0.675637, 0.43431>,
      <1.05379, 0.875584, 0.311443>, <1.04459, 0.835586, 0.359071>, <1.02922, 0.810502, 0.423858>, <1.02618, 0.75559, 0.454328>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.772212, 0.539803, 0.269071>, <0.772212, 0.537048, 0.260867>, <0.772212, 0.534294, 0.252664>, <0.772212, 0.531539, 0.24446>,
      <0.866071, 0.65173, 0.283195>, <0.866071, 0.648975, 0.274991>, <0.857624, 0.633781, 0.265517>, <0.857624, 0.631026, 0.257313>,
      <0.936788, 0.787571, 0.301418>, <0.928341, 0.772377, 0.291944>, <0.93108, 0.76723, 0.283427>, <0.922633, 0.752036, 0.273952>,
      <1.05379, 0.875584, 0.311443>, <1.04534, 0.86039, 0.301968>, <1.0369, 0.845196, 0.292494>, <1.02845, 0.830002, 0.283019>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.772212, 0.539803, 0.269071>, <0.772212, 0.537048, 0.260867>, <0.772212, 0.534294, 0.252664>, <0.772212, 0.531539, 0.24446>,
      <0.779573, 0.517895, 0.288343>, <0.779573, 0.515141, 0.280139>, <0.778911, 0.514358, 0.270202>, <0.778911, 0.511603, 0.261998>,
      <0.786424, 0.500629, 0.315111>, <0.785762, 0.499846, 0.305173>, <0.785807, 0.496674, 0.296295>, <0.785144, 0.495891, 0.286358>,
      <0.794296, 0.474079, 0.326887>, <0.793633, 0.473296, 0.31695>, <0.792971, 0.472514, 0.307012>, <0.792308, 0.471731, 0.297075>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.05379, 0.875584, 0.311443>, <1.04459, 0.835586, 0.359071>, <1.02922, 0.810502, 0.423858>, <1.02618, 0.75559, 0.454328>,
      <1.11454, 0.921282, 0.316648>, <1.10534, 0.881284, 0.364276>, <1.10405, 0.870964, 0.438996>, <1.10101, 0.816052, 0.469466>,
      <1.20336, 0.923326, 0.327528>, <1.20777, 0.908437, 0.365863>, <1.19978, 0.926448, 0.445703>, <1.20086, 0.88824, 0.461504>,
      <1.27797, 0.920251, 0.312404>, <1.28238, 0.905362, 0.350739>, <1.29013, 0.913792, 0.411609>, <1.2912, 0.875584, 0.42741>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.05379, 0.875584, 0.311443>, <1.04534, 0.86039, 0.301968>, <1.0369, 0.845196, 0.292494>, <1.02845, 0.830002, 0.283019>,
      <1.11454, 0.921282, 0.316648>, <1.10609, 0.906088, 0.307173>, <1.09259, 0.886229, 0.297265>, <1.08414, 0.871035, 0.287791>,
      <1.20336, 0.923326, 0.327528>, <1.18818, 0.906791, 0.318024>, <1.17917, 0.889672, 0.304149>, <1.164, 0.873138, 0.294646>,
      <1.27797, 0.920251, 0.312404>, <1.2628, 0.903717, 0.302901>, <1.24763, 0.887182, 0.293397>, <1.23246, 0.870648, 0.283894>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.05379, 0.875584, 0.311443>, <1.04534, 0.86039, 0.301968>, <1.0369, 0.845196, 0.292494>, <1.02845, 0.830002, 0.283019>,
      <1.04459, 0.835586, 0.359071>, <1.03614, 0.820392, 0.349596>, <1.02852, 0.810685, 0.335835>, <1.02008, 0.795491, 0.32636>,
      <1.02922, 0.810502, 0.423858>, <1.0216, 0.800795, 0.410097>, <1.01363, 0.784671, 0.398867>, <1.00602, 0.774964, 0.385106>,
      <1.02618, 0.75559, 0.454328>, <1.01857, 0.745883, 0.440567>, <1.01095, 0.736175, 0.426805>, <1.00333, 0.726468, 0.413044>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.27797, 0.920251, 0.312404>, <1.28238, 0.905362, 0.350739>, <1.29013, 0.913792, 0.411609>, <1.2912, 0.875584, 0.42741>,
      <1.33507, 0.917898, 0.300832>, <1.33948, 0.90301, 0.339167>, <1.38166, 0.900969, 0.377065>, <1.38274, 0.862761, 0.392866>,
      <1.37513, 0.880312, 0.26178>, <1.3923, 0.824426, 0.277914>, <1.40849, 0.813826, 0.327076>, <1.41387, 0.753651, 0.332384>,
      <1.42371, 0.860342, 0.236468>, <1.44087, 0.804457, 0.252602>, <1.46982, 0.75286, 0.279563>, <1.4752, 0.692685, 0.284871>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.27797, 0.920251, 0.312404>, <1.2628, 0.903717, 0.302901>, <1.24763, 0.887182, 0.293397>, <1.23246, 0.870648, 0.283894>,
      <1.33507, 0.917898, 0.300832>, <1.3199, 0.901364, 0.291329>, <1.31186, 0.884846, 0.28331>, <1.29668, 0.868312, 0.273806>,
      <1.37513, 0.880312, 0.26178>, <1.37047, 0.865575, 0.257335>, <1.3553, 0.849041, 0.247832>, <1.35064, 0.834304, 0.243387>,
      <1.42371, 0.860342, 0.236468>, <1.41905, 0.845605, 0.232023>, <1.41439, 0.830869, 0.227579>, <1.40973, 0.816132, 0.223134>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.27797, 0.920251, 0.312404>, <1.2628, 0.903717, 0.302901>, <1.24763, 0.887182, 0.293397>, <1.23246, 0.870648, 0.283894>,
      <1.28238, 0.905362, 0.350739>, <1.26721, 0.888828, 0.341236>, <1.25164, 0.873634, 0.328282>, <1.23647, 0.857099, 0.318779>,
      <1.29013, 0.913792, 0.411609>, <1.27456, 0.898598, 0.398655>, <1.2591, 0.879808, 0.386747>, <1.24353, 0.864614, 0.373794>,
      <1.2912, 0.875584, 0.42741>, <1.27563, 0.86039, 0.414456>, <1.26006, 0.845196, 0.401503>, <1.24449, 0.830002, 0.388549>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.42371, 0.860342, 0.236468>, <1.41905, 0.845605, 0.232023>, <1.41439, 0.830869, 0.227579>, <1.40973, 0.816132, 0.223134>,
      <1.44087, 0.804457, 0.252602>, <1.43622, 0.78972, 0.248158>, <1.43246, 0.780013, 0.246854>, <1.4278, 0.765276, 0.24241>,
      <1.46982, 0.75286, 0.279563>, <1.46607, 0.743153, 0.278259>, <1.46264, 0.730132, 0.277203>, <1.45889, 0.720425, 0.2759>,
      <1.4752, 0.692685, 0.284871>, <1.47145, 0.682978, 0.283568>, <1.4677, 0.673271, 0.282264>, <1.46395, 0.663564, 0.280961>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.794296, 0.474079, 0.326887>, <0.800113, 0.454459, 0.335589>, <0.808512, 0.431202, 0.330895>, <0.810859, 0.409455, 0.326887>,
      <0.871592, 0.567916, 0.369367>, <0.877409, 0.548296, 0.37807>, <0.882128, 0.453319, 0.399691>, <0.884475, 0.431572, 0.395683>,
      <0.927234, 0.675637, 0.43431>, <0.922558, 0.590988, 0.481281>, <0.930125, 0.56408, 0.502086>, <0.935395, 0.467422, 0.49729>,
      <1.02618, 0.75559, 0.454328>, <1.02151, 0.670941, 0.501299>, <1.02644, 0.572463, 0.538071>, <1.03171, 0.475805, 0.533275>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.794296, 0.474079, 0.326887>, <0.793633, 0.473296, 0.31695>, <0.792971, 0.472514, 0.307012>, <0.792308, 0.471731, 0.297075>,
      <0.871592, 0.567916, 0.369367>, <0.870929, 0.567133, 0.35943>, <0.863311, 0.557426, 0.345668>, <0.862648, 0.556643, 0.335731>,
      <0.927234, 0.675637, 0.43431>, <0.919615, 0.665929, 0.420549>, <0.920497, 0.66451, 0.408508>, <0.912878, 0.654803, 0.394746>,
      <1.02618, 0.75559, 0.454328>, <1.01857, 0.745883, 0.440567>, <1.01095, 0.736175, 0.426805>, <1.00333, 0.726468, 0.413044>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.794296, 0.474079, 0.326887>, <0.793633, 0.473296, 0.31695>, <0.792971, 0.472514, 0.307012>, <0.792308, 0.471731, 0.297075>,
      <0.800113, 0.454459, 0.335589>, <0.79945, 0.453677, 0.325652>, <0.798265, 0.45466, 0.314932>, <0.797602, 0.453877, 0.304995>,
      <0.808512, 0.431202, 0.330895>, <0.807354, 0.432358, 0.320957>, <0.806406, 0.431557, 0.310659>, <0.805247, 0.432713, 0.300722>,
      <0.810859, 0.409455, 0.326887>, <0.8097, 0.410611, 0.31695>, <0.808542, 0.411767, 0.307012>, <0.807383, 0.412923, 0.297075>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.02618, 0.75559, 0.454328>, <1.02151, 0.670941, 0.501299>, <1.02644, 0.572463, 0.538071>, <1.03171, 0.475805, 0.533275>,
      <1.10101, 0.816052, 0.469466>, <1.09634, 0.731403, 0.516436>, <1.10799, 0.579561, 0.56854>, <1.11326, 0.482903, 0.563745>,
      <1.20086, 0.88824, 0.461504>, <1.20461, 0.755339, 0.516467>, <1.22199, 0.62195, 0.552212>, <1.21881, 0.478208, 0.54713>,
      <1.2912, 0.875584, 0.42741>, <1.29495, 0.742683, 0.482372>, <1.29439, 0.595005, 0.511439>, <1.2912, 0.451263, 0.506357>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.02618, 0.75559, 0.454328>, <1.01857, 0.745883, 0.440567>, <1.01095, 0.736175, 0.426805>, <1.00333, 0.726468, 0.413044>,
      <1.10101, 0.816052, 0.469466>, <1.09339, 0.806345, 0.455704>, <1.07896, 0.790066, 0.440565>, <1.07135, 0.780359, 0.426803>,
      <1.20086, 0.88824, 0.461504>, <1.18529, 0.873046, 0.448551>, <1.17632, 0.856632, 0.425515>, <1.16075, 0.841438, 0.412562>,
      <1.2912, 0.875584, 0.42741>, <1.27563, 0.86039, 0.414456>, <1.26006, 0.845196, 0.401503>, <1.24449, 0.830002, 0.388549>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.02618, 0.75559, 0.454328>, <1.01857, 0.745883, 0.440567>, <1.01095, 0.736175, 0.426805>, <1.00333, 0.726468, 0.413044>,
      <1.02151, 0.670941, 0.501299>, <1.01389, 0.661234, 0.487537>, <1.00662, 0.657989, 0.471848>, <0.998997, 0.648282, 0.458086>,
      <1.02644, 0.572463, 0.538071>, <1.01865, 0.569615, 0.524309>, <1.01133, 0.560211, 0.510127>, <1.00355, 0.557362, 0.496365>,
      <1.03171, 0.475805, 0.533275>, <1.02392, 0.472957, 0.519514>, <1.01614, 0.470108, 0.505752>, <1.00835, 0.46726, 0.491991>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.2912, 0.875584, 0.42741>, <1.29495, 0.742683, 0.482372>, <1.29439, 0.595005, 0.511439>, <1.2912, 0.451263, 0.506357>,
      <1.38274, 0.862761, 0.392866>, <1.38649, 0.729859, 0.447828>, <1.38241, 0.562243, 0.461864>, <1.37923, 0.418501, 0.456782>,
      <1.41387, 0.753651, 0.332384>, <1.42514, 0.627626, 0.343501>, <1.42321, 0.484725, 0.358311>, <1.41224, 0.358185, 0.358699>,
      <1.4752, 0.692685, 0.284871>, <1.48647, 0.56666, 0.295988>, <1.48373, 0.438186, 0.284482>, <1.47276, 0.311646, 0.284871>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.2912, 0.875584, 0.42741>, <1.27563, 0.86039, 0.414456>, <1.26006, 0.845196, 0.401503>, <1.24449, 0.830002, 0.388549>,
      <1.38274, 0.862761, 0.392866>, <1.36717, 0.847567, 0.379912>, <1.354, 0.832367, 0.374565>, <1.33843, 0.817173, 0.361611>,
      <1.41387, 0.753651, 0.332384>, <1.41012, 0.743944, 0.331081>, <1.39455, 0.72875, 0.318127>, <1.39079, 0.719043, 0.316824>,
      <1.4752, 0.692685, 0.284871>, <1.47145, 0.682978, 0.283568>, <1.4677, 0.673271, 0.282264>, <1.46395, 0.663564, 0.280961>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.2912, 0.875584, 0.42741>, <1.27563, 0.86039, 0.414456>, <1.26006, 0.845196, 0.401503>, <1.24449, 0.830002, 0.388549>,
      <1.29495, 0.742683, 0.482372>, <1.27938, 0.727489, 0.469419>, <1.26347, 0.723216, 0.453504>, <1.2479, 0.708022, 0.440551>,
      <1.29439, 0.595005, 0.511439>, <1.27882, 0.591242, 0.498485>, <1.26297, 0.576269, 0.485087>, <1.2474, 0.572507, 0.472133>,
      <1.2912, 0.451263, 0.506357>, <1.27563, 0.4475, 0.493403>, <1.26006, 0.443737, 0.48045>, <1.24449, 0.439974, 0.467496>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.4752, 0.692685, 0.284871>, <1.47145, 0.682978, 0.283568>, <1.4677, 0.673271, 0.282264>, <1.46395, 0.663564, 0.280961>,
      <1.48647, 0.56666, 0.295988>, <1.48272, 0.556953, 0.294685>, <1.47791, 0.558462, 0.292483>, <1.47416, 0.548755, 0.29118>,
      <1.48373, 0.438186, 0.284482>, <1.47753, 0.439909, 0.278717>, <1.4725, 0.430095, 0.277445>, <1.4663, 0.431818, 0.27168>,
      <1.47276, 0.311646, 0.284871>, <1.46656, 0.313369, 0.279106>, <1.46036, 0.315093, 0.273341>, <1.45416, 0.316816, 0.267576>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.810859, 0.409455, 0.326887>, <0.884475, 0.431572, 0.395683>, <0.935395, 0.467422, 0.49729>, <1.03171, 0.475805, 0.533275>,
      <0.814139, 0.379057, 0.321285>, <0.887755, 0.401173, 0.390081>, <0.941678, 0.352199, 0.491573>, <1.03799, 0.360582, 0.527558>,
      <0.810859, 0.350216, 0.30803>, <0.893677, 0.292675, 0.34989>, <0.960726, 0.316994, 0.441497>, <1.05011, 0.25725, 0.460546>,
      <0.810859, 0.320596, 0.298602>, <0.893677, 0.263055, 0.340462>, <0.969928, 0.207717, 0.405133>, <1.05931, 0.147973, 0.424181>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.810859, 0.409455, 0.326887>, <0.8097, 0.410611, 0.31695>, <0.808542, 0.411767, 0.307012>, <0.807383, 0.412923, 0.297075>,
      <0.814139, 0.379057, 0.321285>, <0.812981, 0.380213, 0.311348>, <0.811527, 0.384105, 0.301914>, <0.810369, 0.385261, 0.291977>,
      <0.810859, 0.350216, 0.30803>, <0.8097, 0.354038, 0.298941>, <0.808542, 0.355194, 0.289004>, <0.807383, 0.359016, 0.279915>,
      <0.810859, 0.320596, 0.298602>, <0.8097, 0.324418, 0.289513>, <0.808542, 0.32824, 0.280424>, <0.807383, 0.332062, 0.271335>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.810859, 0.409455, 0.326887>, <0.8097, 0.410611, 0.31695>, <0.808542, 0.411767, 0.307012>, <0.807383, 0.412923, 0.297075>,
      <0.884475, 0.431572, 0.395683>, <0.883316, 0.432728, 0.385745>, <0.875531, 0.429879, 0.371984>, <0.874372, 0.431035, 0.362047>,
      <0.935395, 0.467422, 0.49729>, <0.92761, 0.464574, 0.483529>, <0.927715, 0.464636, 0.471278>, <0.919929, 0.461788, 0.457517>,
      <1.03171, 0.475805, 0.533275>, <1.02392, 0.472957, 0.519514>, <1.01614, 0.470108, 0.505752>, <1.00835, 0.46726, 0.491991>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.810859, 0.320596, 0.298602>, <0.8097, 0.324418, 0.289513>, <0.808542, 0.32824, 0.280424>, <0.807383, 0.332062, 0.271335>,
      <0.893677, 0.263055, 0.340462>, <0.892518, 0.266877, 0.331373>, <0.883905, 0.271345, 0.318515>, <0.882747, 0.275167, 0.309427>,
      <0.969928, 0.207717, 0.405133>, <0.961315, 0.212184, 0.392276>, <0.960091, 0.214691, 0.380993>, <0.951478, 0.219159, 0.368136>,
      <1.05931, 0.147973, 0.424181>, <1.0507, 0.152441, 0.411324>, <1.04209, 0.156908, 0.398467>, <1.03347, 0.161376, 0.38561>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.03171, 0.475805, 0.533275>, <1.11326, 0.482903, 0.563745>, <1.21881, 0.478208, 0.54713>, <1.2912, 0.451263, 0.506357>,
      <1.03799, 0.360582, 0.527558>, <1.11954, 0.36768, 0.558028>, <1.21547, 0.32741, 0.541799>, <1.28786, 0.300465, 0.501026>,
      <1.05011, 0.25725, 0.460546>, <1.11937, 0.210959, 0.475305>, <1.20632, 0.192882, 0.461314>, <1.27846, 0.158635, 0.433379>,
      <1.05931, 0.147973, 0.424181>, <1.12857, 0.101682, 0.43894>, <1.19994, 0.0465689, 0.424826>, <1.27208, 0.012322, 0.39689>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.03171, 0.475805, 0.533275>, <1.02392, 0.472957, 0.519514>, <1.01614, 0.470108, 0.505752>, <1.00835, 0.46726, 0.491991>,
      <1.03799, 0.360582, 0.527558>, <1.03021, 0.357734, 0.513797>, <1.0219, 0.362113, 0.500509>, <1.01411, 0.359265, 0.486748>,
      <1.05011, 0.25725, 0.460546>, <1.0415, 0.261718, 0.447689>, <1.03371, 0.258869, 0.433927>, <1.0251, 0.263337, 0.42107>,
      <1.05931, 0.147973, 0.424181>, <1.0507, 0.152441, 0.411324>, <1.04209, 0.156908, 0.398467>, <1.03347, 0.161376, 0.38561>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.03171, 0.475805, 0.533275>, <1.02392, 0.472957, 0.519514>, <1.01614, 0.470108, 0.505752>, <1.00835, 0.46726, 0.491991>,
      <1.11326, 0.482903, 0.563745>, <1.10547, 0.480055, 0.549983>, <1.09023, 0.474694, 0.53464>, <1.08244, 0.471845, 0.520878>,
      <1.21881, 0.478208, 0.54713>, <1.20324, 0.474445, 0.534176>, <1.19194, 0.466726, 0.514742>, <1.17637, 0.462963, 0.501789>,
      <1.2912, 0.451263, 0.506357>, <1.27563, 0.4475, 0.493403>, <1.26006, 0.443737, 0.48045>, <1.24449, 0.439974, 0.467496>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.05931, 0.147973, 0.424181>, <1.0507, 0.152441, 0.411324>, <1.04209, 0.156908, 0.398467>, <1.03347, 0.161376, 0.38561>,
      <1.12857, 0.101682, 0.43894>, <1.11996, 0.10615, 0.426083>, <1.10432, 0.113052, 0.411729>, <1.09571, 0.11752, 0.398872>,
      <1.19994, 0.0465689, 0.424826>, <1.18495, 0.0545589, 0.412788>, <1.17401, 0.0558529, 0.396852>, <1.15901, 0.0638429, 0.384814>,
      <1.27208, 0.012322, 0.39689>, <1.25709, 0.020312, 0.384852>, <1.24209, 0.028302, 0.372814>, <1.2271, 0.036292, 0.360776>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.2912, 0.451263, 0.506357>, <1.37923, 0.418501, 0.456782>, <1.41224, 0.358185, 0.358699>, <1.47276, 0.311646, 0.284871>,
      <1.28786, 0.300465, 0.501026>, <1.37589, 0.267703, 0.451451>, <1.40254, 0.246257, 0.359043>, <1.46306, 0.199718, 0.285215>,
      <1.27846, 0.158635, 0.433379>, <1.33016, 0.134091, 0.413358>, <1.38608, 0.10128, 0.322941>, <1.43319, 0.0904642, 0.286331>,
      <1.27208, 0.012322, 0.39689>, <1.32378, -0.0122225, 0.376869>, <1.3663, -0.00931004, 0.323671>, <1.41341, -0.020126, 0.287061>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.2912, 0.451263, 0.506357>, <1.27563, 0.4475, 0.493403>, <1.26006, 0.443737, 0.48045>, <1.24449, 0.439974, 0.467496>,
      <1.28786, 0.300465, 0.501026>, <1.27229, 0.296702, 0.488072>, <1.25701, 0.304552, 0.475579>, <1.24144, 0.300789, 0.462626>,
      <1.27846, 0.158635, 0.433379>, <1.26346, 0.166625, 0.421341>, <1.24789, 0.162862, 0.408387>, <1.23289, 0.170852, 0.396349>,
      <1.27208, 0.012322, 0.39689>, <1.25709, 0.020312, 0.384852>, <1.24209, 0.028302, 0.372814>, <1.2271, 0.036292, 0.360776>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.2912, 0.451263, 0.506357>, <1.27563, 0.4475, 0.493403>, <1.26006, 0.443737, 0.48045>, <1.24449, 0.439974, 0.467496>,
      <1.37923, 0.418501, 0.456782>, <1.36366, 0.414738, 0.443828>, <1.3498, 0.413454, 0.435277>, <1.33423, 0.409691, 0.422323>,
      <1.41224, 0.358185, 0.358699>, <1.40604, 0.359908, 0.352934>, <1.39047, 0.356145, 0.339981>, <1.38427, 0.357868, 0.334216>,
      <1.47276, 0.311646, 0.284871>, <1.46656, 0.313369, 0.279106>, <1.46036, 0.315093, 0.273341>, <1.45416, 0.316816, 0.267576>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.27208, 0.012322, 0.39689>, <1.25709, 0.020312, 0.384852>, <1.24209, 0.028302, 0.372814>, <1.2271, 0.036292, 0.360776>,
      <1.32378, -0.0122225, 0.376869>, <1.30879, -0.00423255, 0.364831>, <1.30038, 0.00471497, 0.352234>, <1.28538, 0.0127049, 0.340196>,
      <1.3663, -0.00931004, 0.323671>, <1.36031, 0.00236691, 0.313922>, <1.34531, 0.010357, 0.301884>, <1.33932, 0.022034, 0.292135>,
      <1.41341, -0.020126, 0.287061>, <1.40742, -0.00844905, 0.277312>, <1.40143, 0.00322805, 0.267564>, <1.39544, 0.014905, 0.257815>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.47276, 0.311646, 0.284871>, <1.46656, 0.313369, 0.279106>, <1.46036, 0.315093, 0.273341>, <1.45416, 0.316816, 0.267576>,
      <1.46306, 0.199718, 0.285215>, <1.45686, 0.201441, 0.27945>, <1.44959, 0.21315, 0.269703>, <1.44339, 0.214874, 0.263938>,
      <1.43319, 0.0904642, 0.286331>, <1.4272, 0.102141, 0.276582>, <1.421, 0.103865, 0.270817>, <1.41501, 0.115542, 0.261069>,
      <1.41341, -0.020126, 0.287061>, <1.40742, -0.00844905, 0.277312>, <1.40143, 0.00322805, 0.267564>, <1.39544, 0.014905, 0.257815>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.772212, 0.531539, 0.24446>, <0.778911, 0.511603, 0.261998>, <0.785144, 0.495891, 0.286358>, <0.792308, 0.471731, 0.297075>,
      <0.857624, 0.631026, 0.257313>, <0.864323, 0.61109, 0.274851>, <0.855484, 0.580803, 0.325014>, <0.862648, 0.556643, 0.335731>,
      <0.922633, 0.752036, 0.273952>, <0.914259, 0.717524, 0.317294>, <0.915565, 0.703299, 0.366808>, <0.912878, 0.654803, 0.394746>,
      <1.02845, 0.830002, 0.283019>, <1.02008, 0.795491, 0.32636>, <1.00602, 0.774964, 0.385106>, <1.00333, 0.726468, 0.413044>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.02845, 0.830002, 0.283019>, <1.02008, 0.795491, 0.32636>, <1.00602, 0.774964, 0.385106>, <1.00333, 0.726468, 0.413044>,
      <1.08414, 0.871035, 0.287791>, <1.07577, 0.836524, 0.331132>, <1.07403, 0.828855, 0.398865>, <1.07135, 0.780359, 0.426803>,
      <1.164, 0.873138, 0.294646>, <1.16801, 0.85959, 0.32953>, <1.15979, 0.87605, 0.397807>, <1.16075, 0.841438, 0.412562>,
      <1.23246, 0.870648, 0.283894>, <1.23647, 0.857099, 0.318779>, <1.24353, 0.864614, 0.373794>, <1.24449, 0.830002, 0.388549>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.23246, 0.870648, 0.283894>, <1.23647, 0.857099, 0.318779>, <1.24353, 0.864614, 0.373794>, <1.24449, 0.830002, 0.388549>,
      <1.29668, 0.868312, 0.273806>, <1.3007, 0.854763, 0.308691>, <1.33747, 0.851785, 0.346856>, <1.33843, 0.817173, 0.361611>,
      <1.35064, 0.834304, 0.243387>, <1.36871, 0.783448, 0.262663>, <1.38574, 0.775904, 0.311763>, <1.39079, 0.719043, 0.316824>,
      <1.40973, 0.816132, 0.223134>, <1.4278, 0.765276, 0.24241>, <1.45889, 0.720425, 0.2759>, <1.46395, 0.663564, 0.280961>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.792308, 0.471731, 0.297075>, <0.797602, 0.453877, 0.304995>, <0.805247, 0.432713, 0.300722>, <0.807383, 0.412923, 0.297075>,
      <0.862648, 0.556643, 0.335731>, <0.867942, 0.538789, 0.343651>, <0.872236, 0.450825, 0.365694>, <0.874372, 0.431035, 0.362047>,
      <0.912878, 0.654803, 0.394746>, <0.908546, 0.576617, 0.439789>, <0.915123, 0.55189, 0.461891>, <0.919929, 0.461788, 0.457517>,
      <1.00333, 0.726468, 0.413044>, <0.998997, 0.648282, 0.458086>, <1.00355, 0.557362, 0.496365>, <1.00835, 0.46726, 0.491991>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.00333, 0.726468, 0.413044>, <0.998997, 0.648282, 0.458086>, <1.00355, 0.557362, 0.496365>, <1.00835, 0.46726, 0.491991>,
      <1.07135, 0.780359, 0.426803>, <1.06701, 0.702172, 0.471846>, <1.07764, 0.561948, 0.525252>, <1.08244, 0.471845, 0.520878>,
      <1.16075, 0.841438, 0.412562>, <1.16416, 0.719458, 0.464563>, <1.17928, 0.595496, 0.506426>, <1.17637, 0.462963, 0.501789>,
      <1.24449, 0.830002, 0.388549>, <1.2479, 0.708022, 0.440551>, <1.2474, 0.572507, 0.472133>, <1.24449, 0.439974, 0.467496>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.24449, 0.830002, 0.388549>, <1.2479, 0.708022, 0.440551>, <1.2474, 0.572507, 0.472133>, <1.24449, 0.439974, 0.467496>,
      <1.33843, 0.817173, 0.361611>, <1.34184, 0.695193, 0.413613>, <1.33714, 0.542223, 0.42696>, <1.33423, 0.409691, 0.422323>,
      <1.39079, 0.719043, 0.316824>, <1.40101, 0.604234, 0.327042>, <1.39641, 0.47287, 0.338319>, <1.38427, 0.357868, 0.334216>,
      <1.46395, 0.663564, 0.280961>, <1.47416, 0.548755, 0.29118>, <1.4663, 0.431818, 0.27168>, <1.45416, 0.316816, 0.267576>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <0.807383, 0.412923, 0.297075>, <0.874372, 0.431035, 0.362047>, <0.919929, 0.461788, 0.457517>, <1.00835, 0.46726, 0.491991>,
      <0.810369, 0.385261, 0.291977>, <0.877358, 0.403373, 0.356949>, <0.925691, 0.353793, 0.452274>, <1.01411, 0.359265, 0.486748>,
      <0.807383, 0.359016, 0.279915>, <0.882747, 0.30212, 0.318007>, <0.943104, 0.32112, 0.403597>, <1.0251, 0.263337, 0.42107>,
      <0.807383, 0.332062, 0.271335>, <0.882747, 0.275167, 0.309427>, <0.951478, 0.219159, 0.368136>, <1.03347, 0.161376, 0.38561>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.00835, 0.46726, 0.491991>, <1.08244, 0.471845, 0.520878>, <1.17637, 0.462963, 0.501789>, <1.24449, 0.439974, 0.467496>,
      <1.01411, 0.359265, 0.486748>, <1.08821, 0.36385, 0.515635>, <1.17332, 0.323778, 0.496918>, <1.24144, 0.300789, 0.462626>,
      <1.0251, 0.263337, 0.42107>, <1.08733, 0.219481, 0.434332>, <1.16481, 0.198403, 0.420387>, <1.23289, 0.170852, 0.396349>,
      <1.03347, 0.161376, 0.38561>, <1.09571, 0.11752, 0.398872>, <1.15901, 0.0638429, 0.384814>, <1.2271, 0.036292, 0.360776>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <1.24449, 0.439974, 0.467496>, <1.33423, 0.409691, 0.422323>, <1.38427, 0.357868, 0.334216>, <1.45416, 0.316816, 0.267576>,
      <1.24144, 0.300789, 0.462626>, <1.33118, 0.270506, 0.417453>, <1.3735, 0.255926, 0.330578>, <1.44339, 0.214874, 0.263938>,
      <1.23289, 0.170852, 0.396349>, <1.29118, 0.147265, 0.37577>, <1.3589, 0.122671, 0.295389>, <1.41501, 0.115542, 0.261069>,
      <1.2271, 0.036292, 0.360776>, <1.28538, 0.0127049, 0.340196>, <1.33932, 0.022034, 0.292135>, <1.39544, 0.014905, 0.257815>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.765392, 0.539803, 0.269071>, <-0.772753, 0.517895, 0.288343>, <-0.779604, 0.500629, 0.315111>, <-0.787476, 0.474079, 0.326887>,
      <-0.859252, 0.65173, 0.283195>, <-0.866613, 0.629822, 0.302467>, <-0.8569, 0.594466, 0.357591>, <-0.864772, 0.567916, 0.369367>,
      <-0.929969, 0.78757, 0.301418>, <-0.920767, 0.747573, 0.349046>, <-0.923449, 0.730548, 0.40384>, <-0.920415, 0.675636, 0.43431>,
      <-1.04697, 0.875584, 0.311443>, <-1.03777, 0.835586, 0.359071>, <-1.0224, 0.810502, 0.423858>, <-1.01937, 0.75559, 0.454328>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.765392, 0.539803, 0.269071>, <-0.765392, 0.537048, 0.260867>, <-0.765392, 0.534294, 0.252664>, <-0.765392, 0.531539, 0.24446>,
      <-0.859252, 0.65173, 0.283195>, <-0.859252, 0.648975, 0.274991>, <-0.850804, 0.633781, 0.265517>, <-0.850804, 0.631026, 0.257313>,
      <-0.929969, 0.78757, 0.301418>, <-0.921521, 0.772377, 0.291944>, <-0.92426, 0.76723, 0.283427>, <-0.915812, 0.752036, 0.273953>,
      <-1.04697, 0.875584, 0.311443>, <-1.03852, 0.86039, 0.301968>, <-1.03008, 0.845196, 0.292494>, <-1.02163, 0.830002, 0.283019>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.765392, 0.539803, 0.269071>, <-0.765392, 0.537048, 0.260867>, <-0.765392, 0.534294, 0.252664>, <-0.765392, 0.531539, 0.24446>,
      <-0.772753, 0.517895, 0.288343>, <-0.772753, 0.515141, 0.280139>, <-0.772091, 0.514358, 0.270202>, <-0.772091, 0.511603, 0.261998>,
      <-0.779604, 0.500629, 0.315111>, <-0.778942, 0.499846, 0.305173>, <-0.778988, 0.496674, 0.296295>, <-0.778326, 0.495892, 0.286358>,
      <-0.787476, 0.474079, 0.326887>, <-0.786814, 0.473296, 0.31695>, <-0.786151, 0.472514, 0.307012>, <-0.785489, 0.471731, 0.297075>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.04697, 0.875584, 0.311443>, <-1.03777, 0.835586, 0.359071>, <-1.0224, 0.810502, 0.423858>, <-1.01937, 0.75559, 0.454328>,
      <-1.10772, 0.921281, 0.316648>, <-1.09852, 0.881284, 0.364276>, <-1.09723, 0.870964, 0.438996>, <-1.09419, 0.816052, 0.469465>,
      <-1.19654, 0.923326, 0.327527>, <-1.20094, 0.908437, 0.365863>, <-1.19296, 0.926448, 0.445703>, <-1.19404, 0.88824, 0.461504>,
      <-1.27115, 0.920251, 0.312404>, <-1.27556, 0.905362, 0.350739>, <-1.2833, 0.913792, 0.411609>, <-1.28438, 0.875584, 0.42741>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.04697, 0.875584, 0.311443>, <-1.03852, 0.86039, 0.301968>, <-1.03008, 0.845196, 0.292494>, <-1.02163, 0.830002, 0.283019>,
      <-1.10772, 0.921281, 0.316648>, <-1.09927, 0.906088, 0.307173>, <-1.08577, 0.886229, 0.297265>, <-1.07732, 0.871035, 0.287791>,
      <-1.19654, 0.923326, 0.327527>, <-1.18136, 0.906791, 0.318024>, <-1.17235, 0.889672, 0.304149>, <-1.15718, 0.873138, 0.294646>,
      <-1.27115, 0.920251, 0.312404>, <-1.25598, 0.903717, 0.302901>, <-1.24081, 0.887182, 0.293397>, <-1.22563, 0.870648, 0.283894>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.04697, 0.875584, 0.311443>, <-1.03852, 0.86039, 0.301968>, <-1.03008, 0.845196, 0.292494>, <-1.02163, 0.830002, 0.283019>,
      <-1.03777, 0.835586, 0.359071>, <-1.02932, 0.820392, 0.349596>, <-1.0217, 0.810685, 0.335835>, <-1.01325, 0.795491, 0.32636>,
      <-1.0224, 0.810502, 0.423858>, <-1.01478, 0.800795, 0.410097>, <-1.00681, 0.784671, 0.398867>, <-0.999195, 0.774964, 0.385106>,
      <-1.01937, 0.75559, 0.454328>, <-1.01175, 0.745883, 0.440567>, <-1.00413, 0.736175, 0.426805>, <-0.996508, 0.726468, 0.413044>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.27115, 0.920251, 0.312404>, <-1.27556, 0.905362, 0.350739>, <-1.2833, 0.913792, 0.411609>, <-1.28438, 0.875584, 0.42741>,
      <-1.32825, 0.917898, 0.300832>, <-1.33266, 0.90301, 0.339167>, <-1.37484, 0.900969, 0.377064>, <-1.37591, 0.862761, 0.392866>,
      <-1.36831, 0.880312, 0.26178>, <-1.38547, 0.824426, 0.277914>, <-1.40167, 0.813826, 0.327076>, <-1.40705, 0.753651, 0.332384>,
      <-1.41689, 0.860342, 0.236468>, <-1.43405, 0.804457, 0.252602>, <-1.463, 0.75286, 0.279563>, <-1.46838, 0.692685, 0.284871>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.27115, 0.920251, 0.312404>, <-1.25598, 0.903717, 0.302901>, <-1.24081, 0.887182, 0.293397>, <-1.22563, 0.870648, 0.283894>,
      <-1.32825, 0.917898, 0.300832>, <-1.31308, 0.901364, 0.291328>, <-1.30503, 0.884846, 0.28331>, <-1.28986, 0.868312, 0.273806>,
      <-1.36831, 0.880312, 0.26178>, <-1.36365, 0.865575, 0.257335>, <-1.34848, 0.849041, 0.247832>, <-1.34382, 0.834304, 0.243387>,
      <-1.41689, 0.860342, 0.236468>, <-1.41223, 0.845605, 0.232023>, <-1.40757, 0.830869, 0.227579>, <-1.40291, 0.816132, 0.223134>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.27115, 0.920251, 0.312404>, <-1.25598, 0.903717, 0.302901>, <-1.24081, 0.887182, 0.293397>, <-1.22563, 0.870648, 0.283894>,
      <-1.27556, 0.905362, 0.350739>, <-1.26039, 0.888828, 0.341236>, <-1.24482, 0.873634, 0.328282>, <-1.22965, 0.857099, 0.318779>,
      <-1.2833, 0.913792, 0.411609>, <-1.26773, 0.898598, 0.398655>, <-1.25227, 0.879808, 0.386747>, <-1.23671, 0.864614, 0.373794>,
      <-1.28438, 0.875584, 0.42741>, <-1.26881, 0.86039, 0.414456>, <-1.25324, 0.845196, 0.401503>, <-1.23767, 0.830002, 0.388549>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.41689, 0.860342, 0.236468>, <-1.41223, 0.845605, 0.232023>, <-1.40757, 0.830869, 0.227579>, <-1.40291, 0.816132, 0.223134>,
      <-1.43405, 0.804457, 0.252602>, <-1.4294, 0.78972, 0.248158>, <-1.42564, 0.780013, 0.246854>, <-1.42098, 0.765276, 0.24241>,
      <-1.463, 0.75286, 0.279563>, <-1.45925, 0.743153, 0.278259>, <-1.45582, 0.730132, 0.277203>, <-1.45206, 0.720425, 0.2759>,
      <-1.46838, 0.692685, 0.284871>, <-1.46463, 0.682978, 0.283568>, <-1.46088, 0.673271, 0.282264>, <-1.45712, 0.663564, 0.280961>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.787476, 0.474079, 0.326887>, <-0.793293, 0.454459, 0.335589>, <-0.801693, 0.431202, 0.330895>, <-0.80404, 0.409455, 0.326887>,
      <-0.864772, 0.567916, 0.369367>, <-0.87059, 0.548296, 0.37807>, <-0.875308, 0.453319, 0.399691>, <-0.877655, 0.431572, 0.395683>,
      <-0.920415, 0.675636, 0.43431>, <-0.915738, 0.590987, 0.481281>, <-0.923304, 0.56408, 0.502086>, <-0.928574, 0.467422, 0.49729>,
      <-1.01937, 0.75559, 0.454328>, <-1.01469, 0.670941, 0.501299>, <-1.01962, 0.572463, 0.538071>, <-1.02489, 0.475805, 0.533275>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.787476, 0.474079, 0.326887>, <-0.786814, 0.473296, 0.31695>, <-0.786151, 0.472514, 0.307012>, <-0.785489, 0.471731, 0.297075>,
      <-0.864772, 0.567916, 0.369367>, <-0.86411, 0.567133, 0.35943>, <-0.856491, 0.557426, 0.345668>, <-0.855828, 0.556643, 0.335731>,
      <-0.920415, 0.675636, 0.43431>, <-0.912796, 0.665929, 0.420549>, <-0.913677, 0.66451, 0.408508>, <-0.906057, 0.654803, 0.394746>,
      <-1.01937, 0.75559, 0.454328>, <-1.01175, 0.745883, 0.440567>, <-1.00413, 0.736175, 0.426805>, <-0.996508, 0.726468, 0.413044>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.787476, 0.474079, 0.326887>, <-0.786814, 0.473296, 0.31695>, <-0.786151, 0.472514, 0.307012>, <-0.785489, 0.471731, 0.297075>,
      <-0.793293, 0.454459, 0.335589>, <-0.792631, 0.453676, 0.325652>, <-0.791445, 0.45466, 0.314932>, <-0.790783, 0.453877, 0.304995>,
      <-0.801693, 0.431202, 0.330895>, <-0.800533, 0.432358, 0.320957>, <-0.799585, 0.431557, 0.310659>, <-0.798425, 0.432713, 0.300722>,
      <-0.80404, 0.409455, 0.326887>, <-0.80288, 0.410611, 0.31695>, <-0.801721, 0.411767, 0.307012>, <-0.800561, 0.412923, 0.297075>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.01937, 0.75559, 0.454328>, <-1.01469, 0.670941, 0.501299>, <-1.01962, 0.572463, 0.538071>, <-1.02489, 0.475805, 0.533275>,
      <-1.09419, 0.816052, 0.469465>, <-1.08952, 0.731403, 0.516436>, <-1.10117, 0.579561, 0.568541>, <-1.10644, 0.482903, 0.563745>,
      <-1.19404, 0.88824, 0.461504>, <-1.19779, 0.755339, 0.516466>, <-1.21517, 0.62195, 0.552211>, <-1.21199, 0.478208, 0.54713>,
      <-1.28438, 0.875584, 0.42741>, <-1.28813, 0.742683, 0.482372>, <-1.28756, 0.595005, 0.511439>, <-1.28438, 0.451263, 0.506357>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.01937, 0.75559, 0.454328>, <-1.01175, 0.745883, 0.440567>, <-1.00413, 0.736175, 0.426805>, <-0.996508, 0.726468, 0.413044>,
      <-1.09419, 0.816052, 0.469465>, <-1.08657, 0.806344, 0.455704>, <-1.07214, 0.790066, 0.440565>, <-1.06453, 0.780359, 0.426804>,
      <-1.19404, 0.88824, 0.461504>, <-1.17847, 0.873046, 0.44855>, <-1.1695, 0.856632, 0.425516>, <-1.15393, 0.841438, 0.412562>,
      <-1.28438, 0.875584, 0.42741>, <-1.26881, 0.86039, 0.414456>, <-1.25324, 0.845196, 0.401503>, <-1.23767, 0.830002, 0.388549>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.01937, 0.75559, 0.454328>, <-1.01175, 0.745883, 0.440567>, <-1.00413, 0.736175, 0.426805>, <-0.996508, 0.726468, 0.413044>,
      <-1.01469, 0.670941, 0.501299>, <-1.00707, 0.661234, 0.487537>, <-0.999796, 0.657989, 0.471848>, <-0.992176, 0.648282, 0.458086>,
      <-1.01962, 0.572463, 0.538071>, <-1.01183, 0.569615, 0.524309>, <-1.00451, 0.560211, 0.510127>, <-0.996724, 0.557362, 0.496365>,
      <-1.02489, 0.475805, 0.533275>, <-1.0171, 0.472957, 0.519514>, <-1.00932, 0.470108, 0.505752>, <-1.00153, 0.46726, 0.491991>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.28438, 0.875584, 0.42741>, <-1.28813, 0.742683, 0.482372>, <-1.28756, 0.595005, 0.511439>, <-1.28438, 0.451263, 0.506357>,
      <-1.37591, 0.862761, 0.392866>, <-1.37966, 0.729859, 0.447828>, <-1.37559, 0.562243, 0.461864>, <-1.3724, 0.418501, 0.456782>,
      <-1.40705, 0.753651, 0.332384>, <-1.41831, 0.627626, 0.343501>, <-1.41639, 0.484725, 0.358311>, <-1.40542, 0.358185, 0.358699>,
      <-1.46838, 0.692685, 0.284871>, <-1.47965, 0.56666, 0.295988>, <-1.47691, 0.438186, 0.284482>, <-1.46594, 0.311646, 0.284871>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.28438, 0.875584, 0.42741>, <-1.26881, 0.86039, 0.414456>, <-1.25324, 0.845196, 0.401503>, <-1.23767, 0.830002, 0.388549>,
      <-1.37591, 0.862761, 0.392866>, <-1.36035, 0.847567, 0.379912>, <-1.34718, 0.832367, 0.374565>, <-1.33161, 0.817173, 0.361611>,
      <-1.40705, 0.753651, 0.332384>, <-1.4033, 0.743944, 0.331081>, <-1.38773, 0.72875, 0.318127>, <-1.38397, 0.719043, 0.316824>,
      <-1.46838, 0.692685, 0.284871>, <-1.46463, 0.682978, 0.283568>, <-1.46088, 0.673271, 0.282264>, <-1.45712, 0.663564, 0.280961>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.28438, 0.875584, 0.42741>, <-1.26881, 0.86039, 0.414456>, <-1.25324, 0.845196, 0.401503>, <-1.23767, 0.830002, 0.388549>,
      <-1.28813, 0.742683, 0.482372>, <-1.27256, 0.727489, 0.469419>, <-1.25665, 0.723216, 0.453504>, <-1.24108, 0.708022, 0.440551>,
      <-1.28756, 0.595005, 0.511439>, <-1.272, 0.591242, 0.498485>, <-1.25615, 0.576269, 0.485087>, <-1.24058, 0.572507, 0.472133>,
      <-1.28438, 0.451263, 0.506357>, <-1.26881, 0.4475, 0.493403>, <-1.25324, 0.443737, 0.48045>, <-1.23767, 0.439974, 0.467496>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.46838, 0.692685, 0.284871>, <-1.46463, 0.682978, 0.283568>, <-1.46088, 0.673271, 0.282264>, <-1.45712, 0.663564, 0.280961>,
      <-1.47965, 0.56666, 0.295988>, <-1.4759, 0.556953, 0.294685>, <-1.47109, 0.558462, 0.292483>, <-1.46734, 0.548755, 0.29118>,
      <-1.47691, 0.438186, 0.284482>, <-1.47071, 0.439909, 0.278717>, <-1.46568, 0.430095, 0.277445>, <-1.45948, 0.431818, 0.27168>,
      <-1.46594, 0.311646, 0.284871>, <-1.45974, 0.313369, 0.279106>, <-1.45354, 0.315093, 0.273341>, <-1.44734, 0.316816, 0.267576>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.80404, 0.409455, 0.326887>, <-0.877655, 0.431572, 0.395683>, <-0.928574, 0.467422, 0.49729>, <-1.02489, 0.475805, 0.533275>,
      <-0.807321, 0.379057, 0.321285>, <-0.880936, 0.401173, 0.390081>, <-0.934856, 0.352199, 0.491573>, <-1.03117, 0.360582, 0.527558>,
      <-0.80404, 0.350216, 0.30803>, <-0.886857, 0.292675, 0.34989>, <-0.953905, 0.316994, 0.441497>, <-1.04329, 0.25725, 0.460546>,
      <-0.80404, 0.320596, 0.298602>, <-0.886857, 0.263055, 0.340462>, <-0.963107, 0.207717, 0.405133>, <-1.05249, 0.147973, 0.424181>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.80404, 0.409455, 0.326887>, <-0.80288, 0.410611, 0.31695>, <-0.801721, 0.411767, 0.307012>, <-0.800561, 0.412923, 0.297075>,
      <-0.807321, 0.379057, 0.321285>, <-0.806161, 0.380213, 0.311348>, <-0.804706, 0.384105, 0.301914>, <-0.803546, 0.385261, 0.291977>,
      <-0.80404, 0.350216, 0.30803>, <-0.80288, 0.354038, 0.298941>, <-0.801721, 0.355194, 0.289004>, <-0.800561, 0.359016, 0.279915>,
      <-0.80404, 0.320596, 0.298602>, <-0.80288, 0.324418, 0.289513>, <-0.801721, 0.32824, 0.280424>, <-0.800561, 0.332062, 0.271335>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.80404, 0.409455, 0.326887>, <-0.80288, 0.410611, 0.31695>, <-0.801721, 0.411767, 0.307012>, <-0.800561, 0.412923, 0.297075>,
      <-0.877655, 0.431572, 0.395683>, <-0.876495, 0.432728, 0.385745>, <-0.86871, 0.429879, 0.371984>, <-0.867551, 0.431035, 0.362047>,
      <-0.928574, 0.467422, 0.49729>, <-0.920789, 0.464574, 0.483529>, <-0.920893, 0.464636, 0.471278>, <-0.913108, 0.461788, 0.457517>,
      <-1.02489, 0.475805, 0.533275>, <-1.0171, 0.472957, 0.519514>, <-1.00932, 0.470108, 0.505752>, <-1.00153, 0.46726, 0.491991>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.80404, 0.320596, 0.298602>, <-0.80288, 0.324418, 0.289513>, <-0.801721, 0.32824, 0.280424>, <-0.800561, 0.332062, 0.271335>,
      <-0.886857, 0.263055, 0.340462>, <-0.885697, 0.266877, 0.331373>, <-0.877085, 0.271345, 0.318515>, <-0.875925, 0.275167, 0.309427>,
      <-0.963107, 0.207717, 0.405133>, <-0.954494, 0.212184, 0.392276>, <-0.953269, 0.214691, 0.380993>, <-0.944657, 0.219159, 0.368136>,
      <-1.05249, 0.147973, 0.424181>, <-1.04388, 0.152441, 0.411324>, <-1.03527, 0.156908, 0.398467>, <-1.02665, 0.161376, 0.38561>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.02489, 0.475805, 0.533275>, <-1.10644, 0.482903, 0.563745>, <-1.21199, 0.478208, 0.54713>, <-1.28438, 0.451263, 0.506357>,
      <-1.03117, 0.360582, 0.527558>, <-1.11272, 0.36768, 0.558028>, <-1.20865, 0.32741, 0.541798>, <-1.28104, 0.300465, 0.501026>,
      <-1.04329, 0.25725, 0.460546>, <-1.11255, 0.210959, 0.475305>, <-1.1995, 0.192882, 0.461315>, <-1.27163, 0.158635, 0.433379>,
      <-1.05249, 0.147973, 0.424181>, <-1.12175, 0.101682, 0.43894>, <-1.19312, 0.0465691, 0.424826>, <-1.26526, 0.012322, 0.39689>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.02489, 0.475805, 0.533275>, <-1.0171, 0.472957, 0.519514>, <-1.00932, 0.470108, 0.505752>, <-1.00153, 0.46726, 0.491991>,
      <-1.03117, 0.360582, 0.527558>, <-1.02338, 0.357734, 0.513797>, <-1.01508, 0.362113, 0.500509>, <-1.00729, 0.359265, 0.486748>,
      <-1.04329, 0.25725, 0.460546>, <-1.03468, 0.261718, 0.447689>, <-1.02689, 0.258869, 0.433927>, <-1.01828, 0.263337, 0.42107>,
      <-1.05249, 0.147973, 0.424181>, <-1.04388, 0.152441, 0.411324>, <-1.03527, 0.156908, 0.398467>, <-1.02665, 0.161376, 0.38561>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.02489, 0.475805, 0.533275>, <-1.0171, 0.472957, 0.519514>, <-1.00932, 0.470108, 0.505752>, <-1.00153, 0.46726, 0.491991>,
      <-1.10644, 0.482903, 0.563745>, <-1.09865, 0.480055, 0.549984>, <-1.08341, 0.474694, 0.53464>, <-1.07562, 0.471845, 0.520878>,
      <-1.21199, 0.478208, 0.54713>, <-1.19642, 0.474445, 0.534176>, <-1.18512, 0.466726, 0.514742>, <-1.16955, 0.462963, 0.501789>,
      <-1.28438, 0.451263, 0.506357>, <-1.26881, 0.4475, 0.493403>, <-1.25324, 0.443737, 0.48045>, <-1.23767, 0.439974, 0.467496>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.05249, 0.147973, 0.424181>, <-1.04388, 0.152441, 0.411324>, <-1.03527, 0.156908, 0.398467>, <-1.02665, 0.161376, 0.38561>,
      <-1.12175, 0.101682, 0.43894>, <-1.11314, 0.10615, 0.426083>, <-1.0975, 0.113052, 0.411729>, <-1.08889, 0.11752, 0.398872>,
      <-1.19312, 0.0465691, 0.424826>, <-1.17813, 0.054559, 0.412788>, <-1.16719, 0.0558531, 0.396852>, <-1.15219, 0.063843, 0.384814>,
      <-1.26526, 0.012322, 0.39689>, <-1.25027, 0.020312, 0.384852>, <-1.23527, 0.028302, 0.372814>, <-1.22027, 0.036292, 0.360776>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.28438, 0.451263, 0.506357>, <-1.3724, 0.418501, 0.456782>, <-1.40542, 0.358185, 0.358699>, <-1.46594, 0.311646, 0.284871>,
      <-1.28104, 0.300465, 0.501026>, <-1.36906, 0.267703, 0.451451>, <-1.39572, 0.246257, 0.359043>, <-1.45624, 0.199718, 0.285215>,
      <-1.27163, 0.158635, 0.433379>, <-1.32334, 0.134091, 0.413358>, <-1.37926, 0.10128, 0.322941>, <-1.42637, 0.0904642, 0.286331>,
      <-1.26526, 0.012322, 0.39689>, <-1.31696, -0.0122224, 0.376869>, <-1.35948, -0.00931004, 0.323671>, <-1.40658, -0.020126, 0.287061>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.28438, 0.451263, 0.506357>, <-1.26881, 0.4475, 0.493403>, <-1.25324, 0.443737, 0.48045>, <-1.23767, 0.439974, 0.467496>,
      <-1.28104, 0.300465, 0.501026>, <-1.26547, 0.296702, 0.488072>, <-1.25019, 0.304552, 0.475579>, <-1.23462, 0.300789, 0.462626>,
      <-1.27163, 0.158635, 0.433379>, <-1.25664, 0.166625, 0.421341>, <-1.24107, 0.162862, 0.408387>, <-1.22607, 0.170852, 0.396349>,
      <-1.26526, 0.012322, 0.39689>, <-1.25027, 0.020312, 0.384852>, <-1.23527, 0.028302, 0.372814>, <-1.22027, 0.036292, 0.360776>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.28438, 0.451263, 0.506357>, <-1.26881, 0.4475, 0.493403>, <-1.25324, 0.443737, 0.48045>, <-1.23767, 0.439974, 0.467496>,
      <-1.3724, 0.418501, 0.456782>, <-1.35684, 0.414738, 0.443828>, <-1.34298, 0.413454, 0.435277>, <-1.32741, 0.409691, 0.422323>,
      <-1.40542, 0.358185, 0.358699>, <-1.39922, 0.359908, 0.352934>, <-1.38365, 0.356145, 0.339981>, <-1.37745, 0.357868, 0.334216>,
      <-1.46594, 0.311646, 0.284871>, <-1.45974, 0.313369, 0.279106>, <-1.45354, 0.315093, 0.273341>, <-1.44734, 0.316816, 0.267576>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.26526, 0.012322, 0.39689>, <-1.25027, 0.020312, 0.384852>, <-1.23527, 0.028302, 0.372814>, <-1.22027, 0.036292, 0.360776>,
      <-1.31696, -0.0122224, 0.376869>, <-1.30197, -0.00423245, 0.364831>, <-1.29356, 0.00471512, 0.352235>, <-1.27856, 0.0127051, 0.340197>,
      <-1.35948, -0.00931004, 0.323671>, <-1.35349, 0.00236691, 0.313922>, <-1.33849, 0.010357, 0.301884>, <-1.3325, 0.022034, 0.292135>,
      <-1.40658, -0.020126, 0.287061>, <-1.40059, -0.00844905, 0.277312>, <-1.3946, 0.00322805, 0.267564>, <-1.38861, 0.014905, 0.257815>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.46594, 0.311646, 0.284871>, <-1.45974, 0.313369, 0.279106>, <-1.45354, 0.315093, 0.273341>, <-1.44734, 0.316816, 0.267576>,
      <-1.45624, 0.199718, 0.285215>, <-1.45004, 0.201441, 0.27945>, <-1.44277, 0.21315, 0.269703>, <-1.43657, 0.214874, 0.263938>,
      <-1.42637, 0.0904642, 0.286331>, <-1.42038, 0.102141, 0.276582>, <-1.41418, 0.103865, 0.270817>, <-1.40819, 0.115542, 0.261069>,
      <-1.40658, -0.020126, 0.287061>, <-1.40059, -0.00844905, 0.277312>, <-1.3946, 0.00322805, 0.267564>, <-1.38861, 0.014905, 0.257815>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.765392, 0.531539, 0.24446>, <-0.772091, 0.511603, 0.261998>, <-0.778326, 0.495892, 0.286358>, <-0.785489, 0.471731, 0.297075>,
      <-0.850804, 0.631026, 0.257313>, <-0.857503, 0.61109, 0.274851>, <-0.848665, 0.580804, 0.325014>, <-0.855828, 0.556643, 0.335731>,
      <-0.915812, 0.752036, 0.273953>, <-0.907438, 0.717524, 0.317294>, <-0.908744, 0.703299, 0.366808>, <-0.906057, 0.654803, 0.394746>,
      <-1.02163, 0.830002, 0.283019>, <-1.01325, 0.795491, 0.32636>, <-0.999195, 0.774964, 0.385106>, <-0.996508, 0.726468, 0.413044>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.02163, 0.830002, 0.283019>, <-1.01325, 0.795491, 0.32636>, <-0.999195, 0.774964, 0.385106>, <-0.996508, 0.726468, 0.413044>,
      <-1.07732, 0.871035, 0.287791>, <-1.06894, 0.836524, 0.331132>, <-1.06721, 0.828855, 0.398865>, <-1.06453, 0.780359, 0.426804>,
      <-1.15718, 0.873138, 0.294646>, <-1.16119, 0.85959, 0.32953>, <-1.15296, 0.87605, 0.397807>, <-1.15393, 0.841438, 0.412562>,
      <-1.22563, 0.870648, 0.283894>, <-1.22965, 0.857099, 0.318779>, <-1.23671, 0.864614, 0.373794>, <-1.23767, 0.830002, 0.388549>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.22563, 0.870648, 0.283894>, <-1.22965, 0.857099, 0.318779>, <-1.23671, 0.864614, 0.373794>, <-1.23767, 0.830002, 0.388549>,
      <-1.28986, 0.868312, 0.273806>, <-1.29387, 0.854763, 0.308691>, <-1.33065, 0.851785, 0.346856>, <-1.33161, 0.817173, 0.361611>,
      <-1.34382, 0.834304, 0.243387>, <-1.36189, 0.783448, 0.262663>, <-1.37891, 0.775904, 0.311763>, <-1.38397, 0.719043, 0.316824>,
      <-1.40291, 0.816132, 0.223134>, <-1.42098, 0.765276, 0.24241>, <-1.45206, 0.720425, 0.2759>, <-1.45712, 0.663564, 0.280961>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.785489, 0.471731, 0.297075>, <-0.790783, 0.453877, 0.304995>, <-0.798425, 0.432713, 0.300722>, <-0.800561, 0.412923, 0.297075>,
      <-0.855828, 0.556643, 0.335731>, <-0.861122, 0.538789, 0.343651>, <-0.865415, 0.450825, 0.365694>, <-0.867551, 0.431035, 0.362047>,
      <-0.906057, 0.654803, 0.394746>, <-0.901726, 0.576617, 0.439789>, <-0.908301, 0.55189, 0.461891>, <-0.913108, 0.461788, 0.457517>,
      <-0.996508, 0.726468, 0.413044>, <-0.992176, 0.648282, 0.458086>, <-0.996724, 0.557362, 0.496365>, <-1.00153, 0.46726, 0.491991>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.996508, 0.726468, 0.413044>, <-0.992176, 0.648282, 0.458086>, <-0.996724, 0.557362, 0.496365>, <-1.00153, 0.46726, 0.491991>,
      <-1.06453, 0.780359, 0.426804>, <-1.06019, 0.702173, 0.471846>, <-1.07082, 0.561948, 0.525252>, <-1.07562, 0.471845, 0.520878>,
      <-1.15393, 0.841438, 0.412562>, <-1.15734, 0.719459, 0.464563>, <-1.17246, 0.595496, 0.506426>, <-1.16955, 0.462963, 0.501789>,
      <-1.23767, 0.830002, 0.388549>, <-1.24108, 0.708022, 0.440551>, <-1.24058, 0.572507, 0.472133>, <-1.23767, 0.439974, 0.467496>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.23767, 0.830002, 0.388549>, <-1.24108, 0.708022, 0.440551>, <-1.24058, 0.572507, 0.472133>, <-1.23767, 0.439974, 0.467496>,
      <-1.33161, 0.817173, 0.361611>, <-1.33502, 0.695193, 0.413613>, <-1.33031, 0.542223, 0.426961>, <-1.32741, 0.409691, 0.422323>,
      <-1.38397, 0.719043, 0.316824>, <-1.39419, 0.604234, 0.327042>, <-1.38959, 0.47287, 0.338319>, <-1.37745, 0.357868, 0.334216>,
      <-1.45712, 0.663564, 0.280961>, <-1.46734, 0.548755, 0.29118>, <-1.45948, 0.431818, 0.27168>, <-1.44734, 0.316816, 0.267576>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-0.800561, 0.412923, 0.297075>, <-0.867551, 0.431035, 0.362047>, <-0.913108, 0.461788, 0.457517>, <-1.00153, 0.46726, 0.491991>,
      <-0.803546, 0.385261, 0.291977>, <-0.870536, 0.403373, 0.356949>, <-0.91887, 0.353793, 0.452274>, <-1.00729, 0.359265, 0.486748>,
      <-0.800561, 0.359016, 0.279915>, <-0.875925, 0.30212, 0.318007>, <-0.936282, 0.32112, 0.403597>, <-1.01828, 0.263337, 0.42107>,
      <-0.800561, 0.332062, 0.271335>, <-0.875925, 0.275167, 0.309427>, <-0.944657, 0.219159, 0.368136>, <-1.02665, 0.161376, 0.38561>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.00153, 0.46726, 0.491991>, <-1.07562, 0.471845, 0.520878>, <-1.16955, 0.462963, 0.501789>, <-1.23767, 0.439974, 0.467496>,
      <-1.00729, 0.359265, 0.486748>, <-1.08139, 0.36385, 0.515635>, <-1.1665, 0.323778, 0.496918>, <-1.23462, 0.300789, 0.462626>,
      <-1.01828, 0.263337, 0.42107>, <-1.08051, 0.219481, 0.434332>, <-1.15799, 0.198403, 0.420387>, <-1.22607, 0.170852, 0.396349>,
      <-1.02665, 0.161376, 0.38561>, <-1.08889, 0.11752, 0.398872>, <-1.15219, 0.063843, 0.384814>, <-1.22027, 0.036292, 0.360776>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-1.23767, 0.439974, 0.467496>, <-1.32741, 0.409691, 0.422323>, <-1.37745, 0.357868, 0.334216>, <-1.44734, 0.316816, 0.267576>,
      <-1.23462, 0.300789, 0.462626>, <-1.32436, 0.270506, 0.417453>, <-1.36668, 0.255926, 0.330578>, <-1.43657, 0.214874, 0.263938>,
      <-1.22607, 0.170852, 0.396349>, <-1.28436, 0.147265, 0.37577>, <-1.35208, 0.122671, 0.295389>, <-1.40819, 0.115542, 0.261069>,
      <-1.22027, 0.036292, 0.360776>, <-1.27856, 0.0127051, 0.340197>, <-1.3325, 0.022034, 0.292135>, <-1.38861, 0.014905, 0.257815>
   }
}

// Commun
#declare PeauGrise = texture {
   pigment {
      granite
      turbulence <2, 2, 2>
      
      color_map {
         [ 0 color rgb <0.45098, 0.462745, 0.52549>
         ]
         [ 0.8 color rgb <0.486275, 0.498039, 0.564706>
         ]
      }
   }
   
   normal {
      agate
      agate_turb 0.5
      turbulence <1, 0, 1>
      bump_size 0.1
   }
   scale 0.1
}

#declare PeauRose = texture {
   pigment {
      color rgb <0.878431, 0.705882, 0.698039>
   }
}

#declare NoirOeil = texture {
   pigment {
      color rgb <0, 0, 0>
   }
   
   finish {
      phong 10
      phong_size 30
   }
}

#declare BlancOeil = texture {
   pigment {
      color rgb <1, 1, 1>
   }
   
   finish {
      phong 10
      phong_size 30
   }
}

#declare RRMoustaches = union {
   //*PMName Moustache
   
   sphere {
      <0, 0, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 0, 0>, <-0.5, 0, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      sphere {
         <0, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, 0>, <-0.5, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         sphere {
            <0, 0, 0>, 0.02
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, 0>, <-0.5, 0, 0>, 0.02
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         union {
            sphere {
               <0, 0, 0>, 0.02
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, 0>, <-0.5, 0, 0>, 0.02
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            rotate z*3
            translate x*(-0.5)
         }
         rotate z*3
         translate x*(-0.5)
      }
      rotate z*3
      translate x*(-0.5)
   }
   rotate z*3
   translate <0, 0, 0>
}
//*PMRawBegin
#include "rat1tete.inc"
//*PMRawEnd

// Colle
#declare TrouColle = superellipsoid {
   <1, 0.2>
   scale <0.17, 0.17, 0.5>
   rotate y*90
   translate <-1.91, 0.62, 0>
}

#declare TrouColle3 = union {
   object {
      TrouColle
      scale 1
      rotate <0, -0, -0>
      translate <0, 0, 0>
   }
   
   object {
      TrouColle
      scale 1
      rotate x*30
      translate <0, 0, 0>
   }
   
   object {
      TrouColle
      scale 1
      rotate x*60
      translate <0, 0, 0>
   }
}

#declare Colle = union {
   //*PMName Stick
   //*PMRawBegin
   #include "ratcolle3.inc"
   //*PMRawEnd
   
   union {
      //*PMName Colle
      
      union {
         //*PMName jaune
         
         cylinder {
            <-1.5, 0, 0>, <1.5, 0, 0>, 0.5
         }
         
         cylinder {
            <-1.499, 0, 0>, <1.499, 0, 0>, 0.501
            
            texture {
               pigment {
                  image_map {
                     png
                     "/home/tom/RayTrace/Unplugged/textures/uhu.png"
                     once
                     map_type 2
                  }
                  rotate z*(-90)
                  scale <3, 1, 1>
                  translate x*(-1.5)
               }
               
               finish {
                  brilliance 1
                  phong 2
                  phong_size 40
                  
                  reflection {
                     rgb <0.0627451, 0.0627451, 0.0627451>
                  }
               }
            }
         }
         
         cylinder {
            <-1.5, 0, 0>, <-1.6, 0, 0>, 0.45
         }
         
         pigment {
            color rgb <1, 0.823529, 0.121569>
         }
      }
      
      difference {
         //*PMName Blanc
         
         cylinder {
            <-1.52, 0, 0>, <-2.4, 0, 0>, 0.51
         }
         
         object {
            TrouColle3
            scale 1
            rotate <0, -0, 0>
            translate <0, 0, 0>
         }
         
         object {
            TrouColle3
            scale 1
            rotate x*90
            translate <0, 0, 0>
         }
         
         object {
            TrouColle3
            scale 1
            rotate x*180
            translate <0, 0, 0>
         }
         
         object {
            TrouColle3
            scale 1
            rotate x*(-90)
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <1, 0.2>
            scale <0.4, 0.4, 0.2>
            rotate y*90
            translate x*(-2.4)
         }
         
         pigment {
            color rgb <1, 1, 1>
         }
      }
      
      union {
         //*PMName Capuchon
         
         cylinder {
            <1.5, 0, 0>, <2, 0, 0>, 0.51
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <1, 0.2>
            scale <0.51, 0.51, 0.1>
            rotate y*90
            translate x*2
         }
         
         texture {
            pigment {
               color rgb <1, 1, 1>
            }
            
            normal {
               bump_map {
                  png
                  "/home/tom/RayTrace/Unplugged/textures/rainurescolle.png"
                  map_type 2
               }
               rotate z*90
               bump_size 0.4
            }
            
            finish {
               diffuse 0.7
               brilliance 1.1
            }
         }
      }
      rotate x*(-45)
      translate y*0.51
      scale 2
   }
   
   union {
      //*PMName Rat
      
      union {
         //*PMName Tete
         
         union {
            //*PMName Moustaches
            
            object {
               RRMoustaches
               scale 1
               rotate z*(-2.6)
               translate <-0.42389, 0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <0, 0, 0>
               translate <-0.42389, 0, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate z*2.3
               translate <-0.42389, -0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <-0, 180, 2.6>
               translate <0.42389, 0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate y*180
               translate <0.42389, 0, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <0, 180, -2.3>
               translate <0.42389, -0.15, -2.8691>
            }
            
            pigment {
               color rgbft <1, 1, 1, 0.2, 0.2>
            }
            translate <0, 0.2, 0.4>
         }
         
         union {
            //*PMName Yeux
            
            union {
               //*PMName Droit
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeil
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate x*20
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-5)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.9, 1>
               rotate <0, 0, 0>
               translate x*(-0.42)
            }
            
            union {
               //*PMName Gauche
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeil
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate x*20
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-5)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.9, 1>
               rotate <0, 0, 0>
               translate x*0.42
            }
            translate <0, 0.98, -0.3758>
         }
         
         object {
            StdTete
            //*PMRawBegin
            texture {
               PeauGrise
            }
            //*PMRawEnd
         }
         
         object {
            StdOreilles
            //*PMRawBegin
            texture {
               PeauGrise
            }
            //*PMRawEnd
         }
         
         sphere {
            //*PMName Truffe
            <0, 0, -3.48>, 0.4
            
            texture {
               NoirOeil
            }
            scale <0.6, 0.5, 1>
            rotate x*5.1
            translate <0, -0.07, 0.38>
         }
         
         union {
            //*PMName Dents
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.11)
            }
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*0.11
            }
            translate <0, -0.6, -1.4>
            
            texture {
               BlancOeil
            }
         }
         scale 0.6
         rotate <-27.6, -12.5, 0>
         translate <0, 0.657124, -1.43286>
      }
      //*PMRawBegin
      object {
         //*PMName Corps
         StickCorps
         
         texture {
            PeauGrise
         }
      }
      
      object {
         //*PMName Queue
         StickQueue
         
         texture {
            PeauRose
         }
      }
      
      object {
         //*PMName Bras
         StickBras
         
         texture {
            PeauGrise
         }
      }
      //*PMRawEnd
      rotate <0, 0, 0>
      translate <0, 5.0145, -1.30099>
   }
   rotate x*(-5)
}

// Bain
#declare Ceramique = texture {
   agate
   agate_turb 0.5
   
   texture_map {
      [ 0 pigment {
         color rgb <1, 1, 1>
      }
      
      finish {
         phong 2
         phong_size 40
         
         reflection {
            rgb <0.14902, 0.14902, 0.14902>
         }
      }
      ]
      [ 0.5 pigment {
         color rgb <0.94902, 0.94902, 0.94902>
      }
      
      finish {
         phong 2
         phong_size 40
         
         reflection {
            rgb <0.117647, 0.117647, 0.117647>
         }
      }
      ]
   }
}

#declare TasseAnse5 = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.92565, 1.26132, 0.249998>, <2.94336, 1.23298, 0.291773>, <2.98743, 1.16246, 0.291773>, <3.00514, 1.13412, 0.249998>,
      <2.88709, 1.24317, 0.249998>, <2.9048, 1.21483, 0.291773>, <2.92976, 1.13726, 0.291773>, <2.94747, 1.10891, 0.249998>,
      <2.84974, 1.22217, 0.249998>, <2.85467, 1.18911, 0.291774>, <2.8864, 1.11288, 0.291774>, <2.89134, 1.07982, 0.249998>,
      <2.80995, 1.20686, 0.249998>, <2.81489, 1.17381, 0.291774>, <2.82718, 1.09156, 0.291774>, <2.83212, 1.05851, 0.249998>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.92565, 1.26132, 0.249998>, <2.89555, 1.30949, 0.178993>, <2.89915, 1.30373, 0.0909308>, <2.89915, 1.30373, -0>,
      <2.88709, 1.24317, 0.249998>, <2.85698, 1.29134, 0.178993>, <2.87003, 1.32466, 0.0909308>, <2.87003, 1.32466, 0>,
      <2.84974, 1.22217, 0.249998>, <2.84134, 1.27835, 0.178993>, <2.8359, 1.26955, 0.0909305>, <2.8359, 1.26955, -0>,
      <2.80995, 1.20686, 0.249998>, <2.80156, 1.26304, 0.178993>, <2.80256, 1.25631, 0.0909305>, <2.80256, 1.25631, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.80995, 1.20686, 0.249998>, <2.81489, 1.17381, 0.291774>, <2.82718, 1.09156, 0.291774>, <2.83212, 1.05851, 0.249998>,
      <2.77159, 1.1921, 0.249998>, <2.77653, 1.15905, 0.291774>, <2.78167, 1.07518, 0.291774>, <2.78661, 1.04213, 0.249998>,
      <2.73053, 1.1731, 0.23619>, <2.73053, 1.13968, 0.277966>, <2.73671, 1.06534, 0.277105>, <2.73671, 1.03192, 0.235329>,
      <2.69185, 1.17136, 0.249998>, <2.69185, 1.13794, 0.291774>, <2.69185, 1.05478, 0.291774>, <2.69185, 1.02136, 0.249998>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.80995, 1.20686, 0.249998>, <2.80156, 1.26304, 0.178993>, <2.80256, 1.25631, 0.0909305>, <2.80256, 1.25631, -0>,
      <2.77159, 1.1921, 0.249998>, <2.76319, 1.24828, 0.178993>, <2.7666, 1.24202, 0.0909305>, <2.7666, 1.24202, 0>,
      <2.73053, 1.1731, 0.23619>, <2.73053, 1.22991, 0.165185>, <2.72943, 1.21215, 0.0903008>, <2.72943, 1.21215, -0.000629742>,
      <2.69185, 1.17136, 0.249998>, <2.69185, 1.22817, 0.178994>, <2.69185, 1.22136, 0.0909306>, <2.69185, 1.22136, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.69185, 1.17136, 0.249998>, <2.69185, 1.13794, 0.291774>, <2.69185, 1.05478, 0.291774>, <2.69185, 1.02136, 0.249998>,
      <2.64407, 1.16922, 0.267052>, <2.64407, 1.1358, 0.308828>, <2.64474, 1.0437, 0.307173>, <2.64474, 1.01028, 0.265397>,
      <2.60973, 1.18781, 0.307419>, <2.60701, 1.13909, 0.359205>, <2.60973, 1.05291, 0.359847>, <2.60973, 1.00481, 0.307419>,
      <2.56867, 1.19603, 0.336129>, <2.56596, 1.14731, 0.387915>, <2.56867, 1.04464, 0.388557>, <2.56867, 0.996532, 0.336129>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.69185, 1.17136, 0.249998>, <2.69185, 1.22817, 0.178994>, <2.69185, 1.22136, 0.0909306>, <2.69185, 1.22136, -0>,
      <2.64407, 1.16922, 0.267052>, <2.64407, 1.22602, 0.196047>, <2.6473, 1.23228, 0.091677>, <2.6473, 1.23228, 0.000746407>,
      <2.60973, 1.18781, 0.307419>, <2.61451, 1.2737, 0.216121>, <2.62135, 1.28002, 0.127861>, <2.62135, 1.28002, 0.002418>,
      <2.56867, 1.19603, 0.336129>, <2.57346, 1.28192, 0.244831>, <2.5861, 1.30935, 0.12907>, <2.5861, 1.30935, 0.003627>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.00514, 1.13412, 0.249998>, <3.03524, 1.08594, 0.178993>, <3.03163, 1.09171, 0.0909307>, <3.03163, 1.09171, -0>,
      <2.94747, 1.10891, 0.249998>, <2.97757, 1.06074, 0.178993>, <2.96759, 1.06416, 0.0909307>, <2.96759, 1.06416, 0>,
      <2.89134, 1.07982, 0.249998>, <2.89974, 1.02364, 0.178993>, <2.90523, 1.03233, 0.0909307>, <2.90523, 1.03233, -0>,
      <2.83212, 1.05851, 0.249998>, <2.84052, 1.00233, 0.178993>, <2.83951, 1.00906, 0.0909307>, <2.83951, 1.00906, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.83212, 1.05851, 0.249998>, <2.84052, 1.00233, 0.178993>, <2.83951, 1.00906, 0.0909307>, <2.83951, 1.00906, -0>,
      <2.78661, 1.04213, 0.249998>, <2.79501, 0.985948, 0.178993>, <2.79163, 0.992096, 0.0909307>, <2.79163, 0.992096, 0>,
      <2.73671, 1.03192, 0.235329>, <2.73671, 0.975113, 0.164325>, <2.73841, 0.991667, 0.0903072>, <2.73841, 0.991667, -0.000623533>,
      <2.69185, 1.02136, 0.249998>, <2.69185, 0.964558, 0.178994>, <2.69185, 0.971361, 0.0909308>, <2.69185, 0.971361, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.69185, 1.02136, 0.249998>, <2.69185, 0.964558, 0.178994>, <2.69185, 0.971361, 0.0909308>, <2.69185, 0.971361, -0>,
      <2.64474, 1.01028, 0.265397>, <2.64474, 0.953477, 0.194393>, <2.64689, 0.951755, 0.0915328>, <2.64689, 0.951755, 0.000602038>,
      <2.60973, 1.00481, 0.307419>, <2.60973, 0.920686, 0.215738>, <2.60973, 0.917748, 0.126845>, <2.60973, 0.917748, 0.002418>,
      <2.56867, 0.996532, 0.336129>, <2.56867, 0.912409, 0.244448>, <2.56867, 0.890941, 0.128054>, <2.56867, 0.890941, 0.003627>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.00514, 1.13412, -0.25>, <2.98743, 1.16246, -0.291775>, <2.94336, 1.23298, -0.291775>, <2.92565, 1.26132, -0.25>,
      <2.94747, 1.10891, -0.25>, <2.92976, 1.13726, -0.291775>, <2.9048, 1.21483, -0.291775>, <2.88709, 1.24317, -0.25>,
      <2.89134, 1.07982, -0.25>, <2.8864, 1.11288, -0.291776>, <2.85467, 1.18911, -0.291776>, <2.84974, 1.22217, -0.25>,
      <2.83212, 1.05851, -0.25>, <2.82718, 1.09156, -0.291776>, <2.81489, 1.17381, -0.291776>, <2.80995, 1.20686, -0.25>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.00514, 1.13412, -0.25>, <3.03524, 1.08594, -0.178994>, <3.03163, 1.09171, -0.0909314>, <3.03163, 1.09171, -0>,
      <2.94747, 1.10891, -0.25>, <2.97757, 1.06074, -0.178994>, <2.96759, 1.06416, -0.0909314>, <2.96759, 1.06416, 0>,
      <2.89134, 1.07982, -0.25>, <2.89974, 1.02364, -0.178995>, <2.90523, 1.03233, -0.0909314>, <2.90523, 1.03233, -0>,
      <2.83212, 1.05851, -0.25>, <2.84052, 1.00233, -0.178995>, <2.83951, 1.00906, -0.0909314>, <2.83951, 1.00906, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.83212, 1.05851, -0.25>, <2.82718, 1.09156, -0.291776>, <2.81489, 1.17381, -0.291776>, <2.80995, 1.20686, -0.25>,
      <2.78661, 1.04213, -0.25>, <2.78167, 1.07518, -0.291776>, <2.77653, 1.15905, -0.291776>, <2.77159, 1.1921, -0.25>,
      <2.73705, 1.032, -0.236467>, <2.73705, 1.06542, -0.278243>, <2.73088, 1.1397, -0.279016>, <2.73088, 1.17312, -0.23724>,
      <2.69185, 1.02136, -0.25>, <2.69185, 1.05478, -0.291776>, <2.69185, 1.13794, -0.291776>, <2.69185, 1.17136, -0.25>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.83212, 1.05851, -0.25>, <2.84052, 1.00233, -0.178995>, <2.83951, 1.00906, -0.0909314>, <2.83951, 1.00906, -0>,
      <2.78661, 1.04213, -0.25>, <2.79501, 0.985948, -0.178995>, <2.79163, 0.992096, -0.0909314>, <2.79163, 0.992096, 0>,
      <2.73705, 1.032, -0.236467>, <2.73705, 0.975192, -0.165462>, <2.73841, 0.991667, -0.091555>, <2.73841, 0.991667, -0.000623533>,
      <2.69185, 1.02136, -0.25>, <2.69185, 0.964558, -0.178995>, <2.69185, 0.971361, -0.0909315>, <2.69185, 0.971361, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.69185, 1.02136, -0.25>, <2.69185, 1.05478, -0.291776>, <2.69185, 1.13794, -0.291776>, <2.69185, 1.17136, -0.25>,
      <2.64563, 1.01049, -0.263835>, <2.64563, 1.04391, -0.305611>, <2.64489, 1.13584, -0.307124>, <2.64489, 1.16926, -0.265347>,
      <2.60973, 1.00481, -0.302579>, <2.60973, 1.05292, -0.355006>, <2.60701, 1.13909, -0.354364>, <2.60973, 1.18781, -0.302579>,
      <2.56867, 0.996532, -0.328868>, <2.56867, 1.04464, -0.381295>, <2.56596, 1.14731, -0.380653>, <2.56867, 1.19603, -0.328868>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.69185, 1.02136, -0.25>, <2.69185, 0.964558, -0.178995>, <2.69185, 0.971361, -0.0909315>, <2.69185, 0.971361, -0>,
      <2.64563, 1.01049, -0.263835>, <2.64563, 0.953686, -0.19283>, <2.64689, 0.951755, -0.0903294>, <2.64689, 0.951755, 0.000602038>,
      <2.60973, 1.00481, -0.302579>, <2.60973, 0.920687, -0.2109>, <2.60973, 0.917748, -0.122007>, <2.60973, 0.917748, 0.002418>,
      <2.56867, 0.996532, -0.328868>, <2.56867, 0.91241, -0.237189>, <2.56867, 0.890941, -0.120798>, <2.56867, 0.890941, 0.003627>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.92565, 1.26132, -0.25>, <2.89555, 1.30949, -0.178994>, <2.89915, 1.30373, -0.0909315>, <2.89915, 1.30373, -0>,
      <2.88709, 1.24317, -0.25>, <2.85698, 1.29134, -0.178994>, <2.87003, 1.32466, -0.0909315>, <2.87003, 1.32466, 0>,
      <2.84974, 1.22217, -0.25>, <2.84134, 1.27835, -0.178994>, <2.8359, 1.26955, -0.0909312>, <2.8359, 1.26955, -0>,
      <2.80995, 1.20686, -0.25>, <2.80156, 1.26304, -0.178994>, <2.80256, 1.25631, -0.0909312>, <2.80256, 1.25631, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.80995, 1.20686, -0.25>, <2.80156, 1.26304, -0.178994>, <2.80256, 1.25631, -0.0909312>, <2.80256, 1.25631, -0>,
      <2.77159, 1.1921, -0.25>, <2.76319, 1.24828, -0.178994>, <2.7666, 1.24202, -0.0909312>, <2.7666, 1.24202, 0>,
      <2.73088, 1.17312, -0.23724>, <2.73088, 1.22992, -0.166234>, <2.72943, 1.21215, -0.091561>, <2.72943, 1.21215, -0.000629742>,
      <2.69185, 1.17136, -0.25>, <2.69185, 1.22817, -0.178995>, <2.69185, 1.22136, -0.0909313>, <2.69185, 1.22136, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.69185, 1.17136, -0.25>, <2.69185, 1.22817, -0.178995>, <2.69185, 1.22136, -0.0909313>, <2.69185, 1.22136, -0>,
      <2.64489, 1.16926, -0.265347>, <2.64489, 1.22606, -0.194342>, <2.6473, 1.23228, -0.0901848>, <2.6473, 1.23228, 0.000746407>,
      <2.60973, 1.18781, -0.302579>, <2.61451, 1.2737, -0.211283>, <2.62135, 1.28002, -0.123023>, <2.62135, 1.28002, 0.002418>,
      <2.56867, 1.19603, -0.328868>, <2.57346, 1.28192, -0.237572>, <2.5861, 1.30935, -0.121814>, <2.5861, 1.30935, 0.003627>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.75635, 2.41652, -0>, <2.732, 2.42206, 0>, <2.70626, 2.43397, 0.00010067>, <2.6822, 2.42727, -0>,
      <2.75635, 2.41652, 0.0909304>, <2.732, 2.42206, 0.0909304>, <2.70626, 2.43397, 0.0910318>, <2.6822, 2.42727, 0.0909312>,
      <2.75459, 2.40995, 0.178993>, <2.72629, 2.41643, 0.178994>, <2.71022, 2.4211, 0.171847>, <2.68208, 2.42047, 0.178994>,
      <2.76929, 2.46482, 0.249998>, <2.74099, 2.4713, 0.249998>, <2.71121, 2.4779, 0.242853>, <2.68308, 2.47727, 0.25>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.75635, 2.41652, -0>, <2.77964, 2.41122, -0>, <2.80892, 2.3769, 0>, <2.82466, 2.39487, -0>,
      <2.75635, 2.41652, 0.0909304>, <2.77964, 2.41123, 0.0909304>, <2.80892, 2.3769, 0.090931>, <2.82466, 2.39487, 0.090931>,
      <2.75459, 2.40995, 0.178993>, <2.78098, 2.4039, 0.178993>, <2.79591, 2.39709, 0.178993>, <2.82168, 2.38875, 0.178994>,
      <2.76929, 2.46482, 0.249998>, <2.79568, 2.45877, 0.249998>, <2.82082, 2.44814, 0.249999>, <2.84658, 2.43981, 0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.75635, 2.41652, -0>, <2.732, 2.42206, 0>, <2.70626, 2.43397, 0.00010067>, <2.6822, 2.42727, -0>,
      <2.75635, 2.41652, -0.0909308>, <2.732, 2.42206, -0.0909308>, <2.70626, 2.43397, -0.0908301>, <2.6822, 2.42727, -0.0909308>,
      <2.75459, 2.40995, -0.178994>, <2.72629, 2.41643, -0.178994>, <2.71017, 2.4211, -0.171652>, <2.68208, 2.42047, -0.178994>,
      <2.76929, 2.46482, -0.249999>, <2.74099, 2.4713, -0.249999>, <2.71116, 2.4779, -0.242657>, <2.68308, 2.47727, -0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.75635, 2.41652, -0>, <2.77964, 2.41122, -0>, <2.80892, 2.3769, 0>, <2.82466, 2.39487, -0>,
      <2.75635, 2.41652, -0.0909308>, <2.77964, 2.41123, -0.0909308>, <2.80892, 2.3769, -0.090931>, <2.82466, 2.39487, -0.090931>,
      <2.75459, 2.40995, -0.178994>, <2.78098, 2.4039, -0.178994>, <2.79591, 2.39709, -0.178994>, <2.82168, 2.38875, -0.178994>,
      <2.76929, 2.46482, -0.249999>, <2.79568, 2.45877, -0.249999>, <2.82082, 2.44814, -0.249999>, <2.84658, 2.43981, -0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.76929, 2.46482, 0.249998>, <2.74099, 2.4713, 0.249998>, <2.71121, 2.4779, 0.242853>, <2.68308, 2.47727, 0.25>,
      <2.77794, 2.4971, 0.291774>, <2.74964, 2.50358, 0.291775>, <2.71179, 2.51131, 0.284629>, <2.68366, 2.51068, 0.291776>,
      <2.79946, 2.57743, 0.291774>, <2.75931, 2.58675, 0.291774>, <2.72505, 2.58849, 0.283082>, <2.68511, 2.59383, 0.291776>,
      <2.80811, 2.60971, 0.249998>, <2.76796, 2.61903, 0.249998>, <2.72563, 2.6219, 0.241306>, <2.68569, 2.62724, 0.25>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.76929, 2.46482, 0.249998>, <2.79568, 2.45877, 0.249998>, <2.82082, 2.44814, 0.249999>, <2.84658, 2.43981, 0.249999>,
      <2.77794, 2.4971, 0.291774>, <2.80433, 2.49105, 0.291774>, <2.83547, 2.47818, 0.291774>, <2.86123, 2.46984, 0.291774>,
      <2.79946, 2.57743, 0.291774>, <2.83517, 2.56914, 0.291774>, <2.86294, 2.55628, 0.291774>, <2.89768, 2.54459, 0.291774>,
      <2.80811, 2.60971, 0.249998>, <2.84382, 2.60142, 0.249998>, <2.87759, 2.58632, 0.249999>, <2.91233, 2.57462, 0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.80811, 2.60971, 0.249998>, <2.76796, 2.61903, 0.249998>, <2.72563, 2.6219, 0.241306>, <2.68569, 2.62724, 0.25>,
      <2.82282, 2.66458, 0.178994>, <2.78266, 2.6739, 0.178994>, <2.72662, 2.6787, 0.170301>, <2.68668, 2.68404, 0.178995>,
      <2.82105, 2.65801, 0.0909307>, <2.77695, 2.66827, 0.0909307>, <2.73, 2.66442, 0.0910716>, <2.68656, 2.67724, 0.0909314>,
      <2.82105, 2.65801, -0>, <2.77695, 2.66827, -0>, <2.73, 2.66442, 0.000140128>, <2.68656, 2.67724, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.80811, 2.60971, 0.249998>, <2.84382, 2.60142, 0.249998>, <2.87759, 2.58632, 0.249999>, <2.91233, 2.57462, 0.249999>,
      <2.82282, 2.66458, 0.178994>, <2.85852, 2.65629, 0.178994>, <2.90249, 2.63737, 0.178994>, <2.93723, 2.62568, 0.178994>,
      <2.82105, 2.65801, 0.0909307>, <2.85987, 2.64897, 0.0909307>, <2.89652, 2.63238, 0.0909312>, <2.93425, 2.61957, 0.0909312>,
      <2.82105, 2.65801, -0>, <2.85987, 2.64897, 0>, <2.89652, 2.63238, 0>, <2.93425, 2.61957, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.82105, 2.65801, -0>, <2.77695, 2.66827, -0>, <2.73, 2.66442, 0.000140128>, <2.68656, 2.67724, -0>,
      <2.82105, 2.65801, -0.090931>, <2.77695, 2.66827, -0.090931>, <2.73, 2.66442, -0.0907909>, <2.68656, 2.67724, -0.0909311>,
      <2.82282, 2.66458, -0.178994>, <2.78266, 2.6739, -0.178994>, <2.72657, 2.67871, -0.170059>, <2.68668, 2.68404, -0.178994>,
      <2.80811, 2.60971, -0.249999>, <2.76796, 2.61903, -0.249999>, <2.72558, 2.62191, -0.241064>, <2.68569, 2.62724, -0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.82105, 2.65801, -0>, <2.85987, 2.64897, 0>, <2.89652, 2.63238, 0>, <2.93425, 2.61957, -0>,
      <2.82105, 2.65801, -0.090931>, <2.85987, 2.64897, -0.090931>, <2.89652, 2.63238, -0.0909312>, <2.93425, 2.61957, -0.0909312>,
      <2.82282, 2.66458, -0.178994>, <2.85852, 2.65629, -0.178994>, <2.90249, 2.63737, -0.178994>, <2.93723, 2.62568, -0.178994>,
      <2.80811, 2.60971, -0.249999>, <2.84382, 2.60142, -0.249999>, <2.87759, 2.58632, -0.249999>, <2.91233, 2.57462, -0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.80811, 2.60971, -0.249999>, <2.76796, 2.61903, -0.249999>, <2.72558, 2.62191, -0.241064>, <2.68569, 2.62724, -0.249999>,
      <2.79946, 2.57743, -0.291775>, <2.75931, 2.58675, -0.291775>, <2.725, 2.58849, -0.282839>, <2.68511, 2.59383, -0.291774>,
      <2.77794, 2.4971, -0.291776>, <2.74964, 2.50358, -0.291776>, <2.71175, 2.51131, -0.284433>, <2.68366, 2.51068, -0.291775>,
      <2.76929, 2.46482, -0.249999>, <2.74099, 2.4713, -0.249999>, <2.71116, 2.4779, -0.242657>, <2.68308, 2.47727, -0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.80811, 2.60971, -0.249999>, <2.84382, 2.60142, -0.249999>, <2.87759, 2.58632, -0.249999>, <2.91233, 2.57462, -0.249999>,
      <2.79946, 2.57743, -0.291775>, <2.83517, 2.56914, -0.291775>, <2.86294, 2.55628, -0.291774>, <2.89768, 2.54459, -0.291774>,
      <2.77794, 2.4971, -0.291776>, <2.80433, 2.49105, -0.291776>, <2.83547, 2.47818, -0.291774>, <2.86123, 2.46984, -0.291774>,
      <2.76929, 2.46482, -0.249999>, <2.79568, 2.45877, -0.249999>, <2.82082, 2.44814, -0.249999>, <2.84658, 2.43981, -0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.55587, 2.46003, 0.30421>, <2.55827, 2.38303, 0.220017>, <2.56778, 2.36406, 0.11333>, <2.56778, 2.36406, -0.000789>,
      <2.59827, 2.46577, 0.28614>, <2.60068, 2.38877, 0.201947>, <2.60592, 2.38513, 0.113593>, <2.60592, 2.38513, -0.000526001>,
      <2.63807, 2.47625, 0.261433>, <2.63707, 2.41946, 0.190427>, <2.64022, 2.41559, 0.0907555>, <2.64022, 2.41559, -0.000175652>,
      <2.68308, 2.47727, 0.25>, <2.68208, 2.42047, 0.178994>, <2.6822, 2.42727, 0.0909312>, <2.6822, 2.42727, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.55587, 2.46003, 0.30421>, <2.55449, 2.50406, 0.352363>, <2.55576, 2.59978, 0.353007>, <2.55906, 2.643, 0.30421>,
      <2.59827, 2.46577, 0.28614>, <2.59689, 2.50981, 0.334293>, <2.59797, 2.59452, 0.334937>, <2.60127, 2.63774, 0.28614>,
      <2.63807, 2.47625, 0.261433>, <2.63865, 2.50967, 0.303209>, <2.64033, 2.59981, 0.301522>, <2.64092, 2.63323, 0.259747>,
      <2.68308, 2.47727, 0.25>, <2.68366, 2.51068, 0.291776>, <2.68511, 2.59383, 0.291776>, <2.68569, 2.62724, 0.25>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.55906, 2.643, -0.305788>, <2.55576, 2.59978, -0.354585>, <2.55449, 2.50406, -0.353941>, <2.55587, 2.46003, -0.305788>,
      <2.60127, 2.63774, -0.287192>, <2.59797, 2.59452, -0.335989>, <2.59689, 2.50981, -0.335345>, <2.59827, 2.46577, -0.287192>,
      <2.64077, 2.63325, -0.260061>, <2.64019, 2.59983, -0.301837>, <2.63853, 2.50967, -0.303572>, <2.63795, 2.47625, -0.261796>,
      <2.68569, 2.62724, -0.249999>, <2.68511, 2.59383, -0.291774>, <2.68366, 2.51068, -0.291775>, <2.68308, 2.47727, -0.249999>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.55906, 2.643, -0.305788>, <2.56479, 2.71803, -0.221075>, <2.57649, 2.73016, -0.114097>, <2.57649, 2.73016, -0.000789>,
      <2.60127, 2.63774, -0.287192>, <2.607, 2.71278, -0.202479>, <2.61318, 2.71252, -0.113834>, <2.61318, 2.71252, -0.000526001>,
      <2.64077, 2.63325, -0.260061>, <2.64176, 2.69004, -0.189056>, <2.64752, 2.68876, -0.0910571>, <2.64752, 2.68876, -0.000125976>,
      <2.68569, 2.62724, -0.249999>, <2.68668, 2.68404, -0.178994>, <2.68656, 2.67724, -0.0909311>, <2.68656, 2.67724, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.55587, 2.46003, -0.305788>, <2.55827, 2.38303, -0.221595>, <2.56778, 2.36406, -0.114908>, <2.56778, 2.36406, -0.000789>,
      <2.59827, 2.46577, -0.287192>, <2.60068, 2.38877, -0.202999>, <2.60592, 2.38513, -0.114645>, <2.60592, 2.38513, -0.000526001>,
      <2.63795, 2.47625, -0.261796>, <2.63695, 2.41946, -0.19079>, <2.64022, 2.41559, -0.0911065>, <2.64022, 2.41559, -0.000175652>,
      <2.68308, 2.47727, -0.249999>, <2.68208, 2.42047, -0.178994>, <2.6822, 2.42727, -0.0909308>, <2.6822, 2.42727, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.68569, 2.62724, 0.25>, <2.64092, 2.63323, 0.259747>, <2.60127, 2.63774, 0.28614>, <2.55906, 2.643, 0.30421>,
      <2.68668, 2.68404, 0.178995>, <2.64191, 2.69002, 0.188741>, <2.607, 2.71278, 0.201427>, <2.56479, 2.71803, 0.219497>,
      <2.68656, 2.67724, 0.0909314>, <2.64752, 2.68876, 0.0908055>, <2.61318, 2.71252, 0.112782>, <2.57649, 2.73016, 0.112519>,
      <2.68656, 2.67724, -0>, <2.64752, 2.68876, -0.000125976>, <2.61318, 2.71252, -0.000526001>, <2.57649, 2.73016, -0.000789>
   }
}

#declare TasseAnseCasse = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.92565, 1.26132, 0.249998>, <2.89555, 1.30949, 0.178993>, <2.89915, 1.30373, 0.0909308>, <2.89915, 1.30373, -0>,
      <2.94336, 1.23298, 0.291773>, <2.91326, 1.28115, 0.220768>, <2.96683, 1.2551, 0.0909308>, <2.96683, 1.2551, -0>,
      <2.98743, 1.16246, 0.291773>, <3.01753, 1.11429, 0.220768>, <2.98747, 1.16238, 0.0909307>, <2.98747, 1.16238, 0>,
      <3.00514, 1.13412, 0.249998>, <3.03524, 1.08594, 0.178993>, <3.03163, 1.09171, 0.0909307>, <3.03163, 1.09171, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.00514, 1.13412, -0.25>, <3.03524, 1.08594, -0.178994>, <3.03163, 1.09171, -0.0909314>, <3.03163, 1.09171, -0>,
      <2.98743, 1.16246, -0.291775>, <3.01753, 1.11429, -0.220769>, <2.98747, 1.16238, -0.0909314>, <2.98747, 1.16238, 0>,
      <2.94336, 1.23298, -0.291775>, <2.91326, 1.28115, -0.220769>, <2.96683, 1.2551, -0.0909315>, <2.96683, 1.2551, -0>,
      <2.92565, 1.26132, -0.25>, <2.89555, 1.30949, -0.178994>, <2.89915, 1.30373, -0.0909315>, <2.89915, 1.30373, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.84658, 2.43981, 0.249999>, <2.86123, 2.46984, 0.291774>, <2.89768, 2.54459, 0.291774>, <2.91233, 2.57462, 0.249999>,
      <2.82168, 2.38875, 0.178994>, <2.83633, 2.41879, 0.220769>, <2.92258, 2.59564, 0.220769>, <2.93723, 2.62568, 0.178994>,
      <2.82466, 2.39487, 0.090931>, <2.87958, 2.45754, 0.090931>, <2.89772, 2.54467, 0.0909312>, <2.93425, 2.61957, 0.0909312>,
      <2.82466, 2.39487, -0>, <2.87958, 2.45754, -0>, <2.89772, 2.54467, 0>, <2.93425, 2.61957, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.91233, 2.57462, -0.249999>, <2.93723, 2.62568, -0.178994>, <2.93425, 2.61957, -0.0909312>, <2.93425, 2.61957, -0>,
      <2.89768, 2.54459, -0.291774>, <2.92258, 2.59564, -0.220769>, <2.89772, 2.54467, -0.0909312>, <2.89772, 2.54467, 0>,
      <2.86123, 2.46984, -0.291774>, <2.83633, 2.41879, -0.220769>, <2.87958, 2.45754, -0.090931>, <2.87958, 2.45754, -0>,
      <2.84658, 2.43981, -0.249999>, <2.82168, 2.38875, -0.178994>, <2.82466, 2.39487, -0.090931>, <2.82466, 2.39487, -0>
   }
}

#declare TasseMain = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0, 0.1, 0>, <-0, 0.1, 0>, <-0, 0.1, 0>, <-0, 0.1, 0>,
      <0.733333, 0.166667, 0>, <0.733333, 0.166667, 0>, <-3.2055e-08, 0.166667, 0.733333>, <-3.2055e-08, 0.166667, 0.733333>,
      <1.52184, 0.0130857, 0>, <1.52184, 0.0130857, 1.20521>, <1.20521, 0.0130857, 1.52184>, <-6.65217e-08, 0.0130857, 1.52184>,
      <2.2, 0.3, 0>, <2.2, 0.3, 1.20521>, <1.20521, 0.3, 2.2>, <-9.6165e-08, 0.3, 2.2>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0, 0.1, 0>, <-0, 0.1, 0>, <-0, 0.1, 0>, <-0, 0.1, 0>,
      <0.733333, 0.166667, 0>, <0.733333, 0.166667, 0>, <8.74491e-09, 0.166667, -0.733333>, <8.74491e-09, 0.166667, -0.733333>,
      <1.52184, 0.0130857, 0>, <1.52184, 0.0130857, -1.20521>, <1.20521, 0.0130857, -1.52184>, <1.81477e-08, 0.0130857, -1.52184>,
      <2.2, 0.3, 0>, <2.2, 0.3, -1.20521>, <1.20521, 0.3, -2.2>, <2.62347e-08, 0.3, -2.2>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.2, 0.3, 0>, <2.2, 0.3, 1.20521>, <1.20521, 0.3, 2.2>, <-9.6165e-08, 0.3, 2.2>,
      <2.50235, 0.427917, 0>, <2.50235, 0.427917, 1.20521>, <1.20521, 0.427917, 2.50235>, <-1.09381e-07, 0.427917, 2.50235>,
      <2.57575, 0.872602, 0>, <2.57575, 0.872602, 1.42434>, <1.42434, 0.872602, 2.57575>, <-1.26371e-07, 0.872602, 2.57575>,
      <2.6, 1.2, 0>, <2.6, 1.2, 1.42434>, <1.42434, 1.2, 2.6>, <-1.1365e-07, 1.2, 2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.2, 0.3, 0>, <2.2, 0.3, -1.20521>, <1.20521, 0.3, -2.2>, <2.62347e-08, 0.3, -2.2>,
      <2.50235, 0.427917, 0>, <2.50235, 0.427917, -1.20521>, <1.20521, 0.427917, -2.50235>, <2.98402e-08, 0.427917, -2.50235>,
      <2.57575, 0.872602, 0>, <2.57575, 0.872602, -1.42434>, <1.42434, 0.872602, -2.57575>, <1.69345e-08, 0.872602, -2.57575>,
      <2.6, 1.2, 0>, <2.6, 1.2, -1.42434>, <1.42434, 1.2, -2.6>, <3.10047e-08, 1.2, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 1.2, 0>, <2.6, 1.2, 1.42434>, <1.42434, 1.2, 2.6>, <-1.1365e-07, 1.2, 2.6>,
      <2.6446, 1.80204, 0>, <2.6446, 1.80204, 1.42434>, <1.42434, 1.80204, 2.6446>, <-9.02575e-08, 1.80204, 2.6446>,
      <2.43015, 2.39706, 0>, <2.43015, 2.39706, 1.31478>, <1.31478, 2.39706, 2.43015>, <-2.68374e-08, 2.39706, 2.43015>,
      <2.4, 3, 0>, <2.4, 3, 1.31478>, <1.31478, 3, 2.4>, <8.74228e-09, 3, 2.4>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 1.2, 0>, <2.6, 1.2, -1.42434>, <1.42434, 1.2, -2.6>, <3.10047e-08, 1.2, -2.6>,
      <2.6446, 1.80204, 0>, <2.6446, 1.80204, -1.42434>, <1.42434, 1.80204, -2.6446>, <5.68779e-08, 1.80204, -2.6446>,
      <2.43015, 2.39706, 0>, <2.43015, 2.39706, -1.31478>, <1.31478, 2.39706, -2.43015>, <1.08367e-07, 2.39706, -2.43015>,
      <2.4, 3, 0>, <2.4, 3, -1.31478>, <1.31478, 3, -2.4>, <1.42269e-07, 3, -2.4>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 3, 0>, <2.6, 3, 1.42434>, <1.42434, 3, 2.6>, <-0, 3, 2.6>,
      <2.61054, 2.96838, 0>, <2.61054, 2.96838, 1.42434>, <1.42434, 2.96838, 2.61054>, <-4.6076e-10, 2.96838, 2.61054>,
      <2.6, 2.93333, 0>, <2.6, 2.93333, 1.42434>, <1.42434, 2.93333, 2.6>, <-0, 2.93333, 2.6>,
      <2.6, 2.9, 0>, <2.6, 2.9, 1.42434>, <1.42434, 2.9, 2.6>, <-0, 2.9, 2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 3, 0>, <2.6, 3, -1.42434>, <1.42435, 3, -2.6>, <1.44654e-07, 3, -2.6>,
      <2.61054, 2.96838, 0>, <2.61054, 2.96838, -1.42434>, <1.42435, 2.96838, -2.61054>, <1.4478e-07, 2.96838, -2.61054>,
      <2.6, 2.93333, 0>, <2.6, 2.93333, -1.42434>, <1.42435, 2.93333, -2.6>, <1.44654e-07, 2.93333, -2.6>,
      <2.6, 2.9, 0>, <2.6, 2.9, -1.42434>, <1.42435, 2.9, -2.6>, <1.44654e-07, 2.9, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 2.9, 0>, <2.6, 2.9, 1.42434>, <1.42434, 2.9, 2.6>, <-0, 2.9, 2.6>,
      <2.6, 2.86667, 0>, <2.6, 2.86667, 1.42434>, <1.42434, 2.86667, 2.6>, <-0, 2.86667, 2.6>,
      <2.6, 2.83333, 0>, <2.6, 2.83333, 1.42434>, <1.42434, 2.83333, 2.6>, <-0, 2.83333, 2.6>,
      <2.6, 2.8, 0>, <2.6, 2.8, 1.42434>, <1.42434, 2.8, 2.6>, <-0, 2.8, 2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 2.9, 0>, <2.6, 2.9, -1.42434>, <1.42435, 2.9, -2.6>, <1.44654e-07, 2.9, -2.6>,
      <2.6, 2.86667, 0>, <2.6, 2.86667, -1.42434>, <1.42435, 2.86667, -2.6>, <1.44654e-07, 2.86667, -2.6>,
      <2.6, 2.83333, 0>, <2.6, 2.83333, -1.42434>, <1.42435, 2.83333, -2.6>, <1.44654e-07, 2.83333, -2.6>,
      <2.6, 2.8, 0>, <2.6, 2.8, -1.42434>, <1.42435, 2.8, -2.6>, <1.44654e-07, 2.8, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 2.73967, 0>, <2.6, 2.73967, 1.42434>, <1.42434, 2.73967, 2.6>, <-0, 2.73967, 2.6>,
      <2.6, 1.95978, 0>, <2.6, 1.95978, 1.42434>, <1.42434, 1.95978, 2.6>, <-3.69309e-08, 1.95978, 2.6>,
      <2.89058, 1.12373, 0>, <2.89058, 1.12373, 1.42434>, <1.42434, 1.12373, 2.89058>, <-9.63289e-08, 1.12373, 2.89058>,
      <2.6, 0.4, 0>, <2.6, 0.4, 1.42434>, <1.42434, 0.4, 2.6>, <-1.1365e-07, 0.4, 2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 2.73967, 0>, <2.6, 2.73967, -1.42434>, <1.42435, 2.73967, -2.6>, <1.44654e-07, 2.73967, -2.6>,
      <2.6, 1.95978, 0>, <2.6, 1.95978, -1.42434>, <1.42435, 1.95978, -2.6>, <1.07723e-07, 1.95978, -2.6>,
      <2.89058, 1.12373, 0>, <2.89058, 1.12373, -1.42434>, <1.42435, 1.12373, -2.89058>, <6.44925e-08, 1.12373, -2.89058>,
      <2.6, 0.4, 0>, <2.6, 0.4, -1.42434>, <1.42434, 0.4, -2.6>, <3.10047e-08, 0.4, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 0.4, 0>, <2.6, 0.4, 1.42434>, <1.42434, 0.4, 2.6>, <-1.1365e-07, 0.4, 2.6>,
      <2.45463, 0.0379372, 0>, <2.45463, 0.0379372, 1.42434>, <1.42434, 0.0379372, 2.45463>, <-1.22315e-07, 0.0379372, 2.45463>,
      <1.86014, 0.15006, 0>, <1.86014, 0.15006, 0.821738>, <0.821737, 0.15006, 1.86014>, <-8.13095e-08, 0.15006, 1.86014>,
      <1.5, 0, 0>, <1.5, 0, 0.821738>, <0.821737, 0, 1.5>, <-6.55671e-08, 0, 1.5>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 0.4, 0>, <2.6, 0.4, -1.42434>, <1.42434, 0.4, -2.6>, <3.10047e-08, 0.4, -2.6>,
      <2.45463, 0.0379372, 0>, <2.45463, 0.0379372, -1.42434>, <1.42434, 0.0379372, -2.45463>, <1.42517e-08, 0.0379372, -2.45463>,
      <1.86014, 0.15006, 0>, <1.86014, 0.15006, -0.821737>, <0.821737, 0.15006, -1.86014>, <2.2182e-08, 0.15006, -1.86014>,
      <1.5, 0, 0>, <1.5, 0, -0.821737>, <0.821737, 0, -1.5>, <1.78873e-08, 0, -1.5>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.5, 0, 0>, <1.5, 0, 0.821738>, <0.821737, 0, 1.5>, <-6.55671e-08, 0, 1.5>,
      <1.45649, -0.0181309, 0>, <1.45649, -0.0181309, 0.821738>, <0.821737, -0.0181309, 1.45649>, <-6.3665e-08, -0.0181309, 1.45649>,
      <1.44704, -0.0968643, 0>, <1.44704, -0.0968643, 0.766955>, <0.766955, -0.0968643, 1.44704>, <-6.32519e-08, -0.0968643, 1.44704>,
      <1.4, -0.1, 0>, <1.4, -0.1, 0.766955>, <0.766955, -0.1, 1.4>, <-6.11959e-08, -0.1, 1.4>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.5, 0, 0>, <1.5, 0, -0.821737>, <0.821737, 0, -1.5>, <1.78873e-08, 0, -1.5>,
      <1.45649, -0.0181309, 0>, <1.45649, -0.0181309, -0.821737>, <0.821737, -0.0181309, -1.45649>, <1.73684e-08, -0.0181309, -1.45649>,
      <1.44704, -0.0968643, 0>, <1.44704, -0.0968643, -0.766955>, <0.766955, -0.0968643, -1.44704>, <1.72557e-08, -0.0968643, -1.44704>,
      <1.4, -0.1, 0>, <1.4, -0.1, -0.766955>, <0.766955, -0.1, -1.4>, <1.66948e-08, -0.1, -1.4>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.4, -0.1, 0>, <1.4, -0.1, 0.766955>, <0.766955, -0.1, 1.4>, <-6.11959e-08, -0.1, 1.4>,
      <0.934367, -0.131042, 0>, <0.934367, -0.131042, 0.766955>, <0.766955, -0.131042, 0.934367>, <-4.08425e-08, -0.131042, 0.934367>,
      <0.466667, -0.1, 0>, <0.466667, -0.1, 0>, <-2.03986e-08, -0.1, 0.466667>, <-2.03986e-08, -0.1, 0.466667>,
      <-0, -0.1, 0>, <-0, -0.1, 0>, <-0, -0.1, 0>, <-0, -0.1, -0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.4, -0.1, 0>, <1.4, -0.1, -0.766955>, <0.766955, -0.1, -1.4>, <1.66948e-08, -0.1, -1.4>,
      <0.934367, -0.131042, 0>, <0.934367, -0.131042, -0.766955>, <0.766955, -0.131042, -0.934367>, <1.11422e-08, -0.131042, -0.934367>,
      <0.466667, -0.1, 0>, <0.466667, -0.1, 0>, <5.56494e-09, -0.1, -0.466667>, <5.56494e-09, -0.1, -0.466667>,
      <-0, -0.1, 0>, <-0, -0.1, 0>, <-0, -0.1, 0>, <-0, -0.1, 0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0, 0.1, 0>, <-0, 0.1, 0>, <-0, 0.1, 0>, <-0, 0.1, 0>,
      <-3.2055e-08, 0.166667, 0.733333>, <-3.2055e-08, 0.166667, 0.733333>, <-0.733333, 0.166667, -6.411e-08>, <-0.733333, 0.166667, -6.411e-08>,
      <-6.65217e-08, 0.0130857, 1.52184>, <-1.20522, 0.0130857, 1.52184>, <-1.52184, 0.0130857, 1.20521>, <-1.52184, 0.0130857, -1.33043e-07>,
      <-9.6165e-08, 0.3, 2.2>, <-1.20522, 0.3, 2.2>, <-2.2, 0.3, 1.20521>, <-2.2, 0.3, -1.9233e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-9.6165e-08, 0.3, 2.2>, <-1.20522, 0.3, 2.2>, <-2.2, 0.3, 1.20521>, <-2.2, 0.3, -1.9233e-07>,
      <-1.09381e-07, 0.427917, 2.50235>, <-1.20522, 0.427917, 2.50235>, <-2.50235, 0.427917, 1.20521>, <-2.50235, 0.427917, -2.18762e-07>,
      <-1.26371e-07, 0.872602, 2.57575>, <-1.42435, 0.872602, 2.57575>, <-2.57575, 0.872602, 1.42434>, <-2.57575, 0.872602, -2.25179e-07>,
      <-1.1365e-07, 1.2, 2.6>, <-1.42435, 1.2, 2.6>, <-2.6, 1.2, 1.42434>, <-2.6, 1.2, -2.27299e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.1365e-07, 1.2, 2.6>, <-1.42435, 1.2, 2.6>, <-2.6, 1.2, 1.42434>, <-2.6, 1.2, -2.27299e-07>,
      <-9.02575e-08, 1.80204, 2.6446>, <-1.42435, 1.80204, 2.6446>, <-2.6446, 1.80204, 1.42434>, <-2.6446, 1.80204, -2.31198e-07>,
      <-2.68374e-08, 2.39706, 2.43015>, <-1.31478, 2.39706, 2.43015>, <-2.43015, 2.39706, 1.31478>, <-2.43015, 2.39706, -2.1245e-07>,
      <8.74228e-09, 3, 2.4>, <-1.31478, 3, 2.4>, <-2.4, 3, 1.31478>, <-2.4, 3, -2.09815e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0, 3, 2.6>, <-1.42435, 3, 2.6>, <-2.6, 3, 1.42434>, <-2.6, 3, -2.27299e-07>,
      <-4.6076e-10, 2.96838, 2.61054>, <-1.42435, 2.96838, 2.61054>, <-2.61054, 2.96838, 1.42434>, <-2.61054, 2.96838, -2.28221e-07>,
      <-0, 2.93333, 2.6>, <-1.42435, 2.93333, 2.6>, <-2.6, 2.93333, 1.42434>, <-2.6, 2.93333, -2.27299e-07>,
      <-0, 2.9, 2.6>, <-1.42435, 2.9, 2.6>, <-2.6, 2.9, 1.42434>, <-2.6, 2.9, -2.27299e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0, 2.9, 2.6>, <-1.42435, 2.9, 2.6>, <-2.6, 2.9, 1.42434>, <-2.6, 2.9, -2.27299e-07>,
      <-0, 2.86667, 2.6>, <-1.42435, 2.86667, 2.6>, <-2.6, 2.86667, 1.42434>, <-2.6, 2.86667, -2.27299e-07>,
      <-0, 2.83333, 2.6>, <-1.42435, 2.83333, 2.6>, <-2.6, 2.83333, 1.42434>, <-2.6, 2.83333, -2.27299e-07>,
      <-0, 2.8, 2.6>, <-1.42435, 2.8, 2.6>, <-2.6, 2.8, 1.42434>, <-2.6, 2.8, -2.27299e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0, 2.73967, 2.6>, <-1.42435, 2.73967, 2.6>, <-2.6, 2.73967, 1.42434>, <-2.6, 2.73967, -2.27299e-07>,
      <-3.69309e-08, 1.95978, 2.6>, <-1.42435, 1.95978, 2.6>, <-2.6, 1.95978, 1.42434>, <-2.6, 1.95978, -2.27299e-07>,
      <-9.63289e-08, 1.12373, 2.89058>, <-1.42435, 1.12373, 2.89058>, <-2.89058, 1.12373, 1.42434>, <-2.89058, 1.12373, -2.52703e-07>,
      <-1.1365e-07, 0.4, 2.6>, <-1.42435, 0.4, 2.6>, <-2.6, 0.4, 1.42434>, <-2.6, 0.4, -2.27299e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.1365e-07, 0.4, 2.6>, <-1.42435, 0.4, 2.6>, <-2.6, 0.4, 1.42434>, <-2.6, 0.4, -2.27299e-07>,
      <-1.22315e-07, 0.0379372, 2.45463>, <-1.42435, 0.0379372, 2.45463>, <-2.45463, 0.0379372, 1.42434>, <-2.45463, 0.0379372, -2.1459e-07>,
      <-8.13095e-08, 0.15006, 1.86014>, <-0.821738, 0.15006, 1.86014>, <-1.86014, 0.15006, 0.821737>, <-1.86014, 0.15006, -1.62619e-07>,
      <-6.55671e-08, 0, 1.5>, <-0.821738, 0, 1.5>, <-1.5, 0, 0.821737>, <-1.5, 0, -1.31134e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-6.55671e-08, 0, 1.5>, <-0.821738, 0, 1.5>, <-1.5, 0, 0.821737>, <-1.5, 0, -1.31134e-07>,
      <-6.3665e-08, -0.0181309, 1.45649>, <-0.821738, -0.0181309, 1.45649>, <-1.45649, -0.0181309, 0.821737>, <-1.45649, -0.0181309, -1.2733e-07>,
      <-6.32519e-08, -0.0968643, 1.44704>, <-0.766955, -0.0968643, 1.44704>, <-1.44704, -0.0968643, 0.766955>, <-1.44704, -0.0968643, -1.26504e-07>,
      <-6.11959e-08, -0.1, 1.4>, <-0.766955, -0.1, 1.4>, <-1.4, -0.1, 0.766955>, <-1.4, -0.1, -1.22392e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-6.11959e-08, -0.1, 1.4>, <-0.766955, -0.1, 1.4>, <-1.4, -0.1, 0.766955>, <-1.4, -0.1, -1.22392e-07>,
      <-4.08425e-08, -0.131042, 0.934367>, <-0.766955, -0.131042, 0.934367>, <-0.934367, -0.131042, 0.766955>, <-0.934367, -0.131042, -8.16849e-08>,
      <-2.03986e-08, -0.1, 0.466667>, <-2.03986e-08, -0.1, 0.466667>, <-0.466667, -0.1, -4.07973e-08>, <-0.466667, -0.1, -4.07973e-08>,
      <-0, -0.1, -0>, <-0, -0.1, 0>, <-0, -0.1, 0>, <0, -0.1, 0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0, 0.1, 0>, <-0, 0.1, 0>, <-0, 0.1, 0>, <-0, 0.1, 0>,
      <-0.733333, 0.166667, -6.411e-08>, <-0.733333, 0.166667, -6.411e-08>, <8.74491e-09, 0.166667, -0.733333>, <8.74491e-09, 0.166667, -0.733333>,
      <-1.52184, 0.0130857, -1.33043e-07>, <-1.52184, 0.0130857, -1.20522>, <-1.20521, 0.0130857, -1.52184>, <1.81477e-08, 0.0130857, -1.52184>,
      <-2.2, 0.3, -1.9233e-07>, <-2.2, 0.3, -1.20522>, <-1.20521, 0.3, -2.2>, <2.62347e-08, 0.3, -2.2>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.2, 0.3, -1.9233e-07>, <-2.2, 0.3, -1.20522>, <-1.20521, 0.3, -2.2>, <2.62347e-08, 0.3, -2.2>,
      <-2.50235, 0.427917, -2.18762e-07>, <-2.50235, 0.427917, -1.20522>, <-1.20521, 0.427917, -2.50235>, <2.98402e-08, 0.427917, -2.50235>,
      <-2.57575, 0.872602, -2.25179e-07>, <-2.57575, 0.872602, -1.42435>, <-1.42434, 0.872602, -2.57575>, <1.69345e-08, 0.872602, -2.57575>,
      <-2.6, 1.2, -2.27299e-07>, <-2.6, 1.2, -1.42435>, <-1.42434, 1.2, -2.6>, <3.10047e-08, 1.2, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.6, 1.2, -2.27299e-07>, <-2.6, 1.2, -1.42435>, <-1.42434, 1.2, -2.6>, <3.10047e-08, 1.2, -2.6>,
      <-2.6446, 1.80204, -2.31198e-07>, <-2.6446, 1.80204, -1.42435>, <-1.42434, 1.80204, -2.6446>, <5.68779e-08, 1.80204, -2.6446>,
      <-2.43015, 2.39706, -2.1245e-07>, <-2.43015, 2.39706, -1.31478>, <-1.31478, 2.39706, -2.43015>, <1.08367e-07, 2.39706, -2.43015>,
      <-2.4, 3, -2.09815e-07>, <-2.4, 3, -1.31478>, <-1.31478, 3, -2.4>, <1.42269e-07, 3, -2.4>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.6, 3, -2.27299e-07>, <-2.6, 3, -1.42435>, <-1.42434, 3, -2.6>, <1.44654e-07, 3, -2.6>,
      <-2.61054, 2.96838, -2.28221e-07>, <-2.61054, 2.96838, -1.42435>, <-1.42434, 2.96838, -2.61054>, <1.4478e-07, 2.96838, -2.61054>,
      <-2.6, 2.93333, -2.27299e-07>, <-2.6, 2.93333, -1.42435>, <-1.42434, 2.93333, -2.6>, <1.44654e-07, 2.93333, -2.6>,
      <-2.6, 2.9, -2.27299e-07>, <-2.6, 2.9, -1.42435>, <-1.42434, 2.9, -2.6>, <1.44654e-07, 2.9, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.6, 2.9, -2.27299e-07>, <-2.6, 2.9, -1.42435>, <-1.42434, 2.9, -2.6>, <1.44654e-07, 2.9, -2.6>,
      <-2.6, 2.86667, -2.27299e-07>, <-2.6, 2.86667, -1.42435>, <-1.42434, 2.86667, -2.6>, <1.44654e-07, 2.86667, -2.6>,
      <-2.6, 2.83333, -2.27299e-07>, <-2.6, 2.83333, -1.42435>, <-1.42434, 2.83333, -2.6>, <1.44654e-07, 2.83333, -2.6>,
      <-2.6, 2.8, -2.27299e-07>, <-2.6, 2.8, -1.42435>, <-1.42434, 2.8, -2.6>, <1.44654e-07, 2.8, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.6, 2.73967, -2.27299e-07>, <-2.6, 2.73967, -1.42435>, <-1.42434, 2.73967, -2.6>, <1.44654e-07, 2.73967, -2.6>,
      <-2.6, 1.95978, -2.27299e-07>, <-2.6, 1.95978, -1.42435>, <-1.42434, 1.95978, -2.6>, <1.07723e-07, 1.95978, -2.6>,
      <-2.89058, 1.12373, -2.52703e-07>, <-2.89058, 1.12373, -1.42435>, <-1.42434, 1.12373, -2.89058>, <6.44925e-08, 1.12373, -2.89058>,
      <-2.6, 0.4, -2.27299e-07>, <-2.6, 0.4, -1.42435>, <-1.42434, 0.4, -2.6>, <3.10047e-08, 0.4, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.6, 0.4, -2.27299e-07>, <-2.6, 0.4, -1.42435>, <-1.42434, 0.4, -2.6>, <3.10047e-08, 0.4, -2.6>,
      <-2.45463, 0.0379372, -2.1459e-07>, <-2.45463, 0.0379372, -1.42435>, <-1.42434, 0.0379372, -2.45463>, <1.42517e-08, 0.0379372, -2.45463>,
      <-1.86014, 0.15006, -1.62619e-07>, <-1.86014, 0.15006, -0.821738>, <-0.821737, 0.15006, -1.86014>, <2.2182e-08, 0.15006, -1.86014>,
      <-1.5, 0, -1.31134e-07>, <-1.5, 0, -0.821738>, <-0.821737, 0, -1.5>, <1.78873e-08, 0, -1.5>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.5, 0, -1.31134e-07>, <-1.5, 0, -0.821738>, <-0.821737, 0, -1.5>, <1.78873e-08, 0, -1.5>,
      <-1.45649, -0.0181309, -1.2733e-07>, <-1.45649, -0.0181309, -0.821738>, <-0.821737, -0.0181309, -1.45649>, <1.73684e-08, -0.0181309, -1.45649>,
      <-1.44704, -0.0968643, -1.26504e-07>, <-1.44704, -0.0968643, -0.766955>, <-0.766955, -0.0968643, -1.44704>, <1.72557e-08, -0.0968643, -1.44704>,
      <-1.4, -0.1, -1.22392e-07>, <-1.4, -0.1, -0.766955>, <-0.766955, -0.1, -1.4>, <1.66948e-08, -0.1, -1.4>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.4, -0.1, -1.22392e-07>, <-1.4, -0.1, -0.766955>, <-0.766955, -0.1, -1.4>, <1.66948e-08, -0.1, -1.4>,
      <-0.934367, -0.131042, -8.16849e-08>, <-0.934367, -0.131042, -0.766955>, <-0.766955, -0.131042, -0.934367>, <1.11422e-08, -0.131042, -0.934367>,
      <-0.466667, -0.1, -4.07973e-08>, <-0.466667, -0.1, -4.07973e-08>, <5.56494e-09, -0.1, -0.466667>, <5.56494e-09, -0.1, -0.466667>,
      <0, -0.1, 0>, <-0, -0.1, 0>, <-0, -0.1, 0>, <-0, -0.1, 0>
   }
}

#declare TasseBordSup = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.4, 3, 0>, <2.4, 3, 1.31478>, <1.31478, 3, 2.4>, <8.74228e-09, 3, 2.4>,
      <2.39628, 3.07444, 0>, <2.39628, 3.07444, 1.31478>, <1.31478, 3.07444, 2.39628>, <1.31352e-08, 3.07444, 2.39628>,
      <2.42546, 3.2, 0>, <2.42546, 3.2, 1.36956>, <1.36956, 3.2, 2.42546>, <7.62921e-09, 3.2, 2.42546>,
      <2.5, 3.2, 0>, <2.5, 3.2, 1.36956>, <1.36956, 3.2, 2.5>, <4.37116e-09, 3.2, 2.5>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.4, 3, 0>, <2.4, 3, -1.31478>, <1.31478, 3, -2.4>, <1.42269e-07, 3, -2.4>,
      <2.39628, 3.07444, 0>, <2.39628, 3.07444, -1.31478>, <1.31478, 3.07444, -2.39628>, <1.46455e-07, 3.07444, -2.39628>,
      <2.42546, 3.2, 0>, <2.42546, 3.2, -1.36956>, <1.36956, 3.2, -2.42546>, <1.42573e-07, 3.2, -2.42546>,
      <2.5, 3.2, 0>, <2.5, 3.2, -1.36956>, <1.36956, 3.2, -2.5>, <1.43462e-07, 3.2, -2.5>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.5, 3.2, 0>, <2.5, 3.2, 1.36956>, <1.36956, 3.2, 2.5>, <4.37116e-09, 3.2, 2.5>,
      <2.57454, 3.2, 0>, <2.57454, 3.2, 1.36956>, <1.36956, 3.2, 2.57454>, <1.1131e-09, 3.2, 2.57454>,
      <2.57643, 3.07071, 0>, <2.57643, 3.07071, 1.42434>, <1.42434, 3.07071, 2.57643>, <1.03029e-09, 3.07071, 2.57643>,
      <2.6, 3, 0>, <2.6, 3, 1.42434>, <1.42434, 3, 2.6>, <-0, 3, 2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.5, 3.2, 0>, <2.5, 3.2, -1.36956>, <1.36956, 3.2, -2.5>, <1.43462e-07, 3.2, -2.5>,
      <2.57454, 3.2, 0>, <2.57454, 3.2, -1.36956>, <1.36956, 3.2, -2.57454>, <1.44351e-07, 3.2, -2.57454>,
      <2.57643, 3.07071, 0>, <2.57643, 3.07071, -1.42434>, <1.42435, 3.07071, -2.57643>, <1.44373e-07, 3.07071, -2.57643>,
      <2.6, 3, 0>, <2.6, 3, -1.42434>, <1.42435, 3, -2.6>, <1.44654e-07, 3, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <8.74228e-09, 3, 2.4>, <-1.31478, 3, 2.4>, <-2.4, 3, 1.31478>, <-2.4, 3, -2.09815e-07>,
      <1.31352e-08, 3.07444, 2.39628>, <-1.31478, 3.07444, 2.39628>, <-2.39628, 3.07444, 1.31478>, <-2.39628, 3.07444, -2.09489e-07>,
      <7.62921e-09, 3.2, 2.42546>, <-1.36956, 3.2, 2.42546>, <-2.42546, 3.2, 1.36956>, <-2.42546, 3.2, -2.12041e-07>,
      <4.37116e-09, 3.2, 2.5>, <-1.36956, 3.2, 2.5>, <-2.5, 3.2, 1.36956>, <-2.5, 3.2, -2.18557e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <4.37116e-09, 3.2, 2.5>, <-1.36956, 3.2, 2.5>, <-2.5, 3.2, 1.36956>, <-2.5, 3.2, -2.18557e-07>,
      <1.1131e-09, 3.2, 2.57454>, <-1.36956, 3.2, 2.57454>, <-2.57454, 3.2, 1.36956>, <-2.57454, 3.2, -2.25073e-07>,
      <1.03029e-09, 3.07071, 2.57643>, <-1.42435, 3.07071, 2.57643>, <-2.57643, 3.07071, 1.42434>, <-2.57643, 3.07071, -2.25239e-07>,
      <-0, 3, 2.6>, <-1.42435, 3, 2.6>, <-2.6, 3, 1.42434>, <-2.6, 3, -2.27299e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.4, 3, -2.09815e-07>, <-2.4, 3, -1.31478>, <-1.31478, 3, -2.4>, <1.42269e-07, 3, -2.4>,
      <-2.39628, 3.07444, -2.09489e-07>, <-2.39628, 3.07444, -1.31478>, <-1.31478, 3.07444, -2.39628>, <1.46455e-07, 3.07444, -2.39628>,
      <-2.42546, 3.2, -2.12041e-07>, <-2.42546, 3.2, -1.36956>, <-1.36956, 3.2, -2.42546>, <1.42573e-07, 3.2, -2.42546>,
      <-2.5, 3.2, -2.18557e-07>, <-2.5, 3.2, -1.36956>, <-1.36956, 3.2, -2.5>, <1.43462e-07, 3.2, -2.5>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.5, 3.2, -2.18557e-07>, <-2.5, 3.2, -1.36956>, <-1.36956, 3.2, -2.5>, <1.43462e-07, 3.2, -2.5>,
      <-2.57454, 3.2, -2.25073e-07>, <-2.57454, 3.2, -1.36956>, <-1.36956, 3.2, -2.57454>, <1.44351e-07, 3.2, -2.57454>,
      <-2.57643, 3.07071, -2.25239e-07>, <-2.57643, 3.07071, -1.42435>, <-1.42434, 3.07071, -2.57643>, <1.44373e-07, 3.07071, -2.57643>,
      <-2.6, 3, -2.27299e-07>, <-2.6, 3, -1.42435>, <-1.42434, 3, -2.6>, <1.44654e-07, 3, -2.6>
   }
}

#declare TasseFil = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 2.8, 0>, <2.6, 2.8, 1.42434>, <1.42434, 2.8, 2.6>, <-0, 2.8, 2.6>,
      <2.6, 2.77989, 0>, <2.6, 2.77989, 1.42434>, <1.42434, 2.77989, 2.6>, <-0, 2.77989, 2.6>,
      <2.6, 2.75978, 0>, <2.6, 2.75978, 1.42434>, <1.42434, 2.75978, 2.6>, <9.52295e-10, 2.75978, 2.6>,
      <2.6, 2.73967, 0>, <2.6, 2.73967, 1.42434>, <1.42434, 2.73967, 2.6>, <-0, 2.73967, 2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6, 2.8, 0>, <2.6, 2.8, -1.42434>, <1.42435, 2.8, -2.6>, <1.44654e-07, 2.8, -2.6>,
      <2.6, 2.77989, 0>, <2.6, 2.77989, -1.42434>, <1.42435, 2.77989, -2.6>, <1.44654e-07, 2.77989, -2.6>,
      <2.6, 2.75978, 0>, <2.6, 2.75978, -1.42434>, <1.42435, 2.75978, -2.6>, <1.45607e-07, 2.75978, -2.6>,
      <2.6, 2.73967, 0>, <2.6, 2.73967, -1.42434>, <1.42435, 2.73967, -2.6>, <1.44654e-07, 2.73967, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0, 2.8, 2.6>, <-1.42435, 2.8, 2.6>, <-2.6, 2.8, 1.42434>, <-2.6, 2.8, -2.27299e-07>,
      <-0, 2.77989, 2.6>, <-1.42435, 2.77989, 2.6>, <-2.6, 2.77989, 1.42434>, <-2.6, 2.77989, -2.27299e-07>,
      <9.52295e-10, 2.75978, 2.6>, <-1.42435, 2.75978, 2.6>, <-2.6, 2.75978, 1.42434>, <-2.6, 2.75978, -2.27299e-07>,
      <-0, 2.73967, 2.6>, <-1.42435, 2.73967, 2.6>, <-2.6, 2.73967, 1.42434>, <-2.6, 2.73967, -2.27299e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.6, 2.8, -2.27299e-07>, <-2.6, 2.8, -1.42435>, <-1.42434, 2.8, -2.6>, <1.44654e-07, 2.8, -2.6>,
      <-2.6, 2.77989, -2.27299e-07>, <-2.6, 2.77989, -1.42435>, <-1.42434, 2.77989, -2.6>, <1.44654e-07, 2.77989, -2.6>,
      <-2.6, 2.75978, -2.27299e-07>, <-2.6, 2.75978, -1.42435>, <-1.42434, 2.75978, -2.6>, <1.45607e-07, 2.75978, -2.6>,
      <-2.6, 2.73967, -2.27299e-07>, <-2.6, 2.73967, -1.42435>, <-1.42434, 2.73967, -2.6>, <1.44654e-07, 2.73967, -2.6>
   }
}

#declare RatBain = union {
   //*PMName Tasse
   //*PMRawBegin
   #include "tasserat.inc"
   //*PMRawEnd
   //*PMRawBegin
   #include "voilier.inc"
   object {
      //*PMName Bateau
      Bateau
      scale 0.12
      rotate <0, -63.7, 0>
      translate <-0.53333, 2.52, 0.63333>
   }
   //*PMRawEnd
   
   merge {
      //*PMName Tasse
      
      object {
         //*PMName Main
         TasseMain
         
         texture {
            Ceramique
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName BordSup
         TasseBordSup
         
         pigment {
            color rgb <0.337255, 0.545098, 0.898039>
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Fil
         TasseFil
         
         pigment {
            color rgb <0.243137, 0.388235, 0.643137>
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   object {
      //*PMName Anse
      TasseAnse5
      
      texture {
         Ceramique
      }
   }
   
   object {
      //*PMName AnseCasse
      TasseAnseCasse
      
      texture {
         pigment {
            color rgb <0.929412, 0.909804, 0.882353>
         }
         
         finish {
            crand 0.2
         }
      }
   }
   
   merge {
      sphere {
         <0, 0, 0>, 2.5
         scale <1, 0.05, 1>
         rotate <0, 0, 0>
         translate y*2.5
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 2.5
         scale 1
         rotate <0, 0, 0>
         translate y*2
      }
      
      material {
         interior {
            ior 1.5
         }
         
         texture {
            normal {
               bumps
               0.3
               scale 0.2
            }
            
            pigment {
               color rgbft <0.94118, 0.91373, 0.87059, 0.49, 0.5>
            }
            
            finish {
               phong 2
               phong_size 40
            }
         }
      }
      hollow
   }
   
   union {
      //*PMName Rat
      //*PMRawBegin
      object {
         //*PMName Rat
         TasseRat
         
          texture {
            PeauGrise
         }
      }
      //*PMRawEnd
      
      union {
         //*PMName Tete
         
         union {
            //*PMName Moustaches
            
            object {
               RRMoustaches
               scale 1
               rotate z*(-2.6)
               translate <-0.42389, 0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <0, 0, 0>
               translate <-0.42389, 0, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate z*2.3
               translate <-0.42389, -0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <-0, 180, 2.6>
               translate <0.42389, 0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate y*180
               translate <0.42389, 0, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <0, 180, -2.3>
               translate <0.42389, -0.15, -2.8691>
            }
            
            pigment {
               color rgbft <1, 1, 1, 0.2, 0.2>
            }
            translate z*0.4
         }
         
         union {
            //*PMName Yeux
            
            union {
               //*PMName Droit
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeil
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate <-0, 0, 0>
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-5)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.9, 1>
               rotate <0, 0, 0>
               translate x*(-0.42)
            }
            
            union {
               //*PMName Gauche
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeil
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate <-0, 0, 0>
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-5)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.9, 1>
               rotate <0, 0, 0>
               translate x*0.42
            }
            translate <0, 0.98, -0.3758>
         }
         //*PMRawBegin
         object {
            RTete
            
            texture {
               PeauGrise
            }
         }
         
         object {
            ROreille
            
            texture {
               PeauGrise
            }
         
         }
         //*PMRawEnd
         
         sphere {
            //*PMName Truffe
            <0, 0, -3.48>, 0.4
            
            texture {
               NoirOeil
            }
            scale <0.6, 0.5, 1>
            rotate <0, 0, 0>
            translate z*0.4
         }
         
         union {
            //*PMName Dents
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.11)
            }
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*0.11
            }
            translate <0, -0.67, -1.42>
            
            texture {
               BlancOeil
            }
         }
         scale 0.6
         rotate x*(-30)
         translate <0.312811, 5.53652, 0.630029>
      }
      rotate <-148.4, -17.8, -180>
      translate <0.409036, 0.441634, 1.13495>
   }
}

// Ptanque
#declare RainureBoule = torus {
   1.72, 0.03
   
   pigment {
      color rgb <0.776471, 0.776471, 0.776471>
   }
   translate y*1
}

#declare RatBoule = union {
   //*PMName Petanque
   //*PMRawBegin
   #include "petrat.inc"
   //*PMRawEnd
   
   union {
      //*PMName Boule
      
      union {
         //*PMName Boule
         
         difference {
            sphere {
               <0, 0, 0>, 2
            }
            
            object {
               RainureBoule
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               RainureBoule
               scale 1
               rotate z*180
               translate <0, 0, 0>
            }
            
            object {
               RainureBoule
               scale 1
               rotate z*90
               translate <0, 0, 0>
            }
            
            object {
               RainureBoule
               scale 1
               rotate z*(-90)
               translate <0, 0, 0>
            }
            
            object {
               RainureBoule
               scale 1
               rotate x*(-90)
               translate <0, 0, 0>
            }
            
            object {
               RainureBoule
               scale 1
               rotate x*90
               translate <0, 0, 0>
            }
            
            text {
               ttf "/home/tom/RayTrace/Fonts/Phosph13.ttf"
               "720"
               0.2, <0, 0>
               scale <0.6, 0.4, 0.6>
               rotate <0, 0, 0>
               translate <-0.279128, -0.135732, -2.08097>
            }
         }
         rotate <8.5, 18, 25.8>
         translate y*2
         
         texture {
            bumps
            turbulence <0.5, 0.1, 0.1>
            scale <0.5, 0.5, 0.2>
            
            texture_map {
               [ 0 pigment {
                  color rgb <0.776471, 0.776471, 0.776471>
               }
               
               finish {
                  metallic 1
                  specular 1.1
                  roughness 0.05
                  
                  reflection {
                     rgb <0.286275, 0.286275, 0.286275>, rgb <0.607843, 0.607843, 0.607843>
                     metallic 1
                  }
               }
               ]
               [ 0.999 pigment {
                  color rgb <0.462745, 0.207843, 0.0980392>
               }
               
               finish {
               }
               
               normal {
                  granite
                  0.3
                  noise_generator 3
               }
               ]
            }
         }
      }
      
      union {
         //*PMName Corde
         
         sphere_sweep {
            cubic_spline,
            15,
            <-5, 0, 0>,0.05
            <-5, 0, 0>,0.05
            <-1.9811, 0, -1.3421>,0.05
            <-0.709728, 0, -1.92503>,0.05
            <-0.00239312, 0, -2.02991>,0.05
            <0.784227, 0, -1.87143>,0.05
            <1.59669, 0, -1.2989>,0.05
            <2.06334, 0, -0.00147314>,0.05
            <1.62783, 0, 1.25951>,0.05
            <0.778169, 0, 1.89466>,0.05
            <-0.00824692, 0, 2.02474>,0.05
            <-0.816608, 0, 1.86126>,0.05
            <-1.9611, 0, 1.3056>,0.05
            <-5, 0, 0>,0.05
            <-5, 0, 0>,0.05
            rotate x*45
         }
         
         sphere_sweep {
            cubic_spline,
            17,
            <-5, 0, 0>,0.05
            <-5, 0, 0>,0.05
            <-1.9811, 0, -1.3421>,0.05
            <-0.70973, 0, -1.925>,0.05
            <-0.0023931, 0, -2.0299>,0.05
            <0.78423, 0, -1.8714>,0.05
            <1.5967, 0, -1.2989>,0.05
            <2.03209, -0.142393, -0.262266>,0.05
            <2.1568, -0.0019438, 0>,0.05
            <2.1107, 0.1375, 0.241663>,0.05
            <1.6278, 0, 1.2595>,0.05
            <0.77817, 0, 1.8947>,0.05
            <-0.0082469, 0, 2.0247>,0.05
            <-0.81661, 0, 1.8613>,0.05
            <-1.9611, 0, 1.3056>,0.05
            <-5, 0, 0>,0.05
            <-5, 0, 0>,0.05
            rotate x*(-45)
         }
         
         torus {
            0.1, 0.05
            rotate <45, 45, 12>
            translate x*(-5)
         }
         
         torus {
            0.1, 0.05
            rotate <-45, -45, -12>
            translate x*(-5)
         }
         
         cylinder {
            <-7, 0, 0>, <-5, 0, 0>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere_sweep {
            cubic_spline,
            6,
            <-7, 0, 0>,0.05
            <-7, 0, 0>,0.05
            <-7.26267, -0.191994, 0>,0.05
            <-7.69517, -1.58782, 0>,0.05
            <-7.74791, -2.43678, 0>,0.05
            <-7.20422, -3.46849, 0>,0.05
         }
         rotate z*(-26.6)
         translate y*2
      }
      translate y*(-0.2)
      
      pigment {
         color rgb <0.654902, 0.556863, 0.47451>
      }
   }
   
   union {
      //*PMName Rat
      
      union {
         //*PMName Tete
         
         union {
            //*PMName Tete
            //*PMRawBegin
            object {
               //*PMName Tete
               PetTete
            }
            
            object {
               //*PMName Oreilles
               PetOreilles
            }
            //*PMRawEnd
         }
         
         union {
            //*PMName Moustaches
            
            object {
               RRMoustaches
               scale 1
               rotate z*(-2.6)
               translate <-0.42389, 0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <0, 0, 0>
               translate <-0.42389, 0, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate z*2.3
               translate <-0.42389, -0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <-0, 180, 2.6>
               translate <0.42389, 0.15, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate y*180
               translate <0.42389, 0, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <0, 180, -2.3>
               translate <0.42389, -0.15, -2.8691>
            }
            
            pigment {
               color rgbft <1, 1, 1, 0.2, 0.2>
            }
            rotate x*(-16.6)
            translate <0, 0.649771, -0.22229>
         }
         
         union {
            //*PMName Yeux
            
            union {
               //*PMName Droit
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeil
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate y*20
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-27.7)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.8, 1>
               rotate <0, 0, 0>
               translate x*(-0.42)
            }
            
            union {
               //*PMName Gauche
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeil
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate y*20
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-27.7)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.8, 1>
               rotate <0, 0, 0>
               translate x*0.42
            }
            translate <0, 0.98, -0.3758>
         }
         
         sphere {
            //*PMName Truffe
            <0, 0, -3.48>, 0.4
            
            texture {
               NoirOeil
            }
            scale <0.6, 0.5, 1>
            rotate x*(-15.7)
            translate <0, 0.42764, -0.246217>
         }
         
         union {
            //*PMName Dents
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.11)
            }
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*0.11
            }
            translate <0, -0.7, -1.82>
            
            texture {
               BlancOeil
            }
         }
         scale 0.6
         rotate <-22, 50, 0>
         translate <0, 1.13058, -0.53684>
         //*PMRawBegin
         texture {
            PeauGrise
         }
         //*PMRawEnd
      }
      //*PMRawBegin
      object {
         //*PMName Corps
         PetCorps
         
         texture {
            PeauGrise
         }
      }
      
      object {
         //*PMName Queue
         PetQueue
         
         texture {
            PeauRose
         }
      }
      
      object {
         //*PMName Bras1
         PetBras1
         
         texture {
            PeauGrise
         }
      }
      
      object {
         //*PMName Bras2
         PetBras2
         
         texture {
            PeauGrise
         }
      }
      //*PMRawEnd
      scale 1
      rotate y*90
      translate <-7.11917, 4.75125, 0.303025>
   }
}

// Machine  laver
#declare WMachine = texture {
   pigment {
      agate
      agate_turb 0.1
      rotate <6, 5, 4>
      
      pigment_map {
         [ 0 color rgb <1, 0.992157, 0.968627>
         ]
         [ 0.9 color rgb <0.760784, 0.670588, 0.580392>
         ]
      }
   }
   
   finish {
      metallic 1
   }
}

#declare WMachineMetal = texture {
   normal {
      leopard
      2
      scale 0.03
   }
   
   pigment {
      color rgb <0.423529, 0.419608, 0.411765>
   }
   
   finish {
      diffuse 0.8
      metallic 1
      specular 1
      roughness 0.1
      
      reflection {
         rgb <0.0941176, 0.0941176, 0.0941176>
         fresnel
      }
   }
}

#declare WMachineB = texture {
   pigment {
      color rgb <1, 1, 1>
   }
   
   finish {
      metallic 1
   }
}

#declare Washing = union {
   //*PMName WashingMachine
   
   difference {
      //*PMName Corps
      
      superellipsoid {
         <0.05, 0.05>
         scale <2, 2.5, 2>
      }
      
      cylinder {
         //*PMName Trou
         <0, 0, -2.1>, <0, 0, -1>, 1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName Tambour
         <0, 0, -1.8>, <0, 0, 0>, 1.4
         
         texture {
            WMachineMetal
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName RainureH
         <-2.1, 0, 0>, <2.1, 0, 0>, 0.03
         scale 1
         rotate <0, 0, 0>
         translate <0, 1.6, -2>
      }
      
      cylinder {
         //*PMName RainureB
         <-2.1, 0, 0>, <2.1, 0, 0>, 0.03
         scale 1
         rotate <0, 0, 0>
         translate <0, 2.2, -2>
      }
      
      box {
         <-2.1, -2.5, -2.1>, <2.1, -1.9, -1.9>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, 0>, <0, 0, -0.1>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <1.7, 1.9, -1.92>
      }
      
      cylinder {
         <0, 0, 0>, <0, 0, -0.1>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <1.4, 1.9, -1.92>
      }
      
      cylinder {
         <-0.18, 0, 0>, <0.18, 0, 0>, 0.1
         scale <1, 1, 0.5>
         rotate x*20.2
         translate <-1.3, 1.83591, -2.03252>
      }
   }
   
   intersection {
      //*PMName Haut
      
      superellipsoid {
         <0.3, 0.05>
         scale <2, 0.15, 2>
         rotate y*90
      }
      
      box {
         <-2, 0, -2>, <2, 0.2, 2>
      }
      translate y*2.5
   }
   
   difference {
      //*PMName Joint
      
      cylinder {
         <0, 0, -2.1>, <0, 0, -2>, 1.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, -2.11>, <0, 0, -1.9>, 1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         WMachineB
      }
   }
   
   union {
      //*PMName Porte
      
      intersection {
         //*PMName Porte
         
         torus {
            1.1, 0.1
            rotate x*90
         }
         
         box {
            <-1.2, -1.2, -0.05>, <1.2, 1.2, 0.05>
         }
         translate z*(-2.05)
      }
      
      merge {
         //*PMName Hublot
         
         cone {
            <0, 0, -1.6>, 0.9,
            <0, 0, -2.09>, 1.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         intersection {
            sphere {
               <0, 0, 0>, 0.9
               scale <1, 1, 0.5>
               rotate <0, 0, 0>
               translate <0, 0, 0>
               hollow false
            }
            
            box {
               <-0.9, 0.9, -0.5>, <0.9, -0.9, 0>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            translate z*(-1.6)
            hollow false
         }
         
         material {
            interior {
               ior 1.2
            }
            
            texture {
               pigment {
                  color rgbft <0.8, 0.8, 0.8, 0.5, 0.5>
               }
               
               finish {
                  phong 0.5
                  phong_size 80
                  
                  reflection {
                     rgb <0.054902, 0.054902, 0.054902>
                  }
               }
            }
         }
         hollow
      }
      
      superellipsoid {
         //*PMName Poigne
         <0.4, 1>
         scale <0.05, 0.3, 0.06>
         rotate <0, 0, 0>
         translate <1.2, 0, -2.05>
         
         texture {
            WMachine
         }
      }
      translate <1.05, 0, 2>
      rotate <0, 0, 0>
      translate <-1.05, 0, -2.05>
   }
   
   union {
      //*PMName Programme
      
      difference {
         //*PMName Poudre
         
         cylinder {
            <-0.4, 0, 0>, <0.4, 0, 0>, 0.25
            scale <1, 1, 0.2>
            rotate <0, 0, 0>
            translate <-1.3, 1.9, -2>
         }
         
         cylinder {
            <-0.18, 0, 0>, <0.18, 0, 0>, 0.1
            scale <1, 1, 0.5>
            rotate x*20.2
            translate <-1.3, 1.83591, -2.03252>
         }
      }
      
      union {
         //*PMName Choix
         
         cone {
            <0, 0, 0>, 0.23,
            <0, 0, -0.1>, 0.21
         }
         
         superellipsoid {
            <0.1, 0.1>
            scale <0.05, 0.2, 0.05>
            rotate <0, 0, 0>
            translate z*(-0.1)
         }
         rotate z*20
         translate <-0.2, 1.9, -2>
      }
      
      union {
         //*PMName Choix
         
         cone {
            <0, 0, 0>, 0.23,
            <0, 0, -0.1>, 0.21
         }
         
         superellipsoid {
            <0.1, 0.1>
            scale <0.05, 0.2, 0.05>
            rotate <0, 0, 0>
            translate z*(-0.1)
         }
         rotate z*(-50)
         translate <0.5, 1.9, -2>
      }
      
      sphere {
         <0, 0, 0>, 0.09
         scale <1, 1, 0.4>
         rotate <0, 0, 0>
         translate <1.7, 1.9, -2>
      }
      
      sphere {
         <0, 0, 0>, 0.09
         scale <1, 1, 0.4>
         rotate <0, 0, 0>
         translate <1.4, 1.9, -2>
      }
   }
   
   texture {
      WMachine
   }
   scale 1
   rotate <0, 0, 0>
   translate y*2.5
}

// Pneu
#declare TexGomme = texture {
   pigment {
      color rgb <0.156863, 0.156863, 0.156863>
   }
   
   normal {
      crackle
      0.5
      turbulence <0.5, 0.5, 0.5>
   }
}

#declare TexRain = texture {
   pigment {
      color rgb <0.188235, 0.188235, 0.188235>
   }
   
   normal {
      leopard
      
      normal_map {
         [ 0 bump_map {
            png
            "/home/tom/RayTrace/Unplugged/textures/pneu.png"
            map_type 2
         }
         scale 0.2
         rotate <0, 0, 0>
         bump_size 1
         ]
         [ 0.5 bump_map {
            png
            "/home/tom/RayTrace/Unplugged/textures/pneu.png"
            map_type 2
         }
         scale 0.2
         rotate <0, 0, 0>
         bump_size 0.2
         ]
      }
   }
}

#declare Rainure = box {
   <2.04993, -0.0711273, -0.1>, <2.61298, 0.0848216, 0.1>
   scale 1
   rotate z*(-22.1)
   translate y*1.48188
}

#declare Rainures3 = union {
   //*PMName Ranure3
   
   object {
      Rainure
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Rainure
      scale 1
      rotate y*10
      translate <0, 0, 0>
   }
   
   object {
      Rainure
      scale 1
      rotate y*20
      translate <0, 0, 0>
   }
}

#declare Rainures9 = union {
   //*PMName Rainures
   
   object {
      Rainures3
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Rainures3
      scale 1
      rotate y*30
      translate <0, 0, 0>
   }
   
   object {
      Rainures3
      scale 1
      rotate y*60
      translate <0, 0, 0>
   }
}

#declare Rainures360 = union {
   //*PMName Rainures
   
   object {
      Rainures9
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Rainures9
      scale 1
      rotate y*90
      translate <0, 0, 0>
   }
   
   object {
      Rainures9
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
   
   object {
      Rainures9
      scale 1
      rotate y*(-90)
      translate <0, 0, 0>
   }
}

#declare Pneumatique = union {
   difference {
      //*PMName Principal
      
      torus {
         1.9, 0.6
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      difference {
         cylinder {
            <0, 0.51, 0>, <0, -0.51, 0>, 2.51
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0.511, 0>, <0, -0.511, 0>, 2.3
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      cylinder {
         <0, 0.51, 0>, <0, -0.51, 0>, 1.55
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      torus {
         1.8, 0.5
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   difference {
      //*PMName Gomme
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 2.32
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.51, 0>, <0, -0.51, 0>, 2.2
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         //*PMName Rainures
         
         object {
            Rainures360
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Rainures360
            scale 1
            rotate z*180
            translate <0, 0, 0>
         }
      }
      
      texture {
         TexRain
      }
   }
   
   difference {
      //*PMName Bande
      
      cylinder {
         <0, 0.52, 0>, <0, -0.52, 0>, 1.55
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.6, 0>, <0, -0.6, 0>, 1.52
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.48, 0>, <0, -0.48, 0>, 1.56
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   texture {
      TexGomme
   }
   translate y*0.6
}

#declare Tas1 = union {
   //*PMName Tas
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-0.858784, 3.28405, -1.466>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0.00825075, 0.0166006, -4.6664>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0.0160672, 0.0788028, -9.39501>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.34158, 1.08734, -3.78099>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.33029, 1.26614, -8.66179>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <22.1, 5, -12.1>
      translate <-0.202502, 1.85278, -0.998733>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.33518, 2.23928, -5.09138>
   }
   
   object {
      Pneumatique
      scale 1
      rotate x*(-4.1)
      translate <-0.269938, 2.24218, -10.1497>
   }
   scale 1
   rotate y*89.6
   translate <5.24401, 0, -0.284334>
}

#declare Tas2 = union {
   //*PMName Tas
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <1.6054, 0, 0.369991>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0.00825075, 0.0166006, -4.6664>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0.0160672, 0.0788028, -9.39501>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.34158, 1.08734, -3.78099>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.33029, 1.26614, -8.66179>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <22.1, 5, -12.1>
      translate <-0.202502, 1.85278, -0.998733>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.33518, 2.23928, -5.09138>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <-23.1, 0, 0.2>
      translate <-1.35212, 3.04791, -7.51721>
   }
   scale 1
   rotate y*89.6
   translate <7.60103, -0.142903, 4.62892>
}

#declare Tas3 = union {
   //*PMName Tas
   
   object {
      Pneumatique
      scale 1
      rotate <36, -3.7, 11.5>
      translate <-2.57702, -1.49285, 0.555928>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0.00825075, 0.0166006, -4.6664>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0.0160672, 0.0788028, -9.39501>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.34158, 1.08734, -3.78099>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.33029, 1.26614, -8.66179>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <24.1, 5.5, -11.2>
      translate <-0.202502, 1.85278, -0.998733>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-0.9, -0.3, 0>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.33518, 2.23928, -5.09138>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <-23.1, 0, 0.2>
      translate <-1.35212, 3.04791, -7.51721>
   }
   scale 1
   rotate <-180, 71.3, -180>
   translate <6.2811, 3.85838, 1.40855>
}

#declare Tas4 = union {
   //*PMName Tas
   
   object {
      Pneumatique
      scale 1
      rotate <36, -3.7, 11.5>
      translate <-2.57702, -1.49285, 0.555928>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0.00825075, 0.0166006, -4.6664>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0.0160672, 0.0788028, -9.39501>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.34158, 1.08734, -3.78099>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.33029, 1.26614, -8.66179>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <22.1, 5, -12.1>
      translate <-0.202502, 1.85278, -0.998733>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <0, 0, 0>
      translate <-1.33518, 2.23928, -5.09138>
   }
   
   object {
      Pneumatique
      scale 1
      rotate <-23.1, 0, 0.2>
      translate <-1.35212, 3.04791, -7.51721>
   }
   scale 1
   rotate y*71.9
   translate <5.44412, 2.17892, 7.39032>
}

#declare TasPneu = union {
   //*PMName TasPneu
   //*PMRawBegin
   object {
      //*PMName Tas1
      Tas1
   }
   
   object {
      //*PMName Tas2
      Tas2
   }
   
   object {
      //*PMName Tas3
      Tas3
   }
   
   object {
      //*PMName Tas4
      Tas4
   }
   //*PMRawEnd
}

// Boites
#declare Rouille = texture {
   leopard
   turbulence <1, 1, 1>
   scale 1
   
   texture_map {
      [ 0 normal {
         bumps
         0.1
         turbulence <0.5, 0.5, 0.5>
      }
      
      pigment {
         color rgb <0.564706, 0.564706, 0.564706>
      }
      
      finish {
         metallic 1.5
         specular 1.5
         roughness 0.08
         
         reflection {
            rgb <0.0392157, 0.0392157, 0.0392157>, rgb <0.117647, 0.117647, 0.117647>
            metallic 1.2
         }
      }
      ]
      [ 0.5 pigment {
         crackle
         turbulence <1, 1, 2>
         
         color_map {
            [ 0 color rgb <0.486275, 0.258824, 0.172549>
            ]
            [ 0.33 color rgb <0.572549, 0.34902, 0.254902>
            ]
            [ 0.66 color rgb <0.619608, 0.368627, 0.290196>
            ]
         }
         scale 0.01
      }
      
      finish {
         crand 0.2
      }
      ]
   }
   translate <1, 0.5, 0.6>
}

// Arbre
#declare Arbre = union {
   //*PMRawBegin
   #include "linden.inc"
    
   //*PMRawEnd
   //*PMRawBegin
   object {
      TREE
   }
   //*PMRawEnd
   scale 4
   translate <0, 0, 0>
}

// Tl
#declare TubeGris = texture {
   pigment {
      color rgb <0.14902, 0.14902, 0.14902>
   }
   
   finish {
      specular 0.2
      roughness 0.001
      
      reflection {
         rgb <0.0823529, 0.0823529, 0.0823529>
      }
   }
}

#declare MetalGris = texture {
   pigment {
      color rgb <0.709804, 0.709804, 0.709804>
   }
   
   finish {
      metallic 1
      specular 0.1
      roughness 0.5
   }
}

#declare Televison = union {
   //*PMName Television
   
   difference {
      //*PMName Cadre
      
      superellipsoid {
         <0.05, 0.1>
         scale <2.8, 1.5, 0.7>
         translate z*0.3
         hollow false
      }
      
      union {
         //*PMName TrouEcran
         
         box {
            <-0.5, -0.9, -0.5>, <0.5, 0.51, 0.5>
            
            pigment {
               color rgb <0, 0, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate x*1
         }
         
         prism {
            linear_spline
            conic_sweep
            1, 1.1,
            5,
            <0.5, 0.5>, <0.5, -0.5>, <-0.5, -0.5>, <-0.5, 0.5>, <0.5, 0.5>
            scale 1
            rotate <0, 0, 0>
            translate <1, -0.5, 0>
         }
         rotate x*(-90)
         scale <3.6, 2.4, 1.1>
         translate <-3.6, 0, 0.25>
      }
      
      union {
         //*PMName HPG
         
         difference {
            //*PMName HP
            
            union {
               cylinder {
                  <0, 0, 0>, <0, 0, -0.42>, 0.25
                  scale 1
                  rotate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, 0, -0.42>, 0.25
                  scale 1
                  rotate <0, 0, 0>
                  translate y*(-0.7)
               }
               
               cylinder {
                  <0, 0, 0>, <0, 0, -0.42>, 0.25
                  scale 1
                  rotate <0, 0, 0>
                  translate y*0.7
               }
               
               pigment {
                  color rgb <0, 0, 0>
               }
               translate x*(-2.3)
            }
            
            union {
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*0.02
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*0.1
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*0.18
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*0.26
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*(-0.06)
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*(-0.14)
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*(-0.22)
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*(-0.3)
               }
               scale <1, 1.1, 1>
               translate <-2.26, 0, -0.4>
               
               texture {
                  MetalGris
               }
            }
         }
         
         union {
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*0.02
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*0.1
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*0.18
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*0.26
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*(-0.06)
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*(-0.14)
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*(-0.22)
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*(-0.3)
            }
            scale <1, 1.1, 1>
            translate <-2.3, 0, -0.4>
            
            texture {
               MetalGris
            }
         }
         translate x*(-0.03)
      }
      
      union {
         //*PMName HPD
         
         difference {
            //*PMName HP
            
            union {
               cylinder {
                  <0, 0, 0>, <0, 0, -0.42>, 0.25
                  scale 1
                  rotate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, 0, -0.42>, 0.25
                  scale 1
                  rotate <0, 0, 0>
                  translate y*(-0.7)
               }
               
               cylinder {
                  <0, 0, 0>, <0, 0, -0.42>, 0.25
                  scale 1
                  rotate <0, 0, 0>
                  translate y*0.7
               }
               
               pigment {
                  color rgb <0, 0, 0>
               }
               translate x*2.3
            }
            
            union {
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*0.02
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*0.1
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*0.18
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*0.26
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*(-0.06)
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*(-0.14)
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*(-0.22)
               }
               
               box {
                  <0.02, 1, 0.03>, <-0.02, -1, -0.04>
                  translate x*(-0.3)
               }
               scale <1, 1.1, 1>
               translate <2.26, 0, -0.4>
               
               texture {
                  MetalGris
               }
            }
         }
         
         union {
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*0.02
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*0.1
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*0.18
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*0.26
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*(-0.06)
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*(-0.14)
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*(-0.22)
            }
            
            box {
               <0.02, 1, 0.03>, <-0.02, -1, -0.04>
               translate x*(-0.3)
            }
            scale <1, 1.1, 1>
            translate <2.3, 0, -0.4>
            
            texture {
               MetalGris
            }
         }
         translate x*0.03
      }
      
      texture {
         MetalGris
      }
   }
   
   difference {
      //*PMName Tube
      
      superellipsoid {
         <0.1, 0.15>
         scale <2, 1.3, 0.2>
         hollow false
      }
      
      height_field {
         png "/home/tom/RayTrace/Unplugged/textures/tele.png"
         scale <2.5, 0.5, 2.5>
         rotate <-90, -0, 17.6>
         translate <-0.807906, -1.56659, 0.249562>
      }
      
      box {
         <-2.1, -1.4, 0.3>, <2.1, 1.4, -0.1>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      translate z*(-0.12)
      
      texture {
         TubeGris
      }
   }
   
   box {
      <-1.8, -1.2, 0.7>, <1.8, 1.2, 0.8>
      
      pigment {
         color rgb <0, 0, 0>
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   translate y*1.5
}

// Radio
#declare Fumee = material {
   interior {
      media {
         density {
            agate
            agate_turb 1
            turbulence <0, 1, 0>
            lambda 5
            
            density_map {
               [ 0 color rgb <0.870588, 0.870588, 0.870588>
               ]
               [ 0.5 color rgb <0, 0, 0>
               ]
            }
         }
         intervals 10
         samples 1,10
         confidence 0.5
         variance 0.0078125
         absorption rgb <0.290196, 0.290196, 0.290196>
         
         scattering {
            5, rgb <0.635294, 0.635294, 0.635294>
            extinction 0.4
         }
      }
   }
   
   texture {
      pigment {
         color rgbt <0.79608, 0.79608, 0.79608, 1>
      }
   }
}

#declare BlancOeilRouge = texture {
   pigment {
      wrinkles
      turbulence <0.1, 0.1, 0.1>
      
      color_map {
         [ 0 color rgb <1, 1, 1>
         ]
         [ 0.495 color rgb <1, 1, 1>
         ]
         [ 0.99 color rgb <0.85098, 0.101961, 0.117647>
         ]
      }
      scale 0.1
   }
   
   finish {
      phong 10
      phong_size 30
   }
}

#declare ConeHP = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-3.93482, 0, -0.9797>, <-3.69873, 0, -0.520613>, <-3.58519, 0, 0.0262447>, <-3.22655, 0, 0.397561>,
      <-3.93482, 2.15559, -0.9797>, <-3.69873, 2.15559, -0.520613>, <-3.58519, 1.76759, 0.0262447>, <-3.22655, 1.76759, 0.397561>,
      <-2.15559, 3.93482, -0.9797>, <-2.15559, 3.69873, -0.520613>, <-1.76759, 3.58519, 0.0262447>, <-1.76759, 3.22655, 0.397561>,
      <-2.40938e-16, 3.93482, -0.9797>, <-2.26482e-16, 3.69873, -0.520613>, <-2.1953e-16, 3.58519, 0.0262447>, <-1.97569e-16, 3.22655, 0.397561>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-3.93482, 0, -0.9797>, <-3.69873, 0, -0.520613>, <-3.58519, 0, 0.0262447>, <-3.22655, 0, 0.397561>,
      <-3.93482, -2.15559, -0.9797>, <-3.69873, -2.15559, -0.520613>, <-3.58519, -1.76759, 0.0262447>, <-3.22655, -1.76759, 0.397561>,
      <-2.15559, -3.93482, -0.9797>, <-2.15559, -3.69873, -0.520613>, <-1.76759, -3.58519, 0.0262447>, <-1.76759, -3.22655, 0.397561>,
      <7.22815e-16, -3.93482, -0.9797>, <6.79446e-16, -3.69873, -0.520613>, <6.58589e-16, -3.58519, 0.0262447>, <5.92708e-16, -3.22655, 0.397561>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.40938e-16, 3.93482, -0.9797>, <-2.26482e-16, 3.69873, -0.520613>, <-2.1953e-16, 3.58519, 0.0262447>, <-1.97569e-16, 3.22655, 0.397561>,
      <2.15559, 3.93482, -0.9797>, <2.15559, 3.69873, -0.520613>, <1.76759, 3.58519, 0.0262447>, <1.76759, 3.22655, 0.397561>,
      <3.93482, 2.15559, -0.9797>, <3.69873, 2.15559, -0.520613>, <3.58519, 1.76759, 0.0262447>, <3.22655, 1.76759, 0.397561>,
      <3.93482, 4.81876e-16, -0.9797>, <3.69873, 4.52964e-16, -0.520613>, <3.58519, 4.3906e-16, 0.0262447>, <3.22655, 3.95139e-16, 0.397561>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.93482, 4.81876e-16, -0.9797>, <3.69873, 4.52964e-16, -0.520613>, <3.58519, 4.3906e-16, 0.0262447>, <3.22655, 3.95139e-16, 0.397561>,
      <3.93482, -2.15559, -0.9797>, <3.69873, -2.15559, -0.520613>, <3.58519, -1.76759, 0.0262447>, <3.22655, -1.76759, 0.397561>,
      <2.15559, -3.93482, -0.9797>, <2.15559, -3.69873, -0.520613>, <1.76759, -3.58519, 0.0262447>, <1.76759, -3.22655, 0.397561>,
      <7.22815e-16, -3.93482, -0.9797>, <6.79446e-16, -3.69873, -0.520613>, <6.58589e-16, -3.58519, 0.0262447>, <5.92708e-16, -3.22655, 0.397561>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-3.22655, 0, 0.397561>, <-2.48709, 0, 1.16316>, <-1.5477, 0, 1.70645>, <-0.708268, 0, 2.36089>,
      <-3.22655, 1.76759, 0.397561>, <-2.48709, 1.76759, 1.16316>, <-1.5477, 0.388007, 1.70645>, <-0.708268, 0.388007, 2.36089>,
      <-1.76759, 3.22655, 0.397561>, <-1.76759, 2.48709, 1.16316>, <-0.388007, 1.5477, 1.70645>, <-0.388007, 0.708268, 2.36089>,
      <-1.97569e-16, 3.22655, 0.397561>, <-1.52291e-16, 2.48709, 1.16316>, <-9.4769e-17, 1.5477, 1.70645>, <-4.33689e-17, 0.708268, 2.36089>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-3.22655, 0, 0.397561>, <-2.48709, 0, 1.16316>, <-1.5477, 0, 1.70645>, <-0.708268, 0, 2.36089>,
      <-3.22655, -1.76759, 0.397561>, <-2.48709, -1.76759, 1.16316>, <-1.5477, -0.388007, 1.70645>, <-0.708268, -0.388007, 2.36089>,
      <-1.76759, -3.22655, 0.397561>, <-1.76759, -2.48709, 1.16316>, <-0.388007, -1.5477, 1.70645>, <-0.388007, -0.708268, 2.36089>,
      <5.92708e-16, -3.22655, 0.397561>, <4.56872e-16, -2.48709, 1.16316>, <2.84307e-16, -1.5477, 1.70645>, <1.30107e-16, -0.708268, 2.36089>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.97569e-16, 3.22655, 0.397561>, <-1.52291e-16, 2.48709, 1.16316>, <-9.4769e-17, 1.5477, 1.70645>, <-4.33689e-17, 0.708268, 2.36089>,
      <1.76759, 3.22655, 0.397561>, <1.76759, 2.48709, 1.16316>, <0.388007, 1.5477, 1.70645>, <0.388007, 0.708268, 2.36089>,
      <3.22655, 1.76759, 0.397561>, <2.48709, 1.76759, 1.16316>, <1.5477, 0.388007, 1.70645>, <0.708268, 0.388007, 2.36089>,
      <3.22655, 3.95139e-16, 0.397561>, <2.48709, 3.04581e-16, 1.16316>, <1.5477, 1.89538e-16, 1.70645>, <0.708268, 8.67378e-17, 2.36089>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.22655, 3.95139e-16, 0.397561>, <2.48709, 3.04581e-16, 1.16316>, <1.5477, 1.89538e-16, 1.70645>, <0.708268, 8.67378e-17, 2.36089>,
      <3.22655, -1.76759, 0.397561>, <2.48709, -1.76759, 1.16316>, <1.5477, -0.388007, 1.70645>, <0.708268, -0.388007, 2.36089>,
      <1.76759, -3.22655, 0.397561>, <1.76759, -2.48709, 1.16316>, <0.388007, -1.5477, 1.70645>, <0.388007, -0.708268, 2.36089>,
      <5.92708e-16, -3.22655, 0.397561>, <4.56872e-16, -2.48709, 1.16316>, <2.84307e-16, -1.5477, 1.70645>, <1.30107e-16, -0.708268, 2.36089>
   }
}

#declare RedPlast = texture {
   agate
   agate_turb 0.5
   
   texture_map {
      [ 0 pigment {
         color rgb <0.2, 0.105882, 0.141176>
      }
      
      finish {
         phong 0.5
         phong_size 40
      }
      ]
      [ 0.8 pigment {
         color rgb <0.2, 0.105882, 0.141176>
      }
      
      finish {
      }
      ]
   }
}

#declare antenne = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.05827, 29.0549, 0.377201>, <-0.965979, 28.8321, 0.377201>, <-0.873687, 28.6093, 0.377201>, <-0.781395, 28.3865, 0.377201>,
      <-1.05827, 29.0549, 0.530592>, <-0.965979, 28.8321, 0.530592>, <-0.873687, 28.6093, 0.530591>, <-0.781395, 28.3865, 0.530591>,
      <-0.9413, 29.1034, 0.657201>, <-0.849009, 28.8805, 0.657201>, <-0.756716, 28.6577, 0.657201>, <-0.664425, 28.4349, 0.657201>,
      <-0.799586, 29.1621, 0.657201>, <-0.707294, 28.9392, 0.657201>, <-0.615002, 28.7164, 0.657201>, <-0.522711, 28.4936, 0.657201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.05827, 29.0549, 0.377201>, <-0.965979, 28.8321, 0.377201>, <-0.873687, 28.6093, 0.377201>, <-0.781395, 28.3865, 0.377201>,
      <-1.05827, 29.0549, 0.22381>, <-0.965979, 28.8321, 0.22381>, <-0.873687, 28.6093, 0.22381>, <-0.781395, 28.3865, 0.22381>,
      <-0.9413, 29.1034, 0.0972008>, <-0.849009, 28.8805, 0.0972008>, <-0.756716, 28.6577, 0.0972008>, <-0.664425, 28.4349, 0.0972008>,
      <-0.799586, 29.1621, 0.0972008>, <-0.707294, 28.9392, 0.0972008>, <-0.615002, 28.7164, 0.0972008>, <-0.522711, 28.4936, 0.0972008>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.799586, 29.1621, 0.657201>, <-0.707294, 28.9392, 0.657201>, <-0.615002, 28.7164, 0.657201>, <-0.522711, 28.4936, 0.657201>,
      <-0.657872, 29.2208, 0.657201>, <-0.56558, 28.9979, 0.657201>, <-0.473287, 28.7751, 0.657201>, <-0.380996, 28.5523, 0.657201>,
      <-0.540902, 29.2692, 0.530591>, <-0.448609, 29.0464, 0.530591>, <-0.356316, 28.8236, 0.530592>, <-0.264024, 28.6008, 0.530592>,
      <-0.540902, 29.2692, 0.377201>, <-0.448609, 29.0464, 0.377201>, <-0.356316, 28.8236, 0.377201>, <-0.264024, 28.6008, 0.377201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.540902, 29.2692, 0.377201>, <-0.448609, 29.0464, 0.377201>, <-0.356316, 28.8236, 0.377201>, <-0.264024, 28.6008, 0.377201>,
      <-0.540902, 29.2692, 0.22381>, <-0.448609, 29.0464, 0.22381>, <-0.356316, 28.8236, 0.223809>, <-0.264024, 28.6008, 0.223809>,
      <-0.657872, 29.2208, 0.0972008>, <-0.56558, 28.9979, 0.0972008>, <-0.473287, 28.7751, 0.0972008>, <-0.380996, 28.5523, 0.0972008>,
      <-0.799586, 29.1621, 0.0972008>, <-0.707294, 28.9392, 0.0972008>, <-0.615002, 28.7164, 0.0972008>, <-0.522711, 28.4936, 0.0972008>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.707486, 28.4171, 0.377201>, <0.197342, 26.3581, 0.377201>, <1.12387, 24.3086, 0.377201>, <2.007, 22.2402, 0.377201>,
      <-0.707486, 28.4171, 0.486765>, <0.197342, 26.3581, 0.486765>, <1.12387, 24.3086, 0.486766>, <2.007, 22.2402, 0.486766>,
      <-0.623935, 28.4517, 0.577201>, <0.284259, 26.3822, 0.577201>, <1.20857, 24.3394, 0.577201>, <2.09511, 22.2605, 0.577201>,
      <-0.522711, 28.4936, 0.577201>, <0.385483, 26.4241, 0.577201>, <1.31533, 24.364, 0.577201>, <2.20187, 22.2852, 0.577201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.707486, 28.4171, 0.377201>, <0.197342, 26.3581, 0.377201>, <1.12387, 24.3086, 0.377201>, <2.007, 22.2402, 0.377201>,
      <-0.707486, 28.4171, 0.267636>, <0.197342, 26.3581, 0.267636>, <1.12387, 24.3086, 0.267636>, <2.007, 22.2402, 0.267636>,
      <-0.623935, 28.4517, 0.177201>, <0.284259, 26.3822, 0.177201>, <1.20857, 24.3394, 0.177201>, <2.09511, 22.2605, 0.177201>,
      <-0.522711, 28.4936, 0.177201>, <0.385483, 26.4241, 0.177201>, <1.31533, 24.364, 0.177201>, <2.20187, 22.2852, 0.177201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.522711, 28.4936, 0.577201>, <0.385483, 26.4241, 0.577201>, <1.31533, 24.364, 0.577201>, <2.20187, 22.2852, 0.577201>,
      <-0.421486, 28.5355, 0.577201>, <0.486708, 26.4661, 0.577201>, <1.42209, 24.3887, 0.577201>, <2.30863, 22.3098, 0.577201>,
      <-0.337935, 28.5702, 0.486766>, <0.573625, 26.4902, 0.486766>, <1.50679, 24.4195, 0.486766>, <2.39674, 22.3302, 0.486766>,
      <-0.337935, 28.5702, 0.377201>, <0.573625, 26.4902, 0.377201>, <1.50679, 24.4195, 0.377201>, <2.39674, 22.3302, 0.377201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.337935, 28.5702, 0.377201>, <0.573625, 26.4902, 0.377201>, <1.50679, 24.4195, 0.377201>, <2.39674, 22.3302, 0.377201>,
      <-0.337935, 28.5702, 0.267636>, <0.573625, 26.4902, 0.267636>, <1.50679, 24.4195, 0.267636>, <2.39674, 22.3302, 0.267636>,
      <-0.421486, 28.5355, 0.177201>, <0.486708, 26.4661, 0.177201>, <1.42209, 24.3887, 0.177201>, <2.30863, 22.3098, 0.177201>,
      <-0.522711, 28.4936, 0.177201>, <0.385483, 26.4241, 0.177201>, <1.31533, 24.364, 0.177201>, <2.20187, 22.2852, 0.177201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.007, 22.2402, 0.377201>, <2.05985, 22.1164, 0.377201>, <2.06755, 21.9779, 0.377201>, <2.09783, 21.8468, 0.377201>,
      <2.007, 22.2402, 0.486766>, <2.05985, 22.1164, 0.486766>, <2.06755, 21.9779, 0.486766>, <2.09783, 21.8468, 0.486766>,
      <2.09511, 22.2605, 0.577201>, <2.14791, 22.1367, 0.577201>, <2.15567, 21.9982, 0.577201>, <2.18595, 21.8671, 0.577201>,
      <2.20187, 22.2852, 0.577201>, <2.25467, 22.1614, 0.577201>, <2.26243, 22.0229, 0.577201>, <2.2927, 21.8917, 0.577201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.007, 22.2402, 0.377201>, <2.05985, 22.1164, 0.377201>, <2.06755, 21.9779, 0.377201>, <2.09783, 21.8468, 0.377201>,
      <2.007, 22.2402, 0.267636>, <2.05985, 22.1164, 0.267636>, <2.06755, 21.9779, 0.267636>, <2.09783, 21.8468, 0.267636>,
      <2.09511, 22.2605, 0.177201>, <2.14791, 22.1367, 0.177201>, <2.15567, 21.9982, 0.177201>, <2.18595, 21.8671, 0.177201>,
      <2.20187, 22.2852, 0.177201>, <2.25467, 22.1614, 0.177201>, <2.26243, 22.0229, 0.177201>, <2.2927, 21.8917, 0.177201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.20187, 22.2852, 0.577201>, <2.25467, 22.1614, 0.577201>, <2.26243, 22.0229, 0.577201>, <2.2927, 21.8917, 0.577201>,
      <2.30863, 22.3098, 0.577201>, <2.36143, 22.186, 0.577201>, <2.36918, 22.0475, 0.577201>, <2.39946, 21.9164, 0.577201>,
      <2.39674, 22.3302, 0.486766>, <2.44949, 22.2063, 0.486766>, <2.4573, 22.0679, 0.486766>, <2.48758, 21.9367, 0.486766>,
      <2.39674, 22.3302, 0.377201>, <2.44949, 22.2063, 0.377201>, <2.4573, 22.0679, 0.377201>, <2.48758, 21.9367, 0.377201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.39674, 22.3302, 0.377201>, <2.44949, 22.2063, 0.377201>, <2.4573, 22.0679, 0.377201>, <2.48758, 21.9367, 0.377201>,
      <2.39674, 22.3302, 0.267636>, <2.44949, 22.2063, 0.267636>, <2.4573, 22.0679, 0.267636>, <2.48758, 21.9367, 0.267636>,
      <2.30863, 22.3098, 0.177201>, <2.36143, 22.186, 0.177201>, <2.36918, 22.0475, 0.177201>, <2.39946, 21.9164, 0.177201>,
      <2.20187, 22.2852, 0.177201>, <2.25467, 22.1614, 0.177201>, <2.26243, 22.0229, 0.177201>, <2.2927, 21.8917, 0.177201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.09783, 21.8468, 0.377201>, <2.13051, 21.7052, 0.377201>, <2.21824, 21.5656, 0.377201>, <2.19587, 21.4221, 0.377201>,
      <2.09783, 21.8468, 0.486766>, <2.13051, 21.7052, 0.486766>, <2.21824, 21.5656, 0.486766>, <2.19587, 21.4221, 0.486766>,
      <2.18595, 21.8671, 0.577201>, <2.21863, 21.7255, 0.577201>, <2.30485, 21.5862, 0.577201>, <2.28399, 21.4424, 0.577201>,
      <2.2927, 21.8917, 0.577201>, <2.32538, 21.7502, 0.577201>, <2.41161, 21.6109, 0.577201>, <2.39074, 21.4671, 0.577201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.09783, 21.8468, 0.377201>, <2.13051, 21.7052, 0.377201>, <2.21824, 21.5656, 0.377201>, <2.19587, 21.4221, 0.377201>,
      <2.09783, 21.8468, 0.267636>, <2.13051, 21.7052, 0.267636>, <2.21824, 21.5656, 0.267636>, <2.19587, 21.4221, 0.267636>,
      <2.18595, 21.8671, 0.177201>, <2.21863, 21.7255, 0.177201>, <2.30485, 21.5862, 0.177201>, <2.28399, 21.4424, 0.177201>,
      <2.2927, 21.8917, 0.177201>, <2.32538, 21.7502, 0.177201>, <2.41161, 21.6109, 0.177201>, <2.39074, 21.4671, 0.177201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.2927, 21.8917, 0.577201>, <2.32538, 21.7502, 0.577201>, <2.41161, 21.6109, 0.577201>, <2.39074, 21.4671, 0.577201>,
      <2.39946, 21.9164, 0.577201>, <2.43214, 21.7748, 0.577201>, <2.51837, 21.6355, 0.577201>, <2.4975, 21.4917, 0.577201>,
      <2.48758, 21.9367, 0.486766>, <2.52026, 21.7952, 0.486766>, <2.60526, 21.656, 0.486766>, <2.58562, 21.5121, 0.486766>,
      <2.48758, 21.9367, 0.377201>, <2.52026, 21.7952, 0.377201>, <2.60526, 21.656, 0.377201>, <2.58562, 21.5121, 0.377201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.48758, 21.9367, 0.377201>, <2.52026, 21.7952, 0.377201>, <2.60526, 21.656, 0.377201>, <2.58562, 21.5121, 0.377201>,
      <2.48758, 21.9367, 0.267636>, <2.52026, 21.7952, 0.267636>, <2.60526, 21.656, 0.267636>, <2.58562, 21.5121, 0.267636>,
      <2.39946, 21.9164, 0.177201>, <2.43214, 21.7748, 0.177201>, <2.51837, 21.6355, 0.177201>, <2.4975, 21.4917, 0.177201>,
      <2.2927, 21.8917, 0.177201>, <2.32538, 21.7502, 0.177201>, <2.41161, 21.6109, 0.177201>, <2.39074, 21.4671, 0.177201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.19587, 21.4221, 0.377201>, <2.16768, 21.2413, 0.377201>, <2.03534, 21.0931, 0.377201>, <1.95474, 20.9288, 0.377201>,
      <2.19587, 21.4221, 0.486766>, <2.16768, 21.2413, 0.486766>, <2.03534, 21.0931, 0.486766>, <1.95474, 20.9288, 0.486766>,
      <2.28399, 21.4424, 0.577201>, <2.25269, 21.2268, 0.577201>, <2.12018, 21.1011, 0.571076>, <2.03998, 20.8986, 0.577201>,
      <2.39074, 21.4671, 0.577201>, <2.35945, 21.2514, 0.577201>, <2.22346, 21.0646, 0.571076>, <2.14326, 20.8621, 0.577201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.19587, 21.4221, 0.377201>, <2.16768, 21.2413, 0.377201>, <2.03534, 21.0931, 0.377201>, <1.95474, 20.9288, 0.377201>,
      <2.19587, 21.4221, 0.267636>, <2.16768, 21.2413, 0.267636>, <2.03534, 21.0931, 0.267636>, <1.95474, 20.9288, 0.267636>,
      <2.28399, 21.4424, 0.177201>, <2.25269, 21.2268, 0.177201>, <2.12018, 21.1011, 0.183325>, <2.03998, 20.8986, 0.177201>,
      <2.39074, 21.4671, 0.177201>, <2.35945, 21.2514, 0.177201>, <2.22346, 21.0646, 0.183325>, <2.14326, 20.8621, 0.177201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.39074, 21.4671, 0.577201>, <2.35945, 21.2514, 0.577201>, <2.22346, 21.0646, 0.571076>, <2.14326, 20.8621, 0.577201>,
      <2.4975, 21.4917, 0.577201>, <2.4662, 21.2761, 0.577201>, <2.32674, 21.028, 0.571076>, <2.24655, 20.8255, 0.577201>,
      <2.58562, 21.5121, 0.486766>, <2.55134, 21.2609, 0.486766>, <2.41041, 21.0363, 0.486766>, <2.33179, 20.7953, 0.486766>,
      <2.58562, 21.5121, 0.377201>, <2.55134, 21.2609, 0.377201>, <2.41041, 21.0363, 0.377201>, <2.33179, 20.7953, 0.377201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.58562, 21.5121, 0.377201>, <2.55134, 21.2609, 0.377201>, <2.41041, 21.0363, 0.377201>, <2.33179, 20.7953, 0.377201>,
      <2.58562, 21.5121, 0.267636>, <2.55134, 21.2609, 0.267636>, <2.41041, 21.0363, 0.267636>, <2.33179, 20.7953, 0.267636>,
      <2.4975, 21.4917, 0.177201>, <2.4662, 21.2761, 0.177201>, <2.32674, 21.028, 0.183325>, <2.24655, 20.8255, 0.177201>,
      <2.39074, 21.4671, 0.177201>, <2.35945, 21.2514, 0.177201>, <2.22346, 21.0646, 0.183325>, <2.14326, 20.8621, 0.177201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.95474, 20.9288, 0.377201>, <1.92517, 20.8685, 0.377201>, <1.86535, 20.7483, 0.377201>, <1.86535, 20.7483, 0.377201>,
      <1.95474, 20.9288, 0.486766>, <1.92517, 20.8685, 0.486766>, <1.86535, 20.7483, 0.499913>, <1.86535, 20.7483, 0.499913>,
      <2.03998, 20.8986, 0.577201>, <2.01527, 20.8362, 0.579088>, <1.96083, 20.7145, 0.601201>, <1.96083, 20.7145, 0.601201>,
      <2.14326, 20.8621, 0.577201>, <2.11855, 20.7997, 0.579088>, <2.0765, 20.6735, 0.601201>, <2.0765, 20.6735, 0.601201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.95474, 20.9288, 0.377201>, <1.92517, 20.8685, 0.377201>, <1.86535, 20.7483, 0.377201>, <1.86535, 20.7483, 0.377201>,
      <1.95474, 20.9288, 0.267636>, <1.92517, 20.8685, 0.267636>, <1.86535, 20.7483, 0.254488>, <1.86535, 20.7483, 0.254488>,
      <2.03998, 20.8986, 0.177201>, <2.01527, 20.8362, 0.175314>, <1.96083, 20.7145, 0.153201>, <1.96083, 20.7145, 0.153201>,
      <2.14326, 20.8621, 0.177201>, <2.11855, 20.7997, 0.175314>, <2.0765, 20.6735, 0.153201>, <2.0765, 20.6735, 0.153201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.14326, 20.8621, 0.577201>, <2.11855, 20.7997, 0.579088>, <2.0765, 20.6735, 0.601201>, <2.0765, 20.6735, 0.601201>,
      <2.24655, 20.8255, 0.577201>, <2.22183, 20.7631, 0.579088>, <2.19218, 20.6326, 0.601201>, <2.19218, 20.6326, 0.601201>,
      <2.33179, 20.7953, 0.486766>, <2.31097, 20.7315, 0.486766>, <2.28765, 20.5988, 0.499914>, <2.28765, 20.5988, 0.499914>,
      <2.33179, 20.7953, 0.377201>, <2.31097, 20.7315, 0.377201>, <2.28765, 20.5988, 0.377201>, <2.28765, 20.5988, 0.377201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.33179, 20.7953, 0.377201>, <2.31097, 20.7315, 0.377201>, <2.28765, 20.5988, 0.377201>, <2.28765, 20.5988, 0.377201>,
      <2.33179, 20.7953, 0.267636>, <2.31097, 20.7315, 0.267636>, <2.28765, 20.5988, 0.254488>, <2.28765, 20.5988, 0.254488>,
      <2.24655, 20.8255, 0.177201>, <2.22183, 20.7631, 0.175314>, <2.19218, 20.6326, 0.153201>, <2.19218, 20.6326, 0.153201>,
      <2.14326, 20.8621, 0.177201>, <2.11855, 20.7997, 0.175314>, <2.0765, 20.6735, 0.153201>, <2.0765, 20.6735, 0.153201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.86535, 20.7483, 0.377201>, <1.86535, 20.7483, 0.377201>, <1.86535, 20.7483, 0.377201>, <1.86535, 20.7483, 0.377201>,
      <1.86535, 20.7483, 0.499913>, <1.86535, 20.7483, 0.499913>, <1.86535, 20.7483, 0.499913>, <1.86535, 20.7483, 0.499913>,
      <1.96083, 20.7145, 0.601201>, <1.96083, 20.7145, 0.601201>, <1.96083, 20.7145, 0.601201>, <1.96083, 20.7145, 0.601201>,
      <2.0765, 20.6735, 0.601201>, <2.0765, 20.6735, 0.601201>, <2.0765, 20.6735, 0.601201>, <2.0765, 20.6735, 0.601201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.86535, 20.7483, 0.377201>, <1.86535, 20.7483, 0.377201>, <1.86535, 20.7483, 0.377201>, <1.86535, 20.7483, 0.377201>,
      <1.86535, 20.7483, 0.254488>, <1.86535, 20.7483, 0.254488>, <1.86535, 20.7483, 0.254488>, <1.86535, 20.7483, 0.254488>,
      <1.96083, 20.7145, 0.153201>, <1.96083, 20.7145, 0.153201>, <1.96083, 20.7145, 0.153201>, <1.96083, 20.7145, 0.153201>,
      <2.0765, 20.6735, 0.153201>, <2.0765, 20.6735, 0.153201>, <2.0765, 20.6735, 0.153201>, <2.0765, 20.6735, 0.153201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.0765, 20.6735, 0.601201>, <2.0765, 20.6735, 0.601201>, <2.0765, 20.6735, 0.601201>, <2.0765, 20.6735, 0.601201>,
      <2.19218, 20.6326, 0.601201>, <2.19218, 20.6326, 0.601201>, <2.19218, 20.6326, 0.601201>, <2.19218, 20.6326, 0.601201>,
      <2.28765, 20.5988, 0.499914>, <2.28765, 20.5988, 0.499914>, <2.28765, 20.5988, 0.499914>, <2.28765, 20.5988, 0.499914>,
      <2.28765, 20.5988, 0.377201>, <2.28765, 20.5988, 0.377201>, <2.28765, 20.5988, 0.377201>, <2.28765, 20.5988, 0.377201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.28765, 20.5988, 0.377201>, <2.28765, 20.5988, 0.377201>, <2.28765, 20.5988, 0.377201>, <2.28765, 20.5988, 0.377201>,
      <2.28765, 20.5988, 0.254488>, <2.28765, 20.5988, 0.254488>, <2.28765, 20.5988, 0.254488>, <2.28765, 20.5988, 0.254488>,
      <2.19218, 20.6326, 0.153201>, <2.19218, 20.6326, 0.153201>, <2.19218, 20.6326, 0.153201>, <2.19218, 20.6326, 0.153201>,
      <2.0765, 20.6735, 0.153201>, <2.0765, 20.6735, 0.153201>, <2.0765, 20.6735, 0.153201>, <2.0765, 20.6735, 0.153201>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.86535, 20.7483, 0.377201>, <1.22595, 18.9152, 0.251467>, <0.586961, 17.0823, 0.121217>, <-0.0528445, 15.2491, 0>,
      <1.86535, 20.7483, 0.499913>, <1.22595, 18.9152, 0.37418>, <0.586961, 17.0823, 0.24393>, <-0.0528445, 15.2491, 0.122713>,
      <1.96083, 20.7145, 0.601201>, <1.32143, 18.8814, 0.475467>, <0.682438, 17.0485, 0.345217>, <0.0426329, 15.2153, 0.224>,
      <2.0765, 20.6735, 0.601201>, <1.4371, 18.8405, 0.475467>, <0.798113, 17.0076, 0.345217>, <0.158307, 15.1743, 0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.86535, 20.7483, 0.377201>, <1.22595, 18.9152, 0.251467>, <0.586961, 17.0823, 0.121217>, <-0.0528445, 15.2491, 0>,
      <1.86535, 20.7483, 0.254488>, <1.22595, 18.9152, 0.128755>, <0.586961, 17.0823, -0.00149589>, <-0.0528445, 15.2491, -0.122713>,
      <1.96083, 20.7145, 0.153201>, <1.32143, 18.8814, 0.0274672>, <0.682438, 17.0485, -0.102783>, <0.0426329, 15.2153, -0.224>,
      <2.0765, 20.6735, 0.153201>, <1.4371, 18.8405, 0.0274672>, <0.798113, 17.0076, -0.102783>, <0.158307, 15.1743, -0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.0765, 20.6735, 0.601201>, <1.4371, 18.8405, 0.475467>, <0.798113, 17.0076, 0.345217>, <0.158307, 15.1743, 0.224>,
      <2.19218, 20.6326, 0.601201>, <1.55278, 18.7995, 0.475467>, <0.913787, 16.9666, 0.345217>, <0.273981, 15.1334, 0.224>,
      <2.28765, 20.5988, 0.499914>, <1.64826, 18.7657, 0.37418>, <1.00926, 16.9328, 0.24393>, <0.369459, 15.0996, 0.122713>,
      <2.28765, 20.5988, 0.377201>, <1.64826, 18.7657, 0.251467>, <1.00926, 16.9328, 0.121217>, <0.369459, 15.0996, 2.74321e-17>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.28765, 20.5988, 0.377201>, <1.64826, 18.7657, 0.251467>, <1.00926, 16.9328, 0.121217>, <0.369459, 15.0996, 2.74321e-17>,
      <2.28765, 20.5988, 0.254488>, <1.64826, 18.7657, 0.128754>, <1.00926, 16.9328, -0.0014959>, <0.369459, 15.0996, -0.122713>,
      <2.19218, 20.6326, 0.153201>, <1.55278, 18.7995, 0.0274672>, <0.913787, 16.9666, -0.102783>, <0.273981, 15.1334, -0.224>,
      <2.0765, 20.6735, 0.153201>, <1.4371, 18.8405, 0.0274672>, <0.798113, 17.0076, -0.102783>, <0.158307, 15.1743, -0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.0528445, 15.2491, 0>, <-0.0767331, 15.1807, -0.00452591>, <-0.101339, 15.1122, 0>, <-0.125586, 15.0437, 0>,
      <-0.0528445, 15.2491, 0.122713>, <-0.0767331, 15.1807, 0.118187>, <-0.101339, 15.1122, 0.122713>, <-0.125586, 15.0437, 0.122713>,
      <0.0426329, 15.2153, 0.224>, <0.0187443, 15.1469, 0.219474>, <-0.00586113, 15.0784, 0.224>, <-0.0301081, 15.0099, 0.224>,
      <0.158307, 15.1743, 0.224>, <0.134418, 15.1059, 0.219474>, <0.109813, 15.0374, 0.224>, <0.085566, 14.9689, 0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.0528445, 15.2491, 0>, <-0.0767331, 15.1807, -0.00452591>, <-0.101339, 15.1122, 0>, <-0.125586, 15.0437, 0>,
      <-0.0528445, 15.2491, -0.122713>, <-0.0767331, 15.1807, -0.127239>, <-0.101339, 15.1122, -0.122713>, <-0.125586, 15.0437, -0.122713>,
      <0.0426329, 15.2153, -0.224>, <0.0187443, 15.1469, -0.228526>, <-0.00586113, 15.0784, -0.224>, <-0.0301081, 15.0099, -0.224>,
      <0.158307, 15.1743, -0.224>, <0.134418, 15.1059, -0.228526>, <0.109813, 15.0374, -0.224>, <0.085566, 14.9689, -0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.158307, 15.1743, 0.224>, <0.134418, 15.1059, 0.219474>, <0.109813, 15.0374, 0.224>, <0.085566, 14.9689, 0.224>,
      <0.273981, 15.1334, 0.224>, <0.250093, 15.0649, 0.219474>, <0.225487, 14.9964, 0.224>, <0.20124, 14.928, 0.224>,
      <0.369459, 15.0996, 0.122713>, <0.34557, 15.0311, 0.118187>, <0.320965, 14.9626, 0.122713>, <0.296718, 14.8942, 0.122713>,
      <0.369459, 15.0996, 2.74321e-17>, <0.34557, 15.0311, -0.00452591>, <0.320965, 14.9626, 2.74321e-17>, <0.296718, 14.8942, 2.74321e-17>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.369459, 15.0996, 2.74321e-17>, <0.34557, 15.0311, -0.00452591>, <0.320965, 14.9626, 2.74321e-17>, <0.296718, 14.8942, 2.74321e-17>,
      <0.369459, 15.0996, -0.122713>, <0.34557, 15.0311, -0.127239>, <0.320965, 14.9626, -0.122713>, <0.296718, 14.8942, -0.122713>,
      <0.273981, 15.1334, -0.224>, <0.250093, 15.0649, -0.228526>, <0.225487, 14.9964, -0.224>, <0.20124, 14.928, -0.224>,
      <0.158307, 15.1743, -0.224>, <0.134418, 15.1059, -0.228526>, <0.109813, 15.0374, -0.224>, <0.085566, 14.9689, -0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.125586, 15.0437, 0>, <-0.15839, 14.9511, 0>, <-0.222191, 14.864, 0>, <-0.224, 14.7658, 0>,
      <-0.125586, 15.0437, 0.122713>, <-0.15839, 14.9511, 0.122713>, <-0.222191, 14.864, 0.122713>, <-0.224, 14.7658, 0.122713>,
      <-0.0301081, 15.0099, 0.224>, <-0.0629129, 14.9173, 0.224>, <-0.126927, 14.8302, 0.224>, <-0.128523, 14.732, 0.224>,
      <0.085566, 14.9689, 0.224>, <0.0527612, 14.8763, 0.224>, <-0.0112529, 14.7893, 0.224>, <-0.0128484, 14.691, 0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.125586, 15.0437, 0>, <-0.15839, 14.9511, 0>, <-0.222191, 14.864, 0>, <-0.224, 14.7658, 0>,
      <-0.125586, 15.0437, -0.122713>, <-0.15839, 14.9511, -0.122713>, <-0.222191, 14.864, -0.122713>, <-0.224, 14.7658, -0.122713>,
      <-0.0301081, 15.0099, -0.224>, <-0.0629129, 14.9173, -0.224>, <-0.126927, 14.8302, -0.224>, <-0.128523, 14.732, -0.224>,
      <0.085566, 14.9689, -0.224>, <0.0527612, 14.8763, -0.224>, <-0.0112529, 14.7893, -0.224>, <-0.0128484, 14.691, -0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.085566, 14.9689, 0.224>, <0.0527612, 14.8763, 0.224>, <-0.0112529, 14.7893, 0.224>, <-0.0128484, 14.691, 0.224>,
      <0.20124, 14.928, 0.224>, <0.168435, 14.8353, 0.224>, <0.104421, 14.7483, 0.224>, <0.102826, 14.6501, 0.224>,
      <0.296718, 14.8942, 0.122713>, <0.263913, 14.8015, 0.122713>, <0.199679, 14.7145, 0.122713>, <0.198303, 14.6162, 0.122713>,
      <0.296718, 14.8942, 2.74321e-17>, <0.263913, 14.8015, 2.74321e-17>, <0.199679, 14.7145, 2.74321e-17>, <0.198303, 14.6162, 2.74321e-17>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.296718, 14.8942, 2.74321e-17>, <0.263913, 14.8015, 2.74321e-17>, <0.199679, 14.7145, 2.74321e-17>, <0.198303, 14.6162, 2.74321e-17>,
      <0.296718, 14.8942, -0.122713>, <0.263913, 14.8015, -0.122713>, <0.199679, 14.7145, -0.122713>, <0.198303, 14.6162, -0.122713>,
      <0.20124, 14.928, -0.224>, <0.168435, 14.8353, -0.224>, <0.104421, 14.7483, -0.224>, <0.102826, 14.6501, -0.224>,
      <0.085566, 14.9689, -0.224>, <0.0527612, 14.8763, -0.224>, <-0.0112529, 14.7893, -0.224>, <-0.0128484, 14.691, -0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.224, 14.7658, 0>, <-0.255094, 13.0772, 0>, <-0.214772, 11.3879, -7.79671e-05>, <-0.224, 9.69906, 0>,
      <-0.224, 14.7658, 0.122713>, <-0.255094, 13.0772, 0.122713>, <-0.214772, 11.3879, 0.122635>, <-0.224, 9.69906, 0.122713>,
      <-0.128523, 14.732, 0.224>, <-0.155537, 13.0682, 0.224>, <-0.126894, 11.363, 0.214622>, <-0.122713, 9.69906, 0.224>,
      <-0.0128484, 14.691, 0.224>, <-0.0398628, 13.0272, 0.224>, <-0.0041815, 11.363, 0.214622>, <-1.3716e-17, 9.69906, 0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.224, 14.7658, 0>, <-0.255094, 13.0772, 0>, <-0.214772, 11.3879, -7.79671e-05>, <-0.224, 9.69906, 0>,
      <-0.224, 14.7658, -0.122713>, <-0.255094, 13.0772, -0.122713>, <-0.214772, 11.3879, -0.122791>, <-0.224, 9.69906, -0.122713>,
      <-0.128523, 14.732, -0.224>, <-0.155537, 13.0682, -0.224>, <-0.126894, 11.363, -0.214777>, <-0.122713, 9.69906, -0.224>,
      <-0.0128484, 14.691, -0.224>, <-0.0398628, 13.0272, -0.224>, <-0.00418151, 11.363, -0.214777>, <4.11481e-17, 9.69906, -0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.0128484, 14.691, 0.224>, <-0.0398628, 13.0272, 0.224>, <-0.0041815, 11.363, 0.214622>, <-1.3716e-17, 9.69906, 0.224>,
      <0.102826, 14.6501, 0.224>, <0.0758114, 12.9863, 0.224>, <0.118531, 11.363, 0.214622>, <0.122713, 9.69906, 0.224>,
      <0.198303, 14.6162, 0.122713>, <0.175363, 12.9773, 0.122713>, <0.206426, 11.3381, 0.122635>, <0.224, 9.69906, 0.122713>,
      <0.198303, 14.6162, 2.74321e-17>, <0.175363, 12.9773, 2.74321e-17>, <0.206426, 11.3381, -7.78672e-05>, <0.224, 9.69906, 2.74321e-17>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.198303, 14.6162, 2.74321e-17>, <0.175363, 12.9773, 2.74321e-17>, <0.206426, 11.3381, -7.78672e-05>, <0.224, 9.69906, 2.74321e-17>,
      <0.198303, 14.6162, -0.122713>, <0.175363, 12.9773, -0.122713>, <0.206426, 11.3381, -0.122791>, <0.224, 9.69906, -0.122713>,
      <0.102826, 14.6501, -0.224>, <0.0758114, 12.9863, -0.224>, <0.118531, 11.363, -0.214777>, <0.122713, 9.69906, -0.224>,
      <-0.0128484, 14.691, -0.224>, <-0.0398628, 13.0272, -0.224>, <-0.00418151, 11.363, -0.214777>, <4.11481e-17, 9.69906, -0.224>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.224, 9.69906, 0>, <-0.2244, 9.62579, 3.38257e-06>, <-0.252658, 9.55442, 0.000242121>, <-0.252876, 9.48115, 0.000243965>,
      <-0.224, 9.69906, 0.122713>, <-0.2244, 9.62579, 0.122716>, <-0.252658, 9.55442, 0.138908>, <-0.252876, 9.48115, 0.138909>,
      <-0.122713, 9.69906, 0.224>, <-0.122529, 9.62577, 0.224413>, <-0.138423, 9.55444, 0.253142>, <-0.138422, 9.48115, 0.253364>,
      <-1.3716e-17, 9.69906, 0.224>, <0.000184184, 9.62577, 0.224413>, <0.000242098, 9.55444, 0.253142>, <0.000243942, 9.48115, 0.253364>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.224, 9.69906, 0>, <-0.2244, 9.62579, 3.38257e-06>, <-0.252658, 9.55442, 0.000242121>, <-0.252876, 9.48115, 0.000243965>,
      <-0.224, 9.69906, -0.122713>, <-0.2244, 9.62579, -0.122709>, <-0.252658, 9.55442, -0.138423>, <-0.252876, 9.48115, -0.138422>,
      <-0.122713, 9.69906, -0.224>, <-0.122529, 9.62579, -0.224406>, <-0.138423, 9.55442, -0.252658>, <-0.138422, 9.48115, -0.252876>,
      <4.11481e-17, 9.69906, -0.224>, <0.00018413, 9.62579, -0.224406>, <0.000242098, 9.55442, -0.252658>, <0.000243942, 9.48115, -0.252876>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.3716e-17, 9.69906, 0.224>, <0.000184184, 9.62577, 0.224413>, <0.000242098, 9.55444, 0.253142>, <0.000243942, 9.48115, 0.253364>,
      <0.122713, 9.69906, 0.224>, <0.122897, 9.62577, 0.224413>, <0.138908, 9.55444, 0.253142>, <0.138909, 9.48115, 0.253364>,
      <0.224, 9.69906, 0.122713>, <0.224786, 9.62577, 0.122716>, <0.253142, 9.55444, 0.138908>, <0.253364, 9.48115, 0.138909>,
      <0.224, 9.69906, 2.74321e-17>, <0.224786, 9.62577, 3.48196e-06>, <0.253142, 9.55444, 0.000242121>, <0.253364, 9.48115, 0.000243965>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.224, 9.69906, 2.74321e-17>, <0.224786, 9.62577, 3.48196e-06>, <0.253142, 9.55444, 0.000242121>, <0.253364, 9.48115, 0.000243965>,
      <0.224, 9.69906, -0.122713>, <0.224786, 9.62577, -0.122709>, <0.253142, 9.55444, -0.138423>, <0.253364, 9.48115, -0.138422>,
      <0.122713, 9.69906, -0.224>, <0.122897, 9.62579, -0.224406>, <0.138908, 9.55442, -0.252658>, <0.138909, 9.48115, -0.252876>,
      <4.11481e-17, 9.69906, -0.224>, <0.00018413, 9.62579, -0.224406>, <0.000242098, 9.55442, -0.252658>, <0.000243942, 9.48115, -0.252876>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.252876, 9.48115, 0.000243965>, <-0.262285, 6.32156, 0.000323459>, <-0.252876, 3.16195, 0.000243965>, <-0.252876, 0.00234795, 0.000243965>,
      <-0.252876, 9.48115, 0.138909>, <-0.262285, 6.32156, 0.138989>, <-0.252876, 3.16195, 0.138909>, <-0.252876, 0.00234795, 0.138909>,
      <-0.138422, 9.48115, 0.253364>, <-0.138342, 6.32156, 0.262932>, <-0.138422, 3.16195, 0.253364>, <-0.138422, 0.00234795, 0.253364>,
      <0.000243942, 9.48115, 0.253364>, <0.000323428, 6.32156, 0.262932>, <0.000243942, 3.16195, 0.253364>, <0.000243942, 0.00234795, 0.253364>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.252876, 9.48115, 0.000243965>, <-0.262285, 6.32156, 0.000323459>, <-0.252876, 3.16195, 0.000243965>, <-0.252876, 0.00234795, 0.000243965>,
      <-0.252876, 9.48115, -0.138422>, <-0.262285, 6.32156, -0.138342>, <-0.252876, 3.16195, -0.138422>, <-0.252876, 0.00234795, -0.138422>,
      <-0.138422, 9.48115, -0.252876>, <-0.138342, 6.32156, -0.262285>, <-0.138422, 3.16195, -0.252876>, <-0.138422, 0.00234795, -0.252876>,
      <0.000243942, 9.48115, -0.252876>, <0.000323428, 6.32156, -0.262285>, <0.000243942, 3.16195, -0.252876>, <0.000243942, 0.00234795, -0.252876>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.000243942, 9.48115, 0.253364>, <0.000323428, 6.32156, 0.262932>, <0.000243942, 3.16195, 0.253364>, <0.000243942, 0.00234795, 0.253364>,
      <0.138909, 9.48115, 0.253364>, <0.138989, 6.32156, 0.262932>, <0.138909, 3.16195, 0.253364>, <0.138909, 0.00234795, 0.253364>,
      <0.253364, 9.48115, 0.138909>, <0.262932, 6.32156, 0.138989>, <0.253364, 3.16195, 0.138909>, <0.253364, 0.00234795, 0.138909>,
      <0.253364, 9.48115, 0.000243965>, <0.262932, 6.32156, 0.000323459>, <0.253364, 3.16195, 0.000243965>, <0.253364, 0.00234795, 0.000243965>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.253364, 9.48115, 0.000243965>, <0.262932, 6.32156, 0.000323459>, <0.253364, 3.16195, 0.000243965>, <0.253364, 0.00234795, 0.000243965>,
      <0.253364, 9.48115, -0.138422>, <0.262932, 6.32156, -0.138342>, <0.253364, 3.16195, -0.138422>, <0.253364, 0.00234795, -0.138422>,
      <0.138909, 9.48115, -0.252876>, <0.138989, 6.32156, -0.262285>, <0.138909, 3.16195, -0.252876>, <0.138909, 0.00234795, -0.252876>,
      <0.000243942, 9.48115, -0.252876>, <0.000323428, 6.32156, -0.262285>, <0.000243942, 3.16195, -0.252876>, <0.000243942, 0.00234795, -0.252876>
   }
}

#declare RadioHaup = intersection {
   torus {
      0.8, 0.05
      scale <1, 1, 0.1>
      rotate <0, 0, 0>
      translate <0.95, 0, -1>
   }
   
   box {
      <0.85, -0.03, 0>, <-0.85, 0.03, -0.09>
      scale 1
      rotate <0, 0, 0>
      translate <0.95, 0, -1>
   }
}

#declare Transistor = union {
   //*PMName Transistor
   
   difference {
      //*PMName Corps
      
      superellipsoid {
         <0.4, 0.2>
         scale <11, 5, 5>
      }
      
      difference {
         cylinder {
            <0, 0, -1.1>, <0, 0, 0>, 0.78
            translate x*0.84
         }
         
         box {
            <0, 0.8, -0.9>, <1.5, 0.6, -1.1>
            translate x*0.1
         }
         
         box {
            <0, -0.8, -0.9>, <1.5, -0.6, -1.1>
            translate x*0.1
         }
         scale 5
      }
   }
   
   union {
      //*PMName Rat
      //*PMRawBegin
      #include "radio.inc"
      //*PMRawEnd
      
      union {
         //*PMName Bonnet
         
         sphere {
            //*PMName Bonnet
            <0, 0, 0>, 0.5
            
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Unplugged/textures/rasta2.png"
                  map_type 1
               }
            }
            scale <1.2, 1, 2>
            rotate x*30
            translate <0, 0.7, 0.8>
         }
         scale 0.6
         rotate y*90
         rotate x*10
         translate <-1.0281, 1.86066, 0.735631>
      }
      
      union {
         //*PMName Tete
         
         merge {
            cone {
               <-0.5, 0, 0>, 0,
               <1, 0, 0>, 0.4
               rotate y*90
               hollow
            }
            
            sphere {
               <0, 0, 0>, 0.4
               scale <1, 1, 0.6>
               rotate <0, 0, 0>
               translate z*(-1)
               hollow
            }
            
            sphere {
               <0, 0, 0.066207>, 0.1
               scale 1
               rotate <0, 0, 0>
               translate <-0.119695, 0.436312, -1.07126>
               hollow
            }
            
            sphere {
               <0, 0, 0.066207>, 0.1
               scale 1
               rotate <0, 0, 0>
               translate <-0.22229, 0.349663, -1.02508>
               hollow
            }
            
            material {
               Fumee
               scale 0.5
            }
            scale 2
            rotate z*(-10)
            translate <0, -1, -3.2>
            hollow
         }
         //*PMRawBegin
         object {
            RRTete
         }
         
         object {
            RRBouche
         }
         
         object {
            RROreilles
         }
         //*PMRawEnd
         
         union {
            //*PMName Moustaches
            
            object {
               RRMoustaches
               scale 1
               rotate z*(-2.6)
               translate <-0.423889, 0.155529, -2.86909>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <0, 0, 0>
               translate <-0.423889, -0.0137449, -2.86909>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate z*2.3
               translate <-0.423889, -0.207201, -2.86909>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <-0, 180, 2.6>
               translate <0.42389, 0.15553, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate y*180
               translate <0.42389, -0.013745, -2.8691>
            }
            
            object {
               RRMoustaches
               scale 1
               rotate <0, 180, -2.3>
               translate <0.42389, -0.2072, -2.8691>
            }
            
            pigment {
               color rgbft <1, 1, 1, 0.2, 0.2>
            }
         }
         
         union {
            //*PMName Yeux
            
            union {
               //*PMName Droit
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeilRouge
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate y*10
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-10)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  uv_mapping texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.8, 1>
               rotate <0, 0, 0>
               translate x*(-0.42)
            }
            
            union {
               //*PMName Gauche
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeilRouge
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate <-0, 0, 0>
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-27.7)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  uv_mapping texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.8, 1>
               rotate <0, 0, 0>
               translate x*0.42
            }
            translate <0, 0.98, -0.3758>
         }
         
         sphere {
            //*PMName Truffe
            <0, 0, -3.48>, 0.4
            
            texture {
               NoirOeil
            }
            scale <0.6, 0.5, 1>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         union {
            //*PMName Dents
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.11)
            }
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*0.11
            }
            translate <0, -0.67, -1.82>
            
            texture {
               BlancOeil
            }
         }
         scale 0.6
         rotate y*90
         rotate <0, 0, 0>
         rotate x*10
         translate <-1.0281, 1.86066, 0.735631>
         //*PMRawBegin
         uv_mapping texture {
            PeauGrise
         }
         //*PMRawEnd
      }
      //*PMRawBegin
      object {
         //*PMName Corps
         RRCorps
         
         texture {
            PeauGrise
         }
      }
      
      object {
         //*PMName Bras
         RRBrasD
         
         texture {
            PeauGrise
         }
      }
      
      object {
         //*PMName Bras
         RRBrasG
         
         texture {
            PeauGrise
         }
      }
      
      object {
         //*PMName Queue
         RRQueue
         
         texture {
            PeauRose
         }
         rotate z*(-16.4)
         translate <0.147476, -0.178056, 0>
      }
      //*PMRawEnd
      
      union {
         //*PMName joint
         
         cone {
            <0, 0, 0>, 0.2,
            <2, 0, 0>, 0.4
            
            pigment {
               color rgb <1, 1, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cone {
            <0, 0, 0>, 0.2,
            <-0.2, 0, 0>, 0.22
            
            pigment {
               color rgb <1, 1, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         //*PMRawBegin
         sor {
            4,
         <0, 0>,
         <0.4, 0>,
         <0.2, 0.3>,
         <0.10718, 0.49984>
            
            material {
               interior {
                  media {
                     density {
                        color rgb <1, 1, 1>
                     }
                     emission rgb <0.882353, 0.160784, 0.231373>
                  }
               }
               
               texture {
                  pigment {
                     color rgbt <0.87059, 0.11765, 0.13333, 0.5>
                  }
               }
            }
            scale 1
            rotate <-90, -90, 0>
            translate x*2
            hollow
         }
         //*PMRawEnd
         scale 0.15
         rotate <164.6, 43.6, 164.6>
         translate <-0.0489652, -1.15972, 0.82733>
      }
      scale 1
      rotate <-90, -74.6, 90>
      translate <4.6548, 0.19438, -4.87195>
   }
   
   union {
      //*PMName ConeHP
      
      object {
         //*PMName ConeHP
         ConeHP
         
         pigment {
            color rgb <0, 0, 0>
         }
         scale 1
         rotate <0, 0, 0>
         translate <4.2, 0, -3.4>
      }
      
      sphere {
         <0, 0, 0>, 1
         
         pigment {
            color rgb <0.847059, 0.847059, 0.847059>
         }
         scale 1
         rotate <0, 0, 0>
         translate <4.2, 0, -0.48>
      }
   }
   
   union {
      //*PMName Poigne
      
      difference {
         //*PMName Haut
         
         box {
            <-2.2, 1.22, 0.08>, <2.2, 1.38, -0.08>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         union {
            cylinder {
               <-2.2, 1.3, 0>, <2.2, 1.3, 0>, 0.08
               scale 1
               rotate <0, 0, 0>
               translate z*(-0.15)
            }
            
            cylinder {
               <-2.2, 1.3, 0>, <2.2, 1.3, 0>, 0.08
               scale 1
               rotate <0, 0, 0>
               translate y*(-0.15)
            }
         }
      }
      
      union {
         //*PMName Droit
         
         cylinder {
            <-0.05, 1.3, 0>, <0, 1.3, 0>, 0.11
            scale 1
            rotate <0, 0, 0>
         }
         
         cylinder {
            <-0.05, 0, 0>, <0, 0, 0>, 0.08
            scale 1
            rotate <0, 0, 0>
         }
         
         box {
            <0, 1.3, -0.08>, <-0.05, 0, 0.08>
            scale 1
            rotate <0, 0, 0>
         }
         translate x*(-2.2)
      }
      
      union {
         //*PMName Gauche
         
         cylinder {
            <-0.05, 1.3, 0>, <0, 1.3, 0>, 0.11
            scale 1
            rotate <0, 0, 0>
         }
         
         cylinder {
            <-0.05, 0, 0>, <0, 0, 0>, 0.08
            scale 1
            rotate <0, 0, 0>
         }
         
         box {
            <0, 1.3, -0.08>, <-0.05, 0, 0.08>
            scale 1
            rotate <0, 0, 0>
         }
         translate x*2.25
      }
      rotate x*29.5
      translate <0, 0, 0>
      
      texture {
         RedPlast
      }
      scale 5
   }
   
   union {
      //*PMName Antenne
      
      object {
         //*PMName Antenne
         antenne
         scale 0.6
         rotate z*71.1
         translate <1.54827, 0.906374, -0.78581>
      }
      
      sphere {
         <1.5483, 0.9, -0.78485>, 0.175
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, 0>, <0, 0.3, 0>, 0.175
         scale 1
         rotate <0, 0, 0>
         translate <1.5483, 0.6, -0.78485>
      }
      
      texture {
         agate
         agate_turb 0.4
         
         texture_map {
            [ 0 pigment {
               color rgb <0.603922, 0.603922, 0.603922>
            }
            
            finish {
               specular 0.5
               roughness 0.2
            }
            ]
            [ 0.5 pigment {
               color rgb <0.545098, 0.545098, 0.545098>
            }
            
            finish {
               specular 0.1
               roughness 0.1
            }
            ]
         }
         scale 5
      }
      translate <6.14019, 4.15518, 0.804089>
   }
   
   difference {
      //*PMName HP
      
      union {
         intersection {
            torus {
               0.8, 0.05
               scale <1, 1, 0.1>
               rotate <0, 0, 0>
               translate <0.95, 0, -1>
            }
            
            box {
               <0.85, -0.03, 0>, <-0.85, 0.06, -0.09>
               scale 1
               rotate <0, 0, 0>
               translate <0.95, 0, -1>
            }
            translate y*0.6
         }
         
         intersection {
            torus {
               0.8, 0.05
               scale <1, 1, 0.1>
               rotate <0, 0, 0>
               translate <0.95, 0, -1>
            }
            
            box {
               <0.85, -0.06, 0>, <-0.85, 0.03, -0.09>
               scale 1
               rotate <0, 0, 0>
               translate <0.95, 0, -1>
            }
            translate y*(-0.6)
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*0.1
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*0.2
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*0.3
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*0.4
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*0.5
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.1)
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.2)
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.3)
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.4)
         }
         
         object {
            RadioHaup
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.5)
         }
         translate x*(-0.1)
      }
      
      box {
         <0.52, -0.05, -1.11>, <1, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*0.4
      }
      
      box {
         <0.5, -0.05, -1.11>, <1.1, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*0.3
      }
      
      box {
         <0.4, -0.05, -1.11>, <1.32, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*0.3
      }
      
      box {
         <0.25, -0.05, -1.11>, <1.4, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*0.2
      }
      
      box {
         <0.2, -0.05, -1.11>, <1.51, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*0.1
      }
      
      box {
         <0.15, -0.05, -1.11>, <1.75, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <0.35, -0.05, -1.11>, <1.5, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.1)
      }
      
      box {
         <0.3, -0.05, -1.11>, <1.4, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.2)
      }
      
      box {
         <0.25, -0.05, -1.11>, <1.42, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.3)
      }
      
      box {
         <0.4, -0.05, -1.11>, <1.25, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.4)
      }
      
      box {
         <0.6, -0.05, -1.11>, <1.43, 0.05, -0.9>
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.5)
      }
      scale 5
   }
   
   union {
      //*PMName FM
      
      difference {
         //*PMName Syntoniseur
         
         superellipsoid {
            <0.4, 0.2>
            scale <0.8, 0.2, 0.05>
            rotate <0, 0, 0>
            translate <-0.905973, 0.408342, -0.976394>
         }
         
         box {
            <0, 0, 0>, <1, 0.1928, -0.05>
            
            pigment {
               color rgb <0, 0, 0>
            }
            scale <1.2, 1.2, 1>
            rotate <0, 0, 0>
            translate <-1.50604, 0.29167, -1>
         }
      }
      
      box {
         //*PMName Stations
         <0, 0, 0>, <1, 0.1928, 0.01>
         
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Unplugged/textures/radio.png"
               map_type 0
            }
            scale <1, 0.1928, 1>
         }
         scale <1.2, 1.2, 1>
         rotate <0, 0, 0>
         translate <-1.506, 0.29167, -1.01>
      }
      
      box {
         //*PMName Curseur
         <0, 0, -0.005>, <0.02, 0.1928, -0.02>
         
         pigment {
            color rgb <0.52549, 0.0980392, 0.262745>
         }
         scale <1, 1.2, 1>
         rotate <0, 0, 0>
         translate <-0.8, 0.29167, -1.01>
      }
      scale <5.5, 5.5, 5>
      translate <-0.0117851, -0.117851, 0>
   }
   
   union {
      //*PMName Bouton
      
      difference {
         //*PMName Bouton1
         
         cone {
            <0, 0, 0>, 0.15,
            <0, 0, 0.09>, 0.2
            scale 1
            rotate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.15
            scale <1, 1, 0.1>
            rotate <0, 0, 0>
         }
         translate <-0.5, -0.22, -1.1>
      }
      
      difference {
         //*PMName Bouton2
         
         cone {
            <0, 0, 0>, 0.15,
            <0, 0, 0.09>, 0.2
            scale 1
            rotate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.15
            scale <1, 1, 0.1>
            rotate <0, 0, 0>
         }
         translate <-1.2, -0.22, -1.1>
      }
      scale <4, 4, 5>
      translate <-0.2, -0.1, 0>
      
      texture {
         RedPlast
      }
   }
   
   texture {
      pigment {
         agate
         agate_turb 0.5
         turbulence <0.5, 0.4, 0.6>
         octaves 7
         omega 0.4
         lambda 3
         
         pigment_map {
            [ 0 color rgb <0.427451, 0.458824, 0.470588>
            ]
            [ 0.9 color rgb <0.466667, 0.568627, 0.584314>
            ]
         }
      }
      
      finish {
      }
      scale 5
   }
}

// Prise
#declare PlastPrise = texture {
   pigment {
      color rgb <0.533333, 0.380392, 0.372549>
   }
}

#declare MetalPrise = texture {
   pigment {
      color rgb <0.513725, 0.513725, 0.513725>
   }
   
   finish {
      metallic 1
      specular 0.8
      roughness 0.05
      
      reflection {
         rgb <0, 0, 0>, rgb <0.286275, 0.286275, 0.286275>
      }
   }
}

#declare Fiche = union {
   cylinder {
      <0, 0, 0>, <0, -0.35, 0>, 0.13
      
      texture {
         PlastPrise
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 0, 0>, 0.13
      
      texture {
         PlastPrise
      }
      scale <1, 0.4, 1>
      rotate <0, 0, 0>
      translate y*(-0.35)
   }
   
   cylinder {
      <0, 0, 0>, <0, -1, 0>, 0.12
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   difference {
      sphere {
         <0, 0, 0>, 0.12
         scale <1, 0.6, 1>
         rotate <0, 0, 0>
         translate y*(-1)
      }
      
      box {
         <-0.15, -0.05, -0.15>, <0.15, -0.08, 0.15>
         scale 1
         rotate <0, 0, 0>
         translate y*(-1)
      }
   }
}

// Rat1
#declare VerreLun = sphere {
   <0, 0, 0>, 0.36
   
   material {
      interior {
         ior -1.5
         dispersion 1
      }
      
      texture {
         pigment {
            color rgbft <0.92941, 0.92941, 0.92941, 0.5, 0.5>
         }
         
         finish {
            phong 2
            phong_size 40
            
            reflection {
               rgb <0.188235, 0.188235, 0.188235>, rgb <0.258824, 0.258824, 0.258824>
            }
         }
      }
   }
   scale <1, 1, 0.3>
   hollow
}

#declare Rat1 = union {
   //*PMName Rat1
   //*PMRawBegin
   #include "rat1.inc"
   //*PMRawEnd
   
   union {
      //*PMName Tete
      
      union {
         //*PMName Moustaches
         
         object {
            RRMoustaches
            scale 1
            rotate z*(-2.6)
            translate <-0.42389, 0.15, -2.8691>
         }
         
         object {
            RRMoustaches
            scale 1
            rotate <0, 0, 0>
            translate <-0.42389, 0, -2.8691>
         }
         
         object {
            RRMoustaches
            scale 1
            rotate z*2.3
            translate <-0.42389, -0.15, -2.8691>
         }
         
         object {
            RRMoustaches
            scale 1
            rotate <-0, 180, 2.6>
            translate <0.42389, 0.15, -2.8691>
         }
         
         object {
            RRMoustaches
            scale 1
            rotate y*180
            translate <0.42389, 0, -2.8691>
         }
         
         object {
            RRMoustaches
            scale 1
            rotate <0, 180, -2.3>
            translate <0.42389, -0.15, -2.8691>
         }
         
         pigment {
            color rgbft <1, 1, 1, 0.2, 0.2>
         }
         translate z*0.4
      }
      
      union {
         //*PMName Yeux
         
         union {
            //*PMName Droit
            
            sphere {
               <0, 0, 0>, 0.4
               
               texture {
                  BlancOeil
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, -0.7>, 0.15
               
               texture {
                  NoirOeil
               }
               scale <1, 1, 0.5>
               rotate <-0, 0, 0>
               translate <0, 0, 0>
            }
            
            intersection {
               sphere {
                  <0, 0, 0>, 0.41
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               union {
                  box {
                     <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  box {
                     <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                     scale 1
                     rotate x*(-27.7)
                     translate y*(-0.42)
                  }
               }
               //*PMRawBegin
               texture {
                  PeauGrise
               }
               //*PMRawEnd
            }
            scale <1, 0.9, 1>
            rotate <0, 0, 0>
            translate x*(-0.42)
         }
         
         union {
            //*PMName Gauche
            
            sphere {
               <0, 0, 0>, 0.4
               
               texture {
                  BlancOeil
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, -0.7>, 0.15
               
               texture {
                  NoirOeil
               }
               scale <1, 1, 0.5>
               rotate <-0, 0, 0>
               translate <0, 0, 0>
            }
            
            intersection {
               sphere {
                  <0, 0, 0>, 0.41
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               union {
                  box {
                     <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  box {
                     <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                     scale 1
                     rotate x*(-27.7)
                     translate y*(-0.42)
                  }
               }
               //*PMRawBegin
               texture {
                  PeauGrise
               }
               //*PMRawEnd
            }
            scale <1, 0.8, 1>
            rotate <0, 0, 0>
            translate x*0.42
         }
         translate <0, 0.98, -0.3758>
      }
      
      union {
         //*PMName Lunettes
         
         union {
            //*PMName VerreD
            
            torus {
               0.35, 0.04
               rotate x*90
            }
            
            object {
               //*PMName Verre
               VerreLun
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            translate <-0.420394, 0.975817, -0.922916>
         }
         
         union {
            //*PMName VerreG
            
            torus {
               0.35, 0.04
               rotate x*90
            }
            
            object {
               //*PMName Verre
               VerreLun
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            translate <0.42039, 0.97582, -0.92292>
         }
         
         sphere_sweep {
            cubic_spline,
            9,
            <-0.93488, -0.079287, 0.29733>,0.03
            <-0.90303, -0.019468, 0.39647>,0.03
            <-0.84203, 0.29971, 0.4976>,0.03
            <-0.79452, 0.50349, 0.46934>,0.03
            <-0.73515, 0.61704, 0.37146>,0.03
            <-0.75915, 0.69181, 0.23019>,0.03
            <-0.88937, 0.86509, -0.37463>,0.03
            <-0.77, 1, -0.92>,0.03
            <-0.77, 1, -0.92>,0.03
         }
         
         sphere_sweep {
            cubic_spline,
            9,
            <0.93488, -0.079287, 0.29732>,0.03
            <0.90303, -0.019468, 0.39647>,0.03
            <0.84203, 0.29971, 0.4976>,0.03
            <0.79452, 0.50349, 0.46934>,0.03
            <0.73515, 0.61704, 0.37146>,0.03
            <0.75915, 0.69181, 0.23018>,0.03
            <0.88937, 0.86509, -0.37463>,0.03
            <0.77, 1, -0.92>,0.03
            <0.77, 1, -0.92>,0.03
         }
         
         intersection {
            torus {
               0.3, 0.04
               scale 1
               rotate x*90
               translate <0.00732403, 0.873523, -0.922916>
            }
            
            box {
               <-0.127069, 1.08206, -0.811011>, <0.126217, 1.22699, -1.03528>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         pigment {
            color rgb <1, 0.34902, 1>
         }
         translate y*0.05
      }
      //*PMRawBegin
      object {
         //*PMName Tete
         RTete
         
         texture {
            PeauGrise
         }
      }
      
      object {
         //*PMName Bouche
         RBouche
         
         texture {
            PeauGrise
         }
      }
      
      object {
         //*PMName Oreille
         ROreille
         
         texture {
            PeauGrise
         }
      }
      //*PMRawEnd
      
      sphere {
         //*PMName Truffe
         <0, 0, -3.48>, 0.4
         
         texture {
            NoirOeil
         }
         scale <0.6, 0.5, 1>
         rotate <0, 0, 0>
         translate z*0.4
      }
      
      union {
         //*PMName Dents
         
         box {
            <-0.1, -0.3, 0>, <0.1, 0, 0.05>
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.11)
         }
         
         box {
            <-0.1, -0.3, 0>, <0.1, 0, 0.05>
            scale 1
            rotate <0, 0, 0>
            translate x*0.11
         }
         translate <0, -0.67, -1.42>
         
         texture {
            BlancOeil
         }
      }
      scale 0.6
      rotate y*20
      translate <0.435089, 2.07201, 2.31426>
   }
   
   union {
      //*PMName Corps
      //*PMRawBegin
      object {
         //*PMName Queue
         R1Queue
         
         texture {
            PeauRose
         }
      }
      
      object {
         //*PMName Corps
         R1Corps
      }
      
      object {
         //*PMName Bras
         R1Bras
      }
      //*PMRawEnd
      //*PMRawBegin
      uv_mapping texture {
         PeauGrise
      }
      //*PMRawEnd
   }
   
   union {
      //*PMName CureDent
      
      cylinder {
         <0, 0.1, 0>, <0, 1.9, 0>, 0.03
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cone {
         <0, 2.2, 0>, 0,
         <0, 1.9, 0>, 0.03
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cone {
         <0, -0.2, 0>, 0,
         <0, 0.1, 0>, 0.03
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         pigment {
            color rgb <0.454902, 0.388235, 0.305882>
         }
         
         normal {
            marble
            0.5
            turbulence <0.5, 0.5, 0.5>
            scale 0.05
            bump_size 0.2
         }
      }
      scale 2
      rotate z*8.1
      translate <-2.29241, -1.84465, 1.68322>
   }
}

// RatL'Colique
#declare MetalPilsBlanc = texture {
   agate
   agate_turb 1
   
   texture_map {
      [ 0 pigment {
         color rgb <0.992157, 1, 0.941176>
      }
      
      finish {
         specular 0.2
         roughness 0.1
      }
      ]
      [ 0.9 pigment {
         color rgb <0.945098, 0.952941, 0.898039>
      }
      
      finish {
         specular 0.1
         roughness 0.1
      }
      ]
   }
}

#declare MetalPils = texture {
   pigment {
      color rgb <0.745098, 0.72549, 0.72549>
   }
   
   finish {
      specular 1.5
      roughness 0.05
   }
}

#declare Etiquette = texture {
   granite
   
   texture_map {
      [ 0 pigment {
         image_map {
            png
            "/home/tom/RayTrace/Unplugged/textures/grim2.png"
            once
            map_type 2
         }
      }
      ]
      [ 0.95 MetalPilsBlanc
      ]
   }
}

#declare Pils = union {
   //*PMName Pils
   
   difference {
      //*PMName boite
      
      union {
         //*PMName Boite
         
         torus {
            1.05, 0.05
            scale 1
            rotate <0, 0, 0>
            translate y*3.8
            
            texture {
               MetalPils
            }
         }
         //*PMRawBegin
         sor {
            4,
         <0, 100>,
         <1.2, 3.5>,
         <1.1, 3.8>,
         <0, 0>
            
         }
         //*PMRawEnd
         
         cylinder {
            <0, 3.5, 0>, <0, 0.3, 0>, 1.2
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         torus {
            0.9, 0.3
            scale 1
            rotate <0, 0, 0>
            translate y*0.3
         }
         
         cylinder {
            //*PMName Etiquette
            <0, 1, 0>, <0, 0, 0>, 1.2001
            
            texture {
               Etiquette
            }
            scale <1, 3, 1>
            rotate y*(-142)
            translate y*0.5
            no_shadow
            hollow false
         }
         
         texture {
            MetalPilsBlanc
         }
      }
      
      cylinder {
         <0, 3.7, 0>, <0, 3.9, 0>, 1.05
         
         texture {
            MetalPils
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 3.5, 0>, <0, 3.85, 0>, 0.3
         
         pigment {
            color rgb <0, 0, 0>
         }
         scale <0.9, 1, 1>
         translate z*(-0.37)
         rotate y*110
      }
   }
   
   difference {
      //*PMName Couvercle
      
      sphere {
         <0, 0, 0>, 0.97
         scale <1, 0.1, 1>
         rotate <0, 0, 0>
         translate y*3.7
      }
      
      difference {
         cylinder {
            <0, 3.5, 0>, <0, 3.85, 0>, 0.3
            scale <0.9, 1, 1>
            rotate <0, 0, 0>
            translate z*(-0.37)
         }
         
         box {
            <-0.15, 3.5, -0.066309>, <0.15, 3.851, -0.12>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         rotate y*110
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
   }
   
   cylinder {
      <0, 0, 0>, <0, 0.03, 0>, 0.1
      scale 1
      rotate <0, 0, 0>
      translate y*3.8
   }
   
   difference {
      //*PMName Goupille
      
      union {
         //*PMName Goupille
         
         box {
            <-0.19, 0, 0.5>, <0.19, 0.02, 0.03>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.15, 0, 0.03>, <0.15, 0.02, -0.1>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, 0>, <0, 0.02, 0>, 0.08
            scale 1
            rotate <0, 0, 0>
            translate <-0.11, 0, 0.03>
         }
         
         cylinder {
            <0, 0, 0>, <0, 0.02, 0>, 0.08
            scale 1
            rotate <0, 0, 0>
            translate <0.11, 0, 0.03>
         }
         
         cylinder {
            <0, 0, 0>, <0, 0.02, 0>, 0.18
            scale <1, 1, 0.2>
            rotate <0, 0, 0>
            translate z*0.5
         }
         translate z*(-0.11)
      }
      
      cylinder {
         <0, -0.0001, 0>, <0, 0.0201, 0>, 0.14
         scale 1
         rotate <0, 0, 0>
         translate z*0.26
      }
      
      box {
         <-0.1, -0.0001, -0.1>, <0.1, 0.0201, 0.1>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         MetalPils
      }
      scale <1.4, 1, 1.4>
      rotate <-40, 110, 0>
      translate y*3.8
   }
   
   texture {
      MetalPils
   }
}

#declare Pils2 = union {
   //*PMName Pils
   
   difference {
      //*PMName boite
      
      union {
         //*PMName Boite
         
         torus {
            1.05, 0.05
            
            texture {
               MetalPils
            }
            scale 1
            rotate <0, 0, 0>
            translate y*3.8
         }
         //*PMRawBegin
         sor {
            4,
         <0, 100>,
         <1.2, 3.5>,
         <1.1, 3.8>,
         <0, 0>
            
         }
         //*PMRawEnd
         
         cylinder {
            <0, 3.5, 0>, <0, 0.3, 0>, 1.2
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         torus {
            0.9, 0.3
            scale 1
            rotate <0, 0, 0>
            translate y*0.3
         }
         
         cylinder {
            //*PMName Etiquette
            <0, 1, 0>, <0, 0, 0>, 1.2001
            
            texture {
               Etiquette
            }
            scale <1, 3, 1>
            rotate y*(-142)
            translate y*0.5
            no_shadow
            hollow false
         }
         
         texture {
            MetalPilsBlanc
         }
      }
      
      cylinder {
         <0, 3.7, 0>, <0, 3.9, 0>, 1.05
         
         texture {
            MetalPils
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 3.5, 0>, <0, 3.85, 0>, 0.3
         
         pigment {
            color rgb <0, 0, 0>
         }
         scale <0.9, 1, 1>
         translate z*(-0.37)
         rotate y*290
      }
   }
   
   difference {
      //*PMName Couvercle
      
      sphere {
         <0, 0, 0>, 0.97
         scale <1, 0.1, 1>
         rotate <0, 0, 0>
         translate y*3.7
      }
      
      difference {
         cylinder {
            <0, 3.5, 0>, <0, 3.85, 0>, 0.3
            scale <0.9, 1, 1>
            rotate <0, 0, 0>
            translate z*(-0.37)
         }
         
         box {
            <-0.15, 3.5, -0.066309>, <0.15, 3.851, -0.12>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         rotate y*290
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
   }
   
   cylinder {
      <0, 0, 0>, <0, 0.03, 0>, 0.1
      scale 1
      rotate <0, 0, 0>
      translate y*3.8
   }
   
   difference {
      //*PMName Goupille
      
      union {
         //*PMName Goupille
         
         box {
            <-0.19, 0, 0.5>, <0.19, 0.02, 0.03>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.15, 0, 0.03>, <0.15, 0.02, -0.1>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, 0>, <0, 0.02, 0>, 0.08
            scale 1
            rotate <0, 0, 0>
            translate <-0.11, 0, 0.03>
         }
         
         cylinder {
            <0, 0, 0>, <0, 0.02, 0>, 0.08
            scale 1
            rotate <0, 0, 0>
            translate <0.11, 0, 0.03>
         }
         
         cylinder {
            <0, 0, 0>, <0, 0.02, 0>, 0.18
            scale <1, 1, 0.2>
            rotate <0, 0, 0>
            translate z*0.5
         }
         translate z*(-0.11)
      }
      
      cylinder {
         <0, -0.0001, 0>, <0, 0.0201, 0>, 0.14
         scale 1
         rotate <0, 0, 0>
         translate z*0.26
      }
      
      box {
         <-0.1, -0.0001, -0.1>, <0.1, 0.0201, 0.1>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         MetalPils
      }
      scale <1.4, 1, 1.4>
      rotate <-5, 290, 0>
      translate y*3.8
   }
   
   texture {
      MetalPils
   }
}

#declare RatGrim = union {
   //*PMName Pils&Rats
   
   union {
      //*PMName RatGrim
      
      object {
         //*PMName Pils
         Pils2
         scale 1.4
         rotate y*(-20)
         translate <-16.186, 0, 0.879672>
      }
      
      union {
         //*PMName Rat
         //*PMRawBegin
         #include "grimrat.pov"
         object {
            //*PMName RatGrim
            GrimRat
            
            texture {
               PeauGrise
            }
         }
         
         object {
            //*PMName Bras
            GrimBras
            
            texture {
               PeauGrise
            }
         }
         
         object {
            //*PMName Queue
            GrimQueue
            
            texture {
               PeauRose
            }
         }
         //*PMRawEnd
         rotate <0, -90, -90>
         translate <-15.0655, 4.14997, 0.847978>
      }
      rotate z*10
      translate <1.21257, 3.03682, -0.268295>
   }
   
   object {
      //*PMName Pils
      Pils
      scale 1.4
      rotate <-15.7, -0, 90>
      translate <-13.1438, 1.68256, 5.21157>
   }
}

// Bidon
#declare Rouge = texture {
   pigment {
      bozo
      turbulence <3, 2, 1>
      lambda 4
      scale 5
      
      color_map {
         [ 0 color rgb <0.756863, 0.207843, 0.207843>
         ]
         [ 0.9 color rgb <0.756863, 0.345098, 0.192157>
         ]
      }
   }
   
   normal {
      bumps
      turbulence <0.2, 0.2, 0.2>
      scale 4
      bump_size 0.2
   }
   
   finish {
      specular 0.5
      roughness 0.07
   }
}

#declare BidonMetal = texture {
   bumps
   turbulence <0.7, 0.7, 0.9>
   
   texture_map {
      [ 0 bumps
      turbulence <0.5, 0.5, 0.5>
      omega 0.1
      
      texture_map {
         [ 0 pigment {
            color rgb <0.635294, 0.635294, 0.635294>
         }
         
         finish {
            specular 3
            roughness 0.09
         }
         ]
         [ 0.5 pigment {
            color rgb <0.635294, 0.635294, 0.635294>
         }
         
         finish {
            specular 4
            roughness 0.1
         }
         ]
      }
      ]
      [ 0.2 Rouille
      ]
   }
}

#declare Bidon = union {
   //*PMName Bidon
   
   difference {
      //*PMName principal
      
      union {
         box {
            <-6, -2, -3>, <6, 2, 3>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-6, 0, 0>, <6, 0, 0>, 2
            scale 1
            rotate <0, 0, 0>
            translate z*(-3)
         }
         
         cylinder {
            <-6, 0, 0>, <6, 0, 0>, 2
            scale 1
            rotate <0, 0, 0>
            translate z*3
         }
         
         texture {
            Rouge
         }
      }
      
      union {
         box {
            <5.75, -2, -3>, <6, 2, 3>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <5.75, 0, 0>, <6, 0, 0>, 2
            scale 1
            rotate <0, 0, 0>
            translate z*(-3)
         }
         
         cylinder {
            <5.75, 0, 0>, <6, 0, 0>, 2
            scale 1
            rotate <0, 0, 0>
            translate z*3
         }
         scale <1, 0.985, 0.985>
         translate x*0.01
         
         texture {
            BidonMetal
         }
      }
   }
   
   union {
      //*PMName Bouchon
      
      cylinder {
         <6.5, 0, 0>, <5.74, 0, 0>, 0.9
         
         texture {
            BidonMetal
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      difference {
         cylinder {
            <6.5, 0, 0>, <5.85, 0, 0>, 0.95
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         torus {
            0.99, 0.07
            scale 1
            rotate <5, 5, 90>
            translate x*6.35
         }
         
         torus {
            0.99, 0.07
            scale 1
            rotate <5, 5, 90>
            translate x*6.2
         }
         
         torus {
            0.99, 0.07
            scale 1
            rotate <5, 5, 90>
            translate x*6.05
         }
      }
      
      sphere {
         <0, 0, 0>, 0.95
         scale <0.1, 1, 1>
         rotate <0, 0, 0>
         translate x*6.5
      }
      translate z*(-3)
      
      texture {
         Rouge
      }
   }
}

// Bouteille
#declare VerreBrunold = material {
   interior {
      ior 1.5
      fade_distance 1
      fade_distance 1
   }
   
   texture {
      pigment {
         color rgbf <0.25882, 0.12549, 0.12549, 0.7>
      }
      
      finish {
         diffuse 0.4
         specular 0.8
         roughness 0.001
         
         reflection {
            rgb <0.145098, 0.0705882, 0.0705882>, rgb <0.25098, 0.121569, 0.121569>
         }
      }
   }
}

#declare VerreBrun = material {
   interior {
      ior 1.5
      fade_distance 1
      fade_distance 1
   }
   
   texture {
      bumps
      turbulence <1, 1, 1>
      
      texture_map {
         [ 0 pigment {
            color rgbf <0.25882, 0.12549, 0.12549, 0.7>
         }
         
         finish {
            diffuse 0.4
            specular 0.8
            roughness 0.001
            
            reflection {
               rgb <0.145098, 0.0705882, 0.0705882>, rgb <0.25098, 0.121569, 0.121569>
            }
         }
         ]
         [ 0.95 pigment {
            color rgbf <0.52157, 0.45098, 0.43137, 0.1>
         }
         
         finish {
            diffuse 0.4
            crand 0.05
         }
         ]
      }
   }
}

#declare BouteilleVerre = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3, -9, 0>, <3, -9, 0.889442>, <2.75025, -9, 1.49239>, <2.12132, -9, 2.12132>,
      <3.07123, -5.80019, 0>, <3.07123, -5.80019, 0.889442>, <2.80062, -5.80019, 1.54276>, <2.17169, -5.80019, 2.17169>,
      <3.29086, -2.56483, 0>, <3.29086, -2.56483, 0.834208>, <2.91686, -2.56483, 1.73711>, <2.32699, -2.56483, 2.32699>,
      <2.8137, 0.6, 0>, <2.8137, 0.6, 0.834208>, <2.57946, 0.6, 1.39971>, <1.98959, 0.6, 1.98959>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3, -9, 0>, <3, -9, -0.889442>, <2.75025, -9, -1.49239>, <2.12132, -9, -2.12132>,
      <3.07123, -5.80019, 0>, <3.07123, -5.80019, -0.889442>, <2.80062, -5.80019, -1.54276>, <2.17169, -5.80019, -2.17169>,
      <3.29086, -2.56483, 0>, <3.29086, -2.56483, -0.834208>, <2.91686, -2.56483, -1.73712>, <2.32699, -2.56483, -2.32699>,
      <2.8137, 0.6, 0>, <2.8137, 0.6, -0.834208>, <2.57946, 0.6, -1.39971>, <1.98959, 0.6, -1.98959>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3, -9, 0>, <3, -9, 0.889442>, <2.75025, -9, 1.49239>, <2.12132, -9, 2.12132>,
      <2.99703, -9.1333, 0>, <2.99703, -9.1333, 0.889442>, <2.74815, -9.1333, 1.49029>, <2.11922, -9.1333, 2.11922>,
      <2.60649, -9.13317, 0>, <2.60649, -9.13317, 0.77085>, <2.38814, -9.13317, 1.29799>, <1.84307, -9.13317, 1.84307>,
      <2.6, -9, 0>, <2.6, -9, 0.77085>, <2.38355, -9, 1.2934>, <1.83848, -9, 1.83848>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3, -9, 0>, <3, -9, -0.889442>, <2.75025, -9, -1.49239>, <2.12132, -9, -2.12132>,
      <2.99703, -9.1333, 0>, <2.99703, -9.1333, -0.889442>, <2.74815, -9.1333, -1.49029>, <2.11922, -9.1333, -2.11922>,
      <2.60649, -9.13317, 0>, <2.60649, -9.13317, -0.77085>, <2.38814, -9.13317, -1.29799>, <1.84306, -9.13318, -1.84307>,
      <2.6, -9, 0>, <2.6, -9, -0.77085>, <2.38355, -9, -1.2934>, <1.83848, -9, -1.83848>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.8137, 0.6, 0>, <2.8137, 0.6, 0.834208>, <2.57946, 0.6, 1.39971>, <1.98959, 0.6, 1.98959>,
      <2.62313, 1.864, 0>, <2.62313, 1.864, 0.834208>, <2.44471, 1.864, 1.26496>, <1.85483, 1.864, 1.85483>,
      <1.43635, 2.78472, 0>, <1.43635, 2.78472, 0.30834>, <1.23368, 2.78472, 0.797625>, <1.01565, 2.78472, 1.01565>,
      <1.04, 4, 0>, <1.04, 4, 0.30834>, <0.95342, 4, 0.517362>, <0.735391, 4, 0.735391>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.8137, 0.6, 0>, <2.8137, 0.6, -0.834208>, <2.57946, 0.6, -1.39971>, <1.98959, 0.6, -1.98959>,
      <2.62313, 1.864, 0>, <2.62313, 1.864, -0.834208>, <2.44471, 1.864, -1.26496>, <1.85483, 1.864, -1.85483>,
      <1.43635, 2.78472, 0>, <1.43635, 2.78472, -0.30834>, <1.23368, 2.78472, -0.797625>, <1.01565, 2.78472, -1.01565>,
      <1.04, 4, 0>, <1.04, 4, -0.30834>, <0.95342, 4, -0.517362>, <0.735391, 4, -0.735391>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.04, 4, 0>, <1.04, 4, 0.30834>, <0.95342, 4, 0.517362>, <0.735391, 4, 0.735391>,
      <0.873972, 4.50907, 0>, <0.873972, 4.50907, 0.30834>, <0.836021, 4.50907, 0.399962>, <0.617992, 4.50907, 0.617992>,
      <1.19949, 5.06479, 0>, <1.19949, 5.0648, 0.350737>, <1.09618, 5.0648, 0.600161>, <0.848169, 5.06479, 0.848169>,
      <1.183, 5.6, 0>, <1.183, 5.6, 0.350737>, <1.08452, 5.6, 0.588499>, <0.836507, 5.6, 0.836507>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.04, 4, 0>, <1.04, 4, -0.30834>, <0.95342, 4, -0.517362>, <0.735391, 4, -0.735391>,
      <0.873972, 4.50907, 0>, <0.873972, 4.50907, -0.30834>, <0.836021, 4.50907, -0.399962>, <0.617992, 4.50907, -0.617992>,
      <1.19949, 5.06479, 0>, <1.19949, 5.0648, -0.350737>, <1.09618, 5.0648, -0.600161>, <0.848169, 5.06479, -0.848169>,
      <1.183, 5.6, 0>, <1.183, 5.6, -0.350737>, <1.08452, 5.6, -0.588499>, <0.836507, 5.6, -0.836507>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.183, 5.6, 0>, <1.183, 5.6, 0.350737>, <1.08452, 5.6, 0.588499>, <0.836507, 5.6, 0.836507>,
      <1.17147, 5.97416, 0>, <1.17147, 5.97416, 0.350737>, <1.07636, 5.97416, 0.580346>, <0.828355, 5.97416, 0.828355>,
      <1.00103, 6.32828, 0>, <1.00103, 6.32828, 0.283673>, <0.908425, 6.32828, 0.507251>, <0.707838, 6.32828, 0.707838>,
      <0.9568, 6.7, 0>, <0.9568, 6.7, 0.283673>, <0.877147, 6.7, 0.475973>, <0.67656, 6.7, 0.67656>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.183, 5.6, 0>, <1.183, 5.6, -0.350737>, <1.08452, 5.6, -0.588499>, <0.836507, 5.6, -0.836507>,
      <1.17147, 5.97416, 0>, <1.17147, 5.97416, -0.350737>, <1.07636, 5.97416, -0.580346>, <0.828354, 5.97416, -0.828355>,
      <1.00103, 6.32828, 0>, <1.00103, 6.32828, -0.283673>, <0.908425, 6.32828, -0.507251>, <0.707838, 6.32828, -0.707838>,
      <0.9568, 6.7, 0>, <0.9568, 6.7, -0.283673>, <0.877147, 6.7, -0.475973>, <0.67656, 6.7, -0.67656>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.9568, 6.7, 0>, <0.9568, 6.7, 0.283673>, <0.877147, 6.7, 0.475973>, <0.67656, 6.7, 0.67656>,
      <0.921347, 6.99792, 0>, <0.921347, 6.99792, 0.283673>, <0.852078, 6.99792, 0.450904>, <0.651491, 6.99792, 0.651491>,
      <0.935949, 7.30011, 0>, <0.935949, 7.30011, 0.280174>, <0.859929, 7.30011, 0.463703>, <0.661816, 7.30011, 0.661816>,
      <0.945, 7.6, 0>, <0.945, 7.6, 0.280174>, <0.866329, 7.6, 0.470103>, <0.668216, 7.6, 0.668216>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.9568, 6.7, 0>, <0.9568, 6.7, -0.283673>, <0.877147, 6.7, -0.475973>, <0.67656, 6.7, -0.67656>,
      <0.921347, 6.99792, 0>, <0.921347, 6.99792, -0.283673>, <0.852078, 6.99792, -0.450904>, <0.651491, 6.99792, -0.651491>,
      <0.935949, 7.30011, 0>, <0.935949, 7.30011, -0.280174>, <0.859929, 7.30011, -0.463703>, <0.661816, 7.30011, -0.661816>,
      <0.945, 7.6, 0>, <0.945, 7.6, -0.280174>, <0.866329, 7.6, -0.470103>, <0.668216, 7.6, -0.668216>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.945, 7.6, 0>, <0.945, 7.6, 0.280174>, <0.866329, 7.6, 0.470103>, <0.668216, 7.6, 0.668216>,
      <0.947062, 7.6683, 0>, <0.947062, 7.6683, 0.280174>, <0.867787, 7.6683, 0.471561>, <0.669674, 7.6683, 0.669674>,
      <0.997639, 7.7321, 0>, <0.997639, 7.7321, 0.293516>, <0.912985, 7.7321, 0.49789>, <0.705438, 7.7321, 0.705438>,
      <0.99, 7.8, 0>, <0.99, 7.8, 0.293516>, <0.907583, 7.8, 0.492489>, <0.700036, 7.8, 0.700036>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.945, 7.6, 0>, <0.945, 7.6, -0.280174>, <0.866329, 7.6, -0.470103>, <0.668216, 7.6, -0.668216>,
      <0.947062, 7.6683, 0>, <0.947062, 7.6683, -0.280174>, <0.867787, 7.6683, -0.471561>, <0.669674, 7.6683, -0.669674>,
      <0.997639, 7.7321, 0>, <0.997639, 7.7321, -0.293516>, <0.912985, 7.7321, -0.49789>, <0.705437, 7.7321, -0.705438>,
      <0.99, 7.8, 0>, <0.99, 7.8, -0.293516>, <0.907583, 7.8, -0.492489>, <0.700036, 7.8, -0.700036>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.99, 7.8, 0>, <0.99, 7.8, 0.293516>, <0.907583, 7.8, 0.492489>, <0.700036, 7.8, 0.700036>,
      <0.981827, 7.87265, 0>, <0.981827, 7.87265, 0.293516>, <0.901804, 7.87265, 0.486709>, <0.694257, 7.87265, 0.694257>,
      <0.911596, 8.07218, 0>, <0.911596, 8.07218, 0.266833>, <0.846289, 7.93333, 0.46893>, <0.657609, 7.93333, 0.657609>,
      <0.9, 8, 0>, <0.9, 8, 0.266833>, <0.825075, 8, 0.447717>, <0.636396, 8, 0.636396>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.99, 7.8, 0>, <0.99, 7.8, -0.293516>, <0.907583, 7.8, -0.492489>, <0.700036, 7.8, -0.700036>,
      <0.981827, 7.87265, 0>, <0.981827, 7.87265, -0.293516>, <0.901804, 7.87265, -0.48671>, <0.694257, 7.87265, -0.694257>,
      <0.911596, 8.07218, 0>, <0.911596, 8.07218, -0.266833>, <0.846288, 7.93333, -0.46893>, <0.657609, 7.93333, -0.657609>,
      <0.9, 8, 0>, <0.9, 8, -0.266833>, <0.825075, 8, -0.447717>, <0.636396, 8, -0.636396>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.08836, 5.6, 0>, <1.08836, 5.6, 0.322678>, <0.997754, 5.6, 0.541419>, <0.769587, 5.6, 0.769587>,
      <1.11269, 5.06481, 0>, <1.11269, 5.06481, 0.322678>, <0.961843, 5.06667, 0.505507>, <0.733675, 5.06667, 0.733675>,
      <0.787354, 4.51471, 0>, <0.787354, 4.51471, 0.277506>, <0.75297, 4.51471, 0.360517>, <0.556744, 4.51471, 0.556744>,
      <0.936, 4, 0>, <0.936, 4, 0.277506>, <0.858078, 4, 0.465626>, <0.661852, 4, 0.661852>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.08836, 5.6, 0>, <1.08836, 5.6, -0.322678>, <0.997754, 5.6, -0.541419>, <0.769586, 5.6, -0.769587>,
      <1.11269, 5.06481, 0>, <1.11269, 5.06481, -0.322678>, <0.961843, 5.06667, -0.505507>, <0.733675, 5.06667, -0.733675>,
      <0.787354, 4.51471, 0>, <0.787354, 4.51471, -0.277506>, <0.75297, 4.51471, -0.360517>, <0.556743, 4.51471, -0.556744>,
      <0.936, 4, 0>, <0.936, 4, -0.277506>, <0.858078, 4, -0.465626>, <0.661852, 4, -0.661852>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.936, 4, 0>, <0.936, 4, 0.277506>, <0.858078, 4, 0.465626>, <0.661852, 4, 0.661852>,
      <1.28338, 2.79712, 0>, <1.28338, 2.79712, 0.277506>, <1.10372, 2.79712, 0.711263>, <0.907489, 2.79712, 0.907489>,
      <2.37337, 1.8419, 0>, <2.37337, 1.8419, 0.750787>, <2.20911, 1.8419, 1.14734>, <1.67822, 1.8419, 1.67822>,
      <2.53233, 0.6, 0>, <2.53233, 0.6, 0.750787>, <2.32151, 0.6, 1.25974>, <1.79063, 0.6, 1.79063>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.936, 4, 0>, <0.936, 4, -0.277506>, <0.858078, 4, -0.465626>, <0.661852, 4, -0.661852>,
      <1.28338, 2.79712, 0>, <1.28338, 2.79712, -0.277506>, <1.10372, 2.79712, -0.711263>, <0.907489, 2.79712, -0.907489>,
      <2.37337, 1.8419, 0>, <2.37337, 1.8419, -0.750787>, <2.20911, 1.8419, -1.14734>, <1.67822, 1.8419, -1.67822>,
      <2.53233, 0.6, 0>, <2.53233, 0.6, -0.750787>, <2.32151, 0.6, -1.25974>, <1.79063, 0.6, -1.79063>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.53233, 0.6, 0>, <2.53233, 0.6, 0.750787>, <2.32151, 0.6, 1.25974>, <1.79063, 0.6, 1.79063>,
      <2.93863, -2.57418, 0>, <2.93863, -2.57418, 0.750787>, <2.60881, -2.57418, 1.54704>, <2.07792, -2.57418, 2.07792>,
      <2.44429, -5.80371, 0>, <2.44429, -5.80371, 0.77085>, <2.27345, -5.80371, 1.1833>, <1.72837, -5.80371, 1.72837>,
      <2.6, -9, 0>, <2.6, -9, 0.77085>, <2.38355, -9, 1.2934>, <1.83848, -9, 1.83848>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.53233, 0.6, 0>, <2.53233, 0.6, -0.750787>, <2.32151, 0.6, -1.25974>, <1.79063, 0.6, -1.79063>,
      <2.93863, -2.57418, 0>, <2.93863, -2.57418, -0.750787>, <2.60881, -2.57418, -1.54704>, <2.07792, -2.57418, -2.07792>,
      <2.44429, -5.80371, 0>, <2.44429, -5.80371, -0.77085>, <2.27345, -5.80371, -1.1833>, <1.72837, -5.80371, -1.72837>,
      <2.6, -9, 0>, <2.6, -9, -0.77085>, <2.38355, -9, -1.2934>, <1.83848, -9, -1.83848>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.769587, 5.6, 0.769587>, <0.541419, 5.6, 0.997754>, <0.322678, 5.6, 1.08836>, <-4.75737e-08, 5.6, 1.08836>,
      <0.733675, 5.06667, 0.733675>, <0.505507, 5.06667, 0.961843>, <0.322678, 5.06667, 1.03757>, <-4.53538e-08, 5.06667, 1.03757>,
      <0.556744, 4.51471, 0.556744>, <0.360517, 4.51471, 0.75297>, <0.277506, 4.51471, 0.787354>, <-3.44164e-08, 4.51471, 0.787354>,
      <0.661852, 4, 0.661852>, <0.465626, 4, 0.858078>, <0.277506, 4, 0.936>, <-4.09139e-08, 4, 0.936>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.661852, 4, 0.661852>, <0.465626, 4, 0.858078>, <0.277506, 4, 0.936>, <-4.09139e-08, 4, 0.936>,
      <0.907489, 2.79712, 0.907489>, <0.711263, 2.79712, 1.10372>, <0.277506, 2.79712, 1.28338>, <-5.60985e-08, 2.79712, 1.28338>,
      <1.67822, 1.8419, 1.67822>, <1.14734, 1.8419, 2.20911>, <0.750787, 1.8419, 2.37337>, <-1.03743e-07, 1.8419, 2.37337>,
      <1.79063, 0.6, 1.79063>, <1.25974, 0.6, 2.32151>, <0.750787, 0.6, 2.53233>, <-1.10692e-07, 0.6, 2.53233>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.79063, 0.6, 1.79063>, <1.25974, 0.6, 2.32151>, <0.750787, 0.6, 2.53233>, <-1.10692e-07, 0.6, 2.53233>,
      <2.07792, -2.57418, 2.07792>, <1.54704, -2.57418, 2.60881>, <0.750787, -2.57418, 2.93863>, <-1.28451e-07, -2.57418, 2.93863>,
      <1.72837, -5.80371, 1.72837>, <1.1833, -5.80371, 2.27345>, <0.77085, -5.80371, 2.44429>, <-1.06843e-07, -5.80371, 2.44429>,
      <1.83848, -9, 1.83848>, <1.2934, -9, 2.38355>, <0.77085, -9, 2.6>, <-1.1365e-07, -9, 2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.83848, -9, 1.83848>, <1.2934, -9, 2.38355>, <0.77085, -9, 2.6>, <-1.1365e-07, -9, 2.6>,
      <1.84307, -9.13317, 1.84307>, <1.29799, -9.13317, 2.38814>, <0.77085, -9.13317, 2.60649>, <-1.13933e-07, -9.13317, 2.60649>,
      <2.11922, -9.1333, 2.11922>, <1.49029, -9.1333, 2.74815>, <0.889442, -9.1333, 2.99703>, <-1.31004e-07, -9.1333, 2.99703>,
      <2.12132, -9, 2.12132>, <1.49239, -9, 2.75025>, <0.889442, -9, 3>, <-1.31134e-07, -9, 3>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.12132, -9, 2.12132>, <1.49239, -9, 2.75025>, <0.889442, -9, 3>, <-1.31134e-07, -9, 3>,
      <2.17169, -5.80019, 2.17169>, <1.54276, -5.80019, 2.80062>, <0.889442, -5.80019, 3.07123>, <-1.34248e-07, -5.80019, 3.07123>,
      <2.32699, -2.56483, 2.32699>, <1.73711, -2.56483, 2.91686>, <0.834208, -2.56483, 3.29086>, <-1.43848e-07, -2.56483, 3.29086>,
      <1.98959, 0.6, 1.98959>, <1.39971, 0.6, 2.57946>, <0.834208, 0.6, 2.8137>, <-1.22991e-07, 0.6, 2.8137>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.98959, 0.6, 1.98959>, <1.39971, 0.6, 2.57946>, <0.834208, 0.6, 2.8137>, <-1.22991e-07, 0.6, 2.8137>,
      <1.85483, 1.864, 1.85483>, <1.26496, 1.864, 2.44471>, <0.834208, 1.864, 2.62313>, <-1.14661e-07, 1.864, 2.62313>,
      <1.01565, 2.78472, 1.01565>, <0.797625, 2.78472, 1.23368>, <0.30834, 2.78472, 1.43635>, <-6.27849e-08, 2.78472, 1.43635>,
      <0.735391, 4, 0.735391>, <0.517362, 4, 0.95342>, <0.30834, 4, 1.04>, <-4.54598e-08, 4, 1.04>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.735391, 4, 0.735391>, <0.517362, 4, 0.95342>, <0.30834, 4, 1.04>, <-4.54598e-08, 4, 1.04>,
      <0.617992, 4.50907, 0.617992>, <0.399962, 4.50907, 0.836021>, <0.30834, 4.50907, 0.873972>, <-3.82025e-08, 4.50907, 0.873972>,
      <0.848169, 5.06479, 0.848169>, <0.600161, 5.0648, 1.09618>, <0.350737, 5.0648, 1.19949>, <-5.24315e-08, 5.06479, 1.19949>,
      <0.836507, 5.6, 0.836507>, <0.588499, 5.6, 1.08452>, <0.350737, 5.6, 1.183>, <-5.17106e-08, 5.6, 1.183>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.836507, 5.6, 0.836507>, <0.588499, 5.6, 1.08452>, <0.350737, 5.6, 1.183>, <-5.17106e-08, 5.6, 1.183>,
      <0.828355, 5.97416, 0.828355>, <0.580346, 5.97416, 1.07636>, <0.350737, 5.97416, 1.17147>, <-5.12066e-08, 5.97416, 1.17147>,
      <0.707838, 6.32828, 0.707838>, <0.507251, 6.32828, 0.908425>, <0.283673, 6.32828, 1.00103>, <-4.37566e-08, 6.32828, 1.00103>,
      <0.67656, 6.7, 0.67656>, <0.475973, 6.7, 0.877147>, <0.283673, 6.7, 0.9568>, <-4.18231e-08, 6.7, 0.9568>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.67656, 6.7, 0.67656>, <0.475973, 6.7, 0.877147>, <0.283673, 6.7, 0.9568>, <-4.18231e-08, 6.7, 0.9568>,
      <0.651491, 6.99792, 0.651491>, <0.450904, 6.99792, 0.852078>, <0.283673, 6.99792, 0.921347>, <-4.02734e-08, 6.99792, 0.921347>,
      <0.661816, 7.30011, 0.661816>, <0.463703, 7.30011, 0.859929>, <0.280174, 7.30011, 0.935949>, <-4.09116e-08, 7.30011, 0.935949>,
      <0.668216, 7.6, 0.668216>, <0.470103, 7.6, 0.866329>, <0.280174, 7.6, 0.945>, <-4.13073e-08, 7.6, 0.945>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.668216, 7.6, 0.668216>, <0.470103, 7.6, 0.866329>, <0.280174, 7.6, 0.945>, <-4.13073e-08, 7.6, 0.945>,
      <0.669674, 7.6683, 0.669674>, <0.47156, 7.6683, 0.867787>, <0.280174, 7.6683, 0.947062>, <-4.13974e-08, 7.6683, 0.947062>,
      <0.705438, 7.7321, 0.705438>, <0.49789, 7.7321, 0.912985>, <0.293516, 7.7321, 0.997639>, <-4.36082e-08, 7.7321, 0.997639>,
      <0.700036, 7.8, 0.700036>, <0.492489, 7.8, 0.907583>, <0.293516, 7.8, 0.99>, <-4.32743e-08, 7.8, 0.99>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.700036, 7.8, 0.700036>, <0.492489, 7.8, 0.907583>, <0.293516, 7.8, 0.99>, <-4.32743e-08, 7.8, 0.99>,
      <0.694257, 7.87265, 0.694257>, <0.486709, 7.87265, 0.901804>, <0.293516, 7.87265, 0.981827>, <-4.2917e-08, 7.87265, 0.981827>,
      <0.657609, 7.93333, 0.657609>, <0.46893, 7.93333, 0.846289>, <0.266833, 7.93333, 0.93>, <-4.06516e-08, 7.93333, 0.93>,
      <0.636396, 8, 0.636396>, <0.447717, 8, 0.825075>, <0.266833, 8, 0.9>, <-3.93403e-08, 8, 0.9>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-4.75737e-08, 5.6, 1.08836>, <-0.322678, 5.6, 1.08836>, <-0.541419, 5.6, 0.997754>, <-0.769587, 5.6, 0.769587>,
      <-4.53538e-08, 5.06667, 1.03757>, <-0.322678, 5.06667, 1.03757>, <-0.505507, 5.06667, 0.961843>, <-0.733675, 5.06667, 0.733675>,
      <-3.44164e-08, 4.51471, 0.787354>, <-0.277506, 4.51471, 0.787354>, <-0.360517, 4.51471, 0.75297>, <-0.556744, 4.51471, 0.556744>,
      <-4.09139e-08, 4, 0.936>, <-0.277506, 4, 0.936>, <-0.465626, 4, 0.858078>, <-0.661852, 4, 0.661852>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-4.09139e-08, 4, 0.936>, <-0.277506, 4, 0.936>, <-0.465626, 4, 0.858078>, <-0.661852, 4, 0.661852>,
      <-5.60985e-08, 2.79712, 1.28338>, <-0.277506, 2.79712, 1.28338>, <-0.711263, 2.79712, 1.10372>, <-0.907489, 2.79712, 0.907489>,
      <-1.03743e-07, 1.8419, 2.37337>, <-0.750787, 1.8419, 2.37337>, <-1.14734, 1.8419, 2.20911>, <-1.67822, 1.8419, 1.67822>,
      <-1.10692e-07, 0.6, 2.53233>, <-0.750787, 0.6, 2.53233>, <-1.25974, 0.6, 2.32151>, <-1.79063, 0.6, 1.79063>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.10692e-07, 0.6, 2.53233>, <-0.750787, 0.6, 2.53233>, <-1.25974, 0.6, 2.32151>, <-1.79063, 0.6, 1.79063>,
      <-1.28451e-07, -2.57418, 2.93863>, <-0.750787, -2.57418, 2.93863>, <-1.54704, -2.57418, 2.60881>, <-2.07792, -2.57418, 2.07792>,
      <-1.06843e-07, -5.80371, 2.44429>, <-0.77085, -5.80371, 2.44429>, <-1.1833, -5.80371, 2.27345>, <-1.72837, -5.80371, 1.72837>,
      <-1.1365e-07, -9, 2.6>, <-0.77085, -9, 2.6>, <-1.2934, -9, 2.38355>, <-1.83848, -9, 1.83848>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.1365e-07, -9, 2.6>, <-0.77085, -9, 2.6>, <-1.2934, -9, 2.38355>, <-1.83848, -9, 1.83848>,
      <-1.13933e-07, -9.13317, 2.60649>, <-0.77085, -9.13317, 2.60649>, <-1.29799, -9.13317, 2.38814>, <-1.84307, -9.13317, 1.84307>,
      <-1.31004e-07, -9.1333, 2.99703>, <-0.889442, -9.1333, 2.99703>, <-1.49029, -9.1333, 2.74815>, <-2.11922, -9.1333, 2.11922>,
      <-1.31134e-07, -9, 3>, <-0.889442, -9, 3>, <-1.49239, -9, 2.75025>, <-2.12132, -9, 2.12132>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.31134e-07, -9, 3>, <-0.889442, -9, 3>, <-1.49239, -9, 2.75025>, <-2.12132, -9, 2.12132>,
      <-1.34248e-07, -5.80019, 3.07123>, <-0.889442, -5.80019, 3.07123>, <-1.54276, -5.80019, 2.80062>, <-2.17169, -5.80019, 2.17169>,
      <-1.43848e-07, -2.56483, 3.29086>, <-0.834208, -2.56483, 3.29086>, <-1.73711, -2.56483, 2.91686>, <-2.32699, -2.56483, 2.32699>,
      <-1.22991e-07, 0.6, 2.8137>, <-0.834208, 0.6, 2.8137>, <-1.39971, 0.6, 2.57946>, <-1.98959, 0.6, 1.98959>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.22991e-07, 0.6, 2.8137>, <-0.834208, 0.6, 2.8137>, <-1.39971, 0.6, 2.57946>, <-1.98959, 0.6, 1.98959>,
      <-1.14661e-07, 1.864, 2.62313>, <-0.834208, 1.864, 2.62313>, <-1.26496, 1.864, 2.44471>, <-1.85483, 1.864, 1.85483>,
      <-6.27849e-08, 2.78472, 1.43635>, <-0.30834, 2.78472, 1.43635>, <-0.797625, 2.78472, 1.23368>, <-1.01565, 2.78472, 1.01565>,
      <-4.54598e-08, 4, 1.04>, <-0.30834, 4, 1.04>, <-0.517362, 4, 0.95342>, <-0.735391, 4, 0.735391>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-4.54598e-08, 4, 1.04>, <-0.30834, 4, 1.04>, <-0.517362, 4, 0.95342>, <-0.735391, 4, 0.735391>,
      <-3.82025e-08, 4.50907, 0.873972>, <-0.30834, 4.50907, 0.873972>, <-0.399962, 4.50907, 0.836021>, <-0.617992, 4.50907, 0.617992>,
      <-5.24315e-08, 5.06479, 1.19949>, <-0.350737, 5.0648, 1.19949>, <-0.600161, 5.0648, 1.09618>, <-0.848169, 5.06479, 0.848169>,
      <-5.17106e-08, 5.6, 1.183>, <-0.350737, 5.6, 1.183>, <-0.588499, 5.6, 1.08452>, <-0.836507, 5.6, 0.836507>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-5.17106e-08, 5.6, 1.183>, <-0.350737, 5.6, 1.183>, <-0.588499, 5.6, 1.08452>, <-0.836507, 5.6, 0.836507>,
      <-5.12066e-08, 5.97416, 1.17147>, <-0.350737, 5.97416, 1.17147>, <-0.580346, 5.97416, 1.07636>, <-0.828355, 5.97416, 0.828355>,
      <-4.37566e-08, 6.32828, 1.00103>, <-0.283673, 6.32828, 1.00103>, <-0.507251, 6.32828, 0.908425>, <-0.707838, 6.32828, 0.707838>,
      <-4.18231e-08, 6.7, 0.9568>, <-0.283673, 6.7, 0.9568>, <-0.475973, 6.7, 0.877147>, <-0.67656, 6.7, 0.67656>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-4.18231e-08, 6.7, 0.9568>, <-0.283673, 6.7, 0.9568>, <-0.475973, 6.7, 0.877147>, <-0.67656, 6.7, 0.67656>,
      <-4.02734e-08, 6.99792, 0.921347>, <-0.283673, 6.99792, 0.921347>, <-0.450904, 6.99792, 0.852078>, <-0.651491, 6.99792, 0.651491>,
      <-4.09116e-08, 7.30011, 0.935949>, <-0.280174, 7.30011, 0.935949>, <-0.463703, 7.30011, 0.859929>, <-0.661816, 7.30011, 0.661816>,
      <-4.13073e-08, 7.6, 0.945>, <-0.280174, 7.6, 0.945>, <-0.470103, 7.6, 0.866329>, <-0.668216, 7.6, 0.668216>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-4.13073e-08, 7.6, 0.945>, <-0.280174, 7.6, 0.945>, <-0.470103, 7.6, 0.866329>, <-0.668216, 7.6, 0.668216>,
      <-4.13974e-08, 7.6683, 0.947062>, <-0.280174, 7.6683, 0.947062>, <-0.471561, 7.6683, 0.867787>, <-0.669674, 7.6683, 0.669674>,
      <-4.36082e-08, 7.7321, 0.997639>, <-0.293516, 7.7321, 0.997639>, <-0.49789, 7.7321, 0.912985>, <-0.705438, 7.7321, 0.705438>,
      <-4.32743e-08, 7.8, 0.99>, <-0.293516, 7.8, 0.99>, <-0.492489, 7.8, 0.907583>, <-0.700036, 7.8, 0.700036>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-4.32743e-08, 7.8, 0.99>, <-0.293516, 7.8, 0.99>, <-0.492489, 7.8, 0.907583>, <-0.700036, 7.8, 0.700036>,
      <-4.2917e-08, 7.87265, 0.981827>, <-0.293516, 7.87265, 0.981827>, <-0.486709, 7.87265, 0.901804>, <-0.694257, 7.87265, 0.694257>,
      <-4.06516e-08, 7.93333, 0.93>, <-0.266833, 7.93333, 0.93>, <-0.46893, 7.93333, 0.846288>, <-0.657609, 7.93333, 0.657609>,
      <-3.93403e-08, 8, 0.9>, <-0.266833, 8, 0.9>, <-0.447717, 8, 0.825075>, <-0.636396, 8, 0.636396>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.769587, 5.6, 0.769587>, <-0.997754, 5.6, 0.541419>, <-1.08836, 5.6, 0.322678>, <-1.08836, 5.6, -9.51474e-08>,
      <-0.733675, 5.06667, 0.733675>, <-0.961843, 5.06667, 0.505507>, <-1.03757, 5.06667, 0.322678>, <-1.03757, 5.06667, -9.07075e-08>,
      <-0.556744, 4.51471, 0.556744>, <-0.75297, 4.51471, 0.360517>, <-0.787354, 4.51471, 0.277506>, <-0.787354, 4.51471, -6.88327e-08>,
      <-0.661852, 4, 0.661852>, <-0.858078, 4, 0.465626>, <-0.936, 4, 0.277506>, <-0.936, 4, -8.18277e-08>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.661852, 4, 0.661852>, <-0.858078, 4, 0.465626>, <-0.936, 4, 0.277506>, <-0.936, 4, -8.18277e-08>,
      <-0.907489, 2.79712, 0.907489>, <-1.10372, 2.79712, 0.711263>, <-1.28338, 2.79712, 0.277506>, <-1.28338, 2.79712, -1.12197e-07>,
      <-1.67822, 1.8419, 1.67822>, <-2.20911, 1.8419, 1.14734>, <-2.37337, 1.8419, 0.750787>, <-2.37337, 1.8419, -2.07486e-07>,
      <-1.79063, 0.6, 1.79063>, <-2.32151, 0.6, 1.25974>, <-2.53233, 0.6, 0.750787>, <-2.53233, 0.6, -2.21383e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.79063, 0.6, 1.79063>, <-2.32151, 0.6, 1.25974>, <-2.53233, 0.6, 0.750787>, <-2.53233, 0.6, -2.21383e-07>,
      <-2.07792, -2.57418, 2.07792>, <-2.60881, -2.57418, 1.54704>, <-2.93863, -2.57418, 0.750787>, <-2.93863, -2.57418, -2.56903e-07>,
      <-1.72837, -5.80371, 1.72837>, <-2.27345, -5.80371, 1.1833>, <-2.44429, -5.80371, 0.77085>, <-2.44429, -5.80371, -2.13687e-07>,
      <-1.83848, -9, 1.83848>, <-2.38355, -9, 1.2934>, <-2.6, -9, 0.77085>, <-2.6, -9, -2.27299e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.83848, -9, 1.83848>, <-2.38355, -9, 1.2934>, <-2.6, -9, 0.77085>, <-2.6, -9, -2.27299e-07>,
      <-1.84307, -9.13317, 1.84307>, <-2.38814, -9.13317, 1.29799>, <-2.60649, -9.13317, 0.77085>, <-2.60649, -9.13317, -2.27866e-07>,
      <-2.11922, -9.1333, 2.11922>, <-2.74815, -9.1333, 1.49029>, <-2.99703, -9.1333, 0.889442>, <-2.99703, -9.1333, -2.62009e-07>,
      <-2.12132, -9, 2.12132>, <-2.75025, -9, 1.49239>, <-3, -9, 0.889442>, <-3, -9, -2.62268e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.12132, -9, 2.12132>, <-2.75025, -9, 1.49239>, <-3, -9, 0.889442>, <-3, -9, -2.62268e-07>,
      <-2.17169, -5.80019, 2.17169>, <-2.80062, -5.80019, 1.54276>, <-3.07123, -5.80019, 0.889442>, <-3.07123, -5.80019, -2.68495e-07>,
      <-2.32699, -2.56483, 2.32699>, <-2.91686, -2.56483, 1.73711>, <-3.29086, -2.56483, 0.834208>, <-3.29086, -2.56483, -2.87696e-07>,
      <-1.98959, 0.6, 1.98959>, <-2.57946, 0.6, 1.39971>, <-2.8137, 0.6, 0.834208>, <-2.8137, 0.6, -2.45981e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.98959, 0.6, 1.98959>, <-2.57946, 0.6, 1.39971>, <-2.8137, 0.6, 0.834208>, <-2.8137, 0.6, -2.45981e-07>,
      <-1.85483, 1.864, 1.85483>, <-2.44471, 1.864, 1.26496>, <-2.62313, 1.864, 0.834208>, <-2.62313, 1.864, -2.29321e-07>,
      <-1.01565, 2.78472, 1.01565>, <-1.23368, 2.78472, 0.797624>, <-1.43635, 2.78472, 0.30834>, <-1.43635, 2.78472, -1.2557e-07>,
      <-0.735391, 4, 0.735391>, <-0.95342, 4, 0.517362>, <-1.04, 4, 0.30834>, <-1.04, 4, -9.09197e-08>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.735391, 4, 0.735391>, <-0.95342, 4, 0.517362>, <-1.04, 4, 0.30834>, <-1.04, 4, -9.09197e-08>,
      <-0.617992, 4.50907, 0.617992>, <-0.836021, 4.50907, 0.399962>, <-0.873972, 4.50907, 0.30834>, <-0.873972, 4.50907, -7.64051e-08>,
      <-0.848169, 5.06479, 0.848169>, <-1.09618, 5.0648, 0.600161>, <-1.19949, 5.0648, 0.350737>, <-1.19949, 5.06479, -1.04863e-07>,
      <-0.836507, 5.6, 0.836507>, <-1.08452, 5.6, 0.588499>, <-1.183, 5.6, 0.350737>, <-1.183, 5.6, -1.03421e-07>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.836507, 5.6, 0.836507>, <-1.08452, 5.6, 0.588499>, <-1.183, 5.6, 0.350737>, <-1.183, 5.6, -1.03421e-07>,
      <-0.828355, 5.97416, 0.828355>, <-1.07636, 5.97416, 0.580346>, <-1.17147, 5.97416, 0.350737>, <-1.17147, 5.97416, -1.02413e-07>,
      <-0.707838, 6.32828, 0.707838>, <-0.908425, 6.32828, 0.507251>, <-1.00103, 6.32828, 0.283673>, <-1.00103, 6.32828, -8.75132e-08>,
      <-0.67656, 6.7, 0.67656>, <-0.877147, 6.7, 0.475973>, <-0.9568, 6.7, 0.283673>, <-0.9568, 6.7, -8.36461e-08>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.67656, 6.7, 0.67656>, <-0.877147, 6.7, 0.475973>, <-0.9568, 6.7, 0.283673>, <-0.9568, 6.7, -8.36461e-08>,
      <-0.651491, 6.99792, 0.651491>, <-0.852078, 6.99792, 0.450904>, <-0.921347, 6.99792, 0.283673>, <-0.921347, 6.99792, -8.05467e-08>,
      <-0.661816, 7.30011, 0.661816>, <-0.859929, 7.30011, 0.463703>, <-0.935949, 7.30011, 0.280174>, <-0.935949, 7.30011, -8.18232e-08>,
      <-0.668216, 7.6, 0.668216>, <-0.866329, 7.6, 0.470103>, <-0.945, 7.6, 0.280174>, <-0.945, 7.6, -8.26145e-08>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.668216, 7.6, 0.668216>, <-0.866329, 7.6, 0.470103>, <-0.945, 7.6, 0.280174>, <-0.945, 7.6, -8.26145e-08>,
      <-0.669674, 7.6683, 0.669674>, <-0.867787, 7.6683, 0.47156>, <-0.947062, 7.6683, 0.280174>, <-0.947062, 7.6683, -8.27948e-08>,
      <-0.705438, 7.7321, 0.705438>, <-0.912985, 7.7321, 0.49789>, <-0.997639, 7.7321, 0.293516>, <-0.997639, 7.7321, -8.72164e-08>,
      <-0.700036, 7.8, 0.700036>, <-0.907583, 7.8, 0.492489>, <-0.99, 7.8, 0.293516>, <-0.99, 7.8, -8.65485e-08>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.700036, 7.8, 0.700036>, <-0.907583, 7.8, 0.492489>, <-0.99, 7.8, 0.293516>, <-0.99, 7.8, -8.65485e-08>,
      <-0.694257, 7.87265, 0.694257>, <-0.901804, 7.87265, 0.486709>, <-0.981827, 7.87265, 0.293516>, <-0.981827, 7.87265, -8.5834e-08>,
      <-0.657609, 7.93333, 0.657609>, <-0.846288, 7.93333, 0.46893>, <-0.93, 7.93333, 0.266833>, <-0.93, 7.93333, -8.13032e-08>,
      <-0.636396, 8, 0.636396>, <-0.825075, 8, 0.447717>, <-0.9, 8, 0.266833>, <-0.9, 8, -7.86805e-08>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.08836, 5.6, -9.51474e-08>, <-1.08836, 5.6, -0.322678>, <-0.997754, 5.6, -0.541419>, <-0.769587, 5.6, -0.769587>,
      <-1.03757, 5.06667, -9.07075e-08>, <-1.03757, 5.06667, -0.322678>, <-0.961843, 5.06667, -0.505507>, <-0.733675, 5.06667, -0.733675>,
      <-0.787354, 4.51471, -6.88327e-08>, <-0.787354, 4.51471, -0.277506>, <-0.75297, 4.51471, -0.360517>, <-0.556744, 4.51471, -0.556744>,
      <-0.936, 4, -8.18277e-08>, <-0.936, 4, -0.277506>, <-0.858078, 4, -0.465626>, <-0.661852, 4, -0.661852>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.936, 4, -8.18277e-08>, <-0.936, 4, -0.277506>, <-0.858078, 4, -0.465626>, <-0.661852, 4, -0.661852>,
      <-1.28338, 2.79712, -1.12197e-07>, <-1.28338, 2.79712, -0.277506>, <-1.10372, 2.79712, -0.711263>, <-0.907489, 2.79712, -0.907489>,
      <-2.37337, 1.8419, -2.07486e-07>, <-2.37337, 1.8419, -0.750787>, <-2.20911, 1.8419, -1.14734>, <-1.67822, 1.8419, -1.67822>,
      <-2.53233, 0.6, -2.21383e-07>, <-2.53233, 0.6, -0.750787>, <-2.32151, 0.6, -1.25974>, <-1.79063, 0.6, -1.79063>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.53233, 0.6, -2.21383e-07>, <-2.53233, 0.6, -0.750787>, <-2.32151, 0.6, -1.25974>, <-1.79063, 0.6, -1.79063>,
      <-2.93863, -2.57418, -2.56903e-07>, <-2.93863, -2.57418, -0.750787>, <-2.60881, -2.57418, -1.54704>, <-2.07792, -2.57418, -2.07792>,
      <-2.44429, -5.80371, -2.13687e-07>, <-2.44429, -5.80371, -0.77085>, <-2.27345, -5.80371, -1.1833>, <-1.72837, -5.80371, -1.72837>,
      <-2.6, -9, -2.27299e-07>, <-2.6, -9, -0.77085>, <-2.38355, -9, -1.2934>, <-1.83848, -9, -1.83848>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.6, -9, -2.27299e-07>, <-2.6, -9, -0.77085>, <-2.38355, -9, -1.2934>, <-1.83848, -9, -1.83848>,
      <-2.60649, -9.13317, -2.27866e-07>, <-2.60649, -9.13317, -0.77085>, <-2.38814, -9.13317, -1.29799>, <-1.84307, -9.13318, -1.84306>,
      <-2.99703, -9.1333, -2.62009e-07>, <-2.99703, -9.1333, -0.889442>, <-2.74815, -9.1333, -1.49029>, <-2.11922, -9.1333, -2.11922>,
      <-3, -9, -2.62268e-07>, <-3, -9, -0.889442>, <-2.75025, -9, -1.49239>, <-2.12132, -9, -2.12132>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-3, -9, -2.62268e-07>, <-3, -9, -0.889442>, <-2.75025, -9, -1.49239>, <-2.12132, -9, -2.12132>,
      <-3.07123, -5.80019, -2.68495e-07>, <-3.07123, -5.80019, -0.889442>, <-2.80062, -5.80019, -1.54276>, <-2.17169, -5.80019, -2.17169>,
      <-3.29086, -2.56483, -2.87696e-07>, <-3.29086, -2.56483, -0.834208>, <-2.91686, -2.56483, -1.73711>, <-2.32699, -2.56483, -2.32699>,
      <-2.8137, 0.6, -2.45981e-07>, <-2.8137, 0.6, -0.834208>, <-2.57946, 0.6, -1.39971>, <-1.98959, 0.6, -1.98959>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.8137, 0.6, -2.45981e-07>, <-2.8137, 0.6, -0.834208>, <-2.57946, 0.6, -1.39971>, <-1.98959, 0.6, -1.98959>,
      <-2.62313, 1.864, -2.29321e-07>, <-2.62313, 1.864, -0.834208>, <-2.44471, 1.864, -1.26496>, <-1.85483, 1.864, -1.85483>,
      <-1.43635, 2.78472, -1.2557e-07>, <-1.43635, 2.78472, -0.30834>, <-1.23368, 2.78472, -0.797625>, <-1.01565, 2.78472, -1.01565>,
      <-1.04, 4, -9.09197e-08>, <-1.04, 4, -0.30834>, <-0.95342, 4, -0.517362>, <-0.735391, 4, -0.735391>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.04, 4, -9.09197e-08>, <-1.04, 4, -0.30834>, <-0.95342, 4, -0.517362>, <-0.735391, 4, -0.735391>,
      <-0.873972, 4.50907, -7.64051e-08>, <-0.873972, 4.50907, -0.30834>, <-0.836021, 4.50907, -0.399962>, <-0.617992, 4.50907, -0.617992>,
      <-1.19949, 5.06479, -1.04863e-07>, <-1.19949, 5.0648, -0.350737>, <-1.09618, 5.0648, -0.600161>, <-0.848169, 5.06479, -0.848169>,
      <-1.183, 5.6, -1.03421e-07>, <-1.183, 5.6, -0.350737>, <-1.08452, 5.6, -0.588499>, <-0.836507, 5.6, -0.836507>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.183, 5.6, -1.03421e-07>, <-1.183, 5.6, -0.350737>, <-1.08452, 5.6, -0.588499>, <-0.836507, 5.6, -0.836507>,
      <-1.17147, 5.97416, -1.02413e-07>, <-1.17147, 5.97416, -0.350737>, <-1.07636, 5.97416, -0.580346>, <-0.828355, 5.97416, -0.828354>,
      <-1.00103, 6.32828, -8.75132e-08>, <-1.00103, 6.32828, -0.283673>, <-0.908425, 6.32828, -0.507251>, <-0.707838, 6.32828, -0.707838>,
      <-0.9568, 6.7, -8.36461e-08>, <-0.9568, 6.7, -0.283673>, <-0.877147, 6.7, -0.475973>, <-0.67656, 6.7, -0.67656>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.9568, 6.7, -8.36461e-08>, <-0.9568, 6.7, -0.283673>, <-0.877147, 6.7, -0.475973>, <-0.67656, 6.7, -0.67656>,
      <-0.921347, 6.99792, -8.05467e-08>, <-0.921347, 6.99792, -0.283673>, <-0.852078, 6.99792, -0.450904>, <-0.651491, 6.99792, -0.651491>,
      <-0.935949, 7.30011, -8.18232e-08>, <-0.935949, 7.30011, -0.280174>, <-0.859929, 7.30011, -0.463703>, <-0.661816, 7.30011, -0.661816>,
      <-0.945, 7.6, -8.26145e-08>, <-0.945, 7.6, -0.280174>, <-0.866329, 7.6, -0.470103>, <-0.668216, 7.6, -0.668216>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.945, 7.6, -8.26145e-08>, <-0.945, 7.6, -0.280174>, <-0.866329, 7.6, -0.470103>, <-0.668216, 7.6, -0.668216>,
      <-0.947062, 7.6683, -8.27948e-08>, <-0.947062, 7.6683, -0.280174>, <-0.867787, 7.6683, -0.47156>, <-0.669674, 7.6683, -0.669674>,
      <-0.997639, 7.7321, -8.72164e-08>, <-0.997639, 7.7321, -0.293516>, <-0.912985, 7.7321, -0.49789>, <-0.705438, 7.7321, -0.705437>,
      <-0.99, 7.8, -8.65485e-08>, <-0.99, 7.8, -0.293516>, <-0.907583, 7.8, -0.492489>, <-0.700036, 7.8, -0.700036>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.99, 7.8, -8.65485e-08>, <-0.99, 7.8, -0.293516>, <-0.907583, 7.8, -0.492489>, <-0.700036, 7.8, -0.700036>,
      <-0.981827, 7.87265, -8.5834e-08>, <-0.981827, 7.87265, -0.293516>, <-0.901804, 7.87265, -0.48671>, <-0.694257, 7.87265, -0.694257>,
      <-0.93, 7.93333, -8.13032e-08>, <-0.93, 7.93333, -0.266833>, <-0.846288, 7.93333, -0.46893>, <-0.657609, 7.93333, -0.657609>,
      <-0.9, 8, -7.86805e-08>, <-0.9, 8, -0.266833>, <-0.825075, 8, -0.447717>, <-0.636396, 8, -0.636396>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.769587, 5.6, -0.769587>, <-0.541419, 5.6, -0.997754>, <-0.322678, 5.6, -1.08836>, <1.29786e-08, 5.6, -1.08836>,
      <-0.733675, 5.06667, -0.733675>, <-0.505507, 5.06667, -0.961843>, <-0.322678, 5.06667, -1.03757>, <1.23729e-08, 5.06667, -1.03757>,
      <-0.556744, 4.51471, -0.556744>, <-0.360517, 4.51471, -0.75297>, <-0.277506, 4.51471, -0.787354>, <9.38911e-09, 4.51471, -0.787354>,
      <-0.661852, 4, -0.661852>, <-0.465626, 4, -0.858078>, <-0.277506, 4, -0.936>, <1.11617e-08, 4, -0.936>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.661852, 4, -0.661852>, <-0.465626, 4, -0.858078>, <-0.277506, 4, -0.936>, <1.11617e-08, 4, -0.936>,
      <-0.907489, 2.79712, -0.907489>, <-0.711263, 2.79712, -1.10372>, <-0.277506, 2.79712, -1.28338>, <1.53042e-08, 2.79712, -1.28338>,
      <-1.67822, 1.8419, -1.67822>, <-1.14734, 1.8419, -2.20911>, <-0.750787, 1.8419, -2.37337>, <2.83021e-08, 1.8419, -2.37337>,
      <-1.79063, 0.6, -1.79063>, <-1.25974, 0.6, -2.32151>, <-0.750787, 0.6, -2.53233>, <3.01977e-08, 0.6, -2.53233>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.79063, 0.6, -1.79063>, <-1.25974, 0.6, -2.32151>, <-0.750787, 0.6, -2.53233>, <3.01977e-08, 0.6, -2.53233>,
      <-2.07792, -2.57418, -2.07792>, <-1.54704, -2.57418, -2.60881>, <-0.750787, -2.57418, -2.93863>, <3.50428e-08, -2.57418, -2.93863>,
      <-1.72837, -5.80371, -1.72837>, <-1.1833, -5.80371, -2.27345>, <-0.77085, -5.80371, -2.44429>, <2.91479e-08, -5.80371, -2.44429>,
      <-1.83848, -9, -1.83848>, <-1.2934, -9, -2.38355>, <-0.77085, -9, -2.6>, <3.10047e-08, -9, -2.6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.83848, -9, -1.83848>, <-1.2934, -9, -2.38355>, <-0.77085, -9, -2.6>, <3.10047e-08, -9, -2.6>,
      <-1.84307, -9.13318, -1.84306>, <-1.29799, -9.13317, -2.38814>, <-0.77085, -9.13317, -2.60649>, <3.10821e-08, -9.13317, -2.60649>,
      <-2.11922, -9.1333, -2.11922>, <-1.49029, -9.1333, -2.74815>, <-0.889442, -9.1333, -2.99703>, <3.57393e-08, -9.1333, -2.99703>,
      <-2.12132, -9, -2.12132>, <-1.49239, -9, -2.75025>, <-0.889442, -9, -3>, <3.57746e-08, -9, -3>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.12132, -9, -2.12132>, <-1.49239, -9, -2.75025>, <-0.889442, -9, -3>, <3.57746e-08, -9, -3>,
      <-2.17169, -5.80019, -2.17169>, <-1.54276, -5.80019, -2.80062>, <-0.889442, -5.80019, -3.07123>, <3.6624e-08, -5.80019, -3.07123>,
      <-2.32699, -2.56483, -2.32699>, <-1.73712, -2.56483, -2.91686>, <-0.834208, -2.56483, -3.29086>, <3.92431e-08, -2.56483, -3.29086>,
      <-1.98959, 0.6, -1.98959>, <-1.39971, 0.6, -2.57946>, <-0.834208, 0.6, -2.8137>, <3.3553e-08, 0.6, -2.8137>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.98959, 0.6, -1.98959>, <-1.39971, 0.6, -2.57946>, <-0.834208, 0.6, -2.8137>, <3.3553e-08, 0.6, -2.8137>,
      <-1.85483, 1.864, -1.85483>, <-1.26496, 1.864, -2.44471>, <-0.834208, 1.864, -2.62313>, <3.12805e-08, 1.864, -2.62313>,
      <-1.01565, 2.78472, -1.01565>, <-0.797625, 2.78472, -1.23368>, <-0.30834, 2.78472, -1.43635>, <1.71283e-08, 2.78472, -1.43635>,
      <-0.735391, 4, -0.735391>, <-0.517362, 4, -0.95342>, <-0.30834, 4, -1.04>, <1.24019e-08, 4, -1.04>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.735391, 4, -0.735391>, <-0.517362, 4, -0.95342>, <-0.30834, 4, -1.04>, <1.24019e-08, 4, -1.04>,
      <-0.617992, 4.50907, -0.617992>, <-0.399962, 4.50907, -0.836021>, <-0.30834, 4.50907, -0.873972>, <1.0422e-08, 4.50907, -0.873972>,
      <-0.848169, 5.06479, -0.848169>, <-0.600161, 5.0648, -1.09618>, <-0.350737, 5.0648, -1.19949>, <1.43038e-08, 5.06479, -1.19949>,
      <-0.836507, 5.6, -0.836507>, <-0.588499, 5.6, -1.08452>, <-0.350737, 5.6, -1.183>, <1.41071e-08, 5.6, -1.183>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.836507, 5.6, -0.836507>, <-0.588499, 5.6, -1.08452>, <-0.350737, 5.6, -1.183>, <1.41071e-08, 5.6, -1.183>,
      <-0.828355, 5.97416, -0.828354>, <-0.580346, 5.97416, -1.07636>, <-0.350737, 5.97416, -1.17147>, <1.39696e-08, 5.97416, -1.17147>,
      <-0.707838, 6.32828, -0.707838>, <-0.507251, 6.32828, -0.908425>, <-0.283673, 6.32828, -1.00103>, <1.19372e-08, 6.32828, -1.00103>,
      <-0.67656, 6.7, -0.67656>, <-0.475973, 6.7, -0.877147>, <-0.283673, 6.7, -0.9568>, <1.14097e-08, 6.7, -0.9568>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.67656, 6.7, -0.67656>, <-0.475973, 6.7, -0.877147>, <-0.283673, 6.7, -0.9568>, <1.14097e-08, 6.7, -0.9568>,
      <-0.651491, 6.99792, -0.651491>, <-0.450904, 6.99792, -0.852078>, <-0.283673, 6.99792, -0.921347>, <1.0987e-08, 6.99792, -0.921347>,
      <-0.661816, 7.30011, -0.661816>, <-0.463703, 7.30011, -0.859929>, <-0.280174, 7.30011, -0.935949>, <1.11611e-08, 7.30011, -0.935949>,
      <-0.668216, 7.6, -0.668216>, <-0.470103, 7.6, -0.866329>, <-0.280174, 7.6, -0.945>, <1.1269e-08, 7.6, -0.945>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.668216, 7.6, -0.668216>, <-0.470103, 7.6, -0.866329>, <-0.280174, 7.6, -0.945>, <1.1269e-08, 7.6, -0.945>,
      <-0.669674, 7.6683, -0.669674>, <-0.47156, 7.6683, -0.867787>, <-0.280174, 7.6683, -0.947061>, <1.12936e-08, 7.6683, -0.947062>,
      <-0.705438, 7.7321, -0.705437>, <-0.497891, 7.7321, -0.912985>, <-0.293516, 7.7321, -0.997639>, <1.18967e-08, 7.7321, -0.997639>,
      <-0.700036, 7.8, -0.700036>, <-0.492489, 7.8, -0.907583>, <-0.293516, 7.8, -0.99>, <1.18056e-08, 7.8, -0.99>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.700036, 7.8, -0.700036>, <-0.492489, 7.8, -0.907583>, <-0.293516, 7.8, -0.99>, <1.18056e-08, 7.8, -0.99>,
      <-0.694257, 7.87265, -0.694257>, <-0.48671, 7.87265, -0.901804>, <-0.293516, 7.87265, -0.981827>, <1.17082e-08, 7.87265, -0.981827>,
      <-0.657609, 7.93333, -0.657609>, <-0.46893, 7.93333, -0.846288>, <-0.266833, 7.93333, -0.93>, <1.10901e-08, 7.93333, -0.93>,
      <-0.636396, 8, -0.636396>, <-0.447717, 8, -0.825075>, <-0.266833, 8, -0.9>, <1.07324e-08, 8, -0.9>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.29786e-08, 5.6, -1.08836>, <0.322678, 5.6, -1.08836>, <0.541419, 5.6, -0.997754>, <0.769586, 5.6, -0.769587>,
      <1.23729e-08, 5.06667, -1.03757>, <0.322678, 5.06667, -1.03757>, <0.505507, 5.06667, -0.961843>, <0.733675, 5.06667, -0.733675>,
      <9.38911e-09, 4.51471, -0.787354>, <0.277506, 4.51471, -0.787354>, <0.360517, 4.51471, -0.75297>, <0.556743, 4.51471, -0.556744>,
      <1.11617e-08, 4, -0.936>, <0.277506, 4, -0.936>, <0.465626, 4, -0.858078>, <0.661852, 4, -0.661852>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.11617e-08, 4, -0.936>, <0.277506, 4, -0.936>, <0.465626, 4, -0.858078>, <0.661852, 4, -0.661852>,
      <1.53042e-08, 2.79712, -1.28338>, <0.277506, 2.79712, -1.28338>, <0.711263, 2.79712, -1.10372>, <0.907489, 2.79712, -0.907489>,
      <2.83021e-08, 1.8419, -2.37337>, <0.750787, 1.8419, -2.37337>, <1.14734, 1.8419, -2.20911>, <1.67822, 1.8419, -1.67822>,
      <3.01977e-08, 0.6, -2.53233>, <0.750787, 0.6, -2.53233>, <1.25974, 0.6, -2.32151>, <1.79063, 0.6, -1.79063>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.01977e-08, 0.6, -2.53233>, <0.750787, 0.6, -2.53233>, <1.25974, 0.6, -2.32151>, <1.79063, 0.6, -1.79063>,
      <3.50428e-08, -2.57418, -2.93863>, <0.750787, -2.57418, -2.93863>, <1.54704, -2.57418, -2.60881>, <2.07792, -2.57418, -2.07792>,
      <2.91479e-08, -5.80371, -2.44429>, <0.77085, -5.80371, -2.44429>, <1.1833, -5.80371, -2.27345>, <1.72837, -5.80371, -1.72837>,
      <3.10047e-08, -9, -2.6>, <0.77085, -9, -2.6>, <1.2934, -9, -2.38355>, <1.83848, -9, -1.83848>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.10047e-08, -9, -2.6>, <0.77085, -9, -2.6>, <1.2934, -9, -2.38355>, <1.83848, -9, -1.83848>,
      <3.10821e-08, -9.13317, -2.60649>, <0.77085, -9.13317, -2.60649>, <1.29799, -9.13317, -2.38814>, <1.84306, -9.13318, -1.84307>,
      <3.57393e-08, -9.1333, -2.99703>, <0.889442, -9.1333, -2.99703>, <1.49029, -9.1333, -2.74815>, <2.11922, -9.1333, -2.11922>,
      <3.57746e-08, -9, -3>, <0.889442, -9, -3>, <1.49239, -9, -2.75025>, <2.12132, -9, -2.12132>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.57746e-08, -9, -3>, <0.889442, -9, -3>, <1.49239, -9, -2.75025>, <2.12132, -9, -2.12132>,
      <3.6624e-08, -5.80019, -3.07123>, <0.889442, -5.80019, -3.07123>, <1.54276, -5.80019, -2.80062>, <2.17169, -5.80019, -2.17169>,
      <3.92431e-08, -2.56483, -3.29086>, <0.834208, -2.56483, -3.29086>, <1.73711, -2.56483, -2.91686>, <2.32699, -2.56483, -2.32699>,
      <3.3553e-08, 0.6, -2.8137>, <0.834208, 0.6, -2.8137>, <1.39971, 0.6, -2.57946>, <1.98959, 0.6, -1.98959>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.3553e-08, 0.6, -2.8137>, <0.834208, 0.6, -2.8137>, <1.39971, 0.6, -2.57946>, <1.98959, 0.6, -1.98959>,
      <3.12805e-08, 1.864, -2.62313>, <0.834208, 1.864, -2.62313>, <1.26496, 1.864, -2.44471>, <1.85483, 1.864, -1.85483>,
      <1.71283e-08, 2.78472, -1.43635>, <0.30834, 2.78472, -1.43635>, <0.797624, 2.78472, -1.23368>, <1.01565, 2.78472, -1.01565>,
      <1.24019e-08, 4, -1.04>, <0.30834, 4, -1.04>, <0.517362, 4, -0.95342>, <0.735391, 4, -0.735391>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.24019e-08, 4, -1.04>, <0.30834, 4, -1.04>, <0.517362, 4, -0.95342>, <0.735391, 4, -0.735391>,
      <1.0422e-08, 4.50907, -0.873972>, <0.30834, 4.50907, -0.873972>, <0.399962, 4.50907, -0.836021>, <0.617992, 4.50907, -0.617992>,
      <1.43038e-08, 5.06479, -1.19949>, <0.350737, 5.0648, -1.19949>, <0.600161, 5.0648, -1.09618>, <0.848169, 5.06479, -0.848169>,
      <1.41071e-08, 5.6, -1.183>, <0.350737, 5.6, -1.183>, <0.588499, 5.6, -1.08452>, <0.836507, 5.6, -0.836507>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.41071e-08, 5.6, -1.183>, <0.350737, 5.6, -1.183>, <0.588499, 5.6, -1.08452>, <0.836507, 5.6, -0.836507>,
      <1.39696e-08, 5.97416, -1.17147>, <0.350737, 5.97416, -1.17147>, <0.580346, 5.97416, -1.07636>, <0.828354, 5.97416, -0.828355>,
      <1.19372e-08, 6.32828, -1.00103>, <0.283673, 6.32828, -1.00103>, <0.507251, 6.32828, -0.908425>, <0.707838, 6.32828, -0.707838>,
      <1.14097e-08, 6.7, -0.9568>, <0.283673, 6.7, -0.9568>, <0.475973, 6.7, -0.877147>, <0.67656, 6.7, -0.67656>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.14097e-08, 6.7, -0.9568>, <0.283673, 6.7, -0.9568>, <0.475973, 6.7, -0.877147>, <0.67656, 6.7, -0.67656>,
      <1.0987e-08, 6.99792, -0.921347>, <0.283673, 6.99792, -0.921347>, <0.450904, 6.99792, -0.852078>, <0.651491, 6.99792, -0.651491>,
      <1.11611e-08, 7.30011, -0.935949>, <0.280174, 7.30011, -0.935949>, <0.463703, 7.30011, -0.859929>, <0.661816, 7.30011, -0.661816>,
      <1.1269e-08, 7.6, -0.945>, <0.280174, 7.6, -0.945>, <0.470103, 7.6, -0.866329>, <0.668216, 7.6, -0.668216>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.1269e-08, 7.6, -0.945>, <0.280174, 7.6, -0.945>, <0.470103, 7.6, -0.866329>, <0.668216, 7.6, -0.668216>,
      <1.12936e-08, 7.6683, -0.947062>, <0.280174, 7.6683, -0.947062>, <0.47156, 7.6683, -0.867787>, <0.669674, 7.6683, -0.669674>,
      <1.18967e-08, 7.7321, -0.997639>, <0.293516, 7.7321, -0.997639>, <0.49789, 7.7321, -0.912985>, <0.705437, 7.7321, -0.705438>,
      <1.18056e-08, 7.8, -0.99>, <0.293516, 7.8, -0.99>, <0.492488, 7.8, -0.907583>, <0.700036, 7.8, -0.700036>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.18056e-08, 7.8, -0.99>, <0.293516, 7.8, -0.99>, <0.492488, 7.8, -0.907583>, <0.700036, 7.8, -0.700036>,
      <1.17082e-08, 7.87265, -0.981827>, <0.293516, 7.87265, -0.981827>, <0.486709, 7.87265, -0.901804>, <0.694257, 7.87265, -0.694257>,
      <1.10901e-08, 7.93333, -0.93>, <0.266833, 7.93333, -0.93>, <0.46893, 7.93333, -0.846289>, <0.657609, 7.93333, -0.657609>,
      <1.07324e-08, 8, -0.9>, <0.266833, 8, -0.9>, <0.447717, 8, -0.825075>, <0.636396, 8, -0.636396>
   }
}

#declare BouchRond = union {
   cylinder {
      <0.35, 0, 0>, <0.35, 0.17, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate y*1.2
   }
   
   cylinder {
      <0.35, 0, 0>, <0.35, 0.17, 0>, 0.02
      scale 1
      rotate y*22.5
      translate y*1.2
   }
   
   cylinder {
      <0.35, 0, 0>, <0.35, 0.17, 0>, 0.02
      scale 1
      rotate y*45
      translate y*1.2
   }
   
   cylinder {
      <0.35, 0, 0>, <0.35, 0.17, 0>, 0.02
      scale 1
      rotate y*67.5
      translate y*1.2
   }
}

#declare Bouteille = union {
   //*PMName Bouteille
   
   union {
      //*PMName Bouchon
      
      cone {
         <0, 0.2, 0>, 0.26,
         <0, 1.2, 0>, 0.29
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         cylinder {
            <0, 0, 0>, <0, 0.17, 0>, 0.35
            scale 1
            rotate <0, 0, 0>
            translate y*1.2
         }
         
         object {
            BouchRond
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            BouchRond
            scale 1
            rotate y*90
            translate <0, 0, 0>
         }
         
         object {
            BouchRond
            scale 1
            rotate y*(-90)
            translate <0, 0, 0>
         }
         
         object {
            BouchRond
            scale 1
            rotate y*(-180)
            translate <0, 0, 0>
         }
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      translate y*5.9
      
      texture {
         pigment {
            marble
            turbulence <0.25, 0.25, 0.25>
            octaves 5
            omega 0.6
            lambda 6
            
            pigment_map {
               [ 0 color rgb <0.913725, 0.74902, 0.568627>
               ]
               [ 0.8 color rgb <0.890196, 0.729412, 0.556863>
               ]
               [ 0.97 color rgb <0.772549, 0.603922, 0.458824>
               ]
            }
            scale 0.05
            rotate y*120
         }
      }
   }
   
   object {
      BouteilleVerre
      
      material {
         VerreBrun
      }
      scale <0.32, 0.39, 0.32>
      rotate <0, 0, 0>
      translate y*3.7
   }
}

// PaperBoard
#declare Or = texture {
   pigment {
      color rgb <0.623529, 0.490196, 0>
   }
   
   finish {
      diffuse 0.2
      metallic 1
      specular 1.5
      roughness 0.01
      
      reflection {
         rgb <0.411765, 0.411765, 0.411765>
      }
   }
}

#declare MetalNoir = texture {
   pigment {
      color rgb <0.105882, 0.0901961, 0.0862745>
   }
   
   finish {
      brilliance 1.2
      metallic 1
      specular 2.5
      roughness 0.01
   }
}

#declare PlastNoir = texture {
   pigment {
      color rgb <0.380392, 0.337255, 0.290196>
   }
}

#declare PaperBoard = union {
   //*PMName Plume
   //*PMRawBegin
   sor {
      4,
   <0, -3>,
   <.1, 0>,
   <.12, 2.5>,
   <0, 3.5>
      sturm
      
      texture {
         MetalNoir
      }
   }
   //*PMRawEnd
   
   union {
      //*PMName Or
      
      cone {
         <0, 0, 0>, 0.1,
         <0, -0.02, 0>, 0.09
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      torus {
         0.09, 0.008
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.02)
      }
      
      sphere {
         <0, 0, 0>, 0.095
         scale <1, 0.2, 1>
         rotate <0, 0, 0>
         translate y*(-0.02)
      }
      
      cylinder {
         <0, 2.505, 0>, <0, 2.53, 0>, 0.12
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         Or
      }
   }
   
   union {
      //*PMName Plastique
      
      torus {
         0.105, 0.015
         scale 1
         rotate <0, 0, 0>
         translate y*2.54
      }
      
      torus {
         0.104, 0.015
         scale 1
         rotate <0, 0, 0>
         translate y*2.57
      }
      
      torus {
         0.103, 0.015
         scale 1
         rotate <0, 0, 0>
         translate y*2.6
      }
      
      torus {
         0.102, 0.015
         scale 1
         rotate <0, 0, 0>
         translate y*2.63
      }
      
      cylinder {
         <0, 2.6, 0>, <0, 3.1, 0>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cone {
         <0, 3.1, 0>, 0.1,
         <0, 3.105, 0>, 0.07
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 3.105, 0>, <0, 3.13, 0>, 0.07
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      torus {
         0.07, 0.015
         scale 1
         rotate <0, 0, 0>
         translate y*3.14
      }
      
      difference {
         union {
            cone {
               <0, 3.15, 0>, 0.069,
               <0, 3.4, 0>, 0.079
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cone {
               <0, 3.4, 0>, 0.079,
               <0, 3.45, 0>, 0.059
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         cone {
            <0, 3.15, 0>, 0.069,
            <0, 3.4, 0>, 0.079
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.09, 3.15, -0.03>, <0.09, 3.51, 0.09>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      texture {
         PlastNoir
      }
   }
   
   difference {
      //*PMName Plume
      
      union {
         //*PMName Plume
         
         cone {
            <0, 3.15, 0>, 0.07,
            <0, 3.4, 0>, 0.08
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cone {
            <0, 3.4, 0>, 0.08,
            <0, 3.9, 0>, 0
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale 1
         translate <0, 0, 0>
      }
      
      box {
         <-0.09, 3.15, -0.05>, <0.09, 3.91, 0.09>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, 0>, <0, 0, -0.1>, 0.1
         scale <1, 0.5, 1>
         rotate z*70
         translate <-0.072, 3.53, 0>
      }
      
      cylinder {
         <0, 0, 0>, <0, 0, -0.1>, 0.1
         scale <1, 0.5, 1>
         rotate z*(-70)
         translate <0.072, 3.53, 0>
      }
      
      box {
         <-0.001, 3.4, -0.09>, <0.001, 3.91, 0.09>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         Or
      }
   }
   
   union {
      //*PMName Papier
      
      bicubic_patch {
         type 0
         u_steps 3
         v_steps 3
         <-4.88509, -0.307885, -3>, <-1, 0, -3>, <0.340246, -0.0879672, -3>, <-0.958524, -0.879672, -3>,
         <-4.84111, 0, -1>, <-1, 0, -1>, <0.340246, -0.0879672, -1>, <-0.91454, -0.643087, -1.01042>,
         <-4.84111, 0, 1>, <-1, 0, 1>, <0.340246, -0.0879672, 1>, <-0.91454, -0.684754, 1.02083>,
         <-4.70915, -0.0879672, 3>, <-1, 0, 3>, <0.340246, -0.0879672, 3>, <-0.91454, -0.659754, 3>
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Unplugged/textures/papier2.png"
                  map_type 0
               }
               scale 6
               rotate <90, 90, 0>
               translate <1.1, 0, 3>
            }
            
            normal {
               bump_map {
                  png
                  "/home/tom/RayTrace/Unplugged/textures/bumppaper.png"
                  map_type 0
               }
               scale 6
               rotate <90, 90, 0>
               translate <1.2, 0, 3>
               bump_size 10
            }
         }
         scale <0.5, 0.5, 0.4>
         rotate <-90, 0, 90>
         translate <0, 3.2, -0.2>
      }
      
      cone {
         <0, 0, -0.0038628>, 0.11419,
         <0, -0.2, -0.0036951>, 0.10394
         open
         
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Unplugged/textures/dechire3.png"
               map_type 0
            }
            scale <0.4, 0.7, 0.4>
            rotate y*35
         }
         scale 1
         rotate <0, 0, 0>
         translate y*3
      }
   }
}

// Jeux
#declare Pico = superellipsoid {
   <1, 0.1>
   scale <0.222, 0.222, 0.06>
   rotate x*90
   translate y*1.05
}

#declare Brique = union {
   difference {
      superellipsoid {
         <0.02, 0.02>
         scale <1.5, 0.5, 0.75>
         rotate <0, 0, 0>
         translate y*0.5
      }
      
      superellipsoid {
         <0.02, 0.02>
         scale <1.49, 0.5, 0.74>
         rotate <0, 0, 0>
         translate y*0.49
      }
   }
   
   object {
      Pico
      scale 1
      rotate <0, 0, 0>
      translate <0.375, 0, -0.375>
   }
   
   object {
      Pico
      scale 1
      rotate <0, 0, 0>
      translate <1.125, 0, -0.375>
   }
   
   object {
      Pico
      scale 1
      rotate <0, 0, 0>
      translate <0.375, 0, 0.375>
   }
   
   object {
      Pico
      scale 1
      rotate <0, 0, 0>
      translate <1.125, 0, 0.375>
   }
   
   object {
      Pico
      scale 1
      rotate <0, 0, 0>
      translate <-0.375, 0, -0.375>
   }
   
   object {
      Pico
      scale 1
      rotate <0, 0, 0>
      translate <-1.125, 0, -0.375>
   }
   
   object {
      Pico
      scale 1
      rotate <0, 0, 0>
      translate <-0.375, 0, 0.375>
   }
   
   object {
      Pico
      scale 1
      rotate <0, 0, 0>
      translate <-1.125, 0, 0.375>
   }
   scale 0.6
}

#declare Puce = union {
   //*PMName Puce
   
   superellipsoid {
      <0.2, 0.05>
      
      texture {
         pigment {
            color rgb <0.0470588, 0.0352941, 0.0392157>
         }
         
         finish {
            specular 0.5
            roughness 0.1
         }
      }
      scale <0.24, 0.019, 0.4>
      rotate <0, 0, 0>
   }
   
   union {
      box {
         <0, 0, -0.4>, <0.01, 0.01, 0.4>
         scale 1
         rotate z*(-51.2)
         translate <-0.246042, 0.0015625, 0>
      }
      
      box {
         <0, -0.015, -0.4>, <0.01, 0.015, 0.4>
         scale 1
         rotate z*(-78.5)
         translate <-0.254896, 0.0015625, 0>
      }
      
      texture {
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Unplugged/textures/patte.png"
               map_type 0
            }
            scale <1, 0.04, 1>
            rotate x*(-90)
         }
         
         finish {
            specular 0.5
            roughness 0.2
         }
      }
   }
   
   union {
      box {
         <0, 0, -0.4>, <0.01, 0.01, 0.4>
         scale 1
         rotate z*(-51.2)
         translate <-0.246042, 0.0015625, 0>
      }
      
      box {
         <0, -0.015, -0.4>, <0.01, 0.015, 0.4>
         scale 1
         rotate z*(-78.5)
         translate <-0.254896, 0.0015625, 0>
      }
      
      texture {
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Unplugged/textures/patte.png"
               map_type 0
            }
            scale <1, 0.04, 1>
            rotate x*(-90)
         }
         
         finish {
            specular 0.5
            roughness 0.2
         }
      }
      rotate y*180
   }
   scale <0.7, 1, 0.85>
   translate <0, 0.037248, 0.08>
}

#declare sdram = difference {
   //*PMName sdram
   
   union {
      difference {
         //*PMName Circuit
         
         union {
            //*PMName Circuit
            
            box {
               <-2, 0.029, -0.5>, <2, 0.03, 0.42>
               
               pigment {
                  image_map {
                     jpeg
                     "/home/tom/RayTrace/Unplugged/textures/comp013.jpg"
                     map_type 0
                  }
                  rotate x*90
                  scale <0.99, 1, 1>
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            box {
               <-2, 0.001, -0.5>, <2, 0.029, 0.42>
               
               pigment {
                  color rgb <0.372549, 0.564706, 0.435294>
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            box {
               <-2, 0, -0.5>, <2, 0.001, 0.42>
               
               pigment {
                  color rgb <0.0784314, 0.329412, 0.215686>
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         cylinder {
            <0, 0.04, 0>, <0, -0.01, 0>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate <-1.91, 0, -0.41>
         }
         
         cylinder {
            <0, 0.04, 0>, <0, -0.01, 0>, 0.07
            scale 1
            rotate <0, 0, 0>
            translate <-2, 0, -0.1>
         }
         
         cylinder {
            <0, 0.04, 0>, <0, -0.01, 0>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate <1.91, 0, -0.41>
         }
         
         cylinder {
            <0, 0.04, 0>, <0, -0.01, 0>, 0.07
            scale 1
            rotate <0, 0, 0>
            translate <2, 0, -0.1>
         }
         
         superellipsoid {
            <0.01, 0.3>
            scale <0.05, 0.03, 0.125>
            rotate <0, 0, 0>
            translate <-1.9977, 0.015, 0.19>
         }
         
         superellipsoid {
            <0.01, 0.3>
            scale <0.05, 0.03, 0.125>
            rotate <0, 0, 0>
            translate <1.9977, 0.015, 0.19>
         }
         
         union {
            cylinder {
               <0, 0.04, 0>, <0, -0.01, 0>, 0.04
               scale 1
               rotate <0, 0, 0>
               translate z*(-0.43)
            }
            
            box {
               <-0.04, 0.04, -0.51>, <0.04, -0.01, -0.43>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         union {
            cylinder {
               <0, 0.04, 0>, <0, -0.01, 0>, 0.04
               scale 1
               rotate <0, 0, 0>
               translate z*(-0.43)
            }
            
            box {
               <-0.04, 0.04, -0.51>, <0.04, -0.01, -0.43>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            translate x*(-1.3)
         }
         
         pigment {
            color rgb <0.372549, 0.564706, 0.435294>
         }
      }
      
      box {
         //*PMName broche1
         <0, 0.03, -0.4>, <1.68, 0.031, -0.5>
         
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Unplugged/textures/broche.png"
               map_type 0
               interpolate 2
            }
            scale <0.04, 1, 1>
            rotate x*90
         }
         
         finish {
            specular 0.8
            roughness 0.001
         }
         scale 1
         rotate <0, 0, 0>
         translate <0.08, 0.001, 0>
      }
      
      box {
         //*PMName broche2
         <0, 0.03, -0.4>, <1.115, 0.031, -0.5>
         
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Unplugged/textures/broche.png"
               map_type 0
               interpolate 2
            }
            scale <0.04, 1, 1>
            rotate x*90
         }
         
         finish {
            specular 0.8
            roughness 0.001
         }
         scale 1
         rotate <0, 0, 0>
         translate <-1.2, 0.001, 0>
      }
      
      box {
         //*PMName broche3
         <0, 0.03, -0.4>, <0.4, 0.031, -0.5>
         
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Unplugged/textures/broche.png"
               map_type 0
               interpolate 2
            }
            scale <0.04, 1, 1>
            rotate x*90
         }
         
         finish {
            specular 0.8
            roughness 0.001
         }
         scale 1
         rotate <0, 0, 0>
         translate <-1.8, 0.001, 0>
      }
      
      union {
         //*PMName Puces
         
         object {
            //*PMName Puce1
            Puce
            scale 1
            rotate <0, 0, 0>
            translate x*(-1.6)
         }
         
         object {
            //*PMName Puce2
            Puce
            scale 1
            rotate <0, 0, 0>
            translate x*(-1.17)
         }
         
         object {
            //*PMName Puce3
            Puce
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.74)
         }
         
         object {
            //*PMName Puce4
            Puce
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.31)
         }
      }
      
      union {
         //*PMName Puces
         
         object {
            //*PMName Puce1
            Puce
            scale 1
            rotate <0, 0, 0>
            translate x*(-1.6)
         }
         
         object {
            //*PMName Puce2
            Puce
            scale 1
            rotate <0, 0, 0>
            translate x*(-1.17)
         }
         
         object {
            //*PMName Puce3
            Puce
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.74)
         }
         
         object {
            //*PMName Puce4
            Puce
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.31)
         }
         translate x*1.91
      }
   }
   
   height_field {
      png "/home/tom/RayTrace/Unplugged/textures/trouram.png"
      smooth
      
      pigment {
         color rgb <0, 0, 0>
      }
      scale <0.5, 0.1, 0.5>
      rotate <-180, 0, -180>
      translate <0.95707, -0.0217638, 0.317724>
   }
}

#declare GrisPlay = texture {
   pigment {
      color rgb <0.545098, 0.545098, 0.545098>
   }
}

#declare RosePlay = texture {
   pigment {
      color rgb <1, 0.678431, 0.72549>
   }
}

#declare RougePlay = texture {
   pigment {
      color rgb <1, 0.133333, 0.14902>
   }
}

#declare RTMoustaches = union {
   //*PMName Moustache
   
   sphere {
      <0, 0, 0>, 0.01
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 0, 0>, <-0.5, 0, 0>, 0.01
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      sphere {
         <0, 0, 0>, 0.01
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, 0>, <-0.5, 0, 0>, 0.01
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         sphere {
            <0, 0, 0>, 0.01
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, 0>, <-0.5, 0, 0>, 0.01
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         rotate z*3
         translate x*(-0.5)
      }
      rotate z*3
      translate x*(-0.5)
   }
   rotate z*3
   translate <0, 0, 0>
}

#declare PlayMob = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.846034, 0.5, 0.746689>, <1.10276, -0.289067, 0.845322>, <0.948678, -1.16667, 0.815563>, <1, -2, 0.85>,
      <0.285505, 0.5, 0.809369>, <0.542234, -0.289067, 0.908003>, <0.285759, -1.16667, 0.886156>, <0.337081, -2, 0.920593>,
      <-0.285505, 0.5, 0.809369>, <-0.542234, -0.289067, 0.908003>, <-0.285759, -1.16667, 0.886156>, <-0.337081, -2, 0.920593>,
      <-0.846034, 0.5, 0.746689>, <-1.10276, -0.289067, 0.845322>, <-0.948678, -1.16667, 0.815563>, <-1, -2, 0.85>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.846034, 0.5, 0.746689>, <0.758898, 0.767817, 0.713211>, <0.341345, 0.7, 0.58223>, <0.089, 0.8, 0.5>,
      <0.285505, 0.5, 0.809369>, <0.198369, 0.767817, 0.775892>, <0.287086, 0.7, 0.606238>, <0.034741, 0.8, 0.524008>,
      <-0.285505, 0.5, 0.809369>, <-0.198369, 0.767817, 0.775892>, <-0.287086, 0.7, 0.606238>, <-0.034741, 0.8, 0.524008>,
      <-0.846034, 0.5, 0.746689>, <-0.758898, 0.767817, 0.713211>, <-0.341345, 0.7, 0.58223>, <-0.089, 0.8, 0.5>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.846034, 0.5, 0.746689>, <1.10276, -0.289067, 0.845322>, <0.948678, -1.16667, 0.815563>, <1, -2, 0.85>,
      <0.917568, 0.5, 0.738689>, <1.1743, -0.289067, 0.837323>, <1.0394, -1.16667, 0.805902>, <1.09072, -2, 0.840339>,
      <0.923018, 0.5, 0.619588>, <1.17803, -0.29338, 0.69639>, <1.06265, -1.16667, 0.686825>, <1.13577, -2, 0.711171>,
      <0.930637, 0.5, 0.548013>, <1.18565, -0.29338, 0.624815>, <1.07688, -1.16667, 0.596704>, <1.15, -2, 0.62105>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.846034, 0.5, 0.746689>, <0.758898, 0.767817, 0.713211>, <0.341345, 0.7, 0.58223>, <0.089, 0.8, 0.5>,
      <0.917568, 0.5, 0.738689>, <0.830431, 0.767817, 0.705212>, <0.408421, 0.7, 0.55255>, <0.156076, 0.8, 0.47032>,
      <0.923018, 0.5, 0.619588>, <0.844835, 0.743236, 0.596042>, <0.446226, 0.7, 0.482642>, <0.219347, 0.8, 0.416637>,
      <0.930637, 0.5, 0.548013>, <0.852454, 0.743236, 0.524467>, <0.476879, 0.7, 0.416004>, <0.25, 0.8, 0.35>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.846034, 0.5, 0.746689>, <-1.10276, -0.289067, 0.845322>, <-0.948678, -1.16667, 0.815563>, <-1, -2, 0.85>,
      <-0.917568, 0.5, 0.738689>, <-1.1743, -0.289067, 0.837323>, <-1.0394, -1.16667, 0.805902>, <-1.09072, -2, 0.840339>,
      <-0.923018, 0.5, 0.619588>, <-1.17803, -0.29338, 0.69639>, <-1.06265, -1.16667, 0.686825>, <-1.13577, -2, 0.711171>,
      <-0.930637, 0.5, 0.548013>, <-1.18565, -0.29338, 0.624815>, <-1.07688, -1.16667, 0.596704>, <-1.15, -2, 0.62105>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.846034, 0.5, 0.746689>, <-0.758898, 0.767817, 0.713211>, <-0.341345, 0.7, 0.58223>, <-0.089, 0.8, 0.5>,
      <-0.917568, 0.5, 0.738689>, <-0.830431, 0.767817, 0.705212>, <-0.408421, 0.7, 0.55255>, <-0.156076, 0.8, 0.47032>,
      <-0.923018, 0.5, 0.619588>, <-0.844835, 0.743236, 0.596042>, <-0.446226, 0.7, 0.482642>, <-0.219347, 0.8, 0.416637>,
      <-0.930637, 0.5, 0.548013>, <-0.852454, 0.743236, 0.524467>, <-0.476879, 0.7, 0.416004>, <-0.25, 0.8, 0.35>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.930637, 0.5, 0.548013>, <-1.18565, -0.29338, 0.624815>, <-1.07688, -1.16667, 0.596704>, <-1.15, -2, 0.62105>,
      <-0.951669, 0.5, 0.350454>, <-1.20668, -0.29338, 0.427256>, <-1.11436, -1.16667, 0.359296>, <-1.18749, -2, 0.383641>,
      <-0.951669, 0.5, 0.149546>, <-1.20679, -0.293714, 0.0786786>, <-1.11357, -1.16667, 0.154862>, <-1.18669, -2, 0.137533>,
      <-0.930637, 0.5, -0.0480131>, <-1.18576, -0.293714, -0.11888>, <-1.07688, -1.16667, -0.082671>, <-1.15, -2, -0.1>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.930637, 0.5, 0.548013>, <-0.852454, 0.743236, 0.524467>, <-0.476879, 0.7, 0.416004>, <-0.25, 0.8, 0.35>,
      <-0.951669, 0.5, 0.350454>, <-0.873486, 0.743236, 0.326908>, <-0.50474, 0.7, 0.355438>, <-0.27786, 0.8, 0.289434>,
      <-0.951669, 0.5, 0.149546>, <-0.873437, 0.743389, 0.171277>, <-0.50474, 0.7, 0.144562>, <-0.27786, 0.8, 0.210566>,
      <-0.930637, 0.5, -0.0480131>, <-0.852405, 0.743389, -0.026282>, <-0.476879, 0.7, 0.0839956>, <-0.25, 0.8, 0.15>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.930637, 0.5, -0.0480131>, <-1.18576, -0.293714, -0.11888>, <-1.07688, -1.16667, -0.082671>, <-1.15, -2, -0.1>,
      <-0.923018, 0.5, -0.119588>, <-1.17814, -0.293714, -0.190456>, <-1.06204, -1.16667, -0.178714>, <-1.13516, -2, -0.196043>,
      <-0.917568, 0.5, -0.238689>, <-1.1743, -0.289067, -0.337323>, <-1.04521, -1.16667, -0.304338>, <-1.09653, -2, -0.338775>,
      <-0.846034, 0.5, -0.246689>, <-1.10276, -0.289067, -0.345322>, <-0.948678, -1.16667, -0.315563>, <-1, -2, -0.35>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.930637, 0.5, -0.0480131>, <-0.852405, 0.743389, -0.026282>, <-0.476879, 0.7, 0.0839956>, <-0.25, 0.8, 0.15>,
      <-0.923018, 0.5, -0.119588>, <-0.844785, 0.743389, -0.0978572>, <-0.446226, 0.7, 0.0173585>, <-0.219347, 0.8, 0.0833629>,
      <-0.917568, 0.5, -0.238689>, <-0.830431, 0.767817, -0.205212>, <-0.408421, 0.7, -0.0525498>, <-0.156076, 0.8, 0.0296798>,
      <-0.846034, 0.5, -0.246689>, <-0.758898, 0.767817, -0.213211>, <-0.341345, 0.7, -0.0822295>, <-0.089, 0.8, 0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.846034, 0.5, -0.246689>, <-1.10276, -0.289067, -0.345322>, <-0.948678, -1.16667, -0.315563>, <-1, -2, -0.35>,
      <-0.285505, 0.5, -0.309369>, <-0.542234, -0.289067, -0.408003>, <-0.286473, -1.16667, -0.392563>, <-0.337795, -2, -0.427001>,
      <0.285505, 0.5, -0.309369>, <0.542234, -0.289067, -0.408003>, <0.286473, -1.16667, -0.392563>, <0.337795, -2, -0.427001>,
      <0.846034, 0.5, -0.246689>, <1.10276, -0.289067, -0.345322>, <0.948678, -1.16667, -0.315563>, <1, -2, -0.35>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.846034, 0.5, -0.246689>, <-0.758898, 0.767817, -0.213211>, <-0.341345, 0.7, -0.0822295>, <-0.089, 0.8, 0>,
      <-0.285505, 0.5, -0.309369>, <-0.198369, 0.767817, -0.275892>, <-0.287086, 0.7, -0.106238>, <-0.034741, 0.8, -0.0240084>,
      <0.285505, 0.5, -0.309369>, <0.198369, 0.767817, -0.275892>, <0.287086, 0.7, -0.106238>, <0.034741, 0.8, -0.0240084>,
      <0.846034, 0.5, -0.246689>, <0.758898, 0.767817, -0.213211>, <0.341345, 0.7, -0.0822295>, <0.089, 0.8, 0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.846034, 0.5, -0.246689>, <1.10276, -0.289067, -0.345322>, <0.948678, -1.16667, -0.315563>, <1, -2, -0.35>,
      <0.917568, 0.5, -0.238689>, <1.1743, -0.289067, -0.337323>, <1.04521, -1.16667, -0.304338>, <1.09653, -2, -0.338775>,
      <0.923018, 0.5, -0.119588>, <1.17814, -0.293714, -0.190456>, <1.06204, -1.16667, -0.178714>, <1.13516, -2, -0.196043>,
      <0.930637, 0.5, -0.0480131>, <1.18576, -0.293714, -0.11888>, <1.07688, -1.16667, -0.082671>, <1.15, -2, -0.1>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.846034, 0.5, -0.246689>, <0.758898, 0.767817, -0.213211>, <0.341345, 0.7, -0.0822295>, <0.089, 0.8, 0>,
      <0.917568, 0.5, -0.238689>, <0.830431, 0.767817, -0.205212>, <0.408421, 0.7, -0.0525498>, <0.156076, 0.8, 0.0296798>,
      <0.923018, 0.5, -0.119588>, <0.844785, 0.743389, -0.0978572>, <0.446226, 0.7, 0.0173585>, <0.219347, 0.8, 0.0833629>,
      <0.930637, 0.5, -0.0480131>, <0.852405, 0.743389, -0.026282>, <0.476879, 0.7, 0.0839956>, <0.25, 0.8, 0.15>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.930637, 0.5, -0.0480131>, <1.18576, -0.293714, -0.11888>, <1.07688, -1.16667, -0.082671>, <1.15, -2, -0.1>,
      <0.951669, 0.5, 0.149546>, <1.20679, -0.293714, 0.0786786>, <1.11357, -1.16667, 0.154862>, <1.18669, -2, 0.137533>,
      <0.951669, 0.5, 0.350454>, <1.20668, -0.29338, 0.427256>, <1.11436, -1.16667, 0.359296>, <1.18749, -2, 0.383641>,
      <0.930637, 0.5, 0.548013>, <1.18565, -0.29338, 0.624815>, <1.07688, -1.16667, 0.596704>, <1.15, -2, 0.62105>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.930637, 0.5, -0.0480131>, <0.852405, 0.743389, -0.026282>, <0.476879, 0.7, 0.0839956>, <0.25, 0.8, 0.15>,
      <0.951669, 0.5, 0.149546>, <0.873437, 0.743389, 0.171277>, <0.50474, 0.7, 0.144562>, <0.27786, 0.8, 0.210566>,
      <0.951669, 0.5, 0.350454>, <0.873486, 0.743236, 0.326908>, <0.50474, 0.7, 0.355438>, <0.27786, 0.8, 0.289434>,
      <0.930637, 0.5, 0.548013>, <0.852454, 0.743236, 0.524467>, <0.476879, 0.7, 0.416004>, <0.25, 0.8, 0.35>
   }
}

#declare PlayMobil = union {
   //*PMName PlayMobil
   
   object {
      //*PMName Corps
      PlayMob
      
      texture {
         RougePlay
      }
      scale 0.8
      rotate <0, 0, 0>
      translate <0, 0.18, -0.25>
   }
   
   union {
      //*PMName AxeBras
      
      cylinder {
         <-0.75, 0, 0>, <0.75, 0, 0>, 0.25
         scale 1
         rotate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 0.25
         scale <1.2, 1, 1>
         rotate <0, 0, 0>
         translate x*(-0.75)
      }
      
      sphere {
         <0, 0, 0>, 0.25
         scale <1.2, 1, 1>
         rotate <0, 0, 0>
         translate x*0.75
      }
      translate y*0.4523
      
      texture {
         RougePlay
      }
   }
   
   union {
      //*PMName BrasD
      
      intersection {
         cone {
            <0, 0, 0>, 0.25,
            <0, -1.68, 0>, 0.23
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.25, 0, -0.25>, <0, -1.68, 0.25>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale <0.7, 1, 1>
      }
      
      intersection {
         cone {
            <0, 0, 0>, 0.25,
            <0, -1.68, 0>, 0.23
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0, 0, -0.25>, <0.25, -1.68, 0.25>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale <0.5, 1, 1>
      }
      
      union {
         difference {
            sphere {
               <0, 0, 0>, 0.2
               scale 1
               rotate <0, 0, 0>
               translate y*(-1.6)
            }
            
            cylinder {
               <0, 0.25, 0>, <0, -0.25, 0>, 0.18
               scale <0.8, 1, 1>
               rotate x*90
               translate y*(-1.66)
            }
            scale <0.9, 1, 1>
            rotate <0, 0, 0>
            translate y*(-0.3)
         }
         
         cylinder {
            <0, -1.72, 0>, <0, -1.6, 0>, 0.08
            
            texture {
               GrisPlay
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            GrisPlay
         }
         rotate <0, 0, 0>
         translate <-0.0281558, -0.00867804, 0>
      }
      rotate <96, 0, -9>
      translate <-0.87756, 0.42, 0>
      
      texture {
         RougePlay
      }
   }
   
   union {
      //*PMName BrasG
      
      intersection {
         cone {
            <0, 0, 0>, 0.25,
            <0, -1.68, 0>, 0.23
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.25, 0, -0.25>, <0, -1.68, 0.25>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale <0.7, 1, 1>
      }
      
      intersection {
         cone {
            <0, 0, 0>, 0.25,
            <0, -1.68, 0>, 0.23
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0, 0, -0.25>, <-0.25, -1.68, 0.25>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale <0.5, 1, 1>
      }
      
      union {
         difference {
            sphere {
               <0, 0, 0>, 0.2
               scale 1
               rotate <0, 0, 0>
               translate y*(-1.6)
            }
            
            cylinder {
               <0, 0.25, 0>, <0, -0.25, 0>, 0.18
               scale <0.8, 1, 1>
               rotate x*90
               translate y*(-1.66)
            }
            scale <0.9, 1, 1>
            rotate <0, 0, 0>
            translate y*(-0.3)
         }
         
         cylinder {
            <0, -1.72, 0>, <0, -1.6, 0>, 0.08
            
            texture {
               GrisPlay
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            GrisPlay
         }
         rotate <0, 0, 0>
         translate <-0.0281558, -0.00867804, 0>
      }
      rotate <75, 0, 9>
      translate <0.87756, 0.42, 0>
      
      texture {
         RougePlay
      }
   }
   
   union {
      //*PMName Tete
      
      cylinder {
         <0, 0.8, 0>, <0, 0.87, 0>, 0.27
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      difference {
         sphere {
            <0, 0, 0>, 0.5
            
            texture {
               pigment {
                  image_map {
                     png
                     "/home/tom/RayTrace/Unplugged/textures/playmobil.png"
                     map_type 1
                     interpolate 4
                  }
               }
            }
            scale 1
            rotate y*(-90)
            translate y*1.2792
         }
         
         box {
            <-0.5, 1.5, -0.5>, <0.5, 1.8, 0.5>
            
            texture {
               RosePlay
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale 1.05
         translate y*(-0.025)
      }
      
      difference {
         union {
            difference {
               cylinder {
                  <0, 1.65, 0>, <0, 1.5, 0>, 0.38
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 1.651, 0>, <0, 1.49, 0>, 0.379
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
            }
            
            torus {
               0.4, 0.025
               scale 1
               rotate <0, 0, 0>
               translate y*1.65
            }
         }
         
         box {
            <-0.1, -0.1, -0.1>, <0.1, 0.1, 0.1>
            scale <0.8, 0.8, 1>
            rotate z*45
            translate <0, 1.68, 0.382>
         }
      }
      
      texture {
         RosePlay
      }
   }
}

#declare Jeux = union {
   //*PMName Jeux
   
   union {
      //*PMName Miroir
      
      sphere {
         <0, 0, 0>, 0.4
         
         texture {
            pigment {
               color rgb <0, 0, 0>
            }
            
            finish {
               diffuse 1
               
               reflection {
                  rgb <1, 1, 1>
               }
            }
         }
         scale <0.1, 1.2, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      intersection {
         sphere {
            <0, 0, 0>, 0.4
            
            texture {
               GrisPlay
            }
         }
         
         box {
            <-0.4, -0.4, -0.4>, <0, 0.4, 0.4>
         }
         scale <0.2, 1.2, 1>
      }
      
      torus {
         0.35, 0.05
         
         texture {
            GrisPlay
         }
         rotate z*90
         scale <0.15, 1.2, 1>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, -0.4, 0>, <0, -0.8, 0>, 0.09
         
         texture {
            GrisPlay
         }
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.03)
      }
      
      cone {
         <0, -0.4, 0>, 0.09,
         <0, -0.35, 0>, 0.05
         
         texture {
            GrisPlay
         }
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.03)
      }
      scale 1
      rotate y*9
      translate <1.24994, 3.43031, 0.166379>
   }
   
   union {
      //*PMName Raton
      //*PMRawBegin
      #include "raton.inc"
      //*PMRawEnd
      
      union {
         //*PMName Tete
         
         union {
            //*PMName Moustaches
            
            object {
               RTMoustaches
               scale 1
               rotate z*(-2.6)
               translate <-0.42389, 0.1, -2.8691>
            }
            
            object {
               RTMoustaches
               scale 1
               rotate <0, 0, 0>
               translate <-0.42389, 0, -2.8691>
            }
            
            object {
               RTMoustaches
               scale 1
               rotate z*2.3
               translate <-0.42389, -0.1, -2.8691>
            }
            
            object {
               RTMoustaches
               scale 1
               rotate <-0, 180, 2.6>
               translate <0.42389, 0.1, -2.8691>
            }
            
            object {
               RTMoustaches
               scale 1
               rotate y*180
               translate <0.42389, 0, -2.8691>
            }
            
            object {
               RTMoustaches
               scale 1
               rotate <0, 180, -2.3>
               translate <0.42389, -0.1, -2.8691>
            }
            
            pigment {
               color rgbft <1, 1, 1, 0.2, 0.2>
            }
            scale 1
            translate <0, 0, 0>
         }
         
         union {
            //*PMName Yeux
            
            union {
               //*PMName Droit
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeil
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate <-0, 20, 10>
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-27.7)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.8, 1>
               rotate <0, 0, 0>
               translate x*(-0.42)
            }
            
            union {
               //*PMName Gauche
               
               sphere {
                  <0, 0, 0>, 0.4
                  
                  texture {
                     BlancOeil
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, -0.7>, 0.15
                  
                  texture {
                     NoirOeil
                  }
                  scale <1, 1, 0.5>
                  rotate <-0, 20, 10>
                  translate <0, 0, 0>
               }
               
               intersection {
                  sphere {
                     <0, 0, 0>, 0.41
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     box {
                        <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                        scale 1
                        rotate x*(-27.7)
                        translate y*(-0.42)
                     }
                  }
                  //*PMRawBegin
                  texture {
                     PeauGrise
                  }
                  //*PMRawEnd
               }
               scale <1, 0.8, 1>
               rotate <0, 0, 0>
               translate x*0.42
            }
            translate <0, 0.98, -0.3758>
         }
         //*PMRawBegin
         object {
            //*PMName Tete
            RTTete
            
            texture {
               PeauGrise
            }
         
         }
         
         object {
            //*PMName Bouche
            RTBouche
            
            texture {
               PeauGrise
            }
         }
         //*PMRawEnd
         
         sphere {
            //*PMName Truffe
            <0, 0, -3.48>, 0.4
            
            texture {
               NoirOeil
            }
            scale <0.6, 0.5, 1>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         union {
            //*PMName Dents
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*(-0.11)
            }
            
            box {
               <-0.1, -0.3, 0>, <0.1, 0, 0.05>
               scale 1
               rotate <0, 0, 0>
               translate x*0.11
            }
            translate <0, -0.67, -1.82>
            
            texture {
               BlancOeil
            }
         }
         scale 0.35
         rotate <-21.1, -20, -0>
         translate <0.00338903, 0.986796, 0.667792>
      }
      //*PMRawBegin
      object {
         //*PMName Corps
         RTCorps
         
         texture {
            PeauGrise
         }
      
      }
      
      object {
         //*PMName Queue
         RTQueue
         
         texture {
            PeauRose
         }
      }
      
      object {
         //*PMName Bras
         RTBras
         
         texture {
            PeauGrise
         }
      }
      //*PMRawEnd
      scale 1
      rotate y*90
      translate <1.67705, 2.85519, -0.376015>
   }
   
   union {
      //*PMName Cheveux
      
      // No prototype for lien d'objet
      sphere {
         <0, 0, 0>, 0.4
         scale <1, 0.3, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, 0>, <0, -0.1, 0>, 0.4
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 0.5
         scale <1, 0.1, 1>
         rotate <0, 0, 0>
         translate y*(-0.11)
      }
      
      difference {
         difference {
            //*PMName cheveux
            
            intersection {
               sphere {
                  <0, 0, 0>, 0.542
                  scale <1, 2.2, 1>
                  rotate <0, 0, 0>
                  translate y*(-0.56947)
               }
               
               box {
                  <-0.6, -0.56, -0.6>, <0.6, -0.11, 0.6>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
            }
            
            intersection {
               sphere {
                  <0, 0, 0>, 0.542
                  scale <1, 2.2, 1>
                  rotate <0, 0, 0>
                  translate y*(-0.56947)
               }
               
               box {
                  <-0.6, -0.56, -0.6>, <0.6, -0.11, 0.6>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               scale <0.94, 1, 0.94>
               translate y*(-0.06)
            }
         }
         
         box {
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 1.2, 1.2>
            rotate <-45, 82, 0>
            translate y*(-0.25)
         }
         
         box {
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 1.2, 1.2>
            rotate <-45, 98, 0>
            translate y*(-0.25)
         }
         
         box {
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 1.2, 1.2>
            rotate <-45, 116, 0>
            translate y*(-0.25)
         }
         
         box {
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 1.2, 1.2>
            rotate <-45, 66, 0>
            translate y*(-0.25)
         }
         
         cylinder {
            <-0.6, 0, 0>, <0.6, 0, 0>, 0.35
            scale <1, 1, 0.7>
            rotate x*(-15)
            translate <0, -0.5852, -0.40957>
         }
         
         box {
            //*PMName XL
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 2.4, 2.4>
            rotate <-45, -10, 0>
            translate y*(-0.56)
         }
         
         box {
            //*PMName X
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 2.1, 2.1>
            rotate <-45, -45, 0>
            translate y*(-0.56)
         }
         
         box {
            //*PMName M
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 1.9, 1.9>
            rotate <-45, -75, 0>
            translate y*(-0.56)
         }
         
         box {
            //*PMName M
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 1.9, 1.9>
            rotate <-45, -105, 0>
            translate y*(-0.56)
         }
         
         box {
            //*PMName X
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 2.1, 2.1>
            rotate <-45, -135, 0>
            translate y*(-0.56)
         }
         
         box {
            //*PMName XL
            <0, -0.05, -0.05>, <0.6, 0.05, 0.05>
            scale <1, 2.4, 2.4>
            rotate <-45, -170, 0>
            translate y*(-0.56)
         }
      }
      
      pigment {
         color rgb <0.545098, 0.341176, 0.345098>
      }
      scale 1
      rotate <0, 70, -10>
      translate <2.50866, 4.34288, -0.37119>
   }
   
   union {
      //*PMName Bureau
      
      object {
         //*PMName SDRam
         sdram
         scale 2
         rotate <90, 89.8, 90>
         translate y*1.31106
      }
      
      union {
         //*PMName lego1
         
         object {
            Brique
            
            pigment {
               color rgb <1, 0.439216, 0.219608>
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Brique
            
            pigment {
               color rgb <0.0392157, 0.470588, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate y*0.63
         }
         translate <-0.15, 0, 3.36>
      }
      translate z*(-2)
   }
   
   object {
      //*PMName lego3
      Brique
      
      pigment {
         color rgb <0.329412, 0.541176, 1>
      }
      scale 1
      rotate y*90
      translate <2.5712, 0, 0.0037084>
   }
   
   object {
      //*PMName Playmobil
      PlayMobil
      scale 1
      rotate y*19.9
      translate <3.03334, 1.46667, 1.96667>
   }
   scale 1
   rotate <0, -0, 0>
   translate <0, 0, 0>
}

// Tournevis
#declare RainureBois = cylinder {
   <1.4, 0.415, 0>, <4.1, 0.415, 0>, 0.09
   
   texture {
      pigment {
         color rgb <0.952941, 0.796078, 0.67451>
      }
      
      normal {
         dents
         turbulence <0.1, 0.1, 0.1>
         scale 0.01
         bump_size -1.2
      }
   }
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

#declare Tournevis = union {
   //*PMName Tournevis
   
   union {
      //*PMName Metal
      
      difference {
         union {
            sphere_sweep {
               cubic_spline,
               7,
               <4, 0, 0>,0.1
               <4, 0, 0>,0.1
               <3.08615, 0.136397, 0>,0.1
               <2.45992, 0.254921, 0.14835>,0.1
               <1.03001, 0.0882716, 0>,0.1
               <0, 0, 0>,0.1
               <0, 0, 0>,0.1
            }
            
            cone {
               <-0.3, 0, 0>, 0,
               <0, 0, 0>, 0.1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         cone {
            <0, 0, 0>, 0,
            <0.4, 0, 0>, 0.05
            scale <1, 1, 1.6>
            rotate z*22
            translate x*(-0.3)
         }
         
         cone {
            <0, 0, 0>, 0,
            <0.4, 0, 0>, 0.05
            scale <1, 1.6, 1>
            rotate y*22
            translate x*(-0.3)
         }
         
         cone {
            <0, 0, 0>, 0,
            <0.4, 0, 0>, 0.05
            scale <1, 1.6, 1>
            rotate y*(-22)
            translate x*(-0.3)
         }
         
         cone {
            <0, 0, 0>, 0,
            <0.4, 0, 0>, 0.05
            scale <1, 1, 1.6>
            rotate z*(-22)
            translate x*(-0.3)
         }
         
         box {
            <-0.31, -0.05, -0.05>, <-0.26, 0.05, 0.05>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         translate x*(-4)
         rotate y*(-5.7)
      }
      
      torus {
         0.11, 0.05
         scale 1
         rotate z*90
         translate <0, 0, 0>
      }
      
      cone {
         <0, 0, 0>, 0.16,
         <0.1, 0, 0>, 0.15
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      difference {
         cone {
            <0.1, 0, 0>, 0.15,
            <0.9, 0, 0>, 0.2
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0.2, 0>, <0, -0.2, 0>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate x*0.5
         }
      }
      
      cylinder {
         <0, 0.186, 0>, <0, -0.18, 0>, 0.048
         scale 1
         rotate <0, 0, 0>
         translate x*0.5
      }
      
      sphere {
         <0, 0, 0>, 0.048
         scale <1, 0.2, 1>
         rotate <0, 0, 0>
         translate <0.5, 0.186, 0>
      }
      
      sphere {
         <0, 0, 0>, 0.048
         scale <1, 0.2, 1>
         rotate <0, 0, 0>
         translate <0.5, -0.18, 0>
      }
      
      texture {
         pigment {
            color rgb <0.592157, 0.592157, 0.592157>
         }
         
         finish {
            metallic 2.5
            specular 2
            roughness 0.1
            
            reflection {
               rgb <0.819608, 0.819608, 0.819608>
               falloff 5
               metallic 1.5
            }
         }
      }
   }
   
   union {
      //*PMName Bois
      
      cylinder {
         //*PMName Premanche
         <0.8, 0, 0>, <0.92, 0, 0>, 0.18
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      intersection {
         //*PMName Premanche
         
         sphere {
            <0, 0, 0>, 0.3
         }
         
         box {
            <0, -0.31, -0.31>, <-0.3, 0.31, 0.31>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         translate x*1.1485
      }
      
      difference {
         //*PMName Manche
         
         union {
            //*PMRawBegin
            sor {
               4,
            <0, 1.0281>,
            <.4, .3>,
            <.3, .7>,
            <0, -0.8757>   
               sturm
               scale 1
               rotate z*90
               translate x*1.85
            }
            //*PMRawEnd
            
            cylinder {
               <0, 0, 0>, <2.4, 0, 0>, 0.4
               scale 1
               rotate <0, 0, 0>
               translate x*1.55
            }
            
            difference {
               sphere {
                  <0, 0, 0>, 0.4
                  scale <0.4, 1, 1>
                  rotate <0, 0, 0>
                  translate x*3.95
               }
               
               box {
                  <4.05, -0.41, -0.41>, <4.15, 0.41, 0.41>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
            }
         }
         
         object {
            RainureBois
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            RainureBois
            scale 1
            rotate x*60
            translate <0, 0, 0>
         }
         
         object {
            RainureBois
            scale 1
            rotate x*120
            translate <0, 0, 0>
         }
         
         object {
            RainureBois
            scale 1
            rotate x*180
            translate <0, 0, 0>
         }
         
         object {
            RainureBois
            scale 1
            rotate x*240
            translate <0, 0, 0>
         }
         
         object {
            RainureBois
            scale 1
            rotate x*300
            translate <0, 0, 0>
         }
      }
      
      texture {
         pigment {
            color rgb <0.85098, 0.168627, 0.180392>
         }
         
         finish {
            specular 0.2
            roughness 0.05
         }
         
         normal {
            dents
            turbulence <0, 0.1, 0.1>
            scale 0.05
            bump_size -0.3
         }
      }
   }
}

// Scne
global_settings {
   adc_bailout 0.0039216
   ambient_light rgb <0.352941, 0.309804, 0.282353>
   assumed_gamma 1.5
   max_trace_level 15
   noise_generator 2
   
   radiosity {
      brightness 1.1
      error_bound 1
      recursion_limit 5
   }
}

#declare Brume = fog {
   fog_type 2
   distance 50
    rgb <0.870588, 0.870588, 0.870588> 
   fog_offset 0
   fog_alt 50
   up <0, 1, 0>
}

object {
   //*PMName Transistor
   Transistor
   rotate <0, -10, 2>
   translate <-15.7762, 8.04384, 9.00596>
}

object {
   //*PMName Rat1
   Rat1
   scale 1
   rotate y*60
   translate <-2.0408, 5.5625, -10.066>
}

object {
   //*PMName Bidon
   Bidon
   scale 0.8
   rotate y*70.8
   translate <-7.39025, 1.60046, 11.7334>
}

object {
   //*PMName RatGrim
   RatGrim
   scale 1
   rotate <0, 0, 0>
   translate <-1.9799, -0.15, -0.28284>
}

object {
   //*PMName Bouteille
   Bouteille
   scale 2
   rotate <90, -89.2, -180>
   translate <-29, 2.0001, -25>
}

object {
   //*PMName Jeux
   Jeux
   scale 1
   rotate y*10
   translate <-9.28387, -0.05, -20.8916>
}

object {
   //*PMName Tournevis
   Tournevis
   scale 1.5
   rotate <0.8, 49.9, 3.7>
   translate <-9.68984, 0.476357, 2.05624>
}
//*PMRawBegin
#include "boitecouple.inc"
//*PMRawEnd
//*PMRawBegin
#include "boite2.inc"
//*PMRawEnd

object {
   //*PMName PaperBoard
   PaperBoard
   scale 3
   rotate y*55.7
   translate <-2.7152, 0, -4.2871>
}

union {
   //*PMName Prise
   
   union {
      //*PMName Plastique
      
      difference {
         union {
            lathe {
               cubic_spline
               5,
               <0, 2.1437>, <0.15, 1.6>, <0.83539, 0.96597>, <1, 0>, <0.81452, -0.62082>
               sturm
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, 0>, <0, 0.001, 0>, 1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         lathe {
            cubic_spline
            5,
            <-1.41833, 1.79196>, <0.0755145, 1.76503>, <0.906101, 0.9424>, <1, 0>, <0.81452, -0.62082>
            sturm
            scale <1, 1, 0.4>
            rotate <0, 0, 0>
            translate <0, 0, 0>
            inverse
         }
      }
      
      torus {
         0.2, 0.03
         sturm
         scale 1
         rotate <0, 0, 0>
         translate y*1.55
      }
      
      torus {
         0.2, 0.03
         sturm
         scale 1
         rotate <0, 0, 0>
         translate y*2.2
      }
      
      cylinder {
         <0, 1.55, 0>, <0, 2.2, 0>, 0.18
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      torus {
         1, 0.03
         sturm
         scale <1, 1, 0.4>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      difference {
         //*PMName Cordon
         
         sphere_sweep {
            b_spline,
            9,
            <-2.0848, 14.889, -1.8047>,0.18
            <-2.4909, 15.711, -1.6596>,0.18
            <-1.8886, 13.894, -2.1273>,0.18
            <-1.1534, 13.306, -2.1258>,0.18
            <-0.374132, 10.3258, -0.237723>,0.18
            <-1.40116, 6.47706, 0.216627>,0.18
            <0, 2.5, 0>,0.18
            <0, 2, 0>,0.18
            <0, 2, 0>,0.18
         }
         
         box {
            <-0.2, -0.2, -0.2>, <0.2, 0.2, 0.2>
            scale 1
            rotate <18, -0, 16>
            translate <-2.36157, 15.3662, -1.72824>
         }
      }
      
      union {
         //*PMName Fils
         
         sphere_sweep {
            b_spline,
            5,
            <0, 1.14, 0.49762>,0.07
            <0, 0.98445, 0.31879>,0.07
            <0, 0.5, 0.09>,0.07
            <0, 0, 0.08>,0.07
            <0, 0, 0.08>,0.07
            
            pigment {
               color rgb <0.839216, 0.168627, 0.180392>
            }
         }
         
         sphere_sweep {
            b_spline,
            5,
            <0, 1.14, -0.5>,0.07
            <0, 0.98445, -0.3>,0.07
            <0, 0.54786, -0.1953>,0.07
            <0, 0, -0.08>,0.07
            <0, 0, -0.08>,0.07
            
            pigment {
               color rgb <0.156863, 0.168627, 0.839216>
            }
         }
         
         union {
            //*PMName Cuivre
            
            cylinder {
               <0, 0.5, 0>, <0, 0, 0>, 0.05
               scale 1
               rotate <-36.1, -47.2, 29.3>
               translate <-0.0067807, 0.908846, -0.302438>
            }
            
            cylinder {
               <0, 0.5, 0>, <0, 0, 0>, 0.05
               scale 1
               rotate <29.2, -6, -0.9>
               translate <-0.00602674, 0.862323, 0.275538>
            }
            
            texture {
               pigment {
                  color rgb <0.776471, 0.588235, 0.552941>
               }
               
               finish {
                  metallic 1
                  specular 1
                  roughness 0.05
               }
            }
         }
         scale 1
         rotate <20.6, 0, 18.7>
         translate <-2.3, 15.1964, -1.78656>
      }
      
      texture {
         PlastPrise
      }
   }
   
   union {
      //*PMName Metal
      
      object {
         Fiche
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.5)
      }
      
      object {
         Fiche
         scale 1
         rotate <0, 0, 0>
         translate x*0.5
      }
      
      texture {
         MetalPrise
      }
   }
   rotate <-90, 90, -180>
   translate <-12.938, 0.41, -11.445>
}

object {
   //*PMName Tlvision
   Televison
   scale 3.5
   rotate y*76.5
   translate <20.5333, 0, 5.86667>
}

object {
   //*PMName Arbre
   Arbre
   scale 20
   translate <35.186, 0, 108.238>
}

object {
   //*PMName TasPneus
   TasPneu
   scale 2
   rotate <0, 0, 0>
   translate <-41.3677, 10.8341, 39.9194>
}

object {
   //*PMName Wash
   Washing
   scale 3
   rotate y*(-53)
   translate <-40.993, 0, 26.799>
}

object {
   //*PMName RatBoule
   RatBoule
   rotate <-180, -82.4, 180>
   translate <15.557, 0, 4.85385>
}

object {
   //*PMName RatBain
   RatBain
   scale 1
   rotate y*33.9
   translate <-21, 0, -19.426>
}

object {
   //*PMName Colle
   Colle
   rotate y*(-68)
   translate <-16.9026, 0, -9.65275>
}

object {
   //*PMName Pylones
   Pylones
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

object {
   //*PMName Gazon
   GazonMaudit
}

object {
   //*PMName Grillage
   Grillage
}

object {
   //*PMName Chaise
   Chaise
   scale 3.2
   rotate y*65.1
   translate <20.2493, 0, 22.8985>
}

union {
   //*PMName RatVioli
   
   union {
      //*PMName Moustaches
      
      object {
         RRMoustaches
         scale 1
         rotate z*(-2.6)
         translate <-0.42389, 0.15, -2.8691>
      }
      
      object {
         RRMoustaches
         scale 1
         rotate <0, 0, 0>
         translate <-0.42389, 0, -2.8691>
      }
      
      object {
         RRMoustaches
         scale 1
         rotate z*2.3
         translate <-0.42389, -0.15, -2.8691>
      }
      
      object {
         RRMoustaches
         scale 1
         rotate <-0, 180, 2.6>
         translate <0.42389, 0.15, -2.8691>
      }
      
      object {
         RRMoustaches
         scale 1
         rotate y*180
         translate <0.42389, 0, -2.8691>
      }
      
      object {
         RRMoustaches
         scale 1
         rotate <0, 180, -2.3>
         translate <0.42389, -0.15, -2.8691>
      }
      
      pigment {
         color rgbft <1, 1, 1, 0.2, 0.2>
      }
      translate <0, 0.2, 0.4>
   }
   
   union {
      //*PMName Yeux
      
      union {
         //*PMName Droit
         
         sphere {
            <0, 0, 0>, 0.4
            
            texture {
               BlancOeil
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, -0.7>, 0.15
            
            texture {
               NoirOeil
            }
            scale <1, 1, 0.5>
            rotate <-0, 0, 0>
            translate <0, 0, 0>
         }
         
         intersection {
            sphere {
               <0, 0, 0>, 0.41
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            union {
               box {
                  <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               box {
                  <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                  scale 1
                  rotate x*(-5)
                  translate y*(-0.42)
               }
            }
            //*PMRawBegin
            texture {
               PeauGrise
            }
            //*PMRawEnd
         }
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.42)
      }
      
      union {
         //*PMName Gauche
         
         sphere {
            <0, 0, 0>, 0.4
            
            texture {
               BlancOeil
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, -0.7>, 0.15
            
            texture {
               NoirOeil
            }
            scale <1, 1, 0.5>
            rotate <-0, 0, 0>
            translate <0, 0, 0>
         }
         
         intersection {
            sphere {
               <0, 0, 0>, 0.41
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            union {
               box {
                  <-0.42, -0.42, 0>, <0.42, 0.42, 0.42>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               box {
                  <-0.42, 0, 0>, <0.42, 0.84, 0.42>
                  scale 1
                  rotate x*(-5)
                  translate y*(-0.42)
               }
            }
            //*PMRawBegin
            texture {
               PeauGrise
            }
            //*PMRawEnd
         }
         scale 1
         rotate <0, 0, 0>
         translate x*0.42
      }
      translate <0, 0.98, -0.3758>
   }
   
   object {
      StdTete
      //*PMRawBegin
      texture {
         PeauGrise
      }
      //*PMRawEnd
   }
   
   object {
      StdOreilles
      //*PMRawBegin
      texture {
         PeauGrise
      }
      //*PMRawEnd
   }
   
   sphere {
      //*PMName Truffe
      <0, 0, -3.48>, 0.4
      
      texture {
         NoirOeil
      }
      scale <0.6, 0.5, 1>
      rotate x*5.1
      translate <0, -0.07, 0.38>
   }
   
   union {
      //*PMName Dents
      
      box {
         <-0.1, -0.3, 0>, <0.1, 0, 0.05>
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.11)
      }
      
      box {
         <-0.1, -0.3, 0>, <0.1, 0, 0.05>
         scale 1
         rotate <0, 0, 0>
         translate x*0.11
      }
      translate <0, -0.6, -1.4>
      
      texture {
         BlancOeil
      }
   }
   
   cone {
      <0, 0, 0>, 0.1,
      <0, -2, 0>, 0.2
      //*PMRawBegin
      uv_mapping texture {
         PeauGrise
      }
      //*PMRawEnd
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   scale 0.6
   rotate y*(-85)
   translate <-24.6894, 6.54107, -2.83786>
}

union {
   //*PMName Sol
   
   difference {
      //*PMName Plat
      
      box {
         //*PMName Sol
         <200, 0, 200>, <-50, -4, -50>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      height_field {
         //*PMName Faille
         png "/home/tom/RayTrace/Unplugged/textures/faille2.png"
         scale 3
         rotate y*(-82.5)
         translate <-1.5036, -2.6204, -6.2244>
      }
   }
   
   texture {
      pigment {
         bumps
         turbulence <1, 1, 1>
         scale 2
         
         pigment_map {
            [ 0 color rgb <0.486275, 0.305882, 0.286275>
            ]
            [ 0.5 color rgb <0.368627, 0.239216, 0.227451>
            ]
         }
      }
      
      normal {
         agate
         1
         agate_turb 0.5
         
         normal_map {
            [ 0 granite
            0.5
            scale <0.4, 1, 0.4>
            ]
            [ 0.3 granite
            0.2
            translate x*20
            ]
            [ 0.6 granite
            1.5
            turbulence <0.2, 0.2, 0.2>
            translate x*20
            ]
         }
      }
      
      finish {
         diffuse 0.5
      }
      scale <2, 1, 2>
   }
}

sky_sphere {
   pigment {
      granite
      turbulence <1, 1, 1>
      scale 800
      
      color_map {
         [ 0 color rgb <0.396078, 0.94902, 1>
         ]
         [ 0.1 color rgb <1, 1, 1>
         ]
      }
   }
}

sphere {
   <0, 0, 0>, 2000
   
   texture {
      normal {
         bumps
         2
         turbulence <1, 1, 1>
         scale 300
      }
      
      pigment {
         bumps
         turbulence <0.5, 0.5, 0.5>
         
         color_map {
            [ 0 color rgbft <0.41176, 0.41176, 0.41176, 0.2, 0.2>
            ]
            [ 0.9 color rgb <0, 0, 0>
            ]
         }
         scale 500
      }
   }
   scale <1, 0.3, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
   hollow
}

light_source {
   <-25, 240.25, -982.87>, rgb <0.627451, 0.619608, 0.529412>
   parallel
   area_light <10, 0, 0>, <0, 10, 0>, 4, 4
   adaptive 2
}

light_source {
   <-18.658, 4.5628, -31.826>, rgb <0.54902, 0.498039, 0.4>
   shadowless
   fade_distance 80
   fade_power 5
}

camera {
   perspective
   location <-18.955, 6.5, -32.224>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.5, 0, 0>
   up <0, 1, 0>
   look_at <4.1668, 0, 48.448>
}