/*
This is a point-contact transistor. 

Started: 2004.04.02

*/
#include "colors.inc"
#include "functions.inc"
#include "glass.inc"
#include "metals.inc" 
#include "golds.inc"
#include "woods.inc"

#declare sky_present=1;
#declare use_radiosity=0;
#declare use_focal_blur=1;
#declare many_lights=1;

global_settings {
  max_trace_level 30
  #if (use_radiosity=1)
	  radiosity {
 	   pretrace_start 0.08
 	   pretrace_end   0.04
 	   count 100
	
 	   nearest_count 20
 	   error_bound .2
 	   recursion_limit 1
	
 	   low_error_factor 0.5
 	   gray_threshold 0.4
 		 minimum_reuse 0.015
   	 brightness 1

   	 adc_bailout 0.01/2
  }
	#end
}

#if (sky_present=1)
sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0 rgb <216,218,239>/255 ]
      [ 0.5 rgb <0.6,0.6,0.8> ]
    }
    translate y*.5
  }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb .9
                   color rgb <0.85, 0.85, 0.85>]
          [0.1 0.5 color rgb <0.85, 0.85, 0.85>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
      rotate x*90
      translate x*-.5
    }
    translate <.5,.1,0>
}
#end


#if (many_lights=1)
light_source{
  <0,10,-10>
  color White
	spotlight
	radius 20
	falloff 30
	tightness 10
  area_light <1, 0, 0>, <0, 0, 1>, 2, 2
  adaptive 1
  jitter
	point_at <0,2,0>
}                        
light_source{
  <0,10,-10>
  color White 
	spotlight
	radius 20
	falloff 30
	tightness 10
  area_light <1, 0, 0>, <0, 0, 1>, 2, 2
  adaptive 1
  jitter
	point_at <0,2,0>
	rotate y*90
}                        
light_source{
  <0,10,-10>
  color White
	spotlight
	radius 20
	falloff 30
	tightness 10
  area_light <1, 0, 0>, <0, 0, 1>, 2, 2
  adaptive 1
  jitter
	point_at <0,2,0>
	rotate y*180
}                        
light_source{
  <0,10,-10>
  color White 
	spotlight
	radius 20
	falloff 30
	tightness 10
  area_light <1, 0, 0>, <0, 0, 1>, 2, 2
  adaptive 1
  jitter
	point_at <0,2,0>
	rotate y*270
}                        
#else
light_source{
	<0,20,0>
	color White
	spotlight
	radius 20
	falloff 30
	tightness 10
}

#end


#declare transistor=union{
  /*
   * This is the main plastic thing that things hang off of
   */
  merge{
    box{
      <-1,.4,-2>, <5.5,-.5,2>
    	pigment{rgbf <.9,.9,.9,.8>}
			normal{bumps .015 scale .1} 
			interior{ior 1.3}
    }
    difference{
      box{
        <.5,0,-.5>, <4,3,.5>  
      }
      box{
        <0,0,-1>, <5,1.7,1>
        translate <1,1,0>
      }                   
      box{
        <0,0,-1>, <5,2,1>
        rotate z*-45
        translate <3,3,0>
      }             
    
      box{
        <-1,-3,0>, <5,5,5>
        rotate y*45
        translate <3,0,.5>
      }
      box{
        <-1,-3,0>, <5,5,-5>
        rotate y*-45
        translate <3,0,-.5>
      }        
     
      box{
        <0,-1,-1>, <5,5,1>
        translate x*3.1
      }
    	pigment{rgbf <.9,.9,.9,.8>}
			normal{bumps .015 scale .1} 
			interior{ior 1.3}
    }
		difference{
			box{
				<1,0,-.5>, <5,-.0001,.5>
			}
      box{
        <-1,-3,0>, <5,5,5>
        rotate y*45
        translate <3,0,.5>
      }
      box{
        <-1,-3,0>, <5,5,-5>
        rotate y*-45
        translate <3,0,-.5>
      }        
      box{
        <0,-1,-1>, <5,5,1>
        translate x*3.1
      }
			translate y*2.7
    	pigment{rgbt <.9,.9,.9,.8>}
			normal{bumps .015 scale .1} 
			interior{ior 1.3}
		}
  }
  /*
   * Copper thing at the base of the main plastic base
   */
  union{
		union{
			isosurface{
				function{y-f_noise3d(x*7, y*7, z*7)*.02}
				contained_by {box {<0,0,-.51>, <2.02,.02,.51>}}
			}

    // -z curve
      difference{
        isosurface{
          function{
            max(
              sqrt(z*z + y*y) - .035,
              x-2.02
            )
            -f_noise3d(x*5, y*5, z*5)*.02
          }
          contained_by{box {0,2.02}}
        }
        cylinder{<-1,0,0>, <4,0,0>, .03}
				rotate x*-90
        translate <0,-.03,-.51>
      }

      isosurface{
        function{y+f_noise3d(x*7, y*7, z*7)*.02}
        contained_by {box {<0,0,0>, <2.02,-.02,-0.3>}}
				rotate x*-90
     	  translate <0,-.025,-.56>
      }


    // +z curve
			difference{
				isosurface{
  				function{
    				max(
      				sqrt(z*z + y*y) - .04,
      				x-2.02  
    				)
						-f_noise3d(x*5, y*5, z*5)*.02
  				}
  				contained_by{box {0,2.02}}
				}
				cylinder{<-1,0,0>, <4,0,0>, .03}
				translate <0,-.03,.51>
			}

      isosurface{
        function{y-f_noise3d(x*7, y*7, z*7)*.02}
        contained_by {box {<0,0,0>, <2.02,.02,0.3>}}
				rotate x*90
     	  translate <0,-.025,.56>
      }


			//pigment{P_Brass2}
			pigment{
				image_map{jpeg "copper-brushed.jpg"}
				rotate y*90
			}
			finish{
				ambient .2
				brilliance 4
				metallic	
				diffuse .4
				specular .7
				roughness 1/60
				reflection .1
			}
		}
    // Germanium substrate on top of copper plating
		difference{
	    box{
 	      <0,0,-.35>, <.4,.1,.35>
 	    }                                                      
			box{
				<0,-5,-5>, <5,5,5>
				rotate z*15
				translate x*.4
			}
			box{
				<0,-5,-5>, <5,5,5>
				rotate z*15
				rotate y*180
			}
			box{
				<0,-5,-5>, <5,5,5>
				rotate z*15
				rotate y*90
				translate <.2,0,-.35>
			}
			box{
				<0,-5,-5>, <5,5,5>
				rotate z*15
				rotate y*-90
				translate <.2,0,.35>
			}
 	    pigment{Gray15}
			finish{
				brilliance 4
				metallic
				reflection .1
			}
			normal{bumps 1 scale .1}
 	    translate <1,.02,0>
 		}   

    // Triangular plastic thing on top of the germanium substrate
    // Gold foil surrounding the outer part of the triangle
    #declare triangle_height=cos(radians(30))*.4;
    difference{
      merge{
        cylinder{
          <0,0,0>, <.06,0,0>, .05
        }              
        cylinder{
          <0,0,0>, <.06,0,0>, .05
          translate y*.4
          rotate x*30
        }               
          cylinder{
          <0,0,0>, <.06,0,0>, .05
          translate y*.4
          rotate x*-30
        }
        cylinder{
          <0,0,0>, <.06,0,0>, .05
          translate y*.1
        }           
      
        box{
          <0,0,-.05>, <.06,.4,.05>
          rotate x*30
        }    
        box{
          <0,0,-.05>, <.06,.4,.05>
          rotate x*-30
        }
      }
			union{
				cylinder{
					<0,0,0>, <.06,0,0>, .05
				}
				box{
					<0,0,-.05>, <.06,.4,.05>
					rotate x*30
				}
				box{
					<0,0,-.05>, <.06,.4,.05>
					rotate x*-30
				}
      	scale <1.5, .95, .95>
			}
			box{
				<-1,0,-.1>, <1,5,.1>
				translate y*.1
			}
			box{
				<-1,0,-.15>, <1,5,.15>
				translate y*.2
			}
			box{
				<-1,0,-.05>, <1,5,.05>
				translate y*.05
			}
			box{
				<-5,0,-5>, <5,5,5>
				translate y*.3
			}
      translate <1+.2,.02+.1+.05,0>
      texture{T_Gold_3C}
    }                  
                            
                        
    // This is the plastic triangle itself
    merge{
      cylinder{
        <0,0,0>, <.06,0,0>, .05
      }              
      cylinder{
        <0,0,0>, <.06,0,0>, .05
        translate y*.4
        rotate x*30
      }               
      cylinder{
        <0,0,0>, <.06,0,0>, .05
        translate y*.4
        rotate x*-30
      }
      cylinder{
        <0,0,0>, <.06,0,0>, .15
        translate y*.25
      }           
      
      box{
        <-0.00001,0,-.05>, <.06001,.4,.05>
        rotate x*30
      }    
      box{
        <0,0,-.05>, <.06,.4,.05>
        rotate x*-30
      }
      box{
        <-.0001,0,-.05>, <.0601,.4,.05>
        rotate x*90
        translate z*-.2
        translate y*triangle_height
      }                            
      scale <1.05, .95, .95>
      translate <1+.2,.02+.1+.05,0>
			pigment{rgbf <.8, .8, .8, .3>}
			interior{ior 1.5}
    }    
    
    //The metal cylinder holding onto the plastic triangle
    union{
      cylinder{
        <0,0,0>, <0,.15,0>, .08
      }
      cylinder{
        <0,0,0>, <0,.1,0>, .01
      	translate y*.15
      }                        
			// solder holding the bottom of wire to metal thing
			isosurface{
				function { f_sphere(x, y, z, .15)-f_noise3d(x, y,z)*.9}
        pigment{P_Silver2}
        finish{
          ambient .3
          brilliance 4
          diffuse .3
          metallic
          specular .7
          roughness 1/60
          reflection .1
        }
				normal{bumps 2 scale .2}
				scale .13
				translate <0,.15,-.02>
			}

			//Here's the wire. This'll be difficult
			cylinder{
				<0,0,0>, <0,.1,0>, .01
				translate y*(.15+.1)
			}
			difference{
				torus{
					.04 .01
					rotate x*90
				}
				box{
					<-5,-5,-5>, <5,0,5>
				}
				box{
					<-5,-5,-5>, <0,5,5>
				}
				translate <-.04, .15+.1+.1, 0>
			}
			cylinder{
				<0,0,0>, <0,.13,0>, .01
				rotate z*90
				translate <-.04, .15+.1+.1+.04,0>
			}
      difference{
        torus{
          .04 .01
          rotate x*90
        }
        box{
          <5,5,5>, <-5,0,-5>
        }
        box{
          <5,5,5>, <0,-5,-5>
        }
				translate y*.04
				rotate x*-45
				translate y*-.04
        translate <-.04-.13, .15+.1+.1+.04+.04, 0>
      }
			cylinder{
				<0,0,0>, <0,.1,0>, .01
				translate y*.04
				rotate x*-45
				translate y*-.04
				translate <-.17-.04, .39+.04, 0>
			}
      difference{
        torus{
          .04 .01
          rotate x*90
        }
        box{
          <-5,-5,-5>, <5,0,5>
        }
        box{
          <5,5,5>, <0,-5,-5>
        }
        translate y*(.04+.1)
        rotate x*-45
        translate y*-.04
        translate <-.04-.13, .15+.1+.1+.04+.04, 0>
      }
      cylinder{
        <0,0,0>, <0,.35,0>, .01
				rotate z*-90
        translate y*(.14+.04)
        rotate x*-45
        translate y*-.04
        translate <-.17, .39+.04, 0>
      }
      difference{
        torus{
          .04 .01
          rotate x*90
        }
        box{
          <-5,-5,-5>, <0,5,5>
        }
        box{
          <5,5,5>, <-5,0,-5>
        }
				translate y*.04
				rotate x*135
        translate y*(.18)
        rotate x*-45
        translate <-.17+.35, .15+.1+.1+.04, 0>
      }
      cylinder{
        <0,0,0>, <0,.05,0>, .01
        rotate x*135
				translate y*(.18)
				rotate x*-45
        translate <.18+.04, .15+.1+.1+.04, .04>
      }
			difference{
        torus{
          .04 .01
          rotate x*90
        }
        box{
          <-5,-5,-5>, <0,5,5>
        }
        box{
          <-5,-5,-5>, <5,0,5>
        }
				translate x*-.04
				rotate y*-45
				translate x*.04
        translate y*.04
        rotate x*135
        translate y*(.18)
        rotate x*-45
        translate <-.17+.35, .15+.1+.1+.04, .04>
      }
      cylinder{
        <0,0,0>, <0,.25,0>, .01
				rotate z*90
        translate x*-.04
        rotate y*-45
        translate x*.04
        translate y*.04
        rotate x*135
        translate y*(.18)
        rotate x*-45
        translate <-.17+.35, .15+.1+.1+.04, .04+.04>
      }
      difference{
        torus{
          .04 .01
          rotate x*90
        }
        box{
          <-5,-5,-5>, <5,0,5>
        }
        box{
          <-5,-5,-5>, <0,5,5>
        }
				translate y*.25
				rotate z*90
        translate x*-.04
        rotate y*-45
        translate x*.04
        translate y*.04
        rotate x*135
        translate y*(.18)
        rotate x*-45
        translate <-.17+.35, .15+.1+.1+.04, .04>
      }
      difference{
        torus{
          .12 .01
          rotate x*90
        }
        box{
          <5,5,5>, <-5,0,-5>
        }
        box{
          <5,5,5>, <0,-5,-5>
        }
				translate y*.12
				rotate x*-45
				translate y*-.12
        translate y*(.25+.16)
        rotate z*90
        translate x*-.04
        rotate y*-45
        translate x*.04
        translate y*.04
        rotate x*135
        translate y*(.18)
        rotate x*-45
        translate <-.17+.35, .15+.1+.1+.04, .04>
      }
      cylinder{
        <0,0,0>, <0,.25,0>, .01
        translate y*.12
        rotate x*-45
        translate y*-.12
        translate y*(.25+.16)
        rotate z*90
        translate x*-.04
        rotate y*-45
        translate x*.04
        translate y*.04
        rotate x*135
        translate y*(.18)
        rotate x*-45
        translate <-.17+.35, .15+.1+.1+.04, .04-.12>
      }
      translate <1+.2+.03,.45,0>
    }
		//The metal thing holding the wire that's holding the plastic
		//triangle, it's on the top
		cylinder{
			<0,0,0>, <0,.55,0>, .04
			translate <1.22,1.5,-.18>
		}
		//this is a cylinder surrounding the other cylinder as it 
		//goes through the plastic base. It simulates the diffraction
		//caused by drilling a hole in the plastic.
		cylinder{
			<0,0,0>, <0,.3,0>, .041
			pigment{White}
			translate <1.22,1.7,-.18>
		}
		cylinder{
			<0,0,0>, <0,0,.03>, .08
			translate <1.22, 1.85,-.51>
		}
		cylinder{
			<0,0,0>, <0,0,-.5+.18>, .05
			pigment{White}
			translate <1.22, 1.85, -.18>
		}

		//solder holding the top of the wire to the metal thing. 
		isosurface{
			function { f_sphere(x, y, z, .015)-f_noise3d(x*1.5, y*1.5, z*1.5)*.8 }
			scale .1
			normal{bumps 2 scale .1}
			texture{T_Silver_2B}
			scale y*.6
			translate <1.22,1.5,-.18>	
		}

		//More wiring, right side of triangle (emitter)
		union{
			difference{
				torus{
					.1 .005
					rotate x*90
				}
				box{
					<0,-5,-5>, <5,5,5>
				}
				box{
					<-5,0,-5>, <5,5,5>
				}
			}
      difference{
        torus{
          .1 .005
          rotate x*90
        }
        box{
          <-5,-5,-5>, <0,5,5>
        }
        box{
          <-5,-5,-5>, <5,0,5>
        }
				translate x*-.1
				rotate y*30
				translate x*-.1
      }
      difference{
        torus{
          .2 .005
          rotate x*90
        }
        box{
          <5,5,5>, <-5,0,-5>
        }
        box{
          <5,5,5>, <0,-5,-5>
        }
				translate x*-.1
        rotate y*30
				translate <-.1,.3,0>
      }
      difference{
        torus{
          .15 .005
          rotate x*90
        }
        box{
          <-5,-5,-5>, <5,0,5>
        }
        box{
          <-5,-5,-5>, <0,5,5>
        }
        translate <-.1-.35,0,0>
        rotate y*30
        translate <-.1,.3,0>
      }
      difference{
        torus{
          .15 .005
          rotate x*90
        }
        box{
          <5,5,5>, <0,-5,-5>
        }
				scale x*.8
				translate y*-.15
				rotate x*10
				translate y*.15
        translate <-.1-.35,0,0>
        rotate y*30
        translate <-.1,.3,0>
      }
      difference{
        torus{
          .15 .005
          rotate x*90
        }
        box{
          <-5,-5,-5>, <0,5,5>
        }
				scale x*.88
        translate y*.15
        rotate x*-10
        translate y*-.15
        translate <-.1-.35,0,-.25*sin(radians(10))>
        rotate y*30
        translate <-.1,.3,0>
      }
      difference{
        torus{
          .15 .005
          rotate x*90
        }
        box{
          <5,5,5>, <0,-5,-5>
        }
				scale x*.8
        translate y*.15
        rotate x*10
        translate y*-.15
        translate <-.1-.35,0,-.85*sin(radians(10))>
        rotate y*30
        translate <-.1,.3,0>
      }
      difference{
        torus{
          .1 .005
          rotate x*90
        }
        box{
          <-5,-5,-5>, <0,5,5>
        }
				scale x*.65
        translate y*.1
        rotate x*-10
        translate y*-.1
				translate y*-.05
        translate <-.1-.35,0,-.85*sin(radians(10))>
        rotate y*30
        translate <-.1,.3,0>
      }
      difference{
        torus{
          .1 .005
          rotate x*90
        }
        box{
          <-5,-5,-5>, <5,0,5>
        }
        box{
          <5,5,5>, <0,-5,-5>
        }
				translate <0,-.15+.1*cos(radians(10)),0>
        translate <-.1-.35,0,-1.05*sin(radians(10))>
        rotate y*30
        translate <-.1,.3,0>
      }
     difference{
        torus{
          .5 .005
          rotate x*90
        }
        box{
          <5,5,5>, <-5,0,-5>
        }
				scale y*.6
				translate x*-.5
				rotate y*65
        translate <0,-.15+.1*cos(radians(10)),0>
        translate <-.55,0,-1.05*sin(radians(10))>
        rotate y*30
        translate <-.1,.3,0>
      }
     difference{
        torus{
          .15 .005
          rotate x*90
        }
        box{
          <-5,-5,-5>, <0,5,5>
        }
        box{
          <-5,-5,-5>, <5,0,5>
        }
        translate x*-1.15
        rotate y*65
        translate <0,-.15+.1*cos(radians(10)),0>
        translate <-.55,0,-1.05*sin(radians(10))>
        rotate y*30
        translate <-.1,.3,0>
      }

			// Solder holding the wire to the right gold contact (emitter)
			isosurface{
     		function { f_sphere(x, y, z, .015)-f_noise3d(x, y,z)}
     		scale .05
     		normal{bumps 2 scale .1}
				pigment{P_Silver2}
				finish{
					ambient .3
					brilliance 4
					diffuse .3
					metallic
					specular .7
					roughness 1/60
					reflection .1
				}
				translate y*-.1
				rotate z*-28
			}

			texture{T_Silver_2B}
			rotate y*-85
      translate <1.24,.5,-.16>
		}

		//This is the collector side of the wiring
		union{
      difference{
        torus{
          .1 .005
          rotate x*90
        }
        box{
          <0,-5,-5>, <5,5,5>
        }
        box{
          <-5,0,-5>, <5,5,5>
        }
      }
      difference{
        torus{
          .4 .005
          rotate x*90
        }
        box{
          <0,5,5>, <-5,-5,-5>
        }
        box{
          <5,0,5>, <-5,-5,-5>
        }
				translate x*-.4
				rotate y*-20
				translate <-.1,0,0>
      }
      difference{
        torus{
          .2 .005
          rotate x*90
        }
        box{
          <0,-5,-5>, <5,5,5>
        }
				scale x*.7
				translate y*.2
				rotate x*-15
				translate x*-.4
				rotate y*-20
        translate <-.1,.4,0>
      }
      difference{
        torus{
          .2 .005
          rotate x*90
        }
        box{
          <0,5,5>, <-5,-5,-5>
        }
				scale x*.85
				translate y*-.2
				rotate x*30
				translate y*.4
        rotate x*-15
        translate x*-.4
        rotate y*-20
        translate <-.1,.4,0>
      }
      difference{
        torus{
          .15 .005
          rotate x*90
        }
        box{
          <0,-5,-5>, <5,5,5>
        }
        box{
          <-5,0,-5>, <5,5,5>
        }
				translate y*-.05
        translate y*-.2
        rotate x*30
        translate y*.4
        rotate x*-15
        translate x*-.4
        rotate y*-20
        translate <-.1,.4,0>
      }
      difference{
        torus{
          .35 .005
          rotate x*90
        }
        box{
          <5,0,5>, <-5,-5,-5>
        }
				scale y*.7
				translate x*-.35
				rotate y*-60
				translate x*-.15
        translate y*-.05
        translate y*-.2
        rotate x*30
        translate y*.4
        rotate x*-15
        translate x*-.4
        rotate y*-20
        translate <-.1,.4,0>
      }
      difference{ 
        torus{
          .25 .005
          rotate x*90
        }
        box{
          <-5,0,-5>, <5,5,5>
        }
        box{
          <0,5,5>, <-5,-5,-5>
        }
				scale y*1.5
				translate x*-.25
				rotate y*-30
        translate x*-.7
        rotate y*-60
        translate x*-.15
        translate y*-.05
        translate y*-.2
        rotate x*30
        translate y*.4
        rotate x*-15
        translate x*-.4
        rotate y*-20
        translate <-.1,.4,0>
      }


			// Solder holding the wire to the right gold contact (collector)
			isosurface{
     		function { f_sphere(x, y, z, .015)-f_noise3d(x, y,z)}
     		scale .05
     		normal{bumps 2 scale .1}
     		texture{T_Silver_2B}
				scale z*.7
				translate y*-.1
				rotate z*-28
			}
			texture{T_Silver_2B}
			rotate y*85
      translate <1.24,.5,.16>

		}

    
    translate <1, 1, 0> 
  }                   

	//metal contact for both wires
	union{
		cylinder{
			<0,0,-.5>, <0,0,.5>, .1
			pigment{White}
		}
		cylinder{
			<0,0,0>, <0,0,-.02>, .2
			translate z*-.5
		}
		difference{
			sphere{
				<0,0,0>, .1
			}
			box{
				<5,5,5>, <-5,-5,0>	
			}
			scale z*2
			translate z*(-.5-.02)
		}
		cylinder{
			<0,0,0>, <0,0,.02>, .2
			translate z*.5
		}
    difference{
      sphere{
        <0,0,0>, .1
      }
      box{
        <-5,-5,-5>, <5,5,0>
      }
      scale z*2
      translate z*(.5+.02)
    }
	
		//solder holding the wires to the metal contacts
    isosurface{
      function { f_sphere(x, y, z, .015)-f_noise3d(x, y,z)}
      scale .05
      normal{bumps 2 scale .1}
      texture{T_Silver_2B}
      scale 1.5
			scale x*.6
      translate <.1,0,-.52-.1>
			rotate z*20
    }
    isosurface{
      function { f_sphere(x, y, z, .015)-f_noise3d(x, y,z)}
      scale .05
      normal{bumps 2 scale .1}
      texture{T_Silver_2B}
      scale 1.5
			scale x*.6
      translate <.1,0,.52+.1>
			rotate z*20
    }

		translate <.8,1.85,0>
		texture{T_Brass_2B}
		normal{bumps 1 scale .3}
	}
	
	// Wire supplying electricity to copper plate 
	union{
		difference{
			torus{
				.25, .005
				rotate z*90
			}
			box{
				<-5,-5,-5>, <5,5,0>
			}	
			box{
				<-5,-5,-5>, <5,0,5>
			}	
		}	
		difference{
			torus{
				1, .005
				rotate z*90
			}
			box{
				<-5,-5,-5>, <5,5,0>
				rotate x*30
			}	
			box{
				<5,5,5>, <-5,0,-5>
			}	
			translate z*-1
			rotate y*90
			translate z*.25
			scale y*.3
		}	

		//where the other end of wire inserts at the end of the base
		cylinder{
			<0,0,0>, <0,.05,0>, .2
			translate <-1.2,-.35,.4>
			pigment{P_Brass2}
		}
		difference{
	    isosurface{
 	     function { f_sphere(x, y, z, .18)-f_noise3d(x*3, y*3,z*3)*.1}
 	     contained_by{box{-2,2}}
 	     texture{T_Silver_2B}
 	   	}

			box{
				<-5,0,-5>, <5,-5,5>
			}
			scale <.8, .7, .8>
 	    translate <-1.2,-.3,.4>
		}
		
		translate <1.25,.75,.51>
		texture{T_Silver_2B}
	}	

  texture{T_Brass_2B}
	normal{bumps 1 scale .3}
}

/*********************************************************
	The actual scene
*********************************************************/
background{
	White
}

camera{
  location <-.4,2,-3.6>
	#if (use_focal_blur=1)
		focal_point <0,2,0>
		aperture 0.1
		blur_samples 40
	#end
  look_at  <-.4,1.8,0>
}                 

//************************Room

union{
	light_source{
		<0,8,0>
		White
	}
  difference{
   box{
     <-50,-50,-50>, <50,50,50>
   }
   box{
     <-49.5, -10, -49.5>, <49.5, 49.5, 49.5>
   }
   //opening in wall for window
   box{
     <0,0,-3>, <10,8,3>
     translate <49,0,40>
   }
   pigment{rgb <185,209,237>/255}
    //  finish{ambient .3}
  }
  //Window pain
  box{
    <0,0,-3>, <-.1,8,3>
    translate <50,0,40>
    pigment{rgbf <.9,.9,.9,.75>}
  }
  //stuff around window pain
  box{
    <0,0,-3.5>, <-.25,.5,3.5>
    texture{T_Wood2}
    translate <49.5,8,40>
  }
  box{
    <0,0,-3.5>, <-.5,-.5,3.5>
    texture{T_Wood2}
    translate <49.5,0,40>
  }
  box{
    <0,-.5,0>, <-.25,8.5,-.5>
    texture{T_Wood2}
    translate <49.5,0,43>
  }
  box{
    <0,-.5,0>, <-.25,8.5,.5>
    texture{T_Wood2}
    translate <49.5,0,37>
  }

  //painting on the wall
  //Wooden Frame
  union{
    difference{
      box{
        <-4, 0, 0>, <4, 8, 1>
      }
      box{
        <-3.8, .2, 1>, <3.8, 7.8, -5>
      }
      texture{T_Wood2}
    }
    //frame window
    box{
      <-3.8,.2,0>, <3.8,7.8,.05>
      pigment{rgbf <.9,.9,.9,.8>}
    }
    //actual painting
    box{
      <-3.8,.2,0>, <3.8,7.8,.05>
      pigment{
        image_map{
          png "Bardeen_Brattain_Shockley.png"
        }
        scale 7.5
        translate x*3.75
      }
      translate z*.1
    }
    translate <40,0,49>
  }
  translate <-35,0,-15>
}

//******************Table
box{
	<-5,-.5,-5>, <5,-1,5>
	texture{T_Wood1 scale 2 rotate y*45}
	//pigment{White}
}

//**Chair back, not a real chair
union{
  union{
    difference{
      cylinder{
        <0,0,0>, <.2,0,0>, 1.5
      }                      
      cylinder{
        <-1,0,0>, <1,0,0>, 1.4
        scale y*.7
      }          
      box{
        <-5,0,-5>, <5,-5,5>
      }
    }     
    box{
      <0,0,0>, <.2,-2,-.1>
      translate z*-1.4
    }
    box{
      <0,0,0>, <.2,-2,.1>
      translate z*1.4
    }         
    translate y*-1.5
    rotate z*7
    translate y*1.5
  }                
  cylinder{
    <0,0,0>, <0,-5,0>, .05
    translate y*1.5
  }    
  cylinder{
    <0,0,0>, <0,-5,0>, .05
    translate <0,1,-.5>
  }    
  cylinder{
    <0,0,0>, <0,-5,0>, .05
    translate <0,1,.5>
  }    
  cylinder{
    <0,0,0>, <0,-5,0>, .05
    translate <0,.8,1>
  }    
  cylinder{
    <0,0,0>, <0,-5,0>, .05
    translate <0,.8,-1>
  }    
  
  texture{T_Wood1}
  rotate y*45
  translate <-7,-1,10>
}

//******************Transistor on the table
object{
  transistor
  translate x*-2.5
  rotate y*35
}

