//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 1.0;
global_settings {
	max_trace_level 30
	adc_bailout 1/255
}
default { texture { pigment { color rgb < 1, 0, 0 > } finish { ambient 0.3 } }   }
//global_settings{ noise_generator 3 } 

#declare Quality = 100;

#include "CameraLightsFog.inc"
#include "Terrain.inc"
#include "SugarCube.inc"
#include "Sand.inc"

#include "TextureTest.inc"
#include "Sky.inc"
#include "Ant.mcr"
#include "Plant.mcr"
#include "Rock.inc"


object { Ground }
object { BackGround }
//object { SugarCube }
object { Rock }
object { AntGeneral }

//#declare SugarCube = box {
//	<-1,-1,-1> <1,1,1>
//	scale <1.0, .90, 1.0>
//	texture { 
//		pigment { color rgb < 1.15, 1.15, 1.15 > } 
//		normal { crackle 1 scale 0.125 }
//		finish{ specular 1 }
//	} 
//}
#include "SugarPile.inc"

#local Normal = <0,0,0>;
#local SmallRockLoc = trace( Ground, <-1.0,20,-10.1>, -y, Normal );
object { RockBase 
	scale 0.15 rotate <0,239,3>
	texture { RockTex translate 7 }
	translate y*-0.05
	translate SmallRockLoc
}
#local Normal = <0,0,0>;
#local SmallRockLoc = trace( Ground, <-0.6,20,-10.5>, -y, Normal );
object { RockBase 
	translate x*-1
	scale 0.085 rotate <-10,-36,-8>
	texture { RockTex translate 65 }
	translate y*-0.05
	translate SmallRockLoc
}
	

#local Normal = <0,0,0>;
#local SugarX = 2.86;
#local SugarZ = -5.4;
#local SugarLocation = trace( Ground, < SugarX,30,SugarZ >, -y, Normal );
object { SugarCube translate y*0.901 scale 0.25 rotate <11.5,50,-10> translate SugarLocation }

#include "Plants.inc"
#include "Ants.inc"



