#include "TextureTest.inc"

#declare myPrism = 
prism {
	linear_spline
	linear_sweep
	-1.0, 	//Base height
	1.0, 	//Top height
	6,
	<1.00000, 0.00000>,
	<0.30902, 0.95106>,
	<-0.80902, 0.58779>,
	<-0.80902, -0.58779>,
	<0.30902, -0.95106>,
	<1.00000, -0.00000>
	sturm
	scale .75
}

//new sand grain, from V
#macro Pebble( Seed )
	intersection{
	#local PebbleRand = seed( Seed );
	
	#local scale_factor = .1 + (rand(PebbleRand)*.02 - .01);
	
	#local random = rand(PebbleRand);
	
	#if(random < 0.15)
		#local  scale_factor = scale_factor + .1 + (rand(PebbleRand) * .1);
	
	#end
	
	object{ myPrism scale scale_factor }
	//box{ //loc, loc+<.015, .015, .015>
	// <-.008, -.008, -.008>, <.008, .008, .008>
	object{ 	
		myPrism scale .1125
		rotate <rand(PebbleRand)*180, rand(PebbleRand)*180, rand(PebbleRand)*180>
	}
	rotate <rand(PebbleRand)*180, rand(PebbleRand)*180, rand(PebbleRand)*180>
	
	scale <1.5+1.2*rand(PebbleRand),1.65+0.4*rand(PebbleRand),1.65+0.4*rand(PebbleRand)>
	rotate <rand(PebbleRand)*180, rand(PebbleRand)*180, rand(PebbleRand)*180>
	translate <0, scale_factor / 2, 0>
}
#end


#if( Quality > 9 )
	#local i = -8;
	
	#declare SandRandom = seed( 831315  );
	#while (i < 9.5)
		#local j = -11.5;
		#while(j < 7)
			#local norm = <0, 0, 0>;
			#local top = <i, 30, j>;
			#local down = <0, -1, 0>;
			#local loc = trace(Ground, top, down, norm);
			
			#if (vlength(norm) != 0)
				#local loc = loc + <norm.x*1.5, 10, norm.z*1.5>;
				#local loc = loc + <rand(SandRandom)*.3, 0, rand(SandRandom)*.3>;
				#local loc = trace(Ground, loc, down,norm);			
				
				#if(vlength(norm) != 0)
						object{Pebble(rand(SandRandom)*10000)
						scale .06
						translate loc
						texture{ SandTex translate<((rand(SandRandom)*100000)-50000),((rand(SandRandom)*100000)-50000),((rand(SandRandom)*100000)-50000) > }  
					}
				#end
			#end
			
			#if(j > -7)
				#local j = j + .065;
			#else
				#local j = j + .05;
			#end
	
		#end
		#debug concat( "\nAt i = ",  str (i, 2.0, 2.0), "\n" )
		#local i = i + .065;
	#end
#end
