
#declare BrownTex = texture {
	pigment {
		bozo
		color_map {
			[ 0.7 rgb <0.126696, 0.021103, 0.012131> ]
			[ 0.8 rgb <0.271489, 0.247990, 0.213825> ]
		}
		turbulence 0.3//2.5
		scale 0.65*0.5
	}
//	normal {
//		granite 1
//		bump_size 0.9
//		turbulence 0.1
//		scale <0.1,0.1,0.1>
//	}
	finish {
		specular 0.05 roughness 0.2
	}
}

#declare ClearPigment = pigment {
	color rgbf 1
}

#declare LightBrownPigment= pigment {
	bozo
	color_map {
		[ 0.6 rgb <0.656107, 0.614038, 0.356298> ]
		[ 0.9 rgb <0.433112, 0.443442, 0.303868> ]
	}
	turbulence 0.8
	scale 2.5
}

#declare GreyPigment = pigment {
	bozo
	color_map {
		[ 0.6 rgb <0.278202, 0.280537, 0.213916> ]
		[ 0.9 rgb <0.190051, 0.137865, 0.083818> ]
	}
	turbulence 0.8
	scale <3,1.5,2.75>
	rotate y*30
	translate 50
}

#declare SandBaseTex = texture {
	pigment {
		bozo 
		pigment_map {
			[ 0.5 LightBrownPigment scale 1/3 ]
			[ 0.75 GreyPigment scale 1/3]
		}
		turbulence 2.5
		scale 3
	}
	normal {
		granite 1
		bump_size 0.75
		turbulence 1.5
		scale <0.3,0.15,0.15>
	}	
	finish {
		specular 0.175 roughness 0.075
	}
}

#declare PinkTex = texture {
	pigment {
		bozo
		color_map {
			[ 0.5 rgbf <1,1,1,1> ]
			[ 0.65 rgbt <0.773754, 0.515999, 0.414176, 0.5> ]
			[ 1 rgbf <0.773754, 0.515999, 0.414176, 0.33> ]
		}
		turbulence 0.1
		scale <40,30,20>
	}
	normal {
		granite 1
		bump_size 0.75
		turbulence 0.2
		scale <0.3,0.15,0.15>
	}
	finish {
		specular 0.175 roughness 0.075
	}
}

#declare SandTex = texture {
	SandBaseTex
}
texture {
	PinkTex
}

#declare GraveyardPigment = pigment {
	bozo
	color_map {
		[ 0.6 rgbf <0.457008, 0.386633, 0.348043, 0.75> ]
		[ 0.95 rgb <0.328954, 0.343893, 0.146380> ]
	}
	turbulence 1.6
	scale <2.25,1.5,0.55>
	rotate y*-40
	translate <10,5,9>
}

#declare GraveYardTex = texture {
	pigment {
		bozo
		pigment_map {
			[ 0.4 ClearPigment ]
			[ 0.7 GraveyardPigment scale 0.2 ]
		}
	}
//	normal {
//		granite 1
//		bump_size 0.9
//		turbulence 0.1
//		scale <0.1,0.1,0.1>
//	}
	finish {
		specular 0.05 roughness 0.2
	}
	scale <5,5,6>
	rotate y*20
	translate 5
}

#declare CrackleNorm = normal {
		crackle 0.95
		bump_size 2.95
		turbulence 0.45
		scale <0.24,0.16,0.16>*0.5
}

#declare GraniteNorm = normal {
	agate 1
	bump_size 0.8
	turbulence 0.24
	scale <1.25,0.16,0.17>*0.075
	rotate y*-35
}

#declare GrassyTex = texture {
	pigment {
		bozo
		color_map {
			[ 0.35 rgbf <1,1,1,1> ]
			[ 0.5 rgbf <0.572183, 0.588235, 0.253696, 0.8> ]
			//[ 0.997 rgbf <0.572183, 0.588235, 0.253696, 0.85> ]
			[ 1 rgbf <0.375967, 0.642527, 0.079103, 0.5> ]
		}
		turbulence 0.1
		scale <4.25,3.5,3.65>
	}
	normal {
		average 0.5
		normal_map {
			[ 0.33 CrackleNorm ]
			[ 0.66 GraniteNorm ]
		}
	}
	finish {
		specular 0.1 roughness 0.2
	}
	rotate y*40
}


#declare TestTexture = texture {
	BrownTex
}
texture { GraveYardTex }
texture { GrassyTex }

