// TREE_NAME=Oak;
//ROOT
#declare ROOTS=5;
#declare ROOT_RANDOM=0.0887;
#declare FIRST_ROOT_AT_TRUNK=80;
#declare ROOT_LENGTH=200;
#declare ROOT_THICKNESS_CHANGE=.35;
#declare ROOT_STRENGTH=.8;
#declare ROOT_BEND=50;
#declare ROOT_BEND_FREQUENCY=1;
#declare ROOT_CURVE=15;
#declare ROOT_CURVE_FREQUENCY=5;
#declare ROOT_SNAG=5;
#declare ROOT_SNAG_FREQUENCY=20;
#declare ROOT_ANGLE=40;
#declare ROOT_ALIGNMENT=0.25;
#declare ROOT_TURN_SWITCH=1.0;
//TRUNK
#declare TRUNK_RADIUS=30;
#declare TRUNK_STRENGTH=.5;
#declare TRUNK_BEND_X=0;
#declare TRUNK_BEND_X_FREQUENCY=1;
#declare TRUNK_BEND_Z=0;
#declare TRUNK_BEND_Z_FREQUENCY=1;
#declare TRUNK_CURVE=0;
#declare TRUNK_CURVE_FREQUENCY=3;
#declare TRUNK_SNAG=0;
#declare TRUNK_SNAG_FREQUENCY=10;
#declare TRUNK_SPIRAL=0;
#declare TRUNK_TAPER=0.6;
//BRANCH
#declare BRANCHES=14;
#declare BRANCH_RANDOM=0.8058;
#declare FIRST_BRANCH_AT_TRUNK=200.0;
#declare BRANCH_AREA_AT_TRUNK=500.0;
#declare BRANCH_THICKNESS_CHANGE=0.4;
#declare BRANCH_STRENGTH=.8;
#declare BRANCH_BEND=15;
#declare BRANCH_BEND_FREQUENCY=3.0;
#declare HORIZONTAL_BRANCH_BEND_SWITCH=1.0;
#declare EXTRA_NOISE_SWITCH=1.0;
#declare BRANCH_CURVE=10.0;
#declare BRANCH_CURVE_FREQUENCY=5.0;
#declare HORIZONTAL_BRANCH_CURVE_SWITCH=1.0;
#declare BRANCH_LONGITUDINAL_CURVE=0.4;
#declare BRANCH_SNAG=5.0;
#declare BRANCH_SNAG_FREQUENCY=2;
#declare BRANCH_REDUCTION=0.8;
#declare BRANCH_TAPER=0.7;
#declare BRANCH_END_EQUALIZER=0.3;
#declare BRANCH_TIP=0.0;
#declare BRANCH_TURN_SWITCH=1.0;
#declare BRANCH_ALTERNATE_SWITCH=1.0;
#declare BRANCH_SPIRAL=15;
#declare BRANCH_ANGLE=30;
#declare BRANCH_ANGLE_SCOPE=20;
#declare BRANCH_ALIGNMENT=0.9;
#declare STRAIGHTEN_TOWARDS_TOP=0.4;
//TWIG
#declare TWIGS=7*BRANCHES;
#declare TWIG_RANDOM=0.1517;
#declare FIRST_TWIG_AT_BRANCH=40;
#declare TWIG_AREA_AT_BRANCH=400;
#declare TWIG_THICKNESS_CHANGE=0.8;
#declare TWIG_STRENGTH=1.2;
#declare HORIZONTAL_TWIG_ANGLE=30;
#declare HORIZONTAL_TWIG_ANGLE_SCOPE=10;
#declare HORIZONTAL_TWIG_ALIGNMENT=0.7;
#declare VERTICAL_TWIG_ANGLE=30;
#declare VERTICAL_TWIG_ANGLE_SCOPE=20;
#declare VERTICAL_TWIG_ALIGNMENT=0.2;
#declare TWIG_TURN_SWITCH=1.0;
#declare TWIG_ALTERNATE_SWITCH=1.0;
#declare TWIG_CURVE_ADJUSTMENT=1.1;
#declare TWIG_CURVE_FREQUENCY_ADJUSTMENT=0.75;
#declare TWIG_TAPER=1;
#declare TWIG_TIP=0;
#declare STRAIGHTEN_TOWARDS_BRANCH_END=.8;
#declare TWIG_RAMIFICATION_ORDER=2;
#declare LAST_RAMIFICATION_NUMBER=4;
#declare TWIG_RAMIFICATION_THICKNESS_CHANGE=0.8;
#declare TWIG_RAMIFICATION_CURVE_ADJUSTMENT=1;
#declare RAMI_CURVE_FREQUENCY_ADJUSTMENT=1;
#declare TWIG_RAMIFICATION_STRENGTH=1;
//BUNCH
#declare BUNCHES=5*TWIGS;
#declare FIRST_BUNCH_AT_TWIG=40;
#declare BUNCH_AREA_AT_TWIG=400;
#declare BUNCH_MAJOR_RADIUS=200;
#declare BUNCH_MINOR_RADIUS=100;
#declare HORIZONTAL_BUNCH_FUNNEL=0;
#declare VERTICAL_BUNCH_FUNNEL=0;
#declare ROTATION_BUNCH_FUNNEL=80;
#declare HORIZONTAL_BUNCH_ANGLE=40;
#declare VERTICAL_BUNCH_ANGLE=-35;
#declare HORIZONTAL_BUNCH_ANGLE_SCOPE=0;
#declare VERTICAL_BUNCH_ANGLE_SCOPE=0;
#declare BUNCH_TURN_SWITCH=1.0;
#declare BUNCH_TURN_SHIFT=0;
#declare BUNCH_ALTERNATE_SWITCH=0.0;
#declare HORIZONTAL_BUNCH_ALIGNMENT=0.85;
#declare VERTICAL_BUNCH_ALIGNMENT=0.85;
#declare BUNCH_TAPER_OFF_AT_TWIG=0;
#declare BUNCH_TAPER_OFF_AT_BRANCH=.4;
#declare BUNCH_TAPER_OFF_AT_TREE=.2;
#declare BUNCH_ARC_AT_TWIG=<0, 0, 0>;
#declare BUNCH_ARC_AT_BRANCH=<0, 0, 0>;
#declare BUNCH_DEFORM=<1, 1, 1>;
//BARK
#declare SUNKEN_TRUNK_COLOR=<0.25882, 0.27058, 0.21176>;
#declare RAISED_TRUNK_COLOR=<0.56862, 0.49411, 0.39607>;
#declare FOLIAGE_COLOR_AT_BRANCH_END=0;
#declare TRUNK_SCAR_WIDTH=6;
#declare TRUNK_SCAR_HEIGHT=24;
#declare HORIZONTAL_SCAR_SHRINKING=0.3;
#declare VERTICAL_SCAR_SHRINKING=1.5;
#declare SCAR_DEPTH=-1;
#declare BARK_PROFILE=0.95;
#declare BRANCH_BARK_PROFILE_CHANGE=0.5;
#declare BRANCH_BARK_PROFILE_TAPER_OFF=1;
#declare ROOT_BARK_PROFILE_CHANGE=0.9;
#declare PALM_TRUNK=0;
//FOLIAGE
#include "TOMLEAF.inc"
#declare Mesh4a = mesh {
	triangle{<0.65, 0.0, 0.5>, <0.49999997, 0.0, 0.15>, <0.0, 0.0, 2.9802322E-8>}
	triangle{<0.49999997, 0.0, 0.15>, <0.0, 0.0, 2.9802322E-8>, <0.49999997, 0.0, -0.14999998>}
	triangle{<0.49999997, 0.0, 0.15>, <0.49999997, 0.0, -0.14999998>, <1.0, 0.0, 0.0>}
	triangle{<0.0, 0.0, 2.9802322E-8>, <0.49999997, 0.0, -0.14999998>, <0.65, 0.0, -0.5>}
};
#declare LEAF_TYPE=Mesh4a;
#declare LEAVES=700*BUNCHES;
#declare LEAF_LENGTH=18;
#declare LEAF_BREADTH=8;
#declare LEAF_HEIGHT=.5;
#declare MAX_LEAF_TILT=20;
#declare MAX_LEAF_TURN=30;
#declare LEAF_INCLINATION=45;
#declare LEAF_INCLINATION_SCOPE=45;
#declare BOTTOM_COLOR_1=<0.22, .33, .18, 0, 0>;
#declare BOTTOM_COLOR_2=<0.23, .41, .15, 0, 0>;
#declare TOP_COLOR_1=<0.44, .66, .35, 0, 0>;
#declare TOP_COLOR_2=<0.42, .66, .40, 0, 0>;
#declare COLOR_TURB=0.5;
#declare TRANSITION_BOTTOM_TOP=.35;
#declare TRANSITION_TURB=.2;
#declare FOLIAGE_GLOSS=0;
#declare FOLIAGE_FILTER=0;
#declare FOLIAGE_TRANSPARENCY=0;
//BLOSSOM
#declare BLOSSOM="NONE";
#declare BLOSSOMS=0*BUNCHES;
#declare BLOSSOM_LENGTH=15;
#declare BLOSSOM_WIDTH=30;
#declare BLOSSOM_INCLINATION=0;
#declare BLOSSOM_COLOR=<1, 1, 1>;
