#declare grassf = function {y/10}
#declare grass1 = pigment {
    function {grassf(x,y,z)}
    color_map {
        [0.00 color <1,1,0.5>]
        [0.1 color <0.55,0.65,0.1>]
        [1.00 color <0.25,0.5,0.1>]
    }
}
    
#declare grass2 = pigment {
    agate
    turbulence 0.5
    color_map {
        [0.00 color <0.75,0.75,0.3>]
        [0.5 color <0.25,0.5,0.1>]
        [1.00 color <0.25,0.5,0.1>]
    }
    scale <0.2,50,0.2>*0.1
}

#declare grassTex = texture {
    pigment {
        average
        pigment_map {
            [1 grass1]
            [0.5 grass2]
        }
    }
    finish {
        ambient 0.3
        diffuse 0.6
        specular 0.1
        roughness 0.05
    }
    normal {
        bumps 1.0
        scale <0.2,50,0.2>*0.001
    }
}

#declare lawnTex = texture {
    pigment {
        bozo
        turbulence 1
        frequency 10
        color_map {
            [0.00 color rgb <0.35,0.15,0.1>]
            [0.20 color rgb <0.35,0.15,0.1>*1.3]
            [0.40 color rgb <0.35,0.15,0.1>*1.3]
            [0.60 color rgb <0.35,0.15,0.1>/2]
            [0.80 color rgb <0.35,0.15,0.1>/2]
            [1.00 color rgb <0.35,0.15,0.1>]     
        }
    }
    finish {
       ambient 0.3
       diffuse 0.6
       specular 0.1
       roughness 0.05
    }
    normal {
        bumps 3.0
        scale 0.2
    }
}

#declare loopI = 1;
#while (loopI <= 10000)
    #declare loopI = loopI + 1;
    #declare loopJ = 1;
    #declare blade = union {
    #while (loopJ <= 5)
        #declare loopJ = loopJ + 1;
        #declare tempnum = rand(R1);
        #declare tempnum2 = 30*rand(R2);
        #declare tempnum3 = rand(R3);
        cone {
            <0,0,0>,0.125,<0,4*(tempnum+1),0>,0
            scale <1,1,0.1>
            #declare tempnum4 = rand(R1)*500;
            #declare tempnum5 = rand(R1)*500;
            translate <tempnum4,0,tempnum5>
            texture {grassTex}
            translate <-tempnum4,0,-tempnum5>
            rotate <tempnum2,0,0>
            translate <0,0,tempnum3>
            rotate <0,rand(R1)*360,0>
        }
    #end
    }
    object {blade 
        translate <-250*(1-pow(rand(R3),2))-20,0,0> 
        rotate <0,70*rand(R3)-35,0>
    }
#end

box {<-500,0,-500>,<500,-1,500> texture {lawnTex}}
