#ifndef DISJOINTSETS_H
#define DISJOINTSETS_H

#include <vector>
#include <map>


template <class T>
class DisjointSets
{
public:
   int nsets();
   void insert_elem( T x );
   void union_elem( T x1, T x2 );
   int find_elem( T x ) { return find_set(set_of(x)); }
   int size() { return h.size(); }
private:
   int set_of( T x ) { return h[x]; }
   void union_set( int root1, int root2 );
   int find_set( int r );
   std::vector<int> s;
   std::map<T,int> h;
};


template <class T>
inline int DisjointSets<T>::nsets()
{
   int retval = 0;
   for (std::vector<int>::iterator i=s.begin(); i!=s.end(); ++i)
      if (*i==-1)
	 retval++;
   return retval;
}


template <class T>
inline void DisjointSets<T>::insert_elem( T x )
{
   h[x] = s.size();
   s.push_back(-1);
}


template <class T>
inline void DisjointSets<T>::union_elem( T x1, T x2 )
{
   if (h[x1]==h[x2])
      return;

   int root1 = h[x1];
   int root2 = h[x2];

   while (s[root1]>=0)
      root1 = s[root1];

   while (s[root2]>=0)
      root2 = s[root2];

   if (s[root2]<s[root1])	// root2 is deeper
   {
      s[root1] = root2;
      h[x1] = h[x2];
   }
   else				// root1 is deeper
   {
      s[root2] = root1;
      if (s[root1]==s[root2])
	 s[root1]--;
      s[root2] = root1;
      h[x2] = h[x1];
   }
}


template <class T>
inline void DisjointSets<T>::union_set( int root1, int root2 )
{
   s[root2] = root1;
}


template <class T>
inline int DisjointSets<T>::find_set( int x )
{
   if (s[x]<0)
      return x;
   else
      return s[x] = find_set(s[x]);
}

#endif
