from array import *
from random import *
from math import *


class Tree:
    def __init__( self, name, incfiles, billboards, w, h ):
        self.name = name
        self.incfiles = incfiles
        self.billboards = billboards
        self.width = w
        self.height = h


camera_x = 5.0
camera_y = 5.0
zscale = 5.0
hfield_x = 0.0
hfield_y = 0.0
hfield_width = 128.0
hfield_height = 128.0
real_threshold = 0.0

pixel_width = 0
pixel_height = 0
pixels = None


trees = [ #Tree("Alder",[],["X:\\alder1.png","X:\\alder2.png"],5.0,6.0),
          #Tree("Birch",[],
          #     ["X:\\birch1.png","X:\\birch2.png","X:\\birch3.png"],6.0,8.0),
          #Tree("Axelia",[],["axelia1.png","axelia2.png"],2.0,8.0),
          Tree("Wildbush",[],["wildbush1.png","wildbush2.png","wildbush3.png","wildbush4.png"],0.3,0.3),
          Tree("Winebush",[],["winebush1.png","winebush2.png"],0.1,0.1),
          ]


def get_tree( name ):
    global trees
    for tree in trees:
        if tree.name==name:
            return tree
    raise "No such tree",name


def read_tga( tgafile ):
    f = open(tgafile,"rb")
    f.seek(12,0)
    w = array("H",f.read(2))[0]
    h = array("H",f.read(2))[0]
    f.seek(2,1)
    pixels = array("L",f.read())
    f.close()
    heights = array("H")
    for p in pixels:
        heights.append( (((p&0x00FF0000)>>8)+((p&0x0000FF00)>>8)))
    return w,h,heights



def get_z( x, y ):
    hx = int((x-hfield_x)*float(pixel_width)/hfield_width)
    hy = pixel_height-int((y-hfield_y)*float(pixel_height)/hfield_height)
    hz = pixels[hy*pixel_width+hx]
    z = float(hz)*zscale/65536.0
    return z


def write_tree( x, y, tree ):
    if ((x-camera_x)**2+(y-camera_y)**2 < real_threshold**2 and
        len(tree.incfiles)):
        variant = randint(0,len(tree.incfiles)-1)
        print "object { %s%d"%(tree.name,variant)
        print "  rotate <0,%g,0>"%(uniform(0.0,360.0))
    else:
        variant = randint(0,len(tree.billboards)-1)
        print "object { %sBillboard%d"%(tree.name,variant)
        #print "  rotate <0,%g,0>"%(180.0-360.0*atan2(x-camera_x,y-camera_y)/(2.0*pi))
        print "  rotate <0,45,0>"
        print "  translate <%g,%g,%g>"%(x,get_z(x,y),y)
    print "}"


def arborate_circle( xc, yc, rmax, trees ):
    for treename,num in trees:
        tree = get_tree(treename)
        for _ in range(num):
            #r = randint(0,rmax)
            r = min(max(0.0,normalvariate(rmax/2.0,rmax/4.5)),rmax)
            a = uniform(0.0,2.0*pi)
            x = xc+r*cos(a)
            y = yc+r*sin(a)
            write_tree(x,y,tree)


def arborate_line( x1, y1, x2, y2, treename, num ):
    xi = (x2-x1)/float(num)
    yi = (y2-y1)/float(num)
    x = x1
    y = y1
    tree = get_tree(treename)
    for _ in range(num):
        write_tree(x,y,tree)
        x += xi
        y += yi



# write billboard tree definitions

for tree in trees:
    for incfile in tree.incfiles:
        print "#include \"%s\""%incfile
    for variant in xrange(len(tree.billboards)):
        pngfile = tree.billboards[variant]
        print """#declare %sBillboard%d = object {
        box {
          <-0.5,0.0,0.0>, <0.5,1.0,1.0>
          photons { pass_through }
          scale <%g,%g,0.000001>
          //rotate <90,0,0>
          texture
          {
             pigment {
               image_map { 
               png "%s" 
                 interpolate 2
               }
               translate <-0.5,0,0>
             }
             scale <%g,%g,0.1>
             //rotate <90,0,0>
          }
        }
        }"""%(tree.name,variant,tree.width,tree.height,pngfile,tree.width,tree.height)

pixel_width,pixel_height,pixels = read_tga("output.tga")


arborate_circle(20.0,20.0,19.0,[("Wildbush",1000)])
arborate_circle(30.0,30.0,25.0,[("Winebush",700)])
arborate_circle(10.0,10.0,9.5,[("Wildbush",300)])

#arborate_circle(400.0,600.0,300.0,[("Birch",1000),("Wildbush",6000)])
#arborate_circle(700.0,350.0,200.0,[("Axelia",200),("Wildbush",1000)])
#arborate_circle(285.0,212.0,60.0,[("Wildbush",160)])
#arborate_line(330.0,210.0,360.0,250.0,"Winebush",20)
#arborate_line(335.0,210.0,365.0,250.0,"Winebush",20)
#arborate_line(340.0,210.0,370.0,250.0,"Winebush",20)
#arborate_line(345.0,210.0,375.0,250.0,"Winebush",20)

##arborate_circle(0.0,0.0,90.0,[("Test",4000)])
